/*!
 * Atlas Maps 1.0.2
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

const EACH_ITEM_REACTIVE = 1;
const EACH_INDEX_REACTIVE = 1 << 1;
/** See EachBlock interface metadata.is_controlled for an explanation what this is */
const EACH_IS_CONTROLLED = 1 << 2;
const EACH_IS_ANIMATED = 1 << 3;
const EACH_ITEM_IMMUTABLE = 1 << 4;

const PROPS_IS_IMMUTABLE = 1;
const PROPS_IS_RUNES = 1 << 1;
const PROPS_IS_UPDATED = 1 << 2;
const PROPS_IS_BINDABLE = 1 << 3;
const PROPS_IS_LAZY_INITIAL = 1 << 4;

const TEMPLATE_FRAGMENT = 1;
const TEMPLATE_USE_IMPORT_NODE = 1 << 1;

const HYDRATION_START = "[";
/** used to indicate that an `{:else}...` block was rendered */
const HYDRATION_START_ELSE = "[!";
const HYDRATION_END = "]";
const HYDRATION_ERROR = {};

const UNINITIALIZED = Symbol();

// Dev-time component properties
const FILENAME = Symbol("filename");

const NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";

const ATTACHMENT_KEY = "@attach";

const DEV = true;

// Store the references to globals in case someone tries to monkey patch these, causing the below
// to de-opt (this occurs often when using popular extensions).
var is_array = Array.isArray;
var index_of = Array.prototype.indexOf;
var array_from = Array.from;
var define_property = Object.defineProperty;
var get_descriptor = Object.getOwnPropertyDescriptor;
var get_descriptors = Object.getOwnPropertyDescriptors;
var object_prototype = Object.prototype;
var array_prototype = Array.prototype;
var get_prototype_of = Object.getPrototypeOf;
var is_extensible = Object.isExtensible;

/**
 * @param {any} thing
 * @returns {thing is Function}
 */
function is_function(thing) {
  return typeof thing === "function";
}

const noop$4 = () => {};

// Adapted from https://github.com/then/is-promise/blob/master/index.js
// Distributed under MIT License https://github.com/then/is-promise/blob/master/LICENSE

/**
 * @template [T=any]
 * @param {any} value
 * @returns {value is PromiseLike<T>}
 */
function is_promise(value) {
  return typeof value?.then === "function";
}

/** @param {Function} fn */
function run(fn) {
  return fn();
}

/** @param {Array<() => void>} arr */
function run_all(arr) {
  for (var i = 0; i < arr.length; i++) {
    arr[i]();
  }
}

/**
 * TODO replace with Promise.withResolvers once supported widely enough
 * @template T
 */
function deferred() {
  /** @type {(value: T) => void} */
  var resolve;

  /** @type {(reason: any) => void} */
  var reject;

  /** @type {Promise<T>} */
  var promise = new Promise((res, rej) => {
    resolve = res;
    reject = rej;
  });

  // @ts-expect-error
  return { promise, resolve, reject };
}

/**
 * When encountering a situation like `let [a, b, c] = $derived(blah())`,
 * we need to stash an intermediate value that `a`, `b`, and `c` derive
 * from, in case it's an iterable
 * @template T
 * @param {ArrayLike<T> | Iterable<T>} value
 * @param {number} [n]
 * @returns {Array<T>}
 */
function to_array(value, n) {
  // return arrays unchanged
  if (Array.isArray(value)) {
    return value;
  }

  // if value is not iterable, or `n` is unspecified (indicates a rest
  // element, which means we're not concerned about unbounded iterables)
  // convert to an array with `Array.from`
  if (!(Symbol.iterator in value)) {
    return Array.from(value);
  }

  // otherwise, populate an array with `n` values

  /** @type {T[]} */
  const array = [];

  for (const element of value) {
    array.push(element);
    if (array.length === n) break;
  }

  return array;
}

const DERIVED = 1 << 1;
const EFFECT = 1 << 2;
const RENDER_EFFECT = 1 << 3;
const BLOCK_EFFECT = 1 << 4;
const BRANCH_EFFECT = 1 << 5;
const ROOT_EFFECT = 1 << 6;
const BOUNDARY_EFFECT = 1 << 7;
const UNOWNED = 1 << 8;
const DISCONNECTED = 1 << 9;
const CLEAN = 1 << 10;
const DIRTY = 1 << 11;
const MAYBE_DIRTY = 1 << 12;
const INERT = 1 << 13;
const DESTROYED = 1 << 14;
const EFFECT_RAN = 1 << 15;
/** 'Transparent' effects do not create a transition boundary */
const EFFECT_TRANSPARENT = 1 << 16;
const INSPECT_EFFECT = 1 << 17;
const HEAD_EFFECT = 1 << 18;
const EFFECT_PRESERVED = 1 << 19;
const USER_EFFECT = 1 << 20;

// Flags used for async
const REACTION_IS_UPDATING = 1 << 21;
const ASYNC = 1 << 22;

const ERROR_VALUE = 1 << 23;

const STATE_SYMBOL = Symbol("$state");
const LEGACY_PROPS = Symbol("legacy props");
const LOADING_ATTR_SYMBOL = Symbol("");
const PROXY_PATH_SYMBOL = Symbol("proxy path");

/** allow users to ignore aborted signal errors if `reason.name === 'StaleReactionError` */
const STALE_REACTION = new (class StaleReactionError extends Error {
  name = "StaleReactionError";
  message =
    "The reaction that called `getAbortSignal()` was re-run or destroyed";
})();

const ELEMENT_NODE = 1;
const TEXT_NODE = 3;
const COMMENT_NODE = 8;
const DOCUMENT_FRAGMENT_NODE = 11;

/* This file is generated by scripts/process-messages/index.js. Do not edit! */

/**
 * Cannot await outside a `<svelte:boundary>` with a `pending` snippet
 * @returns {never}
 */
function await_outside_boundary() {
  {
    const error = new Error(
      `await_outside_boundary\nCannot await outside a \`<svelte:boundary>\` with a \`pending\` snippet\nhttps://svelte.dev/e/await_outside_boundary`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * A snippet function was passed invalid arguments. Snippets should only be instantiated via `{@render ...}`
 * @returns {never}
 */
function invalid_snippet_arguments() {
  {
    const error = new Error(
      `invalid_snippet_arguments\nA snippet function was passed invalid arguments. Snippets should only be instantiated via \`{@render ...}\`\nhttps://svelte.dev/e/invalid_snippet_arguments`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * `%name%(...)` can only be used during component initialisation
 * @param {string} name
 * @returns {never}
 */
function lifecycle_outside_component(name) {
  {
    const error = new Error(
      `lifecycle_outside_component\n\`${name}(...)\` can only be used during component initialisation\nhttps://svelte.dev/e/lifecycle_outside_component`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Attempted to render a snippet without a `{@render}` block. This would cause the snippet code to be stringified instead of its content being rendered to the DOM. To fix this, change `{snippet}` to `{@render snippet()}`.
 * @returns {never}
 */
function snippet_without_render_tag() {
  {
    const error = new Error(
      `snippet_without_render_tag\nAttempted to render a snippet without a \`{@render}\` block. This would cause the snippet code to be stringified instead of its content being rendered to the DOM. To fix this, change \`{snippet}\` to \`{@render snippet()}\`.\nhttps://svelte.dev/e/snippet_without_render_tag`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/* This file is generated by scripts/process-messages/index.js. Do not edit! */

/**
 * Cannot create a `$derived(...)` with an `await` expression outside of an effect tree
 * @returns {never}
 */
function async_derived_orphan() {
  {
    const error = new Error(
      `async_derived_orphan\nCannot create a \`$derived(...)\` with an \`await\` expression outside of an effect tree\nhttps://svelte.dev/e/async_derived_orphan`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Calling `%method%` on a component instance (of %component%) is no longer valid in Svelte 5
 * @param {string} method
 * @param {string} component
 * @returns {never}
 */
function component_api_changed(method, component) {
  {
    const error = new Error(
      `component_api_changed\nCalling \`${method}\` on a component instance (of ${component}) is no longer valid in Svelte 5\nhttps://svelte.dev/e/component_api_changed`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Attempted to instantiate %component% with `new %name%`, which is no longer valid in Svelte 5. If this component is not under your control, set the `compatibility.componentApi` compiler option to `4` to keep it working.
 * @param {string} component
 * @param {string} name
 * @returns {never}
 */
function component_api_invalid_new(component, name) {
  {
    const error = new Error(
      `component_api_invalid_new\nAttempted to instantiate ${component} with \`new ${name}\`, which is no longer valid in Svelte 5. If this component is not under your control, set the \`compatibility.componentApi\` compiler option to \`4\` to keep it working.\nhttps://svelte.dev/e/component_api_invalid_new`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * A derived value cannot reference itself recursively
 * @returns {never}
 */
function derived_references_self() {
  {
    const error = new Error(
      `derived_references_self\nA derived value cannot reference itself recursively\nhttps://svelte.dev/e/derived_references_self`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * `%rune%` cannot be used inside an effect cleanup function
 * @param {string} rune
 * @returns {never}
 */
function effect_in_teardown(rune) {
  {
    const error = new Error(
      `effect_in_teardown\n\`${rune}\` cannot be used inside an effect cleanup function\nhttps://svelte.dev/e/effect_in_teardown`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Effect cannot be created inside a `$derived` value that was not itself created inside an effect
 * @returns {never}
 */
function effect_in_unowned_derived() {
  {
    const error = new Error(
      `effect_in_unowned_derived\nEffect cannot be created inside a \`$derived\` value that was not itself created inside an effect\nhttps://svelte.dev/e/effect_in_unowned_derived`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * `%rune%` can only be used inside an effect (e.g. during component initialisation)
 * @param {string} rune
 * @returns {never}
 */
function effect_orphan(rune) {
  {
    const error = new Error(
      `effect_orphan\n\`${rune}\` can only be used inside an effect (e.g. during component initialisation)\nhttps://svelte.dev/e/effect_orphan`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Maximum update depth exceeded. This typically indicates that an effect reads and writes the same piece of state
 * @returns {never}
 */
function effect_update_depth_exceeded() {
  {
    const error = new Error(
      `effect_update_depth_exceeded\nMaximum update depth exceeded. This typically indicates that an effect reads and writes the same piece of state\nhttps://svelte.dev/e/effect_update_depth_exceeded`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Failed to hydrate the application
 * @returns {never}
 */
function hydration_failed() {
  {
    const error = new Error(
      `hydration_failed\nFailed to hydrate the application\nhttps://svelte.dev/e/hydration_failed`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Could not `{@render}` snippet due to the expression being `null` or `undefined`. Consider using optional chaining `{@render snippet?.()}`
 * @returns {never}
 */
function invalid_snippet() {
  {
    const error = new Error(
      `invalid_snippet\nCould not \`{@render}\` snippet due to the expression being \`null\` or \`undefined\`. Consider using optional chaining \`{@render snippet?.()}\`\nhttps://svelte.dev/e/invalid_snippet`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Cannot do `bind:%key%={undefined}` when `%key%` has a fallback value
 * @param {string} key
 * @returns {never}
 */
function props_invalid_value(key) {
  {
    const error = new Error(
      `props_invalid_value\nCannot do \`bind:${key}={undefined}\` when \`${key}\` has a fallback value\nhttps://svelte.dev/e/props_invalid_value`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Rest element properties of `$props()` such as `%property%` are readonly
 * @param {string} property
 * @returns {never}
 */
function props_rest_readonly(property) {
  {
    const error = new Error(
      `props_rest_readonly\nRest element properties of \`$props()\` such as \`${property}\` are readonly\nhttps://svelte.dev/e/props_rest_readonly`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * The `%rune%` rune is only available inside `.svelte` and `.svelte.js/ts` files
 * @param {string} rune
 * @returns {never}
 */
function rune_outside_svelte(rune) {
  {
    const error = new Error(
      `rune_outside_svelte\nThe \`${rune}\` rune is only available inside \`.svelte\` and \`.svelte.js/ts\` files\nhttps://svelte.dev/e/rune_outside_svelte`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Property descriptors defined on `$state` objects must contain `value` and always be `enumerable`, `configurable` and `writable`.
 * @returns {never}
 */
function state_descriptors_fixed() {
  {
    const error = new Error(
      `state_descriptors_fixed\nProperty descriptors defined on \`$state\` objects must contain \`value\` and always be \`enumerable\`, \`configurable\` and \`writable\`.\nhttps://svelte.dev/e/state_descriptors_fixed`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Cannot set prototype of `$state` object
 * @returns {never}
 */
function state_prototype_fixed() {
  {
    const error = new Error(
      `state_prototype_fixed\nCannot set prototype of \`$state\` object\nhttps://svelte.dev/e/state_prototype_fixed`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/**
 * Updating state inside `$derived(...)`, `$inspect(...)` or a template expression is forbidden. If the value should not be reactive, declare it without `$state`
 * @returns {never}
 */
function state_unsafe_mutation() {
  {
    const error = new Error(
      `state_unsafe_mutation\nUpdating state inside \`$derived(...)\`, \`$inspect(...)\` or a template expression is forbidden. If the value should not be reactive, declare it without \`$state\`\nhttps://svelte.dev/e/state_unsafe_mutation`,
    );

    error.name = "Svelte error";

    throw error;
  }
}

/* This file is generated by scripts/process-messages/index.js. Do not edit! */

var bold = "font-weight: bold";
var normal = "font-weight: normal";

/**
 * Assignment to `%property%` property (%location%) will evaluate to the right-hand side, not the value of `%property%` following the assignment. This may result in unexpected behaviour.
 * @param {string} property
 * @param {string} location
 */
function assignment_value_stale(property, location) {
  {
    console.warn(
      `%c[svelte] assignment_value_stale\n%cAssignment to \`${property}\` property (${location}) will evaluate to the right-hand side, not the value of \`${property}\` following the assignment. This may result in unexpected behaviour.\nhttps://svelte.dev/e/assignment_value_stale`,
      bold,
      normal,
    );
  }
}

/**
 * Detected reactivity loss when reading `%name%`. This happens when state is read in an async function after an earlier `await`
 * @param {string} name
 */
function await_reactivity_loss(name) {
  {
    console.warn(
      `%c[svelte] await_reactivity_loss\n%cDetected reactivity loss when reading \`${name}\`. This happens when state is read in an async function after an earlier \`await\`\nhttps://svelte.dev/e/await_reactivity_loss`,
      bold,
      normal,
    );
  }
}

/**
 * `%binding%` (%location%) is binding to a non-reactive property
 * @param {string} binding
 * @param {string | undefined | null} [location]
 */
function binding_property_non_reactive(binding, location) {
  {
    console.warn(
      `%c[svelte] binding_property_non_reactive\n%c${
        location
          ? `\`${binding}\` (${location}) is binding to a non-reactive property`
          : `\`${binding}\` is binding to a non-reactive property`
      }\nhttps://svelte.dev/e/binding_property_non_reactive`,
      bold,
      normal,
    );
  }
}

/**
 * %handler% should be a function. Did you mean to %suggestion%?
 * @param {string} handler
 * @param {string} suggestion
 */
function event_handler_invalid(handler, suggestion) {
  {
    console.warn(
      `%c[svelte] event_handler_invalid\n%c${handler} should be a function. Did you mean to ${suggestion}?\nhttps://svelte.dev/e/event_handler_invalid`,
      bold,
      normal,
    );
  }
}

/**
 * The `%attribute%` attribute on `%html%` changed its value between server and client renders. The client value, `%value%`, will be ignored in favour of the server value
 * @param {string} attribute
 * @param {string} html
 * @param {string} value
 */
function hydration_attribute_changed(attribute, html, value) {
  {
    console.warn(
      `%c[svelte] hydration_attribute_changed\n%cThe \`${attribute}\` attribute on \`${html}\` changed its value between server and client renders. The client value, \`${value}\`, will be ignored in favour of the server value\nhttps://svelte.dev/e/hydration_attribute_changed`,
      bold,
      normal,
    );
  }
}

/**
 * Hydration failed because the initial UI does not match what was rendered on the server. The error occurred near %location%
 * @param {string | undefined | null} [location]
 */
function hydration_mismatch(location) {
  {
    console.warn(
      `%c[svelte] hydration_mismatch\n%c${"Hydration failed because the initial UI does not match what was rendered on the server"}\nhttps://svelte.dev/e/hydration_mismatch`,
      bold,
      normal,
    );
  }
}

/**
 * %parent% passed property `%prop%` to %child% with `bind:`, but its parent component %owner% did not declare `%prop%` as a binding. Consider creating a binding between %owner% and %parent% (e.g. `bind:%prop%={...}` instead of `%prop%={...}`)
 * @param {string} parent
 * @param {string} prop
 * @param {string} child
 * @param {string} owner
 */
function ownership_invalid_binding(parent, prop, child, owner) {
  {
    console.warn(
      `%c[svelte] ownership_invalid_binding\n%c${parent} passed property \`${prop}\` to ${child} with \`bind:\`, but its parent component ${owner} did not declare \`${prop}\` as a binding. Consider creating a binding between ${owner} and ${parent} (e.g. \`bind:${prop}={...}\` instead of \`${prop}={...}\`)\nhttps://svelte.dev/e/ownership_invalid_binding`,
      bold,
      normal,
    );
  }
}

/**
 * Mutating unbound props (`%name%`, at %location%) is strongly discouraged. Consider using `bind:%prop%={...}` in %parent% (or using a callback) instead
 * @param {string} name
 * @param {string} location
 * @param {string} prop
 * @param {string} parent
 */
function ownership_invalid_mutation(name, location, prop, parent) {
  {
    console.warn(
      `%c[svelte] ownership_invalid_mutation\n%cMutating unbound props (\`${name}\`, at ${location}) is strongly discouraged. Consider using \`bind:${prop}={...}\` in ${parent} (or using a callback) instead\nhttps://svelte.dev/e/ownership_invalid_mutation`,
      bold,
      normal,
    );
  }
}

/**
 * The `value` property of a `<select multiple>` element should be an array, but it received a non-array value. The selection will be kept as is.
 */
function select_multiple_invalid_value() {
  {
    console.warn(
      `%c[svelte] select_multiple_invalid_value\n%cThe \`value\` property of a \`<select multiple>\` element should be an array, but it received a non-array value. The selection will be kept as is.\nhttps://svelte.dev/e/select_multiple_invalid_value`,
      bold,
      normal,
    );
  }
}

/**
 * Reactive `$state(...)` proxies and the values they proxy have different identities. Because of this, comparisons with `%operator%` will produce unexpected results
 * @param {string} operator
 */
function state_proxy_equality_mismatch(operator) {
  {
    console.warn(
      `%c[svelte] state_proxy_equality_mismatch\n%cReactive \`$state(...)\` proxies and the values they proxy have different identities. Because of this, comparisons with \`${operator}\` will produce unexpected results\nhttps://svelte.dev/e/state_proxy_equality_mismatch`,
      bold,
      normal,
    );
  }
}

/** @import { TemplateNode } from '#client' */

/**
 * Use this variable to guard everything related to hydration code so it can be treeshaken out
 * if the user doesn't use the `hydrate` method and these code paths are therefore not needed.
 */
let hydrating = false;

/** @param {boolean} value */
function set_hydrating(value) {
  hydrating = value;
}

/**
 * The node that is currently being hydrated. This starts out as the first node inside the opening
 * <!--[--> comment, and updates each time a component calls `$.child(...)` or `$.sibling(...)`.
 * When entering a block (e.g. `{#if ...}`), `hydrate_node` is the block opening comment; by the
 * time we leave the block it is the closing comment, which serves as the block's anchor.
 * @type {TemplateNode}
 */
let hydrate_node;

/** @param {TemplateNode} node */
function set_hydrate_node(node) {
  if (node === null) {
    hydration_mismatch();
    throw HYDRATION_ERROR;
  }

  return (hydrate_node = node);
}

function hydrate_next() {
  return set_hydrate_node(
    /** @type {TemplateNode} */ (get_next_sibling(hydrate_node)),
  );
}

/** @param {TemplateNode} node */
function reset(node) {
  if (!hydrating) return;

  // If the node has remaining siblings, something has gone wrong
  if (get_next_sibling(hydrate_node) !== null) {
    hydration_mismatch();
    throw HYDRATION_ERROR;
  }

  hydrate_node = node;
}

function next(count = 1) {
  if (hydrating) {
    var i = count;
    var node = hydrate_node;

    while (i--) {
      node = /** @type {TemplateNode} */ (get_next_sibling(node));
    }

    hydrate_node = node;
  }
}

/**
 * Removes all nodes starting at `hydrate_node` up until the next hydration end comment
 */
function remove_nodes() {
  var depth = 0;
  var node = hydrate_node;

  while (true) {
    if (node.nodeType === COMMENT_NODE) {
      var data = /** @type {Comment} */ (node).data;

      if (data === HYDRATION_END) {
        if (depth === 0) return node;
        depth -= 1;
      } else if (data === HYDRATION_START || data === HYDRATION_START_ELSE) {
        depth += 1;
      }
    }

    var next = /** @type {TemplateNode} */ (get_next_sibling(node));
    node.remove();
    node = next;
  }
}

/**
 *
 * @param {TemplateNode} node
 */
function read_hydration_instruction(node) {
  if (!node || node.nodeType !== COMMENT_NODE) {
    hydration_mismatch();
    throw HYDRATION_ERROR;
  }

  return /** @type {Comment} */ (node).data;
}

/** @import { Equals } from '#client' */

/** @type {Equals} */
function equals(value) {
  return value === this.v;
}

/**
 * @param {unknown} a
 * @param {unknown} b
 * @returns {boolean}
 */
function safe_not_equal(a, b) {
  return a != a
    ? b == b
    : a !== b ||
        (a !== null && typeof a === "object") ||
        typeof a === "function";
}

/**
 * @param {unknown} a
 * @param {unknown} b
 * @returns {boolean}
 */
function not_equal(a, b) {
  return a !== b;
}

/** @type {Equals} */
function safe_equals(value) {
  return !safe_not_equal(value, this.v);
}

let legacy_mode_flag = false;
let tracing_mode_flag = false;

function enable_legacy_mode_flag() {
  legacy_mode_flag = true;
}

/** @import { Derived, Reaction, Value } from '#client' */

/**
 * @param {string} label
 * @returns {Error & { stack: string } | null}
 */
function get_stack(label) {
  let error = Error();
  const stack = error.stack;

  if (!stack) return null;

  const lines = stack.split("\n");
  const new_lines = ["\n"];

  for (let i = 0; i < lines.length; i++) {
    const line = lines[i];

    if (line === "Error") {
      continue;
    }
    if (line.includes("validate_each_keys")) {
      return null;
    }
    if (line.includes("svelte/src/internal")) {
      continue;
    }
    new_lines.push(line);
  }

  if (new_lines.length === 1) {
    return null;
  }

  define_property(error, "stack", {
    value: new_lines.join("\n"),
  });

  define_property(error, "name", {
    // 'Error' suffix is required for stack traces to be rendered properly
    value: `${label}Error`,
  });

  return /** @type {Error & { stack: string }} */ (error);
}

/**
 * @param {Value} source
 * @param {string} label
 */
function tag(source, label) {
  source.label = label;
  tag_proxy(source.v, label);

  return source;
}

/**
 * @param {unknown} value
 * @param {string} label
 */
function tag_proxy(value, label) {
  // @ts-expect-error
  value?.[PROXY_PATH_SYMBOL]?.(label);
  return value;
}

/** @import { ComponentContext, DevStackEntry, Effect } from '#client' */

/** @type {ComponentContext | null} */
let component_context = null;

/** @param {ComponentContext | null} context */
function set_component_context(context) {
  component_context = context;
}

/** @type {DevStackEntry | null} */
let dev_stack = null;

/** @param {DevStackEntry | null} stack */
function set_dev_stack(stack) {
  dev_stack = stack;
}

/**
 * Execute a callback with a new dev stack entry
 * @param {() => any} callback - Function to execute
 * @param {DevStackEntry['type']} type - Type of block/component
 * @param {any} component - Component function
 * @param {number} line - Line number
 * @param {number} column - Column number
 * @param {Record<string, any>} [additional] - Any additional properties to add to the dev stack entry
 * @returns {any}
 */
function add_svelte_meta(callback, type, component, line, column, additional) {
  const parent = dev_stack;

  dev_stack = {
    type,
    file: component[FILENAME],
    line,
    column,
    parent,
    ...additional,
  };

  try {
    return callback();
  } finally {
    dev_stack = parent;
  }
}

/**
 * The current component function. Different from current component context:
 * ```html
 * <!-- App.svelte -->
 * <Foo>
 *   <Bar /> <!-- context == Foo.svelte, function == App.svelte -->
 * </Foo>
 * ```
 * @type {ComponentContext['function']}
 */
let dev_current_component_function = null;

/** @param {ComponentContext['function']} fn */
function set_dev_current_component_function(fn) {
  dev_current_component_function = fn;
}

/**
 * Retrieves the context that belongs to the closest parent component with the specified `key`.
 * Must be called during component initialisation.
 *
 * @template T
 * @param {any} key
 * @returns {T}
 */
function getContext(key) {
  const context_map = get_or_init_context_map("getContext");
  const result = /** @type {T} */ (context_map.get(key));
  return result;
}

/**
 * Associates an arbitrary `context` object with the current component and the specified `key`
 * and returns that object. The context is then available to children of the component
 * (including slotted content) with `getContext`.
 *
 * Like lifecycle functions, this must be called during component initialisation.
 *
 * @template T
 * @param {any} key
 * @param {T} context
 * @returns {T}
 */
function setContext(key, context) {
  const context_map = get_or_init_context_map("setContext");

  context_map.set(key, context);
  return context;
}

/**
 * @param {Record<string, unknown>} props
 * @param {any} runes
 * @param {Function} [fn]
 * @returns {void}
 */
function push(props, runes = false, fn) {
  component_context = {
    p: component_context,
    c: null,
    e: null,
    s: props,
    x: null,
    l: legacy_mode_flag && !runes ? { s: null, u: null, $: [] } : null,
  };

  {
    // component function
    component_context.function = fn;
    dev_current_component_function = fn;
  }
}

/**
 * @template {Record<string, any>} T
 * @param {T} [component]
 * @returns {T}
 */
function pop(component) {
  var context = /** @type {ComponentContext} */ (component_context);
  var effects = context.e;

  if (effects !== null) {
    context.e = null;

    for (var fn of effects) {
      create_user_effect(fn);
    }
  }

  if (component !== undefined) {
    context.x = component;
  }

  component_context = context.p;

  {
    dev_current_component_function = component_context?.function ?? null;
  }

  return component ?? /** @type {T} */ ({});
}

/** @returns {boolean} */
function is_runes() {
  return (
    !legacy_mode_flag ||
    (component_context !== null && component_context.l === null)
  );
}

/**
 * @param {string} name
 * @returns {Map<unknown, unknown>}
 */
function get_or_init_context_map(name) {
  if (component_context === null) {
    lifecycle_outside_component(name);
  }

  return (component_context.c ??= new Map(
    get_parent_context(component_context) || undefined,
  ));
}

/**
 * @param {ComponentContext} component_context
 * @returns {Map<unknown, unknown> | null}
 */
function get_parent_context(component_context) {
  let parent = component_context.p;
  while (parent !== null) {
    const context_map = parent.c;
    if (context_map !== null) {
      return context_map;
    }
    parent = parent.p;
  }
  return null;
}

/** @import { Derived, Effect } from '#client' */
/** @import { Boundary } from './dom/blocks/boundary.js' */

const adjustments = new WeakMap();

/**
 * @param {unknown} error
 */
function handle_error(error) {
  var effect = active_effect;

  // for unowned deriveds, don't throw until we read the value
  if (effect === null) {
    /** @type {Derived} */ (active_reaction).f |= ERROR_VALUE;
    return error;
  }

  if (error instanceof Error && !adjustments.has(error)) {
    adjustments.set(error, get_adjustments(error, effect));
  }

  if ((effect.f & EFFECT_RAN) === 0) {
    // if the error occurred while creating this subtree, we let it
    // bubble up until it hits a boundary that can handle it
    if ((effect.f & BOUNDARY_EFFECT) === 0) {
      if (!effect.parent && error instanceof Error) {
        apply_adjustments(error);
      }

      throw error;
    }

    /** @type {Boundary} */ (effect.b).error(error);
  } else {
    // otherwise we bubble up the effect tree ourselves
    invoke_error_boundary(error, effect);
  }
}

/**
 * @param {unknown} error
 * @param {Effect | null} effect
 */
function invoke_error_boundary(error, effect) {
  while (effect !== null) {
    if ((effect.f & BOUNDARY_EFFECT) !== 0) {
      try {
        /** @type {Boundary} */ (effect.b).error(error);
        return;
      } catch (e) {
        error = e;
      }
    }

    effect = effect.parent;
  }

  if (error instanceof Error) {
    apply_adjustments(error);
  }

  throw error;
}

/**
 * Add useful information to the error message/stack in development
 * @param {Error} error
 * @param {Effect} effect
 */
function get_adjustments(error, effect) {
  const message_descriptor = get_descriptor(error, "message");

  // if the message was already changed and it's not configurable we can't change it
  // or it will throw a different error swallowing the original error
  if (message_descriptor && !message_descriptor.configurable) return;

  var indent = is_firefox ? "  " : "\t";
  var component_stack = `\n${indent}in ${effect.fn?.name || "<unknown>"}`;
  var context = effect.ctx;

  while (context !== null) {
    component_stack += `\n${indent}in ${context.function?.[FILENAME].split("/").pop()}`;
    context = context.p;
  }

  return {
    message: error.message + `\n${component_stack}\n`,
    stack: error.stack
      ?.split("\n")
      .filter((line) => !line.includes("svelte/src/internal"))
      .join("\n"),
  };
}

/**
 * @param {Error} error
 */
function apply_adjustments(error) {
  const adjusted = adjustments.get(error);

  if (adjusted) {
    define_property(error, "message", {
      value: adjusted.message,
    });

    define_property(error, "stack", {
      value: adjusted.stack,
    });
  }
}

// Fallback for when requestIdleCallback is not available
const request_idle_callback =
  typeof requestIdleCallback === "undefined"
    ? (/** @type {() => void} */ cb) => setTimeout(cb, 1)
    : requestIdleCallback;

/** @type {Array<() => void>} */
let micro_tasks = [];

/** @type {Array<() => void>} */
let idle_tasks = [];

function run_micro_tasks() {
  var tasks = micro_tasks;
  micro_tasks = [];
  run_all(tasks);
}

function run_idle_tasks() {
  var tasks = idle_tasks;
  idle_tasks = [];
  run_all(tasks);
}

/**
 * @param {() => void} fn
 */
function queue_micro_task(fn) {
  if (micro_tasks.length === 0) {
    queueMicrotask(run_micro_tasks);
  }

  micro_tasks.push(fn);
}

/**
 * @param {() => void} fn
 */
function queue_idle_task(fn) {
  if (idle_tasks.length === 0) {
    request_idle_callback(run_idle_tasks);
  }

  idle_tasks.push(fn);
}

/**
 * Synchronously run any queued tasks.
 */
function flush_tasks() {
  if (micro_tasks.length > 0) {
    run_micro_tasks();
  }

  if (idle_tasks.length > 0) {
    run_idle_tasks();
  }
}

/** @import { Effect, Source, TemplateNode, } from '#client' */

function get_pending_boundary() {
  var boundary = /** @type {Effect} */ (active_effect).b;

  while (boundary !== null && !boundary.has_pending_snippet()) {
    boundary = boundary.parent;
  }

  if (boundary === null) {
    await_outside_boundary();
  }

  return boundary;
}

/** @import { Derived, Effect, Source } from '#client' */
/** @import { Batch } from './batch.js'; */

/** @type {Effect | null} */
let current_async_effect = null;

/** @param {Effect | null} v */
function set_from_async_derived(v) {
  current_async_effect = v;
}

const recent_async_deriveds = new Set();

/**
 * @template V
 * @param {() => V} fn
 * @returns {Derived<V>}
 */
/*#__NO_SIDE_EFFECTS__*/
function derived(fn) {
  var flags = DERIVED | DIRTY;
  var parent_derived =
    active_reaction !== null && (active_reaction.f & DERIVED) !== 0
      ? /** @type {Derived} */ (active_reaction)
      : null;

  if (
    active_effect === null ||
    (parent_derived !== null && (parent_derived.f & UNOWNED) !== 0)
  ) {
    flags |= UNOWNED;
  } else {
    // Since deriveds are evaluated lazily, any effects created inside them are
    // created too late to ensure that the parent effect is added to the tree
    active_effect.f |= EFFECT_PRESERVED;
  }

  /** @type {Derived<V>} */
  const signal = {
    ctx: component_context,
    deps: null,
    effects: null,
    equals,
    f: flags,
    fn,
    reactions: null,
    rv: 0,
    v: /** @type {V} */ (UNINITIALIZED),
    wv: 0,
    parent: parent_derived ?? active_effect,
    ac: null,
  };

  return signal;
}

/**
 * @template V
 * @param {() => V | Promise<V>} fn
 * @param {string} [location] If provided, print a warning if the value is not read immediately after update
 * @returns {Promise<Source<V>>}
 */
/*#__NO_SIDE_EFFECTS__*/
function async_derived(fn, location) {
  let parent = /** @type {Effect | null} */ (active_effect);

  if (parent === null) {
    async_derived_orphan();
  }

  var boundary = /** @type {Boundary} */ (parent.b);

  var promise = /** @type {Promise<V>} */ (/** @type {unknown} */ (undefined));
  var signal = source(/** @type {V} */ (UNINITIALIZED));

  /** @type {Promise<V> | null} */
  var prev = null;

  // only suspend in async deriveds created on initialisation
  var should_suspend = !active_reaction;

  async_effect(() => {
    current_async_effect = active_effect;

    try {
      var p = fn();
    } catch (error) {
      p = Promise.reject(error);
    }

    current_async_effect = null;

    var r = () => p;
    promise = prev?.then(r, r) ?? Promise.resolve(p);

    prev = promise;

    var batch = /** @type {Batch} */ (current_batch);
    var pending = boundary.pending;

    if (should_suspend) {
      boundary.update_pending_count(1);
      if (!pending) batch.increment();
    }

    /**
     * @param {any} value
     * @param {unknown} error
     */
    const handler = (value, error = undefined) => {
      prev = null;

      current_async_effect = null;

      if (!pending) batch.activate();

      if (error) {
        if (error !== STALE_REACTION) {
          signal.f |= ERROR_VALUE;

          // @ts-expect-error the error is the wrong type, but we don't care
          internal_set(signal, error);
        }
      } else {
        if ((signal.f & ERROR_VALUE) !== 0) {
          signal.f ^= ERROR_VALUE;
        }

        internal_set(signal, value);
      }

      if (should_suspend) {
        boundary.update_pending_count(-1);
        if (!pending) batch.decrement();
      }

      unset_context();
    };

    promise.then(handler, (e) => handler(null, e || "unknown"));

    if (batch) {
      return () => {
        queueMicrotask(() => batch.neuter());
      };
    }
  });

  {
    // add a flag that lets this be printed as a derived
    // when using `$inspect.trace()`
    signal.f |= ASYNC;
  }

  return new Promise((fulfil) => {
    /** @param {Promise<V>} p */
    function next(p) {
      function go() {
        if (p === promise) {
          fulfil(signal);
        } else {
          // if the effect re-runs before the initial promise
          // resolves, delay resolution until we have a value
          next(promise);
        }
      }

      p.then(go, go);
    }

    next(promise);
  });
}

/**
 * @template V
 * @param {() => V} fn
 * @returns {Derived<V>}
 */
/*#__NO_SIDE_EFFECTS__*/
function user_derived(fn) {
  const d = derived(fn);

  push_reaction_value(d);

  return d;
}

/**
 * @template V
 * @param {() => V} fn
 * @returns {Derived<V>}
 */
/*#__NO_SIDE_EFFECTS__*/
function derived_safe_equal(fn) {
  const signal = derived(fn);
  signal.equals = safe_equals;
  return signal;
}

/**
 * @param {Derived} derived
 * @returns {void}
 */
function destroy_derived_effects(derived) {
  var effects = derived.effects;

  if (effects !== null) {
    derived.effects = null;

    for (var i = 0; i < effects.length; i += 1) {
      destroy_effect(/** @type {Effect} */ (effects[i]));
    }
  }
}

/**
 * The currently updating deriveds, used to detect infinite recursion
 * in dev mode and provide a nicer error than 'too much recursion'
 * @type {Derived[]}
 */
let stack = [];

/**
 * @param {Derived} derived
 * @returns {Effect | null}
 */
function get_derived_parent_effect(derived) {
  var parent = derived.parent;
  while (parent !== null) {
    if ((parent.f & DERIVED) === 0) {
      return /** @type {Effect} */ (parent);
    }
    parent = parent.parent;
  }
  return null;
}

/**
 * @template T
 * @param {Derived} derived
 * @returns {T}
 */
function execute_derived(derived) {
  var value;
  var prev_active_effect = active_effect;

  set_active_effect(get_derived_parent_effect(derived));

  {
    let prev_inspect_effects = inspect_effects;
    set_inspect_effects(new Set());
    try {
      if (stack.includes(derived)) {
        derived_references_self();
      }

      stack.push(derived);

      destroy_derived_effects(derived);
      value = update_reaction(derived);
    } finally {
      set_active_effect(prev_active_effect);
      set_inspect_effects(prev_inspect_effects);
      stack.pop();
    }
  }

  return value;
}

/**
 * @param {Derived} derived
 * @returns {void}
 */
function update_derived(derived) {
  var value = execute_derived(derived);

  if (!derived.equals(value)) {
    derived.v = value;
    derived.wv = increment_write_version();
  }

  // don't mark derived clean if we're reading it inside a
  // cleanup function, or it will cache a stale value
  if (is_destroying_effect) {
    return;
  }

  if (batch_deriveds !== null) {
    batch_deriveds.set(derived, derived.v);
  } else {
    var status =
      (skip_reaction || (derived.f & UNOWNED) !== 0) && derived.deps !== null
        ? MAYBE_DIRTY
        : CLEAN;

    set_signal_status(derived, status);
  }
}

/** @import { Effect, Value } from '#client' */

/**
 *
 * @param {Array<() => any>} sync
 * @param {Array<() => Promise<any>>} async
 * @param {(values: Value[]) => any} fn
 */
function flatten$1(sync, async, fn) {
  const d = is_runes() ? derived : derived_safe_equal;

  if (async.length === 0) {
    fn(sync.map(d));
    return;
  }

  var batch = current_batch;
  var parent = /** @type {Effect} */ (active_effect);

  var restore = capture();
  var boundary = get_pending_boundary();

  Promise.all(async.map((expression) => async_derived(expression)))
    .then((result) => {
      batch?.activate();

      restore();

      try {
        fn([...sync.map(d), ...result]);
      } catch (error) {
        // ignore errors in blocks that have already been destroyed
        if ((parent.f & DESTROYED) === 0) {
          invoke_error_boundary(error, parent);
        }
      }

      batch?.deactivate();
      unset_context();
    })
    .catch((error) => {
      boundary.error(error);
    });
}

/**
 * Captures the current effect context so that we can restore it after
 * some asynchronous work has happened (so that e.g. `await a + b`
 * causes `b` to be registered as a dependency).
 */
function capture() {
  var previous_effect = active_effect;
  var previous_reaction = active_reaction;
  var previous_component_context = component_context;

  return function restore() {
    set_active_effect(previous_effect);
    set_active_reaction(previous_reaction);
    set_component_context(previous_component_context);

    {
      set_from_async_derived(null);
    }
  };
}

/**
 * Reset `current_async_effect` after the `promise` resolves, so
 * that we can emit `await_reactivity_loss` warnings
 * @template T
 * @param {Promise<T>} promise
 * @returns {Promise<() => T>}
 */
async function track_reactivity_loss(promise) {
  var previous_async_effect = current_async_effect;
  var value = await promise;

  return () => {
    set_from_async_derived(previous_async_effect);
    return value;
  };
}

function unset_context() {
  set_active_effect(null);
  set_active_reaction(null);
  set_component_context(null);
  set_from_async_derived(null);
}

/** @import { Derived, Effect, Source } from '#client' */

/** @type {Set<Batch>} */
const batches = new Set();

/** @type {Batch | null} */
let current_batch = null;

/**
 * When time travelling, we re-evaluate deriveds based on the temporary
 * values of their dependencies rather than their actual values, and cache
 * the results in this map rather than on the deriveds themselves
 * @type {Map<Derived, any> | null}
 */
let batch_deriveds = null;

/** @type {Set<() => void>} */
let effect_pending_updates = new Set();

/** @type {Array<() => void>} */
let tasks = [];

function dequeue() {
  const task = /** @type {() => void} */ (tasks.shift());

  if (tasks.length > 0) {
    queueMicrotask(dequeue);
  }

  task();
}

/** @type {Effect[]} */
let queued_root_effects = [];

/** @type {Effect | null} */
let last_scheduled_effect = null;

let is_flushing = false;

let is_flushing_sync = false;
class Batch {
  /**
   * The current values of any sources that are updated in this batch
   * They keys of this map are identical to `this.#previous`
   * @type {Map<Source, any>}
   */
  current = new Map();

  /**
   * The values of any sources that are updated in this batch _before_ those updates took place.
   * They keys of this map are identical to `this.#current`
   * @type {Map<Source, any>}
   */
  #previous = new Map();

  /**
   * When the batch is committed (and the DOM is updated), we need to remove old branches
   * and append new ones by calling the functions added inside (if/each/key/etc) blocks
   * @type {Set<() => void>}
   */
  #callbacks = new Set();

  /**
   * The number of async effects that are currently in flight
   */
  #pending = 0;

  /**
   * A deferred that resolves when the batch is committed, used with `settled()`
   * TODO replace with Promise.withResolvers once supported widely enough
   * @type {{ promise: Promise<void>, resolve: (value?: any) => void, reject: (reason: unknown) => void } | null}
   */
  #deferred = null;

  /**
   * True if an async effect inside this batch resolved and
   * its parent branch was already deleted
   */
  #neutered = false;

  /**
   * Async effects (created inside `async_derived`) encountered during processing.
   * These run after the rest of the batch has updated, since they should
   * always have the latest values
   * @type {Effect[]}
   */
  #async_effects = [];

  /**
   * The same as `#async_effects`, but for effects inside a newly-created
   * `<svelte:boundary>` — these do not prevent the batch from committing
   * @type {Effect[]}
   */
  #boundary_async_effects = [];

  /**
   * Template effects and `$effect.pre` effects, which run when
   * a batch is committed
   * @type {Effect[]}
   */
  #render_effects = [];

  /**
   * The same as `#render_effects`, but for `$effect` (which runs after)
   * @type {Effect[]}
   */
  #effects = [];

  /**
   * Block effects, which may need to re-run on subsequent flushes
   * in order to update internal sources (e.g. each block items)
   * @type {Effect[]}
   */
  #block_effects = [];

  /**
   * Deferred effects (which run after async work has completed) that are DIRTY
   * @type {Effect[]}
   */
  #dirty_effects = [];

  /**
   * Deferred effects that are MAYBE_DIRTY
   * @type {Effect[]}
   */
  #maybe_dirty_effects = [];

  /**
   * A set of branches that still exist, but will be destroyed when this batch
   * is committed — we skip over these during `process`
   * @type {Set<Effect>}
   */
  skipped_effects = new Set();

  /**
   *
   * @param {Effect[]} root_effects
   */
  process(root_effects) {
    queued_root_effects = [];

    /** @type {Map<Source, { v: unknown, wv: number }> | null} */
    var current_values = null;

    // if there are multiple batches, we are 'time travelling' —
    // we need to undo the changes belonging to any batch
    // other than the current one
    if (batches.size > 1) {
      current_values = new Map();
      batch_deriveds = new Map();

      for (const [source, current] of this.current) {
        current_values.set(source, { v: source.v, wv: source.wv });
        source.v = current;
      }

      for (const batch of batches) {
        if (batch === this) continue;

        for (const [source, previous] of batch.#previous) {
          if (!current_values.has(source)) {
            current_values.set(source, { v: source.v, wv: source.wv });
            source.v = previous;
          }
        }
      }
    }

    for (const root of root_effects) {
      this.#traverse_effect_tree(root);
    }

    // if we didn't start any new async work, and no async work
    // is outstanding from a previous flush, commit
    if (this.#async_effects.length === 0 && this.#pending === 0) {
      this.#commit();

      var render_effects = this.#render_effects;
      var effects = this.#effects;

      this.#render_effects = [];
      this.#effects = [];
      this.#block_effects = [];
      current_batch = null;

      flush_queued_effects(render_effects);
      flush_queued_effects(effects);

      // Reinstate the current batch if there was no new one created, as `process()` runs in a loop in `flush_effects()`.
      // That method expects `current_batch` to be set, and could run the loop again if effects result in new effects
      // being scheduled but without writes happening in which case no new batch is created.
      if (current_batch === null) {
        current_batch = this;
      } else {
        batches.delete(this);
      }

      this.#deferred?.resolve();
    } else {
      this.#defer_effects(this.#render_effects);
      this.#defer_effects(this.#effects);
      this.#defer_effects(this.#block_effects);
    }

    if (current_values) {
      for (const [source, { v, wv }] of current_values) {
        // reset the source to the current value (unless
        // it got a newer value as a result of effects running)
        if (source.wv <= wv) {
          source.v = v;
        }
      }

      batch_deriveds = null;
    }

    for (const effect of this.#async_effects) {
      update_effect(effect);
    }

    for (const effect of this.#boundary_async_effects) {
      update_effect(effect);
    }

    this.#async_effects = [];
    this.#boundary_async_effects = [];
  }

  /**
   * Traverse the effect tree, executing effects or stashing
   * them for later execution as appropriate
   * @param {Effect} root
   */
  #traverse_effect_tree(root) {
    root.f ^= CLEAN;

    var effect = root.first;

    while (effect !== null) {
      var flags = effect.f;
      var is_branch = (flags & (BRANCH_EFFECT | ROOT_EFFECT)) !== 0;
      var is_skippable_branch = is_branch && (flags & CLEAN) !== 0;

      var skip =
        is_skippable_branch ||
        (flags & INERT) !== 0 ||
        this.skipped_effects.has(effect);

      if (!skip && effect.fn !== null) {
        if (is_branch) {
          effect.f ^= CLEAN;
        } else if ((flags & CLEAN) === 0) {
          if ((flags & EFFECT) !== 0) {
            this.#effects.push(effect);
          } else if ((flags & ASYNC) !== 0) {
            var effects = effect.b?.pending
              ? this.#boundary_async_effects
              : this.#async_effects;
            effects.push(effect);
          } else if (is_dirty(effect)) {
            if ((effect.f & BLOCK_EFFECT) !== 0)
              this.#block_effects.push(effect);
            update_effect(effect);
          }
        }

        var child = effect.first;

        if (child !== null) {
          effect = child;
          continue;
        }
      }

      var parent = effect.parent;
      effect = effect.next;

      while (effect === null && parent !== null) {
        effect = parent.next;
        parent = parent.parent;
      }
    }
  }

  /**
   * @param {Effect[]} effects
   */
  #defer_effects(effects) {
    for (const e of effects) {
      const target =
        (e.f & DIRTY) !== 0 ? this.#dirty_effects : this.#maybe_dirty_effects;
      target.push(e);

      // mark as clean so they get scheduled if they depend on pending async state
      set_signal_status(e, CLEAN);
    }

    effects.length = 0;
  }

  /**
   * Associate a change to a given source with the current
   * batch, noting its previous and current values
   * @param {Source} source
   * @param {any} value
   */
  capture(source, value) {
    if (!this.#previous.has(source)) {
      this.#previous.set(source, value);
    }

    this.current.set(source, source.v);
  }

  activate() {
    current_batch = this;
  }

  deactivate() {
    current_batch = null;

    for (const update of effect_pending_updates) {
      effect_pending_updates.delete(update);
      update();

      if (current_batch !== null) {
        // only do one at a time
        break;
      }
    }
  }

  neuter() {
    this.#neutered = true;
  }

  flush() {
    if (queued_root_effects.length > 0) {
      flush_effects();
    } else {
      this.#commit();
    }

    if (current_batch !== this) {
      // this can happen if a `flushSync` occurred during `flush_effects()`,
      // which is permitted in legacy mode despite being a terrible idea
      return;
    }

    if (this.#pending === 0) {
      batches.delete(this);
    }

    this.deactivate();
  }

  /**
   * Append and remove branches to/from the DOM
   */
  #commit() {
    if (!this.#neutered) {
      for (const fn of this.#callbacks) {
        fn();
      }
    }

    this.#callbacks.clear();
  }

  increment() {
    this.#pending += 1;
  }

  decrement() {
    this.#pending -= 1;

    if (this.#pending === 0) {
      for (const e of this.#dirty_effects) {
        set_signal_status(e, DIRTY);
        schedule_effect(e);
      }

      for (const e of this.#maybe_dirty_effects) {
        set_signal_status(e, MAYBE_DIRTY);
        schedule_effect(e);
      }

      this.#render_effects = [];
      this.#effects = [];

      this.flush();
    } else {
      this.deactivate();
    }
  }

  /** @param {() => void} fn */
  add_callback(fn) {
    this.#callbacks.add(fn);
  }

  settled() {
    return (this.#deferred ??= deferred()).promise;
  }

  static ensure() {
    if (current_batch === null) {
      const batch = (current_batch = new Batch());
      batches.add(current_batch);

      if (!is_flushing_sync) {
        Batch.enqueue(() => {
          if (current_batch !== batch) {
            // a flushSync happened in the meantime
            return;
          }

          batch.flush();
        });
      }
    }

    return current_batch;
  }

  /** @param {() => void} task */
  static enqueue(task) {
    if (tasks.length === 0) {
      queueMicrotask(dequeue);
    }

    tasks.unshift(task);
  }
}

/**
 * Synchronously flush any pending updates.
 * Returns void if no callback is provided, otherwise returns the result of calling the callback.
 * @template [T=void]
 * @param {(() => T) | undefined} [fn]
 * @returns {T}
 */
function flushSync(fn) {
  var was_flushing_sync = is_flushing_sync;
  is_flushing_sync = true;

  try {
    var result;

    if (fn);

    while (true) {
      flush_tasks();

      if (queued_root_effects.length === 0) {
        current_batch?.flush();

        // we need to check again, in case we just updated an `$effect.pending()`
        if (queued_root_effects.length === 0) {
          // this would be reset in `flush_effects()` but since we are early returning here,
          // we need to reset it here as well in case the first time there's 0 queued root effects
          last_scheduled_effect = null;

          return /** @type {T} */ (result);
        }
      }

      flush_effects();
    }
  } finally {
    is_flushing_sync = was_flushing_sync;
  }
}

function flush_effects() {
  var was_updating_effect = is_updating_effect;
  is_flushing = true;

  try {
    var flush_count = 0;
    set_is_updating_effect(true);

    while (queued_root_effects.length > 0) {
      var batch = Batch.ensure();

      if (flush_count++ > 1000) {
        if (DEV) {
          var updates = new Map();

          for (const source of batch.current.keys()) {
            for (const [stack, update] of source.updated ?? []) {
              var entry = updates.get(stack);

              if (!entry) {
                entry = { error: update.error, count: 0 };
                updates.set(stack, entry);
              }

              entry.count += update.count;
            }
          }

          for (const update of updates.values()) {
            // eslint-disable-next-line no-console
            console.error(update.error);
          }
        }

        infinite_loop_guard();
      }

      batch.process(queued_root_effects);
      old_values.clear();
    }
  } finally {
    is_flushing = false;
    set_is_updating_effect(was_updating_effect);

    last_scheduled_effect = null;
  }
}

function infinite_loop_guard() {
  try {
    effect_update_depth_exceeded();
  } catch (error) {
    {
      // stack contains no useful information, replace it
      define_property(error, "stack", { value: "" });
    }

    // Best effort: invoke the boundary nearest the most recent
    // effect and hope that it's relevant to the infinite loop
    invoke_error_boundary(error, last_scheduled_effect);
  }
}

/**
 * @param {Array<Effect>} effects
 * @returns {void}
 */
function flush_queued_effects(effects) {
  var length = effects.length;
  if (length === 0) return;

  var i = 0;

  while (i < length) {
    var effect = effects[i++];

    if ((effect.f & (DESTROYED | INERT)) === 0 && is_dirty(effect)) {
      var n = current_batch ? current_batch.current.size : 0;

      update_effect(effect);

      // Effects with no dependencies or teardown do not get added to the effect tree.
      // Deferred effects (e.g. `$effect(...)`) _are_ added to the tree because we
      // don't know if we need to keep them until they are executed. Doing the check
      // here (rather than in `update_effect`) allows us to skip the work for
      // immediate effects.
      if (
        effect.deps === null &&
        effect.first === null &&
        effect.nodes_start === null
      ) {
        // if there's no teardown or abort controller we completely unlink
        // the effect from the graph
        if (effect.teardown === null && effect.ac === null) {
          // remove this effect from the graph
          unlink_effect(effect);
        } else {
          // keep the effect in the graph, but free up some memory
          effect.fn = null;
        }
      }

      // if state is written in a user effect, abort and re-schedule, lest we run
      // effects that should be removed as a result of the state change
      if (
        current_batch !== null &&
        current_batch.current.size > n &&
        (effect.f & USER_EFFECT) !== 0
      ) {
        break;
      }
    }
  }

  while (i < length) {
    schedule_effect(effects[i++]);
  }
}

/**
 * @param {Effect} signal
 * @returns {void}
 */
function schedule_effect(signal) {
  var effect = (last_scheduled_effect = signal);

  while (effect.parent !== null) {
    effect = effect.parent;
    var flags = effect.f;

    // if the effect is being scheduled because a parent (each/await/etc) block
    // updated an internal source, bail out or we'll cause a second flush
    if (
      is_flushing &&
      effect === active_effect &&
      (flags & BLOCK_EFFECT) !== 0
    ) {
      return;
    }

    if ((flags & (ROOT_EFFECT | BRANCH_EFFECT)) !== 0) {
      if ((flags & CLEAN) === 0) return;
      effect.f ^= CLEAN;
    }
  }

  queued_root_effects.push(effect);
}

/** @import { Derived, Effect, Source, Value } from '#client' */

/** @type {Set<any>} */
let inspect_effects = new Set();

/** @type {Map<Source, any>} */
const old_values = new Map();

/**
 * @param {Set<any>} v
 */
function set_inspect_effects(v) {
  inspect_effects = v;
}

let inspect_effects_deferred = false;

function set_inspect_effects_deferred() {
  inspect_effects_deferred = true;
}

/**
 * @template V
 * @param {V} v
 * @param {Error | null} [stack]
 * @returns {Source<V>}
 */
// TODO rename this to `state` throughout the codebase
function source(v, stack) {
  /** @type {Value} */
  var signal = {
    f: 0, // TODO ideally we could skip this altogether, but it causes type errors
    v,
    reactions: null,
    equals,
    rv: 0,
    wv: 0,
  };

  return signal;
}

/**
 * @template V
 * @param {V} v
 * @param {Error | null} [stack]
 */
/*#__NO_SIDE_EFFECTS__*/
function state(v, stack) {
  const s = source(v);

  push_reaction_value(s);

  return s;
}

/**
 * @template V
 * @param {V} initial_value
 * @param {boolean} [immutable]
 * @returns {Source<V>}
 */
/*#__NO_SIDE_EFFECTS__*/
function mutable_source(initial_value, immutable = false, trackable = true) {
  const s = source(initial_value);
  if (!immutable) {
    s.equals = safe_equals;
  }

  // bind the signal to the component context, in case we need to
  // track updates to trigger beforeUpdate/afterUpdate callbacks
  if (
    legacy_mode_flag &&
    trackable &&
    component_context !== null &&
    component_context.l !== null
  ) {
    (component_context.l.s ??= []).push(s);
  }

  return s;
}

/**
 * @template V
 * @param {Source<V>} source
 * @param {V} value
 * @param {boolean} [should_proxy]
 * @returns {V}
 */
function set$2(source, value, should_proxy = false) {
  if (
    active_reaction !== null &&
    // since we are untracking the function inside `$inspect.with` we need to add this check
    // to ensure we error if state is set inside an inspect effect
    (!untracking || (active_reaction.f & INSPECT_EFFECT) !== 0) &&
    is_runes() &&
    (active_reaction.f & (DERIVED | BLOCK_EFFECT | ASYNC | INSPECT_EFFECT)) !==
      0 &&
    !current_sources?.includes(source)
  ) {
    state_unsafe_mutation();
  }

  let new_value = should_proxy ? proxy(value) : value;

  {
    tag_proxy(new_value, /** @type {string} */ (source.label));
  }

  return internal_set(source, new_value);
}

/**
 * @template V
 * @param {Source<V>} source
 * @param {V} value
 * @returns {V}
 */
function internal_set(source, value) {
  if (!source.equals(value)) {
    var old_value = source.v;

    if (is_destroying_effect) {
      old_values.set(source, value);
    } else {
      old_values.set(source, old_value);
    }

    source.v = value;

    var batch = Batch.ensure();
    batch.capture(source, old_value);

    {
      if (active_effect !== null) {
        const error = get_stack("UpdatedAt");

        if (error !== null) {
          source.updated ??= new Map();
          let entry = source.updated.get(error.stack);

          if (!entry) {
            entry = { error, count: 0 };
            source.updated.set(error.stack, entry);
          }

          entry.count++;
        }
      }

      if (active_effect !== null) {
        source.set_during_effect = true;
      }
    }

    if ((source.f & DERIVED) !== 0) {
      // if we are assigning to a dirty derived we set it to clean/maybe dirty but we also eagerly execute it to track the dependencies
      if ((source.f & DIRTY) !== 0) {
        execute_derived(/** @type {Derived} */ (source));
      }
      set_signal_status(
        source,
        (source.f & UNOWNED) === 0 ? CLEAN : MAYBE_DIRTY,
      );
    }

    source.wv = increment_write_version();

    mark_reactions(source, DIRTY);

    // It's possible that the current reaction might not have up-to-date dependencies
    // whilst it's actively running. So in the case of ensuring it registers the reaction
    // properly for itself, we need to ensure the current effect actually gets
    // scheduled. i.e: `$effect(() => x++)`
    if (
      is_runes() &&
      active_effect !== null &&
      (active_effect.f & CLEAN) !== 0 &&
      (active_effect.f & (BRANCH_EFFECT | ROOT_EFFECT)) === 0
    ) {
      if (untracked_writes === null) {
        set_untracked_writes([source]);
      } else {
        untracked_writes.push(source);
      }
    }

    if (inspect_effects.size > 0 && !inspect_effects_deferred) {
      flush_inspect_effects();
    }
  }

  return value;
}

function flush_inspect_effects() {
  inspect_effects_deferred = false;

  const inspects = Array.from(inspect_effects);

  for (const effect of inspects) {
    // Mark clean inspect-effects as maybe dirty and then check their dirtiness
    // instead of just updating the effects - this way we avoid overfiring.
    if ((effect.f & CLEAN) !== 0) {
      set_signal_status(effect, MAYBE_DIRTY);
    }

    if (is_dirty(effect)) {
      update_effect(effect);
    }
  }

  inspect_effects.clear();
}

/**
 * Silently (without using `get`) increment a source
 * @param {Source<number>} source
 */
function increment(source) {
  set$2(source, source.v + 1);
}

/**
 * @param {Value} signal
 * @param {number} status should be DIRTY or MAYBE_DIRTY
 * @returns {void}
 */
function mark_reactions(signal, status) {
  var reactions = signal.reactions;
  if (reactions === null) return;

  var runes = is_runes();
  var length = reactions.length;

  for (var i = 0; i < length; i++) {
    var reaction = reactions[i];
    var flags = reaction.f;

    // In legacy mode, skip the current effect to prevent infinite loops
    if (!runes && reaction === active_effect) continue;

    // Inspect effects need to run immediately, so that the stack trace makes sense
    if ((flags & INSPECT_EFFECT) !== 0) {
      inspect_effects.add(reaction);
      continue;
    }

    var not_dirty = (flags & DIRTY) === 0;

    // don't set a DIRTY reaction to MAYBE_DIRTY
    if (not_dirty) {
      set_signal_status(reaction, status);
    }

    if ((flags & DERIVED) !== 0) {
      mark_reactions(/** @type {Derived} */ (reaction), MAYBE_DIRTY);
    } else if (not_dirty) {
      schedule_effect(/** @type {Effect} */ (reaction));
    }
  }
}

/** @import { Source } from '#client' */

// TODO move all regexes into shared module?
const regex_is_valid_identifier = /^[a-zA-Z_$][a-zA-Z_$0-9]*$/;

/**
 * @template T
 * @param {T} value
 * @returns {T}
 */
function proxy(value) {
  // if non-proxyable, or is already a proxy, return `value`
  if (typeof value !== "object" || value === null || STATE_SYMBOL in value) {
    return value;
  }

  const prototype = get_prototype_of(value);

  if (prototype !== object_prototype && prototype !== array_prototype) {
    return value;
  }

  /** @type {Map<any, Source<any>>} */
  var sources = new Map();
  var is_proxied_array = is_array(value);
  var version = state(0);
  var parent_version = update_version;

  /**
   * Executes the proxy in the context of the reaction it was originally created in, if any
   * @template T
   * @param {() => T} fn
   */
  var with_parent = (fn) => {
    if (update_version === parent_version) {
      return fn();
    }

    // child source is being created after the initial proxy —
    // prevent it from being associated with the current reaction
    var reaction = active_reaction;
    var version = update_version;

    set_active_reaction(null);
    set_update_version(parent_version);

    var result = fn();

    set_active_reaction(reaction);
    set_update_version(version);

    return result;
  };

  if (is_proxied_array) {
    // We need to create the length source eagerly to ensure that
    // mutations to the array are properly synced with our proxy
    sources.set("length", state(/** @type {any[]} */ (value).length));
    {
      value = /** @type {any} */ (
        inspectable_array(/** @type {any[]} */ (value))
      );
    }
  }

  /** Used in dev for $inspect.trace() */
  var path = "";

  /** @param {string} new_path */
  function update_path(new_path) {
    path = new_path;

    tag(version, `${path} version`);

    // rename all child sources and child proxies
    for (const [prop, source] of sources) {
      tag(source, get_label(path, prop));
    }
  }

  return new Proxy(/** @type {any} */ (value), {
    defineProperty(_, prop, descriptor) {
      if (
        !("value" in descriptor) ||
        descriptor.configurable === false ||
        descriptor.enumerable === false ||
        descriptor.writable === false
      ) {
        // we disallow non-basic descriptors, because unless they are applied to the
        // target object — which we avoid, so that state can be forked — we will run
        // afoul of the various invariants
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy/Proxy/getOwnPropertyDescriptor#invariants
        state_descriptors_fixed();
      }
      var s = sources.get(prop);
      if (s === undefined) {
        s = with_parent(() => {
          var s = state(descriptor.value);
          sources.set(prop, s);
          if (typeof prop === "string") {
            tag(s, get_label(path, prop));
          }
          return s;
        });
      } else {
        set$2(s, descriptor.value, true);
      }

      return true;
    },

    deleteProperty(target, prop) {
      var s = sources.get(prop);

      if (s === undefined) {
        if (prop in target) {
          const s = with_parent(() => state(UNINITIALIZED));
          sources.set(prop, s);
          increment(version);

          {
            tag(s, get_label(path, prop));
          }
        }
      } else {
        set$2(s, UNINITIALIZED);
        increment(version);
      }

      return true;
    },

    get(target, prop, receiver) {
      if (prop === STATE_SYMBOL) {
        return value;
      }

      if (prop === PROXY_PATH_SYMBOL) {
        return update_path;
      }

      var s = sources.get(prop);
      var exists = prop in target;

      // create a source, but only if it's an own property and not a prototype property
      if (
        s === undefined &&
        (!exists || get_descriptor(target, prop)?.writable)
      ) {
        s = with_parent(() => {
          var p = proxy(exists ? target[prop] : UNINITIALIZED);
          var s = state(p);

          {
            tag(s, get_label(path, prop));
          }

          return s;
        });

        sources.set(prop, s);
      }

      if (s !== undefined) {
        var v = get$2(s);
        return v === UNINITIALIZED ? undefined : v;
      }

      return Reflect.get(target, prop, receiver);
    },

    getOwnPropertyDescriptor(target, prop) {
      var descriptor = Reflect.getOwnPropertyDescriptor(target, prop);

      if (descriptor && "value" in descriptor) {
        var s = sources.get(prop);
        if (s) descriptor.value = get$2(s);
      } else if (descriptor === undefined) {
        var source = sources.get(prop);
        var value = source?.v;

        if (source !== undefined && value !== UNINITIALIZED) {
          return {
            enumerable: true,
            configurable: true,
            value,
            writable: true,
          };
        }
      }

      return descriptor;
    },

    has(target, prop) {
      if (prop === STATE_SYMBOL) {
        return true;
      }

      var s = sources.get(prop);
      var has =
        (s !== undefined && s.v !== UNINITIALIZED) || Reflect.has(target, prop);

      if (
        s !== undefined ||
        (active_effect !== null &&
          (!has || get_descriptor(target, prop)?.writable))
      ) {
        if (s === undefined) {
          s = with_parent(() => {
            var p = has ? proxy(target[prop]) : UNINITIALIZED;
            var s = state(p);

            {
              tag(s, get_label(path, prop));
            }

            return s;
          });

          sources.set(prop, s);
        }

        var value = get$2(s);
        if (value === UNINITIALIZED) {
          return false;
        }
      }

      return has;
    },

    set(target, prop, value, receiver) {
      var s = sources.get(prop);
      var has = prop in target;

      // variable.length = value -> clear all signals with index >= value
      if (is_proxied_array && prop === "length") {
        for (var i = value; i < /** @type {Source<number>} */ (s).v; i += 1) {
          var other_s = sources.get(i + "");
          if (other_s !== undefined) {
            set$2(other_s, UNINITIALIZED);
          } else if (i in target) {
            // If the item exists in the original, we need to create a uninitialized source,
            // else a later read of the property would result in a source being created with
            // the value of the original item at that index.
            other_s = with_parent(() => state(UNINITIALIZED));
            sources.set(i + "", other_s);

            {
              tag(other_s, get_label(path, i));
            }
          }
        }
      }

      // If we haven't yet created a source for this property, we need to ensure
      // we do so otherwise if we read it later, then the write won't be tracked and
      // the heuristics of effects will be different vs if we had read the proxied
      // object property before writing to that property.
      if (s === undefined) {
        if (!has || get_descriptor(target, prop)?.writable) {
          s = with_parent(() => state(undefined));
          set$2(s, proxy(value));

          sources.set(prop, s);

          {
            tag(s, get_label(path, prop));
          }
        }
      } else {
        has = s.v !== UNINITIALIZED;

        var p = with_parent(() => proxy(value));
        set$2(s, p);
      }

      var descriptor = Reflect.getOwnPropertyDescriptor(target, prop);

      // Set the new value before updating any signals so that any listeners get the new value
      if (descriptor?.set) {
        descriptor.set.call(receiver, value);
      }

      if (!has) {
        // If we have mutated an array directly, we might need to
        // signal that length has also changed. Do it before updating metadata
        // to ensure that iterating over the array as a result of a metadata update
        // will not cause the length to be out of sync.
        if (is_proxied_array && typeof prop === "string") {
          var ls = /** @type {Source<number>} */ (sources.get("length"));
          var n = Number(prop);

          if (Number.isInteger(n) && n >= ls.v) {
            set$2(ls, n + 1);
          }
        }

        increment(version);
      }

      return true;
    },

    ownKeys(target) {
      get$2(version);

      var own_keys = Reflect.ownKeys(target).filter((key) => {
        var source = sources.get(key);
        return source === undefined || source.v !== UNINITIALIZED;
      });

      for (var [key, source] of sources) {
        if (source.v !== UNINITIALIZED && !(key in target)) {
          own_keys.push(key);
        }
      }

      return own_keys;
    },

    setPrototypeOf() {
      state_prototype_fixed();
    },
  });
}

/**
 * @param {string} path
 * @param {string | symbol} prop
 */
function get_label(path, prop) {
  if (typeof prop === "symbol")
    return `${path}[Symbol(${prop.description ?? ""})]`;
  if (regex_is_valid_identifier.test(prop)) return `${path}.${prop}`;
  return /^\d+$/.test(prop) ? `${path}[${prop}]` : `${path}['${prop}']`;
}

/**
 * @param {any} value
 */
function get_proxied_value(value) {
  try {
    if (value !== null && typeof value === "object" && STATE_SYMBOL in value) {
      return value[STATE_SYMBOL];
    }
  } catch {
    // the above if check can throw an error if the value in question
    // is the contentWindow of an iframe on another domain, in which
    // case we want to just return the value (because it's definitely
    // not a proxied value) so we don't break any JavaScript interacting
    // with that iframe (such as various payment companies client side
    // JavaScript libraries interacting with their iframes on the same
    // domain)
  }

  return value;
}

/**
 * @param {any} a
 * @param {any} b
 */
function is(a, b) {
  return Object.is(get_proxied_value(a), get_proxied_value(b));
}

const ARRAY_MUTATING_METHODS = new Set([
  "copyWithin",
  "fill",
  "pop",
  "push",
  "reverse",
  "shift",
  "sort",
  "splice",
  "unshift",
]);

/**
 * Wrap array mutating methods so $inspect is triggered only once and
 * to prevent logging an array in intermediate state (e.g. with an empty slot)
 * @param {any[]} array
 */
function inspectable_array(array) {
  return new Proxy(array, {
    get(target, prop, receiver) {
      var value = Reflect.get(target, prop, receiver);
      if (!ARRAY_MUTATING_METHODS.has(/** @type {string} */ (prop))) {
        return value;
      }

      /**
       * @this {any[]}
       * @param {any[]} args
       */
      return function (...args) {
        set_inspect_effects_deferred();
        var result = value.apply(this, args);
        flush_inspect_effects();
        return result;
      };
    },
  });
}

function init_array_prototype_warnings() {
  const array_prototype = Array.prototype;
  // The REPL ends up here over and over, and this prevents it from adding more and more patches
  // of the same kind to the prototype, which would slow down everything over time.
  // @ts-expect-error
  const cleanup = Array.__svelte_cleanup;
  if (cleanup) {
    cleanup();
  }

  const { indexOf, lastIndexOf, includes } = array_prototype;

  array_prototype.indexOf = function (item, from_index) {
    const index = indexOf.call(this, item, from_index);

    if (index === -1) {
      for (let i = from_index ?? 0; i < this.length; i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.indexOf(...)");
          break;
        }
      }
    }

    return index;
  };

  array_prototype.lastIndexOf = function (item, from_index) {
    // we need to specify this.length - 1 because it's probably using something like
    // `arguments` inside so passing undefined is different from not passing anything
    const index = lastIndexOf.call(this, item, from_index ?? this.length - 1);

    if (index === -1) {
      for (let i = 0; i <= (from_index ?? this.length - 1); i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.lastIndexOf(...)");
          break;
        }
      }
    }

    return index;
  };

  array_prototype.includes = function (item, from_index) {
    const has = includes.call(this, item, from_index);

    if (!has) {
      for (let i = 0; i < this.length; i += 1) {
        if (get_proxied_value(this[i]) === item) {
          state_proxy_equality_mismatch("array.includes(...)");
          break;
        }
      }
    }

    return has;
  };

  // @ts-expect-error
  Array.__svelte_cleanup = () => {
    array_prototype.indexOf = indexOf;
    array_prototype.lastIndexOf = lastIndexOf;
    array_prototype.includes = includes;
  };
}

/**
 * @param {any} a
 * @param {any} b
 * @param {boolean} equal
 * @returns {boolean}
 */
function strict_equals(a, b, equal = true) {
  // try-catch needed because this tries to read properties of `a` and `b`,
  // which could be disallowed for example in a secure context
  try {
    if ((a === b) !== (get_proxied_value(a) === get_proxied_value(b))) {
      state_proxy_equality_mismatch(equal ? "===" : "!==");
    }
  } catch {}

  return (a === b) === equal;
}

/** @import { Effect, TemplateNode } from '#client' */

// export these for reference in the compiled code, making global name deduplication unnecessary
/** @type {Window} */
var $window;

/** @type {boolean} */
var is_firefox;

/** @type {() => Node | null} */
var first_child_getter;
/** @type {() => Node | null} */
var next_sibling_getter;

/**
 * Initialize these lazily to avoid issues when using the runtime in a server context
 * where these globals are not available while avoiding a separate server entry point
 */
function init_operations() {
  if ($window !== undefined) {
    return;
  }

  $window = window;
  is_firefox = /Firefox/.test(navigator.userAgent);

  var element_prototype = Element.prototype;
  var node_prototype = Node.prototype;
  var text_prototype = Text.prototype;

  // @ts-ignore
  first_child_getter = get_descriptor(node_prototype, "firstChild").get;
  // @ts-ignore
  next_sibling_getter = get_descriptor(node_prototype, "nextSibling").get;

  if (is_extensible(element_prototype)) {
    // the following assignments improve perf of lookups on DOM nodes
    // @ts-expect-error
    element_prototype.__click = undefined;
    // @ts-expect-error
    element_prototype.__className = undefined;
    // @ts-expect-error
    element_prototype.__attributes = null;
    // @ts-expect-error
    element_prototype.__style = undefined;
    // @ts-expect-error
    element_prototype.__e = undefined;
  }

  if (is_extensible(text_prototype)) {
    // @ts-expect-error
    text_prototype.__t = undefined;
  }

  {
    // @ts-expect-error
    element_prototype.__svelte_meta = null;

    init_array_prototype_warnings();
  }
}

/**
 * @param {string} value
 * @returns {Text}
 */
function create_text(value = "") {
  return document.createTextNode(value);
}

/**
 * @template {Node} N
 * @param {N} node
 * @returns {Node | null}
 */
/*@__NO_SIDE_EFFECTS__*/
function get_first_child(node) {
  return first_child_getter.call(node);
}

/**
 * @template {Node} N
 * @param {N} node
 * @returns {Node | null}
 */
/*@__NO_SIDE_EFFECTS__*/
function get_next_sibling(node) {
  return next_sibling_getter.call(node);
}

/**
 * Don't mark this as side-effect-free, hydration needs to walk all nodes
 * @template {Node} N
 * @param {N} node
 * @param {boolean} is_text
 * @returns {Node | null}
 */
function child(node, is_text) {
  if (!hydrating) {
    return get_first_child(node);
  }

  var child = /** @type {TemplateNode} */ (get_first_child(hydrate_node));

  // Child can be null if we have an element with a single child, like `<p>{text}</p>`, where `text` is empty
  if (child === null) {
    child = hydrate_node.appendChild(create_text());
  } else if (is_text && child.nodeType !== TEXT_NODE) {
    var text = create_text();
    child?.before(text);
    set_hydrate_node(text);
    return text;
  }

  set_hydrate_node(child);
  return child;
}

/**
 * Don't mark this as side-effect-free, hydration needs to walk all nodes
 * @param {DocumentFragment | TemplateNode[]} fragment
 * @param {boolean} is_text
 * @returns {Node | null}
 */
function first_child(fragment, is_text) {
  if (!hydrating) {
    // when not hydrating, `fragment` is a `DocumentFragment` (the result of calling `open_frag`)
    var first = /** @type {DocumentFragment} */ (
      get_first_child(/** @type {Node} */ (fragment))
    );

    // TODO prevent user comments with the empty string when preserveComments is true
    if (first instanceof Comment && first.data === "")
      return get_next_sibling(first);

    return first;
  }

  return hydrate_node;
}

/**
 * Don't mark this as side-effect-free, hydration needs to walk all nodes
 * @param {TemplateNode} node
 * @param {number} count
 * @param {boolean} is_text
 * @returns {Node | null}
 */
function sibling(node, count = 1, is_text = false) {
  let next_sibling = hydrating ? hydrate_node : node;
  var last_sibling;

  while (count--) {
    last_sibling = next_sibling;
    next_sibling = /** @type {TemplateNode} */ (get_next_sibling(next_sibling));
  }

  if (!hydrating) {
    return next_sibling;
  }

  // if a sibling {expression} is empty during SSR, there might be no
  // text node to hydrate — we must therefore create one
  if (is_text && next_sibling?.nodeType !== TEXT_NODE) {
    var text = create_text();
    // If the next sibling is `null` and we're handling text then it's because
    // the SSR content was empty for the text, so we need to generate a new text
    // node and insert it after the last sibling
    if (next_sibling === null) {
      last_sibling?.after(text);
    } else {
      next_sibling.before(text);
    }
    set_hydrate_node(text);
    return text;
  }

  set_hydrate_node(next_sibling);
  return /** @type {TemplateNode} */ (next_sibling);
}

/**
 * @template {Node} N
 * @param {N} node
 * @returns {void}
 */
function clear_text_content(node) {
  node.textContent = "";
}

/**
 * Returns `true` if we're updating the current block, for example `condition` in
 * an `{#if condition}` block just changed. In this case, the branch should be
 * appended (or removed) at the same time as other updates within the
 * current `<svelte:boundary>`
 */
function should_defer_append() {
  return false;
}

/**
 * @param {HTMLElement} dom
 * @param {boolean} value
 * @returns {void}
 */
function autofocus(dom, value) {
  if (value) {
    const body = document.body;
    dom.autofocus = true;

    queue_micro_task(() => {
      if (document.activeElement === body) {
        dom.focus();
      }
    });
  }
}

/**
 * The child of a textarea actually corresponds to the defaultValue property, so we need
 * to remove it upon hydration to avoid a bug when someone resets the form value.
 * @param {HTMLTextAreaElement} dom
 * @returns {void}
 */
function remove_textarea_child(dom) {
  if (hydrating && get_first_child(dom) !== null) {
    clear_text_content(dom);
  }
}

let listening_to_form_reset = false;

function add_form_reset_listener() {
  if (!listening_to_form_reset) {
    listening_to_form_reset = true;
    document.addEventListener(
      "reset",
      (evt) => {
        // Needs to happen one tick later or else the dom properties of the form
        // elements have not updated to their reset values yet
        Promise.resolve().then(() => {
          if (!evt.defaultPrevented) {
            for (const e of /**@type {HTMLFormElement} */ (evt.target)
              .elements) {
              // @ts-expect-error
              e.__on_r?.();
            }
          }
        });
      },
      // In the capture phase to guarantee we get noticed of it (no possiblity of stopPropagation)
      { capture: true },
    );
  }
}

/**
 * @template T
 * @param {() => T} fn
 */
function without_reactive_context(fn) {
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);
  try {
    return fn();
  } finally {
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}

/** @import { ComponentContext, ComponentContextLegacy, Derived, Effect, TemplateNode, TransitionManager } from '#client' */

/**
 * @param {'$effect' | '$effect.pre' | '$inspect'} rune
 */
function validate_effect(rune) {
  if (active_effect === null && active_reaction === null) {
    effect_orphan(rune);
  }

  if (
    active_reaction !== null &&
    (active_reaction.f & UNOWNED) !== 0 &&
    active_effect === null
  ) {
    effect_in_unowned_derived();
  }

  if (is_destroying_effect) {
    effect_in_teardown(rune);
  }
}

/**
 * @param {Effect} effect
 * @param {Effect} parent_effect
 */
function push_effect(effect, parent_effect) {
  var parent_last = parent_effect.last;
  if (parent_last === null) {
    parent_effect.last = parent_effect.first = effect;
  } else {
    parent_last.next = effect;
    effect.prev = parent_last;
    parent_effect.last = effect;
  }
}

/**
 * @param {number} type
 * @param {null | (() => void | (() => void))} fn
 * @param {boolean} sync
 * @param {boolean} push
 * @returns {Effect}
 */
function create_effect(type, fn, sync, push = true) {
  var parent = active_effect;

  {
    // Ensure the parent is never an inspect effect
    while (parent !== null && (parent.f & INSPECT_EFFECT) !== 0) {
      parent = parent.parent;
    }
  }

  if (parent !== null && (parent.f & INERT) !== 0) {
    type |= INERT;
  }

  /** @type {Effect} */
  var effect = {
    ctx: component_context,
    deps: null,
    nodes_start: null,
    nodes_end: null,
    f: type | DIRTY,
    first: null,
    fn,
    last: null,
    next: null,
    parent,
    b: parent && parent.b,
    prev: null,
    teardown: null,
    transitions: null,
    wv: 0,
    ac: null,
  };

  {
    effect.component_function = dev_current_component_function;
  }

  if (sync) {
    try {
      update_effect(effect);
      effect.f |= EFFECT_RAN;
    } catch (e) {
      destroy_effect(effect);
      throw e;
    }
  } else if (fn !== null) {
    schedule_effect(effect);
  }

  // if an effect has no dependencies, no DOM and no teardown function,
  // don't bother adding it to the effect tree
  var inert =
    sync &&
    effect.deps === null &&
    effect.first === null &&
    effect.nodes_start === null &&
    effect.teardown === null &&
    (effect.f & EFFECT_PRESERVED) === 0;

  if (!inert && push) {
    if (parent !== null) {
      push_effect(effect, parent);
    }

    // if we're in a derived, add the effect there too
    if (
      active_reaction !== null &&
      (active_reaction.f & DERIVED) !== 0 &&
      (type & ROOT_EFFECT) === 0
    ) {
      var derived = /** @type {Derived} */ (active_reaction);
      (derived.effects ??= []).push(effect);
    }
  }

  return effect;
}

/**
 * @param {() => void} fn
 */
function teardown(fn) {
  const effect = create_effect(RENDER_EFFECT, null, false);
  set_signal_status(effect, CLEAN);
  effect.teardown = fn;
  return effect;
}

/**
 * Internal representation of `$effect(...)`
 * @param {() => void | (() => void)} fn
 */
function user_effect(fn) {
  validate_effect("$effect");

  {
    define_property(fn, "name", {
      value: "$effect",
    });
  }

  // Non-nested `$effect(...)` in a component should be deferred
  // until the component is mounted
  var flags = /** @type {Effect} */ (active_effect).f;
  var defer =
    !active_reaction &&
    (flags & BRANCH_EFFECT) !== 0 &&
    (flags & EFFECT_RAN) === 0;

  if (defer) {
    // Top-level `$effect(...)` in an unmounted component — defer until mount
    var context = /** @type {ComponentContext} */ (component_context);
    (context.e ??= []).push(fn);
  } else {
    // Everything else — create immediately
    return create_user_effect(fn);
  }
}

/**
 * @param {() => void | (() => void)} fn
 */
function create_user_effect(fn) {
  return create_effect(EFFECT | USER_EFFECT, fn, false);
}

/**
 * Internal representation of `$effect.pre(...)`
 * @param {() => void | (() => void)} fn
 * @returns {Effect}
 */
function user_pre_effect(fn) {
  validate_effect("$effect.pre");
  {
    define_property(fn, "name", {
      value: "$effect.pre",
    });
  }
  return create_effect(RENDER_EFFECT | USER_EFFECT, fn, true);
}

/**
 * An effect root whose children can transition out
 * @param {() => void} fn
 * @returns {(options?: { outro?: boolean }) => Promise<void>}
 */
function component_root(fn) {
  Batch.ensure();
  const effect = create_effect(ROOT_EFFECT, fn, true);

  return (options = {}) => {
    return new Promise((fulfil) => {
      if (options.outro) {
        pause_effect(effect, () => {
          destroy_effect(effect);
          fulfil(undefined);
        });
      } else {
        destroy_effect(effect);
        fulfil(undefined);
      }
    });
  };
}

/**
 * @param {() => void | (() => void)} fn
 * @returns {Effect}
 */
function effect$3(fn) {
  return create_effect(EFFECT, fn, false);
}

/**
 * @param {() => void | (() => void)} fn
 * @returns {Effect}
 */
function async_effect(fn) {
  return create_effect(ASYNC | EFFECT_PRESERVED, fn, true);
}

/**
 * @param {() => void | (() => void)} fn
 * @returns {Effect}
 */
function render_effect(fn, flags = 0) {
  return create_effect(RENDER_EFFECT | flags, fn, true);
}

/**
 * @param {(...expressions: any) => void | (() => void)} fn
 * @param {Array<() => any>} sync
 * @param {Array<() => Promise<any>>} async
 */
function template_effect(fn, sync = [], async = []) {
  flatten$1(sync, async, (values) => {
    create_effect(RENDER_EFFECT, () => fn(...values.map(get$2)), true);
  });
}

/**
 * @param {(() => void)} fn
 * @param {number} flags
 */
function block(fn, flags = 0) {
  var effect = create_effect(BLOCK_EFFECT | flags, fn, true);
  {
    effect.dev_stack = dev_stack;
  }
  return effect;
}

/**
 * @param {(() => void)} fn
 * @param {boolean} [push]
 */
function branch(fn, push = true) {
  return create_effect(BRANCH_EFFECT, fn, true, push);
}

/**
 * @param {Effect} effect
 */
function execute_effect_teardown(effect) {
  var teardown = effect.teardown;
  if (teardown !== null) {
    const previously_destroying_effect = is_destroying_effect;
    const previous_reaction = active_reaction;
    set_is_destroying_effect(true);
    set_active_reaction(null);
    try {
      teardown.call(null);
    } finally {
      set_is_destroying_effect(previously_destroying_effect);
      set_active_reaction(previous_reaction);
    }
  }
}

/**
 * @param {Effect} signal
 * @param {boolean} remove_dom
 * @returns {void}
 */
function destroy_effect_children(signal, remove_dom = false) {
  var effect = signal.first;
  signal.first = signal.last = null;

  while (effect !== null) {
    const controller = effect.ac;

    if (controller !== null) {
      without_reactive_context(() => {
        controller.abort(STALE_REACTION);
      });
    }

    var next = effect.next;

    if ((effect.f & ROOT_EFFECT) !== 0) {
      // this is now an independent root
      effect.parent = null;
    } else {
      destroy_effect(effect, remove_dom);
    }

    effect = next;
  }
}

/**
 * @param {Effect} signal
 * @returns {void}
 */
function destroy_block_effect_children(signal) {
  var effect = signal.first;

  while (effect !== null) {
    var next = effect.next;
    if ((effect.f & BRANCH_EFFECT) === 0) {
      destroy_effect(effect);
    }
    effect = next;
  }
}

/**
 * @param {Effect} effect
 * @param {boolean} [remove_dom]
 * @returns {void}
 */
function destroy_effect(effect, remove_dom = true) {
  var removed = false;

  if (
    (remove_dom || (effect.f & HEAD_EFFECT) !== 0) &&
    effect.nodes_start !== null &&
    effect.nodes_end !== null
  ) {
    remove_effect_dom(
      effect.nodes_start,
      /** @type {TemplateNode} */ (effect.nodes_end),
    );
    removed = true;
  }

  destroy_effect_children(effect, remove_dom && !removed);
  remove_reactions(effect, 0);
  set_signal_status(effect, DESTROYED);

  var transitions = effect.transitions;

  if (transitions !== null) {
    for (const transition of transitions) {
      transition.stop();
    }
  }

  execute_effect_teardown(effect);

  var parent = effect.parent;

  // If the parent doesn't have any children, then skip this work altogether
  if (parent !== null && parent.first !== null) {
    unlink_effect(effect);
  }

  {
    effect.component_function = null;
  }

  // `first` and `child` are nulled out in destroy_effect_children
  // we don't null out `parent` so that error propagation can work correctly
  effect.next =
    effect.prev =
    effect.teardown =
    effect.ctx =
    effect.deps =
    effect.fn =
    effect.nodes_start =
    effect.nodes_end =
    effect.ac =
      null;
}

/**
 *
 * @param {TemplateNode | null} node
 * @param {TemplateNode} end
 */
function remove_effect_dom(node, end) {
  while (node !== null) {
    /** @type {TemplateNode | null} */
    var next =
      node === end
        ? null
        : /** @type {TemplateNode} */ (get_next_sibling(node));

    node.remove();
    node = next;
  }
}

/**
 * Detach an effect from the effect tree, freeing up memory and
 * reducing the amount of work that happens on subsequent traversals
 * @param {Effect} effect
 */
function unlink_effect(effect) {
  var parent = effect.parent;
  var prev = effect.prev;
  var next = effect.next;

  if (prev !== null) prev.next = next;
  if (next !== null) next.prev = prev;

  if (parent !== null) {
    if (parent.first === effect) parent.first = next;
    if (parent.last === effect) parent.last = prev;
  }
}

/**
 * When a block effect is removed, we don't immediately destroy it or yank it
 * out of the DOM, because it might have transitions. Instead, we 'pause' it.
 * It stays around (in memory, and in the DOM) until outro transitions have
 * completed, and if the state change is reversed then we _resume_ it.
 * A paused effect does not update, and the DOM subtree becomes inert.
 * @param {Effect} effect
 * @param {() => void} [callback]
 */
function pause_effect(effect, callback) {
  /** @type {TransitionManager[]} */
  var transitions = [];

  pause_children(effect, transitions, true);

  run_out_transitions(transitions, () => {
    destroy_effect(effect);
    if (callback) callback();
  });
}

/**
 * @param {TransitionManager[]} transitions
 * @param {() => void} fn
 */
function run_out_transitions(transitions, fn) {
  var remaining = transitions.length;
  if (remaining > 0) {
    var check = () => --remaining || fn();
    for (var transition of transitions) {
      transition.out(check);
    }
  } else {
    fn();
  }
}

/**
 * @param {Effect} effect
 * @param {TransitionManager[]} transitions
 * @param {boolean} local
 */
function pause_children(effect, transitions, local) {
  if ((effect.f & INERT) !== 0) return;
  effect.f ^= INERT;

  if (effect.transitions !== null) {
    for (const transition of effect.transitions) {
      if (transition.is_global || local) {
        transitions.push(transition);
      }
    }
  }

  var child = effect.first;

  while (child !== null) {
    var sibling = child.next;
    var transparent =
      (child.f & EFFECT_TRANSPARENT) !== 0 || (child.f & BRANCH_EFFECT) !== 0;
    // TODO we don't need to call pause_children recursively with a linked list in place
    // it's slightly more involved though as we have to account for `transparent` changing
    // through the tree.
    pause_children(child, transitions, transparent ? local : false);
    child = sibling;
  }
}

/**
 * The opposite of `pause_effect`. We call this if (for example)
 * `x` becomes falsy then truthy: `{#if x}...{/if}`
 * @param {Effect} effect
 */
function resume_effect(effect) {
  resume_children(effect, true);
}

/**
 * @param {Effect} effect
 * @param {boolean} local
 */
function resume_children(effect, local) {
  if ((effect.f & INERT) === 0) return;
  effect.f ^= INERT;

  // If a dependency of this effect changed while it was paused,
  // schedule the effect to update. we don't use `is_dirty`
  // here because we don't want to eagerly recompute a derived like
  // `{#if foo}{foo.bar()}{/if}` if `foo` is now `undefined
  if ((effect.f & CLEAN) === 0) {
    set_signal_status(effect, DIRTY);
    schedule_effect(effect);
  }

  var child = effect.first;

  while (child !== null) {
    var sibling = child.next;
    var transparent =
      (child.f & EFFECT_TRANSPARENT) !== 0 || (child.f & BRANCH_EFFECT) !== 0;
    // TODO we don't need to call resume_children recursively with a linked list in place
    // it's slightly more involved though as we have to account for `transparent` changing
    // through the tree.
    resume_children(child, transparent ? local : false);
    child = sibling;
  }

  if (effect.transitions !== null) {
    for (const transition of effect.transitions) {
      if (transition.is_global || local) {
        transition.in();
      }
    }
  }
}

/** @import { Derived, Effect, Reaction, Signal, Source, Value } from '#client' */

let is_updating_effect = false;

/** @param {boolean} value */
function set_is_updating_effect(value) {
  is_updating_effect = value;
}

let is_destroying_effect = false;

/** @param {boolean} value */
function set_is_destroying_effect(value) {
  is_destroying_effect = value;
}

/** @type {null | Reaction} */
let active_reaction = null;

let untracking = false;

/** @param {null | Reaction} reaction */
function set_active_reaction(reaction) {
  active_reaction = reaction;
}

/** @type {null | Effect} */
let active_effect = null;

/** @param {null | Effect} effect */
function set_active_effect(effect) {
  active_effect = effect;
}

/**
 * When sources are created within a reaction, reading and writing
 * them within that reaction should not cause a re-run
 * @type {null | Source[]}
 */
let current_sources = null;

/** @param {Value} value */
function push_reaction_value(value) {
  if (active_reaction !== null && true) {
    if (current_sources === null) {
      current_sources = [value];
    } else {
      current_sources.push(value);
    }
  }
}

/**
 * The dependencies of the reaction that is currently being executed. In many cases,
 * the dependencies are unchanged between runs, and so this will be `null` unless
 * and until a new dependency is accessed — we track this via `skipped_deps`
 * @type {null | Value[]}
 */
let new_deps = null;

let skipped_deps = 0;

/**
 * Tracks writes that the effect it's executed in doesn't listen to yet,
 * so that the dependency can be added to the effect later on if it then reads it
 * @type {null | Source[]}
 */
let untracked_writes = null;

/** @param {null | Source[]} value */
function set_untracked_writes(value) {
  untracked_writes = value;
}

/**
 * @type {number} Used by sources and deriveds for handling updates.
 * Version starts from 1 so that unowned deriveds differentiate between a created effect and a run one for tracing
 **/
let write_version = 1;

/** @type {number} Used to version each read of a source of derived to avoid duplicating depedencies inside a reaction */
let read_version = 0;

let update_version = read_version;

/** @param {number} value */
function set_update_version(value) {
  update_version = value;
}

// If we are working with a get() chain that has no active container,
// to prevent memory leaks, we skip adding the reaction.
let skip_reaction = false;

function increment_write_version() {
  return ++write_version;
}

/**
 * Determines whether a derived or effect is dirty.
 * If it is MAYBE_DIRTY, will set the status to CLEAN
 * @param {Reaction} reaction
 * @returns {boolean}
 */
function is_dirty(reaction) {
  var flags = reaction.f;

  if ((flags & DIRTY) !== 0) {
    return true;
  }

  if ((flags & MAYBE_DIRTY) !== 0) {
    var dependencies = reaction.deps;
    var is_unowned = (flags & UNOWNED) !== 0;

    if (dependencies !== null) {
      var i;
      var dependency;
      var is_disconnected = (flags & DISCONNECTED) !== 0;
      var is_unowned_connected =
        is_unowned && active_effect !== null && !skip_reaction;
      var length = dependencies.length;

      // If we are working with a disconnected or an unowned signal that is now connected (due to an active effect)
      // then we need to re-connect the reaction to the dependency, unless the effect has already been destroyed
      // (which can happen if the derived is read by an async derived)
      if (
        (is_disconnected || is_unowned_connected) &&
        (active_effect === null || (active_effect.f & DESTROYED) === 0)
      ) {
        var derived = /** @type {Derived} */ (reaction);
        var parent = derived.parent;

        for (i = 0; i < length; i++) {
          dependency = dependencies[i];

          // We always re-add all reactions (even duplicates) if the derived was
          // previously disconnected, however we don't if it was unowned as we
          // de-duplicate dependencies in that case
          if (is_disconnected || !dependency?.reactions?.includes(derived)) {
            (dependency.reactions ??= []).push(derived);
          }
        }

        if (is_disconnected) {
          derived.f ^= DISCONNECTED;
        }
        // If the unowned derived is now fully connected to the graph again (it's unowned and reconnected, has a parent
        // and the parent is not unowned), then we can mark it as connected again, removing the need for the unowned
        // flag
        if (
          is_unowned_connected &&
          parent !== null &&
          (parent.f & UNOWNED) === 0
        ) {
          derived.f ^= UNOWNED;
        }
      }

      for (i = 0; i < length; i++) {
        dependency = dependencies[i];

        if (is_dirty(/** @type {Derived} */ (dependency))) {
          update_derived(/** @type {Derived} */ (dependency));
        }

        if (dependency.wv > reaction.wv) {
          return true;
        }
      }
    }

    // Unowned signals should never be marked as clean unless they
    // are used within an active_effect without skip_reaction
    if (!is_unowned || (active_effect !== null && !skip_reaction)) {
      set_signal_status(reaction, CLEAN);
    }
  }

  return false;
}

/**
 * @param {Value} signal
 * @param {Effect} effect
 * @param {boolean} [root]
 */
function schedule_possible_effect_self_invalidation(
  signal,
  effect,
  root = true,
) {
  var reactions = signal.reactions;
  if (reactions === null) return;

  if (current_sources?.includes(signal)) {
    return;
  }

  for (var i = 0; i < reactions.length; i++) {
    var reaction = reactions[i];

    if ((reaction.f & DERIVED) !== 0) {
      schedule_possible_effect_self_invalidation(
        /** @type {Derived} */ (reaction),
        effect,
        false,
      );
    } else if (effect === reaction) {
      if (root) {
        set_signal_status(reaction, DIRTY);
      } else if ((reaction.f & CLEAN) !== 0) {
        set_signal_status(reaction, MAYBE_DIRTY);
      }
      schedule_effect(/** @type {Effect} */ (reaction));
    }
  }
}

/** @param {Reaction} reaction */
function update_reaction(reaction) {
  var previous_deps = new_deps;
  var previous_skipped_deps = skipped_deps;
  var previous_untracked_writes = untracked_writes;
  var previous_reaction = active_reaction;
  var previous_skip_reaction = skip_reaction;
  var previous_sources = current_sources;
  var previous_component_context = component_context;
  var previous_untracking = untracking;
  var previous_update_version = update_version;

  var flags = reaction.f;

  new_deps = /** @type {null | Value[]} */ (null);
  skipped_deps = 0;
  untracked_writes = null;
  skip_reaction =
    (flags & UNOWNED) !== 0 &&
    (untracking || !is_updating_effect || active_reaction === null);
  active_reaction =
    (flags & (BRANCH_EFFECT | ROOT_EFFECT)) === 0 ? reaction : null;

  current_sources = null;
  set_component_context(reaction.ctx);
  untracking = false;
  update_version = ++read_version;

  if (reaction.ac !== null) {
    without_reactive_context(() => {
      /** @type {AbortController} */ (reaction.ac).abort(STALE_REACTION);
    });

    reaction.ac = null;
  }

  try {
    reaction.f |= REACTION_IS_UPDATING;
    var fn = /** @type {Function} */ (reaction.fn);
    var result = fn();
    var deps = reaction.deps;

    if (new_deps !== null) {
      var i;

      remove_reactions(reaction, skipped_deps);

      if (deps !== null && skipped_deps > 0) {
        deps.length = skipped_deps + new_deps.length;
        for (i = 0; i < new_deps.length; i++) {
          deps[skipped_deps + i] = new_deps[i];
        }
      } else {
        reaction.deps = deps = new_deps;
      }

      if (
        !skip_reaction ||
        // Deriveds that already have reactions can cleanup, so we still add them as reactions
        ((flags & DERIVED) !== 0 &&
          /** @type {import('#client').Derived} */ (reaction).reactions !==
            null)
      ) {
        for (i = skipped_deps; i < deps.length; i++) {
          (deps[i].reactions ??= []).push(reaction);
        }
      }
    } else if (deps !== null && skipped_deps < deps.length) {
      remove_reactions(reaction, skipped_deps);
      deps.length = skipped_deps;
    }

    // If we're inside an effect and we have untracked writes, then we need to
    // ensure that if any of those untracked writes result in re-invalidation
    // of the current effect, then that happens accordingly
    if (
      is_runes() &&
      untracked_writes !== null &&
      !untracking &&
      deps !== null &&
      (reaction.f & (DERIVED | MAYBE_DIRTY | DIRTY)) === 0
    ) {
      for (i = 0; i < /** @type {Source[]} */ (untracked_writes).length; i++) {
        schedule_possible_effect_self_invalidation(
          untracked_writes[i],
          /** @type {Effect} */ (reaction),
        );
      }
    }

    // If we are returning to an previous reaction then
    // we need to increment the read version to ensure that
    // any dependencies in this reaction aren't marked with
    // the same version
    if (previous_reaction !== null && previous_reaction !== reaction) {
      read_version++;

      if (untracked_writes !== null) {
        if (previous_untracked_writes === null) {
          previous_untracked_writes = untracked_writes;
        } else {
          previous_untracked_writes.push(
            .../** @type {Source[]} */ (untracked_writes),
          );
        }
      }
    }

    if ((reaction.f & ERROR_VALUE) !== 0) {
      reaction.f ^= ERROR_VALUE;
    }

    return result;
  } catch (error) {
    return handle_error(error);
  } finally {
    reaction.f ^= REACTION_IS_UPDATING;
    new_deps = previous_deps;
    skipped_deps = previous_skipped_deps;
    untracked_writes = previous_untracked_writes;
    active_reaction = previous_reaction;
    skip_reaction = previous_skip_reaction;
    current_sources = previous_sources;
    set_component_context(previous_component_context);
    untracking = previous_untracking;
    update_version = previous_update_version;
  }
}

/**
 * @template V
 * @param {Reaction} signal
 * @param {Value<V>} dependency
 * @returns {void}
 */
function remove_reaction(signal, dependency) {
  let reactions = dependency.reactions;
  if (reactions !== null) {
    var index = index_of.call(reactions, signal);
    if (index !== -1) {
      var new_length = reactions.length - 1;
      if (new_length === 0) {
        reactions = dependency.reactions = null;
      } else {
        // Swap with last element and then remove.
        reactions[index] = reactions[new_length];
        reactions.pop();
      }
    }
  }

  // If the derived has no reactions, then we can disconnect it from the graph,
  // allowing it to either reconnect in the future, or be GC'd by the VM.
  if (
    reactions === null &&
    (dependency.f & DERIVED) !== 0 &&
    // Destroying a child effect while updating a parent effect can cause a dependency to appear
    // to be unused, when in fact it is used by the currently-updating parent. Checking `new_deps`
    // allows us to skip the expensive work of disconnecting and immediately reconnecting it
    (new_deps === null || !new_deps.includes(dependency))
  ) {
    set_signal_status(dependency, MAYBE_DIRTY);
    // If we are working with a derived that is owned by an effect, then mark it as being
    // disconnected.
    if ((dependency.f & (UNOWNED | DISCONNECTED)) === 0) {
      dependency.f ^= DISCONNECTED;
    }
    // Disconnect any reactions owned by this reaction
    destroy_derived_effects(/** @type {Derived} **/ (dependency));
    remove_reactions(/** @type {Derived} **/ (dependency), 0);
  }
}

/**
 * @param {Reaction} signal
 * @param {number} start_index
 * @returns {void}
 */
function remove_reactions(signal, start_index) {
  var dependencies = signal.deps;
  if (dependencies === null) return;

  for (var i = start_index; i < dependencies.length; i++) {
    remove_reaction(signal, dependencies[i]);
  }
}

/**
 * @param {Effect} effect
 * @returns {void}
 */
function update_effect(effect) {
  var flags = effect.f;

  if ((flags & DESTROYED) !== 0) {
    return;
  }

  set_signal_status(effect, CLEAN);

  var previous_effect = active_effect;
  var was_updating_effect = is_updating_effect;

  active_effect = effect;
  is_updating_effect = true;

  {
    var previous_component_fn = dev_current_component_function;
    set_dev_current_component_function(effect.component_function);
    var previous_stack = /** @type {any} */ (dev_stack);
    // only block effects have a dev stack, keep the current one otherwise
    set_dev_stack(effect.dev_stack ?? dev_stack);
  }

  try {
    if ((flags & BLOCK_EFFECT) !== 0) {
      destroy_block_effect_children(effect);
    } else {
      destroy_effect_children(effect);
    }

    execute_effect_teardown(effect);
    var teardown = update_reaction(effect);
    effect.teardown = typeof teardown === "function" ? teardown : null;
    effect.wv = write_version;

    // In DEV, increment versions of any sources that were written to during the effect,
    // so that they are correctly marked as dirty when the effect re-runs
    var dep;
    if (
      DEV &&
      tracing_mode_flag &&
      (effect.f & DIRTY) !== 0 &&
      effect.deps !== null
    );
  } finally {
    is_updating_effect = was_updating_effect;
    active_effect = previous_effect;

    {
      set_dev_current_component_function(previous_component_fn);
      set_dev_stack(previous_stack);
    }
  }
}

/**
 * @template V
 * @param {Value<V>} signal
 * @returns {V}
 */
function get$2(signal) {
  var flags = signal.f;
  var is_derived = (flags & DERIVED) !== 0;

  // Register the dependency on the current reaction signal.
  if (active_reaction !== null && !untracking) {
    // if we're in a derived that is being read inside an _async_ derived,
    // it's possible that the effect was already destroyed. In this case,
    // we don't add the dependency, because that would create a memory leak
    var destroyed =
      active_effect !== null && (active_effect.f & DESTROYED) !== 0;

    if (!destroyed && !current_sources?.includes(signal)) {
      var deps = active_reaction.deps;

      if ((active_reaction.f & REACTION_IS_UPDATING) !== 0) {
        // we're in the effect init/update cycle
        if (signal.rv < read_version) {
          signal.rv = read_version;

          // If the signal is accessing the same dependencies in the same
          // order as it did last time, increment `skipped_deps`
          // rather than updating `new_deps`, which creates GC cost
          if (
            new_deps === null &&
            deps !== null &&
            deps[skipped_deps] === signal
          ) {
            skipped_deps++;
          } else if (new_deps === null) {
            new_deps = [signal];
          } else if (!skip_reaction || !new_deps.includes(signal)) {
            // Normally we can push duplicated dependencies to `new_deps`, but if we're inside
            // an unowned derived because skip_reaction is true, then we need to ensure that
            // we don't have duplicates
            new_deps.push(signal);
          }
        }
      } else {
        // we're adding a dependency outside the init/update cycle
        // (i.e. after an `await`)
        (active_reaction.deps ??= []).push(signal);

        var reactions = signal.reactions;

        if (reactions === null) {
          signal.reactions = [active_reaction];
        } else if (!reactions.includes(active_reaction)) {
          reactions.push(active_reaction);
        }
      }
    }
  } else if (
    is_derived &&
    /** @type {Derived} */ (signal).deps === null &&
    /** @type {Derived} */ (signal).effects === null
  ) {
    var derived = /** @type {Derived} */ (signal);
    var parent = derived.parent;

    if (parent !== null && (parent.f & UNOWNED) === 0) {
      // If the derived is owned by another derived then mark it as unowned
      // as the derived value might have been referenced in a different context
      // since and thus its parent might not be its true owner anymore
      derived.f ^= UNOWNED;
    }
  }

  {
    if (current_async_effect) {
      var tracking = (current_async_effect.f & REACTION_IS_UPDATING) !== 0;
      var was_read = current_async_effect.deps?.includes(signal);

      if (!tracking && !untracking && !was_read) {
        await_reactivity_loss(/** @type {string} */ (signal.label));

        var trace = get_stack("TracedAt");
        // eslint-disable-next-line no-console
        if (trace) console.warn(trace);
      }
    }

    recent_async_deriveds.delete(signal);
  }

  if (is_destroying_effect) {
    if (old_values.has(signal)) {
      return old_values.get(signal);
    }

    if (is_derived) {
      derived = /** @type {Derived} */ (signal);

      var value = derived.v;

      // if the derived is dirty and has reactions, or depends on the values that just changed, re-execute
      // (a derived can be maybe_dirty due to the effect destroy removing its last reaction)
      if (
        ((derived.f & CLEAN) === 0 && derived.reactions !== null) ||
        depends_on_old_values(derived)
      ) {
        value = execute_derived(derived);
      }

      old_values.set(derived, value);

      return value;
    }
  } else if (is_derived) {
    derived = /** @type {Derived} */ (signal);

    if (batch_deriveds?.has(derived)) {
      return batch_deriveds.get(derived);
    }

    if (is_dirty(derived)) {
      update_derived(derived);
    }
  }

  if ((signal.f & ERROR_VALUE) !== 0) {
    throw signal.v;
  }

  return signal.v;
}

/** @param {Derived} derived */
function depends_on_old_values(derived) {
  if (derived.v === UNINITIALIZED) return true; // we don't know, so assume the worst
  if (derived.deps === null) return false;

  for (const dep of derived.deps) {
    if (old_values.has(dep)) {
      return true;
    }

    if (
      (dep.f & DERIVED) !== 0 &&
      depends_on_old_values(/** @type {Derived} */ (dep))
    ) {
      return true;
    }
  }

  return false;
}

/**
 * When used inside a [`$derived`](https://svelte.dev/docs/svelte/$derived) or [`$effect`](https://svelte.dev/docs/svelte/$effect),
 * any state read inside `fn` will not be treated as a dependency.
 *
 * ```ts
 * $effect(() => {
 *   // this will run when `data` changes, but not when `time` changes
 *   save(data, {
 *     timestamp: untrack(() => time)
 *   });
 * });
 * ```
 * @template T
 * @param {() => T} fn
 * @returns {T}
 */
function untrack(fn) {
  var previous_untracking = untracking;
  try {
    untracking = true;
    return fn();
  } finally {
    untracking = previous_untracking;
  }
}

const STATUS_MASK = -7169;

/**
 * @param {Signal} signal
 * @param {number} status
 * @returns {void}
 */
function set_signal_status(signal, status) {
  signal.f = (signal.f & STATUS_MASK) | status;
}

/**
 * Possibly traverse an object and read all its properties so that they're all reactive in case this is `$state`.
 * Does only check first level of an object for performance reasons (heuristic should be good for 99% of all cases).
 * @param {any} value
 * @returns {void}
 */
function deep_read_state(value) {
  if (typeof value !== "object" || !value || value instanceof EventTarget) {
    return;
  }

  if (STATE_SYMBOL in value) {
    deep_read(value);
  } else if (!Array.isArray(value)) {
    for (let key in value) {
      const prop = value[key];
      if (typeof prop === "object" && prop && STATE_SYMBOL in prop) {
        deep_read(prop);
      }
    }
  }
}

/**
 * Deeply traverse an object and read all its properties
 * so that they're all reactive in case this is `$state`
 * @param {any} value
 * @param {Set<any>} visited
 * @returns {void}
 */
function deep_read(value, visited = new Set()) {
  if (
    typeof value === "object" &&
    value !== null &&
    // We don't want to traverse DOM elements
    !(value instanceof EventTarget) &&
    !visited.has(value)
  ) {
    visited.add(value);
    // When working with a possible SvelteDate, this
    // will ensure we capture changes to it.
    if (value instanceof Date) {
      value.getTime();
    }
    for (let key in value) {
      try {
        deep_read(value[key], visited);
      } catch (e) {
        // continue
      }
    }
    const proto = get_prototype_of(value);
    if (
      proto !== Object.prototype &&
      proto !== Array.prototype &&
      proto !== Map.prototype &&
      proto !== Set.prototype &&
      proto !== Date.prototype
    ) {
      const descriptors = get_descriptors(proto);
      for (let key in descriptors) {
        const get = descriptors[key].get;
        if (get) {
          try {
            get.call(value);
          } catch (e) {
            // continue
          }
        }
      }
    }
  }
}

/** @type {Set<string>} */
const all_registered_events = new Set();

/** @type {Set<(events: Array<string>) => void>} */
const root_event_handles = new Set();

/**
 * @param {string} event_name
 * @param {EventTarget} dom
 * @param {EventListener} [handler]
 * @param {AddEventListenerOptions} [options]
 */
function create_event(event_name, dom, handler, options = {}) {
  /**
   * @this {EventTarget}
   */
  function target_handler(/** @type {Event} */ event) {
    if (!options.capture) {
      // Only call in the bubble phase, else delegated events would be called before the capturing events
      handle_event_propagation.call(dom, event);
    }
    if (!event.cancelBubble) {
      return without_reactive_context(() => {
        return handler?.call(this, event);
      });
    }
  }

  // Chrome has a bug where pointer events don't work when attached to a DOM element that has been cloned
  // with cloneNode() and the DOM element is disconnected from the document. To ensure the event works, we
  // defer the attachment till after it's been appended to the document. TODO: remove this once Chrome fixes
  // this bug. The same applies to wheel events and touch events.
  if (
    event_name.startsWith("pointer") ||
    event_name.startsWith("touch") ||
    event_name === "wheel"
  ) {
    queue_micro_task(() => {
      dom.addEventListener(event_name, target_handler, options);
    });
  } else {
    dom.addEventListener(event_name, target_handler, options);
  }

  return target_handler;
}

/**
 * @param {string} event_name
 * @param {Element} dom
 * @param {EventListener} [handler]
 * @param {boolean} [capture]
 * @param {boolean} [passive]
 * @returns {void}
 */
function event(event_name, dom, handler, capture, passive) {
  var options = { capture, passive };
  var target_handler = create_event(event_name, dom, handler, options);

  if (
    dom === document.body ||
    // @ts-ignore
    dom === window ||
    // @ts-ignore
    dom === document ||
    // Firefox has quirky behavior, it can happen that we still get "canplay" events when the element is already removed
    dom instanceof HTMLMediaElement
  ) {
    teardown(() => {
      dom.removeEventListener(event_name, target_handler, options);
    });
  }
}

/**
 * @param {Array<string>} events
 * @returns {void}
 */
function delegate(events) {
  for (var i = 0; i < events.length; i++) {
    all_registered_events.add(events[i]);
  }

  for (var fn of root_event_handles) {
    fn(events);
  }
}

// used to store the reference to the currently propagated event
// to prevent garbage collection between microtasks in Firefox
// If the event object is GCed too early, the expando __root property
// set on the event object is lost, causing the event delegation
// to process the event twice
let last_propagated_event = null;

/**
 * @this {EventTarget}
 * @param {Event} event
 * @returns {void}
 */
function handle_event_propagation(event) {
  var handler_element = this;
  var owner_document = /** @type {Node} */ (handler_element).ownerDocument;
  var event_name = event.type;
  var path = event.composedPath?.() || [];
  var current_target = /** @type {null | Element} */ (path[0] || event.target);

  last_propagated_event = event;

  // composedPath contains list of nodes the event has propagated through.
  // We check __root to skip all nodes below it in case this is a
  // parent of the __root node, which indicates that there's nested
  // mounted apps. In this case we don't want to trigger events multiple times.
  var path_idx = 0;

  // the `last_propagated_event === event` check is redundant, but
  // without it the variable will be DCE'd and things will
  // fail mysteriously in Firefox
  // @ts-expect-error is added below
  var handled_at = last_propagated_event === event && event.__root;

  if (handled_at) {
    var at_idx = path.indexOf(handled_at);
    if (
      at_idx !== -1 &&
      (handler_element === document ||
        handler_element === /** @type {any} */ (window))
    ) {
      // This is the fallback document listener or a window listener, but the event was already handled
      // -> ignore, but set handle_at to document/window so that we're resetting the event
      // chain in case someone manually dispatches the same event object again.
      // @ts-expect-error
      event.__root = handler_element;
      return;
    }

    // We're deliberately not skipping if the index is higher, because
    // someone could create an event programmatically and emit it multiple times,
    // in which case we want to handle the whole propagation chain properly each time.
    // (this will only be a false negative if the event is dispatched multiple times and
    // the fallback document listener isn't reached in between, but that's super rare)
    var handler_idx = path.indexOf(handler_element);
    if (handler_idx === -1) {
      // handle_idx can theoretically be -1 (happened in some JSDOM testing scenarios with an event listener on the window object)
      // so guard against that, too, and assume that everything was handled at this point.
      return;
    }

    if (at_idx <= handler_idx) {
      path_idx = at_idx;
    }
  }

  current_target = /** @type {Element} */ (path[path_idx] || event.target);
  // there can only be one delegated event per element, and we either already handled the current target,
  // or this is the very first target in the chain which has a non-delegated listener, in which case it's safe
  // to handle a possible delegated event on it later (through the root delegation listener for example).
  if (current_target === handler_element) return;

  // Proxy currentTarget to correct target
  define_property(event, "currentTarget", {
    configurable: true,
    get() {
      return current_target || owner_document;
    },
  });

  // This started because of Chromium issue https://chromestatus.com/feature/5128696823545856,
  // where removal or moving of of the DOM can cause sync `blur` events to fire, which can cause logic
  // to run inside the current `active_reaction`, which isn't what we want at all. However, on reflection,
  // it's probably best that all event handled by Svelte have this behaviour, as we don't really want
  // an event handler to run in the context of another reaction or effect.
  var previous_reaction = active_reaction;
  var previous_effect = active_effect;
  set_active_reaction(null);
  set_active_effect(null);

  try {
    /**
     * @type {unknown}
     */
    var throw_error;
    /**
     * @type {unknown[]}
     */
    var other_errors = [];

    while (current_target !== null) {
      /** @type {null | Element} */
      var parent_element =
        current_target.assignedSlot ||
        current_target.parentNode ||
        /** @type {any} */ (current_target).host ||
        null;

      try {
        // @ts-expect-error
        var delegated = current_target["__" + event_name];

        if (
          delegated != null &&
          (!(/** @type {any} */ (current_target).disabled) ||
            // DOM could've been updated already by the time this is reached, so we check this as well
            // -> the target could not have been disabled because it emits the event in the first place
            event.target === current_target)
        ) {
          if (is_array(delegated)) {
            var [fn, ...data] = delegated;
            fn.apply(current_target, [event, ...data]);
          } else {
            delegated.call(current_target, event);
          }
        }
      } catch (error) {
        if (throw_error) {
          other_errors.push(error);
        } else {
          throw_error = error;
        }
      }
      if (
        event.cancelBubble ||
        parent_element === handler_element ||
        parent_element === null
      ) {
        break;
      }
      current_target = parent_element;
    }

    if (throw_error) {
      for (let error of other_errors) {
        // Throw the rest of the errors, one-by-one on a microtask
        queueMicrotask(() => {
          throw error;
        });
      }
      throw throw_error;
    }
  } finally {
    // @ts-expect-error is used above
    event.__root = handler_element;
    // @ts-ignore remove proxy on currentTarget
    delete event.currentTarget;
    set_active_reaction(previous_reaction);
    set_active_effect(previous_effect);
  }
}

/**
 * In dev, warn if an event handler is not a function, as it means the
 * user probably called the handler or forgot to add a `() =>`
 * @param {() => (event: Event, ...args: any) => void} thunk
 * @param {EventTarget} element
 * @param {[Event, ...any]} args
 * @param {any} component
 * @param {[number, number]} [loc]
 * @param {boolean} [remove_parens]
 */
function apply(
  thunk,
  element,
  args,
  component,
  loc,
  has_side_effects = false,
  remove_parens = false,
) {
  let handler;
  let error;

  try {
    handler = thunk();
  } catch (e) {
    error = e;
  }

  if (
    typeof handler !== "function" &&
    (has_side_effects || handler != null || error)
  ) {
    const filename = component?.[FILENAME];
    const location = loc
      ? ` at ${filename}:${loc[0]}:${loc[1]}`
      : ` in ${filename}`;
    const phase = args[0]?.eventPhase < Event.BUBBLING_PHASE ? "capture" : "";
    const event_name = args[0]?.type + phase;
    const description = `\`${event_name}\` handler${location}`;
    const suggestion = remove_parens
      ? "remove the trailing `()`"
      : "add a leading `() =>`";

    event_handler_invalid(description, suggestion);

    if (error) {
      throw error;
    }
  }
  handler?.apply(element, args);
}

/** @param {string} html */
function create_fragment_from_html(html) {
  var elem = document.createElement("template");
  elem.innerHTML = html.replaceAll("<!>", "<!---->"); // XHTML compliance
  return elem.content;
}

/** @import { Effect, TemplateNode } from '#client' */
/** @import { TemplateStructure } from './types' */

/**
 * @param {TemplateNode} start
 * @param {TemplateNode | null} end
 */
function assign_nodes(start, end) {
  var effect = /** @type {Effect} */ (active_effect);
  if (effect.nodes_start === null) {
    effect.nodes_start = start;
    effect.nodes_end = end;
  }
}

/**
 * @param {string} content
 * @param {number} flags
 * @returns {() => Node | Node[]}
 */
/*#__NO_SIDE_EFFECTS__*/
function from_html(content, flags) {
  var is_fragment = (flags & TEMPLATE_FRAGMENT) !== 0;
  var use_import_node = (flags & TEMPLATE_USE_IMPORT_NODE) !== 0;

  /** @type {Node} */
  var node;

  /**
   * Whether or not the first item is a text/element node. If not, we need to
   * create an additional comment node to act as `effect.nodes.start`
   */
  var has_start = !content.startsWith("<!>");

  return () => {
    if (hydrating) {
      assign_nodes(hydrate_node, null);
      return hydrate_node;
    }

    if (node === undefined) {
      node = create_fragment_from_html(has_start ? content : "<!>" + content);
      if (!is_fragment) node = /** @type {Node} */ (get_first_child(node));
    }

    var clone = /** @type {TemplateNode} */ (
      use_import_node || is_firefox
        ? document.importNode(node, true)
        : node.cloneNode(true)
    );

    if (is_fragment) {
      var start = /** @type {TemplateNode} */ (get_first_child(clone));
      var end = /** @type {TemplateNode} */ (clone.lastChild);

      assign_nodes(start, end);
    } else {
      assign_nodes(clone, clone);
    }

    return clone;
  };
}

/**
 * @param {string} content
 * @param {number} flags
 * @param {'svg' | 'math'} ns
 * @returns {() => Node | Node[]}
 */
/*#__NO_SIDE_EFFECTS__*/
function from_namespace(content, flags, ns = "svg") {
  /**
   * Whether or not the first item is a text/element node. If not, we need to
   * create an additional comment node to act as `effect.nodes.start`
   */
  var has_start = !content.startsWith("<!>");

  var is_fragment = (flags & TEMPLATE_FRAGMENT) !== 0;
  var wrapped = `<${ns}>${has_start ? content : "<!>" + content}</${ns}>`;

  /** @type {Element | DocumentFragment} */
  var node;

  return () => {
    if (hydrating) {
      assign_nodes(hydrate_node, null);
      return hydrate_node;
    }

    if (!node) {
      var fragment = /** @type {DocumentFragment} */ (
        create_fragment_from_html(wrapped)
      );
      var root = /** @type {Element} */ (get_first_child(fragment));

      if (is_fragment) {
        node = document.createDocumentFragment();
        while (get_first_child(root)) {
          node.appendChild(/** @type {Node} */ (get_first_child(root)));
        }
      } else {
        node = /** @type {Element} */ (get_first_child(root));
      }
    }

    var clone = /** @type {TemplateNode} */ (node.cloneNode(true));

    if (is_fragment) {
      var start = /** @type {TemplateNode} */ (get_first_child(clone));
      var end = /** @type {TemplateNode} */ (clone.lastChild);

      assign_nodes(start, end);
    } else {
      assign_nodes(clone, clone);
    }

    return clone;
  };
}

/**
 * @param {string} content
 * @param {number} flags
 */
/*#__NO_SIDE_EFFECTS__*/
function from_svg(content, flags) {
  return from_namespace(content, flags, "svg");
}

/**
 * Don't mark this as side-effect-free, hydration needs to walk all nodes
 * @param {any} value
 */
function text(value = "") {
  if (!hydrating) {
    var t = create_text(value + "");
    assign_nodes(t, t);
    return t;
  }

  var node = hydrate_node;

  if (node.nodeType !== TEXT_NODE) {
    // if an {expression} is empty during SSR, we need to insert an empty text node
    node.before((node = create_text()));
    set_hydrate_node(node);
  }

  assign_nodes(node, node);
  return node;
}

function comment() {
  // we're not delegating to `template` here for performance reasons
  if (hydrating) {
    assign_nodes(hydrate_node, null);
    return hydrate_node;
  }

  var frag = document.createDocumentFragment();
  var start = document.createComment("");
  var anchor = create_text();
  frag.append(start, anchor);

  assign_nodes(start, anchor);

  return frag;
}

/**
 * Assign the created (or in hydration mode, traversed) dom elements to the current block
 * and insert the elements into the dom (in client mode).
 * @param {Text | Comment | Element} anchor
 * @param {DocumentFragment | Element} dom
 */
function append$2(anchor, dom) {
  if (hydrating) {
    /** @type {Effect} */ (active_effect).nodes_end = hydrate_node;
    hydrate_next();
    return;
  }

  if (anchor === null) {
    // edge case — void `<svelte:element>` with content
    return;
  }

  anchor.before(/** @type {Node} */ (dom));
}

/**
 * Create (or hydrate) an unique UID for the component instance.
 */
function props_id() {
  if (
    hydrating &&
    hydrate_node &&
    hydrate_node.nodeType === COMMENT_NODE &&
    hydrate_node.textContent?.startsWith(`#`)
  ) {
    const id = hydrate_node.textContent.substring(1);
    hydrate_next();
    return id;
  }

  // @ts-expect-error This way we ensure the id is unique even across Svelte runtimes
  (window.__svelte ??= {}).uid ??= 1;

  // @ts-expect-error
  return `c${window.__svelte.uid++}`;
}

/**
 * @param {string} name
 */
function is_capture_event(name) {
  return (
    name.endsWith("capture") &&
    name !== "gotpointercapture" &&
    name !== "lostpointercapture"
  );
}

/** List of Element events that will be delegated */
const DELEGATED_EVENTS = [
  "beforeinput",
  "click",
  "change",
  "dblclick",
  "contextmenu",
  "focusin",
  "focusout",
  "input",
  "keydown",
  "keyup",
  "mousedown",
  "mousemove",
  "mouseout",
  "mouseover",
  "mouseup",
  "pointerdown",
  "pointermove",
  "pointerout",
  "pointerover",
  "pointerup",
  "touchend",
  "touchmove",
  "touchstart",
];

/**
 * Returns `true` if `event_name` is a delegated event
 * @param {string} event_name
 */
function is_delegated(event_name) {
  return DELEGATED_EVENTS.includes(event_name);
}

/**
 * @type {Record<string, string>}
 * List of attribute names that should be aliased to their property names
 * because they behave differently between setting them as an attribute and
 * setting them as a property.
 */
const ATTRIBUTE_ALIASES = {
  // no `class: 'className'` because we handle that separately
  formnovalidate: "formNoValidate",
  ismap: "isMap",
  nomodule: "noModule",
  playsinline: "playsInline",
  readonly: "readOnly",
  defaultvalue: "defaultValue",
  defaultchecked: "defaultChecked",
  srcobject: "srcObject",
  novalidate: "noValidate",
  allowfullscreen: "allowFullscreen",
  disablepictureinpicture: "disablePictureInPicture",
  disableremoteplayback: "disableRemotePlayback",
};

/**
 * @param {string} name
 */
function normalize_attribute(name) {
  name = name.toLowerCase();
  return ATTRIBUTE_ALIASES[name] ?? name;
}

/**
 * Subset of delegated events which should be passive by default.
 * These two are already passive via browser defaults on window, document and body.
 * But since
 * - we're delegating them
 * - they happen often
 * - they apply to mobile which is generally less performant
 * we're marking them as passive by default for other elements, too.
 */
const PASSIVE_EVENTS = ["touchstart", "touchmove"];

/**
 * Returns `true` if `name` is a passive event
 * @param {string} name
 */
function is_passive_event(name) {
  return PASSIVE_EVENTS.includes(name);
}

/**
 * Prevent devtools trying to make `location` a clickable link by inserting a zero-width space
 * @template {string | undefined} T
 * @param {T} location
 * @returns {T};
 */
function sanitize_location(location) {
  return /** @type {T} */ (location?.replace(/\//g, "/\u200b"));
}

/** @import { ComponentContext, Effect, TemplateNode } from '#client' */
/** @import { Component, ComponentType, SvelteComponent, MountOptions } from '../../index.js' */

/**
 * @param {Element} text
 * @param {string} value
 * @returns {void}
 */
function set_text(text, value) {
  // For objects, we apply string coercion (which might make things like $state array references in the template reactive) before diffing
  var str = value == null ? "" : typeof value === "object" ? value + "" : value;
  // @ts-expect-error
  if (str !== (text.__t ??= text.nodeValue)) {
    // @ts-expect-error
    text.__t = str;
    text.nodeValue = str + "";
  }
}

/**
 * Mounts a component to the given target and returns the exports and potentially the props (if compiled with `accessors: true`) of the component.
 * Transitions will play during the initial render unless the `intro` option is set to `false`.
 *
 * @template {Record<string, any>} Props
 * @template {Record<string, any>} Exports
 * @param {ComponentType<SvelteComponent<Props>> | Component<Props, Exports, any>} component
 * @param {MountOptions<Props>} options
 * @returns {Exports}
 */
function mount(component, options) {
  return _mount(component, options);
}

/**
 * Hydrates a component on the given target and returns the exports and potentially the props (if compiled with `accessors: true`) of the component
 *
 * @template {Record<string, any>} Props
 * @template {Record<string, any>} Exports
 * @param {ComponentType<SvelteComponent<Props>> | Component<Props, Exports, any>} component
 * @param {{} extends Props ? {
 * 		target: Document | Element | ShadowRoot;
 * 		props?: Props;
 * 		events?: Record<string, (e: any) => any>;
 *  	context?: Map<any, any>;
 * 		intro?: boolean;
 * 		recover?: boolean;
 * 	} : {
 * 		target: Document | Element | ShadowRoot;
 * 		props: Props;
 * 		events?: Record<string, (e: any) => any>;
 *  	context?: Map<any, any>;
 * 		intro?: boolean;
 * 		recover?: boolean;
 * 	}} options
 * @returns {Exports}
 */
function hydrate(component, options) {
  init_operations();
  options.intro = options.intro ?? false;
  const target = options.target;
  const was_hydrating = hydrating;
  const previous_hydrate_node = hydrate_node;

  try {
    var anchor = /** @type {TemplateNode} */ (get_first_child(target));
    while (
      anchor &&
      (anchor.nodeType !== COMMENT_NODE ||
        /** @type {Comment} */ (anchor).data !== HYDRATION_START)
    ) {
      anchor = /** @type {TemplateNode} */ (get_next_sibling(anchor));
    }

    if (!anchor) {
      throw HYDRATION_ERROR;
    }

    set_hydrating(true);
    set_hydrate_node(/** @type {Comment} */ (anchor));
    hydrate_next();

    const instance = _mount(component, { ...options, anchor });

    if (
      hydrate_node === null ||
      hydrate_node.nodeType !== COMMENT_NODE ||
      /** @type {Comment} */ (hydrate_node).data !== HYDRATION_END
    ) {
      hydration_mismatch();
      throw HYDRATION_ERROR;
    }

    set_hydrating(false);

    return /**  @type {Exports} */ (instance);
  } catch (error) {
    // re-throw Svelte errors - they are certainly not related to hydration
    if (
      error instanceof Error &&
      error.message
        .split("\n")
        .some((line) => line.startsWith("https://svelte.dev/e/"))
    ) {
      throw error;
    }
    if (error !== HYDRATION_ERROR) {
      // eslint-disable-next-line no-console
      console.warn("Failed to hydrate: ", error);
    }

    if (options.recover === false) {
      hydration_failed();
    }

    // If an error occured above, the operations might not yet have been initialised.
    init_operations();
    clear_text_content(target);

    set_hydrating(false);
    return mount(component, options);
  } finally {
    set_hydrating(was_hydrating);
    set_hydrate_node(previous_hydrate_node);
  }
}

/** @type {Map<string, number>} */
const document_listeners = new Map();

/**
 * @template {Record<string, any>} Exports
 * @param {ComponentType<SvelteComponent<any>> | Component<any>} Component
 * @param {MountOptions} options
 * @returns {Exports}
 */
function _mount(
  Component,
  { target, anchor, props = {}, events, context, intro = true },
) {
  init_operations();

  /** @type {Set<string>} */
  var registered_events = new Set();

  /** @param {Array<string>} events */
  var event_handle = (events) => {
    for (var i = 0; i < events.length; i++) {
      var event_name = events[i];

      if (registered_events.has(event_name)) continue;
      registered_events.add(event_name);

      var passive = is_passive_event(event_name);

      // Add the event listener to both the container and the document.
      // The container listener ensures we catch events from within in case
      // the outer content stops propagation of the event.
      target.addEventListener(event_name, handle_event_propagation, {
        passive,
      });

      var n = document_listeners.get(event_name);

      if (n === undefined) {
        // The document listener ensures we catch events that originate from elements that were
        // manually moved outside of the container (e.g. via manual portals).
        document.addEventListener(event_name, handle_event_propagation, {
          passive,
        });
        document_listeners.set(event_name, 1);
      } else {
        document_listeners.set(event_name, n + 1);
      }
    }
  };

  event_handle(array_from(all_registered_events));
  root_event_handles.add(event_handle);

  /** @type {Exports} */
  // @ts-expect-error will be defined because the render effect runs synchronously
  var component = undefined;

  var unmount = component_root(() => {
    var anchor_node = anchor ?? target.appendChild(create_text());

    branch(() => {
      if (context) {
        push({});
        var ctx = /** @type {ComponentContext} */ (component_context);
        ctx.c = context;
      }

      if (events) {
        // We can't spread the object or else we'd lose the state proxy stuff, if it is one
        /** @type {any} */ (props).$$events = events;
      }

      if (hydrating) {
        assign_nodes(/** @type {TemplateNode} */ (anchor_node), null);
      }
      // @ts-expect-error the public typings are not what the actual function looks like
      component = Component(anchor_node, props) || {};

      if (hydrating) {
        /** @type {Effect} */ (active_effect).nodes_end = hydrate_node;
      }

      if (context) {
        pop();
      }
    });

    return () => {
      for (var event_name of registered_events) {
        target.removeEventListener(event_name, handle_event_propagation);

        var n = /** @type {number} */ (document_listeners.get(event_name));

        if (--n === 0) {
          document.removeEventListener(event_name, handle_event_propagation);
          document_listeners.delete(event_name);
        } else {
          document_listeners.set(event_name, n);
        }
      }

      root_event_handles.delete(event_handle);

      if (anchor_node !== anchor) {
        anchor_node.parentNode?.removeChild(anchor_node);
      }
    };
  });

  mounted_components.set(component, unmount);
  return component;
}

/**
 * References of the components that were mounted or hydrated.
 * Uses a `WeakMap` to avoid memory leaks.
 */
let mounted_components = new WeakMap();

/**
 * @template {(...args: any[]) => unknown} T
 * @param {T} fn
 */
function prevent_snippet_stringification(fn) {
  fn.toString = () => {
    snippet_without_render_tag();
    return "";
  };
  return fn;
}

/** @import { Snippet } from 'svelte' */
/** @import { Effect, TemplateNode } from '#client' */
/** @import { Getters } from '#shared' */

/**
 * @template {(node: TemplateNode, ...args: any[]) => void} SnippetFn
 * @param {TemplateNode} node
 * @param {() => SnippetFn | null | undefined} get_snippet
 * @param {(() => any)[]} args
 * @returns {void}
 */
function snippet(node, get_snippet, ...args) {
  var anchor = node;

  /** @type {SnippetFn | null | undefined} */
  // @ts-ignore
  var snippet = noop$4;

  /** @type {Effect | null} */
  var snippet_effect;

  block(() => {
    if (snippet === (snippet = get_snippet())) return;

    if (snippet_effect) {
      destroy_effect(snippet_effect);
      snippet_effect = null;
    }

    if (snippet == null) {
      invalid_snippet();
    }

    snippet_effect = branch(() =>
      /** @type {SnippetFn} */ (snippet)(anchor, ...args),
    );
  }, EFFECT_TRANSPARENT);

  if (hydrating) {
    anchor = hydrate_node;
  }
}

/**
 * In development, wrap the snippet function so that it passes validation, and so that the
 * correct component context is set for ownership checks
 * @param {any} component
 * @param {(node: TemplateNode, ...args: any[]) => void} fn
 */
function wrap_snippet(component, fn) {
  const snippet = (
    /** @type {TemplateNode} */ node,
    /** @type {any[]} */ ...args
  ) => {
    var previous_component_function = dev_current_component_function;
    set_dev_current_component_function(component);

    try {
      return fn(node, ...args);
    } finally {
      set_dev_current_component_function(previous_component_function);
    }
  };

  prevent_snippet_stringification(snippet);

  return snippet;
}

/** @import { ComponentContext, ComponentContextLegacy } from '#client' */
/** @import { EventDispatcher } from './index.js' */
/** @import { NotFunction } from './internal/types.js' */

{
  /**
   * @param {string} rune
   */
  function throw_rune_error(rune) {
    if (!(rune in globalThis)) {
      // TODO if people start adjusting the "this can contain runes" config through v-p-s more, adjust this message
      /** @type {any} */
      let value; // let's hope noone modifies this global, but belts and braces
      Object.defineProperty(globalThis, rune, {
        configurable: true,
        // eslint-disable-next-line getter-return
        get: () => {
          if (value !== undefined) {
            return value;
          }

          rune_outside_svelte(rune);
        },
        set: (v) => {
          value = v;
        },
      });
    }
  }

  throw_rune_error("$state");
  throw_rune_error("$effect");
  throw_rune_error("$derived");
  throw_rune_error("$inspect");
  throw_rune_error("$props");
  throw_rune_error("$bindable");
}

/**
 *
 * @param {any} a
 * @param {any} b
 * @param {string} property
 * @param {string} location
 */
function compare(a, b, property, location) {
  if (a !== b) {
    assignment_value_stale(
      property,
      /** @type {string} */ (sanitize_location(location)),
    );
  }

  return a;
}

/**
 * @param {any} object
 * @param {string} property
 * @param {any} value
 * @param {string} location
 */
function assign(object, property, value, location) {
  return compare(
    (object[property] = value),
    untrack(() => object[property]),
    property,
    location,
  );
}

/** @import { SourceLocation } from '#client' */

/**
 * @param {any} fn
 * @param {string} filename
 * @param {SourceLocation[]} locations
 * @returns {any}
 */
function add_locations(fn, filename, locations) {
  return (/** @type {any[]} */ ...args) => {
    const dom = fn(...args);

    var node = hydrating
      ? dom
      : dom.nodeType === DOCUMENT_FRAGMENT_NODE
        ? dom.firstChild
        : dom;
    assign_locations(node, filename, locations);

    return dom;
  };
}

/**
 * @param {Element} element
 * @param {string} filename
 * @param {SourceLocation} location
 */
function assign_location(element, filename, location) {
  // @ts-expect-error
  element.__svelte_meta = {
    parent: dev_stack,
    loc: { file: filename, line: location[0], column: location[1] },
  };

  if (location[2]) {
    assign_locations(element.firstChild, filename, location[2]);
  }
}

/**
 * @param {Node | null} node
 * @param {string} filename
 * @param {SourceLocation[]} locations
 */
function assign_locations(node, filename, locations) {
  var i = 0;
  var depth = 0;

  while (node && i < locations.length) {
    if (hydrating && node.nodeType === COMMENT_NODE) {
      var comment = /** @type {Comment} */ (node);
      if (
        comment.data === HYDRATION_START ||
        comment.data === HYDRATION_START_ELSE
      )
        depth += 1;
      else if (comment.data[0] === HYDRATION_END) depth -= 1;
    }

    if (depth === 0 && node.nodeType === ELEMENT_NODE) {
      assign_location(/** @type {Element} */ (node), filename, locations[i++]);
    }

    node = node.nextSibling;
  }
}

/** @typedef {{ file: string, line: number, column: number }} Location */

/**
 * Sets up a validator that
 * - traverses the path of a prop to find out if it is allowed to be mutated
 * - checks that the binding chain is not interrupted
 * @param {Record<string, any>} props
 */
function create_ownership_validator(props) {
  const component = component_context?.function;
  const parent = component_context?.p?.function;

  return {
    /**
     * @param {string} prop
     * @param {any[]} path
     * @param {any} result
     * @param {number} line
     * @param {number} column
     */
    mutation: (prop, path, result, line, column) => {
      const name = path[0];
      if (is_bound_or_unset(props, name) || !parent) {
        return result;
      }

      /** @type {any} */
      let value = props;

      for (let i = 0; i < path.length - 1; i++) {
        value = value[path[i]];
        if (!value?.[STATE_SYMBOL]) {
          return result;
        }
      }

      const location = sanitize_location(
        `${component[FILENAME]}:${line}:${column}`,
      );

      ownership_invalid_mutation(name, location, prop, parent[FILENAME]);

      return result;
    },
    /**
     * @param {any} key
     * @param {any} child_component
     * @param {() => any} value
     */
    binding: (key, child_component, value) => {
      if (!is_bound_or_unset(props, key) && parent && value()?.[STATE_SYMBOL]) {
        ownership_invalid_binding(
          component[FILENAME],
          key,
          child_component[FILENAME],
          parent[FILENAME],
        );
      }
    },
  };
}

/**
 * @param {Record<string, any>} props
 * @param {string} prop_name
 */
function is_bound_or_unset(props, prop_name) {
  // Can be the case when someone does `mount(Component, props)` with `let props = $state({...})`
  // or `createClassComponent(Component, props)`
  const is_entry_props = STATE_SYMBOL in props || LEGACY_PROPS in props;
  return (
    !!get_descriptor(props, prop_name)?.set ||
    (is_entry_props && prop_name in props) ||
    !(prop_name in props)
  );
}

/** @param {Function & { [FILENAME]: string }} target */
function check_target(target) {
  if (target) {
    component_api_invalid_new(target[FILENAME] ?? "a component", target.name);
  }
}

function legacy_api() {
  const component = component_context?.function;

  /** @param {string} method */
  function error(method) {
    component_api_changed(method, component[FILENAME]);
  }

  return {
    $destroy: () => error("$destroy()"),
    $on: () => error("$on(...)"),
    $set: () => error("$set(...)"),
  };
}

/**
 * @param {Node} anchor
 * @param {...(()=>any)[]} args
 */
function validate_snippet_args(anchor, ...args) {
  if (typeof anchor !== "object" || !(anchor instanceof Node)) {
    invalid_snippet_arguments();
  }

  for (let arg of args) {
    if (typeof arg !== "function") {
      invalid_snippet_arguments();
    }
  }
}

/** @import { Effect, Source, TemplateNode } from '#client' */

const PENDING = 0;
const THEN = 1;
const CATCH = 2;

/** @typedef {typeof PENDING | typeof THEN | typeof CATCH} AwaitState */

/**
 * @template V
 * @param {TemplateNode} node
 * @param {(() => Promise<V>)} get_input
 * @param {null | ((anchor: Node) => void)} pending_fn
 * @param {null | ((anchor: Node, value: Source<V>) => void)} then_fn
 * @param {null | ((anchor: Node, error: unknown) => void)} catch_fn
 * @returns {void}
 */
function await_block(node, get_input, pending_fn, then_fn, catch_fn) {
  if (hydrating) {
    hydrate_next();
  }

  var anchor = node;
  var runes = is_runes();
  var active_component_context = component_context;

  /** @type {any} */
  var component_function = component_context?.function;
  var dev_original_stack = dev_stack;

  /** @type {V | Promise<V> | typeof UNINITIALIZED} */
  var input = UNINITIALIZED;

  /** @type {Effect | null} */
  var pending_effect;

  /** @type {Effect | null} */
  var then_effect;

  /** @type {Effect | null} */
  var catch_effect;

  var input_source = runes
    ? source(/** @type {V} */ (undefined))
    : mutable_source(/** @type {V} */ (undefined), false, false);
  var error_source = runes
    ? source(undefined)
    : mutable_source(undefined, false, false);
  var resolved = false;
  /**
   * @param {AwaitState} state
   * @param {boolean} restore
   */
  function update(state, restore) {
    resolved = true;

    if (restore) {
      set_active_effect(effect);
      set_active_reaction(effect); // TODO do we need both?
      set_component_context(active_component_context);
      {
        set_dev_current_component_function(component_function);
        set_dev_stack(dev_original_stack);
      }
    }

    try {
      if (state === PENDING && pending_fn);

      if (state === THEN && then_fn) {
        if (then_effect) resume_effect(then_effect);
        else then_effect = branch(() => then_fn(anchor, input_source));
      }

      if (state === CATCH && catch_fn);

      if (state !== PENDING && pending_effect) {
        pause_effect(pending_effect, () => (pending_effect = null));
      }

      if (state !== THEN && then_effect) {
        pause_effect(then_effect, () => (then_effect = null));
      }

      if (state !== CATCH && catch_effect) {
        pause_effect(catch_effect, () => (catch_effect = null));
      }
    } finally {
      if (restore) {
        {
          set_dev_current_component_function(null);
          set_dev_stack(null);
        }

        set_component_context(null);
        set_active_reaction(null);
        set_active_effect(null);

        // without this, the DOM does not update until two ticks after the promise
        // resolves, which is unexpected behaviour (and somewhat irksome to test)
        flushSync();
      }
    }
  }

  var effect = block(() => {
    if (input === (input = get_input())) return;

    /** Whether or not there was a hydration mismatch. Needs to be a `let` or else it isn't treeshaken out */
    // @ts-ignore coercing `anchor` to a `Comment` causes TypeScript and Prettier to fight
    let mismatch =
      hydrating && is_promise(input) === (anchor.data === HYDRATION_START_ELSE);

    if (mismatch) {
      // Hydration mismatch: remove everything inside the anchor and start fresh
      anchor = remove_nodes();

      set_hydrate_node(anchor);
      set_hydrating(false);
      mismatch = true;
    }

    if (is_promise(input)) {
      var promise = input;

      resolved = false;

      promise.then(
        (value) => {
          if (promise !== input) return;
          // we technically could use `set` here since it's on the next microtick
          // but let's use internal_set for consistency and just to be safe
          internal_set(input_source, value);
          update(THEN, true);
        },
        (error) => {
          if (promise !== input) return;
          // we technically could use `set` here since it's on the next microtick
          // but let's use internal_set for consistency and just to be safe
          internal_set(error_source, error);
          update(CATCH, true);
          {
            // Rethrow the error if no catch block exists
            throw error_source.v;
          }
        },
      );

      if (hydrating);
      else {
        // Wait a microtask before checking if we should show the pending state as
        // the promise might have resolved by the next microtask.
        queue_micro_task(() => {
          if (!resolved) update(PENDING, true);
        });
      }
    } else {
      internal_set(input_source, input);
      update(THEN, false);
    }

    if (mismatch) {
      // continue in hydration mode
      set_hydrating(true);
    }

    // Set the input to something else, in order to disable the promise callbacks
    return () => (input = UNINITIALIZED);
  });

  if (hydrating) {
    anchor = hydrate_node;
  }
}

/** @import { Effect, TemplateNode } from '#client' */
/** @import { Batch } from '../../reactivity/batch.js'; */

// TODO reinstate https://github.com/sveltejs/svelte/pull/15250

/**
 * @param {TemplateNode} node
 * @param {(branch: (fn: (anchor: Node) => void, flag?: boolean) => void) => void} fn
 * @param {boolean} [elseif] True if this is an `{:else if ...}` block rather than an `{#if ...}`, as that affects which transitions are considered 'local'
 * @returns {void}
 */
function if_block(node, fn, elseif = false) {
  if (hydrating) {
    hydrate_next();
  }

  var anchor = node;

  /** @type {Effect | null} */
  var consequent_effect = null;

  /** @type {Effect | null} */
  var alternate_effect = null;

  /** @type {typeof UNINITIALIZED | boolean | null} */
  var condition = UNINITIALIZED;

  var flags = elseif ? EFFECT_TRANSPARENT : 0;

  var has_branch = false;

  const set_branch = (
    /** @type {(anchor: Node) => void} */ fn,
    flag = true,
  ) => {
    has_branch = true;
    update_branch(flag, fn);
  };

  /** @type {DocumentFragment | null} */
  var offscreen_fragment = null;

  function commit() {
    if (offscreen_fragment !== null) {
      // remove the anchor
      /** @type {Text} */ (offscreen_fragment.lastChild).remove();

      anchor.before(offscreen_fragment);
      offscreen_fragment = null;
    }

    var active = condition ? consequent_effect : alternate_effect;
    var inactive = condition ? alternate_effect : consequent_effect;

    if (active) {
      resume_effect(active);
    }

    if (inactive) {
      pause_effect(inactive, () => {
        if (condition) {
          alternate_effect = null;
        } else {
          consequent_effect = null;
        }
      });
    }
  }

  const update_branch = (
    /** @type {boolean | null} */ new_condition,
    /** @type {null | ((anchor: Node) => void)} */ fn,
  ) => {
    if (condition === (condition = new_condition)) return;

    /** Whether or not there was a hydration mismatch. Needs to be a `let` or else it isn't treeshaken out */
    let mismatch = false;

    if (hydrating) {
      const is_else =
        read_hydration_instruction(anchor) === HYDRATION_START_ELSE;

      if (!!condition === is_else) {
        // Hydration mismatch: remove everything inside the anchor and start fresh.
        // This could happen with `{#if browser}...{/if}`, for example
        anchor = remove_nodes();

        set_hydrate_node(anchor);
        set_hydrating(false);
        mismatch = true;
      }
    }

    var defer = should_defer_append();
    var target = anchor;

    if (defer) {
      offscreen_fragment = document.createDocumentFragment();
      offscreen_fragment.append((target = create_text()));
    }

    if (condition) {
      consequent_effect ??= fn && branch(() => fn(target));
    } else {
      alternate_effect ??= fn && branch(() => fn(target));
    }

    if (defer) {
      var batch = /** @type {Batch} */ (current_batch);

      var active = condition ? consequent_effect : alternate_effect;
      var inactive = condition ? alternate_effect : consequent_effect;

      if (active) batch.skipped_effects.delete(active);
      if (inactive) batch.skipped_effects.add(inactive);

      batch.add_callback(commit);
    } else {
      commit();
    }

    if (mismatch) {
      // continue in hydration mode
      set_hydrating(true);
    }
  };

  block(() => {
    has_branch = false;
    fn(set_branch);
    if (!has_branch) {
      update_branch(null, null);
    }
  }, flags);

  if (hydrating) {
    anchor = hydrate_node;
  }
}

/** @import { Effect, TemplateNode } from '#client' */
/** @import { Batch } from '../../reactivity/batch.js'; */

/**
 * @template V
 * @param {TemplateNode} node
 * @param {() => V} get_key
 * @param {(anchor: Node) => TemplateNode | void} render_fn
 * @returns {void}
 */
function key(node, get_key, render_fn) {
  if (hydrating) {
    hydrate_next();
  }

  var anchor = node;

  /** @type {V | typeof UNINITIALIZED} */
  var key = UNINITIALIZED;

  /** @type {Effect} */
  var effect;

  /** @type {Effect} */
  var pending_effect;

  /** @type {DocumentFragment | null} */
  var offscreen_fragment = null;

  var changed = is_runes() ? not_equal : safe_not_equal;

  function commit() {
    if (effect) {
      pause_effect(effect);
    }

    if (offscreen_fragment !== null) {
      // remove the anchor
      /** @type {Text} */ (offscreen_fragment.lastChild).remove();

      anchor.before(offscreen_fragment);
      offscreen_fragment = null;
    }

    effect = pending_effect;
  }

  block(() => {
    if (changed(key, (key = get_key()))) {
      var target = anchor;

      var defer = should_defer_append();

      if (defer) {
        offscreen_fragment = document.createDocumentFragment();
        offscreen_fragment.append((target = create_text()));
      }

      pending_effect = branch(() => render_fn(target));

      if (defer) {
        /** @type {Batch} */ (current_batch).add_callback(commit);
      } else {
        commit();
      }
    }
  });

  if (hydrating) {
    anchor = hydrate_node;
  }
}

/** @import { EachItem, EachState, Effect, MaybeSource, Source, TemplateNode, TransitionManager, Value } from '#client' */
/** @import { Batch } from '../../reactivity/batch.js'; */

/**
 * @param {any} _
 * @param {number} i
 */
function index(_, i) {
  return i;
}

/**
 * Pause multiple effects simultaneously, and coordinate their
 * subsequent destruction. Used in each blocks
 * @param {EachState} state
 * @param {EachItem[]} items
 * @param {null | Node} controlled_anchor
 */
function pause_effects(state, items, controlled_anchor) {
  var items_map = state.items;

  /** @type {TransitionManager[]} */
  var transitions = [];
  var length = items.length;

  for (var i = 0; i < length; i++) {
    pause_children(items[i].e, transitions, true);
  }

  var is_controlled =
    length > 0 && transitions.length === 0 && controlled_anchor !== null;
  // If we have a controlled anchor, it means that the each block is inside a single
  // DOM element, so we can apply a fast-path for clearing the contents of the element.
  if (is_controlled) {
    var parent_node = /** @type {Element} */ (
      /** @type {Element} */ (controlled_anchor).parentNode
    );
    clear_text_content(parent_node);
    parent_node.append(/** @type {Element} */ (controlled_anchor));
    items_map.clear();
    link$2(state, items[0].prev, items[length - 1].next);
  }

  run_out_transitions(transitions, () => {
    for (var i = 0; i < length; i++) {
      var item = items[i];
      if (!is_controlled) {
        items_map.delete(item.k);
        link$2(state, item.prev, item.next);
      }
      destroy_effect(item.e, !is_controlled);
    }
  });
}

/**
 * @template V
 * @param {Element | Comment} node The next sibling node, or the parent node if this is a 'controlled' block
 * @param {number} flags
 * @param {() => V[]} get_collection
 * @param {(value: V, index: number) => any} get_key
 * @param {(anchor: Node, item: MaybeSource<V>, index: MaybeSource<number>) => void} render_fn
 * @param {null | ((anchor: Node) => void)} fallback_fn
 * @returns {void}
 */
function each(
  node,
  flags,
  get_collection,
  get_key,
  render_fn,
  fallback_fn = null,
) {
  var anchor = node;

  /** @type {EachState} */
  var state = { flags, items: new Map(), first: null };

  var is_controlled = (flags & EACH_IS_CONTROLLED) !== 0;

  if (is_controlled) {
    var parent_node = /** @type {Element} */ (node);

    anchor = hydrating
      ? set_hydrate_node(
          /** @type {Comment | Text} */ (get_first_child(parent_node)),
        )
      : parent_node.appendChild(create_text());
  }

  if (hydrating) {
    hydrate_next();
  }

  /** @type {Effect | null} */
  var fallback = null;

  var was_empty = false;

  /** @type {Map<any, EachItem>} */
  var offscreen_items = new Map();

  // TODO: ideally we could use derived for runes mode but because of the ability
  // to use a store which can be mutated, we can't do that here as mutating a store
  // will still result in the collection array being the same from the store
  var each_array = derived_safe_equal(() => {
    var collection = get_collection();

    return is_array(collection)
      ? collection
      : collection == null
        ? []
        : array_from(collection);
  });

  /** @type {V[]} */
  var array;

  /** @type {Effect} */
  var each_effect;

  function commit() {
    reconcile(
      each_effect,
      array,
      state,
      offscreen_items,
      anchor,
      render_fn,
      flags,
      get_key,
      get_collection,
    );

    if (fallback_fn !== null) {
      if (array.length === 0) {
        if (fallback) {
          resume_effect(fallback);
        } else {
          fallback = branch(() => fallback_fn(anchor));
        }
      } else if (fallback !== null) {
        pause_effect(fallback, () => {
          fallback = null;
        });
      }
    }
  }

  block(() => {
    // store a reference to the effect so that we can update the start/end nodes in reconciliation
    each_effect ??= /** @type {Effect} */ (active_effect);

    array = /** @type {V[]} */ (get$2(each_array));
    var length = array.length;

    if (was_empty && length === 0) {
      // ignore updates if the array is empty,
      // and it already was empty on previous run
      return;
    }
    was_empty = length === 0;

    /** `true` if there was a hydration mismatch. Needs to be a `let` or else it isn't treeshaken out */
    let mismatch = false;

    if (hydrating) {
      var is_else = read_hydration_instruction(anchor) === HYDRATION_START_ELSE;

      if (is_else !== (length === 0)) {
        // hydration mismatch — remove the server-rendered DOM and start over
        anchor = remove_nodes();

        set_hydrate_node(anchor);
        set_hydrating(false);
        mismatch = true;
      }
    }

    // this is separate to the previous block because `hydrating` might change
    if (hydrating) {
      /** @type {EachItem | null} */
      var prev = null;

      /** @type {EachItem} */
      var item;

      for (var i = 0; i < length; i++) {
        if (
          hydrate_node.nodeType === COMMENT_NODE &&
          /** @type {Comment} */ (hydrate_node).data === HYDRATION_END
        ) {
          // The server rendered fewer items than expected,
          // so break out and continue appending non-hydrated items
          anchor = /** @type {Comment} */ (hydrate_node);
          mismatch = true;
          set_hydrating(false);
          break;
        }

        var value = array[i];
        var key = get_key(value, i);
        item = create_item(
          hydrate_node,
          state,
          prev,
          null,
          value,
          key,
          i,
          render_fn,
          flags,
          get_collection,
        );
        state.items.set(key, item);

        prev = item;
      }

      // remove excess nodes
      if (length > 0) {
        set_hydrate_node(remove_nodes());
      }
    }

    if (hydrating) {
      if (length === 0 && fallback_fn) {
        fallback = branch(() => fallback_fn(anchor));
      }
    } else {
      if (should_defer_append()) {
        var keys = new Set();
        var batch = /** @type {Batch} */ (current_batch);

        for (i = 0; i < length; i += 1) {
          value = array[i];
          key = get_key(value, i);

          var existing = state.items.get(key) ?? offscreen_items.get(key);

          if (existing) {
            // update before reconciliation, to trigger any async updates
            if ((flags & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0) {
              update_item(existing, value, i, flags);
            }
          } else {
            item = create_item(
              null,
              state,
              null,
              null,
              value,
              key,
              i,
              render_fn,
              flags,
              get_collection,
              true,
            );

            offscreen_items.set(key, item);
          }

          keys.add(key);
        }

        for (const [key, item] of state.items) {
          if (!keys.has(key)) {
            batch.skipped_effects.add(item.e);
          }
        }

        batch.add_callback(commit);
      } else {
        commit();
      }
    }

    if (mismatch) {
      // continue in hydration mode
      set_hydrating(true);
    }

    // When we mount the each block for the first time, the collection won't be
    // connected to this effect as the effect hasn't finished running yet and its deps
    // won't be assigned. However, it's possible that when reconciling the each block
    // that a mutation occurred and it's made the collection MAYBE_DIRTY, so reading the
    // collection again can provide consistency to the reactive graph again as the deriveds
    // will now be `CLEAN`.
    get$2(each_array);
  });

  if (hydrating) {
    anchor = hydrate_node;
  }
}

/**
 * Add, remove, or reorder items output by an each block as its input changes
 * @template V
 * @param {Effect} each_effect
 * @param {Array<V>} array
 * @param {EachState} state
 * @param {Map<any, EachItem>} offscreen_items
 * @param {Element | Comment | Text} anchor
 * @param {(anchor: Node, item: MaybeSource<V>, index: number | Source<number>, collection: () => V[]) => void} render_fn
 * @param {number} flags
 * @param {(value: V, index: number) => any} get_key
 * @param {() => V[]} get_collection
 * @returns {void}
 */
function reconcile(
  each_effect,
  array,
  state,
  offscreen_items,
  anchor,
  render_fn,
  flags,
  get_key,
  get_collection,
) {
  var is_animated = (flags & EACH_IS_ANIMATED) !== 0;
  var should_update =
    (flags & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0;

  var length = array.length;
  var items = state.items;
  var first = state.first;
  var current = first;

  /** @type {undefined | Set<EachItem>} */
  var seen;

  /** @type {EachItem | null} */
  var prev = null;

  /** @type {undefined | Set<EachItem>} */
  var to_animate;

  /** @type {EachItem[]} */
  var matched = [];

  /** @type {EachItem[]} */
  var stashed = [];

  /** @type {V} */
  var value;

  /** @type {any} */
  var key;

  /** @type {EachItem | undefined} */
  var item;

  /** @type {number} */
  var i;

  if (is_animated) {
    for (i = 0; i < length; i += 1) {
      value = array[i];
      key = get_key(value, i);
      item = items.get(key);

      if (item !== undefined) {
        item.a?.measure();
        (to_animate ??= new Set()).add(item);
      }
    }
  }

  for (i = 0; i < length; i += 1) {
    value = array[i];
    key = get_key(value, i);

    item = items.get(key);

    if (item === undefined) {
      var pending = offscreen_items.get(key);

      if (pending !== undefined) {
        offscreen_items.delete(key);
        items.set(key, pending);

        var next = prev ? prev.next : current;

        link$2(state, prev, pending);
        link$2(state, pending, next);

        move(pending, next, anchor);
        prev = pending;
      } else {
        var child_anchor = current
          ? /** @type {TemplateNode} */ (current.e.nodes_start)
          : anchor;

        prev = create_item(
          child_anchor,
          state,
          prev,
          prev === null ? state.first : prev.next,
          value,
          key,
          i,
          render_fn,
          flags,
          get_collection,
        );
      }

      items.set(key, prev);

      matched = [];
      stashed = [];

      current = prev.next;
      continue;
    }

    if (should_update) {
      update_item(item, value, i, flags);
    }

    if ((item.e.f & INERT) !== 0) {
      resume_effect(item.e);
      if (is_animated) {
        item.a?.unfix();
        (to_animate ??= new Set()).delete(item);
      }
    }

    if (item !== current) {
      if (seen !== undefined && seen.has(item)) {
        if (matched.length < stashed.length) {
          // more efficient to move later items to the front
          var start = stashed[0];
          var j;

          prev = start.prev;

          var a = matched[0];
          var b = matched[matched.length - 1];

          for (j = 0; j < matched.length; j += 1) {
            move(matched[j], start, anchor);
          }

          for (j = 0; j < stashed.length; j += 1) {
            seen.delete(stashed[j]);
          }

          link$2(state, a.prev, b.next);
          link$2(state, prev, a);
          link$2(state, b, start);

          current = start;
          prev = b;
          i -= 1;

          matched = [];
          stashed = [];
        } else {
          // more efficient to move earlier items to the back
          seen.delete(item);
          move(item, current, anchor);

          link$2(state, item.prev, item.next);
          link$2(state, item, prev === null ? state.first : prev.next);
          link$2(state, prev, item);

          prev = item;
        }

        continue;
      }

      matched = [];
      stashed = [];

      while (current !== null && current.k !== key) {
        // If the each block isn't inert and an item has an effect that is already inert,
        // skip over adding it to our seen Set as the item is already being handled
        if ((current.e.f & INERT) === 0) {
          (seen ??= new Set()).add(current);
        }
        stashed.push(current);
        current = current.next;
      }

      if (current === null) {
        continue;
      }

      item = current;
    }

    matched.push(item);
    prev = item;
    current = item.next;
  }

  if (current !== null || seen !== undefined) {
    var to_destroy = seen === undefined ? [] : array_from(seen);

    while (current !== null) {
      // If the each block isn't inert, then inert effects are currently outroing and will be removed once the transition is finished
      if ((current.e.f & INERT) === 0) {
        to_destroy.push(current);
      }
      current = current.next;
    }

    var destroy_length = to_destroy.length;

    if (destroy_length > 0) {
      var controlled_anchor =
        (flags & EACH_IS_CONTROLLED) !== 0 && length === 0 ? anchor : null;

      if (is_animated) {
        for (i = 0; i < destroy_length; i += 1) {
          to_destroy[i].a?.measure();
        }

        for (i = 0; i < destroy_length; i += 1) {
          to_destroy[i].a?.fix();
        }
      }

      pause_effects(state, to_destroy, controlled_anchor);
    }
  }

  if (is_animated) {
    queue_micro_task(() => {
      if (to_animate === undefined) return;
      for (item of to_animate) {
        item.a?.apply();
      }
    });
  }

  each_effect.first = state.first && state.first.e;
  each_effect.last = prev && prev.e;

  for (var unused of offscreen_items.values()) {
    destroy_effect(unused.e);
  }

  offscreen_items.clear();
}

/**
 * @param {EachItem} item
 * @param {any} value
 * @param {number} index
 * @param {number} type
 * @returns {void}
 */
function update_item(item, value, index, type) {
  if ((type & EACH_ITEM_REACTIVE) !== 0) {
    internal_set(item.v, value);
  }

  if ((type & EACH_INDEX_REACTIVE) !== 0) {
    internal_set(/** @type {Value<number>} */ (item.i), index);
  } else {
    item.i = index;
  }
}

/**
 * @template V
 * @param {Node | null} anchor
 * @param {EachState} state
 * @param {EachItem | null} prev
 * @param {EachItem | null} next
 * @param {V} value
 * @param {unknown} key
 * @param {number} index
 * @param {(anchor: Node, item: V | Source<V>, index: number | Value<number>, collection: () => V[]) => void} render_fn
 * @param {number} flags
 * @param {() => V[]} get_collection
 * @param {boolean} [deferred]
 * @returns {EachItem}
 */
function create_item(
  anchor,
  state,
  prev,
  next,
  value,
  key,
  index,
  render_fn,
  flags,
  get_collection,
  deferred,
) {
  var reactive = (flags & EACH_ITEM_REACTIVE) !== 0;
  var mutable = (flags & EACH_ITEM_IMMUTABLE) === 0;

  var v = reactive
    ? mutable
      ? mutable_source(value, false, false)
      : source(value)
    : value;
  var i = (flags & EACH_INDEX_REACTIVE) === 0 ? index : source(index);

  if (reactive) {
    // For tracing purposes, we need to link the source signal we create with the
    // collection + index so that tracing works as intended
    /** @type {Value} */ (v).trace = () => {
      var collection_index = typeof i === "number" ? index : i.v;
      // eslint-disable-next-line @typescript-eslint/no-unused-expressions
      get_collection()[collection_index];
    };
  }

  /** @type {EachItem} */
  var item = {
    i,
    v,
    k: key,
    a: null,
    // @ts-expect-error
    e: null,
    prev,
    next,
  };

  try {
    if (anchor === null) {
      var fragment = document.createDocumentFragment();
      fragment.append((anchor = create_text()));
    }

    item.e = branch(
      () => render_fn(/** @type {Node} */ (anchor), v, i, get_collection),
      hydrating,
    );

    item.e.prev = prev && prev.e;
    item.e.next = next && next.e;

    if (prev === null) {
      if (!deferred) {
        state.first = item;
      }
    } else {
      prev.next = item;
      prev.e.next = item.e;
    }

    if (next !== null) {
      next.prev = item;
      next.e.prev = item.e;
    }

    return item;
  } finally {
  }
}

/**
 * @param {EachItem} item
 * @param {EachItem | null} next
 * @param {Text | Element | Comment} anchor
 */
function move(item, next, anchor) {
  var end = item.next
    ? /** @type {TemplateNode} */ (item.next.e.nodes_start)
    : anchor;

  var dest = next ? /** @type {TemplateNode} */ (next.e.nodes_start) : anchor;
  var node = /** @type {TemplateNode} */ (item.e.nodes_start);

  while (node !== null && node !== end) {
    var next_node = /** @type {TemplateNode} */ (get_next_sibling(node));
    dest.before(node);
    node = next_node;
  }
}

/**
 * @param {EachState} state
 * @param {EachItem | null} prev
 * @param {EachItem | null} next
 */
function link$2(state, prev, next) {
  if (prev === null) {
    state.first = next;
  } else {
    prev.next = next;
    prev.e.next = next && next.e;
  }

  if (next !== null) {
    next.prev = prev;
    next.e.prev = prev && prev.e;
  }
}

/** @import { ActionPayload } from '#client' */

/**
 * @template P
 * @param {Element} dom
 * @param {(dom: Element, value?: P) => ActionPayload<P>} action
 * @param {() => P} [get_value]
 * @returns {void}
 */
function action(dom, action, get_value) {
  effect$3(() => {
    var payload = untrack(() => action(dom, get_value?.()) || {});

    if (get_value && payload?.update) {
      var inited = false;
      /** @type {P} */
      var prev = /** @type {any} */ ({}); // initialize with something so it's never equal on first run

      render_effect(() => {
        var value = get_value();

        // Action's update method is coarse-grained, i.e. when anything in the passed value changes, update.
        // This works in legacy mode because of mutable_source being updated as a whole, but when using $state
        // together with actions and mutation, it wouldn't notice the change without a deep read.
        deep_read_state(value);

        if (inited && safe_not_equal(prev, value)) {
          prev = value;
          /** @type {Function} */ (payload.update)(value);
        }
      });

      inited = true;
    }

    if (payload?.destroy) {
      return () => /** @type {Function} */ (payload.destroy)();
    }
  });
}

/** @import { Effect } from '#client' */

// TODO in 6.0 or 7.0, when we remove legacy mode, we can simplify this by
// getting rid of the block/branch stuff and just letting the effect rip.
// see https://github.com/sveltejs/svelte/pull/15962

/**
 * @param {Element} node
 * @param {() => (node: Element) => void} get_fn
 */
function attach(node, get_fn) {
  /** @type {false | undefined | ((node: Element) => void)} */
  var fn = undefined;

  /** @type {Effect | null} */
  var e;

  block(() => {
    if (fn !== (fn = get_fn())) {
      if (e) {
        destroy_effect(e);
        e = null;
      }

      if (fn) {
        e = branch(() => {
          effect$3(() => /** @type {(node: Element) => void} */ (fn)(node));
        });
      }
    }
  });
}

function r(e) {
  var t,
    f,
    n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;
  else if ("object" == typeof e)
    if (Array.isArray(e)) {
      var o = e.length;
      for (t = 0; t < o; t++)
        e[t] && (f = r(e[t])) && (n && (n += " "), (n += f));
    } else for (f in e) e[f] && (n && (n += " "), (n += f));
  return n;
}
function clsx$1() {
  for (var e, t, f = 0, n = "", o = arguments.length; f < o; f++)
    (e = arguments[f]) && (t = r(e)) && (n && (n += " "), (n += t));
  return n;
}

/**
 * Small wrapper around clsx to preserve Svelte's (weird) handling of falsy values.
 * TODO Svelte 6 revisit this, and likely turn all falsy values into the empty string (what clsx also does)
 * @param  {any} value
 */
function clsx(value) {
  if (typeof value === "object") {
    return clsx$1(value);
  } else {
    return value ?? "";
  }
}

const whitespace = [..." \t\n\r\f\u00a0\u000b\ufeff"];

/**
 * @param {any} value
 * @param {string | null} [hash]
 * @param {Record<string, boolean>} [directives]
 * @returns {string | null}
 */
function to_class(value, hash, directives) {
  var classname = value == null ? "" : "" + value;

  if (hash) {
    classname = classname ? classname + " " + hash : hash;
  }

  if (directives) {
    for (var key in directives) {
      if (directives[key]) {
        classname = classname ? classname + " " + key : key;
      } else if (classname.length) {
        var len = key.length;
        var a = 0;

        while ((a = classname.indexOf(key, a)) >= 0) {
          var b = a + len;

          if (
            (a === 0 || whitespace.includes(classname[a - 1])) &&
            (b === classname.length || whitespace.includes(classname[b]))
          ) {
            classname =
              (a === 0 ? "" : classname.substring(0, a)) +
              classname.substring(b + 1);
          } else {
            a = b;
          }
        }
      }
    }
  }

  return classname === "" ? null : classname;
}

/**
 *
 * @param {Record<string,any>} styles
 * @param {boolean} important
 */
function append_styles(styles, important = false) {
  var separator = important ? " !important;" : ";";
  var css = "";

  for (var key in styles) {
    var value = styles[key];
    if (value != null && value !== "") {
      css += " " + key + ": " + value + separator;
    }
  }

  return css;
}

/**
 * @param {string} name
 * @returns {string}
 */
function to_css_name(name) {
  if (name[0] !== "-" || name[1] !== "-") {
    return name.toLowerCase();
  }
  return name;
}

/**
 * @param {any} value
 * @param {Record<string, any> | [Record<string, any>, Record<string, any>]} [styles]
 * @returns {string | null}
 */
function to_style(value, styles) {
  if (styles) {
    var new_style = "";

    /** @type {Record<string,any> | undefined} */
    var normal_styles;

    /** @type {Record<string,any> | undefined} */
    var important_styles;

    if (Array.isArray(styles)) {
      normal_styles = styles[0];
      important_styles = styles[1];
    } else {
      normal_styles = styles;
    }

    if (value) {
      value = String(value)
        .replaceAll(/\s*\/\*.*?\*\/\s*/g, "")
        .trim();

      /** @type {boolean | '"' | "'"} */
      var in_str = false;
      var in_apo = 0;
      var in_comment = false;

      var reserved_names = [];

      if (normal_styles) {
        reserved_names.push(...Object.keys(normal_styles).map(to_css_name));
      }
      if (important_styles) {
        reserved_names.push(...Object.keys(important_styles).map(to_css_name));
      }

      var start_index = 0;
      var name_index = -1;

      const len = value.length;
      for (var i = 0; i < len; i++) {
        var c = value[i];

        if (in_comment) {
          if (c === "/" && value[i - 1] === "*") {
            in_comment = false;
          }
        } else if (in_str) {
          if (in_str === c) {
            in_str = false;
          }
        } else if (c === "/" && value[i + 1] === "*") {
          in_comment = true;
        } else if (c === '"' || c === "'") {
          in_str = c;
        } else if (c === "(") {
          in_apo++;
        } else if (c === ")") {
          in_apo--;
        }

        if (!in_comment && in_str === false && in_apo === 0) {
          if (c === ":" && name_index === -1) {
            name_index = i;
          } else if (c === ";" || i === len - 1) {
            if (name_index !== -1) {
              var name = to_css_name(
                value.substring(start_index, name_index).trim(),
              );

              if (!reserved_names.includes(name)) {
                if (c !== ";") {
                  i++;
                }

                var property = value.substring(start_index, i).trim();
                new_style += " " + property + ";";
              }
            }

            start_index = i + 1;
            name_index = -1;
          }
        }
      }
    }

    if (normal_styles) {
      new_style += append_styles(normal_styles);
    }

    if (important_styles) {
      new_style += append_styles(important_styles, true);
    }

    new_style = new_style.trim();
    return new_style === "" ? null : new_style;
  }

  return value == null ? null : String(value);
}

/**
 * @param {Element} dom
 * @param {boolean | number} is_html
 * @param {string | null} value
 * @param {string} [hash]
 * @param {Record<string, any>} [prev_classes]
 * @param {Record<string, any>} [next_classes]
 * @returns {Record<string, boolean> | undefined}
 */
function set_class(dom, is_html, value, hash, prev_classes, next_classes) {
  // @ts-expect-error need to add __className to patched prototype
  var prev = dom.__className;

  if (
    hydrating ||
    prev !== value ||
    prev === undefined // for edge case of `class={undefined}`
  ) {
    var next_class_name = to_class(value, hash, next_classes);

    if (!hydrating || next_class_name !== dom.getAttribute("class")) {
      // Removing the attribute when the value is only an empty string causes
      // performance issues vs simply making the className an empty string. So
      // we should only remove the class if the value is nullish
      // and there no hash/directives :
      if (next_class_name == null) {
        dom.removeAttribute("class");
      } else if (is_html) {
        dom.className = next_class_name;
      } else {
        dom.setAttribute("class", next_class_name);
      }
    }

    // @ts-expect-error need to add __className to patched prototype
    dom.__className = value;
  } else if (next_classes && prev_classes !== next_classes) {
    for (var key in next_classes) {
      var is_present = !!next_classes[key];

      if (prev_classes == null || is_present !== !!prev_classes[key]) {
        dom.classList.toggle(key, is_present);
      }
    }
  }

  return next_classes;
}

/**
 * @param {Element & ElementCSSInlineStyle} dom
 * @param {Record<string, any>} prev
 * @param {Record<string, any>} next
 * @param {string} [priority]
 */
function update_styles(dom, prev = {}, next, priority) {
  for (var key in next) {
    var value = next[key];

    if (prev[key] !== value) {
      if (next[key] == null) {
        dom.style.removeProperty(key);
      } else {
        dom.style.setProperty(key, value, priority);
      }
    }
  }
}

/**
 * @param {Element & ElementCSSInlineStyle} dom
 * @param {string | null} value
 * @param {Record<string, any> | [Record<string, any>, Record<string, any>]} [prev_styles]
 * @param {Record<string, any> | [Record<string, any>, Record<string, any>]} [next_styles]
 */
function set_style(dom, value, prev_styles, next_styles) {
  // @ts-expect-error
  var prev = dom.__style;

  if (hydrating || prev !== value) {
    var next_style_attr = to_style(value, next_styles);

    if (!hydrating || next_style_attr !== dom.getAttribute("style")) {
      if (next_style_attr == null) {
        dom.removeAttribute("style");
      } else {
        dom.style.cssText = next_style_attr;
      }
    }

    // @ts-expect-error
    dom.__style = value;
  } else if (next_styles) {
    if (Array.isArray(next_styles)) {
      update_styles(dom, prev_styles?.[0], next_styles[0]);
      update_styles(dom, prev_styles?.[1], next_styles[1], "important");
    } else {
      update_styles(dom, prev_styles, next_styles);
    }
  }

  return next_styles;
}

/**
 * Selects the correct option(s) (depending on whether this is a multiple select)
 * @template V
 * @param {HTMLSelectElement} select
 * @param {V} value
 * @param {boolean} mounting
 */
function select_option(select, value, mounting = false) {
  if (select.multiple) {
    // If value is null or undefined, keep the selection as is
    if (value == undefined) {
      return;
    }

    // If not an array, warn and keep the selection as is
    if (!is_array(value)) {
      return select_multiple_invalid_value();
    }

    // Otherwise, update the selection
    for (var option of select.options) {
      option.selected = value.includes(get_option_value(option));
    }

    return;
  }

  for (option of select.options) {
    var option_value = get_option_value(option);
    if (is(option_value, value)) {
      option.selected = true;
      return;
    }
  }

  if (!mounting || value !== undefined) {
    select.selectedIndex = -1; // no option should be selected
  }
}

/**
 * Selects the correct option(s) if `value` is given,
 * and then sets up a mutation observer to sync the
 * current selection to the dom when it changes. Such
 * changes could for example occur when options are
 * inside an `#each` block.
 * @param {HTMLSelectElement} select
 */
function init_select(select) {
  var observer = new MutationObserver(() => {
    // @ts-ignore
    select_option(select, select.__value);
    // Deliberately don't update the potential binding value,
    // the model should be preserved unless explicitly changed
  });

  observer.observe(select, {
    // Listen to option element changes
    childList: true,
    subtree: true, // because of <optgroup>
    // Listen to option element value attribute changes
    // (doesn't get notified of select value changes,
    // because that property is not reflected as an attribute)
    attributes: true,
    attributeFilter: ["value"],
  });

  teardown(() => {
    observer.disconnect();
  });
}

/** @param {HTMLOptionElement} option */
function get_option_value(option) {
  // __value only exists if the <option> has a value attribute
  if ("__value" in option) {
    return option.__value;
  } else {
    return option.value;
  }
}

/** @import { Effect } from '#client' */

const CLASS = Symbol("class");
const STYLE = Symbol("style");

const IS_CUSTOM_ELEMENT = Symbol("is custom element");
const IS_HTML = Symbol("is html");

/**
 * The value/checked attribute in the template actually corresponds to the defaultValue property, so we need
 * to remove it upon hydration to avoid a bug when someone resets the form value.
 * @param {HTMLInputElement} input
 * @returns {void}
 */
function remove_input_defaults(input) {
  if (!hydrating) return;

  var already_removed = false;

  // We try and remove the default attributes later, rather than sync during hydration.
  // Doing it sync during hydration has a negative impact on performance, but deferring the
  // work in an idle task alleviates this greatly. If a form reset event comes in before
  // the idle callback, then we ensure the input defaults are cleared just before.
  var remove_defaults = () => {
    if (already_removed) return;
    already_removed = true;

    // Remove the attributes but preserve the values
    if (input.hasAttribute("value")) {
      var value = input.value;
      set_attribute(input, "value", null);
      input.value = value;
    }

    if (input.hasAttribute("checked")) {
      var checked = input.checked;
      set_attribute(input, "checked", null);
      input.checked = checked;
    }
  };

  // @ts-expect-error
  input.__on_r = remove_defaults;
  queue_idle_task(remove_defaults);
  add_form_reset_listener();
}

/**
 * @param {Element} element
 * @param {any} value
 */
function set_value(element, value) {
  var attributes = get_attributes(element);

  if (
    attributes.value ===
      (attributes.value =
        // treat null and undefined the same for the initial value
        value ?? undefined) ||
    // @ts-expect-error
    // `progress` elements always need their value set when it's `0`
    (element.value === value &&
      (value !== 0 || element.nodeName !== "PROGRESS"))
  ) {
    return;
  }

  // @ts-expect-error
  element.value = value ?? "";
}

/**
 * Sets the `selected` attribute on an `option` element.
 * Not set through the property because that doesn't reflect to the DOM,
 * which means it wouldn't be taken into account when a form is reset.
 * @param {HTMLOptionElement} element
 * @param {boolean} selected
 */
function set_selected(element, selected) {
  if (selected) {
    // The selected option could've changed via user selection, and
    // setting the value without this check would set it back.
    if (!element.hasAttribute("selected")) {
      element.setAttribute("selected", "");
    }
  } else {
    element.removeAttribute("selected");
  }
}

/**
 * @param {Element} element
 * @param {string} attribute
 * @param {string | null} value
 * @param {boolean} [skip_warning]
 */
function set_attribute(element, attribute, value, skip_warning) {
  var attributes = get_attributes(element);

  if (hydrating) {
    attributes[attribute] = element.getAttribute(attribute);

    if (
      attribute === "src" ||
      attribute === "srcset" ||
      (attribute === "href" && element.nodeName === "LINK")
    ) {
      if (!skip_warning) {
        check_src_in_dev_hydration(element, attribute, value ?? "");
      }

      // If we reset these attributes, they would result in another network request, which we want to avoid.
      // We assume they are the same between client and server as checking if they are equal is expensive
      // (we can't just compare the strings as they can be different between client and server but result in the
      // same url, so we would need to create hidden anchor elements to compare them)
      return;
    }
  }

  if (attributes[attribute] === (attributes[attribute] = value)) return;

  if (attribute === "loading") {
    // @ts-expect-error
    element[LOADING_ATTR_SYMBOL] = value;
  }

  if (value == null) {
    element.removeAttribute(attribute);
  } else if (
    typeof value !== "string" &&
    get_setters(element).includes(attribute)
  ) {
    // @ts-ignore
    element[attribute] = value;
  } else {
    element.setAttribute(attribute, value);
  }
}

/**
 * Spreads attributes onto a DOM element, taking into account the currently set attributes
 * @param {Element & ElementCSSInlineStyle} element
 * @param {Record<string | symbol, any> | undefined} prev
 * @param {Record<string | symbol, any>} next New attributes - this function mutates this object
 * @param {string} [css_hash]
 * @param {boolean} [skip_warning]
 * @returns {Record<string, any>}
 */
function set_attributes(element, prev, next, css_hash, skip_warning = false) {
  var attributes = get_attributes(element);

  var is_custom_element = attributes[IS_CUSTOM_ELEMENT];
  var preserve_attribute_case = !attributes[IS_HTML];

  // If we're hydrating but the custom element is from Svelte, and it already scaffolded,
  // then it might run block logic in hydration mode, which we have to prevent.
  let is_hydrating_custom_element = hydrating && is_custom_element;
  if (is_hydrating_custom_element) {
    set_hydrating(false);
  }

  var current = prev || {};
  var is_option_element = element.tagName === "OPTION";

  for (var key in prev) {
    if (!(key in next)) {
      next[key] = null;
    }
  }

  if (next.class) {
    next.class = clsx(next.class);
  } else if (css_hash || next[CLASS]) {
    next.class = null; /* force call to set_class() */
  }

  if (next[STYLE]) {
    next.style ??= null; /* force call to set_style() */
  }

  var setters = get_setters(element);

  // since key is captured we use const
  for (const key in next) {
    // let instead of var because referenced in a closure
    let value = next[key];

    // Up here because we want to do this for the initial value, too, even if it's undefined,
    // and this wouldn't be reached in case of undefined because of the equality check below
    if (is_option_element && key === "value" && value == null) {
      // The <option> element is a special case because removing the value attribute means
      // the value is set to the text content of the option element, and setting the value
      // to null or undefined means the value is set to the string "null" or "undefined".
      // To align with how we handle this case in non-spread-scenarios, this logic is needed.
      // There's a super-edge-case bug here that is left in in favor of smaller code size:
      // Because of the "set missing props to null" logic above, we can't differentiate
      // between a missing value and an explicitly set value of null or undefined. That means
      // that once set, the value attribute of an <option> element can't be removed. This is
      // a very rare edge case, and removing the attribute altogether isn't possible either
      // for the <option value={undefined}> case, so we're not losing any functionality here.
      // @ts-ignore
      element.value = element.__value = "";
      current[key] = value;
      continue;
    }

    if (key === "class") {
      var is_html = element.namespaceURI === "http://www.w3.org/1999/xhtml";
      set_class(element, is_html, value, css_hash, prev?.[CLASS], next[CLASS]);
      current[key] = value;
      current[CLASS] = next[CLASS];
      continue;
    }

    if (key === "style") {
      set_style(element, value, prev?.[STYLE], next[STYLE]);
      current[key] = value;
      current[STYLE] = next[STYLE];
      continue;
    }

    var prev_value = current[key];

    // Skip if value is unchanged, unless it's `undefined` and the element still has the attribute
    if (
      value === prev_value &&
      !(value === undefined && element.hasAttribute(key))
    ) {
      continue;
    }

    current[key] = value;

    var prefix = key[0] + key[1]; // this is faster than key.slice(0, 2)
    if (prefix === "$$") continue;

    if (prefix === "on") {
      /** @type {{ capture?: true }} */
      const opts = {};
      const event_handle_key = "$$" + key;
      let event_name = key.slice(2);
      var delegated = is_delegated(event_name);

      if (is_capture_event(event_name)) {
        event_name = event_name.slice(0, -7);
        opts.capture = true;
      }

      if (!delegated && prev_value) {
        // Listening to same event but different handler -> our handle function below takes care of this
        // If we were to remove and add listeners in this case, it could happen that the event is "swallowed"
        // (the browser seems to not know yet that a new one exists now) and doesn't reach the handler
        // https://github.com/sveltejs/svelte/issues/11903
        if (value != null) continue;

        element.removeEventListener(
          event_name,
          current[event_handle_key],
          opts,
        );
        current[event_handle_key] = null;
      }

      if (value != null) {
        if (!delegated) {
          /**
           * @this {any}
           * @param {Event} evt
           */
          function handle(evt) {
            current[key].call(this, evt);
          }

          current[event_handle_key] = create_event(
            event_name,
            element,
            handle,
            opts,
          );
        } else {
          // @ts-ignore
          element[`__${event_name}`] = value;
          delegate([event_name]);
        }
      } else if (delegated) {
        // @ts-ignore
        element[`__${event_name}`] = undefined;
      }
    } else if (key === "style") {
      // avoid using the setter
      set_attribute(element, key, value);
    } else if (key === "autofocus") {
      autofocus(/** @type {HTMLElement} */ (element), Boolean(value));
    } else if (
      !is_custom_element &&
      (key === "__value" || (key === "value" && value != null))
    ) {
      // @ts-ignore We're not running this for custom elements because __value is actually
      // how Lit stores the current value on the element, and messing with that would break things.
      element.value = element.__value = value;
    } else if (key === "selected" && is_option_element) {
      set_selected(/** @type {HTMLOptionElement} */ (element), value);
    } else {
      var name = key;
      if (!preserve_attribute_case) {
        name = normalize_attribute(name);
      }

      var is_default = name === "defaultValue" || name === "defaultChecked";

      if (value == null && !is_custom_element && !is_default) {
        attributes[key] = null;

        if (name === "value" || name === "checked") {
          // removing value/checked also removes defaultValue/defaultChecked — preserve
          let input = /** @type {HTMLInputElement} */ (element);
          const use_default = prev === undefined;
          if (name === "value") {
            let previous = input.defaultValue;
            input.removeAttribute(name);
            input.defaultValue = previous;
            // @ts-ignore
            input.value = input.__value = use_default ? previous : null;
          } else {
            let previous = input.defaultChecked;
            input.removeAttribute(name);
            input.defaultChecked = previous;
            input.checked = use_default ? previous : false;
          }
        } else {
          element.removeAttribute(key);
        }
      } else if (
        is_default ||
        (setters.includes(name) &&
          (is_custom_element || typeof value !== "string"))
      ) {
        // @ts-ignore
        element[name] = value;
        // remove it from attributes's cache
        if (name in attributes) attributes[name] = UNINITIALIZED;
      } else if (typeof value !== "function") {
        set_attribute(element, name, value, skip_warning);
      }
    }
  }

  if (is_hydrating_custom_element) {
    set_hydrating(true);
  }

  return current;
}

/**
 * @param {Element & ElementCSSInlineStyle} element
 * @param {(...expressions: any) => Record<string | symbol, any>} fn
 * @param {Array<() => any>} sync
 * @param {Array<() => Promise<any>>} async
 * @param {string} [css_hash]
 * @param {boolean} [skip_warning]
 */
function attribute_effect(
  element,
  fn,
  sync = [],
  async = [],
  css_hash,
  skip_warning = false,
) {
  flatten$1(sync, async, (values) => {
    /** @type {Record<string | symbol, any> | undefined} */
    var prev = undefined;

    /** @type {Record<symbol, Effect>} */
    var effects = {};

    var is_select = element.nodeName === "SELECT";
    var inited = false;

    block(() => {
      var next = fn(...values.map(get$2));
      /** @type {Record<string | symbol, any>} */
      var current = set_attributes(element, prev, next, css_hash, skip_warning);

      if (inited && is_select && "value" in next) {
        select_option(/** @type {HTMLSelectElement} */ (element), next.value);
      }

      for (let symbol of Object.getOwnPropertySymbols(effects)) {
        if (!next[symbol]) destroy_effect(effects[symbol]);
      }

      for (let symbol of Object.getOwnPropertySymbols(next)) {
        var n = next[symbol];

        if (
          symbol.description === ATTACHMENT_KEY &&
          (!prev || n !== prev[symbol])
        ) {
          if (effects[symbol]) destroy_effect(effects[symbol]);
          effects[symbol] = branch(() => attach(element, () => n));
        }

        current[symbol] = n;
      }

      prev = current;
    });

    if (is_select) {
      var select = /** @type {HTMLSelectElement} */ (element);

      effect$3(() => {
        select_option(
          select,
          /** @type {Record<string | symbol, any>} */ (prev).value,
          true,
        );
        init_select(select);
      });
    }

    inited = true;
  });
}

/**
 *
 * @param {Element} element
 */
function get_attributes(element) {
  return /** @type {Record<string | symbol, unknown>} **/ (
    // @ts-expect-error
    element.__attributes ??= {
      [IS_CUSTOM_ELEMENT]: element.nodeName.includes("-"),
      [IS_HTML]: element.namespaceURI === NAMESPACE_HTML,
    }
  );
}

/** @type {Map<string, string[]>} */
var setters_cache = new Map();

/** @param {Element} element */
function get_setters(element) {
  var setters = setters_cache.get(element.nodeName);
  if (setters) return setters;
  setters_cache.set(element.nodeName, (setters = []));

  var descriptors;
  var proto = element; // In the case of custom elements there might be setters on the instance
  var element_proto = Element.prototype;

  // Stop at Element, from there on there's only unnecessary setters we're not interested in
  // Do not use contructor.name here as that's unreliable in some browser environments
  while (element_proto !== proto) {
    descriptors = get_descriptors(proto);

    for (var key in descriptors) {
      if (descriptors[key].set) {
        setters.push(key);
      }
    }

    proto = get_prototype_of(proto);
  }

  return setters;
}

/**
 * @param {any} element
 * @param {string} attribute
 * @param {string} value
 */
function check_src_in_dev_hydration(element, attribute, value) {
  if (attribute === "srcset" && srcset_url_equal(element, value)) return;
  if (src_url_equal(element.getAttribute(attribute) ?? "", value)) return;

  hydration_attribute_changed(
    attribute,
    element.outerHTML.replace(element.innerHTML, element.innerHTML && "..."),
    String(value),
  );
}

/**
 * @param {string} element_src
 * @param {string} url
 * @returns {boolean}
 */
function src_url_equal(element_src, url) {
  if (element_src === url) return true;
  return (
    new URL(element_src, document.baseURI).href ===
    new URL(url, document.baseURI).href
  );
}

/** @param {string} srcset */
function split_srcset(srcset) {
  return srcset.split(",").map((src) => src.trim().split(" ").filter(Boolean));
}

/**
 * @param {HTMLSourceElement | HTMLImageElement} element
 * @param {string} srcset
 * @returns {boolean}
 */
function srcset_url_equal(element, srcset) {
  var element_urls = split_srcset(element.srcset);
  var urls = split_srcset(srcset);

  return (
    urls.length === element_urls.length &&
    urls.every(
      ([url, width], i) =>
        width === element_urls[i][1] &&
        // We need to test both ways because Vite will create an a full URL with
        // `new URL(asset, import.meta.url).href` for the client when `base: './'`, and the
        // relative URLs inside srcset are not automatically resolved to absolute URLs by
        // browsers (in contrast to img.src). This means both SSR and DOM code could
        // contain relative or absolute URLs.
        (src_url_equal(element_urls[i][0], url) ||
          src_url_equal(url, element_urls[i][0])),
    )
  );
}

/**
 * @param {any} bound_value
 * @param {Element} element_or_component
 * @returns {boolean}
 */
function is_bound_this(bound_value, element_or_component) {
  return (
    bound_value === element_or_component ||
    bound_value?.[STATE_SYMBOL] === element_or_component
  );
}

/**
 * @param {any} element_or_component
 * @param {(value: unknown, ...parts: unknown[]) => void} update
 * @param {(...parts: unknown[]) => unknown} get_value
 * @param {() => unknown[]} [get_parts] Set if the this binding is used inside an each block,
 * 										returns all the parts of the each block context that are used in the expression
 * @returns {void}
 */
function bind_this(element_or_component = {}, update, get_value, get_parts) {
  effect$3(() => {
    /** @type {unknown[]} */
    var old_parts;

    /** @type {unknown[]} */
    var parts;

    render_effect(() => {
      old_parts = parts;
      // We only track changes to the parts, not the value itself to avoid unnecessary reruns.
      parts = [];

      untrack(() => {
        if (element_or_component !== get_value(...parts)) {
          update(element_or_component, ...parts);
          // If this is an effect rerun (cause: each block context changes), then nullfiy the binding at
          // the previous position if it isn't already taken over by a different effect.
          if (
            old_parts &&
            is_bound_this(get_value(...old_parts), element_or_component)
          ) {
            update(null, ...old_parts);
          }
        }
      });
    });

    return () => {
      // We cannot use effects in the teardown phase, we we use a microtask instead.
      queue_micro_task(() => {
        if (parts && is_bound_this(get_value(...parts), element_or_component)) {
          update(null, ...parts);
        }
      });
    };
  });

  return element_or_component;
}

/** @import { ComponentContextLegacy } from '#client' */

/**
 * Legacy-mode only: Call `onMount` callbacks and set up `beforeUpdate`/`afterUpdate` effects
 * @param {boolean} [immutable]
 */
function init$1(immutable = false) {
  const context = /** @type {ComponentContextLegacy} */ (component_context);

  const callbacks = context.l.u;
  if (!callbacks) return;

  let props = () => deep_read_state(context.s);

  if (immutable) {
    let version = 0;
    let prev = /** @type {Record<string, any>} */ ({});

    // In legacy immutable mode, before/afterUpdate only fire if the object identity of a prop changes
    const d = derived(() => {
      let changed = false;
      const props = context.s;
      for (const key in props) {
        if (props[key] !== prev[key]) {
          prev[key] = props[key];
          changed = true;
        }
      }
      if (changed) version++;
      return version;
    });

    props = () => get$2(d);
  }

  // beforeUpdate
  if (callbacks.b.length) {
    user_pre_effect(() => {
      observe_all(context, props);
      run_all(callbacks.b);
    });
  }

  // onMount (must run before afterUpdate)
  user_effect(() => {
    const fns = untrack(() => callbacks.m.map(run));
    return () => {
      for (const fn of fns) {
        if (typeof fn === "function") {
          fn();
        }
      }
    };
  });

  // afterUpdate
  if (callbacks.a.length) {
    user_effect(() => {
      observe_all(context, props);
      run_all(callbacks.a);
    });
  }
}

/**
 * Invoke the getter of all signals associated with a component
 * so they can be registered to the effect this function is called in.
 * @param {ComponentContextLegacy} context
 * @param {(() => void)} props
 */
function observe_all(context, props) {
  if (context.l.s) {
    for (const signal of context.l.s) get$2(signal);
  }

  props();
}

/**
 * Under some circumstances, imports may be reactive in legacy mode. In that case,
 * they should be using `reactive_import` as part of the transformation
 * @param {() => any} fn
 */
function reactive_import(fn) {
  var s = source(0);

  return function () {
    if (arguments.length === 1) {
      set$2(s, get$2(s) + 1);
      return arguments[0];
    } else {
      get$2(s);
      return fn();
    }
  };
}

/** @import { StoreReferencesContainer } from '#client' */
/** @import { Store } from '#shared' */

/**
 * Whether or not the prop currently being read is a store binding, as in
 * `<Child bind:x={$y} />`. If it is, we treat the prop as mutable even in
 * runes mode, and skip `binding_property_non_reactive` validation
 */
let is_store_binding = false;

/**
 * Returns a tuple that indicates whether `fn()` reads a prop that is a store binding.
 * Used to prevent `binding_property_non_reactive` validation false positives and
 * ensure that these props are treated as mutable even in runes mode
 * @template T
 * @param {() => T} fn
 * @returns {[T, boolean]}
 */
function capture_store_binding(fn) {
  var previous_is_store_binding = is_store_binding;

  try {
    is_store_binding = false;
    return [fn(), is_store_binding];
  } finally {
    is_store_binding = previous_is_store_binding;
  }
}

/** @import { Effect, Source } from './types.js' */

/**
 * The proxy handler for rest props (i.e. `const { x, ...rest } = $props()`).
 * Is passed the full `$$props` object and excludes the named props.
 * @type {ProxyHandler<{ props: Record<string | symbol, unknown>, exclude: Array<string | symbol>, name?: string }>}}
 */
const rest_props_handler = {
  get(target, key) {
    if (target.exclude.includes(key)) return;
    return target.props[key];
  },
  set(target, key) {
    {
      // TODO should this happen in prod too?
      props_rest_readonly(`${target.name}.${String(key)}`);
    }

    return false;
  },
  getOwnPropertyDescriptor(target, key) {
    if (target.exclude.includes(key)) return;
    if (key in target.props) {
      return {
        enumerable: true,
        configurable: true,
        value: target.props[key],
      };
    }
  },
  has(target, key) {
    if (target.exclude.includes(key)) return false;
    return key in target.props;
  },
  ownKeys(target) {
    return Reflect.ownKeys(target.props).filter(
      (key) => !target.exclude.includes(key),
    );
  },
};

/**
 * @param {Record<string, unknown>} props
 * @param {string[]} exclude
 * @param {string} [name]
 * @returns {Record<string, unknown>}
 */
/*#__NO_SIDE_EFFECTS__*/
function rest_props(props, exclude, name) {
  return new Proxy(
    { props, exclude, name, other: {}, to_proxy: [] },
    rest_props_handler,
  );
}

/**
 * The proxy handler for spread props. Handles the incoming array of props
 * that looks like `() => { dynamic: props }, { static: prop }, ..` and wraps
 * them so that the whole thing is passed to the component as the `$$props` argument.
 * @type {ProxyHandler<{ props: Array<Record<string | symbol, unknown> | (() => Record<string | symbol, unknown>)> }>}}
 */
const spread_props_handler = {
  get(target, key) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key in p) return p[key];
    }
  },
  set(target, key, value) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      const desc = get_descriptor(p, key);
      if (desc && desc.set) {
        desc.set(value);
        return true;
      }
    }
    return false;
  },
  getOwnPropertyDescriptor(target, key) {
    let i = target.props.length;
    while (i--) {
      let p = target.props[i];
      if (is_function(p)) p = p();
      if (typeof p === "object" && p !== null && key in p) {
        const descriptor = get_descriptor(p, key);
        if (descriptor && !descriptor.configurable) {
          // Prevent a "Non-configurability Report Error": The target is an array, it does
          // not actually contain this property. If it is now described as non-configurable,
          // the proxy throws a validation error. Setting it to true avoids that.
          descriptor.configurable = true;
        }
        return descriptor;
      }
    }
  },
  has(target, key) {
    // To prevent a false positive `is_entry_props` in the `prop` function
    if (key === STATE_SYMBOL || key === LEGACY_PROPS) return false;

    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (p != null && key in p) return true;
    }

    return false;
  },
  ownKeys(target) {
    /** @type {Array<string | symbol>} */
    const keys = [];

    for (let p of target.props) {
      if (is_function(p)) p = p();
      if (!p) continue;

      for (const key in p) {
        if (!keys.includes(key)) keys.push(key);
      }

      for (const key of Object.getOwnPropertySymbols(p)) {
        if (!keys.includes(key)) keys.push(key);
      }
    }

    return keys;
  },
};

/**
 * @param {Array<Record<string, unknown> | (() => Record<string, unknown>)>} props
 * @returns {any}
 */
function spread_props(...props) {
  return new Proxy({ props }, spread_props_handler);
}

/**
 * This function is responsible for synchronizing a possibly bound prop with the inner component state.
 * It is used whenever the compiler sees that the component writes to the prop, or when it has a default prop_value.
 * @template V
 * @param {Record<string, unknown>} props
 * @param {string} key
 * @param {number} flags
 * @param {V | (() => V)} [fallback]
 * @returns {(() => V | ((arg: V) => V) | ((arg: V, mutation: boolean) => V))}
 */
function prop(props, key, flags, fallback) {
  var runes = !legacy_mode_flag || (flags & PROPS_IS_RUNES) !== 0;
  var bindable = (flags & PROPS_IS_BINDABLE) !== 0;
  var lazy = (flags & PROPS_IS_LAZY_INITIAL) !== 0;

  var fallback_value = /** @type {V} */ (fallback);
  var fallback_dirty = true;

  var get_fallback = () => {
    if (fallback_dirty) {
      fallback_dirty = false;

      fallback_value = lazy
        ? untrack(/** @type {() => V} */ (fallback))
        : /** @type {V} */ (fallback);
    }

    return fallback_value;
  };

  /** @type {((v: V) => void) | undefined} */
  var setter;

  if (bindable) {
    // Can be the case when someone does `mount(Component, props)` with `let props = $state({...})`
    // or `createClassComponent(Component, props)`
    var is_entry_props = STATE_SYMBOL in props || LEGACY_PROPS in props;

    setter =
      get_descriptor(props, key)?.set ??
      (is_entry_props && key in props ? (v) => (props[key] = v) : undefined);
  }

  var initial_value;
  var is_store_sub = false;

  if (bindable) {
    [initial_value, is_store_sub] = capture_store_binding(
      () => /** @type {V} */ (props[key]),
    );
  } else {
    initial_value = /** @type {V} */ (props[key]);
  }

  if (initial_value === undefined && fallback !== undefined) {
    initial_value = get_fallback();

    if (setter) {
      if (runes) props_invalid_value(key);
      setter(initial_value);
    }
  }

  /** @type {() => V} */
  var getter;

  if (runes) {
    getter = () => {
      var value = /** @type {V} */ (props[key]);
      if (value === undefined) return get_fallback();
      fallback_dirty = true;
      return value;
    };
  } else {
    getter = () => {
      var value = /** @type {V} */ (props[key]);

      if (value !== undefined) {
        // in legacy mode, we don't revert to the fallback value
        // if the prop goes from defined to undefined. The easiest
        // way to model this is to make the fallback undefined
        // as soon as the prop has a value
        fallback_value = /** @type {V} */ (undefined);
      }

      return value === undefined ? fallback_value : value;
    };
  }

  // prop is never written to — we only need a getter
  if (runes && (flags & PROPS_IS_UPDATED) === 0) {
    return getter;
  }

  // prop is written to, but the parent component had `bind:foo` which
  // means we can just call `$$props.foo = value` directly
  if (setter) {
    var legacy_parent = props.$$legacy;
    return /** @type {() => V} */ (
      function (/** @type {V} */ value, /** @type {boolean} */ mutation) {
        if (arguments.length > 0) {
          // We don't want to notify if the value was mutated and the parent is in runes mode.
          // In that case the state proxy (if it exists) should take care of the notification.
          // If the parent is not in runes mode, we need to notify on mutation, too, that the prop
          // has changed because the parent will not be able to detect the change otherwise.
          if (!runes || !mutation || legacy_parent || is_store_sub) {
            /** @type {Function} */ (setter)(mutation ? getter() : value);
          }

          return value;
        }

        return getter();
      }
    );
  }

  // Either prop is written to, but there's no binding, which means we
  // create a derived that we can write to locally.
  // Or we are in legacy mode where we always create a derived to replicate that
  // Svelte 4 did not trigger updates when a primitive value was updated to the same value.
  var overridden = false;

  var d = ((flags & PROPS_IS_IMMUTABLE) !== 0 ? derived : derived_safe_equal)(
    () => {
      overridden = false;
      return getter();
    },
  );

  {
    d.label = key;
  }

  // Capture the initial value if it's bindable
  if (bindable) get$2(d);

  var parent_effect = /** @type {Effect} */ (active_effect);

  return /** @type {() => V} */ (
    function (/** @type {any} */ value, /** @type {boolean} */ mutation) {
      if (arguments.length > 0) {
        const new_value = mutation
          ? get$2(d)
          : runes && bindable
            ? proxy(value)
            : value;

        set$2(d, new_value);
        overridden = true;

        if (fallback_value !== undefined) {
          fallback_value = new_value;
        }

        return value;
      }

      // special case — avoid recalculating the derived if we're in a
      // teardown function and the prop was overridden locally, or the
      // component was already destroyed (this latter part is necessary
      // because `bind:this` can read props after the component has
      // been destroyed. TODO simplify `bind:this`
      if (
        (is_destroying_effect && overridden) ||
        (parent_effect.f & DESTROYED) !== 0
      ) {
        return d.v;
      }

      return get$2(d);
    }
  );
}

/**
 * @param {string} binding
 * @param {() => Record<string, any>} get_object
 * @param {() => string} get_property
 * @param {number} line
 * @param {number} column
 */
function validate_binding(binding, get_object, get_property, line, column) {
  var warned = false;

  var filename = dev_current_component_function?.[FILENAME];

  render_effect(() => {
    if (warned) return;

    var [object, is_store_sub] = capture_store_binding(get_object);

    if (is_store_sub) return;

    var property = get_property();

    var ran = false;

    // by making the (possibly false, but it would be an extreme edge case) assumption
    // that a getter has a corresponding setter, we can determine if a property is
    // reactive by seeing if this effect has dependencies
    var effect = render_effect(() => {
      if (ran) return;

      // eslint-disable-next-line @typescript-eslint/no-unused-expressions
      object[property];
    });

    ran = true;

    if (effect.deps === null) {
      var location = `${filename}:${line}:${column}`;
      binding_property_non_reactive(binding, location);

      warned = true;
    }
  });
}

var top = "top";
var bottom = "bottom";
var right = "right";
var left = "left";
var auto = "auto";
var basePlacements = [top, bottom, right, left];
var start$1 = "start";
var end = "end";
var clippingParents = "clippingParents";
var viewport = "viewport";
var popper = "popper";
var reference = "reference";
var variationPlacements = /*#__PURE__*/ basePlacements.reduce(function (
  acc,
  placement,
) {
  return acc.concat([placement + "-" + start$1, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/ []
  .concat(basePlacements, [auto])
  .reduce(function (acc, placement) {
    return acc.concat([
      placement,
      placement + "-" + start$1,
      placement + "-" + end,
    ]);
  }, []); // modifiers that need to read the DOM

var beforeRead = "beforeRead";
var read = "read";
var afterRead = "afterRead"; // pure-logic modifiers

var beforeMain = "beforeMain";
var main = "main";
var afterMain = "afterMain"; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = "beforeWrite";
var write = "write";
var afterWrite = "afterWrite";
var modifierPhases = [
  beforeRead,
  read,
  afterRead,
  beforeMain,
  main,
  afterMain,
  beforeWrite,
  write,
  afterWrite,
];

function getNodeName(element) {
  return element ? (element.nodeName || "").toLowerCase() : null;
}

function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== "[object Window]") {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

function isElement$1(node) {
  var OwnElement = getWindow(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = getWindow(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === "undefined") {
    return false;
  }

  var OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}

// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!isHTMLElement(element) || !getNodeName(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]

    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? "" : value);
      }
    });
  });
}

function effect$2(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: "0",
      top: "0",
      margin: "0",
    },
    arrow: {
      position: "absolute",
    },
    reference: {},
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(
        state.styles.hasOwnProperty(name)
          ? state.styles[name]
          : initialStyles[name],
      ); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = "";
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules

const applyStyles$1 = {
  name: "applyStyles",
  enabled: true,
  phase: "write",
  fn: applyStyles,
  effect: effect$2,
  requires: ["computeStyles"],
};

function getBasePlacement$1(placement) {
  return placement.split("-")[0];
}

var max = Math.max;
var min = Math.min;
var round = Math.round;

function getUAString() {
  var uaData = navigator.userAgentData;

  if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
    return uaData.brands
      .map(function (item) {
        return item.brand + "/" + item.version;
      })
      .join(" ");
  }

  return navigator.userAgent;
}

function isLayoutViewport() {
  return !/^((?!chrome|android).)*safari/i.test(getUAString());
}

function getBoundingClientRect(element, includeScale, isFixedStrategy) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }

  var clientRect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if (includeScale && isHTMLElement(element)) {
    scaleX =
      element.offsetWidth > 0
        ? round(clientRect.width) / element.offsetWidth || 1
        : 1;
    scaleY =
      element.offsetHeight > 0
        ? round(clientRect.height) / element.offsetHeight || 1
        : 1;
  }

  var _ref = isElement$1(element) ? getWindow(element) : window,
    visualViewport = _ref.visualViewport;

  var addVisualOffsets = !isLayoutViewport() && isFixedStrategy;
  var x =
    (clientRect.left +
      (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) /
    scaleX;
  var y =
    (clientRect.top +
      (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) /
    scaleY;
  var width = clientRect.width / scaleX;
  var height = clientRect.height / scaleY;
  return {
    width: width,
    height: height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x,
    x: x,
    y: y,
  };
}

// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height,
  };
}

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && isShadowRoot(rootNode)) {
    var next = child;

    do {
      if (next && parent.isSameNode(next)) {
        return true;
      } // $FlowFixMe[prop-missing]: need a better way to handle this...

      next = next.parentNode || next.host;
    } while (next);
  } // Give up, the result is false

  return false;
}

function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}

function isTableElement(element) {
  return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
}

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return (
    (isElement$1(element)
      ? element.ownerDocument // $FlowFixMe[prop-missing]
      : element.document) || window.document
  ).documentElement;
}

function getParentNode(element) {
  if (getNodeName(element) === "html") {
    return element;
  }

  return (
    // this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || // DOM Element detected
    (isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    getDocumentElement(element) // fallback
  );
}

function getTrueOffsetParent(element) {
  if (
    !isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
    getComputedStyle$1(element).position === "fixed"
  ) {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block

function getContainingBlock(element) {
  var isFirefox = /firefox/i.test(getUAString());
  var isIE = /Trident/i.test(getUAString());

  if (isIE && isHTMLElement(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = getComputedStyle$1(element);

    if (elementCss.position === "fixed") {
      return null;
    }
  }

  var currentNode = getParentNode(element);

  if (isShadowRoot(currentNode)) {
    currentNode = currentNode.host;
  }

  while (
    isHTMLElement(currentNode) &&
    ["html", "body"].indexOf(getNodeName(currentNode)) < 0
  ) {
    var css = getComputedStyle$1(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (
      css.transform !== "none" ||
      css.perspective !== "none" ||
      css.contain === "paint" ||
      ["transform", "perspective"].indexOf(css.willChange) !== -1 ||
      (isFirefox && css.willChange === "filter") ||
      (isFirefox && css.filter && css.filter !== "none")
    ) {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.

function getOffsetParent(element) {
  var window = getWindow(element);
  var offsetParent = getTrueOffsetParent(element);

  while (
    offsetParent &&
    isTableElement(offsetParent) &&
    getComputedStyle$1(offsetParent).position === "static"
  ) {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (
    offsetParent &&
    (getNodeName(offsetParent) === "html" ||
      (getNodeName(offsetParent) === "body" &&
        getComputedStyle$1(offsetParent).position === "static"))
  ) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

function getMainAxisFromPlacement(placement) {
  return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
}

function within(min$1, value, max$1) {
  return max(min$1, min(value, max$1));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
  };
}

function mergePaddingObject(paddingObject) {
  return Object.assign({}, getFreshSideObject(), paddingObject);
}

function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

var toPaddingObject = function toPaddingObject(padding, state) {
  padding =
    typeof padding === "function"
      ? padding(
          Object.assign({}, state.rects, {
            placement: state.placement,
          }),
        )
      : padding;
  return mergePaddingObject(
    typeof padding !== "number"
      ? padding
      : expandToHashMap(padding, basePlacements),
  );
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
    name = _ref.name,
    options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = getBasePlacement$1(state.placement);
  var axis = getMainAxisFromPlacement(basePlacement);
  var isVertical = [left, right].indexOf(basePlacement) >= 0;
  var len = isVertical ? "height" : "width";

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = getLayoutRect(arrowElement);
  var minProp = axis === "y" ? top : left;
  var maxProp = axis === "y" ? bottom : right;
  var endDiff =
    state.rects.reference[len] +
    state.rects.reference[axis] -
    popperOffsets[axis] -
    state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = getOffsetParent(arrowElement);
  var clientSize = arrowOffsetParent
    ? axis === "y"
      ? arrowOffsetParent.clientHeight || 0
      : arrowOffsetParent.clientWidth || 0
    : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = within(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] =
    ((_state$modifiersData$ = {}),
    (_state$modifiersData$[axisProp] = offset),
    (_state$modifiersData$.centerOffset = offset - center),
    _state$modifiersData$);
}

function effect$1(_ref2) {
  var state = _ref2.state,
    options = _ref2.options;
  var _options$element = options.element,
    arrowElement =
      _options$element === void 0 ? "[data-popper-arrow]" : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector

  if (typeof arrowElement === "string") {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (!contains(state.elements.popper, arrowElement)) {
    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules

const arrow$1 = {
  name: "arrow",
  enabled: true,
  phase: "main",
  fn: arrow,
  effect: effect$1,
  requires: ["popperOffsets"],
  requiresIfExists: ["preventOverflow"],
};

function getVariation(placement) {
  return placement.split("-")[1];
}

var unsetSides = {
  top: "auto",
  right: "auto",
  bottom: "auto",
  left: "auto",
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref, win) {
  var x = _ref.x,
    y = _ref.y;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: round(x * dpr) / dpr || 0,
    y: round(y * dpr) / dpr || 0,
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
    popperRect = _ref2.popperRect,
    placement = _ref2.placement,
    variation = _ref2.variation,
    offsets = _ref2.offsets,
    position = _ref2.position,
    gpuAcceleration = _ref2.gpuAcceleration,
    adaptive = _ref2.adaptive,
    roundOffsets = _ref2.roundOffsets,
    isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
    x = _offsets$x === void 0 ? 0 : _offsets$x,
    _offsets$y = offsets.y,
    y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 =
    typeof roundOffsets === "function"
      ? roundOffsets({
          x: x,
          y: y,
        })
      : {
          x: x,
          y: y,
        };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty("x");
  var hasY = offsets.hasOwnProperty("y");
  var sideX = left;
  var sideY = top;
  var win = window;

  if (adaptive) {
    var offsetParent = getOffsetParent(popper);
    var heightProp = "clientHeight";
    var widthProp = "clientWidth";

    if (offsetParent === getWindow(popper)) {
      offsetParent = getDocumentElement(popper);

      if (
        getComputedStyle$1(offsetParent).position !== "static" &&
        position === "absolute"
      ) {
        heightProp = "scrollHeight";
        widthProp = "scrollWidth";
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it

    offsetParent = offsetParent;

    if (
      placement === top ||
      ((placement === left || placement === right) && variation === end)
    ) {
      sideY = bottom;
      var offsetY =
        isFixed && offsetParent === win && win.visualViewport
          ? win.visualViewport.height // $FlowFixMe[prop-missing]
          : offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (
      placement === left ||
      ((placement === top || placement === bottom) && variation === end)
    ) {
      sideX = right;
      var offsetX =
        isFixed && offsetParent === win && win.visualViewport
          ? win.visualViewport.width // $FlowFixMe[prop-missing]
          : offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign(
    {
      position: position,
    },
    adaptive && unsetSides,
  );

  var _ref4 =
    roundOffsets === true
      ? roundOffsetsByDPR(
          {
            x: x,
            y: y,
          },
          getWindow(popper),
        )
      : {
          x: x,
          y: y,
        };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign(
      {},
      commonStyles,
      ((_Object$assign = {}),
      (_Object$assign[sideY] = hasY ? "0" : ""),
      (_Object$assign[sideX] = hasX ? "0" : ""),
      (_Object$assign.transform =
        (win.devicePixelRatio || 1) <= 1
          ? "translate(" + x + "px, " + y + "px)"
          : "translate3d(" + x + "px, " + y + "px, 0)"),
      _Object$assign),
    );
  }

  return Object.assign(
    {},
    commonStyles,
    ((_Object$assign2 = {}),
    (_Object$assign2[sideY] = hasY ? y + "px" : ""),
    (_Object$assign2[sideX] = hasX ? x + "px" : ""),
    (_Object$assign2.transform = ""),
    _Object$assign2),
  );
}

function computeStyles(_ref5) {
  var state = _ref5.state,
    options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
    gpuAcceleration =
      _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
    _options$adaptive = options.adaptive,
    adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
    _options$roundOffsets = options.roundOffsets,
    roundOffsets =
      _options$roundOffsets === void 0 ? true : _options$roundOffsets;
  var commonStyles = {
    placement: getBasePlacement$1(state.placement),
    variation: getVariation(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === "fixed",
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign(
      {},
      state.styles.popper,
      mapToStyles(
        Object.assign({}, commonStyles, {
          offsets: state.modifiersData.popperOffsets,
          position: state.options.strategy,
          adaptive: adaptive,
          roundOffsets: roundOffsets,
        }),
      ),
    );
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign(
      {},
      state.styles.arrow,
      mapToStyles(
        Object.assign({}, commonStyles, {
          offsets: state.modifiersData.arrow,
          position: "absolute",
          adaptive: false,
          roundOffsets: roundOffsets,
        }),
      ),
    );
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    "data-popper-placement": state.placement,
  });
} // eslint-disable-next-line import/no-unused-modules

const computeStyles$1 = {
  name: "computeStyles",
  enabled: true,
  phase: "beforeWrite",
  fn: computeStyles,
  data: {},
};

var passive = {
  passive: true,
};

function effect(_ref) {
  var state = _ref.state,
    instance = _ref.instance,
    options = _ref.options;
  var _options$scroll = options.scroll,
    scroll = _options$scroll === void 0 ? true : _options$scroll,
    _options$resize = options.resize,
    resize = _options$resize === void 0 ? true : _options$resize;
  var window = getWindow(state.elements.popper);
  var scrollParents = [].concat(
    state.scrollParents.reference,
    state.scrollParents.popper,
  );

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener("scroll", instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener("resize", instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener("scroll", instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener("resize", instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules

const eventListeners = {
  name: "eventListeners",
  enabled: true,
  phase: "write",
  fn: function fn() {},
  effect: effect,
  data: {},
};

var hash$1 = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom",
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash$1[matched];
  });
}

var hash = {
  start: "end",
  end: "start",
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

function getWindowScroll(node) {
  var win = getWindow(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop,
  };
}

function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return (
    getBoundingClientRect(getDocumentElement(element)).left +
    getWindowScroll(element).scrollLeft
  );
}

function getViewportRect(element, strategy) {
  var win = getWindow(element);
  var html = getDocumentElement(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0;

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    var layoutViewport = isLayoutViewport();

    if (layoutViewport || (!layoutViewport && strategy === "fixed")) {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + getWindowScrollBarX(element),
    y: y,
  };
}

// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = getDocumentElement(element);
  var winScroll = getWindowScroll(element);
  var body =
    (_element$ownerDocumen = element.ownerDocument) == null
      ? void 0
      : _element$ownerDocumen.body;
  var width = max(
    html.scrollWidth,
    html.clientWidth,
    body ? body.scrollWidth : 0,
    body ? body.clientWidth : 0,
  );
  var height = max(
    html.scrollHeight,
    html.clientHeight,
    body ? body.scrollHeight : 0,
    body ? body.clientHeight : 0,
  );
  var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
  var y = -winScroll.scrollTop;

  if (getComputedStyle$1(body || html).direction === "rtl") {
    x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y,
  };
}

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = getComputedStyle$1(element),
    overflow = _getComputedStyle.overflow,
    overflowX = _getComputedStyle.overflowX,
    overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

function getScrollParent(node) {
  if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if (isHTMLElement(node) && isScrollParent(node)) {
    return node;
  }

  return getScrollParent(getParentNode(node));
}

/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = getScrollParent(element);
  var isBody =
    scrollParent ===
    ((_element$ownerDocumen = element.ownerDocument) == null
      ? void 0
      : _element$ownerDocumen.body);
  var win = getWindow(scrollParent);
  var target = isBody
    ? [win].concat(
        win.visualViewport || [],
        isScrollParent(scrollParent) ? scrollParent : [],
      )
    : scrollParent;
  var updatedList = list.concat(target);
  return isBody
    ? updatedList // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
    : updatedList.concat(listScrollParents(getParentNode(target)));
}

function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height,
  });
}

function getInnerBoundingClientRect(element, strategy) {
  var rect = getBoundingClientRect(element, false, strategy === "fixed");
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent, strategy) {
  return clippingParent === viewport
    ? rectToClientRect(getViewportRect(element, strategy))
    : isElement$1(clippingParent)
      ? getInnerBoundingClientRect(clippingParent, strategy)
      : rectToClientRect(getDocumentRect(getDocumentElement(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`

function getClippingParents(element) {
  var clippingParents = listScrollParents(getParentNode(element));
  var canEscapeClipping =
    ["absolute", "fixed"].indexOf(getComputedStyle$1(element).position) >= 0;
  var clipperElement =
    canEscapeClipping && isHTMLElement(element)
      ? getOffsetParent(element)
      : element;

  if (!isElement$1(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414

  return clippingParents.filter(function (clippingParent) {
    return (
      isElement$1(clippingParent) &&
      contains(clippingParent, clipperElement) &&
      getNodeName(clippingParent) !== "body"
    );
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents

function getClippingRect(element, boundary, rootBoundary, strategy) {
  var mainClippingParents =
    boundary === "clippingParents"
      ? getClippingParents(element)
      : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(
    function (accRect, clippingParent) {
      var rect = getClientRectFromMixedType(element, clippingParent, strategy);
      accRect.top = max(rect.top, accRect.top);
      accRect.right = min(rect.right, accRect.right);
      accRect.bottom = min(rect.bottom, accRect.bottom);
      accRect.left = max(rect.left, accRect.left);
      return accRect;
    },
    getClientRectFromMixedType(element, firstClippingParent, strategy),
  );
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

function computeOffsets(_ref) {
  var reference = _ref.reference,
    element = _ref.element,
    placement = _ref.placement;
  var basePlacement = placement ? getBasePlacement$1(placement) : null;
  var variation = placement ? getVariation(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case top:
      offsets = {
        x: commonX,
        y: reference.y - element.height,
      };
      break;

    case bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height,
      };
      break;

    case right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY,
      };
      break;

    case left:
      offsets = {
        x: reference.x - element.width,
        y: commonY,
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y,
      };
  }

  var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === "y" ? "height" : "width";

    switch (variation) {
      case start$1:
        offsets[mainAxis] =
          offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case end:
        offsets[mainAxis] =
          offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;
    }
  }

  return offsets;
}

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
    _options$placement = _options.placement,
    placement =
      _options$placement === void 0 ? state.placement : _options$placement,
    _options$strategy = _options.strategy,
    strategy =
      _options$strategy === void 0 ? state.strategy : _options$strategy,
    _options$boundary = _options.boundary,
    boundary =
      _options$boundary === void 0 ? clippingParents : _options$boundary,
    _options$rootBoundary = _options.rootBoundary,
    rootBoundary =
      _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
    _options$elementConte = _options.elementContext,
    elementContext =
      _options$elementConte === void 0 ? popper : _options$elementConte,
    _options$altBoundary = _options.altBoundary,
    altBoundary =
      _options$altBoundary === void 0 ? false : _options$altBoundary,
    _options$padding = _options.padding,
    padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = mergePaddingObject(
    typeof padding !== "number"
      ? padding
      : expandToHashMap(padding, basePlacements),
  );
  var altContext = elementContext === popper ? reference : popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = getClippingRect(
    isElement$1(element)
      ? element
      : element.contextElement || getDocumentElement(state.elements.popper),
    boundary,
    rootBoundary,
    strategy,
  );
  var referenceClientRect = getBoundingClientRect(state.elements.reference);
  var popperOffsets = computeOffsets({
    reference: referenceClientRect,
    element: popperRect,
    placement: placement,
  });
  var popperClientRect = rectToClientRect(
    Object.assign({}, popperRect, popperOffsets),
  );
  var elementClientRect =
    elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom:
      elementClientRect.bottom -
      clippingClientRect.bottom +
      paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right:
      elementClientRect.right - clippingClientRect.right + paddingObject.right,
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
    placement = _options.placement,
    boundary = _options.boundary,
    rootBoundary = _options.rootBoundary,
    padding = _options.padding,
    flipVariations = _options.flipVariations,
    _options$allowedAutoP = _options.allowedAutoPlacements,
    allowedAutoPlacements =
      _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
  var variation = getVariation(placement);
  var placements$1 = variation
    ? flipVariations
      ? variationPlacements
      : variationPlacements.filter(function (placement) {
          return getVariation(placement) === variation;
        })
    : basePlacements;
  var allowedPlacements = placements$1.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements$1;
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...

  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
    })[getBasePlacement$1(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

function getExpandedFallbackPlacements(placement) {
  if (getBasePlacement$1(placement) === auto) {
    return [];
  }

  var oppositePlacement = getOppositePlacement(placement);
  return [
    getOppositeVariationPlacement(placement),
    oppositePlacement,
    getOppositeVariationPlacement(oppositePlacement),
  ];
}

function flip(_ref) {
  var state = _ref.state,
    options = _ref.options,
    name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
    checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
    _options$altAxis = options.altAxis,
    checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
    specifiedFallbackPlacements = options.fallbackPlacements,
    padding = options.padding,
    boundary = options.boundary,
    rootBoundary = options.rootBoundary,
    altBoundary = options.altBoundary,
    _options$flipVariatio = options.flipVariations,
    flipVariations =
      _options$flipVariatio === void 0 ? true : _options$flipVariatio,
    allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = getBasePlacement$1(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements =
    specifiedFallbackPlacements ||
    (isBasePlacement || !flipVariations
      ? [getOppositePlacement(preferredPlacement)]
      : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement]
    .concat(fallbackPlacements)
    .reduce(function (acc, placement) {
      return acc.concat(
        getBasePlacement$1(placement) === auto
          ? computeAutoPlacement(state, {
              placement: placement,
              boundary: boundary,
              rootBoundary: rootBoundary,
              padding: padding,
              flipVariations: flipVariations,
              allowedAutoPlacements: allowedAutoPlacements,
            })
          : placement,
      );
    }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = getBasePlacement$1(placement);

    var isStartVariation = getVariation(placement) === start$1;
    var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? "width" : "height";
    var overflow = detectOverflow(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding,
    });
    var mainVariationSide = isVertical
      ? isStartVariation
        ? right
        : left
      : isStartVariation
        ? bottom
        : top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = getOppositePlacement(mainVariationSide);
    }

    var altVariationSide = getOppositePlacement(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(
        overflow[mainVariationSide] <= 0,
        overflow[altVariationSide] <= 0,
      );
    }

    if (
      checks.every(function (check) {
        return check;
      })
    ) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules

const flip$1 = {
  name: "flip",
  enabled: true,
  phase: "main",
  fn: flip,
  requiresIfExists: ["offset"],
  data: {
    _skip: false,
  },
};

function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0,
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x,
  };
}

function isAnySideFullyClipped(overflow) {
  return [top, right, bottom, left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
    name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = detectOverflow(state, {
    elementContext: "reference",
  });
  var popperAltOverflow = detectOverflow(state, {
    altBoundary: true,
  });
  var referenceClippingOffsets = getSideOffsets(
    referenceOverflow,
    referenceRect,
  );
  var popperEscapeOffsets = getSideOffsets(
    popperAltOverflow,
    popperRect,
    preventedOffsets,
  );
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped,
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    "data-popper-reference-hidden": isReferenceHidden,
    "data-popper-escaped": hasPopperEscaped,
  });
} // eslint-disable-next-line import/no-unused-modules

const hide$1 = {
  name: "hide",
  enabled: true,
  phase: "main",
  requiresIfExists: ["preventOverflow"],
  fn: hide,
};

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = getBasePlacement$1(placement);
  var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref =
      typeof offset === "function"
        ? offset(
            Object.assign({}, rects, {
              placement: placement,
            }),
          )
        : offset,
    skidding = _ref[0],
    distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [left, right].indexOf(basePlacement) >= 0
    ? {
        x: distance,
        y: skidding,
      }
    : {
        x: skidding,
        y: distance,
      };
}

function offset(_ref2) {
  var state = _ref2.state,
    options = _ref2.options,
    name = _ref2.name;
  var _options$offset = options.offset,
    offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
    x = _data$state$placement.x,
    y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules

const offset$1 = {
  name: "offset",
  enabled: true,
  phase: "main",
  requires: ["popperOffsets"],
  fn: offset,
};

function popperOffsets(_ref) {
  var state = _ref.state,
    name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = computeOffsets({
    reference: state.rects.reference,
    element: state.rects.popper,
    placement: state.placement,
  });
} // eslint-disable-next-line import/no-unused-modules

const popperOffsets$1 = {
  name: "popperOffsets",
  enabled: true,
  phase: "read",
  fn: popperOffsets,
  data: {},
};

function getAltAxis(axis) {
  return axis === "x" ? "y" : "x";
}

function preventOverflow(_ref) {
  var state = _ref.state,
    options = _ref.options,
    name = _ref.name;
  var _options$mainAxis = options.mainAxis,
    checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
    _options$altAxis = options.altAxis,
    checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
    boundary = options.boundary,
    rootBoundary = options.rootBoundary,
    altBoundary = options.altBoundary,
    padding = options.padding,
    _options$tether = options.tether,
    tether = _options$tether === void 0 ? true : _options$tether,
    _options$tetherOffset = options.tetherOffset,
    tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = detectOverflow(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary,
  });
  var basePlacement = getBasePlacement$1(state.placement);
  var variation = getVariation(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = getMainAxisFromPlacement(basePlacement);
  var altAxis = getAltAxis(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue =
    typeof tetherOffset === "function"
      ? tetherOffset(
          Object.assign({}, state.rects, {
            placement: state.placement,
          }),
        )
      : tetherOffset;
  var normalizedTetherOffsetValue =
    typeof tetherOffsetValue === "number"
      ? {
          mainAxis: tetherOffsetValue,
          altAxis: tetherOffsetValue,
        }
      : Object.assign(
          {
            mainAxis: 0,
            altAxis: 0,
          },
          tetherOffsetValue,
        );
  var offsetModifierState = state.modifiersData.offset
    ? state.modifiersData.offset[state.placement]
    : null;
  var data = {
    x: 0,
    y: 0,
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === "y" ? top : left;
    var altSide = mainAxis === "y" ? bottom : right;
    var len = mainAxis === "y" ? "height" : "width";
    var offset = popperOffsets[mainAxis];
    var min$1 = offset + overflow[mainSide];
    var max$1 = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === start$1 ? referenceRect[len] : popperRect[len];
    var maxLen = variation === start$1 ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect =
      tether && arrowElement
        ? getLayoutRect(arrowElement)
        : {
            width: 0,
            height: 0,
          };
    var arrowPaddingObject = state.modifiersData["arrow#persistent"]
      ? state.modifiersData["arrow#persistent"].padding
      : getFreshSideObject();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = within(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement
      ? referenceRect[len] / 2 -
        additive -
        arrowLen -
        arrowPaddingMin -
        normalizedTetherOffsetValue.mainAxis
      : minLen -
        arrowLen -
        arrowPaddingMin -
        normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement
      ? -referenceRect[len] / 2 +
        additive +
        arrowLen +
        arrowPaddingMax +
        normalizedTetherOffsetValue.mainAxis
      : maxLen +
        arrowLen +
        arrowPaddingMax +
        normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent =
      state.elements.arrow && getOffsetParent(state.elements.arrow);
    var clientOffset = arrowOffsetParent
      ? mainAxis === "y"
        ? arrowOffsetParent.clientTop || 0
        : arrowOffsetParent.clientLeft || 0
      : 0;
    var offsetModifierValue =
      (_offsetModifierState$ =
        offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) !=
      null
        ? _offsetModifierState$
        : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = within(
      tether ? min(min$1, tetherMin) : min$1,
      offset,
      tether ? max(max$1, tetherMax) : max$1,
    );
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === "x" ? top : left;

    var _altSide = mainAxis === "x" ? bottom : right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === "y" ? "height" : "width";

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [top, left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue =
      (_offsetModifierState$2 =
        offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) !=
      null
        ? _offsetModifierState$2
        : 0;

    var _tetherMin = isOriginSide
      ? _min
      : _offset -
        referenceRect[_len] -
        popperRect[_len] -
        _offsetModifierValue +
        normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide
      ? _offset +
        referenceRect[_len] +
        popperRect[_len] -
        _offsetModifierValue -
        normalizedTetherOffsetValue.altAxis
      : _max;

    var _preventedOffset =
      tether && isOriginSide
        ? withinMaxClamp(_tetherMin, _offset, _tetherMax)
        : within(
            tether ? _tetherMin : _min,
            _offset,
            tether ? _tetherMax : _max,
          );

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules

const preventOverflow$1 = {
  name: "preventOverflow",
  enabled: true,
  phase: "main",
  fn: preventOverflow,
  requiresIfExists: ["offset"],
};

function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop,
  };
}

function getNodeScroll(node) {
  if (node === getWindow(node) || !isHTMLElement(node)) {
    return getWindowScroll(node);
  } else {
    return getHTMLElementScroll(node);
  }
}

function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = round(rect.width) / element.offsetWidth || 1;
  var scaleY = round(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.

function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = isHTMLElement(offsetParent);
  var offsetParentIsScaled =
    isHTMLElement(offsetParent) && isElementScaled(offsetParent);
  var documentElement = getDocumentElement(offsetParent);
  var rect = getBoundingClientRect(
    elementOrVirtualElement,
    offsetParentIsScaled,
    isFixed,
  );
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0,
  };
  var offsets = {
    x: 0,
    y: 0,
  };

  if (isOffsetParentAnElement || (!isOffsetParentAnElement && !isFixed)) {
    if (
      getNodeName(offsetParent) !== "body" || // https://github.com/popperjs/popper-core/issues/1078
      isScrollParent(documentElement)
    ) {
      scroll = getNodeScroll(offsetParent);
    }

    if (isHTMLElement(offsetParent)) {
      offsets = getBoundingClientRect(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height,
  };
}

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(
      modifier.requires || [],
      modifier.requiresIfExists || [],
    );
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return modifierPhases.reduce(function (acc, phase) {
    return acc.concat(
      orderedModifiers.filter(function (modifier) {
        return modifier.phase === phase;
      }),
    );
  }, []);
}

function debounce$1(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing
      ? Object.assign({}, existing, current, {
          options: Object.assign({}, existing.options, current.options),
          data: Object.assign({}, existing.data, current.data),
        })
      : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

var DEFAULT_OPTIONS = {
  placement: "bottom",
  modifiers: [],
  strategy: "absolute",
};

function areValidElements() {
  for (
    var _len = arguments.length, args = new Array(_len), _key = 0;
    _key < _len;
    _key++
  ) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === "function");
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
    _generatorOptions$def = _generatorOptions.defaultModifiers,
    defaultModifiers =
      _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
    _generatorOptions$def2 = _generatorOptions.defaultOptions,
    defaultOptions =
      _generatorOptions$def2 === void 0
        ? DEFAULT_OPTIONS
        : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: "bottom",
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper,
      },
      attributes: {},
      styles: {},
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options =
          typeof setOptionsAction === "function"
            ? setOptionsAction(state.options)
            : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign(
          {},
          defaultOptions,
          state.options,
          options,
        );
        state.scrollParents = {
          reference: isElement$1(reference)
            ? listScrollParents(reference)
            : reference.contextElement
              ? listScrollParents(reference.contextElement)
              : [],
          popper: listScrollParents(popper),
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = orderModifiers(
          mergeByName([].concat(defaultModifiers, state.options.modifiers)),
        ); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        });
        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
          reference = _state$elements.reference,
          popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          return;
        } // Store the reference and popper rects to be read by modifiers

        state.rects = {
          reference: getCompositeRect(
            reference,
            getOffsetParent(popper),
            state.options.strategy === "fixed",
          ),
          popper: getLayoutRect(popper),
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return (state.modifiersData[modifier.name] = Object.assign(
            {},
            modifier.data,
          ));
        });

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
            fn = _state$orderedModifie.fn,
            _state$orderedModifie2 = _state$orderedModifie.options,
            _options =
              _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
            name = _state$orderedModifie.name;

          if (typeof fn === "function") {
            state =
              fn({
                state: state,
                options: _options,
                name: name,
                instance: instance,
              }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: debounce$1(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      },
    };

    if (!areValidElements(reference, popper)) {
      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref) {
        var name = _ref.name,
          _ref$options = _ref.options,
          options = _ref$options === void 0 ? {} : _ref$options,
          effect = _ref.effect;

        if (typeof effect === "function") {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options,
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}

var defaultModifiers = [
  eventListeners,
  popperOffsets$1,
  computeStyles$1,
  applyStyles$1,
  offset$1,
  flip$1,
  preventOverflow$1,
  arrow$1,
  hide$1,
];
var createPopper = /*#__PURE__*/ popperGenerator({
  defaultModifiers: defaultModifiers,
}); // eslint-disable-next-line import/no-unused-modules

var BOX_CLASS = "tippy-box";
var CONTENT_CLASS = "tippy-content";
var BACKDROP_CLASS = "tippy-backdrop";
var ARROW_CLASS = "tippy-arrow";
var SVG_ARROW_CLASS = "tippy-svg-arrow";
var TOUCH_OPTIONS = {
  passive: true,
  capture: true,
};
var TIPPY_DEFAULT_APPEND_TO = function TIPPY_DEFAULT_APPEND_TO2() {
  return document.body;
};
function hasOwnProperty(obj, key) {
  return {}.hasOwnProperty.call(obj, key);
}
function getValueAtIndexOrReturn(value, index, defaultValue) {
  if (Array.isArray(value)) {
    var v = value[index];
    return v == null
      ? Array.isArray(defaultValue)
        ? defaultValue[index]
        : defaultValue
      : v;
  }
  return value;
}
function isType(value, type) {
  var str = {}.toString.call(value);
  return str.indexOf("[object") === 0 && str.indexOf(type + "]") > -1;
}
function invokeWithArgsOrReturn(value, args) {
  return typeof value === "function" ? value.apply(void 0, args) : value;
}
function debounce(fn5, ms) {
  if (ms === 0) {
    return fn5;
  }
  var timeout;
  return function (arg) {
    clearTimeout(timeout);
    timeout = setTimeout(function () {
      fn5(arg);
    }, ms);
  };
}
function removeProperties(obj, keys) {
  var clone = Object.assign({}, obj);
  keys.forEach(function (key) {
    delete clone[key];
  });
  return clone;
}
function splitBySpaces(value) {
  return value.split(/\s+/).filter(Boolean);
}
function normalizeToArray(value) {
  return [].concat(value);
}
function pushIfUnique(arr, value) {
  if (arr.indexOf(value) === -1) {
    arr.push(value);
  }
}
function unique(arr) {
  return arr.filter(function (item, index) {
    return arr.indexOf(item) === index;
  });
}
function getBasePlacement(placement) {
  return placement.split("-")[0];
}
function arrayFrom(value) {
  return [].slice.call(value);
}
function removeUndefinedProps(obj) {
  return Object.keys(obj).reduce(function (acc, key) {
    if (obj[key] !== void 0) {
      acc[key] = obj[key];
    }
    return acc;
  }, {});
}
function div() {
  return document.createElement("div");
}
function isElement(value) {
  return ["Element", "Fragment"].some(function (type) {
    return isType(value, type);
  });
}
function isNodeList(value) {
  return isType(value, "NodeList");
}
function isMouseEvent(value) {
  return isType(value, "MouseEvent");
}
function isReferenceElement(value) {
  return !!(value && value._tippy && value._tippy.reference === value);
}
function getArrayOfElements(value) {
  if (isElement(value)) {
    return [value];
  }
  if (isNodeList(value)) {
    return arrayFrom(value);
  }
  if (Array.isArray(value)) {
    return value;
  }
  return arrayFrom(document.querySelectorAll(value));
}
function setTransitionDuration(els, value) {
  els.forEach(function (el) {
    if (el) {
      el.style.transitionDuration = value + "ms";
    }
  });
}
function setVisibilityState(els, state) {
  els.forEach(function (el) {
    if (el) {
      el.setAttribute("data-state", state);
    }
  });
}
function getOwnerDocument(elementOrElements) {
  var _element$ownerDocumen;
  var _normalizeToArray = normalizeToArray(elementOrElements),
    element = _normalizeToArray[0];
  return element != null &&
    (_element$ownerDocumen = element.ownerDocument) != null &&
    _element$ownerDocumen.body
    ? element.ownerDocument
    : document;
}
function isCursorOutsideInteractiveBorder(popperTreeData, event) {
  var clientX = event.clientX,
    clientY = event.clientY;
  return popperTreeData.every(function (_ref) {
    var popperRect = _ref.popperRect,
      popperState = _ref.popperState,
      props = _ref.props;
    var interactiveBorder = props.interactiveBorder;
    var basePlacement = getBasePlacement(popperState.placement);
    var offsetData = popperState.modifiersData.offset;
    if (!offsetData) {
      return true;
    }
    var topDistance = basePlacement === "bottom" ? offsetData.top.y : 0;
    var bottomDistance = basePlacement === "top" ? offsetData.bottom.y : 0;
    var leftDistance = basePlacement === "right" ? offsetData.left.x : 0;
    var rightDistance = basePlacement === "left" ? offsetData.right.x : 0;
    var exceedsTop = popperRect.top - clientY + topDistance > interactiveBorder;
    var exceedsBottom =
      clientY - popperRect.bottom - bottomDistance > interactiveBorder;
    var exceedsLeft =
      popperRect.left - clientX + leftDistance > interactiveBorder;
    var exceedsRight =
      clientX - popperRect.right - rightDistance > interactiveBorder;
    return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
  });
}
function updateTransitionEndListener(box, action, listener) {
  var method = action + "EventListener";
  ["transitionend", "webkitTransitionEnd"].forEach(function (event) {
    box[method](event, listener);
  });
}
function actualContains(parent, child) {
  var target = child;
  while (target) {
    var _target$getRootNode;
    if (parent.contains(target)) {
      return true;
    }
    target =
      target.getRootNode == null
        ? void 0
        : (_target$getRootNode = target.getRootNode()) == null
          ? void 0
          : _target$getRootNode.host;
  }
  return false;
}
var currentInput = {
  isTouch: false,
};
var lastMouseMoveTime = 0;
function onDocumentTouchStart() {
  if (currentInput.isTouch) {
    return;
  }
  currentInput.isTouch = true;
  if (window.performance) {
    document.addEventListener("mousemove", onDocumentMouseMove);
  }
}
function onDocumentMouseMove() {
  var now = performance.now();
  if (now - lastMouseMoveTime < 20) {
    currentInput.isTouch = false;
    document.removeEventListener("mousemove", onDocumentMouseMove);
  }
  lastMouseMoveTime = now;
}
function onWindowBlur() {
  var activeElement = document.activeElement;
  if (isReferenceElement(activeElement)) {
    var instance = activeElement._tippy;
    if (activeElement.blur && !instance.state.isVisible) {
      activeElement.blur();
    }
  }
}
function bindGlobalEventListeners() {
  document.addEventListener("touchstart", onDocumentTouchStart, TOUCH_OPTIONS);
  window.addEventListener("blur", onWindowBlur);
}
var isBrowser =
  typeof window !== "undefined" && typeof document !== "undefined";
var isIE11 = isBrowser
  ? // @ts-ignore
    !!window.msCrypto
  : false;
function createMemoryLeakWarning(method) {
  var txt = method === "destroy" ? "n already-" : " ";
  return [
    method +
      "() was called on a" +
      txt +
      "destroyed instance. This is a no-op but",
    "indicates a potential memory leak.",
  ].join(" ");
}
function clean(value) {
  var spacesAndTabs = /[ \t]{2,}/g;
  var lineStartWithSpaces = /^[ \t]*/gm;
  return value
    .replace(spacesAndTabs, " ")
    .replace(lineStartWithSpaces, "")
    .trim();
}
function getDevMessage(message) {
  return clean(
    "\n  %ctippy.js\n\n  %c" +
      clean(message) +
      "\n\n  %c👷‍ This is a development-only message. It will be removed in production.\n  ",
  );
}
function getFormattedMessage(message) {
  return [
    getDevMessage(message),
    // title
    "color: #00C584; font-size: 1.3em; font-weight: bold;",
    // message
    "line-height: 1.5",
    // footer
    "color: #a6a095;",
  ];
}
var visitedMessages;
{
  resetVisitedMessages();
}
function resetVisitedMessages() {
  visitedMessages = /* @__PURE__ */ new Set();
}
function warnWhen(condition, message) {
  if (condition && !visitedMessages.has(message)) {
    var _console;
    visitedMessages.add(message);
    (_console = console).warn.apply(_console, getFormattedMessage(message));
  }
}
function errorWhen(condition, message) {
  if (condition && !visitedMessages.has(message)) {
    var _console2;
    visitedMessages.add(message);
    (_console2 = console).error.apply(_console2, getFormattedMessage(message));
  }
}
function validateTargets(targets) {
  var didPassFalsyValue = !targets;
  var didPassPlainObject =
    Object.prototype.toString.call(targets) === "[object Object]" &&
    !targets.addEventListener;
  errorWhen(
    didPassFalsyValue,
    [
      "tippy() was passed",
      "`" + String(targets) + "`",
      "as its targets (first) argument. Valid types are: String, Element,",
      "Element[], or NodeList.",
    ].join(" "),
  );
  errorWhen(
    didPassPlainObject,
    [
      "tippy() was passed a plain object which is not supported as an argument",
      "for virtual positioning. Use props.getReferenceClientRect instead.",
    ].join(" "),
  );
}
var pluginProps = {
  animateFill: false,
  followCursor: false,
  inlinePositioning: false,
  sticky: false,
};
var renderProps = {
  allowHTML: false,
  animation: "fade",
  arrow: true,
  content: "",
  inertia: false,
  maxWidth: 350,
  role: "tooltip",
  theme: "",
  zIndex: 9999,
};
var defaultProps = Object.assign(
  {
    appendTo: TIPPY_DEFAULT_APPEND_TO,
    aria: {
      content: "auto",
      expanded: "auto",
    },
    delay: 0,
    duration: [300, 250],
    getReferenceClientRect: null,
    hideOnClick: true,
    ignoreAttributes: false,
    interactive: false,
    interactiveBorder: 2,
    interactiveDebounce: 0,
    moveTransition: "",
    offset: [0, 10],
    onAfterUpdate: function onAfterUpdate() {},
    onBeforeUpdate: function onBeforeUpdate() {},
    onCreate: function onCreate() {},
    onDestroy: function onDestroy() {},
    onHidden: function onHidden() {},
    onHide: function onHide() {},
    onMount: function onMount() {},
    onShow: function onShow() {},
    onShown: function onShown() {},
    onTrigger: function onTrigger() {},
    onUntrigger: function onUntrigger() {},
    onClickOutside: function onClickOutside() {},
    placement: "top",
    plugins: [],
    popperOptions: {},
    render: null,
    showOnCreate: false,
    touch: true,
    trigger: "mouseenter focus",
    triggerTarget: null,
  },
  pluginProps,
  renderProps,
);
var defaultKeys = Object.keys(defaultProps);
var setDefaultProps = function setDefaultProps2(partialProps) {
  {
    validateProps(partialProps, []);
  }
  var keys = Object.keys(partialProps);
  keys.forEach(function (key) {
    defaultProps[key] = partialProps[key];
  });
};
function getExtendedPassedProps(passedProps) {
  var plugins = passedProps.plugins || [];
  var pluginProps2 = plugins.reduce(function (acc, plugin) {
    var name = plugin.name,
      defaultValue = plugin.defaultValue;
    if (name) {
      var _name;
      acc[name] =
        passedProps[name] !== void 0
          ? passedProps[name]
          : (_name = defaultProps[name]) != null
            ? _name
            : defaultValue;
    }
    return acc;
  }, {});
  return Object.assign({}, passedProps, pluginProps2);
}
function getDataAttributeProps(reference, plugins) {
  var propKeys = plugins
    ? Object.keys(
        getExtendedPassedProps(
          Object.assign({}, defaultProps, {
            plugins,
          }),
        ),
      )
    : defaultKeys;
  var props = propKeys.reduce(function (acc, key) {
    var valueAsString = (
      reference.getAttribute("data-tippy-" + key) || ""
    ).trim();
    if (!valueAsString) {
      return acc;
    }
    if (key === "content") {
      acc[key] = valueAsString;
    } else {
      try {
        acc[key] = JSON.parse(valueAsString);
      } catch (e) {
        acc[key] = valueAsString;
      }
    }
    return acc;
  }, {});
  return props;
}
function evaluateProps(reference, props) {
  var out = Object.assign(
    {},
    props,
    {
      content: invokeWithArgsOrReturn(props.content, [reference]),
    },
    props.ignoreAttributes
      ? {}
      : getDataAttributeProps(reference, props.plugins),
  );
  out.aria = Object.assign({}, defaultProps.aria, out.aria);
  out.aria = {
    expanded:
      out.aria.expanded === "auto" ? props.interactive : out.aria.expanded,
    content:
      out.aria.content === "auto"
        ? props.interactive
          ? null
          : "describedby"
        : out.aria.content,
  };
  return out;
}
function validateProps(partialProps, plugins) {
  if (partialProps === void 0) {
    partialProps = {};
  }
  if (plugins === void 0) {
    plugins = [];
  }
  var keys = Object.keys(partialProps);
  keys.forEach(function (prop) {
    var nonPluginProps = removeProperties(
      defaultProps,
      Object.keys(pluginProps),
    );
    var didPassUnknownProp = !hasOwnProperty(nonPluginProps, prop);
    if (didPassUnknownProp) {
      didPassUnknownProp =
        plugins.filter(function (plugin) {
          return plugin.name === prop;
        }).length === 0;
    }
    warnWhen(
      didPassUnknownProp,
      [
        "`" + prop + "`",
        "is not a valid prop. You may have spelled it incorrectly, or if it's",
        "a plugin, forgot to pass it in an array as props.plugins.",
        "\n\n",
        "All props: https://atomiks.github.io/tippyjs/v6/all-props/\n",
        "Plugins: https://atomiks.github.io/tippyjs/v6/plugins/",
      ].join(" "),
    );
  });
}
var innerHTML = function innerHTML2() {
  return "innerHTML";
};
function dangerouslySetInnerHTML(element, html) {
  element[innerHTML()] = html;
}
function createArrowElement(value) {
  var arrow = div();
  if (value === true) {
    arrow.className = ARROW_CLASS;
  } else {
    arrow.className = SVG_ARROW_CLASS;
    if (isElement(value)) {
      arrow.appendChild(value);
    } else {
      dangerouslySetInnerHTML(arrow, value);
    }
  }
  return arrow;
}
function setContent(content, props) {
  if (isElement(props.content)) {
    dangerouslySetInnerHTML(content, "");
    content.appendChild(props.content);
  } else if (typeof props.content !== "function") {
    if (props.allowHTML) {
      dangerouslySetInnerHTML(content, props.content);
    } else {
      content.textContent = props.content;
    }
  }
}
function getChildren(popper) {
  var box = popper.firstElementChild;
  var boxChildren = arrayFrom(box.children);
  return {
    box,
    content: boxChildren.find(function (node) {
      return node.classList.contains(CONTENT_CLASS);
    }),
    arrow: boxChildren.find(function (node) {
      return (
        node.classList.contains(ARROW_CLASS) ||
        node.classList.contains(SVG_ARROW_CLASS)
      );
    }),
    backdrop: boxChildren.find(function (node) {
      return node.classList.contains(BACKDROP_CLASS);
    }),
  };
}
function render(instance) {
  var popper = div();
  var box = div();
  box.className = BOX_CLASS;
  box.setAttribute("data-state", "hidden");
  box.setAttribute("tabindex", "-1");
  var content = div();
  content.className = CONTENT_CLASS;
  content.setAttribute("data-state", "hidden");
  setContent(content, instance.props);
  popper.appendChild(box);
  box.appendChild(content);
  onUpdate(instance.props, instance.props);
  function onUpdate(prevProps, nextProps) {
    var _getChildren = getChildren(popper),
      box2 = _getChildren.box,
      content2 = _getChildren.content,
      arrow = _getChildren.arrow;
    if (nextProps.theme) {
      box2.setAttribute("data-theme", nextProps.theme);
    } else {
      box2.removeAttribute("data-theme");
    }
    if (typeof nextProps.animation === "string") {
      box2.setAttribute("data-animation", nextProps.animation);
    } else {
      box2.removeAttribute("data-animation");
    }
    if (nextProps.inertia) {
      box2.setAttribute("data-inertia", "");
    } else {
      box2.removeAttribute("data-inertia");
    }
    box2.style.maxWidth =
      typeof nextProps.maxWidth === "number"
        ? nextProps.maxWidth + "px"
        : nextProps.maxWidth;
    if (nextProps.role) {
      box2.setAttribute("role", nextProps.role);
    } else {
      box2.removeAttribute("role");
    }
    if (
      prevProps.content !== nextProps.content ||
      prevProps.allowHTML !== nextProps.allowHTML
    ) {
      setContent(content2, instance.props);
    }
    if (nextProps.arrow) {
      if (!arrow) {
        box2.appendChild(createArrowElement(nextProps.arrow));
      } else if (prevProps.arrow !== nextProps.arrow) {
        box2.removeChild(arrow);
        box2.appendChild(createArrowElement(nextProps.arrow));
      }
    } else if (arrow) {
      box2.removeChild(arrow);
    }
  }
  return {
    popper,
    onUpdate,
  };
}
render.$$tippy = true;
var idCounter = 1;
var mouseMoveListeners = [];
var mountedInstances = [];
function createTippy(reference, passedProps) {
  var props = evaluateProps(
    reference,
    Object.assign(
      {},
      defaultProps,
      getExtendedPassedProps(removeUndefinedProps(passedProps)),
    ),
  );
  var showTimeout;
  var hideTimeout;
  var scheduleHideAnimationFrame;
  var isVisibleFromClick = false;
  var didHideDueToDocumentMouseDown = false;
  var didTouchMove = false;
  var ignoreOnFirstUpdate = false;
  var lastTriggerEvent;
  var currentTransitionEndListener;
  var onFirstUpdate;
  var listeners = [];
  var debouncedOnMouseMove = debounce(onMouseMove, props.interactiveDebounce);
  var currentTarget;
  var id = idCounter++;
  var popperInstance = null;
  var plugins = unique(props.plugins);
  var state = {
    // Is the instance currently enabled?
    isEnabled: true,
    // Is the tippy currently showing and not transitioning out?
    isVisible: false,
    // Has the instance been destroyed?
    isDestroyed: false,
    // Is the tippy currently mounted to the DOM?
    isMounted: false,
    // Has the tippy finished transitioning in?
    isShown: false,
  };
  var instance = {
    // properties
    id,
    reference,
    popper: div(),
    popperInstance,
    props,
    state,
    plugins,
    // methods
    clearDelayTimeouts,
    setProps,
    setContent: setContent2,
    show,
    hide,
    hideWithInteractivity,
    enable,
    disable,
    unmount,
    destroy,
  };
  if (!props.render) {
    {
      errorWhen(true, "render() function has not been supplied.");
    }
    return instance;
  }
  var _props$render = props.render(instance),
    popper = _props$render.popper,
    onUpdate = _props$render.onUpdate;
  popper.setAttribute("data-tippy-root", "");
  popper.id = "tippy-" + instance.id;
  instance.popper = popper;
  reference._tippy = instance;
  popper._tippy = instance;
  var pluginsHooks = plugins.map(function (plugin) {
    return plugin.fn(instance);
  });
  var hasAriaExpanded = reference.hasAttribute("aria-expanded");
  addListeners();
  handleAriaExpandedAttribute();
  handleStyles();
  invokeHook("onCreate", [instance]);
  if (props.showOnCreate) {
    scheduleShow();
  }
  popper.addEventListener("mouseenter", function () {
    if (instance.props.interactive && instance.state.isVisible) {
      instance.clearDelayTimeouts();
    }
  });
  popper.addEventListener("mouseleave", function () {
    if (
      instance.props.interactive &&
      instance.props.trigger.indexOf("mouseenter") >= 0
    ) {
      getDocument().addEventListener("mousemove", debouncedOnMouseMove);
    }
  });
  return instance;
  function getNormalizedTouchSettings() {
    var touch = instance.props.touch;
    return Array.isArray(touch) ? touch : [touch, 0];
  }
  function getIsCustomTouchBehavior() {
    return getNormalizedTouchSettings()[0] === "hold";
  }
  function getIsDefaultRenderFn() {
    var _instance$props$rende;
    return !!(
      (_instance$props$rende = instance.props.render) != null &&
      _instance$props$rende.$$tippy
    );
  }
  function getCurrentTarget() {
    return currentTarget || reference;
  }
  function getDocument() {
    var parent = getCurrentTarget().parentNode;
    return parent ? getOwnerDocument(parent) : document;
  }
  function getDefaultTemplateChildren() {
    return getChildren(popper);
  }
  function getDelay(isShow) {
    if (
      (instance.state.isMounted && !instance.state.isVisible) ||
      currentInput.isTouch ||
      (lastTriggerEvent && lastTriggerEvent.type === "focus")
    ) {
      return 0;
    }
    return getValueAtIndexOrReturn(
      instance.props.delay,
      isShow ? 0 : 1,
      defaultProps.delay,
    );
  }
  function handleStyles(fromHide) {
    if (fromHide === void 0) {
      fromHide = false;
    }
    popper.style.pointerEvents =
      instance.props.interactive && !fromHide ? "" : "none";
    popper.style.zIndex = "" + instance.props.zIndex;
  }
  function invokeHook(hook, args, shouldInvokePropsHook) {
    if (shouldInvokePropsHook === void 0) {
      shouldInvokePropsHook = true;
    }
    pluginsHooks.forEach(function (pluginHooks) {
      if (pluginHooks[hook]) {
        pluginHooks[hook].apply(pluginHooks, args);
      }
    });
    if (shouldInvokePropsHook) {
      var _instance$props;
      (_instance$props = instance.props)[hook].apply(_instance$props, args);
    }
  }
  function handleAriaContentAttribute() {
    var aria = instance.props.aria;
    if (!aria.content) {
      return;
    }
    var attr = "aria-" + aria.content;
    var id2 = popper.id;
    var nodes = normalizeToArray(instance.props.triggerTarget || reference);
    nodes.forEach(function (node) {
      var currentValue = node.getAttribute(attr);
      if (instance.state.isVisible) {
        node.setAttribute(attr, currentValue ? currentValue + " " + id2 : id2);
      } else {
        var nextValue = currentValue && currentValue.replace(id2, "").trim();
        if (nextValue) {
          node.setAttribute(attr, nextValue);
        } else {
          node.removeAttribute(attr);
        }
      }
    });
  }
  function handleAriaExpandedAttribute() {
    if (hasAriaExpanded || !instance.props.aria.expanded) {
      return;
    }
    var nodes = normalizeToArray(instance.props.triggerTarget || reference);
    nodes.forEach(function (node) {
      if (instance.props.interactive) {
        node.setAttribute(
          "aria-expanded",
          instance.state.isVisible && node === getCurrentTarget()
            ? "true"
            : "false",
        );
      } else {
        node.removeAttribute("aria-expanded");
      }
    });
  }
  function cleanupInteractiveMouseListeners() {
    getDocument().removeEventListener("mousemove", debouncedOnMouseMove);
    mouseMoveListeners = mouseMoveListeners.filter(function (listener) {
      return listener !== debouncedOnMouseMove;
    });
  }
  function onDocumentPress(event) {
    if (currentInput.isTouch) {
      if (didTouchMove || event.type === "mousedown") {
        return;
      }
    }
    var actualTarget =
      (event.composedPath && event.composedPath()[0]) || event.target;
    if (instance.props.interactive && actualContains(popper, actualTarget)) {
      return;
    }
    if (
      normalizeToArray(instance.props.triggerTarget || reference).some(
        function (el) {
          return actualContains(el, actualTarget);
        },
      )
    ) {
      if (currentInput.isTouch) {
        return;
      }
      if (
        instance.state.isVisible &&
        instance.props.trigger.indexOf("click") >= 0
      ) {
        return;
      }
    } else {
      invokeHook("onClickOutside", [instance, event]);
    }
    if (instance.props.hideOnClick === true) {
      instance.clearDelayTimeouts();
      instance.hide();
      didHideDueToDocumentMouseDown = true;
      setTimeout(function () {
        didHideDueToDocumentMouseDown = false;
      });
      if (!instance.state.isMounted) {
        removeDocumentPress();
      }
    }
  }
  function onTouchMove() {
    didTouchMove = true;
  }
  function onTouchStart() {
    didTouchMove = false;
  }
  function addDocumentPress() {
    var doc = getDocument();
    doc.addEventListener("mousedown", onDocumentPress, true);
    doc.addEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
    doc.addEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
    doc.addEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
  }
  function removeDocumentPress() {
    var doc = getDocument();
    doc.removeEventListener("mousedown", onDocumentPress, true);
    doc.removeEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
    doc.removeEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
    doc.removeEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
  }
  function onTransitionedOut(duration, callback) {
    onTransitionEnd(duration, function () {
      if (
        !instance.state.isVisible &&
        popper.parentNode &&
        popper.parentNode.contains(popper)
      ) {
        callback();
      }
    });
  }
  function onTransitionedIn(duration, callback) {
    onTransitionEnd(duration, callback);
  }
  function onTransitionEnd(duration, callback) {
    var box = getDefaultTemplateChildren().box;
    function listener(event) {
      if (event.target === box) {
        updateTransitionEndListener(box, "remove", listener);
        callback();
      }
    }
    if (duration === 0) {
      return callback();
    }
    updateTransitionEndListener(box, "remove", currentTransitionEndListener);
    updateTransitionEndListener(box, "add", listener);
    currentTransitionEndListener = listener;
  }
  function on(eventType, handler, options) {
    if (options === void 0) {
      options = false;
    }
    var nodes = normalizeToArray(instance.props.triggerTarget || reference);
    nodes.forEach(function (node) {
      node.addEventListener(eventType, handler, options);
      listeners.push({
        node,
        eventType,
        handler,
        options,
      });
    });
  }
  function addListeners() {
    if (getIsCustomTouchBehavior()) {
      on("touchstart", onTrigger2, {
        passive: true,
      });
      on("touchend", onMouseLeave, {
        passive: true,
      });
    }
    splitBySpaces(instance.props.trigger).forEach(function (eventType) {
      if (eventType === "manual") {
        return;
      }
      on(eventType, onTrigger2);
      switch (eventType) {
        case "mouseenter":
          on("mouseleave", onMouseLeave);
          break;
        case "focus":
          on(isIE11 ? "focusout" : "blur", onBlurOrFocusOut);
          break;
        case "focusin":
          on("focusout", onBlurOrFocusOut);
          break;
      }
    });
  }
  function removeListeners() {
    listeners.forEach(function (_ref) {
      var node = _ref.node,
        eventType = _ref.eventType,
        handler = _ref.handler,
        options = _ref.options;
      node.removeEventListener(eventType, handler, options);
    });
    listeners = [];
  }
  function onTrigger2(event) {
    var _lastTriggerEvent;
    var shouldScheduleClickHide = false;
    if (
      !instance.state.isEnabled ||
      isEventListenerStopped(event) ||
      didHideDueToDocumentMouseDown
    ) {
      return;
    }
    var wasFocused =
      ((_lastTriggerEvent = lastTriggerEvent) == null
        ? void 0
        : _lastTriggerEvent.type) === "focus";
    lastTriggerEvent = event;
    currentTarget = event.currentTarget;
    handleAriaExpandedAttribute();
    if (!instance.state.isVisible && isMouseEvent(event)) {
      mouseMoveListeners.forEach(function (listener) {
        return listener(event);
      });
    }
    if (
      event.type === "click" &&
      (instance.props.trigger.indexOf("mouseenter") < 0 ||
        isVisibleFromClick) &&
      instance.props.hideOnClick !== false &&
      instance.state.isVisible
    ) {
      shouldScheduleClickHide = true;
    } else {
      scheduleShow(event);
    }
    if (event.type === "click") {
      isVisibleFromClick = !shouldScheduleClickHide;
    }
    if (shouldScheduleClickHide && !wasFocused) {
      scheduleHide(event);
    }
  }
  function onMouseMove(event) {
    var target = event.target;
    var isCursorOverReferenceOrPopper =
      getCurrentTarget().contains(target) || popper.contains(target);
    if (event.type === "mousemove" && isCursorOverReferenceOrPopper) {
      return;
    }
    var popperTreeData = getNestedPopperTree()
      .concat(popper)
      .map(function (popper2) {
        var _instance$popperInsta;
        var instance2 = popper2._tippy;
        var state2 =
          (_instance$popperInsta = instance2.popperInstance) == null
            ? void 0
            : _instance$popperInsta.state;
        if (state2) {
          return {
            popperRect: popper2.getBoundingClientRect(),
            popperState: state2,
            props,
          };
        }
        return null;
      })
      .filter(Boolean);
    if (isCursorOutsideInteractiveBorder(popperTreeData, event)) {
      cleanupInteractiveMouseListeners();
      scheduleHide(event);
    }
  }
  function onMouseLeave(event) {
    var shouldBail =
      isEventListenerStopped(event) ||
      (instance.props.trigger.indexOf("click") >= 0 && isVisibleFromClick);
    if (shouldBail) {
      return;
    }
    if (instance.props.interactive) {
      instance.hideWithInteractivity(event);
      return;
    }
    scheduleHide(event);
  }
  function onBlurOrFocusOut(event) {
    if (
      instance.props.trigger.indexOf("focusin") < 0 &&
      event.target !== getCurrentTarget()
    ) {
      return;
    }
    if (
      instance.props.interactive &&
      event.relatedTarget &&
      popper.contains(event.relatedTarget)
    ) {
      return;
    }
    scheduleHide(event);
  }
  function isEventListenerStopped(event) {
    return currentInput.isTouch
      ? getIsCustomTouchBehavior() !== event.type.indexOf("touch") >= 0
      : false;
  }
  function createPopperInstance() {
    destroyPopperInstance();
    var _instance$props2 = instance.props,
      popperOptions = _instance$props2.popperOptions,
      placement = _instance$props2.placement,
      offset = _instance$props2.offset,
      getReferenceClientRect = _instance$props2.getReferenceClientRect,
      moveTransition = _instance$props2.moveTransition;
    var arrow = getIsDefaultRenderFn() ? getChildren(popper).arrow : null;
    var computedReference = getReferenceClientRect
      ? {
          getBoundingClientRect: getReferenceClientRect,
          contextElement:
            getReferenceClientRect.contextElement || getCurrentTarget(),
        }
      : reference;
    var tippyModifier = {
      name: "$$tippy",
      enabled: true,
      phase: "beforeWrite",
      requires: ["computeStyles"],
      fn: function fn5(_ref2) {
        var state2 = _ref2.state;
        if (getIsDefaultRenderFn()) {
          var _getDefaultTemplateCh = getDefaultTemplateChildren(),
            box = _getDefaultTemplateCh.box;
          ["placement", "reference-hidden", "escaped"].forEach(function (attr) {
            if (attr === "placement") {
              box.setAttribute("data-placement", state2.placement);
            } else {
              if (state2.attributes.popper["data-popper-" + attr]) {
                box.setAttribute("data-" + attr, "");
              } else {
                box.removeAttribute("data-" + attr);
              }
            }
          });
          state2.attributes.popper = {};
        }
      },
    };
    var modifiers = [
      {
        name: "offset",
        options: {
          offset,
        },
      },
      {
        name: "preventOverflow",
        options: {
          padding: {
            top: 2,
            bottom: 2,
            left: 5,
            right: 5,
          },
        },
      },
      {
        name: "flip",
        options: {
          padding: 5,
        },
      },
      {
        name: "computeStyles",
        options: {
          adaptive: !moveTransition,
        },
      },
      tippyModifier,
    ];
    if (getIsDefaultRenderFn() && arrow) {
      modifiers.push({
        name: "arrow",
        options: {
          element: arrow,
          padding: 3,
        },
      });
    }
    modifiers.push.apply(
      modifiers,
      (popperOptions == null ? void 0 : popperOptions.modifiers) || [],
    );
    instance.popperInstance = createPopper(
      computedReference,
      popper,
      Object.assign({}, popperOptions, {
        placement,
        onFirstUpdate,
        modifiers,
      }),
    );
  }
  function destroyPopperInstance() {
    if (instance.popperInstance) {
      instance.popperInstance.destroy();
      instance.popperInstance = null;
    }
  }
  function mount() {
    var appendTo = instance.props.appendTo;
    var parentNode;
    var node = getCurrentTarget();
    if (
      (instance.props.interactive && appendTo === TIPPY_DEFAULT_APPEND_TO) ||
      appendTo === "parent"
    ) {
      parentNode = node.parentNode;
    } else {
      parentNode = invokeWithArgsOrReturn(appendTo, [node]);
    }
    if (!parentNode.contains(popper)) {
      parentNode.appendChild(popper);
    }
    instance.state.isMounted = true;
    createPopperInstance();
    {
      warnWhen(
        instance.props.interactive &&
          appendTo === defaultProps.appendTo &&
          node.nextElementSibling !== popper,
        [
          "Interactive tippy element may not be accessible via keyboard",
          "navigation because it is not directly after the reference element",
          "in the DOM source order.",
          "\n\n",
          "Using a wrapper <div> or <span> tag around the reference element",
          "solves this by creating a new parentNode context.",
          "\n\n",
          "Specifying `appendTo: document.body` silences this warning, but it",
          "assumes you are using a focus management solution to handle",
          "keyboard navigation.",
          "\n\n",
          "See: https://atomiks.github.io/tippyjs/v6/accessibility/#interactivity",
        ].join(" "),
      );
    }
  }
  function getNestedPopperTree() {
    return arrayFrom(popper.querySelectorAll("[data-tippy-root]"));
  }
  function scheduleShow(event) {
    instance.clearDelayTimeouts();
    if (event) {
      invokeHook("onTrigger", [instance, event]);
    }
    addDocumentPress();
    var delay = getDelay(true);
    var _getNormalizedTouchSe = getNormalizedTouchSettings(),
      touchValue = _getNormalizedTouchSe[0],
      touchDelay = _getNormalizedTouchSe[1];
    if (currentInput.isTouch && touchValue === "hold" && touchDelay) {
      delay = touchDelay;
    }
    if (delay) {
      showTimeout = setTimeout(function () {
        instance.show();
      }, delay);
    } else {
      instance.show();
    }
  }
  function scheduleHide(event) {
    instance.clearDelayTimeouts();
    invokeHook("onUntrigger", [instance, event]);
    if (!instance.state.isVisible) {
      removeDocumentPress();
      return;
    }
    if (
      instance.props.trigger.indexOf("mouseenter") >= 0 &&
      instance.props.trigger.indexOf("click") >= 0 &&
      ["mouseleave", "mousemove"].indexOf(event.type) >= 0 &&
      isVisibleFromClick
    ) {
      return;
    }
    var delay = getDelay(false);
    if (delay) {
      hideTimeout = setTimeout(function () {
        if (instance.state.isVisible) {
          instance.hide();
        }
      }, delay);
    } else {
      scheduleHideAnimationFrame = requestAnimationFrame(function () {
        instance.hide();
      });
    }
  }
  function enable() {
    instance.state.isEnabled = true;
  }
  function disable() {
    instance.hide();
    instance.state.isEnabled = false;
  }
  function clearDelayTimeouts() {
    clearTimeout(showTimeout);
    clearTimeout(hideTimeout);
    cancelAnimationFrame(scheduleHideAnimationFrame);
  }
  function setProps(partialProps) {
    {
      warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("setProps"));
    }
    if (instance.state.isDestroyed) {
      return;
    }
    invokeHook("onBeforeUpdate", [instance, partialProps]);
    removeListeners();
    var prevProps = instance.props;
    var nextProps = evaluateProps(
      reference,
      Object.assign({}, prevProps, removeUndefinedProps(partialProps), {
        ignoreAttributes: true,
      }),
    );
    instance.props = nextProps;
    addListeners();
    if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
      cleanupInteractiveMouseListeners();
      debouncedOnMouseMove = debounce(
        onMouseMove,
        nextProps.interactiveDebounce,
      );
    }
    if (prevProps.triggerTarget && !nextProps.triggerTarget) {
      normalizeToArray(prevProps.triggerTarget).forEach(function (node) {
        node.removeAttribute("aria-expanded");
      });
    } else if (nextProps.triggerTarget) {
      reference.removeAttribute("aria-expanded");
    }
    handleAriaExpandedAttribute();
    handleStyles();
    if (onUpdate) {
      onUpdate(prevProps, nextProps);
    }
    if (instance.popperInstance) {
      createPopperInstance();
      getNestedPopperTree().forEach(function (nestedPopper) {
        requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
      });
    }
    invokeHook("onAfterUpdate", [instance, partialProps]);
  }
  function setContent2(content) {
    instance.setProps({
      content,
    });
  }
  function show() {
    {
      warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("show"));
    }
    var isAlreadyVisible = instance.state.isVisible;
    var isDestroyed = instance.state.isDestroyed;
    var isDisabled = !instance.state.isEnabled;
    var isTouchAndTouchDisabled = currentInput.isTouch && !instance.props.touch;
    var duration = getValueAtIndexOrReturn(
      instance.props.duration,
      0,
      defaultProps.duration,
    );
    if (
      isAlreadyVisible ||
      isDestroyed ||
      isDisabled ||
      isTouchAndTouchDisabled
    ) {
      return;
    }
    if (getCurrentTarget().hasAttribute("disabled")) {
      return;
    }
    invokeHook("onShow", [instance], false);
    if (instance.props.onShow(instance) === false) {
      return;
    }
    instance.state.isVisible = true;
    if (getIsDefaultRenderFn()) {
      popper.style.visibility = "visible";
    }
    handleStyles();
    addDocumentPress();
    if (!instance.state.isMounted) {
      popper.style.transition = "none";
    }
    if (getIsDefaultRenderFn()) {
      var _getDefaultTemplateCh2 = getDefaultTemplateChildren(),
        box = _getDefaultTemplateCh2.box,
        content = _getDefaultTemplateCh2.content;
      setTransitionDuration([box, content], 0);
    }
    onFirstUpdate = function onFirstUpdate2() {
      var _instance$popperInsta2;
      if (!instance.state.isVisible || ignoreOnFirstUpdate) {
        return;
      }
      ignoreOnFirstUpdate = true;
      void popper.offsetHeight;
      popper.style.transition = instance.props.moveTransition;
      if (getIsDefaultRenderFn() && instance.props.animation) {
        var _getDefaultTemplateCh3 = getDefaultTemplateChildren(),
          _box = _getDefaultTemplateCh3.box,
          _content = _getDefaultTemplateCh3.content;
        setTransitionDuration([_box, _content], duration);
        setVisibilityState([_box, _content], "visible");
      }
      handleAriaContentAttribute();
      handleAriaExpandedAttribute();
      pushIfUnique(mountedInstances, instance);
      (_instance$popperInsta2 = instance.popperInstance) == null
        ? void 0
        : _instance$popperInsta2.forceUpdate();
      invokeHook("onMount", [instance]);
      if (instance.props.animation && getIsDefaultRenderFn()) {
        onTransitionedIn(duration, function () {
          instance.state.isShown = true;
          invokeHook("onShown", [instance]);
        });
      }
    };
    mount();
  }
  function hide() {
    {
      warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("hide"));
    }
    var isAlreadyHidden = !instance.state.isVisible;
    var isDestroyed = instance.state.isDestroyed;
    var isDisabled = !instance.state.isEnabled;
    var duration = getValueAtIndexOrReturn(
      instance.props.duration,
      1,
      defaultProps.duration,
    );
    if (isAlreadyHidden || isDestroyed || isDisabled) {
      return;
    }
    invokeHook("onHide", [instance], false);
    if (instance.props.onHide(instance) === false) {
      return;
    }
    instance.state.isVisible = false;
    instance.state.isShown = false;
    ignoreOnFirstUpdate = false;
    isVisibleFromClick = false;
    if (getIsDefaultRenderFn()) {
      popper.style.visibility = "hidden";
    }
    cleanupInteractiveMouseListeners();
    removeDocumentPress();
    handleStyles(true);
    if (getIsDefaultRenderFn()) {
      var _getDefaultTemplateCh4 = getDefaultTemplateChildren(),
        box = _getDefaultTemplateCh4.box,
        content = _getDefaultTemplateCh4.content;
      if (instance.props.animation) {
        setTransitionDuration([box, content], duration);
        setVisibilityState([box, content], "hidden");
      }
    }
    handleAriaContentAttribute();
    handleAriaExpandedAttribute();
    if (instance.props.animation) {
      if (getIsDefaultRenderFn()) {
        onTransitionedOut(duration, instance.unmount);
      }
    } else {
      instance.unmount();
    }
  }
  function hideWithInteractivity(event) {
    {
      warnWhen(
        instance.state.isDestroyed,
        createMemoryLeakWarning("hideWithInteractivity"),
      );
    }
    getDocument().addEventListener("mousemove", debouncedOnMouseMove);
    pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
    debouncedOnMouseMove(event);
  }
  function unmount() {
    {
      warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("unmount"));
    }
    if (instance.state.isVisible) {
      instance.hide();
    }
    if (!instance.state.isMounted) {
      return;
    }
    destroyPopperInstance();
    getNestedPopperTree().forEach(function (nestedPopper) {
      nestedPopper._tippy.unmount();
    });
    if (popper.parentNode) {
      popper.parentNode.removeChild(popper);
    }
    mountedInstances = mountedInstances.filter(function (i) {
      return i !== instance;
    });
    instance.state.isMounted = false;
    invokeHook("onHidden", [instance]);
  }
  function destroy() {
    {
      warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("destroy"));
    }
    if (instance.state.isDestroyed) {
      return;
    }
    instance.clearDelayTimeouts();
    instance.unmount();
    removeListeners();
    delete reference._tippy;
    instance.state.isDestroyed = true;
    invokeHook("onDestroy", [instance]);
  }
}
function tippy(targets, optionalProps) {
  if (optionalProps === void 0) {
    optionalProps = {};
  }
  var plugins = defaultProps.plugins.concat(optionalProps.plugins || []);
  {
    validateTargets(targets);
    validateProps(optionalProps, plugins);
  }
  bindGlobalEventListeners();
  var passedProps = Object.assign({}, optionalProps, {
    plugins,
  });
  var elements = getArrayOfElements(targets);
  {
    var isSingleContentElement = isElement(passedProps.content);
    var isMoreThanOneReferenceElement = elements.length > 1;
    warnWhen(
      isSingleContentElement && isMoreThanOneReferenceElement,
      [
        "tippy() was passed an Element as the `content` prop, but more than",
        "one tippy instance was created by this invocation. This means the",
        "content element will only be appended to the last tippy instance.",
        "\n\n",
        "Instead, pass the .innerHTML of the element, or use a function that",
        "returns a cloned version of the element instead.",
        "\n\n",
        "1) content: element.innerHTML\n",
        "2) content: () => element.cloneNode(true)",
      ].join(" "),
    );
  }
  var instances = elements.reduce(function (acc, reference) {
    var instance = reference && createTippy(reference, passedProps);
    if (instance) {
      acc.push(instance);
    }
    return acc;
  }, []);
  return isElement(targets) ? instances[0] : instances;
}
tippy.defaultProps = defaultProps;
tippy.setDefaultProps = setDefaultProps;
tippy.currentInput = currentInput;
Object.assign({}, applyStyles$1, {
  effect: function effect(_ref) {
    var state = _ref.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: "0",
        top: "0",
        margin: "0",
      },
      arrow: {
        position: "absolute",
      },
      reference: {},
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    state.styles = initialStyles;
    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }
  },
});
tippy.setDefaultProps({
  render,
});

// generated during release, do not modify

const PUBLIC_VERSION = "5";

if (typeof window !== "undefined") {
  // @ts-expect-error
  ((window.__svelte ??= {}).v ??= new Set()).add(PUBLIC_VERSION);
}

// https://github.com/python/cpython/blob/a74eea238f5baba15797e2e8b570d153bc8690a7/Modules/mathmodule.c#L1423
class Adder {
  constructor() {
    this._partials = new Float64Array(32);
    this._n = 0;
  }
  add(x) {
    const p = this._partials;
    let i = 0;
    for (let j = 0; j < this._n && j < 32; j++) {
      const y = p[j],
        hi = x + y,
        lo = Math.abs(x) < Math.abs(y) ? x - (hi - y) : y - (hi - x);
      if (lo) p[i++] = lo;
      x = hi;
    }
    p[i] = x;
    this._n = i + 1;
    return this;
  }
  valueOf() {
    const p = this._partials;
    let n = this._n,
      x,
      y,
      lo,
      hi = 0;
    if (n > 0) {
      hi = p[--n];
      while (n > 0) {
        x = hi;
        y = p[--n];
        hi = x + y;
        lo = y - (hi - x);
        if (lo) break;
      }
      if (n > 0 && ((lo < 0 && p[n - 1] < 0) || (lo > 0 && p[n - 1] > 0))) {
        y = lo * 2;
        x = hi + y;
        if (y == x - hi) hi = x;
      }
    }
    return hi;
  }
}

function* flatten(arrays) {
  for (const array of arrays) {
    yield* array;
  }
}

function merge$1(arrays) {
  return Array.from(flatten(arrays));
}

var noop$3 = { value: () => {} };

function dispatch() {
  for (var i = 0, n = arguments.length, _ = {}, t; i < n; ++i) {
    if (!(t = arguments[i] + "") || t in _ || /[\s.]/.test(t))
      throw new Error("illegal type: " + t);
    _[t] = [];
  }
  return new Dispatch(_);
}

function Dispatch(_) {
  this._ = _;
}

function parseTypenames$1(typenames, types) {
  return typenames
    .trim()
    .split(/^|\s+/)
    .map(function (t) {
      var name = "",
        i = t.indexOf(".");
      if (i >= 0) ((name = t.slice(i + 1)), (t = t.slice(0, i)));
      if (t && !types.hasOwnProperty(t)) throw new Error("unknown type: " + t);
      return { type: t, name: name };
    });
}

Dispatch.prototype = dispatch.prototype = {
  constructor: Dispatch,
  on: function (typename, callback) {
    var _ = this._,
      T = parseTypenames$1(typename + "", _),
      t,
      i = -1,
      n = T.length;

    // If no callback was specified, return the callback of the given type and name.
    if (arguments.length < 2) {
      while (++i < n)
        if ((t = (typename = T[i]).type) && (t = get$1(_[t], typename.name)))
          return t;
      return;
    }

    // If a type was specified, set the callback for the given type and name.
    // Otherwise, if a null callback was specified, remove callbacks of the given name.
    if (callback != null && typeof callback !== "function")
      throw new Error("invalid callback: " + callback);
    while (++i < n) {
      if ((t = (typename = T[i]).type))
        _[t] = set$1(_[t], typename.name, callback);
      else if (callback == null)
        for (t in _) _[t] = set$1(_[t], typename.name, null);
    }

    return this;
  },
  copy: function () {
    var copy = {},
      _ = this._;
    for (var t in _) copy[t] = _[t].slice();
    return new Dispatch(copy);
  },
  call: function (type, that) {
    if ((n = arguments.length - 2) > 0)
      for (var args = new Array(n), i = 0, n, t; i < n; ++i)
        args[i] = arguments[i + 2];
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (t = this._[type], i = 0, n = t.length; i < n; ++i)
      t[i].value.apply(that, args);
  },
  apply: function (type, that, args) {
    if (!this._.hasOwnProperty(type)) throw new Error("unknown type: " + type);
    for (var t = this._[type], i = 0, n = t.length; i < n; ++i)
      t[i].value.apply(that, args);
  },
};

function get$1(type, name) {
  for (var i = 0, n = type.length, c; i < n; ++i) {
    if ((c = type[i]).name === name) {
      return c.value;
    }
  }
}

function set$1(type, name, callback) {
  for (var i = 0, n = type.length; i < n; ++i) {
    if (type[i].name === name) {
      ((type[i] = noop$3), (type = type.slice(0, i).concat(type.slice(i + 1))));
      break;
    }
  }
  if (callback != null) type.push({ name: name, value: callback });
  return type;
}

var xhtml = "http://www.w3.org/1999/xhtml";

const namespaces = {
  svg: "http://www.w3.org/2000/svg",
  xhtml: xhtml,
  xlink: "http://www.w3.org/1999/xlink",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns/",
};

function namespace(name) {
  var prefix = (name += ""),
    i = prefix.indexOf(":");
  if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns")
    name = name.slice(i + 1);
  return namespaces.hasOwnProperty(prefix)
    ? { space: namespaces[prefix], local: name }
    : name; // eslint-disable-line no-prototype-builtins
}

function creatorInherit(name) {
  return function () {
    var document = this.ownerDocument,
      uri = this.namespaceURI;
    return uri === xhtml && document.documentElement.namespaceURI === xhtml
      ? document.createElement(name)
      : document.createElementNS(uri, name);
  };
}

function creatorFixed(fullname) {
  return function () {
    return this.ownerDocument.createElementNS(fullname.space, fullname.local);
  };
}

function creator(name) {
  var fullname = namespace(name);
  return (fullname.local ? creatorFixed : creatorInherit)(fullname);
}

function none() {}

function selector(selector) {
  return selector == null
    ? none
    : function () {
        return this.querySelector(selector);
      };
}

function selection_select(select) {
  if (typeof select !== "function") select = selector(select);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group = groups[j],
        n = group.length,
        subgroup = (subgroups[j] = new Array(n)),
        node,
        subnode,
        i = 0;
      i < n;
      ++i
    ) {
      if (
        (node = group[i]) &&
        (subnode = select.call(node, node.__data__, i, group))
      ) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
      }
    }
  }

  return new Selection$1(subgroups, this._parents);
}

// Given something array like (or null), returns something that is strictly an
// array. This is used to ensure that array-like objects passed to d3.selectAll
// or selection.selectAll are converted into proper arrays when creating a
// selection; we don’t ever want to create a selection backed by a live
// HTMLCollection or NodeList. However, note that selection.selectAll will use a
// static NodeList as a group, since it safely derived from querySelectorAll.
function array(x) {
  return x == null ? [] : Array.isArray(x) ? x : Array.from(x);
}

function empty() {
  return [];
}

function selectorAll(selector) {
  return selector == null
    ? empty
    : function () {
        return this.querySelectorAll(selector);
      };
}

function arrayAll(select) {
  return function () {
    return array(select.apply(this, arguments));
  };
}

function selection_selectAll(select) {
  if (typeof select === "function") select = arrayAll(select);
  else select = selectorAll(select);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = [],
      parents = [],
      j = 0;
    j < m;
    ++j
  ) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if ((node = group[i])) {
        subgroups.push(select.call(node, node.__data__, i, group));
        parents.push(node);
      }
    }
  }

  return new Selection$1(subgroups, parents);
}

function matcher(selector) {
  return function () {
    return this.matches(selector);
  };
}

function childMatcher(selector) {
  return function (node) {
    return node.matches(selector);
  };
}

var find = Array.prototype.find;

function childFind(match) {
  return function () {
    return find.call(this.children, match);
  };
}

function childFirst() {
  return this.firstElementChild;
}

function selection_selectChild(match) {
  return this.select(
    match == null
      ? childFirst
      : childFind(typeof match === "function" ? match : childMatcher(match)),
  );
}

var filter = Array.prototype.filter;

function children() {
  return Array.from(this.children);
}

function childrenFilter(match) {
  return function () {
    return filter.call(this.children, match);
  };
}

function selection_selectChildren(match) {
  return this.selectAll(
    match == null
      ? children
      : childrenFilter(
          typeof match === "function" ? match : childMatcher(match),
        ),
  );
}

function selection_filter(match) {
  if (typeof match !== "function") match = matcher(match);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group = groups[j],
        n = group.length,
        subgroup = (subgroups[j] = []),
        node,
        i = 0;
      i < n;
      ++i
    ) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }

  return new Selection$1(subgroups, this._parents);
}

function sparse(update) {
  return new Array(update.length);
}

function selection_enter() {
  return new Selection$1(
    this._enter || this._groups.map(sparse),
    this._parents,
  );
}

function EnterNode(parent, datum) {
  this.ownerDocument = parent.ownerDocument;
  this.namespaceURI = parent.namespaceURI;
  this._next = null;
  this._parent = parent;
  this.__data__ = datum;
}

EnterNode.prototype = {
  constructor: EnterNode,
  appendChild: function (child) {
    return this._parent.insertBefore(child, this._next);
  },
  insertBefore: function (child, next) {
    return this._parent.insertBefore(child, next);
  },
  querySelector: function (selector) {
    return this._parent.querySelector(selector);
  },
  querySelectorAll: function (selector) {
    return this._parent.querySelectorAll(selector);
  },
};

function constant$1(x) {
  return function () {
    return x;
  };
}

function bindIndex(parent, group, enter, update, exit, data) {
  var i = 0,
    node,
    groupLength = group.length,
    dataLength = data.length;

  // Put any non-null nodes that fit into update.
  // Put any null nodes into enter.
  // Put any remaining data into enter.
  for (; i < dataLength; ++i) {
    if ((node = group[i])) {
      node.__data__ = data[i];
      update[i] = node;
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }

  // Put any non-null nodes that don’t fit into exit.
  for (; i < groupLength; ++i) {
    if ((node = group[i])) {
      exit[i] = node;
    }
  }
}

function bindKey(parent, group, enter, update, exit, data, key) {
  var i,
    node,
    nodeByKeyValue = new Map(),
    groupLength = group.length,
    dataLength = data.length,
    keyValues = new Array(groupLength),
    keyValue;

  // Compute the key for each node.
  // If multiple nodes have the same key, the duplicates are added to exit.
  for (i = 0; i < groupLength; ++i) {
    if ((node = group[i])) {
      keyValues[i] = keyValue = key.call(node, node.__data__, i, group) + "";
      if (nodeByKeyValue.has(keyValue)) {
        exit[i] = node;
      } else {
        nodeByKeyValue.set(keyValue, node);
      }
    }
  }

  // Compute the key for each datum.
  // If there a node associated with this key, join and add it to update.
  // If there is not (or the key is a duplicate), add it to enter.
  for (i = 0; i < dataLength; ++i) {
    keyValue = key.call(parent, data[i], i, data) + "";
    if ((node = nodeByKeyValue.get(keyValue))) {
      update[i] = node;
      node.__data__ = data[i];
      nodeByKeyValue.delete(keyValue);
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }

  // Add any remaining nodes that were not bound to data to exit.
  for (i = 0; i < groupLength; ++i) {
    if ((node = group[i]) && nodeByKeyValue.get(keyValues[i]) === node) {
      exit[i] = node;
    }
  }
}

function datum(node) {
  return node.__data__;
}

function selection_data(value, key) {
  if (!arguments.length) return Array.from(this, datum);

  var bind = key ? bindKey : bindIndex,
    parents = this._parents,
    groups = this._groups;

  if (typeof value !== "function") value = constant$1(value);

  for (
    var m = groups.length,
      update = new Array(m),
      enter = new Array(m),
      exit = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    var parent = parents[j],
      group = groups[j],
      groupLength = group.length,
      data = arraylike(
        value.call(parent, parent && parent.__data__, j, parents),
      ),
      dataLength = data.length,
      enterGroup = (enter[j] = new Array(dataLength)),
      updateGroup = (update[j] = new Array(dataLength)),
      exitGroup = (exit[j] = new Array(groupLength));

    bind(parent, group, enterGroup, updateGroup, exitGroup, data, key);

    // Now connect the enter nodes to their following update node, such that
    // appendChild can insert the materialized enter node before this node,
    // rather than at the end of the parent node.
    for (var i0 = 0, i1 = 0, previous, next; i0 < dataLength; ++i0) {
      if ((previous = enterGroup[i0])) {
        if (i0 >= i1) i1 = i0 + 1;
        while (!(next = updateGroup[i1]) && ++i1 < dataLength);
        previous._next = next || null;
      }
    }
  }

  update = new Selection$1(update, parents);
  update._enter = enter;
  update._exit = exit;
  return update;
}

// Given some data, this returns an array-like view of it: an object that
// exposes a length property and allows numeric indexing. Note that unlike
// selectAll, this isn’t worried about “live” collections because the resulting
// array will only be used briefly while data is being bound. (It is possible to
// cause the data to change while iterating by using a key function, but please
// don’t; we’d rather avoid a gratuitous copy.)
function arraylike(data) {
  return typeof data === "object" && "length" in data
    ? data // Array, TypedArray, NodeList, array-like
    : Array.from(data); // Map, Set, iterable, string, or anything else
}

function selection_exit() {
  return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
}

function selection_join(onenter, onupdate, onexit) {
  var enter = this.enter(),
    update = this,
    exit = this.exit();
  if (typeof onenter === "function") {
    enter = onenter(enter);
    if (enter) enter = enter.selection();
  } else {
    enter = enter.append(onenter + "");
  }
  if (onupdate != null) {
    update = onupdate(update);
    if (update) update = update.selection();
  }
  if (onexit == null) exit.remove();
  else onexit(exit);
  return enter && update ? enter.merge(update).order() : update;
}

function selection_merge(context) {
  var selection = context.selection ? context.selection() : context;

  for (
    var groups0 = this._groups,
      groups1 = selection._groups,
      m0 = groups0.length,
      m1 = groups1.length,
      m = Math.min(m0, m1),
      merges = new Array(m0),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group0 = groups0[j],
        group1 = groups1[j],
        n = group0.length,
        merge = (merges[j] = new Array(n)),
        node,
        i = 0;
      i < n;
      ++i
    ) {
      if ((node = group0[i] || group1[i])) {
        merge[i] = node;
      }
    }
  }

  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }

  return new Selection$1(merges, this._parents);
}

function selection_order() {
  for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
    for (
      var group = groups[j], i = group.length - 1, next = group[i], node;
      --i >= 0;

    ) {
      if ((node = group[i])) {
        if (next && node.compareDocumentPosition(next) ^ 4)
          next.parentNode.insertBefore(node, next);
        next = node;
      }
    }
  }

  return this;
}

function selection_sort(compare) {
  if (!compare) compare = ascending;

  function compareNode(a, b) {
    return a && b ? compare(a.__data__, b.__data__) : !a - !b;
  }

  for (
    var groups = this._groups,
      m = groups.length,
      sortgroups = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group = groups[j],
        n = group.length,
        sortgroup = (sortgroups[j] = new Array(n)),
        node,
        i = 0;
      i < n;
      ++i
    ) {
      if ((node = group[i])) {
        sortgroup[i] = node;
      }
    }
    sortgroup.sort(compareNode);
  }

  return new Selection$1(sortgroups, this._parents).order();
}

function ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}

function selection_call() {
  var callback = arguments[0];
  arguments[0] = this;
  callback.apply(null, arguments);
  return this;
}

function selection_nodes() {
  return Array.from(this);
}

function selection_node() {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length; i < n; ++i) {
      var node = group[i];
      if (node) return node;
    }
  }

  return null;
}

function selection_size() {
  let size = 0;
  for (const node of this) ++size; // eslint-disable-line no-unused-vars
  return size;
}

function selection_empty() {
  return !this.node();
}

function selection_each(callback) {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length, node; i < n; ++i) {
      if ((node = group[i])) callback.call(node, node.__data__, i, group);
    }
  }

  return this;
}

function attrRemove$1(name) {
  return function () {
    this.removeAttribute(name);
  };
}

function attrRemoveNS$1(fullname) {
  return function () {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}

function attrConstant$1(name, value) {
  return function () {
    this.setAttribute(name, value);
  };
}

function attrConstantNS$1(fullname, value) {
  return function () {
    this.setAttributeNS(fullname.space, fullname.local, value);
  };
}

function attrFunction$1(name, value) {
  return function () {
    var v = value.apply(this, arguments);
    if (v == null) this.removeAttribute(name);
    else this.setAttribute(name, v);
  };
}

function attrFunctionNS$1(fullname, value) {
  return function () {
    var v = value.apply(this, arguments);
    if (v == null) this.removeAttributeNS(fullname.space, fullname.local);
    else this.setAttributeNS(fullname.space, fullname.local, v);
  };
}

function selection_attr(name, value) {
  var fullname = namespace(name);

  if (arguments.length < 2) {
    var node = this.node();
    return fullname.local
      ? node.getAttributeNS(fullname.space, fullname.local)
      : node.getAttribute(fullname);
  }

  return this.each(
    (value == null
      ? fullname.local
        ? attrRemoveNS$1
        : attrRemove$1
      : typeof value === "function"
        ? fullname.local
          ? attrFunctionNS$1
          : attrFunction$1
        : fullname.local
          ? attrConstantNS$1
          : attrConstant$1)(fullname, value),
  );
}

function defaultView(node) {
  return (
    (node.ownerDocument && node.ownerDocument.defaultView) || // node is a Node
    (node.document && node) || // node is a Window
    node.defaultView
  ); // node is a Document
}

function styleRemove$1(name) {
  return function () {
    this.style.removeProperty(name);
  };
}

function styleConstant$1(name, value, priority) {
  return function () {
    this.style.setProperty(name, value, priority);
  };
}

function styleFunction$1(name, value, priority) {
  return function () {
    var v = value.apply(this, arguments);
    if (v == null) this.style.removeProperty(name);
    else this.style.setProperty(name, v, priority);
  };
}

function selection_style(name, value, priority) {
  return arguments.length > 1
    ? this.each(
        (value == null
          ? styleRemove$1
          : typeof value === "function"
            ? styleFunction$1
            : styleConstant$1)(name, value, priority == null ? "" : priority),
      )
    : styleValue(this.node(), name);
}

function styleValue(node, name) {
  return (
    node.style.getPropertyValue(name) ||
    defaultView(node).getComputedStyle(node, null).getPropertyValue(name)
  );
}

function propertyRemove(name) {
  return function () {
    delete this[name];
  };
}

function propertyConstant(name, value) {
  return function () {
    this[name] = value;
  };
}

function propertyFunction(name, value) {
  return function () {
    var v = value.apply(this, arguments);
    if (v == null) delete this[name];
    else this[name] = v;
  };
}

function selection_property(name, value) {
  return arguments.length > 1
    ? this.each(
        (value == null
          ? propertyRemove
          : typeof value === "function"
            ? propertyFunction
            : propertyConstant)(name, value),
      )
    : this.node()[name];
}

function classArray(string) {
  return string.trim().split(/^|\s+/);
}

function classList(node) {
  return node.classList || new ClassList(node);
}

function ClassList(node) {
  this._node = node;
  this._names = classArray(node.getAttribute("class") || "");
}

ClassList.prototype = {
  add: function (name) {
    var i = this._names.indexOf(name);
    if (i < 0) {
      this._names.push(name);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  remove: function (name) {
    var i = this._names.indexOf(name);
    if (i >= 0) {
      this._names.splice(i, 1);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  contains: function (name) {
    return this._names.indexOf(name) >= 0;
  },
};

function classedAdd(node, names) {
  var list = classList(node),
    i = -1,
    n = names.length;
  while (++i < n) list.add(names[i]);
}

function classedRemove(node, names) {
  var list = classList(node),
    i = -1,
    n = names.length;
  while (++i < n) list.remove(names[i]);
}

function classedTrue(names) {
  return function () {
    classedAdd(this, names);
  };
}

function classedFalse(names) {
  return function () {
    classedRemove(this, names);
  };
}

function classedFunction(names, value) {
  return function () {
    (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
  };
}

function selection_classed(name, value) {
  var names = classArray(name + "");

  if (arguments.length < 2) {
    var list = classList(this.node()),
      i = -1,
      n = names.length;
    while (++i < n) if (!list.contains(names[i])) return false;
    return true;
  }

  return this.each(
    (typeof value === "function"
      ? classedFunction
      : value
        ? classedTrue
        : classedFalse)(names, value),
  );
}

function textRemove() {
  this.textContent = "";
}

function textConstant$1(value) {
  return function () {
    this.textContent = value;
  };
}

function textFunction$1(value) {
  return function () {
    var v = value.apply(this, arguments);
    this.textContent = v == null ? "" : v;
  };
}

function selection_text(value) {
  return arguments.length
    ? this.each(
        value == null
          ? textRemove
          : (typeof value === "function" ? textFunction$1 : textConstant$1)(
              value,
            ),
      )
    : this.node().textContent;
}

function htmlRemove() {
  this.innerHTML = "";
}

function htmlConstant(value) {
  return function () {
    this.innerHTML = value;
  };
}

function htmlFunction(value) {
  return function () {
    var v = value.apply(this, arguments);
    this.innerHTML = v == null ? "" : v;
  };
}

function selection_html(value) {
  return arguments.length
    ? this.each(
        value == null
          ? htmlRemove
          : (typeof value === "function" ? htmlFunction : htmlConstant)(value),
      )
    : this.node().innerHTML;
}

function raise() {
  if (this.nextSibling) this.parentNode.appendChild(this);
}

function selection_raise() {
  return this.each(raise);
}

function lower() {
  if (this.previousSibling)
    this.parentNode.insertBefore(this, this.parentNode.firstChild);
}

function selection_lower() {
  return this.each(lower);
}

function selection_append(name) {
  var create = typeof name === "function" ? name : creator(name);
  return this.select(function () {
    return this.appendChild(create.apply(this, arguments));
  });
}

function constantNull() {
  return null;
}

function selection_insert(name, before) {
  var create = typeof name === "function" ? name : creator(name),
    select =
      before == null
        ? constantNull
        : typeof before === "function"
          ? before
          : selector(before);
  return this.select(function () {
    return this.insertBefore(
      create.apply(this, arguments),
      select.apply(this, arguments) || null,
    );
  });
}

function remove() {
  var parent = this.parentNode;
  if (parent) parent.removeChild(this);
}

function selection_remove() {
  return this.each(remove);
}

function selection_cloneShallow() {
  var clone = this.cloneNode(false),
    parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}

function selection_cloneDeep() {
  var clone = this.cloneNode(true),
    parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}

function selection_clone(deep) {
  return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
}

function selection_datum(value) {
  return arguments.length
    ? this.property("__data__", value)
    : this.node().__data__;
}

function contextListener(listener) {
  return function (event) {
    listener.call(this, event, this.__data__);
  };
}

function parseTypenames(typenames) {
  return typenames
    .trim()
    .split(/^|\s+/)
    .map(function (t) {
      var name = "",
        i = t.indexOf(".");
      if (i >= 0) ((name = t.slice(i + 1)), (t = t.slice(0, i)));
      return { type: t, name: name };
    });
}

function onRemove(typename) {
  return function () {
    var on = this.__on;
    if (!on) return;
    for (var j = 0, i = -1, m = on.length, o; j < m; ++j) {
      if (
        ((o = on[j]),
        (!typename.type || o.type === typename.type) &&
          o.name === typename.name)
      ) {
        this.removeEventListener(o.type, o.listener, o.options);
      } else {
        on[++i] = o;
      }
    }
    if (++i) on.length = i;
    else delete this.__on;
  };
}

function onAdd(typename, value, options) {
  return function () {
    var on = this.__on,
      o,
      listener = contextListener(value);
    if (on)
      for (var j = 0, m = on.length; j < m; ++j) {
        if ((o = on[j]).type === typename.type && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
          this.addEventListener(
            o.type,
            (o.listener = listener),
            (o.options = options),
          );
          o.value = value;
          return;
        }
      }
    this.addEventListener(typename.type, listener, options);
    o = {
      type: typename.type,
      name: typename.name,
      value: value,
      listener: listener,
      options: options,
    };
    if (!on) this.__on = [o];
    else on.push(o);
  };
}

function selection_on(typename, value, options) {
  var typenames = parseTypenames(typename + ""),
    i,
    n = typenames.length,
    t;

  if (arguments.length < 2) {
    var on = this.node().__on;
    if (on)
      for (var j = 0, m = on.length, o; j < m; ++j) {
        for (i = 0, o = on[j]; i < n; ++i) {
          if ((t = typenames[i]).type === o.type && t.name === o.name) {
            return o.value;
          }
        }
      }
    return;
  }

  on = value ? onAdd : onRemove;
  for (i = 0; i < n; ++i) this.each(on(typenames[i], value, options));
  return this;
}

function dispatchEvent(node, type, params) {
  var window = defaultView(node),
    event = window.CustomEvent;

  if (typeof event === "function") {
    event = new event(type, params);
  } else {
    event = window.document.createEvent("Event");
    if (params)
      (event.initEvent(type, params.bubbles, params.cancelable),
        (event.detail = params.detail));
    else event.initEvent(type, false, false);
  }

  node.dispatchEvent(event);
}

function dispatchConstant(type, params) {
  return function () {
    return dispatchEvent(this, type, params);
  };
}

function dispatchFunction(type, params) {
  return function () {
    return dispatchEvent(this, type, params.apply(this, arguments));
  };
}

function selection_dispatch(type, params) {
  return this.each(
    (typeof params === "function" ? dispatchFunction : dispatchConstant)(
      type,
      params,
    ),
  );
}

function* selection_iterator() {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length, node; i < n; ++i) {
      if ((node = group[i])) yield node;
    }
  }
}

var root = [null];

function Selection$1(groups, parents) {
  this._groups = groups;
  this._parents = parents;
}

function selection() {
  return new Selection$1([[document.documentElement]], root);
}

function selection_selection() {
  return this;
}

Selection$1.prototype = selection.prototype = {
  constructor: Selection$1,
  select: selection_select,
  selectAll: selection_selectAll,
  selectChild: selection_selectChild,
  selectChildren: selection_selectChildren,
  filter: selection_filter,
  data: selection_data,
  enter: selection_enter,
  exit: selection_exit,
  join: selection_join,
  merge: selection_merge,
  selection: selection_selection,
  order: selection_order,
  sort: selection_sort,
  call: selection_call,
  nodes: selection_nodes,
  node: selection_node,
  size: selection_size,
  empty: selection_empty,
  each: selection_each,
  attr: selection_attr,
  style: selection_style,
  property: selection_property,
  classed: selection_classed,
  text: selection_text,
  html: selection_html,
  raise: selection_raise,
  lower: selection_lower,
  append: selection_append,
  insert: selection_insert,
  remove: selection_remove,
  clone: selection_clone,
  datum: selection_datum,
  on: selection_on,
  dispatch: selection_dispatch,
  [Symbol.iterator]: selection_iterator,
};

function select(selector) {
  return typeof selector === "string"
    ? new Selection$1(
        [[document.querySelector(selector)]],
        [document.documentElement],
      )
    : new Selection$1([[selector]], root);
}

function define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}

function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition) prototype[key] = definition[key];
  return prototype;
}

function Color() {}

var darker = 0.7;
var brighter = 1 / darker;

var reI = "\\s*([+-]?\\d+)\\s*",
  reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",
  reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
  reHex = /^#([0-9a-f]{3,8})$/,
  reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`),
  reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`),
  reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`),
  reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`),
  reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`),
  reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);

var named = {
  aliceblue: 0xf0f8ff,
  antiquewhite: 0xfaebd7,
  aqua: 0x00ffff,
  aquamarine: 0x7fffd4,
  azure: 0xf0ffff,
  beige: 0xf5f5dc,
  bisque: 0xffe4c4,
  black: 0x000000,
  blanchedalmond: 0xffebcd,
  blue: 0x0000ff,
  blueviolet: 0x8a2be2,
  brown: 0xa52a2a,
  burlywood: 0xdeb887,
  cadetblue: 0x5f9ea0,
  chartreuse: 0x7fff00,
  chocolate: 0xd2691e,
  coral: 0xff7f50,
  cornflowerblue: 0x6495ed,
  cornsilk: 0xfff8dc,
  crimson: 0xdc143c,
  cyan: 0x00ffff,
  darkblue: 0x00008b,
  darkcyan: 0x008b8b,
  darkgoldenrod: 0xb8860b,
  darkgray: 0xa9a9a9,
  darkgreen: 0x006400,
  darkgrey: 0xa9a9a9,
  darkkhaki: 0xbdb76b,
  darkmagenta: 0x8b008b,
  darkolivegreen: 0x556b2f,
  darkorange: 0xff8c00,
  darkorchid: 0x9932cc,
  darkred: 0x8b0000,
  darksalmon: 0xe9967a,
  darkseagreen: 0x8fbc8f,
  darkslateblue: 0x483d8b,
  darkslategray: 0x2f4f4f,
  darkslategrey: 0x2f4f4f,
  darkturquoise: 0x00ced1,
  darkviolet: 0x9400d3,
  deeppink: 0xff1493,
  deepskyblue: 0x00bfff,
  dimgray: 0x696969,
  dimgrey: 0x696969,
  dodgerblue: 0x1e90ff,
  firebrick: 0xb22222,
  floralwhite: 0xfffaf0,
  forestgreen: 0x228b22,
  fuchsia: 0xff00ff,
  gainsboro: 0xdcdcdc,
  ghostwhite: 0xf8f8ff,
  gold: 0xffd700,
  goldenrod: 0xdaa520,
  gray: 0x808080,
  green: 0x008000,
  greenyellow: 0xadff2f,
  grey: 0x808080,
  honeydew: 0xf0fff0,
  hotpink: 0xff69b4,
  indianred: 0xcd5c5c,
  indigo: 0x4b0082,
  ivory: 0xfffff0,
  khaki: 0xf0e68c,
  lavender: 0xe6e6fa,
  lavenderblush: 0xfff0f5,
  lawngreen: 0x7cfc00,
  lemonchiffon: 0xfffacd,
  lightblue: 0xadd8e6,
  lightcoral: 0xf08080,
  lightcyan: 0xe0ffff,
  lightgoldenrodyellow: 0xfafad2,
  lightgray: 0xd3d3d3,
  lightgreen: 0x90ee90,
  lightgrey: 0xd3d3d3,
  lightpink: 0xffb6c1,
  lightsalmon: 0xffa07a,
  lightseagreen: 0x20b2aa,
  lightskyblue: 0x87cefa,
  lightslategray: 0x778899,
  lightslategrey: 0x778899,
  lightsteelblue: 0xb0c4de,
  lightyellow: 0xffffe0,
  lime: 0x00ff00,
  limegreen: 0x32cd32,
  linen: 0xfaf0e6,
  magenta: 0xff00ff,
  maroon: 0x800000,
  mediumaquamarine: 0x66cdaa,
  mediumblue: 0x0000cd,
  mediumorchid: 0xba55d3,
  mediumpurple: 0x9370db,
  mediumseagreen: 0x3cb371,
  mediumslateblue: 0x7b68ee,
  mediumspringgreen: 0x00fa9a,
  mediumturquoise: 0x48d1cc,
  mediumvioletred: 0xc71585,
  midnightblue: 0x191970,
  mintcream: 0xf5fffa,
  mistyrose: 0xffe4e1,
  moccasin: 0xffe4b5,
  navajowhite: 0xffdead,
  navy: 0x000080,
  oldlace: 0xfdf5e6,
  olive: 0x808000,
  olivedrab: 0x6b8e23,
  orange: 0xffa500,
  orangered: 0xff4500,
  orchid: 0xda70d6,
  palegoldenrod: 0xeee8aa,
  palegreen: 0x98fb98,
  paleturquoise: 0xafeeee,
  palevioletred: 0xdb7093,
  papayawhip: 0xffefd5,
  peachpuff: 0xffdab9,
  peru: 0xcd853f,
  pink: 0xffc0cb,
  plum: 0xdda0dd,
  powderblue: 0xb0e0e6,
  purple: 0x800080,
  rebeccapurple: 0x663399,
  red: 0xff0000,
  rosybrown: 0xbc8f8f,
  royalblue: 0x4169e1,
  saddlebrown: 0x8b4513,
  salmon: 0xfa8072,
  sandybrown: 0xf4a460,
  seagreen: 0x2e8b57,
  seashell: 0xfff5ee,
  sienna: 0xa0522d,
  silver: 0xc0c0c0,
  skyblue: 0x87ceeb,
  slateblue: 0x6a5acd,
  slategray: 0x708090,
  slategrey: 0x708090,
  snow: 0xfffafa,
  springgreen: 0x00ff7f,
  steelblue: 0x4682b4,
  tan: 0xd2b48c,
  teal: 0x008080,
  thistle: 0xd8bfd8,
  tomato: 0xff6347,
  turquoise: 0x40e0d0,
  violet: 0xee82ee,
  wheat: 0xf5deb3,
  white: 0xffffff,
  whitesmoke: 0xf5f5f5,
  yellow: 0xffff00,
  yellowgreen: 0x9acd32,
};

define(Color, color, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex, // Deprecated! Use color.formatHex.
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb,
});

function color_formatHex() {
  return this.rgb().formatHex();
}

function color_formatHex8() {
  return this.rgb().formatHex8();
}

function color_formatHsl() {
  return hslConvert(this).formatHsl();
}

function color_formatRgb() {
  return this.rgb().formatRgb();
}

function color(format) {
  var m, l;
  format = (format + "").trim().toLowerCase();
  return (m = reHex.exec(format))
    ? ((l = m[1].length),
      (m = parseInt(m[1], 16)),
      l === 6
        ? rgbn(m) // #ff0000
        : l === 3
          ? new Rgb(
              ((m >> 8) & 0xf) | ((m >> 4) & 0xf0),
              ((m >> 4) & 0xf) | (m & 0xf0),
              ((m & 0xf) << 4) | (m & 0xf),
              1,
            ) // #f00
          : l === 8
            ? rgba(
                (m >> 24) & 0xff,
                (m >> 16) & 0xff,
                (m >> 8) & 0xff,
                (m & 0xff) / 0xff,
              ) // #ff000000
            : l === 4
              ? rgba(
                  ((m >> 12) & 0xf) | ((m >> 8) & 0xf0),
                  ((m >> 8) & 0xf) | ((m >> 4) & 0xf0),
                  ((m >> 4) & 0xf) | (m & 0xf0),
                  (((m & 0xf) << 4) | (m & 0xf)) / 0xff,
                ) // #f000
              : null) // invalid hex
    : (m = reRgbInteger.exec(format))
      ? new Rgb(m[1], m[2], m[3], 1) // rgb(255, 0, 0)
      : (m = reRgbPercent.exec(format))
        ? new Rgb((m[1] * 255) / 100, (m[2] * 255) / 100, (m[3] * 255) / 100, 1) // rgb(100%, 0%, 0%)
        : (m = reRgbaInteger.exec(format))
          ? rgba(m[1], m[2], m[3], m[4]) // rgba(255, 0, 0, 1)
          : (m = reRgbaPercent.exec(format))
            ? rgba(
                (m[1] * 255) / 100,
                (m[2] * 255) / 100,
                (m[3] * 255) / 100,
                m[4],
              ) // rgb(100%, 0%, 0%, 1)
            : (m = reHslPercent.exec(format))
              ? hsla(m[1], m[2] / 100, m[3] / 100, 1) // hsl(120, 50%, 50%)
              : (m = reHslaPercent.exec(format))
                ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) // hsla(120, 50%, 50%, 1)
                : named.hasOwnProperty(format)
                  ? rgbn(named[format]) // eslint-disable-line no-prototype-builtins
                  : format === "transparent"
                    ? new Rgb(NaN, NaN, NaN, 0)
                    : null;
}

function rgbn(n) {
  return new Rgb((n >> 16) & 0xff, (n >> 8) & 0xff, n & 0xff, 1);
}

function rgba(r, g, b, a) {
  if (a <= 0) r = g = b = NaN;
  return new Rgb(r, g, b, a);
}

function rgbConvert(o) {
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}

function rgb(r, g, b, opacity) {
  return arguments.length === 1
    ? rgbConvert(r)
    : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}

function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}

define(
  Rgb,
  rgb,
  extend(Color, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    rgb() {
      return this;
    },
    clamp() {
      return new Rgb(
        clampi(this.r),
        clampi(this.g),
        clampi(this.b),
        clampa(this.opacity),
      );
    },
    displayable() {
      return (
        -0.5 <= this.r &&
        this.r < 255.5 &&
        -0.5 <= this.g &&
        this.g < 255.5 &&
        -0.5 <= this.b &&
        this.b < 255.5 &&
        0 <= this.opacity &&
        this.opacity <= 1
      );
    },
    hex: rgb_formatHex, // Deprecated! Use color.formatHex.
    formatHex: rgb_formatHex,
    formatHex8: rgb_formatHex8,
    formatRgb: rgb_formatRgb,
    toString: rgb_formatRgb,
  }),
);

function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}

function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}

function rgb_formatRgb() {
  const a = clampa(this.opacity);
  return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
}

function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}

function clampi(value) {
  return Math.max(0, Math.min(255, Math.round(value) || 0));
}

function hex(value) {
  value = clampi(value);
  return (value < 16 ? "0" : "") + value.toString(16);
}

function hsla(h, s, l, a) {
  if (a <= 0) h = s = l = NaN;
  else if (l <= 0 || l >= 1) h = s = NaN;
  else if (s <= 0) h = NaN;
  return new Hsl(h, s, l, a);
}

function hslConvert(o) {
  if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color)) o = color(o);
  if (!o) return new Hsl();
  if (o instanceof Hsl) return o;
  o = o.rgb();
  var r = o.r / 255,
    g = o.g / 255,
    b = o.b / 255,
    min = Math.min(r, g, b),
    max = Math.max(r, g, b),
    h = NaN,
    s = max - min,
    l = (max + min) / 2;
  if (s) {
    if (r === max) h = (g - b) / s + (g < b) * 6;
    else if (g === max) h = (b - r) / s + 2;
    else h = (r - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h;
  }
  return new Hsl(h, s, l, o.opacity);
}

function hsl(h, s, l, opacity) {
  return arguments.length === 1
    ? hslConvert(h)
    : new Hsl(h, s, l, opacity == null ? 1 : opacity);
}

function Hsl(h, s, l, opacity) {
  this.h = +h;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}

define(
  Hsl,
  hsl,
  extend(Color, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    rgb() {
      var h = (this.h % 360) + (this.h < 0) * 360,
        s = isNaN(h) || isNaN(this.s) ? 0 : this.s,
        l = this.l,
        m2 = l + (l < 0.5 ? l : 1 - l) * s,
        m1 = 2 * l - m2;
      return new Rgb(
        hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
        hsl2rgb(h, m1, m2),
        hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
        this.opacity,
      );
    },
    clamp() {
      return new Hsl(
        clamph(this.h),
        clampt(this.s),
        clampt(this.l),
        clampa(this.opacity),
      );
    },
    displayable() {
      return (
        ((0 <= this.s && this.s <= 1) || isNaN(this.s)) &&
        0 <= this.l &&
        this.l <= 1 &&
        0 <= this.opacity &&
        this.opacity <= 1
      );
    },
    formatHsl() {
      const a = clampa(this.opacity);
      return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
    },
  }),
);

function clamph(value) {
  value = (value || 0) % 360;
  return value < 0 ? value + 360 : value;
}

function clampt(value) {
  return Math.max(0, Math.min(1, value || 0));
}

/* From FvD 13.37, CSS Color Module Level 3 */
function hsl2rgb(h, m1, m2) {
  return (
    (h < 60
      ? m1 + ((m2 - m1) * h) / 60
      : h < 180
        ? m2
        : h < 240
          ? m1 + ((m2 - m1) * (240 - h)) / 60
          : m1) * 255
  );
}

const constant = (x) => () => x;

function linear(a, d) {
  return function (t) {
    return a + t * d;
  };
}

function exponential(a, b, y) {
  return (
    (a = Math.pow(a, y)),
    (b = Math.pow(b, y) - a),
    (y = 1 / y),
    function (t) {
      return Math.pow(a + t * b, y);
    }
  );
}

function gamma(y) {
  return (y = +y) === 1
    ? nogamma
    : function (a, b) {
        return b - a ? exponential(a, b, y) : constant(isNaN(a) ? b : a);
      };
}

function nogamma(a, b) {
  var d = b - a;
  return d ? linear(a, d) : constant(isNaN(a) ? b : a);
}

const interpolateRgb = (function rgbGamma(y) {
  var color = gamma(y);

  function rgb$1(start, end) {
    var r = color((start = rgb(start)).r, (end = rgb(end)).r),
      g = color(start.g, end.g),
      b = color(start.b, end.b),
      opacity = nogamma(start.opacity, end.opacity);
    return function (t) {
      start.r = r(t);
      start.g = g(t);
      start.b = b(t);
      start.opacity = opacity(t);
      return start + "";
    };
  }

  rgb$1.gamma = rgbGamma;

  return rgb$1;
})(1);

function interpolateNumber(a, b) {
  return (
    (a = +a),
    (b = +b),
    function (t) {
      return a * (1 - t) + b * t;
    }
  );
}

var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
  reB = new RegExp(reA.source, "g");

function zero(b) {
  return function () {
    return b;
  };
}

function one(b) {
  return function (t) {
    return b(t) + "";
  };
}

function interpolateString(a, b) {
  var bi = (reA.lastIndex = reB.lastIndex = 0), // scan index for next number in b
    am, // current match in a
    bm, // current match in b
    bs, // string preceding current number in b, if any
    i = -1, // index in s
    s = [], // string constants and placeholders
    q = []; // number interpolators

  // Coerce inputs to strings.
  ((a = a + ""), (b = b + ""));

  // Interpolate pairs of numbers in a & b.
  while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) {
      // a string precedes the next number in b
      bs = b.slice(bi, bs);
      if (s[i])
        s[i] += bs; // coalesce with previous string
      else s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      // numbers in a & b match
      if (s[i])
        s[i] += bm; // coalesce with previous string
      else s[++i] = bm;
    } else {
      // interpolate non-matching numbers
      s[++i] = null;
      q.push({ i: i, x: interpolateNumber(am, bm) });
    }
    bi = reB.lastIndex;
  }

  // Add remains of b.
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s[i])
      s[i] += bs; // coalesce with previous string
    else s[++i] = bs;
  }

  // Special optimization for only a single match.
  // Otherwise, interpolate each of the numbers and rejoin the string.
  return s.length < 2
    ? q[0]
      ? one(q[0].x)
      : zero(b)
    : ((b = q.length),
      function (t) {
        for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
        return s.join("");
      });
}

var degrees$2 = 180 / Math.PI;

var identity$3 = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1,
};

function decompose(a, b, c, d, e, f) {
  var scaleX, scaleY, skewX;
  if ((scaleX = Math.sqrt(a * a + b * b))) ((a /= scaleX), (b /= scaleX));
  if ((skewX = a * c + b * d)) ((c -= a * skewX), (d -= b * skewX));
  if ((scaleY = Math.sqrt(c * c + d * d)))
    ((c /= scaleY), (d /= scaleY), (skewX /= scaleY));
  if (a * d < b * c) ((a = -a), (b = -b), (skewX = -skewX), (scaleX = -scaleX));
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b, a) * degrees$2,
    skewX: Math.atan(skewX) * degrees$2,
    scaleX: scaleX,
    scaleY: scaleY,
  };
}

var svgNode;

/* eslint-disable no-undef */
function parseCss(value) {
  const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(
    value + "",
  );
  return m.isIdentity ? identity$3 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
}

function parseSvg(value) {
  if (value == null) return identity$3;
  if (!svgNode)
    svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value);
  if (!(value = svgNode.transform.baseVal.consolidate())) return identity$3;
  value = value.matrix;
  return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
}

function interpolateTransform(parse, pxComma, pxParen, degParen) {
  function pop(s) {
    return s.length ? s.pop() + " " : "";
  }

  function translate(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q.push(
        { i: i - 4, x: interpolateNumber(xa, xb) },
        { i: i - 2, x: interpolateNumber(ya, yb) },
      );
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }

  function rotate(a, b, s, q) {
    if (a !== b) {
      if (a - b > 180) b += 360;
      else if (b - a > 180) a += 360; // shortest path
      q.push({
        i: s.push(pop(s) + "rotate(", null, degParen) - 2,
        x: interpolateNumber(a, b),
      });
    } else if (b) {
      s.push(pop(s) + "rotate(" + b + degParen);
    }
  }

  function skewX(a, b, s, q) {
    if (a !== b) {
      q.push({
        i: s.push(pop(s) + "skewX(", null, degParen) - 2,
        x: interpolateNumber(a, b),
      });
    } else if (b) {
      s.push(pop(s) + "skewX(" + b + degParen);
    }
  }

  function scale(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop(s) + "scale(", null, ",", null, ")");
      q.push(
        { i: i - 4, x: interpolateNumber(xa, xb) },
        { i: i - 2, x: interpolateNumber(ya, yb) },
      );
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop(s) + "scale(" + xb + "," + yb + ")");
    }
  }

  return function (a, b) {
    var s = [], // string constants and placeholders
      q = []; // number interpolators
    ((a = parse(a)), (b = parse(b)));
    translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
    rotate(a.rotate, b.rotate, s, q);
    skewX(a.skewX, b.skewX, s, q);
    scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
    a = b = null; // gc
    return function (t) {
      var i = -1,
        n = q.length,
        o;
      while (++i < n) s[(o = q[i]).i] = o.x(t);
      return s.join("");
    };
  };
}

var interpolateTransformCss = interpolateTransform(
  parseCss,
  "px, ",
  "px)",
  "deg)",
);
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");

var frame = 0, // is an animation frame pending?
  timeout$1 = 0, // is a timeout pending?
  interval = 0, // are any timers active?
  pokeDelay = 1000, // how frequently we check for clock skew
  taskHead,
  taskTail,
  clockLast = 0,
  clockNow = 0,
  clockSkew = 0,
  clock =
    typeof performance === "object" && performance.now ? performance : Date,
  setFrame =
    typeof window === "object" && window.requestAnimationFrame
      ? window.requestAnimationFrame.bind(window)
      : function (f) {
          setTimeout(f, 17);
        };

function now() {
  return clockNow || (setFrame(clearNow), (clockNow = clock.now() + clockSkew));
}

function clearNow() {
  clockNow = 0;
}

function Timer() {
  this._call = this._time = this._next = null;
}

Timer.prototype = timer.prototype = {
  constructor: Timer,
  restart: function (callback, delay, time) {
    if (typeof callback !== "function")
      throw new TypeError("callback is not a function");
    time = (time == null ? now() : +time) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail) taskTail._next = this;
      else taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time;
    sleep();
  },
  stop: function () {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  },
};

function timer(callback, delay, time) {
  var t = new Timer();
  t.restart(callback, delay, time);
  return t;
}

function timerFlush() {
  now(); // Get the current time, if not already set.
  ++frame; // Pretend we’ve set an alarm, if we haven’t already.
  var t = taskHead,
    e;
  while (t) {
    if ((e = clockNow - t._time) >= 0) t._call.call(undefined, e);
    t = t._next;
  }
  --frame;
}

function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  frame = timeout$1 = 0;
  try {
    timerFlush();
  } finally {
    frame = 0;
    nap();
    clockNow = 0;
  }
}

function poke() {
  var now = clock.now(),
    delay = now - clockLast;
  if (delay > pokeDelay) ((clockSkew -= delay), (clockLast = now));
}

function nap() {
  var t0,
    t1 = taskHead,
    t2,
    time = Infinity;
  while (t1) {
    if (t1._call) {
      if (time > t1._time) time = t1._time;
      ((t0 = t1), (t1 = t1._next));
    } else {
      ((t2 = t1._next), (t1._next = null));
      t1 = t0 ? (t0._next = t2) : (taskHead = t2);
    }
  }
  taskTail = t0;
  sleep(time);
}

function sleep(time) {
  if (frame) return; // Soonest alarm already set, or will be.
  if (timeout$1) timeout$1 = clearTimeout(timeout$1);
  var delay = time - clockNow; // Strictly less than if we recomputed clockNow.
  if (delay > 24) {
    if (time < Infinity)
      timeout$1 = setTimeout(wake, time - clock.now() - clockSkew);
    if (interval) interval = clearInterval(interval);
  } else {
    if (!interval)
      ((clockLast = clock.now()), (interval = setInterval(poke, pokeDelay)));
    ((frame = 1), setFrame(wake));
  }
}

function timeout(callback, delay, time) {
  var t = new Timer();
  delay = delay == null ? 0 : +delay;
  t.restart(
    (elapsed) => {
      t.stop();
      callback(elapsed + delay);
    },
    delay,
    time,
  );
  return t;
}

var emptyOn = dispatch("start", "end", "cancel", "interrupt");
var emptyTween = [];

var CREATED = 0;
var SCHEDULED = 1;
var STARTING = 2;
var STARTED = 3;
var RUNNING = 4;
var ENDING = 5;
var ENDED = 6;

function schedule(node, name, id, index, group, timing) {
  var schedules = node.__transition;
  if (!schedules) node.__transition = {};
  else if (id in schedules) return;
  create(node, id, {
    name: name,
    index: index, // For context during callback.
    group: group, // For context during callback.
    on: emptyOn,
    tween: emptyTween,
    time: timing.time,
    delay: timing.delay,
    duration: timing.duration,
    ease: timing.ease,
    timer: null,
    state: CREATED,
  });
}

function init(node, id) {
  var schedule = get(node, id);
  if (schedule.state > CREATED) throw new Error("too late; already scheduled");
  return schedule;
}

function set(node, id) {
  var schedule = get(node, id);
  if (schedule.state > STARTED) throw new Error("too late; already running");
  return schedule;
}

function get(node, id) {
  var schedule = node.__transition;
  if (!schedule || !(schedule = schedule[id]))
    throw new Error("transition not found");
  return schedule;
}

function create(node, id, self) {
  var schedules = node.__transition,
    tween;

  // Initialize the self timer when the transition is created.
  // Note the actual delay is not known until the first callback!
  schedules[id] = self;
  self.timer = timer(schedule, 0, self.time);

  function schedule(elapsed) {
    self.state = SCHEDULED;
    self.timer.restart(start, self.delay, self.time);

    // If the elapsed delay is less than our first sleep, start immediately.
    if (self.delay <= elapsed) start(elapsed - self.delay);
  }

  function start(elapsed) {
    var i, j, n, o;

    // If the state is not SCHEDULED, then we previously errored on start.
    if (self.state !== SCHEDULED) return stop();

    for (i in schedules) {
      o = schedules[i];
      if (o.name !== self.name) continue;

      // While this element already has a starting transition during this frame,
      // defer starting an interrupting transition until that transition has a
      // chance to tick (and possibly end); see d3/d3-transition#54!
      if (o.state === STARTED) return timeout(start);

      // Interrupt the active transition, if any.
      if (o.state === RUNNING) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("interrupt", node, node.__data__, o.index, o.group);
        delete schedules[i];
      }

      // Cancel any pre-empted transitions.
      else if (+i < id) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("cancel", node, node.__data__, o.index, o.group);
        delete schedules[i];
      }
    }

    // Defer the first tick to end of the current frame; see d3/d3#1576.
    // Note the transition may be canceled after start and before the first tick!
    // Note this must be scheduled before the start event; see d3/d3-transition#16!
    // Assuming this is successful, subsequent callbacks go straight to tick.
    timeout(function () {
      if (self.state === STARTED) {
        self.state = RUNNING;
        self.timer.restart(tick, self.delay, self.time);
        tick(elapsed);
      }
    });

    // Dispatch the start event.
    // Note this must be done before the tween are initialized.
    self.state = STARTING;
    self.on.call("start", node, node.__data__, self.index, self.group);
    if (self.state !== STARTING) return; // interrupted
    self.state = STARTED;

    // Initialize the tween, deleting null tween.
    tween = new Array((n = self.tween.length));
    for (i = 0, j = -1; i < n; ++i) {
      if (
        (o = self.tween[i].value.call(
          node,
          node.__data__,
          self.index,
          self.group,
        ))
      ) {
        tween[++j] = o;
      }
    }
    tween.length = j + 1;
  }

  function tick(elapsed) {
    var t =
        elapsed < self.duration
          ? self.ease.call(null, elapsed / self.duration)
          : (self.timer.restart(stop), (self.state = ENDING), 1),
      i = -1,
      n = tween.length;

    while (++i < n) {
      tween[i].call(node, t);
    }

    // Dispatch the end event.
    if (self.state === ENDING) {
      self.on.call("end", node, node.__data__, self.index, self.group);
      stop();
    }
  }

  function stop() {
    self.state = ENDED;
    self.timer.stop();
    delete schedules[id];
    for (var i in schedules) return; // eslint-disable-line no-unused-vars
    delete node.__transition;
  }
}

function interrupt(node, name) {
  var schedules = node.__transition,
    schedule,
    active,
    empty = true,
    i;

  if (!schedules) return;

  name = name == null ? null : name + "";

  for (i in schedules) {
    if ((schedule = schedules[i]).name !== name) {
      empty = false;
      continue;
    }
    active = schedule.state > STARTING && schedule.state < ENDING;
    schedule.state = ENDED;
    schedule.timer.stop();
    schedule.on.call(
      active ? "interrupt" : "cancel",
      node,
      node.__data__,
      schedule.index,
      schedule.group,
    );
    delete schedules[i];
  }

  if (empty) delete node.__transition;
}

function selection_interrupt(name) {
  return this.each(function () {
    interrupt(this, name);
  });
}

function tweenRemove(id, name) {
  var tween0, tween1;
  return function () {
    var schedule = set(this, id),
      tween = schedule.tween;

    // If this node shared tween with the previous node,
    // just assign the updated shared tween and we’re done!
    // Otherwise, copy-on-write.
    if (tween !== tween0) {
      tween1 = tween0 = tween;
      for (var i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name) {
          tween1 = tween1.slice();
          tween1.splice(i, 1);
          break;
        }
      }
    }

    schedule.tween = tween1;
  };
}

function tweenFunction(id, name, value) {
  var tween0, tween1;
  if (typeof value !== "function") throw new Error();
  return function () {
    var schedule = set(this, id),
      tween = schedule.tween;

    // If this node shared tween with the previous node,
    // just assign the updated shared tween and we’re done!
    // Otherwise, copy-on-write.
    if (tween !== tween0) {
      tween1 = (tween0 = tween).slice();
      for (
        var t = { name: name, value: value }, i = 0, n = tween1.length;
        i < n;
        ++i
      ) {
        if (tween1[i].name === name) {
          tween1[i] = t;
          break;
        }
      }
      if (i === n) tween1.push(t);
    }

    schedule.tween = tween1;
  };
}

function transition_tween(name, value) {
  var id = this._id;

  name += "";

  if (arguments.length < 2) {
    var tween = get(this.node(), id).tween;
    for (var i = 0, n = tween.length, t; i < n; ++i) {
      if ((t = tween[i]).name === name) {
        return t.value;
      }
    }
    return null;
  }

  return this.each(
    (value == null ? tweenRemove : tweenFunction)(id, name, value),
  );
}

function tweenValue(transition, name, value) {
  var id = transition._id;

  transition.each(function () {
    var schedule = set(this, id);
    (schedule.value || (schedule.value = {}))[name] = value.apply(
      this,
      arguments,
    );
  });

  return function (node) {
    return get(node, id).value[name];
  };
}

function interpolate(a, b) {
  var c;
  return (
    typeof b === "number"
      ? interpolateNumber
      : b instanceof color
        ? interpolateRgb
        : (c = color(b))
          ? ((b = c), interpolateRgb)
          : interpolateString
  )(a, b);
}

function attrRemove(name) {
  return function () {
    this.removeAttribute(name);
  };
}

function attrRemoveNS(fullname) {
  return function () {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}

function attrConstant(name, interpolate, value1) {
  var string00,
    string1 = value1 + "",
    interpolate0;
  return function () {
    var string0 = this.getAttribute(name);
    return string0 === string1
      ? null
      : string0 === string00
        ? interpolate0
        : (interpolate0 = interpolate((string00 = string0), value1));
  };
}

function attrConstantNS(fullname, interpolate, value1) {
  var string00,
    string1 = value1 + "",
    interpolate0;
  return function () {
    var string0 = this.getAttributeNS(fullname.space, fullname.local);
    return string0 === string1
      ? null
      : string0 === string00
        ? interpolate0
        : (interpolate0 = interpolate((string00 = string0), value1));
  };
}

function attrFunction(name, interpolate, value) {
  var string00, string10, interpolate0;
  return function () {
    var string0,
      value1 = value(this),
      string1;
    if (value1 == null) return void this.removeAttribute(name);
    string0 = this.getAttribute(name);
    string1 = value1 + "";
    return string0 === string1
      ? null
      : string0 === string00 && string1 === string10
        ? interpolate0
        : ((string10 = string1),
          (interpolate0 = interpolate((string00 = string0), value1)));
  };
}

function attrFunctionNS(fullname, interpolate, value) {
  var string00, string10, interpolate0;
  return function () {
    var string0,
      value1 = value(this),
      string1;
    if (value1 == null)
      return void this.removeAttributeNS(fullname.space, fullname.local);
    string0 = this.getAttributeNS(fullname.space, fullname.local);
    string1 = value1 + "";
    return string0 === string1
      ? null
      : string0 === string00 && string1 === string10
        ? interpolate0
        : ((string10 = string1),
          (interpolate0 = interpolate((string00 = string0), value1)));
  };
}

function transition_attr(name, value) {
  var fullname = namespace(name),
    i = fullname === "transform" ? interpolateTransformSvg : interpolate;
  return this.attrTween(
    name,
    typeof value === "function"
      ? (fullname.local ? attrFunctionNS : attrFunction)(
          fullname,
          i,
          tweenValue(this, "attr." + name, value),
        )
      : value == null
        ? (fullname.local ? attrRemoveNS : attrRemove)(fullname)
        : (fullname.local ? attrConstantNS : attrConstant)(fullname, i, value),
  );
}

function attrInterpolate(name, i) {
  return function (t) {
    this.setAttribute(name, i.call(this, t));
  };
}

function attrInterpolateNS(fullname, i) {
  return function (t) {
    this.setAttributeNS(fullname.space, fullname.local, i.call(this, t));
  };
}

function attrTweenNS(fullname, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolateNS(fullname, i);
    return t0;
  }
  tween._value = value;
  return tween;
}

function attrTween(name, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && attrInterpolate(name, i);
    return t0;
  }
  tween._value = value;
  return tween;
}

function transition_attrTween(name, value) {
  var key = "attr." + name;
  if (arguments.length < 2) return (key = this.tween(key)) && key._value;
  if (value == null) return this.tween(key, null);
  if (typeof value !== "function") throw new Error();
  var fullname = namespace(name);
  return this.tween(
    key,
    (fullname.local ? attrTweenNS : attrTween)(fullname, value),
  );
}

function delayFunction(id, value) {
  return function () {
    init(this, id).delay = +value.apply(this, arguments);
  };
}

function delayConstant(id, value) {
  return (
    (value = +value),
    function () {
      init(this, id).delay = value;
    }
  );
}

function transition_delay(value) {
  var id = this._id;

  return arguments.length
    ? this.each(
        (typeof value === "function" ? delayFunction : delayConstant)(
          id,
          value,
        ),
      )
    : get(this.node(), id).delay;
}

function durationFunction(id, value) {
  return function () {
    set(this, id).duration = +value.apply(this, arguments);
  };
}

function durationConstant(id, value) {
  return (
    (value = +value),
    function () {
      set(this, id).duration = value;
    }
  );
}

function transition_duration(value) {
  var id = this._id;

  return arguments.length
    ? this.each(
        (typeof value === "function" ? durationFunction : durationConstant)(
          id,
          value,
        ),
      )
    : get(this.node(), id).duration;
}

function easeConstant(id, value) {
  if (typeof value !== "function") throw new Error();
  return function () {
    set(this, id).ease = value;
  };
}

function transition_ease(value) {
  var id = this._id;

  return arguments.length
    ? this.each(easeConstant(id, value))
    : get(this.node(), id).ease;
}

function easeVarying(id, value) {
  return function () {
    var v = value.apply(this, arguments);
    if (typeof v !== "function") throw new Error();
    set(this, id).ease = v;
  };
}

function transition_easeVarying(value) {
  if (typeof value !== "function") throw new Error();
  return this.each(easeVarying(this._id, value));
}

function transition_filter(match) {
  if (typeof match !== "function") match = matcher(match);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group = groups[j],
        n = group.length,
        subgroup = (subgroups[j] = []),
        node,
        i = 0;
      i < n;
      ++i
    ) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }

  return new Transition(subgroups, this._parents, this._name, this._id);
}

function transition_merge(transition) {
  if (transition._id !== this._id) throw new Error();

  for (
    var groups0 = this._groups,
      groups1 = transition._groups,
      m0 = groups0.length,
      m1 = groups1.length,
      m = Math.min(m0, m1),
      merges = new Array(m0),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group0 = groups0[j],
        group1 = groups1[j],
        n = group0.length,
        merge = (merges[j] = new Array(n)),
        node,
        i = 0;
      i < n;
      ++i
    ) {
      if ((node = group0[i] || group1[i])) {
        merge[i] = node;
      }
    }
  }

  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }

  return new Transition(merges, this._parents, this._name, this._id);
}

function start(name) {
  return (name + "")
    .trim()
    .split(/^|\s+/)
    .every(function (t) {
      var i = t.indexOf(".");
      if (i >= 0) t = t.slice(0, i);
      return !t || t === "start";
    });
}

function onFunction(id, name, listener) {
  var on0,
    on1,
    sit = start(name) ? init : set;
  return function () {
    var schedule = sit(this, id),
      on = schedule.on;

    // If this node shared a dispatch with the previous node,
    // just assign the updated shared dispatch and we’re done!
    // Otherwise, copy-on-write.
    if (on !== on0) (on1 = (on0 = on).copy()).on(name, listener);

    schedule.on = on1;
  };
}

function transition_on(name, listener) {
  var id = this._id;

  return arguments.length < 2
    ? get(this.node(), id).on.on(name)
    : this.each(onFunction(id, name, listener));
}

function removeFunction(id) {
  return function () {
    var parent = this.parentNode;
    for (var i in this.__transition) if (+i !== id) return;
    if (parent) parent.removeChild(this);
  };
}

function transition_remove() {
  return this.on("end.remove", removeFunction(this._id));
}

function transition_select(select) {
  var name = this._name,
    id = this._id;

  if (typeof select !== "function") select = selector(select);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = new Array(m),
      j = 0;
    j < m;
    ++j
  ) {
    for (
      var group = groups[j],
        n = group.length,
        subgroup = (subgroups[j] = new Array(n)),
        node,
        subnode,
        i = 0;
      i < n;
      ++i
    ) {
      if (
        (node = group[i]) &&
        (subnode = select.call(node, node.__data__, i, group))
      ) {
        if ("__data__" in node) subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
        schedule(subgroup[i], name, id, i, subgroup, get(node, id));
      }
    }
  }

  return new Transition(subgroups, this._parents, name, id);
}

function transition_selectAll(select) {
  var name = this._name,
    id = this._id;

  if (typeof select !== "function") select = selectorAll(select);

  for (
    var groups = this._groups,
      m = groups.length,
      subgroups = [],
      parents = [],
      j = 0;
    j < m;
    ++j
  ) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if ((node = group[i])) {
        for (
          var children = select.call(node, node.__data__, i, group),
            child,
            inherit = get(node, id),
            k = 0,
            l = children.length;
          k < l;
          ++k
        ) {
          if ((child = children[k])) {
            schedule(child, name, id, k, children, inherit);
          }
        }
        subgroups.push(children);
        parents.push(node);
      }
    }
  }

  return new Transition(subgroups, parents, name, id);
}

var Selection = selection.prototype.constructor;

function transition_selection() {
  return new Selection(this._groups, this._parents);
}

function styleNull(name, interpolate) {
  var string00, string10, interpolate0;
  return function () {
    var string0 = styleValue(this, name),
      string1 = (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1
      ? null
      : string0 === string00 && string1 === string10
        ? interpolate0
        : (interpolate0 = interpolate(
            (string00 = string0),
            (string10 = string1),
          ));
  };
}

function styleRemove(name) {
  return function () {
    this.style.removeProperty(name);
  };
}

function styleConstant(name, interpolate, value1) {
  var string00,
    string1 = value1 + "",
    interpolate0;
  return function () {
    var string0 = styleValue(this, name);
    return string0 === string1
      ? null
      : string0 === string00
        ? interpolate0
        : (interpolate0 = interpolate((string00 = string0), value1));
  };
}

function styleFunction(name, interpolate, value) {
  var string00, string10, interpolate0;
  return function () {
    var string0 = styleValue(this, name),
      value1 = value(this),
      string1 = value1 + "";
    if (value1 == null)
      string1 = value1 =
        (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1
      ? null
      : string0 === string00 && string1 === string10
        ? interpolate0
        : ((string10 = string1),
          (interpolate0 = interpolate((string00 = string0), value1)));
  };
}

function styleMaybeRemove(id, name) {
  var on0,
    on1,
    listener0,
    key = "style." + name,
    event = "end." + key,
    remove;
  return function () {
    var schedule = set(this, id),
      on = schedule.on,
      listener =
        schedule.value[key] == null
          ? remove || (remove = styleRemove(name))
          : undefined;

    // If this node shared a dispatch with the previous node,
    // just assign the updated shared dispatch and we’re done!
    // Otherwise, copy-on-write.
    if (on !== on0 || listener0 !== listener)
      (on1 = (on0 = on).copy()).on(event, (listener0 = listener));

    schedule.on = on1;
  };
}

function transition_style(name, value, priority) {
  var i = (name += "") === "transform" ? interpolateTransformCss : interpolate;
  return value == null
    ? this.styleTween(name, styleNull(name, i)).on(
        "end.style." + name,
        styleRemove(name),
      )
    : typeof value === "function"
      ? this.styleTween(
          name,
          styleFunction(name, i, tweenValue(this, "style." + name, value)),
        ).each(styleMaybeRemove(this._id, name))
      : this.styleTween(name, styleConstant(name, i, value), priority).on(
          "end.style." + name,
          null,
        );
}

function styleInterpolate(name, i, priority) {
  return function (t) {
    this.style.setProperty(name, i.call(this, t), priority);
  };
}

function styleTween(name, value, priority) {
  var t, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t = (i0 = i) && styleInterpolate(name, i, priority);
    return t;
  }
  tween._value = value;
  return tween;
}

function transition_styleTween(name, value, priority) {
  var key = "style." + (name += "");
  if (arguments.length < 2) return (key = this.tween(key)) && key._value;
  if (value == null) return this.tween(key, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(
    key,
    styleTween(name, value, priority == null ? "" : priority),
  );
}

function textConstant(value) {
  return function () {
    this.textContent = value;
  };
}

function textFunction(value) {
  return function () {
    var value1 = value(this);
    this.textContent = value1 == null ? "" : value1;
  };
}

function transition_text(value) {
  return this.tween(
    "text",
    typeof value === "function"
      ? textFunction(tweenValue(this, "text", value))
      : textConstant(value == null ? "" : value + ""),
  );
}

function textInterpolate(i) {
  return function (t) {
    this.textContent = i.call(this, t);
  };
}

function textTween(value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0) t0 = (i0 = i) && textInterpolate(i);
    return t0;
  }
  tween._value = value;
  return tween;
}

function transition_textTween(value) {
  var key = "text";
  if (arguments.length < 1) return (key = this.tween(key)) && key._value;
  if (value == null) return this.tween(key, null);
  if (typeof value !== "function") throw new Error();
  return this.tween(key, textTween(value));
}

function transition_transition() {
  var name = this._name,
    id0 = this._id,
    id1 = newId();

  for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if ((node = group[i])) {
        var inherit = get(node, id0);
        schedule(node, name, id1, i, group, {
          time: inherit.time + inherit.delay + inherit.duration,
          delay: 0,
          duration: inherit.duration,
          ease: inherit.ease,
        });
      }
    }
  }

  return new Transition(groups, this._parents, name, id1);
}

function transition_end() {
  var on0,
    on1,
    that = this,
    id = that._id,
    size = that.size();
  return new Promise(function (resolve, reject) {
    var cancel = { value: reject },
      end = {
        value: function () {
          if (--size === 0) resolve();
        },
      };

    that.each(function () {
      var schedule = set(this, id),
        on = schedule.on;

      // If this node shared a dispatch with the previous node,
      // just assign the updated shared dispatch and we’re done!
      // Otherwise, copy-on-write.
      if (on !== on0) {
        on1 = (on0 = on).copy();
        on1._.cancel.push(cancel);
        on1._.interrupt.push(cancel);
        on1._.end.push(end);
      }

      schedule.on = on1;
    });

    // The selection was empty, resolve end immediately
    if (size === 0) resolve();
  });
}

var id = 0;

function Transition(groups, parents, name, id) {
  this._groups = groups;
  this._parents = parents;
  this._name = name;
  this._id = id;
}

function newId() {
  return ++id;
}

var selection_prototype = selection.prototype;

Transition.prototype = {
  constructor: Transition,
  select: transition_select,
  selectAll: transition_selectAll,
  selectChild: selection_prototype.selectChild,
  selectChildren: selection_prototype.selectChildren,
  filter: transition_filter,
  merge: transition_merge,
  selection: transition_selection,
  transition: transition_transition,
  call: selection_prototype.call,
  nodes: selection_prototype.nodes,
  node: selection_prototype.node,
  size: selection_prototype.size,
  empty: selection_prototype.empty,
  each: selection_prototype.each,
  on: transition_on,
  attr: transition_attr,
  attrTween: transition_attrTween,
  style: transition_style,
  styleTween: transition_styleTween,
  text: transition_text,
  textTween: transition_textTween,
  remove: transition_remove,
  tween: transition_tween,
  delay: transition_delay,
  duration: transition_duration,
  ease: transition_ease,
  easeVarying: transition_easeVarying,
  end: transition_end,
  [Symbol.iterator]: selection_prototype[Symbol.iterator],
};

function cubicInOut(t) {
  return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
}

var defaultTiming = {
  time: null, // Set on use.
  delay: 0,
  duration: 250,
  ease: cubicInOut,
};

function inherit(node, id) {
  var timing;
  while (!(timing = node.__transition) || !(timing = timing[id])) {
    if (!(node = node.parentNode)) {
      throw new Error(`transition ${id} not found`);
    }
  }
  return timing;
}

function selection_transition(name) {
  var id, timing;

  if (name instanceof Transition) {
    ((id = name._id), (name = name._name));
  } else {
    ((id = newId()),
      ((timing = defaultTiming).time = now()),
      (name = name == null ? null : name + ""));
  }

  for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if ((node = group[i])) {
        schedule(node, name, id, i, group, timing || inherit(node, id));
      }
    }
  }

  return new Transition(groups, this._parents, name, id);
}

selection.prototype.interrupt = selection_interrupt;
selection.prototype.transition = selection_transition;

const pi$2 = Math.PI,
  tau$2 = 2 * pi$2,
  epsilon$3 = 1e-6,
  tauEpsilon = tau$2 - epsilon$3;

function append$1(strings) {
  this._ += strings[0];
  for (let i = 1, n = strings.length; i < n; ++i) {
    this._ += arguments[i] + strings[i];
  }
}

function appendRound$1(digits) {
  let d = Math.floor(digits);
  if (!(d >= 0)) throw new Error(`invalid digits: ${digits}`);
  if (d > 15) return append$1;
  const k = 10 ** d;
  return function (strings) {
    this._ += strings[0];
    for (let i = 1, n = strings.length; i < n; ++i) {
      this._ += Math.round(arguments[i] * k) / k + strings[i];
    }
  };
}

class Path {
  constructor(digits) {
    this._x0 =
      this._y0 = // start of current subpath
      this._x1 =
      this._y1 =
        null; // end of current subpath
    this._ = "";
    this._append = digits == null ? append$1 : appendRound$1(digits);
  }
  moveTo(x, y) {
    this._append`M${(this._x0 = this._x1 = +x)},${(this._y0 = this._y1 = +y)}`;
  }
  closePath() {
    if (this._x1 !== null) {
      ((this._x1 = this._x0), (this._y1 = this._y0));
      this._append`Z`;
    }
  }
  lineTo(x, y) {
    this._append`L${(this._x1 = +x)},${(this._y1 = +y)}`;
  }
  quadraticCurveTo(x1, y1, x, y) {
    this._append`Q${+x1},${+y1},${(this._x1 = +x)},${(this._y1 = +y)}`;
  }
  bezierCurveTo(x1, y1, x2, y2, x, y) {
    this
      ._append`C${+x1},${+y1},${+x2},${+y2},${(this._x1 = +x)},${(this._y1 = +y)}`;
  }
  arcTo(x1, y1, x2, y2, r) {
    ((x1 = +x1), (y1 = +y1), (x2 = +x2), (y2 = +y2), (r = +r));

    // Is the radius negative? Error.
    if (r < 0) throw new Error(`negative radius: ${r}`);

    let x0 = this._x1,
      y0 = this._y1,
      x21 = x2 - x1,
      y21 = y2 - y1,
      x01 = x0 - x1,
      y01 = y0 - y1,
      l01_2 = x01 * x01 + y01 * y01;

    // Is this path empty? Move to (x1,y1).
    if (this._x1 === null) {
      this._append`M${(this._x1 = x1)},${(this._y1 = y1)}`;
    }

    // Or, is (x1,y1) coincident with (x0,y0)? Do nothing.
    else if (!(l01_2 > epsilon$3));
    else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$3) || !r) {
      // Or, are (x0,y0), (x1,y1) and (x2,y2) collinear?
      // Equivalently, is (x1,y1) coincident with (x2,y2)?
      // Or, is the radius zero? Line to (x1,y1).
      this._append`L${(this._x1 = x1)},${(this._y1 = y1)}`;
    }

    // Otherwise, draw an arc!
    else {
      let x20 = x2 - x0,
        y20 = y2 - y0,
        l21_2 = x21 * x21 + y21 * y21,
        l20_2 = x20 * x20 + y20 * y20,
        l21 = Math.sqrt(l21_2),
        l01 = Math.sqrt(l01_2),
        l =
          r *
          Math.tan(
            (pi$2 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2,
          ),
        t01 = l / l01,
        t21 = l / l21;

      // If the start tangent is not coincident with (x0,y0), line to.
      if (Math.abs(t01 - 1) > epsilon$3) {
        this._append`L${x1 + t01 * x01},${y1 + t01 * y01}`;
      }

      this
        ._append`A${r},${r},0,0,${+(y01 * x20 > x01 * y20)},${(this._x1 = x1 + t21 * x21)},${(this._y1 = y1 + t21 * y21)}`;
    }
  }
  arc(x, y, r, a0, a1, ccw) {
    ((x = +x), (y = +y), (r = +r), (ccw = !!ccw));

    // Is the radius negative? Error.
    if (r < 0) throw new Error(`negative radius: ${r}`);

    let dx = r * Math.cos(a0),
      dy = r * Math.sin(a0),
      x0 = x + dx,
      y0 = y + dy,
      cw = 1 ^ ccw,
      da = ccw ? a0 - a1 : a1 - a0;

    // Is this path empty? Move to (x0,y0).
    if (this._x1 === null) {
      this._append`M${x0},${y0}`;
    }

    // Or, is (x0,y0) not coincident with the previous point? Line to (x0,y0).
    else if (
      Math.abs(this._x1 - x0) > epsilon$3 ||
      Math.abs(this._y1 - y0) > epsilon$3
    ) {
      this._append`L${x0},${y0}`;
    }

    // Is this arc empty? We’re done.
    if (!r) return;

    // Does the angle go the wrong way? Flip the direction.
    if (da < 0) da = (da % tau$2) + tau$2;

    // Is this a complete circle? Draw two arcs to complete the circle.
    if (da > tauEpsilon) {
      this
        ._append`A${r},${r},0,1,${cw},${x - dx},${y - dy}A${r},${r},0,1,${cw},${(this._x1 = x0)},${(this._y1 = y0)}`;
    }

    // Is this arc non-empty? Draw an arc!
    else if (da > epsilon$3) {
      this
        ._append`A${r},${r},0,${+(da >= pi$2)},${cw},${(this._x1 = x + r * Math.cos(a1))},${(this._y1 = y + r * Math.sin(a1))}`;
    }
  }
  rect(x, y, w, h) {
    this
      ._append`M${(this._x0 = this._x1 = +x)},${(this._y0 = this._y1 = +y)}h${(w = +w)}v${+h}h${-w}Z`;
  }
  toString() {
    return this._;
  }
}

function path() {
  return new Path();
}

// Allow instanceof d3.path
path.prototype = Path.prototype;

var epsilon$2 = 1e-6;
var epsilon2 = 1e-12;
var pi$1 = Math.PI;
var halfPi$1 = pi$1 / 2;
var quarterPi$1 = pi$1 / 4;
var tau$1 = pi$1 * 2;

var degrees$1 = 180 / pi$1;
var radians$1 = pi$1 / 180;

var abs$1 = Math.abs;
var atan$1 = Math.atan;
var atan2$1 = Math.atan2;
var cos$1 = Math.cos;
var exp = Math.exp;
var log = Math.log;
var pow = Math.pow;
var sin$1 = Math.sin;
var sign$1 =
  Math.sign ||
  function (x) {
    return x > 0 ? 1 : x < 0 ? -1 : 0;
  };
var sqrt$1 = Math.sqrt;
var tan = Math.tan;

function acos$1(x) {
  return x > 1 ? 0 : x < -1 ? pi$1 : Math.acos(x);
}

function asin$1(x) {
  return x > 1 ? halfPi$1 : x < -1 ? -halfPi$1 : Math.asin(x);
}

function noop$2() {}

function streamGeometry$1(geometry, stream) {
  if (geometry && streamGeometryType$1.hasOwnProperty(geometry.type)) {
    streamGeometryType$1[geometry.type](geometry, stream);
  }
}

var streamObjectType$1 = {
  Feature: function (object, stream) {
    streamGeometry$1(object.geometry, stream);
  },
  FeatureCollection: function (object, stream) {
    var features = object.features,
      i = -1,
      n = features.length;
    while (++i < n) streamGeometry$1(features[i].geometry, stream);
  },
};

var streamGeometryType$1 = {
  Sphere: function (object, stream) {
    stream.sphere();
  },
  Point: function (object, stream) {
    object = object.coordinates;
    stream.point(object[0], object[1], object[2]);
  },
  MultiPoint: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n)
      ((object = coordinates[i]),
        stream.point(object[0], object[1], object[2]));
  },
  LineString: function (object, stream) {
    streamLine$1(object.coordinates, stream, 0);
  },
  MultiLineString: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamLine$1(coordinates[i], stream, 0);
  },
  Polygon: function (object, stream) {
    streamPolygon$1(object.coordinates, stream);
  },
  MultiPolygon: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamPolygon$1(coordinates[i], stream);
  },
  GeometryCollection: function (object, stream) {
    var geometries = object.geometries,
      i = -1,
      n = geometries.length;
    while (++i < n) streamGeometry$1(geometries[i], stream);
  },
};

function streamLine$1(coordinates, stream, closed) {
  var i = -1,
    n = coordinates.length - closed,
    coordinate;
  stream.lineStart();
  while (++i < n)
    ((coordinate = coordinates[i]),
      stream.point(coordinate[0], coordinate[1], coordinate[2]));
  stream.lineEnd();
}

function streamPolygon$1(coordinates, stream) {
  var i = -1,
    n = coordinates.length;
  stream.polygonStart();
  while (++i < n) streamLine$1(coordinates[i], stream, 1);
  stream.polygonEnd();
}

function geoStream$1(object, stream) {
  if (object && streamObjectType$1.hasOwnProperty(object.type)) {
    streamObjectType$1[object.type](object, stream);
  } else {
    streamGeometry$1(object, stream);
  }
}

function spherical$1(cartesian) {
  return [atan2$1(cartesian[1], cartesian[0]), asin$1(cartesian[2])];
}

function cartesian$1(spherical) {
  var lambda = spherical[0],
    phi = spherical[1],
    cosPhi = cos$1(phi);
  return [cosPhi * cos$1(lambda), cosPhi * sin$1(lambda), sin$1(phi)];
}

function cartesianDot$1(a, b) {
  return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
}

function cartesianCross$1(a, b) {
  return [
    a[1] * b[2] - a[2] * b[1],
    a[2] * b[0] - a[0] * b[2],
    a[0] * b[1] - a[1] * b[0],
  ];
}

// TODO return a
function cartesianAddInPlace$1(a, b) {
  ((a[0] += b[0]), (a[1] += b[1]), (a[2] += b[2]));
}

function cartesianScale$1(vector, k) {
  return [vector[0] * k, vector[1] * k, vector[2] * k];
}

// TODO return d
function cartesianNormalizeInPlace$1(d) {
  var l = sqrt$1(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  ((d[0] /= l), (d[1] /= l), (d[2] /= l));
}

function compose$1(a, b) {
  function compose(x, y) {
    return ((x = a(x, y)), b(x[0], x[1]));
  }

  if (a.invert && b.invert)
    compose.invert = function (x, y) {
      return ((x = b.invert(x, y)), x && a.invert(x[0], x[1]));
    };

  return compose;
}

function rotationIdentity$1(lambda, phi) {
  if (abs$1(lambda) > pi$1) lambda -= Math.round(lambda / tau$1) * tau$1;
  return [lambda, phi];
}

rotationIdentity$1.invert = rotationIdentity$1;

function rotateRadians$1(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= tau$1)
    ? deltaPhi || deltaGamma
      ? compose$1(
          rotationLambda$1(deltaLambda),
          rotationPhiGamma$1(deltaPhi, deltaGamma),
        )
      : rotationLambda$1(deltaLambda)
    : deltaPhi || deltaGamma
      ? rotationPhiGamma$1(deltaPhi, deltaGamma)
      : rotationIdentity$1;
}

function forwardRotationLambda$1(deltaLambda) {
  return function (lambda, phi) {
    lambda += deltaLambda;
    if (abs$1(lambda) > pi$1) lambda -= Math.round(lambda / tau$1) * tau$1;
    return [lambda, phi];
  };
}

function rotationLambda$1(deltaLambda) {
  var rotation = forwardRotationLambda$1(deltaLambda);
  rotation.invert = forwardRotationLambda$1(-deltaLambda);
  return rotation;
}

function rotationPhiGamma$1(deltaPhi, deltaGamma) {
  var cosDeltaPhi = cos$1(deltaPhi),
    sinDeltaPhi = sin$1(deltaPhi),
    cosDeltaGamma = cos$1(deltaGamma),
    sinDeltaGamma = sin$1(deltaGamma);

  function rotation(lambda, phi) {
    var cosPhi = cos$1(phi),
      x = cos$1(lambda) * cosPhi,
      y = sin$1(lambda) * cosPhi,
      z = sin$1(phi),
      k = z * cosDeltaPhi + x * sinDeltaPhi;
    return [
      atan2$1(
        y * cosDeltaGamma - k * sinDeltaGamma,
        x * cosDeltaPhi - z * sinDeltaPhi,
      ),
      asin$1(k * cosDeltaGamma + y * sinDeltaGamma),
    ];
  }

  rotation.invert = function (lambda, phi) {
    var cosPhi = cos$1(phi),
      x = cos$1(lambda) * cosPhi,
      y = sin$1(lambda) * cosPhi,
      z = sin$1(phi),
      k = z * cosDeltaGamma - y * sinDeltaGamma;
    return [
      atan2$1(
        y * cosDeltaGamma + z * sinDeltaGamma,
        x * cosDeltaPhi + k * sinDeltaPhi,
      ),
      asin$1(k * cosDeltaPhi - x * sinDeltaPhi),
    ];
  };

  return rotation;
}

function rotation(rotate) {
  rotate = rotateRadians$1(
    rotate[0] * radians$1,
    rotate[1] * radians$1,
    rotate.length > 2 ? rotate[2] * radians$1 : 0,
  );

  function forward(coordinates) {
    coordinates = rotate(
      coordinates[0] * radians$1,
      coordinates[1] * radians$1,
    );
    return (
      (coordinates[0] *= degrees$1),
      (coordinates[1] *= degrees$1),
      coordinates
    );
  }

  forward.invert = function (coordinates) {
    coordinates = rotate.invert(
      coordinates[0] * radians$1,
      coordinates[1] * radians$1,
    );
    return (
      (coordinates[0] *= degrees$1),
      (coordinates[1] *= degrees$1),
      coordinates
    );
  };

  return forward;
}

// Generates a circle centered at [0°, 0°], with a given radius and precision.
function circleStream$1(stream, radius, delta, direction, t0, t1) {
  if (!delta) return;
  var cosRadius = cos$1(radius),
    sinRadius = sin$1(radius),
    step = direction * delta;
  if (t0 == null) {
    t0 = radius + direction * tau$1;
    t1 = radius - step / 2;
  } else {
    t0 = circleRadius$1(cosRadius, t0);
    t1 = circleRadius$1(cosRadius, t1);
    if (direction > 0 ? t0 < t1 : t0 > t1) t0 += direction * tau$1;
  }
  for (var point, t = t0; direction > 0 ? t > t1 : t < t1; t -= step) {
    point = spherical$1([
      cosRadius,
      -sinRadius * cos$1(t),
      -sinRadius * sin$1(t),
    ]);
    stream.point(point[0], point[1]);
  }
}

// Returns the signed angle of a cartesian point relative to [cosRadius, 0, 0].
function circleRadius$1(cosRadius, point) {
  ((point = cartesian$1(point)), (point[0] -= cosRadius));
  cartesianNormalizeInPlace$1(point);
  var radius = acos$1(-point[1]);
  return ((-point[2] < 0 ? -radius : radius) + tau$1 - epsilon$2) % tau$1;
}

function clipBuffer$1() {
  var lines = [],
    line;
  return {
    point: function (x, y, m) {
      line.push([x, y, m]);
    },
    lineStart: function () {
      lines.push((line = []));
    },
    lineEnd: noop$2,
    rejoin: function () {
      if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));
    },
    result: function () {
      var result = lines;
      lines = [];
      line = null;
      return result;
    },
  };
}

function pointEqual$1(a, b) {
  return abs$1(a[0] - b[0]) < epsilon$2 && abs$1(a[1] - b[1]) < epsilon$2;
}

function Intersection$1(point, points, other, entry) {
  this.x = point;
  this.z = points;
  this.o = other; // another intersection
  this.e = entry; // is an entry?
  this.v = false; // visited
  this.n = this.p = null; // next & previous
}

// A generalized polygon clipping algorithm: given a polygon that has been cut
// into its visible line segments, and rejoins the segments by interpolating
// along the clip edge.
function clipRejoin$1(
  segments,
  compareIntersection,
  startInside,
  interpolate,
  stream,
) {
  var subject = [],
    clip = [],
    i,
    n;

  segments.forEach(function (segment) {
    if ((n = segment.length - 1) <= 0) return;
    var n,
      p0 = segment[0],
      p1 = segment[n],
      x;

    if (pointEqual$1(p0, p1)) {
      if (!p0[2] && !p1[2]) {
        stream.lineStart();
        for (i = 0; i < n; ++i) stream.point((p0 = segment[i])[0], p0[1]);
        stream.lineEnd();
        return;
      }
      // handle degenerate cases by moving the point
      p1[0] += 2 * epsilon$2;
    }

    subject.push((x = new Intersection$1(p0, segment, null, true)));
    clip.push((x.o = new Intersection$1(p0, null, x, false)));
    subject.push((x = new Intersection$1(p1, segment, null, false)));
    clip.push((x.o = new Intersection$1(p1, null, x, true)));
  });

  if (!subject.length) return;

  clip.sort(compareIntersection);
  link$1(subject);
  link$1(clip);

  for (i = 0, n = clip.length; i < n; ++i) {
    clip[i].e = startInside = !startInside;
  }

  var start = subject[0],
    points,
    point;

  while (1) {
    // Find first unvisited intersection.
    var current = start,
      isSubject = true;
    while (current.v) if ((current = current.n) === start) return;
    points = current.z;
    stream.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points.length; i < n; ++i)
            stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.n.x, 1, stream);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points = current.p.z;
          for (i = points.length - 1; i >= 0; --i)
            stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.p.x, -1, stream);
        }
        current = current.p;
      }
      current = current.o;
      points = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream.lineEnd();
  }
}

function link$1(array) {
  if (!(n = array.length)) return;
  var n,
    i = 0,
    a = array[0],
    b;
  while (++i < n) {
    a.n = b = array[i];
    b.p = a;
    a = b;
  }
  a.n = b = array[0];
  b.p = a;
}

function longitude$1(point) {
  return abs$1(point[0]) <= pi$1
    ? point[0]
    : sign$1(point[0]) * (((abs$1(point[0]) + pi$1) % tau$1) - pi$1);
}

function polygonContains$1(polygon, point) {
  var lambda = longitude$1(point),
    phi = point[1],
    sinPhi = sin$1(phi),
    normal = [sin$1(lambda), -cos$1(lambda), 0],
    angle = 0,
    winding = 0;

  var sum = new Adder();

  if (sinPhi === 1) phi = halfPi$1 + epsilon$2;
  else if (sinPhi === -1) phi = -halfPi$1 - epsilon$2;

  for (var i = 0, n = polygon.length; i < n; ++i) {
    if (!(m = (ring = polygon[i]).length)) continue;
    var ring,
      m,
      point0 = ring[m - 1],
      lambda0 = longitude$1(point0),
      phi0 = point0[1] / 2 + quarterPi$1,
      sinPhi0 = sin$1(phi0),
      cosPhi0 = cos$1(phi0);

    for (
      var j = 0;
      j < m;
      ++j,
        lambda0 = lambda1,
        sinPhi0 = sinPhi1,
        cosPhi0 = cosPhi1,
        point0 = point1
    ) {
      var point1 = ring[j],
        lambda1 = longitude$1(point1),
        phi1 = point1[1] / 2 + quarterPi$1,
        sinPhi1 = sin$1(phi1),
        cosPhi1 = cos$1(phi1),
        delta = lambda1 - lambda0,
        sign = delta >= 0 ? 1 : -1,
        absDelta = sign * delta,
        antimeridian = absDelta > pi$1,
        k = sinPhi0 * sinPhi1;

      sum.add(
        atan2$1(
          k * sign * sin$1(absDelta),
          cosPhi0 * cosPhi1 + k * cos$1(absDelta),
        ),
      );
      angle += antimeridian ? delta + sign * tau$1 : delta;

      // Are the longitudes either side of the point’s meridian (lambda),
      // and are the latitudes smaller than the parallel (phi)?
      if (antimeridian ^ (lambda0 >= lambda) ^ (lambda1 >= lambda)) {
        var arc = cartesianCross$1(cartesian$1(point0), cartesian$1(point1));
        cartesianNormalizeInPlace$1(arc);
        var intersection = cartesianCross$1(normal, arc);
        cartesianNormalizeInPlace$1(intersection);
        var phiArc =
          (antimeridian ^ (delta >= 0) ? -1 : 1) * asin$1(intersection[2]);
        if (phi > phiArc || (phi === phiArc && (arc[0] || arc[1]))) {
          winding += antimeridian ^ (delta >= 0) ? 1 : -1;
        }
      }
    }
  }

  // First, determine whether the South pole is inside or outside:
  //
  // It is inside if:
  // * the polygon winds around it in a clockwise direction.
  // * the polygon does not (cumulatively) wind around it, but has a negative
  //   (counter-clockwise) area.
  //
  // Second, count the (signed) number of times a segment crosses a lambda
  // from the point to the South pole.  If it is zero, then the point is the
  // same side as the South pole.

  return (
    (angle < -epsilon$2 || (angle < epsilon$2 && sum < -epsilon2)) ^
    (winding & 1)
  );
}

function clip$1(pointVisible, clipLine, interpolate, start) {
  return function (sink) {
    var line = clipLine(sink),
      ringBuffer = clipBuffer$1(),
      ringSink = clipLine(ringBuffer),
      polygonStarted = false,
      polygon,
      segments,
      ring;

    var clip = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        clip.point = pointRing;
        clip.lineStart = ringStart;
        clip.lineEnd = ringEnd;
        segments = [];
        polygon = [];
      },
      polygonEnd: function () {
        clip.point = point;
        clip.lineStart = lineStart;
        clip.lineEnd = lineEnd;
        segments = merge$1(segments);
        var startInside = polygonContains$1(polygon, start);
        if (segments.length) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          clipRejoin$1(
            segments,
            compareIntersection$1,
            startInside,
            interpolate,
            sink,
          );
        } else if (startInside) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          sink.lineStart();
          interpolate(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted) (sink.polygonEnd(), (polygonStarted = false));
        segments = polygon = null;
      },
      sphere: function () {
        sink.polygonStart();
        sink.lineStart();
        interpolate(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      },
    };

    function point(lambda, phi) {
      if (pointVisible(lambda, phi)) sink.point(lambda, phi);
    }

    function pointLine(lambda, phi) {
      line.point(lambda, phi);
    }

    function lineStart() {
      clip.point = pointLine;
      line.lineStart();
    }

    function lineEnd() {
      clip.point = point;
      line.lineEnd();
    }

    function pointRing(lambda, phi) {
      ring.push([lambda, phi]);
      ringSink.point(lambda, phi);
    }

    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }

    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();

      var clean = ringSink.clean(),
        ringSegments = ringBuffer.result(),
        i,
        n = ringSegments.length,
        m,
        segment,
        point;

      ring.pop();
      polygon.push(ring);
      ring = null;

      if (!n) return;

      // No intersections.
      if (clean & 1) {
        segment = ringSegments[0];
        if ((m = segment.length - 1) > 0) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          sink.lineStart();
          for (i = 0; i < m; ++i) sink.point((point = segment[i])[0], point[1]);
          sink.lineEnd();
        }
        return;
      }

      // Rejoin connected segments.
      // TODO reuse ringBuffer.rejoin()?
      if (n > 1 && clean & 2)
        ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));

      segments.push(ringSegments.filter(validSegment$1));
    }

    return clip;
  };
}

function validSegment$1(segment) {
  return segment.length > 1;
}

// Intersections are sorted along the clip edge. For both antimeridian cutting
// and circle clipping, the same comparison is used.
function compareIntersection$1(a, b) {
  return (
    ((a = a.x)[0] < 0 ? a[1] - halfPi$1 - epsilon$2 : halfPi$1 - a[1]) -
    ((b = b.x)[0] < 0 ? b[1] - halfPi$1 - epsilon$2 : halfPi$1 - b[1])
  );
}

const clipAntimeridian$1 = clip$1(
  function () {
    return true;
  },
  clipAntimeridianLine$1,
  clipAntimeridianInterpolate$1,
  [-pi$1, -halfPi$1],
);

// Takes a line and cuts into visible segments. Return values: 0 - there were
// intersections or the line was empty; 1 - no intersections; 2 - there were
// intersections, and the first and last segments should be rejoined.
function clipAntimeridianLine$1(stream) {
  var lambda0 = NaN,
    phi0 = NaN,
    sign0 = NaN,
    clean; // no intersections

  return {
    lineStart: function () {
      stream.lineStart();
      clean = 1;
    },
    point: function (lambda1, phi1) {
      var sign1 = lambda1 > 0 ? pi$1 : -pi$1,
        delta = abs$1(lambda1 - lambda0);
      if (abs$1(delta - pi$1) < epsilon$2) {
        // line crosses a pole
        stream.point(
          lambda0,
          (phi0 = (phi0 + phi1) / 2 > 0 ? halfPi$1 : -halfPi$1),
        );
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        stream.point(lambda1, phi0);
        clean = 0;
      } else if (sign0 !== sign1 && delta >= pi$1) {
        // line crosses antimeridian
        if (abs$1(lambda0 - sign0) < epsilon$2) lambda0 -= sign0 * epsilon$2; // handle degeneracies
        if (abs$1(lambda1 - sign1) < epsilon$2) lambda1 -= sign1 * epsilon$2;
        phi0 = clipAntimeridianIntersect$1(lambda0, phi0, lambda1, phi1);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        clean = 0;
      }
      stream.point((lambda0 = lambda1), (phi0 = phi1));
      sign0 = sign1;
    },
    lineEnd: function () {
      stream.lineEnd();
      lambda0 = phi0 = NaN;
    },
    clean: function () {
      return 2 - clean; // if intersections, rejoin first and last segments
    },
  };
}

function clipAntimeridianIntersect$1(lambda0, phi0, lambda1, phi1) {
  var cosPhi0,
    cosPhi1,
    sinLambda0Lambda1 = sin$1(lambda0 - lambda1);
  return abs$1(sinLambda0Lambda1) > epsilon$2
    ? atan$1(
        (sin$1(phi0) * (cosPhi1 = cos$1(phi1)) * sin$1(lambda1) -
          sin$1(phi1) * (cosPhi0 = cos$1(phi0)) * sin$1(lambda0)) /
          (cosPhi0 * cosPhi1 * sinLambda0Lambda1),
      )
    : (phi0 + phi1) / 2;
}

function clipAntimeridianInterpolate$1(from, to, direction, stream) {
  var phi;
  if (from == null) {
    phi = direction * halfPi$1;
    stream.point(-pi$1, phi);
    stream.point(0, phi);
    stream.point(pi$1, phi);
    stream.point(pi$1, 0);
    stream.point(pi$1, -phi);
    stream.point(0, -phi);
    stream.point(-pi$1, -phi);
    stream.point(-pi$1, 0);
    stream.point(-pi$1, phi);
  } else if (abs$1(from[0] - to[0]) > epsilon$2) {
    var lambda = from[0] < to[0] ? pi$1 : -pi$1;
    phi = (direction * lambda) / 2;
    stream.point(-lambda, phi);
    stream.point(0, phi);
    stream.point(lambda, phi);
  } else {
    stream.point(to[0], to[1]);
  }
}

function clipCircle$1(radius) {
  var cr = cos$1(radius),
    delta = 2 * radians$1,
    smallRadius = cr > 0,
    notHemisphere = abs$1(cr) > epsilon$2; // TODO optimise for this common case

  function interpolate(from, to, direction, stream) {
    circleStream$1(stream, radius, delta, direction, from, to);
  }

  function visible(lambda, phi) {
    return cos$1(lambda) * cos$1(phi) > cr;
  }

  // Takes a line and cuts into visible segments. Return values used for polygon
  // clipping: 0 - there were intersections or the line was empty; 1 - no
  // intersections 2 - there were intersections, and the first and last segments
  // should be rejoined.
  function clipLine(stream) {
    var point0, // previous point
      c0, // code for previous point
      v0, // visibility of previous point
      v00, // visibility of first point
      clean; // no intersections
    return {
      lineStart: function () {
        v00 = v0 = false;
        clean = 1;
      },
      point: function (lambda, phi) {
        var point1 = [lambda, phi],
          point2,
          v = visible(lambda, phi),
          c = smallRadius
            ? v
              ? 0
              : code(lambda, phi)
            : v
              ? code(lambda + (lambda < 0 ? pi$1 : -pi$1), phi)
              : 0;
        if (!point0 && (v00 = v0 = v)) stream.lineStart();
        if (v !== v0) {
          point2 = intersect(point0, point1);
          if (
            !point2 ||
            pointEqual$1(point0, point2) ||
            pointEqual$1(point1, point2)
          )
            point1[2] = 1;
        }
        if (v !== v0) {
          clean = 0;
          if (v) {
            // outside going in
            stream.lineStart();
            point2 = intersect(point1, point0);
            stream.point(point2[0], point2[1]);
          } else {
            // inside going out
            point2 = intersect(point0, point1);
            stream.point(point2[0], point2[1], 2);
            stream.lineEnd();
          }
          point0 = point2;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          // If the codes for two points are different, or are both zero,
          // and there this segment intersects with the small circle.
          if (!(c & c0) && (t = intersect(point1, point0, true))) {
            clean = 0;
            if (smallRadius) {
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
            } else {
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
              stream.lineStart();
              stream.point(t[0][0], t[0][1], 3);
            }
          }
        }
        if (v && (!point0 || !pointEqual$1(point0, point1))) {
          stream.point(point1[0], point1[1]);
        }
        ((point0 = point1), (v0 = v), (c0 = c));
      },
      lineEnd: function () {
        if (v0) stream.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function () {
        return clean | ((v00 && v0) << 1);
      },
    };
  }

  // Intersects the great circle between a and b with the clip circle.
  function intersect(a, b, two) {
    var pa = cartesian$1(a),
      pb = cartesian$1(b);

    // We have two planes, n1.p = d1 and n2.p = d2.
    // Find intersection line p(t) = c1 n1 + c2 n2 + t (n1 ⨯ n2).
    var n1 = [1, 0, 0], // normal
      n2 = cartesianCross$1(pa, pb),
      n2n2 = cartesianDot$1(n2, n2),
      n1n2 = n2[0], // cartesianDot(n1, n2),
      determinant = n2n2 - n1n2 * n1n2;

    // Two polar points.
    if (!determinant) return !two && a;

    var c1 = (cr * n2n2) / determinant,
      c2 = (-cr * n1n2) / determinant,
      n1xn2 = cartesianCross$1(n1, n2),
      A = cartesianScale$1(n1, c1),
      B = cartesianScale$1(n2, c2);
    cartesianAddInPlace$1(A, B);

    // Solve |p(t)|^2 = 1.
    var u = n1xn2,
      w = cartesianDot$1(A, u),
      uu = cartesianDot$1(u, u),
      t2 = w * w - uu * (cartesianDot$1(A, A) - 1);

    if (t2 < 0) return;

    var t = sqrt$1(t2),
      q = cartesianScale$1(u, (-w - t) / uu);
    cartesianAddInPlace$1(q, A);
    q = spherical$1(q);

    if (!two) return q;

    // Two intersection points.
    var lambda0 = a[0],
      lambda1 = b[0],
      phi0 = a[1],
      phi1 = b[1],
      z;

    if (lambda1 < lambda0) ((z = lambda0), (lambda0 = lambda1), (lambda1 = z));

    var delta = lambda1 - lambda0,
      polar = abs$1(delta - pi$1) < epsilon$2,
      meridian = polar || delta < epsilon$2;

    if (!polar && phi1 < phi0) ((z = phi0), (phi0 = phi1), (phi1 = z));

    // Check that the first point is between a and b.
    if (
      meridian
        ? polar
          ? (phi0 + phi1 > 0) ^
            (q[1] < (abs$1(q[0] - lambda0) < epsilon$2 ? phi0 : phi1))
          : phi0 <= q[1] && q[1] <= phi1
        : (delta > pi$1) ^ (lambda0 <= q[0] && q[0] <= lambda1)
    ) {
      var q1 = cartesianScale$1(u, (-w + t) / uu);
      cartesianAddInPlace$1(q1, A);
      return [q, spherical$1(q1)];
    }
  }

  // Generates a 4-bit vector representing the location of a point relative to
  // the small circle's bounding box.
  function code(lambda, phi) {
    var r = smallRadius ? radius : pi$1 - radius,
      code = 0;
    if (lambda < -r)
      code |= 1; // left
    else if (lambda > r) code |= 2; // right
    if (phi < -r)
      code |= 4; // below
    else if (phi > r) code |= 8; // above
    return code;
  }

  return clip$1(
    visible,
    clipLine,
    interpolate,
    smallRadius ? [0, -radius] : [-pi$1, radius - pi$1],
  );
}

function clipLine$1(a, b, x0, y0, x1, y1) {
  var ax = a[0],
    ay = a[1],
    bx = b[0],
    by = b[1],
    t0 = 0,
    t1 = 1,
    dx = bx - ax,
    dy = by - ay,
    r;

  r = x0 - ax;
  if (!dx && r > 0) return;
  r /= dx;
  if (dx < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dx > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = x1 - ax;
  if (!dx && r < 0) return;
  r /= dx;
  if (dx < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dx > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  r = y0 - ay;
  if (!dy && r > 0) return;
  r /= dy;
  if (dy < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dy > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = y1 - ay;
  if (!dy && r < 0) return;
  r /= dy;
  if (dy < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dy > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  if (t0 > 0) ((a[0] = ax + t0 * dx), (a[1] = ay + t0 * dy));
  if (t1 < 1) ((b[0] = ax + t1 * dx), (b[1] = ay + t1 * dy));
  return true;
}

var clipMax$1 = 1e9,
  clipMin$1 = -clipMax$1;

// TODO Use d3-polygon’s polygonContains here for the ring check?
// TODO Eliminate duplicate buffering in clipBuffer and polygon.push?

function clipRectangle$1(x0, y0, x1, y1) {
  function visible(x, y) {
    return x0 <= x && x <= x1 && y0 <= y && y <= y1;
  }

  function interpolate(from, to, direction, stream) {
    var a = 0,
      a1 = 0;
    if (
      from == null ||
      (a = corner(from, direction)) !== (a1 = corner(to, direction)) ||
      (comparePoint(from, to) < 0) ^ (direction > 0)
    ) {
      do stream.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0);
      while ((a = (a + direction + 4) % 4) !== a1);
    } else {
      stream.point(to[0], to[1]);
    }
  }

  function corner(p, direction) {
    return abs$1(p[0] - x0) < epsilon$2
      ? direction > 0
        ? 0
        : 3
      : abs$1(p[0] - x1) < epsilon$2
        ? direction > 0
          ? 2
          : 1
        : abs$1(p[1] - y0) < epsilon$2
          ? direction > 0
            ? 1
            : 0
          : direction > 0
            ? 3
            : 2; // abs(p[1] - y1) < epsilon
  }

  function compareIntersection(a, b) {
    return comparePoint(a.x, b.x);
  }

  function comparePoint(a, b) {
    var ca = corner(a, 1),
      cb = corner(b, 1);
    return ca !== cb
      ? ca - cb
      : ca === 0
        ? b[1] - a[1]
        : ca === 1
          ? a[0] - b[0]
          : ca === 2
            ? a[1] - b[1]
            : b[0] - a[0];
  }

  return function (stream) {
    var activeStream = stream,
      bufferStream = clipBuffer$1(),
      segments,
      polygon,
      ring,
      x__,
      y__,
      v__, // first point
      x_,
      y_,
      v_, // previous point
      first,
      clean;

    var clipStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: polygonStart,
      polygonEnd: polygonEnd,
    };

    function point(x, y) {
      if (visible(x, y)) activeStream.point(x, y);
    }

    function polygonInside() {
      var winding = 0;

      for (var i = 0, n = polygon.length; i < n; ++i) {
        for (
          var ring = polygon[i],
            j = 1,
            m = ring.length,
            point = ring[0],
            a0,
            a1,
            b0 = point[0],
            b1 = point[1];
          j < m;
          ++j
        ) {
          ((a0 = b0),
            (a1 = b1),
            (point = ring[j]),
            (b0 = point[0]),
            (b1 = point[1]));
          if (a1 <= y1) {
            if (b1 > y1 && (b0 - a0) * (y1 - a1) > (b1 - a1) * (x0 - a0))
              ++winding;
          } else {
            if (b1 <= y1 && (b0 - a0) * (y1 - a1) < (b1 - a1) * (x0 - a0))
              --winding;
          }
        }
      }

      return winding;
    }

    // Buffer geometry within a polygon and then clip it en masse.
    function polygonStart() {
      ((activeStream = bufferStream),
        (segments = []),
        (polygon = []),
        (clean = true));
    }

    function polygonEnd() {
      var startInside = polygonInside(),
        cleanInside = clean && startInside,
        visible = (segments = merge$1(segments)).length;
      if (cleanInside || visible) {
        stream.polygonStart();
        if (cleanInside) {
          stream.lineStart();
          interpolate(null, null, 1, stream);
          stream.lineEnd();
        }
        if (visible) {
          clipRejoin$1(
            segments,
            compareIntersection,
            startInside,
            interpolate,
            stream,
          );
        }
        stream.polygonEnd();
      }
      ((activeStream = stream), (segments = polygon = ring = null));
    }

    function lineStart() {
      clipStream.point = linePoint;
      if (polygon) polygon.push((ring = []));
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }

    // TODO rather than special-case polygons, simply handle them separately.
    // Ideally, coincident intersection points should be jittered to avoid
    // clipping issues.
    function lineEnd() {
      if (segments) {
        linePoint(x__, y__);
        if (v__ && v_) bufferStream.rejoin();
        segments.push(bufferStream.result());
      }
      clipStream.point = point;
      if (v_) activeStream.lineEnd();
    }

    function linePoint(x, y) {
      var v = visible(x, y);
      if (polygon) ring.push([x, y]);
      if (first) {
        ((x__ = x), (y__ = y), (v__ = v));
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x, y);
        }
      } else {
        if (v && v_) activeStream.point(x, y);
        else {
          var a = [
              (x_ = Math.max(clipMin$1, Math.min(clipMax$1, x_))),
              (y_ = Math.max(clipMin$1, Math.min(clipMax$1, y_))),
            ],
            b = [
              (x = Math.max(clipMin$1, Math.min(clipMax$1, x))),
              (y = Math.max(clipMin$1, Math.min(clipMax$1, y))),
            ];
          if (clipLine$1(a, b, x0, y0, x1, y1)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a[0], a[1]);
            }
            activeStream.point(b[0], b[1]);
            if (!v) activeStream.lineEnd();
            clean = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x, y);
            clean = false;
          }
        }
      }
      ((x_ = x), (y_ = y), (v_ = v));
    }

    return clipStream;
  };
}

var lengthSum$1, lambda0, sinPhi0, cosPhi0;

var lengthStream$1 = {
  sphere: noop$2,
  point: noop$2,
  lineStart: lengthLineStart,
  lineEnd: noop$2,
  polygonStart: noop$2,
  polygonEnd: noop$2,
};

function lengthLineStart() {
  lengthStream$1.point = lengthPointFirst$1;
  lengthStream$1.lineEnd = lengthLineEnd;
}

function lengthLineEnd() {
  lengthStream$1.point = lengthStream$1.lineEnd = noop$2;
}

function lengthPointFirst$1(lambda, phi) {
  ((lambda *= radians$1), (phi *= radians$1));
  ((lambda0 = lambda), (sinPhi0 = sin$1(phi)), (cosPhi0 = cos$1(phi)));
  lengthStream$1.point = lengthPoint$1;
}

function lengthPoint$1(lambda, phi) {
  ((lambda *= radians$1), (phi *= radians$1));
  var sinPhi = sin$1(phi),
    cosPhi = cos$1(phi),
    delta = abs$1(lambda - lambda0),
    cosDelta = cos$1(delta),
    sinDelta = sin$1(delta),
    x = cosPhi * sinDelta,
    y = cosPhi0 * sinPhi - sinPhi0 * cosPhi * cosDelta,
    z = sinPhi0 * sinPhi + cosPhi0 * cosPhi * cosDelta;
  lengthSum$1.add(atan2$1(sqrt$1(x * x + y * y), z));
  ((lambda0 = lambda), (sinPhi0 = sinPhi), (cosPhi0 = cosPhi));
}

function length(object) {
  lengthSum$1 = new Adder();
  geoStream$1(object, lengthStream$1);
  return +lengthSum$1;
}

var coordinates = [null, null],
  object$1 = { type: "LineString", coordinates: coordinates };

function distance(a, b) {
  coordinates[0] = a;
  coordinates[1] = b;
  return length(object$1);
}

var containsObjectType = {
  Feature: function (object, point) {
    return containsGeometry(object.geometry, point);
  },
  FeatureCollection: function (object, point) {
    var features = object.features,
      i = -1,
      n = features.length;
    while (++i < n)
      if (containsGeometry(features[i].geometry, point)) return true;
    return false;
  },
};

var containsGeometryType = {
  Sphere: function () {
    return true;
  },
  Point: function (object, point) {
    return containsPoint(object.coordinates, point);
  },
  MultiPoint: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsPoint(coordinates[i], point)) return true;
    return false;
  },
  LineString: function (object, point) {
    return containsLine(object.coordinates, point);
  },
  MultiLineString: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsLine(coordinates[i], point)) return true;
    return false;
  },
  Polygon: function (object, point) {
    return containsPolygon(object.coordinates, point);
  },
  MultiPolygon: function (object, point) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) if (containsPolygon(coordinates[i], point)) return true;
    return false;
  },
  GeometryCollection: function (object, point) {
    var geometries = object.geometries,
      i = -1,
      n = geometries.length;
    while (++i < n) if (containsGeometry(geometries[i], point)) return true;
    return false;
  },
};

function containsGeometry(geometry, point) {
  return geometry && containsGeometryType.hasOwnProperty(geometry.type)
    ? containsGeometryType[geometry.type](geometry, point)
    : false;
}

function containsPoint(coordinates, point) {
  return distance(coordinates, point) === 0;
}

function containsLine(coordinates, point) {
  var ao, bo, ab;
  for (var i = 0, n = coordinates.length; i < n; i++) {
    bo = distance(coordinates[i], point);
    if (bo === 0) return true;
    if (i > 0) {
      ab = distance(coordinates[i], coordinates[i - 1]);
      if (
        ab > 0 &&
        ao <= ab &&
        bo <= ab &&
        (ao + bo - ab) * (1 - Math.pow((ao - bo) / ab, 2)) < epsilon2 * ab
      )
        return true;
    }
    ao = bo;
  }
  return false;
}

function containsPolygon(coordinates, point) {
  return !!polygonContains$1(coordinates.map(ringRadians), pointRadians(point));
}

function ringRadians(ring) {
  return ((ring = ring.map(pointRadians)), ring.pop(), ring);
}

function pointRadians(point) {
  return [point[0] * radians$1, point[1] * radians$1];
}

function geoContains(object, point) {
  return (
    object && containsObjectType.hasOwnProperty(object.type)
      ? containsObjectType[object.type]
      : containsGeometry
  )(object, point);
}

const identity$2 = (x) => x;

var areaSum = new Adder(),
  areaRingSum = new Adder(),
  x00$2,
  y00$2,
  x0$5,
  y0$5;

var areaStream = {
  point: noop$2,
  lineStart: noop$2,
  lineEnd: noop$2,
  polygonStart: function () {
    areaStream.lineStart = areaRingStart;
    areaStream.lineEnd = areaRingEnd;
  },
  polygonEnd: function () {
    areaStream.lineStart = areaStream.lineEnd = areaStream.point = noop$2;
    areaSum.add(abs$1(areaRingSum));
    areaRingSum = new Adder();
  },
  result: function () {
    var area = areaSum / 2;
    areaSum = new Adder();
    return area;
  },
};

function areaRingStart() {
  areaStream.point = areaPointFirst;
}

function areaPointFirst(x, y) {
  areaStream.point = areaPoint;
  ((x00$2 = x0$5 = x), (y00$2 = y0$5 = y));
}

function areaPoint(x, y) {
  areaRingSum.add(y0$5 * x - x0$5 * y);
  ((x0$5 = x), (y0$5 = y));
}

function areaRingEnd() {
  areaPoint(x00$2, y00$2);
}

var x0$4 = Infinity,
  y0$4 = x0$4,
  x1$2 = -x0$4,
  y1$2 = x1$2;

var boundsStream$2 = {
  point: boundsPoint$2,
  lineStart: noop$2,
  lineEnd: noop$2,
  polygonStart: noop$2,
  polygonEnd: noop$2,
  result: function () {
    var bounds = [
      [x0$4, y0$4],
      [x1$2, y1$2],
    ];
    x1$2 = y1$2 = -(y0$4 = x0$4 = Infinity);
    return bounds;
  },
};

function boundsPoint$2(x, y) {
  if (x < x0$4) x0$4 = x;
  if (x > x1$2) x1$2 = x;
  if (y < y0$4) y0$4 = y;
  if (y > y1$2) y1$2 = y;
}

// TODO Enforce positive area for exterior, negative area for interior?

var X0 = 0,
  Y0 = 0,
  Z0 = 0,
  X1 = 0,
  Y1 = 0,
  Z1 = 0,
  X2 = 0,
  Y2 = 0,
  Z2 = 0,
  x00$1,
  y00$1,
  x0$3,
  y0$3;

var centroidStream = {
  point: centroidPoint,
  lineStart: centroidLineStart,
  lineEnd: centroidLineEnd,
  polygonStart: function () {
    centroidStream.lineStart = centroidRingStart;
    centroidStream.lineEnd = centroidRingEnd;
  },
  polygonEnd: function () {
    centroidStream.point = centroidPoint;
    centroidStream.lineStart = centroidLineStart;
    centroidStream.lineEnd = centroidLineEnd;
  },
  result: function () {
    var centroid = Z2
      ? [X2 / Z2, Y2 / Z2]
      : Z1
        ? [X1 / Z1, Y1 / Z1]
        : Z0
          ? [X0 / Z0, Y0 / Z0]
          : [NaN, NaN];
    X0 = Y0 = Z0 = X1 = Y1 = Z1 = X2 = Y2 = Z2 = 0;
    return centroid;
  },
};

function centroidPoint(x, y) {
  X0 += x;
  Y0 += y;
  ++Z0;
}

function centroidLineStart() {
  centroidStream.point = centroidPointFirstLine;
}

function centroidPointFirstLine(x, y) {
  centroidStream.point = centroidPointLine;
  centroidPoint((x0$3 = x), (y0$3 = y));
}

function centroidPointLine(x, y) {
  var dx = x - x0$3,
    dy = y - y0$3,
    z = sqrt$1(dx * dx + dy * dy);
  X1 += (z * (x0$3 + x)) / 2;
  Y1 += (z * (y0$3 + y)) / 2;
  Z1 += z;
  centroidPoint((x0$3 = x), (y0$3 = y));
}

function centroidLineEnd() {
  centroidStream.point = centroidPoint;
}

function centroidRingStart() {
  centroidStream.point = centroidPointFirstRing;
}

function centroidRingEnd() {
  centroidPointRing(x00$1, y00$1);
}

function centroidPointFirstRing(x, y) {
  centroidStream.point = centroidPointRing;
  centroidPoint((x00$1 = x0$3 = x), (y00$1 = y0$3 = y));
}

function centroidPointRing(x, y) {
  var dx = x - x0$3,
    dy = y - y0$3,
    z = sqrt$1(dx * dx + dy * dy);

  X1 += (z * (x0$3 + x)) / 2;
  Y1 += (z * (y0$3 + y)) / 2;
  Z1 += z;

  z = y0$3 * x - x0$3 * y;
  X2 += z * (x0$3 + x);
  Y2 += z * (y0$3 + y);
  Z2 += z * 3;
  centroidPoint((x0$3 = x), (y0$3 = y));
}

function PathContext(context) {
  this._context = context;
}

PathContext.prototype = {
  _radius: 4.5,
  pointRadius: function (_) {
    return ((this._radius = _), this);
  },
  polygonStart: function () {
    this._line = 0;
  },
  polygonEnd: function () {
    this._line = NaN;
  },
  lineStart: function () {
    this._point = 0;
  },
  lineEnd: function () {
    if (this._line === 0) this._context.closePath();
    this._point = NaN;
  },
  point: function (x, y) {
    switch (this._point) {
      case 0: {
        this._context.moveTo(x, y);
        this._point = 1;
        break;
      }
      case 1: {
        this._context.lineTo(x, y);
        break;
      }
      default: {
        this._context.moveTo(x + this._radius, y);
        this._context.arc(x, y, this._radius, 0, tau$1);
        break;
      }
    }
  },
  result: noop$2,
};

var lengthSum = new Adder(),
  lengthRing,
  x00,
  y00,
  x0$2,
  y0$2;

var lengthStream = {
  point: noop$2,
  lineStart: function () {
    lengthStream.point = lengthPointFirst;
  },
  lineEnd: function () {
    if (lengthRing) lengthPoint(x00, y00);
    lengthStream.point = noop$2;
  },
  polygonStart: function () {
    lengthRing = true;
  },
  polygonEnd: function () {
    lengthRing = null;
  },
  result: function () {
    var length = +lengthSum;
    lengthSum = new Adder();
    return length;
  },
};

function lengthPointFirst(x, y) {
  lengthStream.point = lengthPoint;
  ((x00 = x0$2 = x), (y00 = y0$2 = y));
}

function lengthPoint(x, y) {
  ((x0$2 -= x), (y0$2 -= y));
  lengthSum.add(sqrt$1(x0$2 * x0$2 + y0$2 * y0$2));
  ((x0$2 = x), (y0$2 = y));
}

// Simple caching for constant-radius points.
let cacheDigits, cacheAppend, cacheRadius, cacheCircle;

class PathString {
  constructor(digits) {
    this._append = digits == null ? append : appendRound(digits);
    this._radius = 4.5;
    this._ = "";
  }
  pointRadius(_) {
    this._radius = +_;
    return this;
  }
  polygonStart() {
    this._line = 0;
  }
  polygonEnd() {
    this._line = NaN;
  }
  lineStart() {
    this._point = 0;
  }
  lineEnd() {
    if (this._line === 0) this._ += "Z";
    this._point = NaN;
  }
  point(x, y) {
    switch (this._point) {
      case 0: {
        this._append`M${x},${y}`;
        this._point = 1;
        break;
      }
      case 1: {
        this._append`L${x},${y}`;
        break;
      }
      default: {
        this._append`M${x},${y}`;
        if (this._radius !== cacheRadius || this._append !== cacheAppend) {
          const r = this._radius;
          const s = this._;
          this._ = ""; // stash the old string so we can cache the circle path fragment
          this
            ._append`m0,${r}a${r},${r} 0 1,1 0,${-2 * r}a${r},${r} 0 1,1 0,${2 * r}z`;
          cacheRadius = r;
          cacheAppend = this._append;
          cacheCircle = this._;
          this._ = s;
        }
        this._ += cacheCircle;
        break;
      }
    }
  }
  result() {
    const result = this._;
    this._ = "";
    return result.length ? result : null;
  }
}

function append(strings) {
  let i = 1;
  this._ += strings[0];
  for (const j = strings.length; i < j; ++i) {
    this._ += arguments[i] + strings[i];
  }
}

function appendRound(digits) {
  const d = Math.floor(digits);
  if (!(d >= 0)) throw new RangeError(`invalid digits: ${digits}`);
  if (d > 15) return append;
  if (d !== cacheDigits) {
    const k = 10 ** d;
    cacheDigits = d;
    cacheAppend = function append(strings) {
      let i = 1;
      this._ += strings[0];
      for (const j = strings.length; i < j; ++i) {
        this._ += Math.round(arguments[i] * k) / k + strings[i];
      }
    };
  }
  return cacheAppend;
}

function d3GeoPath(projection, context) {
  let digits = 3,
    pointRadius = 4.5,
    projectionStream,
    contextStream;

  function path(object) {
    if (object) {
      if (typeof pointRadius === "function")
        contextStream.pointRadius(+pointRadius.apply(this, arguments));
      geoStream$1(object, projectionStream(contextStream));
    }
    return contextStream.result();
  }

  path.area = function (object) {
    geoStream$1(object, projectionStream(areaStream));
    return areaStream.result();
  };

  path.measure = function (object) {
    geoStream$1(object, projectionStream(lengthStream));
    return lengthStream.result();
  };

  path.bounds = function (object) {
    geoStream$1(object, projectionStream(boundsStream$2));
    return boundsStream$2.result();
  };

  path.centroid = function (object) {
    geoStream$1(object, projectionStream(centroidStream));
    return centroidStream.result();
  };

  path.projection = function (_) {
    if (!arguments.length) return projection;
    projectionStream =
      _ == null ? ((projection = null), identity$2) : (projection = _).stream;
    return path;
  };

  path.context = function (_) {
    if (!arguments.length) return context;
    contextStream =
      _ == null
        ? ((context = null), new PathString(digits))
        : new PathContext((context = _));
    if (typeof pointRadius !== "function")
      contextStream.pointRadius(pointRadius);
    return path;
  };

  path.pointRadius = function (_) {
    if (!arguments.length) return pointRadius;
    pointRadius =
      typeof _ === "function" ? _ : (contextStream.pointRadius(+_), +_);
    return path;
  };

  path.digits = function (_) {
    if (!arguments.length) return digits;
    if (_ == null) digits = null;
    else {
      const d = Math.floor(_);
      if (!(d >= 0)) throw new RangeError(`invalid digits: ${_}`);
      digits = d;
    }
    if (context === null) contextStream = new PathString(digits);
    return path;
  };

  return path.projection(projection).digits(digits).context(context);
}

function transformer$1(methods) {
  return function (stream) {
    var s = new TransformStream$1();
    for (var key in methods) s[key] = methods[key];
    s.stream = stream;
    return s;
  };
}

function TransformStream$1() {}

TransformStream$1.prototype = {
  constructor: TransformStream$1,
  point: function (x, y) {
    this.stream.point(x, y);
  },
  sphere: function () {
    this.stream.sphere();
  },
  lineStart: function () {
    this.stream.lineStart();
  },
  lineEnd: function () {
    this.stream.lineEnd();
  },
  polygonStart: function () {
    this.stream.polygonStart();
  },
  polygonEnd: function () {
    this.stream.polygonEnd();
  },
};

function fit$1(projection, fitBounds, object) {
  var clip = projection.clipExtent && projection.clipExtent();
  projection.scale(150).translate([0, 0]);
  if (clip != null) projection.clipExtent(null);
  geoStream$1(object, projection.stream(boundsStream$2));
  fitBounds(boundsStream$2.result());
  if (clip != null) projection.clipExtent(clip);
  return projection;
}

function fitExtent$2(projection, extent, object) {
  return fit$1(
    projection,
    function (b) {
      var w = extent[1][0] - extent[0][0],
        h = extent[1][1] - extent[0][1],
        k = Math.min(w / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])),
        x = +extent[0][0] + (w - k * (b[1][0] + b[0][0])) / 2,
        y = +extent[0][1] + (h - k * (b[1][1] + b[0][1])) / 2;
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

function fitSize$2(projection, size, object) {
  return fitExtent$2(projection, [[0, 0], size], object);
}

function fitWidth$1(projection, width, object) {
  return fit$1(
    projection,
    function (b) {
      var w = +width,
        k = w / (b[1][0] - b[0][0]),
        x = (w - k * (b[1][0] + b[0][0])) / 2,
        y = -k * b[0][1];
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

function fitHeight$1(projection, height, object) {
  return fit$1(
    projection,
    function (b) {
      var h = +height,
        k = h / (b[1][1] - b[0][1]),
        x = -k * b[0][0],
        y = (h - k * (b[1][1] + b[0][1])) / 2;
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

var maxDepth$1 = 16, // maximum depth of subdivision
  cosMinDistance$1 = cos$1(30 * radians$1); // cos(minimum angular distance)

function resample$2(project, delta2) {
  return +delta2 ? resample$3(project, delta2) : resampleNone$1(project);
}

function resampleNone$1(project) {
  return transformer$1({
    point: function (x, y) {
      x = project(x, y);
      this.stream.point(x[0], x[1]);
    },
  });
}

function resample$3(project, delta2) {
  function resampleLineTo(
    x0,
    y0,
    lambda0,
    a0,
    b0,
    c0,
    x1,
    y1,
    lambda1,
    a1,
    b1,
    c1,
    depth,
    stream,
  ) {
    var dx = x1 - x0,
      dy = y1 - y0,
      d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a = a0 + a1,
        b = b0 + b1,
        c = c0 + c1,
        m = sqrt$1(a * a + b * b + c * c),
        phi2 = asin$1((c /= m)),
        lambda2 =
          abs$1(abs$1(c) - 1) < epsilon$2 ||
          abs$1(lambda0 - lambda1) < epsilon$2
            ? (lambda0 + lambda1) / 2
            : atan2$1(b, a),
        p = project(lambda2, phi2),
        x2 = p[0],
        y2 = p[1],
        dx2 = x2 - x0,
        dy2 = y2 - y0,
        dz = dy * dx2 - dx * dy2;
      if (
        (dz * dz) / d2 > delta2 || // perpendicular projected distance
        abs$1((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 || // midpoint close to an end
        a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance$1
      ) {
        // angular distance
        resampleLineTo(
          x0,
          y0,
          lambda0,
          a0,
          b0,
          c0,
          x2,
          y2,
          lambda2,
          (a /= m),
          (b /= m),
          c,
          depth,
          stream,
        );
        stream.point(x2, y2);
        resampleLineTo(
          x2,
          y2,
          lambda2,
          a,
          b,
          c,
          x1,
          y1,
          lambda1,
          a1,
          b1,
          c1,
          depth,
          stream,
        );
      }
    }
  }
  return function (stream) {
    var lambda00,
      x00,
      y00,
      a00,
      b00,
      c00, // first point
      lambda0,
      x0,
      y0,
      a0,
      b0,
      c0; // previous point

    var resampleStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        stream.polygonStart();
        resampleStream.lineStart = ringStart;
      },
      polygonEnd: function () {
        stream.polygonEnd();
        resampleStream.lineStart = lineStart;
      },
    };

    function point(x, y) {
      x = project(x, y);
      stream.point(x[0], x[1]);
    }

    function lineStart() {
      x0 = NaN;
      resampleStream.point = linePoint;
      stream.lineStart();
    }

    function linePoint(lambda, phi) {
      var c = cartesian$1([lambda, phi]),
        p = project(lambda, phi);
      resampleLineTo(
        x0,
        y0,
        lambda0,
        a0,
        b0,
        c0,
        (x0 = p[0]),
        (y0 = p[1]),
        (lambda0 = lambda),
        (a0 = c[0]),
        (b0 = c[1]),
        (c0 = c[2]),
        maxDepth$1,
        stream,
      );
      stream.point(x0, y0);
    }

    function lineEnd() {
      resampleStream.point = point;
      stream.lineEnd();
    }

    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }

    function ringPoint(lambda, phi) {
      (linePoint((lambda00 = lambda), phi),
        (x00 = x0),
        (y00 = y0),
        (a00 = a0),
        (b00 = b0),
        (c00 = c0));
      resampleStream.point = linePoint;
    }

    function ringEnd() {
      resampleLineTo(
        x0,
        y0,
        lambda0,
        a0,
        b0,
        c0,
        x00,
        y00,
        lambda00,
        a00,
        b00,
        c00,
        maxDepth$1,
        stream,
      );
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }

    return resampleStream;
  };
}

var transformRadians$1 = transformer$1({
  point: function (x, y) {
    this.stream.point(x * radians$1, y * radians$1);
  },
});

function transformRotate$1(rotate) {
  return transformer$1({
    point: function (x, y) {
      var r = rotate(x, y);
      return this.stream.point(r[0], r[1]);
    },
  });
}

function scaleTranslate$1(k, dx, dy, sx, sy) {
  function transform(x, y) {
    x *= sx;
    y *= sy;
    return [dx + k * x, dy - k * y];
  }
  transform.invert = function (x, y) {
    return [((x - dx) / k) * sx, ((dy - y) / k) * sy];
  };
  return transform;
}

function scaleTranslateRotate$1(k, dx, dy, sx, sy, alpha) {
  if (!alpha) return scaleTranslate$1(k, dx, dy, sx, sy);
  var cosAlpha = cos$1(alpha),
    sinAlpha = sin$1(alpha),
    a = cosAlpha * k,
    b = sinAlpha * k,
    ai = cosAlpha / k,
    bi = sinAlpha / k,
    ci = (sinAlpha * dy - cosAlpha * dx) / k,
    fi = (sinAlpha * dx + cosAlpha * dy) / k;
  function transform(x, y) {
    x *= sx;
    y *= sy;
    return [a * x - b * y + dx, dy - b * x - a * y];
  }
  transform.invert = function (x, y) {
    return [sx * (ai * x - bi * y + ci), sy * (fi - bi * x - ai * y)];
  };
  return transform;
}

function projection$1(project) {
  return projectionMutator$1(function () {
    return project;
  })();
}

function projectionMutator$1(projectAt) {
  var project,
    k = 150, // scale
    x = 480,
    y = 250, // translate
    lambda = 0,
    phi = 0, // center
    deltaLambda = 0,
    deltaPhi = 0,
    deltaGamma = 0,
    rotate, // pre-rotate
    alpha = 0, // post-rotate angle
    sx = 1, // reflectX
    sy = 1, // reflectX
    theta = null,
    preclip = clipAntimeridian$1, // pre-clip angle
    x0 = null,
    y0,
    x1,
    y1,
    postclip = identity$2, // post-clip extent
    delta2 = 0.5, // precision
    projectResample,
    projectTransform,
    projectRotateTransform,
    cache,
    cacheStream;

  function projection(point) {
    return projectRotateTransform(point[0] * radians$1, point[1] * radians$1);
  }

  function invert(point) {
    point = projectRotateTransform.invert(point[0], point[1]);
    return point && [point[0] * degrees$1, point[1] * degrees$1];
  }

  projection.stream = function (stream) {
    return cache && cacheStream === stream
      ? cache
      : (cache = transformRadians$1(
          transformRotate$1(rotate)(
            preclip(projectResample(postclip((cacheStream = stream)))),
          ),
        ));
  };

  projection.preclip = function (_) {
    return arguments.length
      ? ((preclip = _), (theta = undefined), reset())
      : preclip;
  };

  projection.postclip = function (_) {
    return arguments.length
      ? ((postclip = _), (x0 = y0 = x1 = y1 = null), reset())
      : postclip;
  };

  projection.clipAngle = function (_) {
    return arguments.length
      ? ((preclip = +_
          ? clipCircle$1((theta = _ * radians$1))
          : ((theta = null), clipAntimeridian$1)),
        reset())
      : theta * degrees$1;
  };

  projection.clipExtent = function (_) {
    return arguments.length
      ? ((postclip =
          _ == null
            ? ((x0 = y0 = x1 = y1 = null), identity$2)
            : clipRectangle$1(
                (x0 = +_[0][0]),
                (y0 = +_[0][1]),
                (x1 = +_[1][0]),
                (y1 = +_[1][1]),
              )),
        reset())
      : x0 == null
        ? null
        : [
            [x0, y0],
            [x1, y1],
          ];
  };

  projection.scale = function (_) {
    return arguments.length ? ((k = +_), recenter()) : k;
  };

  projection.translate = function (_) {
    return arguments.length ? ((x = +_[0]), (y = +_[1]), recenter()) : [x, y];
  };

  projection.center = function (_) {
    return arguments.length
      ? ((lambda = (_[0] % 360) * radians$1),
        (phi = (_[1] % 360) * radians$1),
        recenter())
      : [lambda * degrees$1, phi * degrees$1];
  };

  projection.rotate = function (_) {
    return arguments.length
      ? ((deltaLambda = (_[0] % 360) * radians$1),
        (deltaPhi = (_[1] % 360) * radians$1),
        (deltaGamma = _.length > 2 ? (_[2] % 360) * radians$1 : 0),
        recenter())
      : [deltaLambda * degrees$1, deltaPhi * degrees$1, deltaGamma * degrees$1];
  };

  projection.angle = function (_) {
    return arguments.length
      ? ((alpha = (_ % 360) * radians$1), recenter())
      : alpha * degrees$1;
  };

  projection.reflectX = function (_) {
    return arguments.length ? ((sx = _ ? -1 : 1), recenter()) : sx < 0;
  };

  projection.reflectY = function (_) {
    return arguments.length ? ((sy = _ ? -1 : 1), recenter()) : sy < 0;
  };

  projection.precision = function (_) {
    return arguments.length
      ? ((projectResample = resample$2(projectTransform, (delta2 = _ * _))),
        reset())
      : sqrt$1(delta2);
  };

  projection.fitExtent = function (extent, object) {
    return fitExtent$2(projection, extent, object);
  };

  projection.fitSize = function (size, object) {
    return fitSize$2(projection, size, object);
  };

  projection.fitWidth = function (width, object) {
    return fitWidth$1(projection, width, object);
  };

  projection.fitHeight = function (height, object) {
    return fitHeight$1(projection, height, object);
  };

  function recenter() {
    var center = scaleTranslateRotate$1(k, 0, 0, sx, sy, alpha).apply(
        null,
        project(lambda, phi),
      ),
      transform = scaleTranslateRotate$1(
        k,
        x - center[0],
        y - center[1],
        sx,
        sy,
        alpha,
      );
    rotate = rotateRadians$1(deltaLambda, deltaPhi, deltaGamma);
    projectTransform = compose$1(project, transform);
    projectRotateTransform = compose$1(rotate, projectTransform);
    projectResample = resample$2(projectTransform, delta2);
    return reset();
  }

  function reset() {
    cache = cacheStream = null;
    return projection;
  }

  return function () {
    project = projectAt.apply(this, arguments);
    projection.invert = project.invert && invert;
    return recenter();
  };
}

function conicProjection$1(projectAt) {
  var phi0 = 0,
    phi1 = pi$1 / 3,
    m = projectionMutator$1(projectAt),
    p = m(phi0, phi1);

  p.parallels = function (_) {
    return arguments.length
      ? m((phi0 = _[0] * radians$1), (phi1 = _[1] * radians$1))
      : [phi0 * degrees$1, phi1 * degrees$1];
  };

  return p;
}

function mercatorRaw(lambda, phi) {
  return [lambda, log(tan((halfPi$1 + phi) / 2))];
}

mercatorRaw.invert = function (x, y) {
  return [x, 2 * atan$1(exp(y)) - halfPi$1];
};

function geoMercator() {
  return mercatorProjection(mercatorRaw).scale(961 / tau$1);
}

function mercatorProjection(project) {
  var m = projection$1(project),
    center = m.center,
    scale = m.scale,
    translate = m.translate,
    clipExtent = m.clipExtent,
    x0 = null,
    y0,
    x1,
    y1; // clip extent

  m.scale = function (_) {
    return arguments.length ? (scale(_), reclip()) : scale();
  };

  m.translate = function (_) {
    return arguments.length ? (translate(_), reclip()) : translate();
  };

  m.center = function (_) {
    return arguments.length ? (center(_), reclip()) : center();
  };

  m.clipExtent = function (_) {
    return arguments.length
      ? (_ == null
          ? (x0 = y0 = x1 = y1 = null)
          : ((x0 = +_[0][0]),
            (y0 = +_[0][1]),
            (x1 = +_[1][0]),
            (y1 = +_[1][1])),
        reclip())
      : x0 == null
        ? null
        : [
            [x0, y0],
            [x1, y1],
          ];
  };

  function reclip() {
    var k = pi$1 * scale(),
      t = m(rotation(m.rotate()).invert([0, 0]));
    return clipExtent(
      x0 == null
        ? [
            [t[0] - k, t[1] - k],
            [t[0] + k, t[1] + k],
          ]
        : project === mercatorRaw
          ? [
              [Math.max(t[0] - k, x0), y0],
              [Math.min(t[0] + k, x1), y1],
            ]
          : [
              [x0, Math.max(t[1] - k, y0)],
              [x1, Math.min(t[1] + k, y1)],
            ],
    );
  }

  return reclip();
}

function tany(y) {
  return tan((halfPi$1 + y) / 2);
}

function conicConformalRaw(y0, y1) {
  var cy0 = cos$1(y0),
    n = y0 === y1 ? sin$1(y0) : log(cy0 / cos$1(y1)) / log(tany(y1) / tany(y0)),
    f = (cy0 * pow(tany(y0), n)) / n;

  if (!n) return mercatorRaw;

  function project(x, y) {
    if (f > 0) {
      if (y < -halfPi$1 + epsilon$2) y = -halfPi$1 + epsilon$2;
    } else {
      if (y > halfPi$1 - epsilon$2) y = halfPi$1 - epsilon$2;
    }
    var r = f / pow(tany(y), n);
    return [r * sin$1(n * x), f - r * cos$1(n * x)];
  }

  project.invert = function (x, y) {
    var fy = f - y,
      r = sign$1(n) * sqrt$1(x * x + fy * fy),
      l = atan2$1(x, abs$1(fy)) * sign$1(fy);
    if (fy * n < 0) l -= pi$1 * sign$1(x) * sign$1(fy);
    return [l / n, 2 * atan$1(pow(f / r, 1 / n)) - halfPi$1];
  };

  return project;
}

function geoConicConformal() {
  return conicProjection$1(conicConformalRaw).scale(109.5).parallels([30, 30]);
}

function naturalEarth1Raw(lambda, phi) {
  var phi2 = phi * phi,
    phi4 = phi2 * phi2;
  return [
    lambda *
      (0.8707 -
        0.131979 * phi2 +
        phi4 * (-0.013791 + phi4 * (0.003971 * phi2 - 0.001529 * phi4))),
    phi *
      (1.007226 +
        phi2 *
          (0.015085 + phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4))),
  ];
}

naturalEarth1Raw.invert = function (x, y) {
  var phi = y,
    i = 25,
    delta;
  do {
    var phi2 = phi * phi,
      phi4 = phi2 * phi2;
    phi -= delta =
      (phi *
        (1.007226 +
          phi2 *
            (0.015085 +
              phi4 * (-0.044475 + 0.028874 * phi2 - 0.005916 * phi4))) -
        y) /
      (1.007226 +
        phi2 *
          (0.015085 * 3 +
            phi4 *
              (-0.044475 * 7 + 0.028874 * 9 * phi2 - 0.005916 * 11 * phi4)));
  } while (abs$1(delta) > epsilon$2 && --i > 0);
  return [
    x /
      (0.8707 +
        (phi2 = phi * phi) *
          (-0.131979 +
            phi2 *
              (-0.013791 + phi2 * phi2 * phi2 * (0.003971 - 0.001529 * phi2)))),
    phi,
  ];
};

function geoNaturalEarth1() {
  return projection$1(naturalEarth1Raw).scale(175.295);
}

function Transform(k, x, y) {
  this.k = k;
  this.x = x;
  this.y = y;
}

Transform.prototype = {
  constructor: Transform,
  scale: function (k) {
    return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
  },
  translate: function (x, y) {
    return (x === 0) & (y === 0)
      ? this
      : new Transform(this.k, this.x + this.k * x, this.y + this.k * y);
  },
  apply: function (point) {
    return [point[0] * this.k + this.x, point[1] * this.k + this.y];
  },
  applyX: function (x) {
    return x * this.k + this.x;
  },
  applyY: function (y) {
    return y * this.k + this.y;
  },
  invert: function (location) {
    return [(location[0] - this.x) / this.k, (location[1] - this.y) / this.k];
  },
  invertX: function (x) {
    return (x - this.x) / this.k;
  },
  invertY: function (y) {
    return (y - this.y) / this.k;
  },
  rescaleX: function (x) {
    return x.copy().domain(x.range().map(this.invertX, this).map(x.invert, x));
  },
  rescaleY: function (y) {
    return y.copy().domain(y.range().map(this.invertY, this).map(y.invert, y));
  },
  toString: function () {
    return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
  },
};

Transform.prototype;

var epsilon$1 = 1e-6;

var epsilon = 1e-6;
var pi = Math.PI;
var halfPi = pi / 2;
var quarterPi = pi / 4;
var tau = pi * 2;

var degrees = 180 / pi;
var radians = pi / 180;

var abs = Math.abs;
var atan = Math.atan;
var atan2 = Math.atan2;
var cos = Math.cos;
var sin = Math.sin;
var sign =
  Math.sign ||
  function (x) {
    return x > 0 ? 1 : x < 0 ? -1 : 0;
  };
var sqrt = Math.sqrt;

function acos(x) {
  return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);
}

function asin(x) {
  return x > 1 ? halfPi : x < -1 ? -halfPi : Math.asin(x);
}

function noop$1() {}

function streamGeometry(geometry, stream) {
  if (geometry && streamGeometryType.hasOwnProperty(geometry.type)) {
    streamGeometryType[geometry.type](geometry, stream);
  }
}

var streamObjectType = {
  Feature: function (object, stream) {
    streamGeometry(object.geometry, stream);
  },
  FeatureCollection: function (object, stream) {
    var features = object.features,
      i = -1,
      n = features.length;
    while (++i < n) streamGeometry(features[i].geometry, stream);
  },
};

var streamGeometryType = {
  Sphere: function (object, stream) {
    stream.sphere();
  },
  Point: function (object, stream) {
    object = object.coordinates;
    stream.point(object[0], object[1], object[2]);
  },
  MultiPoint: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n)
      ((object = coordinates[i]),
        stream.point(object[0], object[1], object[2]));
  },
  LineString: function (object, stream) {
    streamLine(object.coordinates, stream, 0);
  },
  MultiLineString: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamLine(coordinates[i], stream, 0);
  },
  Polygon: function (object, stream) {
    streamPolygon(object.coordinates, stream);
  },
  MultiPolygon: function (object, stream) {
    var coordinates = object.coordinates,
      i = -1,
      n = coordinates.length;
    while (++i < n) streamPolygon(coordinates[i], stream);
  },
  GeometryCollection: function (object, stream) {
    var geometries = object.geometries,
      i = -1,
      n = geometries.length;
    while (++i < n) streamGeometry(geometries[i], stream);
  },
};

function streamLine(coordinates, stream, closed) {
  var i = -1,
    n = coordinates.length - closed,
    coordinate;
  stream.lineStart();
  while (++i < n)
    ((coordinate = coordinates[i]),
      stream.point(coordinate[0], coordinate[1], coordinate[2]));
  stream.lineEnd();
}

function streamPolygon(coordinates, stream) {
  var i = -1,
    n = coordinates.length;
  stream.polygonStart();
  while (++i < n) streamLine(coordinates[i], stream, 1);
  stream.polygonEnd();
}

function geoStream(object, stream) {
  if (object && streamObjectType.hasOwnProperty(object.type)) {
    streamObjectType[object.type](object, stream);
  } else {
    streamGeometry(object, stream);
  }
}

function spherical(cartesian) {
  return [atan2(cartesian[1], cartesian[0]), asin(cartesian[2])];
}

function cartesian(spherical) {
  var lambda = spherical[0],
    phi = spherical[1],
    cosPhi = cos(phi);
  return [cosPhi * cos(lambda), cosPhi * sin(lambda), sin(phi)];
}

function cartesianDot(a, b) {
  return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
}

function cartesianCross(a, b) {
  return [
    a[1] * b[2] - a[2] * b[1],
    a[2] * b[0] - a[0] * b[2],
    a[0] * b[1] - a[1] * b[0],
  ];
}

// TODO return a
function cartesianAddInPlace(a, b) {
  ((a[0] += b[0]), (a[1] += b[1]), (a[2] += b[2]));
}

function cartesianScale(vector, k) {
  return [vector[0] * k, vector[1] * k, vector[2] * k];
}

// TODO return d
function cartesianNormalizeInPlace(d) {
  var l = sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
  ((d[0] /= l), (d[1] /= l), (d[2] /= l));
}

function compose(a, b) {
  function compose(x, y) {
    return ((x = a(x, y)), b(x[0], x[1]));
  }

  if (a.invert && b.invert)
    compose.invert = function (x, y) {
      return ((x = b.invert(x, y)), x && a.invert(x[0], x[1]));
    };

  return compose;
}

function rotationIdentity(lambda, phi) {
  if (abs(lambda) > pi) lambda -= Math.round(lambda / tau) * tau;
  return [lambda, phi];
}

rotationIdentity.invert = rotationIdentity;

function rotateRadians(deltaLambda, deltaPhi, deltaGamma) {
  return (deltaLambda %= tau)
    ? deltaPhi || deltaGamma
      ? compose(
          rotationLambda(deltaLambda),
          rotationPhiGamma(deltaPhi, deltaGamma),
        )
      : rotationLambda(deltaLambda)
    : deltaPhi || deltaGamma
      ? rotationPhiGamma(deltaPhi, deltaGamma)
      : rotationIdentity;
}

function forwardRotationLambda(deltaLambda) {
  return function (lambda, phi) {
    lambda += deltaLambda;
    if (abs(lambda) > pi) lambda -= Math.round(lambda / tau) * tau;
    return [lambda, phi];
  };
}

function rotationLambda(deltaLambda) {
  var rotation = forwardRotationLambda(deltaLambda);
  rotation.invert = forwardRotationLambda(-deltaLambda);
  return rotation;
}

function rotationPhiGamma(deltaPhi, deltaGamma) {
  var cosDeltaPhi = cos(deltaPhi),
    sinDeltaPhi = sin(deltaPhi),
    cosDeltaGamma = cos(deltaGamma),
    sinDeltaGamma = sin(deltaGamma);

  function rotation(lambda, phi) {
    var cosPhi = cos(phi),
      x = cos(lambda) * cosPhi,
      y = sin(lambda) * cosPhi,
      z = sin(phi),
      k = z * cosDeltaPhi + x * sinDeltaPhi;
    return [
      atan2(
        y * cosDeltaGamma - k * sinDeltaGamma,
        x * cosDeltaPhi - z * sinDeltaPhi,
      ),
      asin(k * cosDeltaGamma + y * sinDeltaGamma),
    ];
  }

  rotation.invert = function (lambda, phi) {
    var cosPhi = cos(phi),
      x = cos(lambda) * cosPhi,
      y = sin(lambda) * cosPhi,
      z = sin(phi),
      k = z * cosDeltaGamma - y * sinDeltaGamma;
    return [
      atan2(
        y * cosDeltaGamma + z * sinDeltaGamma,
        x * cosDeltaPhi + k * sinDeltaPhi,
      ),
      asin(k * cosDeltaPhi - x * sinDeltaPhi),
    ];
  };

  return rotation;
}

// Generates a circle centered at [0°, 0°], with a given radius and precision.
function circleStream(stream, radius, delta, direction, t0, t1) {
  if (!delta) return;
  var cosRadius = cos(radius),
    sinRadius = sin(radius),
    step = direction * delta;
  if (t0 == null) {
    t0 = radius + direction * tau;
    t1 = radius - step / 2;
  } else {
    t0 = circleRadius(cosRadius, t0);
    t1 = circleRadius(cosRadius, t1);
    if (direction > 0 ? t0 < t1 : t0 > t1) t0 += direction * tau;
  }
  for (var point, t = t0; direction > 0 ? t > t1 : t < t1; t -= step) {
    point = spherical([cosRadius, -sinRadius * cos(t), -sinRadius * sin(t)]);
    stream.point(point[0], point[1]);
  }
}

// Returns the signed angle of a cartesian point relative to [cosRadius, 0, 0].
function circleRadius(cosRadius, point) {
  ((point = cartesian(point)), (point[0] -= cosRadius));
  cartesianNormalizeInPlace(point);
  var radius = acos(-point[1]);
  return ((-point[2] < 0 ? -radius : radius) + tau - epsilon) % tau;
}

function clipBuffer() {
  var lines = [],
    line;
  return {
    point: function (x, y, m) {
      line.push([x, y, m]);
    },
    lineStart: function () {
      lines.push((line = []));
    },
    lineEnd: noop$1,
    rejoin: function () {
      if (lines.length > 1) lines.push(lines.pop().concat(lines.shift()));
    },
    result: function () {
      var result = lines;
      lines = [];
      line = null;
      return result;
    },
  };
}

function pointEqual(a, b) {
  return abs(a[0] - b[0]) < epsilon && abs(a[1] - b[1]) < epsilon;
}

function Intersection(point, points, other, entry) {
  this.x = point;
  this.z = points;
  this.o = other; // another intersection
  this.e = entry; // is an entry?
  this.v = false; // visited
  this.n = this.p = null; // next & previous
}

// A generalized polygon clipping algorithm: given a polygon that has been cut
// into its visible line segments, and rejoins the segments by interpolating
// along the clip edge.
function clipRejoin(
  segments,
  compareIntersection,
  startInside,
  interpolate,
  stream,
) {
  var subject = [],
    clip = [],
    i,
    n;

  segments.forEach(function (segment) {
    if ((n = segment.length - 1) <= 0) return;
    var n,
      p0 = segment[0],
      p1 = segment[n],
      x;

    if (pointEqual(p0, p1)) {
      if (!p0[2] && !p1[2]) {
        stream.lineStart();
        for (i = 0; i < n; ++i) stream.point((p0 = segment[i])[0], p0[1]);
        stream.lineEnd();
        return;
      }
      // handle degenerate cases by moving the point
      p1[0] += 2 * epsilon;
    }

    subject.push((x = new Intersection(p0, segment, null, true)));
    clip.push((x.o = new Intersection(p0, null, x, false)));
    subject.push((x = new Intersection(p1, segment, null, false)));
    clip.push((x.o = new Intersection(p1, null, x, true)));
  });

  if (!subject.length) return;

  clip.sort(compareIntersection);
  link(subject);
  link(clip);

  for (i = 0, n = clip.length; i < n; ++i) {
    clip[i].e = startInside = !startInside;
  }

  var start = subject[0],
    points,
    point;

  while (1) {
    // Find first unvisited intersection.
    var current = start,
      isSubject = true;
    while (current.v) if ((current = current.n) === start) return;
    points = current.z;
    stream.lineStart();
    do {
      current.v = current.o.v = true;
      if (current.e) {
        if (isSubject) {
          for (i = 0, n = points.length; i < n; ++i)
            stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.n.x, 1, stream);
        }
        current = current.n;
      } else {
        if (isSubject) {
          points = current.p.z;
          for (i = points.length - 1; i >= 0; --i)
            stream.point((point = points[i])[0], point[1]);
        } else {
          interpolate(current.x, current.p.x, -1, stream);
        }
        current = current.p;
      }
      current = current.o;
      points = current.z;
      isSubject = !isSubject;
    } while (!current.v);
    stream.lineEnd();
  }
}

function link(array) {
  if (!(n = array.length)) return;
  var n,
    i = 0,
    a = array[0],
    b;
  while (++i < n) {
    a.n = b = array[i];
    b.p = a;
    a = b;
  }
  a.n = b = array[0];
  b.p = a;
}

function longitude(point) {
  return abs(point[0]) <= pi
    ? point[0]
    : sign(point[0]) * (((abs(point[0]) + pi) % tau) - pi);
}

function polygonContains(polygon, point) {
  var lambda = longitude(point),
    phi = point[1],
    sinPhi = sin(phi),
    normal = [sin(lambda), -cos(lambda), 0],
    angle = 0,
    winding = 0;

  var sum = new Adder();

  if (sinPhi === 1) phi = halfPi + epsilon;
  else if (sinPhi === -1) phi = -halfPi - epsilon;

  for (var i = 0, n = polygon.length; i < n; ++i) {
    if (!(m = (ring = polygon[i]).length)) continue;
    var ring,
      m,
      point0 = ring[m - 1],
      lambda0 = longitude(point0),
      phi0 = point0[1] / 2 + quarterPi,
      sinPhi0 = sin(phi0),
      cosPhi0 = cos(phi0);

    for (
      var j = 0;
      j < m;
      ++j,
        lambda0 = lambda1,
        sinPhi0 = sinPhi1,
        cosPhi0 = cosPhi1,
        point0 = point1
    ) {
      var point1 = ring[j],
        lambda1 = longitude(point1),
        phi1 = point1[1] / 2 + quarterPi,
        sinPhi1 = sin(phi1),
        cosPhi1 = cos(phi1),
        delta = lambda1 - lambda0,
        sign = delta >= 0 ? 1 : -1,
        absDelta = sign * delta,
        antimeridian = absDelta > pi,
        k = sinPhi0 * sinPhi1;

      sum.add(
        atan2(k * sign * sin(absDelta), cosPhi0 * cosPhi1 + k * cos(absDelta)),
      );
      angle += antimeridian ? delta + sign * tau : delta;

      // Are the longitudes either side of the point’s meridian (lambda),
      // and are the latitudes smaller than the parallel (phi)?
      if (antimeridian ^ (lambda0 >= lambda) ^ (lambda1 >= lambda)) {
        var arc = cartesianCross(cartesian(point0), cartesian(point1));
        cartesianNormalizeInPlace(arc);
        var intersection = cartesianCross(normal, arc);
        cartesianNormalizeInPlace(intersection);
        var phiArc =
          (antimeridian ^ (delta >= 0) ? -1 : 1) * asin(intersection[2]);
        if (phi > phiArc || (phi === phiArc && (arc[0] || arc[1]))) {
          winding += antimeridian ^ (delta >= 0) ? 1 : -1;
        }
      }
    }
  }

  // First, determine whether the South pole is inside or outside:
  //
  // It is inside if:
  // * the polygon winds around it in a clockwise direction.
  // * the polygon does not (cumulatively) wind around it, but has a negative
  //   (counter-clockwise) area.
  //
  // Second, count the (signed) number of times a segment crosses a lambda
  // from the point to the South pole.  If it is zero, then the point is the
  // same side as the South pole.

  return (
    (angle < -epsilon || (angle < epsilon && sum < -1e-12)) ^ (winding & 1)
  );
}

function clip(pointVisible, clipLine, interpolate, start) {
  return function (sink) {
    var line = clipLine(sink),
      ringBuffer = clipBuffer(),
      ringSink = clipLine(ringBuffer),
      polygonStarted = false,
      polygon,
      segments,
      ring;

    var clip = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        clip.point = pointRing;
        clip.lineStart = ringStart;
        clip.lineEnd = ringEnd;
        segments = [];
        polygon = [];
      },
      polygonEnd: function () {
        clip.point = point;
        clip.lineStart = lineStart;
        clip.lineEnd = lineEnd;
        segments = merge$1(segments);
        var startInside = polygonContains(polygon, start);
        if (segments.length) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          clipRejoin(
            segments,
            compareIntersection,
            startInside,
            interpolate,
            sink,
          );
        } else if (startInside) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          sink.lineStart();
          interpolate(null, null, 1, sink);
          sink.lineEnd();
        }
        if (polygonStarted) (sink.polygonEnd(), (polygonStarted = false));
        segments = polygon = null;
      },
      sphere: function () {
        sink.polygonStart();
        sink.lineStart();
        interpolate(null, null, 1, sink);
        sink.lineEnd();
        sink.polygonEnd();
      },
    };

    function point(lambda, phi) {
      if (pointVisible(lambda, phi)) sink.point(lambda, phi);
    }

    function pointLine(lambda, phi) {
      line.point(lambda, phi);
    }

    function lineStart() {
      clip.point = pointLine;
      line.lineStart();
    }

    function lineEnd() {
      clip.point = point;
      line.lineEnd();
    }

    function pointRing(lambda, phi) {
      ring.push([lambda, phi]);
      ringSink.point(lambda, phi);
    }

    function ringStart() {
      ringSink.lineStart();
      ring = [];
    }

    function ringEnd() {
      pointRing(ring[0][0], ring[0][1]);
      ringSink.lineEnd();

      var clean = ringSink.clean(),
        ringSegments = ringBuffer.result(),
        i,
        n = ringSegments.length,
        m,
        segment,
        point;

      ring.pop();
      polygon.push(ring);
      ring = null;

      if (!n) return;

      // No intersections.
      if (clean & 1) {
        segment = ringSegments[0];
        if ((m = segment.length - 1) > 0) {
          if (!polygonStarted) (sink.polygonStart(), (polygonStarted = true));
          sink.lineStart();
          for (i = 0; i < m; ++i) sink.point((point = segment[i])[0], point[1]);
          sink.lineEnd();
        }
        return;
      }

      // Rejoin connected segments.
      // TODO reuse ringBuffer.rejoin()?
      if (n > 1 && clean & 2)
        ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));

      segments.push(ringSegments.filter(validSegment));
    }

    return clip;
  };
}

function validSegment(segment) {
  return segment.length > 1;
}

// Intersections are sorted along the clip edge. For both antimeridian cutting
// and circle clipping, the same comparison is used.
function compareIntersection(a, b) {
  return (
    ((a = a.x)[0] < 0 ? a[1] - halfPi - epsilon : halfPi - a[1]) -
    ((b = b.x)[0] < 0 ? b[1] - halfPi - epsilon : halfPi - b[1])
  );
}

const clipAntimeridian = clip(
  function () {
    return true;
  },
  clipAntimeridianLine,
  clipAntimeridianInterpolate,
  [-pi, -halfPi],
);

// Takes a line and cuts into visible segments. Return values: 0 - there were
// intersections or the line was empty; 1 - no intersections; 2 - there were
// intersections, and the first and last segments should be rejoined.
function clipAntimeridianLine(stream) {
  var lambda0 = NaN,
    phi0 = NaN,
    sign0 = NaN,
    clean; // no intersections

  return {
    lineStart: function () {
      stream.lineStart();
      clean = 1;
    },
    point: function (lambda1, phi1) {
      var sign1 = lambda1 > 0 ? pi : -pi,
        delta = abs(lambda1 - lambda0);
      if (abs(delta - pi) < epsilon) {
        // line crosses a pole
        stream.point(
          lambda0,
          (phi0 = (phi0 + phi1) / 2 > 0 ? halfPi : -halfPi),
        );
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        stream.point(lambda1, phi0);
        clean = 0;
      } else if (sign0 !== sign1 && delta >= pi) {
        // line crosses antimeridian
        if (abs(lambda0 - sign0) < epsilon) lambda0 -= sign0 * epsilon; // handle degeneracies
        if (abs(lambda1 - sign1) < epsilon) lambda1 -= sign1 * epsilon;
        phi0 = clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1);
        stream.point(sign0, phi0);
        stream.lineEnd();
        stream.lineStart();
        stream.point(sign1, phi0);
        clean = 0;
      }
      stream.point((lambda0 = lambda1), (phi0 = phi1));
      sign0 = sign1;
    },
    lineEnd: function () {
      stream.lineEnd();
      lambda0 = phi0 = NaN;
    },
    clean: function () {
      return 2 - clean; // if intersections, rejoin first and last segments
    },
  };
}

function clipAntimeridianIntersect(lambda0, phi0, lambda1, phi1) {
  var cosPhi0,
    cosPhi1,
    sinLambda0Lambda1 = sin(lambda0 - lambda1);
  return abs(sinLambda0Lambda1) > epsilon
    ? atan(
        (sin(phi0) * (cosPhi1 = cos(phi1)) * sin(lambda1) -
          sin(phi1) * (cosPhi0 = cos(phi0)) * sin(lambda0)) /
          (cosPhi0 * cosPhi1 * sinLambda0Lambda1),
      )
    : (phi0 + phi1) / 2;
}

function clipAntimeridianInterpolate(from, to, direction, stream) {
  var phi;
  if (from == null) {
    phi = direction * halfPi;
    stream.point(-pi, phi);
    stream.point(0, phi);
    stream.point(pi, phi);
    stream.point(pi, 0);
    stream.point(pi, -phi);
    stream.point(0, -phi);
    stream.point(-pi, -phi);
    stream.point(-pi, 0);
    stream.point(-pi, phi);
  } else if (abs(from[0] - to[0]) > epsilon) {
    var lambda = from[0] < to[0] ? pi : -pi;
    phi = (direction * lambda) / 2;
    stream.point(-lambda, phi);
    stream.point(0, phi);
    stream.point(lambda, phi);
  } else {
    stream.point(to[0], to[1]);
  }
}

function clipCircle(radius) {
  var cr = cos(radius),
    delta = 2 * radians,
    smallRadius = cr > 0,
    notHemisphere = abs(cr) > epsilon; // TODO optimise for this common case

  function interpolate(from, to, direction, stream) {
    circleStream(stream, radius, delta, direction, from, to);
  }

  function visible(lambda, phi) {
    return cos(lambda) * cos(phi) > cr;
  }

  // Takes a line and cuts into visible segments. Return values used for polygon
  // clipping: 0 - there were intersections or the line was empty; 1 - no
  // intersections 2 - there were intersections, and the first and last segments
  // should be rejoined.
  function clipLine(stream) {
    var point0, // previous point
      c0, // code for previous point
      v0, // visibility of previous point
      v00, // visibility of first point
      clean; // no intersections
    return {
      lineStart: function () {
        v00 = v0 = false;
        clean = 1;
      },
      point: function (lambda, phi) {
        var point1 = [lambda, phi],
          point2,
          v = visible(lambda, phi),
          c = smallRadius
            ? v
              ? 0
              : code(lambda, phi)
            : v
              ? code(lambda + (lambda < 0 ? pi : -pi), phi)
              : 0;
        if (!point0 && (v00 = v0 = v)) stream.lineStart();
        if (v !== v0) {
          point2 = intersect(point0, point1);
          if (
            !point2 ||
            pointEqual(point0, point2) ||
            pointEqual(point1, point2)
          )
            point1[2] = 1;
        }
        if (v !== v0) {
          clean = 0;
          if (v) {
            // outside going in
            stream.lineStart();
            point2 = intersect(point1, point0);
            stream.point(point2[0], point2[1]);
          } else {
            // inside going out
            point2 = intersect(point0, point1);
            stream.point(point2[0], point2[1], 2);
            stream.lineEnd();
          }
          point0 = point2;
        } else if (notHemisphere && point0 && smallRadius ^ v) {
          var t;
          // If the codes for two points are different, or are both zero,
          // and there this segment intersects with the small circle.
          if (!(c & c0) && (t = intersect(point1, point0, true))) {
            clean = 0;
            if (smallRadius) {
              stream.lineStart();
              stream.point(t[0][0], t[0][1]);
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
            } else {
              stream.point(t[1][0], t[1][1]);
              stream.lineEnd();
              stream.lineStart();
              stream.point(t[0][0], t[0][1], 3);
            }
          }
        }
        if (v && (!point0 || !pointEqual(point0, point1))) {
          stream.point(point1[0], point1[1]);
        }
        ((point0 = point1), (v0 = v), (c0 = c));
      },
      lineEnd: function () {
        if (v0) stream.lineEnd();
        point0 = null;
      },
      // Rejoin first and last segments if there were intersections and the first
      // and last points were visible.
      clean: function () {
        return clean | ((v00 && v0) << 1);
      },
    };
  }

  // Intersects the great circle between a and b with the clip circle.
  function intersect(a, b, two) {
    var pa = cartesian(a),
      pb = cartesian(b);

    // We have two planes, n1.p = d1 and n2.p = d2.
    // Find intersection line p(t) = c1 n1 + c2 n2 + t (n1 ⨯ n2).
    var n1 = [1, 0, 0], // normal
      n2 = cartesianCross(pa, pb),
      n2n2 = cartesianDot(n2, n2),
      n1n2 = n2[0], // cartesianDot(n1, n2),
      determinant = n2n2 - n1n2 * n1n2;

    // Two polar points.
    if (!determinant) return !two && a;

    var c1 = (cr * n2n2) / determinant,
      c2 = (-cr * n1n2) / determinant,
      n1xn2 = cartesianCross(n1, n2),
      A = cartesianScale(n1, c1),
      B = cartesianScale(n2, c2);
    cartesianAddInPlace(A, B);

    // Solve |p(t)|^2 = 1.
    var u = n1xn2,
      w = cartesianDot(A, u),
      uu = cartesianDot(u, u),
      t2 = w * w - uu * (cartesianDot(A, A) - 1);

    if (t2 < 0) return;

    var t = sqrt(t2),
      q = cartesianScale(u, (-w - t) / uu);
    cartesianAddInPlace(q, A);
    q = spherical(q);

    if (!two) return q;

    // Two intersection points.
    var lambda0 = a[0],
      lambda1 = b[0],
      phi0 = a[1],
      phi1 = b[1],
      z;

    if (lambda1 < lambda0) ((z = lambda0), (lambda0 = lambda1), (lambda1 = z));

    var delta = lambda1 - lambda0,
      polar = abs(delta - pi) < epsilon,
      meridian = polar || delta < epsilon;

    if (!polar && phi1 < phi0) ((z = phi0), (phi0 = phi1), (phi1 = z));

    // Check that the first point is between a and b.
    if (
      meridian
        ? polar
          ? (phi0 + phi1 > 0) ^
            (q[1] < (abs(q[0] - lambda0) < epsilon ? phi0 : phi1))
          : phi0 <= q[1] && q[1] <= phi1
        : (delta > pi) ^ (lambda0 <= q[0] && q[0] <= lambda1)
    ) {
      var q1 = cartesianScale(u, (-w + t) / uu);
      cartesianAddInPlace(q1, A);
      return [q, spherical(q1)];
    }
  }

  // Generates a 4-bit vector representing the location of a point relative to
  // the small circle's bounding box.
  function code(lambda, phi) {
    var r = smallRadius ? radius : pi - radius,
      code = 0;
    if (lambda < -r)
      code |= 1; // left
    else if (lambda > r) code |= 2; // right
    if (phi < -r)
      code |= 4; // below
    else if (phi > r) code |= 8; // above
    return code;
  }

  return clip(
    visible,
    clipLine,
    interpolate,
    smallRadius ? [0, -radius] : [-pi, radius - pi],
  );
}

function clipLine(a, b, x0, y0, x1, y1) {
  var ax = a[0],
    ay = a[1],
    bx = b[0],
    by = b[1],
    t0 = 0,
    t1 = 1,
    dx = bx - ax,
    dy = by - ay,
    r;

  r = x0 - ax;
  if (!dx && r > 0) return;
  r /= dx;
  if (dx < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dx > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = x1 - ax;
  if (!dx && r < 0) return;
  r /= dx;
  if (dx < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dx > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  r = y0 - ay;
  if (!dy && r > 0) return;
  r /= dy;
  if (dy < 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  } else if (dy > 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  }

  r = y1 - ay;
  if (!dy && r < 0) return;
  r /= dy;
  if (dy < 0) {
    if (r > t1) return;
    if (r > t0) t0 = r;
  } else if (dy > 0) {
    if (r < t0) return;
    if (r < t1) t1 = r;
  }

  if (t0 > 0) ((a[0] = ax + t0 * dx), (a[1] = ay + t0 * dy));
  if (t1 < 1) ((b[0] = ax + t1 * dx), (b[1] = ay + t1 * dy));
  return true;
}

var clipMax = 1e9,
  clipMin = -clipMax;

// TODO Use d3-polygon’s polygonContains here for the ring check?
// TODO Eliminate duplicate buffering in clipBuffer and polygon.push?

function clipRectangle(x0, y0, x1, y1) {
  function visible(x, y) {
    return x0 <= x && x <= x1 && y0 <= y && y <= y1;
  }

  function interpolate(from, to, direction, stream) {
    var a = 0,
      a1 = 0;
    if (
      from == null ||
      (a = corner(from, direction)) !== (a1 = corner(to, direction)) ||
      (comparePoint(from, to) < 0) ^ (direction > 0)
    ) {
      do stream.point(a === 0 || a === 3 ? x0 : x1, a > 1 ? y1 : y0);
      while ((a = (a + direction + 4) % 4) !== a1);
    } else {
      stream.point(to[0], to[1]);
    }
  }

  function corner(p, direction) {
    return abs(p[0] - x0) < epsilon
      ? direction > 0
        ? 0
        : 3
      : abs(p[0] - x1) < epsilon
        ? direction > 0
          ? 2
          : 1
        : abs(p[1] - y0) < epsilon
          ? direction > 0
            ? 1
            : 0
          : direction > 0
            ? 3
            : 2; // abs(p[1] - y1) < epsilon
  }

  function compareIntersection(a, b) {
    return comparePoint(a.x, b.x);
  }

  function comparePoint(a, b) {
    var ca = corner(a, 1),
      cb = corner(b, 1);
    return ca !== cb
      ? ca - cb
      : ca === 0
        ? b[1] - a[1]
        : ca === 1
          ? a[0] - b[0]
          : ca === 2
            ? a[1] - b[1]
            : b[0] - a[0];
  }

  return function (stream) {
    var activeStream = stream,
      bufferStream = clipBuffer(),
      segments,
      polygon,
      ring,
      x__,
      y__,
      v__, // first point
      x_,
      y_,
      v_, // previous point
      first,
      clean;

    var clipStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: polygonStart,
      polygonEnd: polygonEnd,
    };

    function point(x, y) {
      if (visible(x, y)) activeStream.point(x, y);
    }

    function polygonInside() {
      var winding = 0;

      for (var i = 0, n = polygon.length; i < n; ++i) {
        for (
          var ring = polygon[i],
            j = 1,
            m = ring.length,
            point = ring[0],
            a0,
            a1,
            b0 = point[0],
            b1 = point[1];
          j < m;
          ++j
        ) {
          ((a0 = b0),
            (a1 = b1),
            (point = ring[j]),
            (b0 = point[0]),
            (b1 = point[1]));
          if (a1 <= y1) {
            if (b1 > y1 && (b0 - a0) * (y1 - a1) > (b1 - a1) * (x0 - a0))
              ++winding;
          } else {
            if (b1 <= y1 && (b0 - a0) * (y1 - a1) < (b1 - a1) * (x0 - a0))
              --winding;
          }
        }
      }

      return winding;
    }

    // Buffer geometry within a polygon and then clip it en masse.
    function polygonStart() {
      ((activeStream = bufferStream),
        (segments = []),
        (polygon = []),
        (clean = true));
    }

    function polygonEnd() {
      var startInside = polygonInside(),
        cleanInside = clean && startInside,
        visible = (segments = merge$1(segments)).length;
      if (cleanInside || visible) {
        stream.polygonStart();
        if (cleanInside) {
          stream.lineStart();
          interpolate(null, null, 1, stream);
          stream.lineEnd();
        }
        if (visible) {
          clipRejoin(
            segments,
            compareIntersection,
            startInside,
            interpolate,
            stream,
          );
        }
        stream.polygonEnd();
      }
      ((activeStream = stream), (segments = polygon = ring = null));
    }

    function lineStart() {
      clipStream.point = linePoint;
      if (polygon) polygon.push((ring = []));
      first = true;
      v_ = false;
      x_ = y_ = NaN;
    }

    // TODO rather than special-case polygons, simply handle them separately.
    // Ideally, coincident intersection points should be jittered to avoid
    // clipping issues.
    function lineEnd() {
      if (segments) {
        linePoint(x__, y__);
        if (v__ && v_) bufferStream.rejoin();
        segments.push(bufferStream.result());
      }
      clipStream.point = point;
      if (v_) activeStream.lineEnd();
    }

    function linePoint(x, y) {
      var v = visible(x, y);
      if (polygon) ring.push([x, y]);
      if (first) {
        ((x__ = x), (y__ = y), (v__ = v));
        first = false;
        if (v) {
          activeStream.lineStart();
          activeStream.point(x, y);
        }
      } else {
        if (v && v_) activeStream.point(x, y);
        else {
          var a = [
              (x_ = Math.max(clipMin, Math.min(clipMax, x_))),
              (y_ = Math.max(clipMin, Math.min(clipMax, y_))),
            ],
            b = [
              (x = Math.max(clipMin, Math.min(clipMax, x))),
              (y = Math.max(clipMin, Math.min(clipMax, y))),
            ];
          if (clipLine(a, b, x0, y0, x1, y1)) {
            if (!v_) {
              activeStream.lineStart();
              activeStream.point(a[0], a[1]);
            }
            activeStream.point(b[0], b[1]);
            if (!v) activeStream.lineEnd();
            clean = false;
          } else if (v) {
            activeStream.lineStart();
            activeStream.point(x, y);
            clean = false;
          }
        }
      }
      ((x_ = x), (y_ = y), (v_ = v));
    }

    return clipStream;
  };
}

const identity$1 = (x) => x;

var x0$1 = Infinity,
  y0$1 = x0$1,
  x1$1 = -x0$1,
  y1$1 = x1$1;

var boundsStream$1 = {
  point: boundsPoint$1,
  lineStart: noop$1,
  lineEnd: noop$1,
  polygonStart: noop$1,
  polygonEnd: noop$1,
  result: function () {
    var bounds = [
      [x0$1, y0$1],
      [x1$1, y1$1],
    ];
    x1$1 = y1$1 = -(y0$1 = x0$1 = Infinity);
    return bounds;
  },
};

function boundsPoint$1(x, y) {
  if (x < x0$1) x0$1 = x;
  if (x > x1$1) x1$1 = x;
  if (y < y0$1) y0$1 = y;
  if (y > y1$1) y1$1 = y;
}

function transformer(methods) {
  return function (stream) {
    var s = new TransformStream();
    for (var key in methods) s[key] = methods[key];
    s.stream = stream;
    return s;
  };
}

function TransformStream() {}

TransformStream.prototype = {
  constructor: TransformStream,
  point: function (x, y) {
    this.stream.point(x, y);
  },
  sphere: function () {
    this.stream.sphere();
  },
  lineStart: function () {
    this.stream.lineStart();
  },
  lineEnd: function () {
    this.stream.lineEnd();
  },
  polygonStart: function () {
    this.stream.polygonStart();
  },
  polygonEnd: function () {
    this.stream.polygonEnd();
  },
};

function fit(projection, fitBounds, object) {
  var clip = projection.clipExtent && projection.clipExtent();
  projection.scale(150).translate([0, 0]);
  if (clip != null) projection.clipExtent(null);
  geoStream(object, projection.stream(boundsStream$1));
  fitBounds(boundsStream$1.result());
  if (clip != null) projection.clipExtent(clip);
  return projection;
}

function fitExtent$1(projection, extent, object) {
  return fit(
    projection,
    function (b) {
      var w = extent[1][0] - extent[0][0],
        h = extent[1][1] - extent[0][1],
        k = Math.min(w / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])),
        x = +extent[0][0] + (w - k * (b[1][0] + b[0][0])) / 2,
        y = +extent[0][1] + (h - k * (b[1][1] + b[0][1])) / 2;
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

function fitSize$1(projection, size, object) {
  return fitExtent$1(projection, [[0, 0], size], object);
}

function fitWidth(projection, width, object) {
  return fit(
    projection,
    function (b) {
      var w = +width,
        k = w / (b[1][0] - b[0][0]),
        x = (w - k * (b[1][0] + b[0][0])) / 2,
        y = -k * b[0][1];
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

function fitHeight(projection, height, object) {
  return fit(
    projection,
    function (b) {
      var h = +height,
        k = h / (b[1][1] - b[0][1]),
        x = -k * b[0][0],
        y = (h - k * (b[1][1] + b[0][1])) / 2;
      projection.scale(150 * k).translate([x, y]);
    },
    object,
  );
}

var maxDepth = 16, // maximum depth of subdivision
  cosMinDistance = cos(30 * radians); // cos(minimum angular distance)

function resample(project, delta2) {
  return +delta2 ? resample$1(project, delta2) : resampleNone(project);
}

function resampleNone(project) {
  return transformer({
    point: function (x, y) {
      x = project(x, y);
      this.stream.point(x[0], x[1]);
    },
  });
}

function resample$1(project, delta2) {
  function resampleLineTo(
    x0,
    y0,
    lambda0,
    a0,
    b0,
    c0,
    x1,
    y1,
    lambda1,
    a1,
    b1,
    c1,
    depth,
    stream,
  ) {
    var dx = x1 - x0,
      dy = y1 - y0,
      d2 = dx * dx + dy * dy;
    if (d2 > 4 * delta2 && depth--) {
      var a = a0 + a1,
        b = b0 + b1,
        c = c0 + c1,
        m = sqrt(a * a + b * b + c * c),
        phi2 = asin((c /= m)),
        lambda2 =
          abs(abs(c) - 1) < epsilon || abs(lambda0 - lambda1) < epsilon
            ? (lambda0 + lambda1) / 2
            : atan2(b, a),
        p = project(lambda2, phi2),
        x2 = p[0],
        y2 = p[1],
        dx2 = x2 - x0,
        dy2 = y2 - y0,
        dz = dy * dx2 - dx * dy2;
      if (
        (dz * dz) / d2 > delta2 || // perpendicular projected distance
        abs((dx * dx2 + dy * dy2) / d2 - 0.5) > 0.3 || // midpoint close to an end
        a0 * a1 + b0 * b1 + c0 * c1 < cosMinDistance
      ) {
        // angular distance
        resampleLineTo(
          x0,
          y0,
          lambda0,
          a0,
          b0,
          c0,
          x2,
          y2,
          lambda2,
          (a /= m),
          (b /= m),
          c,
          depth,
          stream,
        );
        stream.point(x2, y2);
        resampleLineTo(
          x2,
          y2,
          lambda2,
          a,
          b,
          c,
          x1,
          y1,
          lambda1,
          a1,
          b1,
          c1,
          depth,
          stream,
        );
      }
    }
  }
  return function (stream) {
    var lambda00,
      x00,
      y00,
      a00,
      b00,
      c00, // first point
      lambda0,
      x0,
      y0,
      a0,
      b0,
      c0; // previous point

    var resampleStream = {
      point: point,
      lineStart: lineStart,
      lineEnd: lineEnd,
      polygonStart: function () {
        stream.polygonStart();
        resampleStream.lineStart = ringStart;
      },
      polygonEnd: function () {
        stream.polygonEnd();
        resampleStream.lineStart = lineStart;
      },
    };

    function point(x, y) {
      x = project(x, y);
      stream.point(x[0], x[1]);
    }

    function lineStart() {
      x0 = NaN;
      resampleStream.point = linePoint;
      stream.lineStart();
    }

    function linePoint(lambda, phi) {
      var c = cartesian([lambda, phi]),
        p = project(lambda, phi);
      resampleLineTo(
        x0,
        y0,
        lambda0,
        a0,
        b0,
        c0,
        (x0 = p[0]),
        (y0 = p[1]),
        (lambda0 = lambda),
        (a0 = c[0]),
        (b0 = c[1]),
        (c0 = c[2]),
        maxDepth,
        stream,
      );
      stream.point(x0, y0);
    }

    function lineEnd() {
      resampleStream.point = point;
      stream.lineEnd();
    }

    function ringStart() {
      lineStart();
      resampleStream.point = ringPoint;
      resampleStream.lineEnd = ringEnd;
    }

    function ringPoint(lambda, phi) {
      (linePoint((lambda00 = lambda), phi),
        (x00 = x0),
        (y00 = y0),
        (a00 = a0),
        (b00 = b0),
        (c00 = c0));
      resampleStream.point = linePoint;
    }

    function ringEnd() {
      resampleLineTo(
        x0,
        y0,
        lambda0,
        a0,
        b0,
        c0,
        x00,
        y00,
        lambda00,
        a00,
        b00,
        c00,
        maxDepth,
        stream,
      );
      resampleStream.lineEnd = lineEnd;
      lineEnd();
    }

    return resampleStream;
  };
}

var transformRadians = transformer({
  point: function (x, y) {
    this.stream.point(x * radians, y * radians);
  },
});

function transformRotate(rotate) {
  return transformer({
    point: function (x, y) {
      var r = rotate(x, y);
      return this.stream.point(r[0], r[1]);
    },
  });
}

function scaleTranslate(k, dx, dy, sx, sy) {
  function transform(x, y) {
    x *= sx;
    y *= sy;
    return [dx + k * x, dy - k * y];
  }
  transform.invert = function (x, y) {
    return [((x - dx) / k) * sx, ((dy - y) / k) * sy];
  };
  return transform;
}

function scaleTranslateRotate(k, dx, dy, sx, sy, alpha) {
  if (!alpha) return scaleTranslate(k, dx, dy, sx, sy);
  var cosAlpha = cos(alpha),
    sinAlpha = sin(alpha),
    a = cosAlpha * k,
    b = sinAlpha * k,
    ai = cosAlpha / k,
    bi = sinAlpha / k,
    ci = (sinAlpha * dy - cosAlpha * dx) / k,
    fi = (sinAlpha * dx + cosAlpha * dy) / k;
  function transform(x, y) {
    x *= sx;
    y *= sy;
    return [a * x - b * y + dx, dy - b * x - a * y];
  }
  transform.invert = function (x, y) {
    return [sx * (ai * x - bi * y + ci), sy * (fi - bi * x - ai * y)];
  };
  return transform;
}

function projection(project) {
  return projectionMutator(function () {
    return project;
  })();
}

function projectionMutator(projectAt) {
  var project,
    k = 150, // scale
    x = 480,
    y = 250, // translate
    lambda = 0,
    phi = 0, // center
    deltaLambda = 0,
    deltaPhi = 0,
    deltaGamma = 0,
    rotate, // pre-rotate
    alpha = 0, // post-rotate angle
    sx = 1, // reflectX
    sy = 1, // reflectX
    theta = null,
    preclip = clipAntimeridian, // pre-clip angle
    x0 = null,
    y0,
    x1,
    y1,
    postclip = identity$1, // post-clip extent
    delta2 = 0.5, // precision
    projectResample,
    projectTransform,
    projectRotateTransform,
    cache,
    cacheStream;

  function projection(point) {
    return projectRotateTransform(point[0] * radians, point[1] * radians);
  }

  function invert(point) {
    point = projectRotateTransform.invert(point[0], point[1]);
    return point && [point[0] * degrees, point[1] * degrees];
  }

  projection.stream = function (stream) {
    return cache && cacheStream === stream
      ? cache
      : (cache = transformRadians(
          transformRotate(rotate)(
            preclip(projectResample(postclip((cacheStream = stream)))),
          ),
        ));
  };

  projection.preclip = function (_) {
    return arguments.length
      ? ((preclip = _), (theta = undefined), reset())
      : preclip;
  };

  projection.postclip = function (_) {
    return arguments.length
      ? ((postclip = _), (x0 = y0 = x1 = y1 = null), reset())
      : postclip;
  };

  projection.clipAngle = function (_) {
    return arguments.length
      ? ((preclip = +_
          ? clipCircle((theta = _ * radians))
          : ((theta = null), clipAntimeridian)),
        reset())
      : theta * degrees;
  };

  projection.clipExtent = function (_) {
    return arguments.length
      ? ((postclip =
          _ == null
            ? ((x0 = y0 = x1 = y1 = null), identity$1)
            : clipRectangle(
                (x0 = +_[0][0]),
                (y0 = +_[0][1]),
                (x1 = +_[1][0]),
                (y1 = +_[1][1]),
              )),
        reset())
      : x0 == null
        ? null
        : [
            [x0, y0],
            [x1, y1],
          ];
  };

  projection.scale = function (_) {
    return arguments.length ? ((k = +_), recenter()) : k;
  };

  projection.translate = function (_) {
    return arguments.length ? ((x = +_[0]), (y = +_[1]), recenter()) : [x, y];
  };

  projection.center = function (_) {
    return arguments.length
      ? ((lambda = (_[0] % 360) * radians),
        (phi = (_[1] % 360) * radians),
        recenter())
      : [lambda * degrees, phi * degrees];
  };

  projection.rotate = function (_) {
    return arguments.length
      ? ((deltaLambda = (_[0] % 360) * radians),
        (deltaPhi = (_[1] % 360) * radians),
        (deltaGamma = _.length > 2 ? (_[2] % 360) * radians : 0),
        recenter())
      : [deltaLambda * degrees, deltaPhi * degrees, deltaGamma * degrees];
  };

  projection.angle = function (_) {
    return arguments.length
      ? ((alpha = (_ % 360) * radians), recenter())
      : alpha * degrees;
  };

  projection.reflectX = function (_) {
    return arguments.length ? ((sx = _ ? -1 : 1), recenter()) : sx < 0;
  };

  projection.reflectY = function (_) {
    return arguments.length ? ((sy = _ ? -1 : 1), recenter()) : sy < 0;
  };

  projection.precision = function (_) {
    return arguments.length
      ? ((projectResample = resample(projectTransform, (delta2 = _ * _))),
        reset())
      : sqrt(delta2);
  };

  projection.fitExtent = function (extent, object) {
    return fitExtent$1(projection, extent, object);
  };

  projection.fitSize = function (size, object) {
    return fitSize$1(projection, size, object);
  };

  projection.fitWidth = function (width, object) {
    return fitWidth(projection, width, object);
  };

  projection.fitHeight = function (height, object) {
    return fitHeight(projection, height, object);
  };

  function recenter() {
    var center = scaleTranslateRotate(k, 0, 0, sx, sy, alpha).apply(
        null,
        project(lambda, phi),
      ),
      transform = scaleTranslateRotate(
        k,
        x - center[0],
        y - center[1],
        sx,
        sy,
        alpha,
      );
    rotate = rotateRadians(deltaLambda, deltaPhi, deltaGamma);
    projectTransform = compose(project, transform);
    projectRotateTransform = compose(rotate, projectTransform);
    projectResample = resample(projectTransform, delta2);
    return reset();
  }

  function reset() {
    cache = cacheStream = null;
    return projection;
  }

  return function () {
    project = projectAt.apply(this, arguments);
    projection.invert = project.invert && invert;
    return recenter();
  };
}

function conicProjection(projectAt) {
  var phi0 = 0,
    phi1 = pi / 3,
    m = projectionMutator(projectAt),
    p = m(phi0, phi1);

  p.parallels = function (_) {
    return arguments.length
      ? m((phi0 = _[0] * radians), (phi1 = _[1] * radians))
      : [phi0 * degrees, phi1 * degrees];
  };

  return p;
}

function cylindricalEqualAreaRaw(phi0) {
  var cosPhi0 = cos(phi0);

  function forward(lambda, phi) {
    return [lambda * cosPhi0, sin(phi) / cosPhi0];
  }

  forward.invert = function (x, y) {
    return [x / cosPhi0, asin(y * cosPhi0)];
  };

  return forward;
}

function conicEqualAreaRaw(y0, y1) {
  var sy0 = sin(y0),
    n = (sy0 + sin(y1)) / 2;

  // Are the parallels symmetrical around the Equator?
  if (abs(n) < epsilon) return cylindricalEqualAreaRaw(y0);

  var c = 1 + sy0 * (2 * n - sy0),
    r0 = sqrt(c) / n;

  function project(x, y) {
    var r = sqrt(c - 2 * n * sin(y)) / n;
    return [r * sin((x *= n)), r0 - r * cos(x)];
  }

  project.invert = function (x, y) {
    var r0y = r0 - y,
      l = atan2(x, abs(r0y)) * sign(r0y);
    if (r0y * n < 0) l -= pi * sign(x) * sign(r0y);
    return [l / n, asin((c - (x * x + r0y * r0y) * n * n) / (2 * n))];
  };

  return project;
}

function conicEqualArea() {
  return conicProjection(conicEqualAreaRaw).scale(155.424).center([0, 33.6442]);
}

function albers() {
  return conicEqualArea()
    .parallels([29.5, 45.5])
    .scale(1070)
    .translate([480, 250])
    .rotate([96, 0])
    .center([-0.6, 38.7]);
}

function equirectangularRaw(lambda, phi) {
  return [lambda, phi];
}

equirectangularRaw.invert = equirectangularRaw;

function equirectangular() {
  return projection(equirectangularRaw).scale(152.63);
}

function noop() {}

var x0 = Infinity,
  y0 = x0,
  x1 = -x0,
  y1 = x1;

var boundsStream = {
  point: boundsPoint,
  lineStart: noop,
  lineEnd: noop,
  polygonStart: noop,
  polygonEnd: noop,
  result: function () {
    var bounds = [
      [x0, y0],
      [x1, y1],
    ];
    x1 = y1 = -(y0 = x0 = Infinity);
    return bounds;
  },
};

function boundsPoint(x, y) {
  if (x < x0) x0 = x;
  if (x > x1) x1 = x;
  if (y < y0) y0 = y;
  if (y > y1) y1 = y;
}

function fitExtent(projection, extent, object) {
  var w = extent[1][0] - extent[0][0],
    h = extent[1][1] - extent[0][1],
    clip = projection.clipExtent && projection.clipExtent();

  projection.scale(150).translate([0, 0]);

  if (clip != null) projection.clipExtent(null);

  geoStream(object, projection.stream(boundsStream));

  var b = boundsStream.result(),
    k = Math.min(w / (b[1][0] - b[0][0]), h / (b[1][1] - b[0][1])),
    x = +extent[0][0] + (w - k * (b[1][0] + b[0][0])) / 2,
    y = +extent[0][1] + (h - k * (b[1][1] + b[0][1])) / 2;

  if (clip != null) projection.clipExtent(clip);

  return projection.scale(k * 150).translate([x, y]);
}

function fitSize(projection, size, object) {
  return fitExtent(projection, [[0, 0], size], object);
}

// The projections must have mutually exclusive clip regions on the sphere,
// as this will avoid emitting interleaving lines and polygons.
function multiplex(streams) {
  var n = streams.length;
  return {
    point: function (x, y) {
      var i = -1;
      while (++i < n) streams[i].point(x, y);
    },
    sphere: function () {
      var i = -1;
      while (++i < n) streams[i].sphere();
    },
    lineStart: function () {
      var i = -1;
      while (++i < n) streams[i].lineStart();
    },
    lineEnd: function () {
      var i = -1;
      while (++i < n) streams[i].lineEnd();
    },
    polygonStart: function () {
      var i = -1;
      while (++i < n) streams[i].polygonStart();
    },
    polygonEnd: function () {
      var i = -1;
      while (++i < n) streams[i].polygonEnd();
    },
  };
}

// A composite projection for the United States, configured by default for
// 960×500. Also works quite well at 960×600 with scale 1285. The set of
// standard parallels for each region comes from USGS, which is published here:
// http://egsc.usgs.gov/isb/pubs/MapProjections/projections.html#albers
function geoAlbersUsaTerritories() {
  var cache,
    cacheStream,
    lower48 = albers(),
    lower48Point,
    alaska = conicEqualArea()
      .rotate([154, 0])
      .center([-2, 58.5])
      .parallels([55, 65]),
    alaskaPoint, // EPSG:3338
    hawaii = conicEqualArea()
      .rotate([157, 0])
      .center([-3, 19.9])
      .parallels([8, 18]),
    hawaiiPoint, // ESRI:102007
    puertoRico = conicEqualArea()
      .rotate([66, 0])
      .center([0, 18])
      .parallels([8, 18]),
    puertoRicoPoint, //Taken from https://bl.ocks.org/mbostock/5629120
    samoa = equirectangular().rotate([173, 14]),
    samoaPoint, // EPSG:4169
    guam = equirectangular().rotate([-145, -16.8]),
    guamPoint,
    point,
    pointStream = {
      point: function (x, y) {
        point = [x, y];
      },
    };

  /*
      var puertoRicoBbox = [[-68.3, 19], [-63.9, 17]];
      var samoaBbox = [[-171, -14], [-168, -14.8]];
      var guamBbox = [[144, 20.8], [146.5, 12.7]];
      */

  function albersUsa(coordinates) {
    var x = coordinates[0],
      y = coordinates[1];

    return (
      (point = null),
      (lower48Point.point(x, y), point) ||
        (alaskaPoint.point(x, y), point) ||
        (hawaiiPoint.point(x, y), point) ||
        (puertoRicoPoint.point(x, y), point) ||
        (samoaPoint.point(x, y), point) ||
        (guamPoint.point(x, y), point)
    );
  }

  albersUsa.invert = function (coordinates) {
    var k = lower48.scale(),
      t = lower48.translate(),
      x = (coordinates[0] - t[0]) / k,
      y = (coordinates[1] - t[1]) / k;
    /*
        //How are the return values calculated:
        console.info("******");
        var c0 = puertoRico(puertoRicoBbox[0]);
        var x0 = (c0[0] - t[0]) / k;
        var y0 = (c0[1] - t[1]) / k;

        console.info("p0 puertoRico", x0 + ' - ' + y0);

        var c1 = puertoRico(puertoRicoBbox[1]);
        var x1 = (c1[0] - t[0]) / k;
        var y1 = (c1[1] - t[1]) / k;

        console.info("p1 puertoRico", x1 + ' - ' + y1);

        c0 = samoa(samoaBbox[0]);
        x0 = (c0[0] - t[0]) / k;
        y0 = (c0[1] - t[1]) / k;

        console.info("p0 samoa", x0 + ' - ' + y0);

        c1 = samoa(samoaBbox[1]);
        x1 = (c1[0] - t[0]) / k;
        y1 = (c1[1] - t[1]) / k;

        console.info("p1 samoa", x1 + ' - ' + y1);

        c0 = guam(guamBbox[0]);
        x0 = (c0[0] - t[0]) / k;
        y0 = (c0[1] - t[1]) / k;

        console.info("p0 guam", x0 + ' - ' + y0);

        c1 = guam(guamBbox[1]);
        x1 = (c1[0] - t[0]) / k;
        y1 = (c1[1] - t[1]) / k;

        console.info("p1 guam", x1 + ' - ' + y1);
        */

    return (
      y >= 0.12 && y < 0.234 && x >= -0.425 && x < -0.214
        ? alaska
        : y >= 0.166 && y < 0.234 && x >= -0.214 && x < -0.115
          ? hawaii
          : y >= 0.2064 && y < 0.2413 && x >= 0.312 && x < 0.385
            ? puertoRico
            : y >= 0.09 && y < 0.1197 && x >= -0.4243 && x < -0.3232
              ? samoa
              : y >= -0.0518 && y < 0.0895 && x >= -0.4243 && x < -0.3824
                ? guam
                : lower48
    ).invert(coordinates);
  };

  albersUsa.stream = function (stream) {
    return cache && cacheStream === stream
      ? cache
      : (cache = multiplex([
          lower48.stream((cacheStream = stream)),
          alaska.stream(stream),
          hawaii.stream(stream),
          puertoRico.stream(stream),
          samoa.stream(stream),
          guam.stream(stream),
        ]));
  };

  albersUsa.precision = function (_) {
    if (!arguments.length) {
      return lower48.precision();
    }
    lower48.precision(_);
    alaska.precision(_);
    hawaii.precision(_);
    puertoRico.precision(_);
    samoa.precision(_);
    guam.precision(_);
    return reset();
  };

  albersUsa.scale = function (_) {
    if (!arguments.length) {
      return lower48.scale();
    }
    lower48.scale(_);
    alaska.scale(_ * 0.35);
    hawaii.scale(_);
    puertoRico.scale(_);
    samoa.scale(_ * 2);
    guam.scale(_);
    return albersUsa.translate(lower48.translate());
  };

  albersUsa.translate = function (_) {
    if (!arguments.length) {
      return lower48.translate();
    }
    var k = lower48.scale(),
      x = +_[0],
      y = +_[1];

    /*
    var c0 = puertoRico.translate([x + 0.350 * k, y + 0.224 * k])(puertoRicoBbox[0]);
    var x0 = (x - c0[0]) / k;
    var y0 = (y - c0[1]) / k;

    var c1 = puertoRico.translate([x + 0.350 * k, y + 0.224 * k])(puertoRicoBbox[1]);
    var x1 = (x - c1[0]) / k;
    var y1 = (y - c1[1]) / k;

    console.info('puertoRico: p0: ' + x0 + ', ' + y0 + ' , p1: ' + x1 + ' - ' + y1);
    console.info('.clipExtent([[x '+
     (x0<0?'+ ':'- ') + Math.abs(x0.toFixed(4))+
     ' * k + epsilon, y '+
     (y0<0?'+ ':'- ') + Math.abs(y0.toFixed(4))+
     ' * k + epsilon],[x '+
     (x1<0?'+ ':'- ') + Math.abs(x1.toFixed(4))+
     ' * k - epsilon, y '+
     (y1<0?'+ ':'- ') + Math.abs(y1.toFixed(4))+
     ' * k - epsilon]])');

      c0 = samoa.translate([x - 0.492 * k, y + 0.09 * k])(samoaBbox[0]);
      x0 = (x - c0[0]) / k;
      y0 = (y - c0[1]) / k;

      c1 = samoa.translate([x - 0.492 * k, y + 0.09 * k])(samoaBbox[1]);
      x1 = (x - c1[0]) / k;
      y1 = (y - c1[1]) / k;

     console.info('samoa: p0: ' + x0 + ', ' + y0 + ' , p1: ' + x1 + ' - ' + y1);
     console.info('.clipExtent([[x '+
      (x0<0?'+ ':'- ') + Math.abs(x0.toFixed(4))+
      ' * k + epsilon, y '+
      (y0<0?'+ ':'- ') + Math.abs(y0.toFixed(4))+
      ' * k + epsilon],[x '+
      (x1<0?'+ ':'- ') + Math.abs(x1.toFixed(4))+
      ' * k - epsilon, y '+
      (y1<0?'+ ':'- ') + Math.abs(y1.toFixed(4))+
      ' * k - epsilon]])');

      c0 = guam.translate([x - 0.408 * k, y + 0.018 * k])(guamBbox[0]);
      x0 = (x - c0[0]) / k;
      y0 = (y - c0[1]) / k;

      c1 = guam.translate([x - 0.408 * k, y + 0.018 * k])(guamBbox[1]);
      x1 = (x - c1[0]) / k;
      y1 = (y - c1[1]) / k;

     console.info('guam: p0: ' + x0 + ', ' + y0 + ' , p1: ' + x1 + ' - ' + y1);
     console.info('.clipExtent([[x '+
      (x0<0?'+ ':'- ') + Math.abs(x0.toFixed(4))+
      ' * k + epsilon, y '+
      (y0<0?'+ ':'- ') + Math.abs(y0.toFixed(4))+
      ' * k + epsilon],[x '+
      (x1<0?'+ ':'- ') + Math.abs(x1.toFixed(4))+
      ' * k - epsilon, y '+
      (y1<0?'+ ':'- ') + Math.abs(y1.toFixed(4))+
      ' * k - epsilon]])');
      */

    lower48Point = lower48
      .translate(_)
      .clipExtent([
        [x - 0.455 * k, y - 0.238 * k],
        [x + 0.455 * k, y + 0.238 * k],
      ])
      .stream(pointStream);

    alaskaPoint = alaska
      .translate([x - 0.307 * k, y + 0.201 * k])
      .clipExtent([
        [x - 0.425 * k + epsilon$1, y + 0.12 * k + epsilon$1],
        [x - 0.214 * k - epsilon$1, y + 0.233 * k - epsilon$1],
      ])
      .stream(pointStream);

    hawaiiPoint = hawaii
      .translate([x - 0.205 * k, y + 0.212 * k])
      .clipExtent([
        [x - 0.214 * k + epsilon$1, y + 0.166 * k + epsilon$1],
        [x - 0.115 * k - epsilon$1, y + 0.233 * k - epsilon$1],
      ])
      .stream(pointStream);

    puertoRicoPoint = puertoRico
      .translate([x + 0.35 * k, y + 0.224 * k])
      .clipExtent([
        [x + 0.312 * k + epsilon$1, y + 0.2064 * k + epsilon$1],
        [x + 0.385 * k - epsilon$1, y + 0.233 * k - epsilon$1],
      ])
      .stream(pointStream);

    samoaPoint = samoa
      .translate([x - 0.492 * k, y + 0.09 * k])
      .clipExtent([
        [x - 0.4243 * k + epsilon$1, y + 0.0903 * k + epsilon$1],
        [x - 0.3233 * k - epsilon$1, y + 0.1197 * k - epsilon$1],
      ])
      .stream(pointStream);

    guamPoint = guam
      .translate([x - 0.408 * k, y + 0.018 * k])
      .clipExtent([
        [x - 0.4244 * k + epsilon$1, y - 0.0519 * k + epsilon$1],
        [x - 0.3824 * k - epsilon$1, y + 0.0895 * k - epsilon$1],
      ])
      .stream(pointStream);

    return reset();
  };

  albersUsa.fitExtent = function (extent, object) {
    return fitExtent(albersUsa, extent, object);
  };

  albersUsa.fitSize = function (size, object) {
    return fitSize(albersUsa, size, object);
  };

  function reset() {
    cache = cacheStream = null;
    return albersUsa;
  }

  albersUsa.drawCompositionBorders = function (context) {
    /*
    console.info("CLIP EXTENT hawaii: ", hawaii.clipExtent());
    console.info("UL BBOX:", lower48.invert([hawaii.clipExtent()[0][0], hawaii.clipExtent()[0][1]]));
    console.info("UR BBOX:", lower48.invert([hawaii.clipExtent()[1][0], hawaii.clipExtent()[0][1]]));
    console.info("LD BBOX:", lower48.invert([hawaii.clipExtent()[1][0], hawaii.clipExtent()[1][1]]));
    console.info("LL BBOX:", lower48.invert([hawaii.clipExtent()[0][0], hawaii.clipExtent()[1][1]]));

    console.info("CLIP EXTENT alaska: ", alaska.clipExtent());
    console.info("UL BBOX:", lower48.invert([alaska.clipExtent()[0][0], alaska.clipExtent()[0][1]]));
    console.info("UR BBOX:", lower48.invert([alaska.clipExtent()[1][0], alaska.clipExtent()[0][1]]));
    console.info("LD BBOX:", lower48.invert([alaska.clipExtent()[1][0], alaska.clipExtent()[1][1]]));
    console.info("LL BBOX:", lower48.invert([alaska.clipExtent()[0][0], alaska.clipExtent()[1][1]]));

    console.info("CLIP EXTENT puertoRico: ", puertoRico.clipExtent());
    console.info("UL BBOX:", lower48.invert([puertoRico.clipExtent()[0][0], puertoRico.clipExtent()[0][1]]));
    console.info("UR BBOX:", lower48.invert([puertoRico.clipExtent()[1][0], puertoRico.clipExtent()[0][1]]));
    console.info("LD BBOX:", lower48.invert([puertoRico.clipExtent()[1][0], puertoRico.clipExtent()[1][1]]));
    console.info("LL BBOX:", lower48.invert([puertoRico.clipExtent()[0][0], puertoRico.clipExtent()[1][1]]));

    console.info("CLIP EXTENT samoa: ", samoa.clipExtent());
    console.info("UL BBOX:", lower48.invert([samoa.clipExtent()[0][0], samoa.clipExtent()[0][1]]));
    console.info("UR BBOX:", lower48.invert([samoa.clipExtent()[1][0], samoa.clipExtent()[0][1]]));
    console.info("LD BBOX:", lower48.invert([samoa.clipExtent()[1][0], samoa.clipExtent()[1][1]]));
    console.info("LL BBOX:", lower48.invert([samoa.clipExtent()[0][0], samoa.clipExtent()[1][1]]));


    console.info("CLIP EXTENT guam: ", guam.clipExtent());
    console.info("UL BBOX:", lower48.invert([guam.clipExtent()[0][0], guam.clipExtent()[0][1]]));
    console.info("UR BBOX:", lower48.invert([guam.clipExtent()[1][0], guam.clipExtent()[0][1]]));
    console.info("LD BBOX:", lower48.invert([guam.clipExtent()[1][0], guam.clipExtent()[1][1]]));
    console.info("LL BBOX:", lower48.invert([guam.clipExtent()[0][0], guam.clipExtent()[1][1]]));
    */

    var ulhawaii = lower48([-110.4641, 28.2805]);
    var urhawaii = lower48([-104.0597, 28.9528]);
    var ldhawaii = lower48([-103.7049, 25.1031]);
    var llhawaii = lower48([-109.8337, 24.4531]);

    var ulalaska = lower48([-124.4745, 28.1407]);
    var uralaska = lower48([-110.931, 30.8844]);
    var ldalaska = lower48([-109.8337, 24.4531]);
    var llalaska = lower48([-122.4628, 21.8562]);

    var ulpuertoRico = lower48([-76.8579, 25.1544]);
    var urpuertoRico = lower48([-72.429, 24.2097]);
    var ldpuertoRico = lower48([-72.8265, 22.7056]);
    var llpuertoRico = lower48([-77.1852, 23.6392]);

    var ulsamoa = lower48([-125.0093, 29.7791]);
    var ursamoa = lower48([-118.5193, 31.3262]);
    var ldsamoa = lower48([-118.064, 29.6912]);
    var llsamoa = lower48([-124.4369, 28.169]);

    var ulguam = lower48([-128.1314, 37.4582]);
    var urguam = lower48([-125.2132, 38.214]);
    var ldguam = lower48([-122.3616, 30.5115]);
    var llguam = lower48([-125.0315, 29.8211]);

    context.moveTo(ulhawaii[0], ulhawaii[1]);
    context.lineTo(urhawaii[0], urhawaii[1]);
    context.lineTo(ldhawaii[0], ldhawaii[1]);
    context.lineTo(ldhawaii[0], ldhawaii[1]);
    context.lineTo(llhawaii[0], llhawaii[1]);
    context.closePath();

    context.moveTo(ulalaska[0], ulalaska[1]);
    context.lineTo(uralaska[0], uralaska[1]);
    context.lineTo(ldalaska[0], ldalaska[1]);
    context.lineTo(ldalaska[0], ldalaska[1]);
    context.lineTo(llalaska[0], llalaska[1]);
    context.closePath();

    context.moveTo(ulpuertoRico[0], ulpuertoRico[1]);
    context.lineTo(urpuertoRico[0], urpuertoRico[1]);
    context.lineTo(ldpuertoRico[0], ldpuertoRico[1]);
    context.lineTo(ldpuertoRico[0], ldpuertoRico[1]);
    context.lineTo(llpuertoRico[0], llpuertoRico[1]);
    context.closePath();

    context.moveTo(ulsamoa[0], ulsamoa[1]);
    context.lineTo(ursamoa[0], ursamoa[1]);
    context.lineTo(ldsamoa[0], ldsamoa[1]);
    context.lineTo(ldsamoa[0], ldsamoa[1]);
    context.lineTo(llsamoa[0], llsamoa[1]);
    context.closePath();

    context.moveTo(ulguam[0], ulguam[1]);
    context.lineTo(urguam[0], urguam[1]);
    context.lineTo(ldguam[0], ldguam[1]);
    context.lineTo(ldguam[0], ldguam[1]);
    context.lineTo(llguam[0], llguam[1]);
    context.closePath();
  };
  albersUsa.getCompositionBorders = function () {
    var context = path();
    this.drawCompositionBorders(context);
    return context.toString();
  };

  return albersUsa.scale(1070);
}

function identity(x) {
  return x;
}

function transform(transform) {
  if (transform == null) return identity;
  var x0,
    y0,
    kx = transform.scale[0],
    ky = transform.scale[1],
    dx = transform.translate[0],
    dy = transform.translate[1];
  return function (input, i) {
    if (!i) x0 = y0 = 0;
    var j = 2,
      n = input.length,
      output = new Array(n);
    output[0] = (x0 += input[0]) * kx + dx;
    output[1] = (y0 += input[1]) * ky + dy;
    while (j < n) ((output[j] = input[j]), ++j);
    return output;
  };
}

function reverse(array, n) {
  var t,
    j = array.length,
    i = j - n;
  while (i < --j) ((t = array[i]), (array[i++] = array[j]), (array[j] = t));
}

function feature(topology, o) {
  if (typeof o === "string") o = topology.objects[o];
  return o.type === "GeometryCollection"
    ? {
        type: "FeatureCollection",
        features: o.geometries.map(function (o) {
          return feature$1(topology, o);
        }),
      }
    : feature$1(topology, o);
}

function feature$1(topology, o) {
  var id = o.id,
    bbox = o.bbox,
    properties = o.properties == null ? {} : o.properties,
    geometry = object(topology, o);
  return id == null && bbox == null
    ? { type: "Feature", properties: properties, geometry: geometry }
    : bbox == null
      ? { type: "Feature", id: id, properties: properties, geometry: geometry }
      : {
          type: "Feature",
          id: id,
          bbox: bbox,
          properties: properties,
          geometry: geometry,
        };
}

function object(topology, o) {
  var transformPoint = transform(topology.transform),
    arcs = topology.arcs;

  function arc(i, points) {
    if (points.length) points.pop();
    for (var a = arcs[i < 0 ? ~i : i], k = 0, n = a.length; k < n; ++k) {
      points.push(transformPoint(a[k], k));
    }
    if (i < 0) reverse(points, n);
  }

  function point(p) {
    return transformPoint(p);
  }

  function line(arcs) {
    var points = [];
    for (var i = 0, n = arcs.length; i < n; ++i) arc(arcs[i], points);
    if (points.length < 2) points.push(points[0]); // This should never happen per the specification.
    return points;
  }

  function ring(arcs) {
    var points = line(arcs);
    while (points.length < 4) points.push(points[0]); // This may happen if an arc has only two points.
    return points;
  }

  function polygon(arcs) {
    return arcs.map(ring);
  }

  function geometry(o) {
    var type = o.type,
      coordinates;
    switch (type) {
      case "GeometryCollection":
        return { type: type, geometries: o.geometries.map(geometry) };
      case "Point":
        coordinates = point(o.coordinates);
        break;
      case "MultiPoint":
        coordinates = o.coordinates.map(point);
        break;
      case "LineString":
        coordinates = line(o.arcs);
        break;
      case "MultiLineString":
        coordinates = o.arcs.map(line);
        break;
      case "Polygon":
        coordinates = polygon(o.arcs);
        break;
      case "MultiPolygon":
        coordinates = o.arcs.map(polygon);
        break;
      default:
        return null;
    }
    return { type: type, coordinates: coordinates };
  }

  return geometry(o);
}

function stitch(topology, arcs) {
  var stitchedArcs = {},
    fragmentByStart = {},
    fragmentByEnd = {},
    fragments = [],
    emptyIndex = -1;

  // Stitch empty arcs first, since they may be subsumed by other arcs.
  arcs.forEach(function (i, j) {
    var arc = topology.arcs[i < 0 ? ~i : i],
      t;
    if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
      ((t = arcs[++emptyIndex]), (arcs[emptyIndex] = i), (arcs[j] = t));
    }
  });

  arcs.forEach(function (i) {
    var e = ends(i),
      start = e[0],
      end = e[1],
      f,
      g;

    if ((f = fragmentByEnd[start])) {
      delete fragmentByEnd[f.end];
      f.push(i);
      f.end = end;
      if ((g = fragmentByStart[end])) {
        delete fragmentByStart[g.start];
        var fg = g === f ? f : f.concat(g);
        fragmentByStart[(fg.start = f.start)] = fragmentByEnd[
          (fg.end = g.end)
        ] = fg;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else if ((f = fragmentByStart[end])) {
      delete fragmentByStart[f.start];
      f.unshift(i);
      f.start = start;
      if ((g = fragmentByEnd[start])) {
        delete fragmentByEnd[g.end];
        var gf = g === f ? f : g.concat(f);
        fragmentByStart[(gf.start = g.start)] = fragmentByEnd[
          (gf.end = f.end)
        ] = gf;
      } else {
        fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
      }
    } else {
      f = [i];
      fragmentByStart[(f.start = start)] = fragmentByEnd[(f.end = end)] = f;
    }
  });

  function ends(i) {
    var arc = topology.arcs[i < 0 ? ~i : i],
      p0 = arc[0],
      p1;
    if (topology.transform)
      ((p1 = [0, 0]),
        arc.forEach(function (dp) {
          ((p1[0] += dp[0]), (p1[1] += dp[1]));
        }));
    else p1 = arc[arc.length - 1];
    return i < 0 ? [p1, p0] : [p0, p1];
  }

  function flush(fragmentByEnd, fragmentByStart) {
    for (var k in fragmentByEnd) {
      var f = fragmentByEnd[k];
      delete fragmentByStart[f.start];
      delete f.start;
      delete f.end;
      f.forEach(function (i) {
        stitchedArcs[i < 0 ? ~i : i] = 1;
      });
      fragments.push(f);
    }
  }

  flush(fragmentByEnd, fragmentByStart);
  flush(fragmentByStart, fragmentByEnd);
  arcs.forEach(function (i) {
    if (!stitchedArcs[i < 0 ? ~i : i]) fragments.push([i]);
  });

  return fragments;
}

function planarRingArea(ring) {
  var i = -1,
    n = ring.length,
    a,
    b = ring[n - 1],
    area = 0;
  while (++i < n) ((a = b), (b = ring[i]), (area += a[0] * b[1] - a[1] * b[0]));
  return Math.abs(area); // Note: doubled area!
}

function merge(topology) {
  return object(topology, mergeArcs.apply(this, arguments));
}

function mergeArcs(topology, objects) {
  var polygonsByArc = {},
    polygons = [],
    groups = [];

  objects.forEach(geometry);

  function geometry(o) {
    switch (o.type) {
      case "GeometryCollection":
        o.geometries.forEach(geometry);
        break;
      case "Polygon":
        extract(o.arcs);
        break;
      case "MultiPolygon":
        o.arcs.forEach(extract);
        break;
    }
  }

  function extract(polygon) {
    polygon.forEach(function (ring) {
      ring.forEach(function (arc) {
        (
          polygonsByArc[(arc = arc < 0 ? ~arc : arc)] ||
          (polygonsByArc[arc] = [])
        ).push(polygon);
      });
    });
    polygons.push(polygon);
  }

  function area(ring) {
    return planarRingArea(
      object(topology, { type: "Polygon", arcs: [ring] }).coordinates[0],
    );
  }

  polygons.forEach(function (polygon) {
    if (!polygon._) {
      var group = [],
        neighbors = [polygon];
      polygon._ = 1;
      groups.push(group);
      while ((polygon = neighbors.pop())) {
        group.push(polygon);
        polygon.forEach(function (ring) {
          ring.forEach(function (arc) {
            polygonsByArc[arc < 0 ? ~arc : arc].forEach(function (polygon) {
              if (!polygon._) {
                polygon._ = 1;
                neighbors.push(polygon);
              }
            });
          });
        });
      }
    }
  });

  polygons.forEach(function (polygon) {
    delete polygon._;
  });

  return {
    type: "MultiPolygon",
    arcs: groups
      .map(function (polygons) {
        var arcs = [],
          n;

        // Extract the exterior (unique) arcs.
        polygons.forEach(function (polygon) {
          polygon.forEach(function (ring) {
            ring.forEach(function (arc) {
              if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
                arcs.push(arc);
              }
            });
          });
        });

        // Stitch the arcs into one or more rings.
        arcs = stitch(topology, arcs);

        // If more than one ring is returned,
        // at most one of these rings can be the exterior;
        // choose the one with the greatest absolute area.
        if ((n = arcs.length) > 1) {
          for (var i = 1, k = area(arcs[0]), ki, t; i < n; ++i) {
            if ((ki = area(arcs[i])) > k) {
              ((t = arcs[0]), (arcs[0] = arcs[i]), (arcs[i] = t), (k = ki));
            }
          }
        }

        return arcs;
      })
      .filter(function (arcs) {
        return arcs.length > 0;
      }),
  };
}

enable_legacy_mode_flag();

const Coloris = (() => {
  /*!
   * Copyright (c) 2021-2024 Momo Bassit.
   * Licensed under the MIT License (MIT)
   * https://github.com/mdbassit/Coloris
   * Version: 0.25.0
   * NPM: https://github.com/melloware/coloris-npm
   */

  return ((window, document, Math, undefined$1) => {
    const ctx = document.createElement("canvas").getContext("2d");
    const currentColor = { r: 0, g: 0, b: 0, h: 0, s: 0, v: 0, a: 1 };
    let container,
      picker,
      colorArea,
      colorMarker,
      colorPreview,
      colorValue,
      clearButton,
      closeButton,
      hueSlider,
      hueMarker,
      alphaSlider,
      alphaMarker,
      currentEl,
      currentFormat,
      oldColor,
      keyboardNav,
      colorAreaDims = {};

    // Default settings
    const settings = {
      el: "[data-coloris]",
      parent: "body",
      theme: "default",
      themeMode: "light",
      rtl: false,
      wrap: true,
      margin: 2,
      format: "hex",
      formatToggle: false,
      swatches: [],
      swatchesOnly: false,
      alpha: true,
      forceAlpha: false,
      focusInput: true,
      selectInput: false,
      inline: false,
      defaultColor: "#000000",
      clearButton: false,
      clearLabel: "Clear",
      closeButton: false,
      closeLabel: "Close",
      onChange: () => undefined$1,
      a11y: {
        open: "Open color picker",
        close: "Close color picker",
        clear: "Clear the selected color",
        marker: "Saturation: {s}. Brightness: {v}.",
        hueSlider: "Hue slider",
        alphaSlider: "Opacity slider",
        input: "Color value field",
        format: "Color format",
        swatch: "Color swatch",
        instruction:
          "Saturation and brightness selector. Use up, down, left and right arrow keys to select.",
      },
    };

    // Virtual instances cache
    const instances = {};
    let currentInstanceId = "";
    let defaultInstance = {};
    let hasInstance = false;

    /**
     * Configure the color picker.
     * @param {object} options Configuration options.
     */
    function configure(options) {
      if (typeof options !== "object") {
        return;
      }

      for (const key in options) {
        switch (key) {
          case "el":
            bindFields(options.el);
            if (options.wrap !== false) {
              wrapFields(options.el);
            }
            break;
          case "parent":
            container =
              options.parent instanceof HTMLElement
                ? options.parent
                : document.querySelector(options.parent);
            if (container) {
              container.appendChild(picker);
              settings.parent = options.parent;

              // document.body is special
              if (container === document.body) {
                container = undefined$1;
              }
            }
            break;
          case "themeMode":
            settings.themeMode = options.themeMode;
            if (
              options.themeMode === "auto" &&
              window.matchMedia &&
              window.matchMedia("(prefers-color-scheme: dark)").matches
            ) {
              settings.themeMode = "dark";
            }
          // The lack of a break statement is intentional
          case "theme":
            if (options.theme) {
              settings.theme = options.theme;
            }

            // Set the theme and color scheme
            picker.className = `clr-picker clr-${settings.theme} clr-${settings.themeMode}`;

            // Update the color picker's position if inline mode is in use
            if (settings.inline) {
              updatePickerPosition();
            }
            break;
          case "rtl":
            settings.rtl = !!options.rtl;
            Array.from(document.getElementsByClassName("clr-field")).forEach(
              (field) => field.classList.toggle("clr-rtl", settings.rtl),
            );
            break;
          case "margin":
            options.margin *= 1;
            settings.margin = !isNaN(options.margin)
              ? options.margin
              : settings.margin;
            break;
          case "wrap":
            if (options.el && options.wrap) {
              wrapFields(options.el);
            }
            break;
          case "formatToggle":
            settings.formatToggle = !!options.formatToggle;
            getEl("clr-format").style.display = settings.formatToggle
              ? "block"
              : "none";
            if (settings.formatToggle) {
              settings.format = "auto";
            }
            break;
          case "swatches":
            if (Array.isArray(options.swatches)) {
              const swatchesContainer = getEl("clr-swatches");
              const swatches = document.createElement("div");

              // Clear current swatches
              swatchesContainer.textContent = "";

              // Build new swatches
              options.swatches.forEach((swatch, i) => {
                const button = document.createElement("button");

                button.setAttribute("type", `button`);
                button.setAttribute("id", `clr-swatch-${i}`);
                button.setAttribute(
                  "aria-labelledby",
                  `clr-swatch-label clr-swatch-${i}`,
                );
                button.style.color = swatch;
                button.textContent = swatch;

                swatches.appendChild(button);
              });

              // Append new swatches if any
              if (options.swatches.length) {
                swatchesContainer.appendChild(swatches);
              }

              settings.swatches = options.swatches.slice();
            }
            break;
          case "swatchesOnly":
            settings.swatchesOnly = !!options.swatchesOnly;
            picker.setAttribute("data-minimal", settings.swatchesOnly);
            break;
          case "alpha":
            settings.alpha = !!options.alpha;
            picker.setAttribute("data-alpha", settings.alpha);
            break;
          case "inline":
            settings.inline = !!options.inline;
            picker.setAttribute("data-inline", settings.inline);

            if (settings.inline) {
              const defaultColor =
                options.defaultColor || settings.defaultColor;

              currentFormat = getColorFormatFromStr(defaultColor);
              updatePickerPosition();
              setColorFromStr(defaultColor);
            }
            break;
          case "clearButton":
            // Backward compatibility
            if (typeof options.clearButton === "object") {
              if (options.clearButton.label) {
                settings.clearLabel = options.clearButton.label;
                clearButton.innerHTML = settings.clearLabel;
              }

              options.clearButton = options.clearButton.show;
            }

            settings.clearButton = !!options.clearButton;
            clearButton.style.display = settings.clearButton ? "block" : "none";
            break;
          case "clearLabel":
            settings.clearLabel = options.clearLabel;
            clearButton.innerHTML = settings.clearLabel;
            break;
          case "closeButton":
            settings.closeButton = !!options.closeButton;

            if (settings.closeButton) {
              picker.insertBefore(closeButton, colorPreview);
            } else {
              colorPreview.appendChild(closeButton);
            }

            break;
          case "closeLabel":
            settings.closeLabel = options.closeLabel;
            closeButton.innerHTML = settings.closeLabel;
            break;
          case "a11y":
            const labels = options.a11y;
            let update = false;

            if (typeof labels === "object") {
              for (const label in labels) {
                if (labels[label] && settings.a11y[label]) {
                  settings.a11y[label] = labels[label];
                  update = true;
                }
              }
            }

            if (update) {
              const openLabel = getEl("clr-open-label");
              const swatchLabel = getEl("clr-swatch-label");

              openLabel.innerHTML = settings.a11y.open;
              swatchLabel.innerHTML = settings.a11y.swatch;
              closeButton.setAttribute("aria-label", settings.a11y.close);
              clearButton.setAttribute("aria-label", settings.a11y.clear);
              hueSlider.setAttribute("aria-label", settings.a11y.hueSlider);
              alphaSlider.setAttribute("aria-label", settings.a11y.alphaSlider);
              colorValue.setAttribute("aria-label", settings.a11y.input);
              colorArea.setAttribute("aria-label", settings.a11y.instruction);
            }
            break;
          default:
            settings[key] = options[key];
        }
      }
    }

    /**
     * Add or update a virtual instance.
     * @param {String} selector The CSS selector of the elements to which the instance is attached.
     * @param {Object} options Per-instance options to apply.
     */
    function setVirtualInstance(selector, options) {
      if (typeof selector === "string" && typeof options === "object") {
        instances[selector] = options;
        hasInstance = true;
      }
    }

    /**
     * Remove a virtual instance.
     * @param {String} selector The CSS selector of the elements to which the instance is attached.
     */
    function removeVirtualInstance(selector) {
      delete instances[selector];

      if (Object.keys(instances).length === 0) {
        hasInstance = false;

        if (selector === currentInstanceId) {
          resetVirtualInstance();
        }
      }
    }

    /**
     * Attach a virtual instance to an element if it matches a selector.
     * @param {Object} element Target element that will receive a virtual instance if applicable.
     */
    function attachVirtualInstance(element) {
      if (hasInstance) {
        // These options can only be set globally, not per instance
        const unsupportedOptions = [
          "el",
          "wrap",
          "rtl",
          "inline",
          "defaultColor",
          "a11y",
        ];

        for (let selector in instances) {
          const options = instances[selector];

          // If the element matches an instance's CSS selector
          if (element.matches(selector)) {
            currentInstanceId = selector;
            defaultInstance = {};

            // Delete unsupported options
            unsupportedOptions.forEach((option) => delete options[option]);

            // Back up the default options so we can restore them later
            for (let option in options) {
              defaultInstance[option] = Array.isArray(settings[option])
                ? settings[option].slice()
                : settings[option];
            }

            // Set the instance's options
            configure(options);
            break;
          }
        }
      }
    }

    /**
     * Revert any per-instance options that were previously applied.
     */
    function resetVirtualInstance() {
      if (Object.keys(defaultInstance).length > 0) {
        configure(defaultInstance);
        currentInstanceId = "";
        defaultInstance = {};
      }
    }

    /**
     * Bind the color picker to input fields that match the selector.
     * @param {(string|HTMLElement|HTMLElement[])} selector A CSS selector string, a DOM element or a list of DOM elements.
     */
    function bindFields(selector) {
      if (selector instanceof HTMLElement) {
        selector = [selector];
      }

      if (Array.isArray(selector)) {
        selector.forEach((field) => {
          addListener(field, "click", openPicker);
          addListener(field, "input", updateColorPreview);
        });
      } else {
        addListener(document, "click", selector, openPicker);
        addListener(document, "input", selector, updateColorPreview);
      }
    }

    /**
     * Open the color picker.
     * @param {object} event The event that opens the color picker.
     */
    function openPicker(event) {
      // Skip if inline mode is in use
      if (settings.inline) {
        return;
      }

      // Apply any per-instance options first
      attachVirtualInstance(event.target);

      currentEl = event.target;
      oldColor = currentEl.value;
      currentFormat = getColorFormatFromStr(oldColor);
      picker.classList.add("clr-open");

      updatePickerPosition();
      setColorFromStr(oldColor);

      if (settings.focusInput || settings.selectInput) {
        colorValue.focus({ preventScroll: true });
        colorValue.setSelectionRange(
          currentEl.selectionStart,
          currentEl.selectionEnd,
        );
      }

      if (settings.selectInput) {
        colorValue.select();
      }

      // Always focus the first element when using keyboard navigation
      if (keyboardNav || settings.swatchesOnly) {
        getFocusableElements().shift().focus();
      }

      // Trigger an "open" event
      currentEl.dispatchEvent(new Event("open", { bubbles: false }));
    }

    /**
     * Update the color picker's position and the color gradient's offset
     */
    function updatePickerPosition() {
      if (!picker || (!currentEl && !settings.inline)) return; //** DO NOT REMOVE: in case called before initialized
      const parent = container;
      const scrollY = window.scrollY;
      const pickerWidth = picker.offsetWidth;
      const pickerHeight = picker.offsetHeight;
      const reposition = { left: false, top: false };
      let parentStyle, parentMarginTop, parentBorderTop;
      let offset = { x: 0, y: 0 };

      if (parent) {
        parentStyle = window.getComputedStyle(parent);
        parentMarginTop = parseFloat(parentStyle.marginTop);
        parentBorderTop = parseFloat(parentStyle.borderTopWidth);

        offset = parent.getBoundingClientRect();
        offset.y += parentBorderTop + scrollY;
      }

      if (!settings.inline) {
        const coords = currentEl.getBoundingClientRect();
        let left = coords.x;
        let top = scrollY + coords.y + coords.height + settings.margin;

        // If the color picker is inside a custom container
        // set the position relative to it
        if (parent) {
          left -= offset.x;
          top -= offset.y;

          if (left + pickerWidth > parent.clientWidth) {
            left += coords.width - pickerWidth;
            reposition.left = true;
          }

          if (top + pickerHeight > parent.clientHeight - parentMarginTop) {
            if (
              pickerHeight + settings.margin <=
              coords.top - (offset.y - scrollY)
            ) {
              top -= coords.height + pickerHeight + settings.margin * 2;
              reposition.top = true;
            }
          }

          top += parent.scrollTop;

          // Otherwise set the position relative to the whole document
        } else {
          if (left + pickerWidth > document.documentElement.clientWidth) {
            left += coords.width - pickerWidth;
            reposition.left = true;
          }

          if (
            top + pickerHeight - scrollY >
            document.documentElement.clientHeight
          ) {
            if (pickerHeight + settings.margin <= coords.top) {
              top = scrollY + coords.y - pickerHeight - settings.margin;
              reposition.top = true;
            }
          }
        }

        picker.classList.toggle("clr-left", reposition.left);
        picker.classList.toggle("clr-top", reposition.top);
        picker.style.left = `${left}px`;
        picker.style.top = `${top}px`;
        offset.x += picker.offsetLeft;
        offset.y += picker.offsetTop;
      }

      colorAreaDims = {
        width: colorArea.offsetWidth,
        height: colorArea.offsetHeight,
        x: colorArea.offsetLeft + offset.x,
        y: colorArea.offsetTop + offset.y,
      };
    }

    /**
     * Wrap the linked input fields in a div that adds a color preview.
     * @param {(string|HTMLElement|HTMLElement[])} selector A CSS selector string, a DOM element or a list of DOM elements.
     */
    function wrapFields(selector) {
      if (selector instanceof HTMLElement) {
        wrapColorField(selector);
      } else if (Array.isArray(selector)) {
        selector.forEach(wrapColorField);
      } else {
        document.querySelectorAll(selector).forEach(wrapColorField);
      }
    }

    /**
     * Wrap an input field in a div that adds a color preview.
     * @param {object} field The input field.
     */
    function wrapColorField(field) {
      const parentNode = field.parentNode;

      if (!parentNode.classList.contains("clr-field")) {
        const wrapper = document.createElement("div");
        let classes = "clr-field";

        if (settings.rtl || field.classList.contains("clr-rtl")) {
          classes += " clr-rtl";
        }

        wrapper.innerHTML =
          '<button type="button" aria-labelledby="clr-open-label"></button>';
        parentNode.insertBefore(wrapper, field);
        wrapper.className = classes;
        wrapper.style.color = field.value;
        wrapper.appendChild(field);
      }
    }

    /**
     * Update the color preview of an input field
     * @param {object} event The "input" event that triggers the color change.
     */
    function updateColorPreview(event) {
      const parent = event.target.parentNode;

      // Only update the preview if the field has been previously wrapped
      if (parent.classList.contains("clr-field")) {
        parent.style.color = event.target.value;
      }
    }

    /**
     * Close the color picker.
     * @param {boolean} [revert] If true, revert the color to the original value.
     */
    function closePicker(revert) {
      if (currentEl && !settings.inline) {
        const prevEl = currentEl;

        // Revert the color to the original value if needed
        if (revert) {
          // This will prevent the "change" event on the colorValue input to execute its handler
          currentEl = undefined$1;

          if (oldColor !== prevEl.value) {
            prevEl.value = oldColor;

            // Trigger an "input" event to force update the thumbnail next to the input field
            prevEl.dispatchEvent(new Event("input", { bubbles: true }));
          }
        }

        // Trigger a "change" event if needed
        setTimeout(() => {
          // Add this to the end of the event loop
          if (oldColor !== prevEl.value) {
            prevEl.dispatchEvent(new Event("change", { bubbles: true }));
          }
        });

        // Hide the picker dialog
        picker.classList.remove("clr-open");

        // Reset any previously set per-instance options
        if (hasInstance) {
          resetVirtualInstance();
        }

        // Trigger a "close" event
        prevEl.dispatchEvent(new Event("close", { bubbles: false }));

        if (settings.focusInput) {
          prevEl.focus({ preventScroll: true });
        }

        // This essentially marks the picker as closed
        currentEl = undefined$1;
      }
    }

    /**
     * Set the active color from a string.
     * @param {string} str String representing a color.
     */
    function setColorFromStr(str) {
      const rgba = strToRGBA(str);
      const hsva = RGBAtoHSVA(rgba);

      updateMarkerA11yLabel(hsva.s, hsva.v);
      updateColor(rgba, hsva);

      // Update the UI
      hueSlider.value = hsva.h;
      picker.style.color = `hsl(${hsva.h}, 100%, 50%)`;
      hueMarker.style.left = `${(hsva.h / 360) * 100}%`;

      colorMarker.style.left = `${(colorAreaDims.width * hsva.s) / 100}px`;
      colorMarker.style.top = `${colorAreaDims.height - (colorAreaDims.height * hsva.v) / 100}px`;

      alphaSlider.value = hsva.a * 100;
      alphaMarker.style.left = `${hsva.a * 100}%`;
    }

    /**
     * Guess the color format from a string.
     * @param {string} str String representing a color.
     * @return {string} The color format.
     */
    function getColorFormatFromStr(str) {
      const format = str.substring(0, 3).toLowerCase();

      if (format === "rgb" || format === "hsl") {
        return format;
      }

      return "hex";
    }

    /**
     * Copy the active color to the linked input field.
     * @param {number} [color] Color value to override the active color.
     */
    function pickColor(color) {
      color = color !== undefined$1 ? color : colorValue.value;

      if (currentEl) {
        currentEl.value = color;
        currentEl.dispatchEvent(new Event("input", { bubbles: true }));
      }

      if (settings.onChange) {
        settings.onChange.call(window, color, currentEl);
      }

      document.dispatchEvent(
        new CustomEvent("coloris:pick", { detail: { color, currentEl } }),
      );
    }

    /**
     * Set the active color based on a specific point in the color gradient.
     * @param {number} x Left position.
     * @param {number} y Top position.
     */
    function setColorAtPosition(x, y) {
      const hsva = {
        h: hueSlider.value * 1,
        s: (x / colorAreaDims.width) * 100,
        v: 100 - (y / colorAreaDims.height) * 100,
        a: alphaSlider.value / 100,
      };
      const rgba = HSVAtoRGBA(hsva);

      updateMarkerA11yLabel(hsva.s, hsva.v);
      updateColor(rgba, hsva);
      pickColor();
    }

    /**
     * Update the color marker's accessibility label.
     * @param {number} saturation
     * @param {number} value
     */
    function updateMarkerA11yLabel(saturation, value) {
      let label = settings.a11y.marker;

      saturation = saturation.toFixed(1) * 1;
      value = value.toFixed(1) * 1;
      label = label.replace("{s}", saturation);
      label = label.replace("{v}", value);
      colorMarker.setAttribute("aria-label", label);
    }

    //
    /**
     * Get the pageX and pageY positions of the pointer.
     * @param {object} event The MouseEvent or TouchEvent object.
     * @return {object} The pageX and pageY positions.
     */
    function getPointerPosition(event) {
      return {
        pageX: event.changedTouches
          ? event.changedTouches[0].pageX
          : event.pageX,
        pageY: event.changedTouches
          ? event.changedTouches[0].pageY
          : event.pageY,
      };
    }

    /**
     * Move the color marker when dragged.
     * @param {object} event The MouseEvent object.
     */
    function moveMarker(event) {
      const pointer = getPointerPosition(event);
      let x = pointer.pageX - colorAreaDims.x;
      let y = pointer.pageY - colorAreaDims.y;

      if (container) {
        y += container.scrollTop;
      }

      setMarkerPosition(x, y);

      // Prevent scrolling while dragging the marker
      event.preventDefault();
      event.stopPropagation();
    }

    /**
     * Move the color marker when the arrow keys are pressed.
     * @param {number} offsetX The horizontal amount to move.
     * @param {number} offsetY The vertical amount to move.
     */
    function moveMarkerOnKeydown(offsetX, offsetY) {
      let x = colorMarker.style.left.replace("px", "") * 1 + offsetX;
      let y = colorMarker.style.top.replace("px", "") * 1 + offsetY;

      setMarkerPosition(x, y);
    }

    /**
     * Set the color marker's position.
     * @param {number} x Left position.
     * @param {number} y Top position.
     */
    function setMarkerPosition(x, y) {
      // Make sure the marker doesn't go out of bounds
      x = x < 0 ? 0 : x > colorAreaDims.width ? colorAreaDims.width : x;
      y = y < 0 ? 0 : y > colorAreaDims.height ? colorAreaDims.height : y;

      // Set the position
      colorMarker.style.left = `${x}px`;
      colorMarker.style.top = `${y}px`;

      // Update the color
      setColorAtPosition(x, y);

      // Make sure the marker is focused
      colorMarker.focus();
    }

    /**
     * Update the color picker's input field and preview thumb.
     * @param {Object} rgba Red, green, blue and alpha values.
     * @param {Object} [hsva] Hue, saturation, value and alpha values.
     */
    function updateColor(rgba, hsva) {
      if (rgba === void 0) {
        rgba = {};
      }
      if (hsva === void 0) {
        hsva = {};
      }
      let format = settings.format;

      for (const key in rgba) {
        currentColor[key] = rgba[key];
      }

      for (const key in hsva) {
        currentColor[key] = hsva[key];
      }

      const hex = RGBAToHex(currentColor);
      const opaqueHex = hex.substring(0, 7);

      colorMarker.style.color = opaqueHex;
      alphaMarker.parentNode.style.color = opaqueHex;
      alphaMarker.style.color = hex;
      colorPreview.style.color = hex;

      // Force repaint the color and alpha gradients as a workaround for a Google Chrome bug
      colorArea.style.display = "none";
      colorArea.offsetHeight;
      colorArea.style.display = "";
      alphaMarker.nextElementSibling.style.display = "none";
      alphaMarker.nextElementSibling.offsetHeight;
      alphaMarker.nextElementSibling.style.display = "";

      if (format === "mixed") {
        format = currentColor.a === 1 ? "hex" : "rgb";
      } else if (format === "auto") {
        format = currentFormat;
      }

      switch (format) {
        case "hex":
          colorValue.value = hex;
          break;
        case "rgb":
          colorValue.value = RGBAToStr(currentColor);
          break;
        case "hsl":
          colorValue.value = HSLAToStr(HSVAtoHSLA(currentColor));
          break;
      }

      // Select the current format in the format switcher
      document.querySelector(`.clr-format [value="${format}"]`).checked = true;
    }

    /**
     * Set the hue when its slider is moved.
     */
    function setHue() {
      const hue = hueSlider.value * 1;
      const x = colorMarker.style.left.replace("px", "") * 1;
      const y = colorMarker.style.top.replace("px", "") * 1;

      picker.style.color = `hsl(${hue}, 100%, 50%)`;
      hueMarker.style.left = `${(hue / 360) * 100}%`;

      setColorAtPosition(x, y);
    }

    /**
     * Set the alpha when its slider is moved.
     */
    function setAlpha() {
      const alpha = alphaSlider.value / 100;

      alphaMarker.style.left = `${alpha * 100}%`;
      updateColor({ a: alpha });
      pickColor();
    }

    /**
     * Convert HSVA to RGBA.
     * @param {object} hsva Hue, saturation, value and alpha values.
     * @return {object} Red, green, blue and alpha values.
     */
    function HSVAtoRGBA(hsva) {
      const saturation = hsva.s / 100;
      const value = hsva.v / 100;
      let chroma = saturation * value;
      let hueBy60 = hsva.h / 60;
      let x = chroma * (1 - Math.abs((hueBy60 % 2) - 1));
      let m = value - chroma;

      chroma = chroma + m;
      x = x + m;

      const index = Math.floor(hueBy60) % 6;
      const red = [chroma, x, m, m, x, chroma][index];
      const green = [x, chroma, chroma, x, m, m][index];
      const blue = [m, m, x, chroma, chroma, x][index];

      return {
        r: Math.round(red * 255),
        g: Math.round(green * 255),
        b: Math.round(blue * 255),
        a: hsva.a,
      };
    }

    /**
     * Convert HSVA to HSLA.
     * @param {object} hsva Hue, saturation, value and alpha values.
     * @return {object} Hue, saturation, lightness and alpha values.
     */
    function HSVAtoHSLA(hsva) {
      const value = hsva.v / 100;
      const lightness = value * (1 - hsva.s / 100 / 2);
      let saturation;

      if (lightness > 0 && lightness < 1) {
        saturation = Math.round(
          ((value - lightness) / Math.min(lightness, 1 - lightness)) * 100,
        );
      }

      return {
        h: hsva.h,
        s: saturation || 0,
        l: Math.round(lightness * 100),
        a: hsva.a,
      };
    }

    /**
     * Convert RGBA to HSVA.
     * @param {object} rgba Red, green, blue and alpha values.
     * @return {object} Hue, saturation, value and alpha values.
     */
    function RGBAtoHSVA(rgba) {
      const red = rgba.r / 255;
      const green = rgba.g / 255;
      const blue = rgba.b / 255;
      const xmax = Math.max(red, green, blue);
      const xmin = Math.min(red, green, blue);
      const chroma = xmax - xmin;
      const value = xmax;
      let hue = 0;
      let saturation = 0;

      if (chroma) {
        if (xmax === red) {
          hue = (green - blue) / chroma;
        }
        if (xmax === green) {
          hue = 2 + (blue - red) / chroma;
        }
        if (xmax === blue) {
          hue = 4 + (red - green) / chroma;
        }
        if (xmax) {
          saturation = chroma / xmax;
        }
      }

      hue = Math.floor(hue * 60);

      return {
        h: hue < 0 ? hue + 360 : hue,
        s: Math.round(saturation * 100),
        v: Math.round(value * 100),
        a: rgba.a,
      };
    }

    /**
     * Parse a string to RGBA.
     * @param {string} str String representing a color.
     * @return {object} Red, green, blue and alpha values.
     */
    function strToRGBA(str) {
      const regex =
        /^((rgba)|rgb)[\D]+([\d.]+)[\D]+([\d.]+)[\D]+([\d.]+)[\D]*?([\d.]+|$)/i;
      let match, rgba;

      // Default to black for invalid color strings
      ctx.fillStyle = "#000";

      // Use canvas to convert the string to a valid color string
      ctx.fillStyle = str;
      match = regex.exec(ctx.fillStyle);

      if (match) {
        rgba = {
          r: match[3] * 1,
          g: match[4] * 1,
          b: match[5] * 1,
          a: match[6] * 1,
        };
      } else {
        match = ctx.fillStyle
          .replace("#", "")
          .match(/.{2}/g)
          .map((h) => parseInt(h, 16));
        rgba = {
          r: match[0],
          g: match[1],
          b: match[2],
          a: 1,
        };
      }

      return rgba;
    }

    /**
     * Convert RGBA to Hex.
     * @param {object} rgba Red, green, blue and alpha values.
     * @return {string} Hex color string.
     */
    function RGBAToHex(rgba) {
      let R = rgba.r.toString(16);
      let G = rgba.g.toString(16);
      let B = rgba.b.toString(16);
      let A = "";

      if (rgba.r < 16) {
        R = "0" + R;
      }

      if (rgba.g < 16) {
        G = "0" + G;
      }

      if (rgba.b < 16) {
        B = "0" + B;
      }

      if (settings.alpha && (rgba.a < 1 || settings.forceAlpha)) {
        const alpha = (rgba.a * 255) | 0;
        A = alpha.toString(16);

        if (alpha < 16) {
          A = "0" + A;
        }
      }

      return "#" + R + G + B + A;
    }

    /**
     * Convert RGBA values to a CSS rgb/rgba string.
     * @param {object} rgba Red, green, blue and alpha values.
     * @return {string} CSS color string.
     */
    function RGBAToStr(rgba) {
      if (!settings.alpha || (rgba.a === 1 && !settings.forceAlpha)) {
        return `rgb(${rgba.r}, ${rgba.g}, ${rgba.b})`;
      } else {
        return `rgba(${rgba.r}, ${rgba.g}, ${rgba.b}, ${rgba.a})`;
      }
    }

    /**
     * Convert HSLA values to a CSS hsl/hsla string.
     * @param {object} hsla Hue, saturation, lightness and alpha values.
     * @return {string} CSS color string.
     */
    function HSLAToStr(hsla) {
      if (!settings.alpha || (hsla.a === 1 && !settings.forceAlpha)) {
        return `hsl(${hsla.h}, ${hsla.s}%, ${hsla.l}%)`;
      } else {
        return `hsla(${hsla.h}, ${hsla.s}%, ${hsla.l}%, ${hsla.a})`;
      }
    }

    /**
     * Init the color picker.
     */
    function init() {
      if (document.getElementById("clr-picker")) return; //** DO NOT REMOVE: Prevent binding events multiple times
      // Render the UI
      container = undefined$1;
      picker = document.createElement("div");
      picker.setAttribute("id", "clr-picker");
      picker.className = "clr-picker";
      picker.innerHTML =
        `<input id="clr-color-value" name="clr-color-value" class="clr-color" type="text" value="" spellcheck="false" aria-label="${settings.a11y.input}">` +
        `<div id="clr-color-area" class="clr-gradient" role="application" aria-label="${settings.a11y.instruction}">` +
        '<div id="clr-color-marker" class="clr-marker" tabindex="0"></div>' +
        "</div>" +
        '<div class="clr-hue">' +
        `<input id="clr-hue-slider" name="clr-hue-slider" type="range" min="0" max="360" step="1" aria-label="${settings.a11y.hueSlider}">` +
        '<div id="clr-hue-marker"></div>' +
        "</div>" +
        '<div class="clr-alpha">' +
        `<input id="clr-alpha-slider" name="clr-alpha-slider" type="range" min="0" max="100" step="1" aria-label="${settings.a11y.alphaSlider}">` +
        '<div id="clr-alpha-marker"></div>' +
        "<span></span>" +
        "</div>" +
        '<div id="clr-format" class="clr-format">' +
        '<fieldset class="clr-segmented">' +
        `<legend>${settings.a11y.format}</legend>` +
        '<input id="clr-f1" type="radio" name="clr-format" value="hex">' +
        '<label for="clr-f1">Hex</label>' +
        '<input id="clr-f2" type="radio" name="clr-format" value="rgb">' +
        '<label for="clr-f2">RGB</label>' +
        '<input id="clr-f3" type="radio" name="clr-format" value="hsl">' +
        '<label for="clr-f3">HSL</label>' +
        "<span></span>" +
        "</fieldset>" +
        "</div>" +
        '<div id="clr-swatches" class="clr-swatches"></div>' +
        `<button type="button" id="clr-clear" class="clr-clear" aria-label="${settings.a11y.clear}">${settings.clearLabel}</button>` +
        '<div id="clr-color-preview" class="clr-preview">' +
        `<button type="button" id="clr-close" class="clr-close" aria-label="${settings.a11y.close}">${settings.closeLabel}</button>` +
        "</div>" +
        `<span id="clr-open-label" hidden>${settings.a11y.open}</span>` +
        `<span id="clr-swatch-label" hidden>${settings.a11y.swatch}</span>`;

      // Append the color picker to the DOM
      document.body.appendChild(picker);

      // Reference the UI elements
      colorArea = getEl("clr-color-area");
      colorMarker = getEl("clr-color-marker");
      clearButton = getEl("clr-clear");
      closeButton = getEl("clr-close");
      colorPreview = getEl("clr-color-preview");
      colorValue = getEl("clr-color-value");
      hueSlider = getEl("clr-hue-slider");
      hueMarker = getEl("clr-hue-marker");
      alphaSlider = getEl("clr-alpha-slider");
      alphaMarker = getEl("clr-alpha-marker");

      // Bind the picker to the default selector
      bindFields(settings.el);
      wrapFields(settings.el);

      addListener(picker, "mousedown", (event) => {
        picker.classList.remove("clr-keyboard-nav");
        event.stopPropagation();
      });

      addListener(colorArea, "mousedown", (event) => {
        addListener(document, "mousemove", moveMarker);
      });

      addListener(colorArea, "contextmenu", (event) => {
        event.preventDefault();
      });

      addListener(colorArea, "touchstart", (event) => {
        document.addEventListener("touchmove", moveMarker, { passive: false });
      });

      addListener(colorMarker, "mousedown", (event) => {
        addListener(document, "mousemove", moveMarker);
      });

      addListener(colorMarker, "touchstart", (event) => {
        document.addEventListener("touchmove", moveMarker, { passive: false });
      });

      addListener(colorValue, "change", (event) => {
        const value = colorValue.value;

        if (currentEl || settings.inline) {
          const color = value === "" ? value : setColorFromStr(value);
          pickColor(color);
        }
      });

      addListener(clearButton, "click", (event) => {
        pickColor("");
        closePicker();
      });

      addListener(closeButton, "click", (event) => {
        pickColor();
        closePicker();
      });

      addListener(
        getEl("clr-format"),
        "click",
        ".clr-format input",
        (event) => {
          currentFormat = event.target.value;
          updateColor();
          pickColor();
        },
      );

      addListener(picker, "click", ".clr-swatches button", (event) => {
        setColorFromStr(event.target.textContent);
        pickColor();

        if (settings.swatchesOnly) {
          closePicker();
        }
      });

      addListener(document, "mouseup", (event) => {
        document.removeEventListener("mousemove", moveMarker);
      });

      addListener(document, "touchend", (event) => {
        document.removeEventListener("touchmove", moveMarker);
      });

      addListener(document, "mousedown", (event) => {
        keyboardNav = false;
        picker.classList.remove("clr-keyboard-nav");
        closePicker();
      });

      addListener(document, "keydown", (event) => {
        const key = event.key;
        const target = event.target;
        const shiftKey = event.shiftKey;
        const navKeys = [
          "Tab",
          "ArrowUp",
          "ArrowDown",
          "ArrowLeft",
          "ArrowRight",
        ];

        if (key === "Escape") {
          closePicker(true);
          return;

          // Close the color picker and keep the selected color on press on Enter
        } else if (key === "Enter" && target.tagName !== "BUTTON") {
          closePicker();
          return;

          // Display focus rings when using the keyboard
        } else if (navKeys.includes(key)) {
          keyboardNav = true;
          picker.classList.add("clr-keyboard-nav");
        }

        // Trap the focus within the color picker while it's open
        if (key === "Tab" && target.matches(".clr-picker *")) {
          const focusables = getFocusableElements();
          const firstFocusable = focusables.shift();
          const lastFocusable = focusables.pop();

          if (shiftKey && target === firstFocusable) {
            lastFocusable.focus();
            event.preventDefault();
          } else if (!shiftKey && target === lastFocusable) {
            firstFocusable.focus();
            event.preventDefault();
          }
        }
      });

      addListener(document, "click", ".clr-field button", (event) => {
        // Reset any previously set per-instance options
        if (hasInstance) {
          resetVirtualInstance();
        }

        // Open the color picker
        event.target.nextElementSibling.dispatchEvent(
          new Event("click", { bubbles: true }),
        );
      });

      addListener(colorMarker, "keydown", (event) => {
        const movements = {
          ArrowUp: [0, -1],
          ArrowDown: [0, 1],
          ArrowLeft: [-1, 0],
          ArrowRight: [1, 0],
        };

        if (Object.keys(movements).includes(event.key)) {
          moveMarkerOnKeydown(...movements[event.key]);
          event.preventDefault();
        }
      });

      addListener(colorArea, "click", moveMarker);
      addListener(hueSlider, "input", setHue);
      addListener(alphaSlider, "input", setAlpha);
    }

    /**
     * Return a list of focusable elements within the color picker.
     * @return {array} The list of focusable DOM elemnts.
     */
    function getFocusableElements() {
      const controls = Array.from(picker.querySelectorAll("input, button"));
      const focusables = controls.filter((node) => !!node.offsetWidth);

      return focusables;
    }

    /**
     * Shortcut for getElementById to optimize the minified JS.
     * @param {string} id The element id.
     * @return {object} The DOM element with the provided id.
     */
    function getEl(id) {
      return document.getElementById(id);
    }

    /**
     * Shortcut for addEventListener to optimize the minified JS.
     * @param {object} context The context to which the listener is attached.
     * @param {string} type Event type.
     * @param {(string|function)} selector Event target if delegation is used, event handler if not.
     * @param {function} [fn] Event handler if delegation is used.
     */
    function addListener(context, type, selector, fn) {
      const matches =
        Element.prototype.matches || Element.prototype.msMatchesSelector;

      // Delegate event to the target of the selector
      if (typeof selector === "string") {
        context.addEventListener(type, (event) => {
          if (matches.call(event.target, selector)) {
            fn.call(event.target, event);
          }
        });

        // If the selector is not a string then it's a function
        // in which case we need a regular event listener
      } else {
        fn = selector;
        context.addEventListener(type, fn);
      }
    }

    /**
     * Call a function only when the DOM is ready.
     * @param {function} fn The function to call.
     * @param {array} [args] Arguments to pass to the function.
     */
    function DOMReady(fn, args) {
      args = args !== undefined$1 ? args : [];

      if (document.readyState !== "loading") {
        fn(...args);
      } else {
        document.addEventListener("DOMContentLoaded", () => {
          fn(...args);
        });
      }
    }

    // Polyfill for Nodelist.forEach
    if (
      NodeList !== undefined$1 &&
      NodeList.prototype &&
      !NodeList.prototype.forEach
    ) {
      NodeList.prototype.forEach = Array.prototype.forEach;
    }

    //*****************************************************
    //******* NPM: Custom code starts here ****************
    //*****************************************************

    /**
     * Copy the active color to the linked input field and set the color.
     * @param {string} [color] Color value to override the active color.
     * @param {HTMLelement} [target] the element setting the color on
     */
    function setColor(color, target) {
      currentEl = target;
      oldColor = currentEl.value;
      attachVirtualInstance(target);
      currentFormat = getColorFormatFromStr(color);
      updatePickerPosition();
      setColorFromStr(color);
      pickColor();
      if (oldColor !== color) {
        currentEl.dispatchEvent(new Event("change", { bubbles: true }));
      }
    }

    // Expose the color picker to the global scope
    const Coloris = (() => {
      const methods = {
        init: init,
        set: configure,
        wrap: wrapFields,
        close: closePicker,
        setInstance: setVirtualInstance,
        setColor: setColor,
        removeInstance: removeVirtualInstance,
        updatePosition: updatePickerPosition,
        ready: DOMReady,
      };

      function Coloris(options) {
        DOMReady(() => {
          if (options) {
            if (typeof options === "string") {
              bindFields(options);
            } else {
              configure(options);
            }
          }
        });
      }

      for (const key in methods) {
        Coloris[key] = function () {
          for (
            var _len = arguments.length, args = new Array(_len), _key = 0;
            _key < _len;
            _key++
          ) {
            args[_key] = arguments[_key];
          }
          DOMReady(methods[key], args);
        };
      }

      // handle window resize events re-aligning the panel
      DOMReady(() => {
        window.addEventListener("resize", (event) => {
          Coloris.updatePosition();
        });
        window.addEventListener("scroll", (event) => {
          Coloris.updatePosition();
        });
      });

      return Coloris;
    })();

    // Ensure init function is available not only as as a default import
    Coloris.coloris = Coloris;

    // Init the color picker when the DOM is ready
    return Coloris;
  })(window, document, Math);
})();

const _coloris = Coloris.coloris;
const _init = Coloris.init;
const _set = Coloris.set;
const _wrap = Coloris.wrap;
const _close = Coloris.close;
const _setInstance = Coloris.setInstance;
const _removeInstance = Coloris.removeInstance;
const _updatePosition = Coloris.updatePosition;

const coloris = /*#__PURE__*/ Object.freeze(
  /*#__PURE__*/ Object.defineProperty(
    {
      __proto__: null,
      close: _close,
      coloris: _coloris,
      default: Coloris,
      init: _init,
      removeInstance: _removeInstance,
      set: _set,
      setInstance: _setInstance,
      updatePosition: _updatePosition,
      wrap: _wrap,
    },
    Symbol.toStringTag,
    { value: "Module" },
  ),
);

export {
  derived_safe_equal as $,
  user_derived as A,
  to_array as B,
  sibling as C,
  tippy as D,
  action as E,
  FILENAME as F,
  set_class as G,
  clsx as H,
  set_style as I,
  prop as J,
  child as K,
  reset as L,
  set_text as M,
  snippet as N,
  props_id as O,
  spread_props as P,
  attribute_effect as Q,
  rest_props as R,
  user_effect as S,
  validate_binding as T,
  bind_this as U,
  next as V,
  attach as W,
  from_svg as X,
  delegate as Y,
  create_ownership_validator as Z,
  init$1 as _,
  set$2 as a,
  reactive_import as a0,
  key as a1,
  remove_textarea_child as a2,
  STYLE as a3,
  apply as a4,
  await_block as a5,
  text as a6,
  assign as a7,
  track_reactivity_loss as a8,
  setContext as a9,
  getContext as aa,
  geoNaturalEarth1 as ab,
  geoConicConformal as ac,
  geoAlbersUsaTerritories as ad,
  geoMercator as ae,
  tag_proxy as af,
  select as ag,
  merge as ah,
  geoContains as ai,
  feature as aj,
  d3GeoPath as ak,
  untrack as al,
  hydrate as am,
  event as an,
  coloris as ao,
  push as b,
  check_target as c,
  comment as d,
  add_svelte_meta as e,
  first_child as f,
  get$2 as g,
  append$2 as h,
  pop as i,
  if_block as j,
  strict_equals as k,
  legacy_api as l,
  add_locations as m,
  noop$4 as n,
  template_effect as o,
  proxy as p,
  set_attribute as q,
  remove_input_defaults as r,
  state as s,
  tag as t,
  set_value as u,
  validate_snippet_args as v,
  wrap_snippet as w,
  from_html as x,
  each as y,
  index as z,
};
