/*!
 * Atlas Maps 1.0.2
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

import {
  p as proTitle,
  t as tooltipForRegionColors,
  a as tooltipForRichText,
  b as tooltipForInteractiveTooltip,
  c as tooltipForCenteredTooltip,
  d as tooltipForHoverEffects,
} from "./tg-am-admin-CBUwx3YxyT.js";
import {
  aj as ptTerritories,
  ak as nzTerritories,
  al as frTerritories,
  am as esTerritories,
  an as ecTerritories,
  ao as toSlug,
  ap as countryNames,
  aq as isProFeatureId,
  ar as last,
  _ as isThemeId,
  Y as themesById,
  i as isMapCode,
  o as mapCodeToName,
  as as fragment,
  at as h,
  au as usStatesByLowerAlphaCode,
  av as usStateVirginIslands,
  aw as usStatePuertoRico,
  ax as usStateMarianaIslands,
  ay as usStateGuam,
  az as usStateAmericanSamoa,
  $ as mount,
  aA as adminTippy,
} from "./tg-am-mount-CScR2kmj0g.js";
import {
  c as check_target,
  b as push,
  t as tag,
  A as user_derived,
  m as add_locations,
  K as child,
  V as next,
  L as reset,
  o as template_effect,
  h as append,
  i as pop,
  l as legacy_api,
  F as FILENAME,
  x as from_html,
  q as set_attribute,
  g as get,
  Q as attribute_effect,
  R as rest_props,
  X as from_svg,
  Y as delegate,
  s as state,
  S as user_effect,
  a as set,
  f as first_child,
  C as sibling,
  e as add_svelte_meta,
  U as bind_this,
  j as if_block,
  an as event,
  G as set_class,
  H as clsx,
} from "./tg-am-vendor-CBMAXaHyD6.js";
/* empty css                     */

const centeredTooltipScreenshot = "/tg-am-centered-tooltip-ABR8obaDxC.jpg";

const iconPinScreenshot = "/tg-am-icon-pin-ABy3PzcGI0.jpg";

const regionColorsScreenshot = "/tg-am-region-colors-ABvUBc5rZm.jpg";

const richTextScreenshot = "/tg-am-rich-text-ACGhG6ABIf.jpg";

const stateLabelsScreenshot = "/tg-am-state-labels-ADfVyQ5e5D.jpg";

const themeBubblegumScreenshot = "/tg-am-theme-bubblegum-AkpH0nUOPq.jpg";

const themeCorallineScreenshot = "/tg-am-theme-coralline-ABAQCElgTA.jpg";

const themeEditorScreenshot = "/tg-am-theme-editor-ACEbP7S_ES.jpg";

const themeForestScreenshot = "/tg-am-theme-forest-ACfVj8Afop.jpg";

const themeIrisScreenshot = "/tg-am-theme-iris-ABvMHscrdT.jpg";

const themeNeoBrutalistScreenshot = "/tg-am-theme-neo-brutalist-A1-dOOzRiv.jpg";

const usAmericanSamoaScreenshot = "/tg-am-us-american-samoa-ABdtgFDE3t.jpg";

const usGuamScreenshot = "/tg-am-us-guam-ADL7Eukacp.jpg";

const usMarianaIslandsScreenshot = "/tg-am-us-mariana-islands-AwRhL9Mnij.jpg";

const usPuertoRicoScreenshot = "/tg-am-us-puerto-rico-AC2CdzKhtW.jpg";

const usVirginIslandsScreenshot = "/tg-am-us-virgin-islands-AB2KcE6MOz.jpg";

const hoverEffectsMp4 = "/tg-am-hover-effects-AX2wrqYGP7.mp4";

const hoverEffectsWebM = "/tg-am-hover-effects-ABwUSPyZBU.webm";

const interactiveTooltipMp4 = "/tg-am-interactive-tooltip-ADSKRrubXd.mp4";

const interactiveTooltipWebM = "/tg-am-interactive-tooltip-ABNx5Yeq-Z.webm";

const territoryAlphaCodeToName = (mapCode, alphaCode) => {
  let territories = [];
  switch (mapCode) {
    case "ec":
      territories = ecTerritories;
      break;
    case "es":
      territories = esTerritories;
      break;
    case "fr":
      territories = frTerritories;
      break;
    case "nz":
      territories = nzTerritories;
      break;
    case "pt":
      territories = ptTerritories;
      break;
  }
  return territories
    ? territories.find((t) => t.alphaCode === alphaCode)?.name
    : null;
};

const baseUrlStem = "/atlas-maps-pro".replace(/\/+$/, "");
const linkToPricing = `${baseUrlStem}/pricing`;
const linkToMaps = `${baseUrlStem}/maps`;
const linkToToroRoot = "https://toroguapo.com";
`${linkToMaps}/${toSlug(countryNames.us)}`;

Pro_tooltip_link[FILENAME] = "src/lib/pro-tooltips/pro-tooltip-link.svelte";

var root$3 = add_locations(
  from_html(
    `<div class="tg_am_pro_tooltip_link svelte-1j0ovig"><a target="_blank" class="svelte-1j0ovig">Learn more &rarr;</a> <div class="tg_am_pro_tooltip_link_feature svelte-1j0ovig">Pro Feature</div></div>`,
  ),
  Pro_tooltip_link[FILENAME],
  [
    [
      18,
      0,
      [
        [19, 2],
        [20, 2],
      ],
    ],
  ],
);

function Pro_tooltip_link($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pro_tooltip_link);

  const href = tag(
    user_derived(
      () =>
        linkToToroRoot +
        linkToPricing +
        ($$props.featureId
          ? `/feature_${encodeURIComponent($$props.featureId)}`
          : ""),
    ),
    "href",
  );

  var div = root$3();
  var a = child(div);

  next(2);
  reset(div);
  template_effect(() => set_attribute(a, "href", get(href)));
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

Pause_icon[FILENAME] = "src/lib/components/icons/pause-icon.svelte";

var root$2 = add_locations(
  from_svg(
    `<svg><rect x="14" y="3" width="5" height="18" rx="1"></rect><rect x="5" y="3" width="5" height="18" rx="1"></rect></svg>`,
  ),
  Pause_icon[FILENAME],
  [
    [
      10,
      0,
      [
        [20, 2],
        [21, 2],
      ],
    ],
  ],
);

function Pause_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pause_icon);

  // See:
  // https://lucide.dev/icons/pause
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$2();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Play_icon[FILENAME] = "src/lib/components/icons/play-icon.svelte";

var root$1 = add_locations(
  from_svg(
    `<svg><path d="M5 5a2 2 0 0 1 3.008-1.728l11.997 6.998a2 2 0 0 1 .003 3.458l-12 7A2 2 0 0 1 5 19z"></path></svg>`,
  ),
  Play_icon[FILENAME],
  [[10, 0, [[20, 2]]]],
);

function Play_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Play_icon);

  // See:
  // https://lucide.dev/icons/play
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$1();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Video[FILENAME] = "src/lib/pro-tooltips/video.svelte";

var on_click = (_, shouldPlay) => set(shouldPlay, true);

var on_click_1 = (event, shouldPlay) => {
  event.preventDefault();
  set(shouldPlay, !get(shouldPlay));
};

var root_1 = add_locations(from_html(`<!> Pause`, 1), Video[FILENAME], []);
var root_2 = add_locations(from_html(`<!> Play`, 1), Video[FILENAME], []);

var root = add_locations(
  from_html(
    `<div class="tg_am_embed_container"><div class="tg_am_video_box"></div> <div><div class="tg_am_play_icon svelte-5rp9yv"><!></div></div> <video autoplay><source type="video/mp4"/> <source type="video/webm"/> <track kind="captions"/></video></div> <div class="tg_am_video_controls"><a href="#" class="tg_am_video_control"><!></a></div>`,
    3,
  ),
  Video[FILENAME],
  [
    [
      34,
      0,

      [
        [35, 2],
        [37, 2, [[43, 4]]],
        [
          48,
          2,
          [
            [54, 4],
            [55, 4],
            [56, 4],
          ],
        ],
      ],
    ],

    [60, 0, [[62, 2]]],
  ],
);

function Video($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Video);

  let videoRef = tag(state(void 0), "videoRef");
  let shouldPlay = tag(state(false), "shouldPlay");
  let isPlaying = tag(state(false), "isPlaying");
  let isFirstPlay = tag(state(true), "isFirstPlay");
  const videoIsPlaying = () => (get(videoRef) ? !get(videoRef).paused : false);

  user_effect(() => {
    if (get(videoRef)) {
      if (get(shouldPlay) && !videoIsPlaying()) {
        get(videoRef).play();
      } else if (!get(shouldPlay) && videoIsPlaying()) {
        get(videoRef).pause();
      }

      set(isPlaying, !get(videoRef).paused);

      if (get(isPlaying)) {
        set(isFirstPlay, false);
      }
    }
  });

  var fragment = root();
  var div = first_child(fragment);

  div.__click = [on_click, shouldPlay];

  var div_1 = sibling(child(div), 2);
  var div_2 = child(div_1);
  var node = child(div_2);

  add_svelte_meta(() => Play_icon(node, {}), "component", Video, 44, 6, {
    componentTag: "PlayIcon",
  });
  reset(div_2);
  reset(div_1);

  var video = sibling(div_1, 2);
  var source = child(video);
  var source_1 = sibling(source, 2);

  next(2);
  reset(video);
  bind_this(
    video,
    ($$value) => set(videoRef, $$value),
    () => get(videoRef),
  );
  reset(div);

  var div_3 = sibling(div, 2);
  var a = child(div_3);

  a.__click = [on_click_1, shouldPlay];

  var node_1 = child(a);

  {
    var consequent = ($$anchor) => {
      var fragment_1 = root_1();
      var node_2 = first_child(fragment_1);

      add_svelte_meta(() => Pause_icon(node_2, {}), "component", Video, 71, 6, {
        componentTag: "PauseIcon",
      });
      next();
      append($$anchor, fragment_1);
    };

    var alternate = ($$anchor) => {
      var fragment_2 = root_2();
      var node_3 = first_child(fragment_2);

      add_svelte_meta(() => Play_icon(node_3, {}), "component", Video, 74, 6, {
        componentTag: "PlayIcon",
      });
      next();
      append($$anchor, fragment_2);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (get(shouldPlay)) $$render(consequent);
          else $$render(alternate, false);
        }),
      "if",
      Video,
      70,
      4,
    );
  }

  reset(a);
  reset(div_3);

  template_effect(() => {
    set_class(
      div_1,
      1,
      clsx([
        "tg_am_play_box",
        get(isPlaying) || !get(isFirstPlay) ? "tg_am_hidden" : null,
      ]),
      "svelte-5rp9yv",
    );

    set_attribute(source, "src", $$props.mp4);
    set_attribute(source_1, "src", $$props.webm);
  });

  event("playing", video, () => set(shouldPlay, true));
  event("pause", video, () => set(shouldPlay, false));
  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

const tippyInstances = /* @__PURE__ */ new Map();
const contexts = [];
const getContext = () => last(contexts) ?? {};
const getAssetUrlPrefix = () => {
  return tg_am_data?.assetsBaseUrl?.replace(/\/+$/, "") ?? "";
};
const cleanup = () => {
  for (const [el, tippyInstance] of tippyInstances.entries()) {
    tippyInstance.destroy();
  }
  tippyInstances.clear();
};
document.body.addEventListener("keydown", cleanup);
document.body.addEventListener("mouseover", (event) => {
  const target = event.target;
  if (!(target instanceof HTMLElement)) {
    return;
  }
  const el = target.closest("[data-tg-am-pro]");
  if (!(el instanceof HTMLElement) || tippyInstances.has(el)) {
    return;
  }
  const [featureId, params] = (el.dataset.tgAmPro ?? "").split(":");
  if (!isProFeatureId(featureId)) {
    return;
  }
  cleanup();
  contexts.push({ featureId, params });
  const add = (tippyInstance) => {
    if (tippyInstance) {
      tippyInstances.set(el, tippyInstance);
    }
  };
  switch (featureId) {
    case "max_pins":
      add(setupMaxPins(el));
      break;
    case "hover_effects":
      add(setupHoverEffects(el));
      break;
    case "centered_tooltip":
      add(setupCenteredTooltip(el));
      break;
    case "interactive_tooltip":
      add(setupInteractiveTooltip(el));
      break;
    case "theme":
      add(setupTheme(el));
      break;
    case "pin_shape":
      add(setupPinShape(el));
      break;
    case "map":
      add(setupMap(el));
      break;
    case "rich_text":
      add(setupRichText(el));
      break;
    case "theme_editor":
      add(setupThemeEditor(el));
      break;
    case "state_labels":
      add(setupStateLabels(el));
      break;
    case "custom_regions":
      add(setupCustomRegions(el));
      break;
    case "region_colors":
      add(setupRegionColors(el));
      break;
  }
  contexts.pop();
});
const setupMaxPins = (el) => {
  const { params } = getContext();
  const maxCount = params ? parseInt(params, 10) : null;
  const content =
    (maxCount ?? 0) > 0
      ? `Adding more than ${maxCount} pin${maxCount === 1 ? "" : "s"} requires ${proTitle}.`
      : `Adding more pins requires ${proTitle}.`;
  return setupTippy(el, { content });
};
const setupHoverEffects = (el) => {
  return setupVideo(el, {
    text: tooltipForHoverEffects,
    mp4: hoverEffectsMp4,
    webm: hoverEffectsWebM,
  });
};
const setupCenteredTooltip = (el) => {
  return setupScreenshot(el, {
    content: tooltipForCenteredTooltip,
    src: centeredTooltipScreenshot,
  });
};
const setupInteractiveTooltip = (el) => {
  return setupVideo(el, {
    text: tooltipForInteractiveTooltip,
    mp4: interactiveTooltipMp4,
    webm: interactiveTooltipWebM,
  });
};
const setupTheme = (el) => {
  const { params: themeId } = getContext();
  if (!isThemeId(themeId)) {
    return;
  }
  let src;
  switch (themeId) {
    case "coralline":
      src = themeCorallineScreenshot;
      break;
    case "iris":
      src = themeIrisScreenshot;
      break;
    case "forest":
      src = themeForestScreenshot;
      break;
    case "bubblegum":
      src = themeBubblegumScreenshot;
      break;
    case "neo_brutalist":
      src = themeNeoBrutalistScreenshot;
      break;
  }
  if (!src) {
    return;
  }
  return setupScreenshot(el, {
    content:
      "The " +
      themesById[themeId].title +
      ` theme is available in ${proTitle}.`,
    src,
  });
};
const setupPinShape = (el) => {
  return setupScreenshot(el, {
    content: "Icon pin shape.",
    src: iconPinScreenshot,
  });
};
const setupMap = (el) => {
  const { params: mapCode } = getContext();
  const map = isMapCode(mapCode) ? `map of ${mapCodeToName(mapCode)}` : "map";
  const content = `The ${map} is included in ${proTitle}.`;
  return setupTippy(el, { content });
};
const setupRichText = (el) => {
  return setupScreenshot(el, {
    content: tooltipForRichText,
    src: richTextScreenshot,
  });
};
const setupThemeEditor = (el) => {
  return setupScreenshot(el, {
    content: fragment([
      "Creating custom themes",
      h("br"),
      `requires ${proTitle}.`,
    ]),
    src: themeEditorScreenshot,
    imageStyle: "max-width: 200px",
  });
};
const setupStateLabels = (el) => {
  return setupScreenshot(el, {
    content: `Displaying state labels requires ${proTitle}.`,
    src: stateLabelsScreenshot,
  });
};
const setupCustomRegions = (el) => {
  let { params } = getContext();
  params ??= "";
  let mapCode = "us";
  let alphaCode;
  if (params.indexOf(" ") > 0) {
    const [paramMapCode, paramAlphaCode] = params.split(" ");
    if (isMapCode(paramMapCode)) {
      mapCode = paramMapCode;
    }
    alphaCode = paramAlphaCode;
  } else {
    alphaCode = params;
  }
  let content;
  if (mapCode === "us") {
    const usState = usStatesByLowerAlphaCode[alphaCode?.toLowerCase()];
    content = `Displaying ${usState ? usState.name : "this state"} as part of the United States map requires ${proTitle}.`;
    switch (usState) {
      case usStateAmericanSamoa:
        return setupScreenshot(el, { content, src: usAmericanSamoaScreenshot });
      case usStateGuam:
        return setupScreenshot(el, { content, src: usGuamScreenshot });
      case usStateMarianaIslands:
        return setupScreenshot(el, {
          content,
          src: usMarianaIslandsScreenshot,
        });
      case usStatePuertoRico:
        return setupScreenshot(el, { content, src: usPuertoRicoScreenshot });
      case usStateVirginIslands:
        return setupScreenshot(el, { content, src: usVirginIslandsScreenshot });
    }
  } else {
    const countryName = mapCodeToName(mapCode);
    const territoryName = territoryAlphaCodeToName(mapCode, alphaCode);
    content = `Displaying ${territoryName ? territoryName : "this territory"} as part of the ${countryName} map requires ${proTitle}.`;
  }
  if (content) {
    return setupTippy(el, { content });
  }
};
const setupRegionColors = (el) => {
  return setupScreenshot(el, {
    content: tooltipForRegionColors,
    src: regionColorsScreenshot,
  });
};
const setupVideo = (el, options) => {
  return setupTippy(el, {
    content: fragment([
      h("div", {}, [options.text]),
      video({
        mp4: getAssetUrlPrefix() + options.mp4,
        webm: getAssetUrlPrefix() + options.webm,
      }),
    ]),
  });
};
const setupScreenshot = (el, options) => {
  const elImage = h("img", {
    className: "tg_am_embed_container",
    src: getAssetUrlPrefix() + options.src,
  });
  if (options.imageStyle) {
    elImage.setAttribute("style", options.imageStyle);
  }
  const elEmbed = h("div", { className: "tg_am_pro_tooltip_embed" }, [elImage]);
  if (options.embedStyle) {
    elEmbed.setAttribute("style", options.embedStyle);
  }
  return setupTippy(el, {
    content: fragment([h("div", {}, [options.content]), elEmbed]),
  });
};
const setupTippy = (el, props) => {
  const { featureId } = getContext();
  const link = h("a");
  mount(Pro_tooltip_link, link, { featureId });
  const content = h("div", { className: "tg_am_pro_tooltip" }, [
    props?.content,
    link,
  ]);
  return adminTippy(el, {
    appendTo: document.body,
    interactive: true,
    interactiveBorder: 3,
    theme: "tg_am_pro_demo",
    delay: [500, 0],
    ...props,
    content,
    onHidden(instance) {
      props?.onHidden?.(instance);
      tippyInstances.delete(el);
      instance.destroy();
    },
  });
};
const video = (props) => {
  return mount(
    Video,
    h("div", { className: "tg_am_pro_tooltip_embed" }),
    props,
  );
};
