/*!
 * Atlas Maps 1.0.2
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

import {
  D as tippy,
  a9 as setContext,
  aa as getContext,
  ab as geoNaturalEarth1,
  ac as geoConicConformal,
  ad as geoAlbersUsaTerritories,
  ae as geoMercator,
  c as check_target,
  b as push,
  t as tag,
  A as user_derived,
  s as state,
  af as tag_proxy,
  p as proxy,
  S as user_effect,
  g as get,
  ag as select,
  ah as merge,
  ai as geoContains,
  k as strict_equals,
  m as add_locations,
  q as set_attribute,
  U as bind_this,
  h as append,
  i as pop,
  l as legacy_api,
  R as rest_props,
  F as FILENAME,
  X as from_svg,
  aj as feature,
  ak as d3GeoPath,
  a as set,
  w as wrap_snippet,
  v as validate_snippet_args,
  V as next,
  d as comment,
  f as first_child,
  e as add_svelte_meta,
  j as if_block,
  Q as attribute_effect,
  K as child,
  o as template_effect,
  L as reset,
  J as prop,
  al as untrack,
  C as sibling,
  P as spread_props,
  x as from_html,
  G as set_class,
  H as clsx,
  Z as create_ownership_validator,
  a5 as await_block,
  am as hydrate,
} from "./tg-am-vendor-CBMAXaHyD6.js";

const last = (input) => input[input.length - 1];
const ucfirst = (input) => input[0].toUpperCase() + input.slice(1);
const isRecord = (input) => {
  return typeof input === "object" && input !== null && !Array.isArray(input);
};
const toSlug = (input) => {
  return input
    .normalize("NFD")
    .replace(/[\u0300-\u036f]/g, "")
    .toLowerCase()
    .replace(/\s+/g, "-");
};
const localStorageGetItem = (key) => {
  if (typeof localStorage === "undefined") {
    return null;
  }
  return localStorage?.getItem?.(key);
};
const localStorageSetItem = (key, value) => {
  if (typeof localStorage !== "undefined") {
    localStorage?.setItem?.(key, value);
  }
};

const usStateArizona = {
  name: "Arizona",
  alphaCode: "AZ",
  numericCode: "04",
  regionId: "ITjzXw",
};
const usStateLouisiana = {
  name: "Louisiana",
  alphaCode: "LA",
  numericCode: "22",
  regionId: "N1Nkqg",
};
const usStateIdaho = {
  name: "Idaho",
  alphaCode: "ID",
  numericCode: "16",
  regionId: "StArPA",
};
const usStateMinnesota = {
  name: "Minnesota",
  alphaCode: "MN",
  numericCode: "27",
  regionId: "udVfFg",
};
const usStateNorthDakota = {
  name: "North Dakota",
  alphaCode: "ND",
  numericCode: "38",
  regionId: "HKLcyA",
};
const usStateSouthDakota = {
  name: "South Dakota",
  alphaCode: "SD",
  numericCode: "46",
  regionId: "UCE7wQ",
};
const usStateNewYork = {
  name: "New York",
  alphaCode: "NY",
  numericCode: "36",
  regionId: "eP2d7Q",
};
const usStateAlaska = {
  name: "Alaska",
  alphaCode: "AK",
  numericCode: "02",
  regionId: "kPyjPw",
};
const usStateGeorgia = {
  name: "Georgia",
  alphaCode: "GA",
  numericCode: "13",
  regionId: "nmWsHg",
};
const usStateIndiana = {
  name: "Indiana",
  alphaCode: "IN",
  numericCode: "18",
  regionId: "_x8nWA",
};
const usStateMichigan = {
  name: "Michigan",
  alphaCode: "MI",
  numericCode: "26",
  regionId: "Rjs1VQ",
};
const usStateMississippi = {
  name: "Mississippi",
  alphaCode: "MS",
  numericCode: "28",
  regionId: "l1DSaw",
};
const usStateOhio = {
  name: "Ohio",
  alphaCode: "OH",
  numericCode: "39",
  regionId: "LoRMAQ",
};
const usStateTexas = {
  name: "Texas",
  alphaCode: "TX",
  numericCode: "48",
  regionId: "bbnwow",
};
const usStatePuertoRico = {
  name: "Puerto Rico",
  alphaCode: "PR",
  numericCode: "72",
  regionId: "j3rByw",
};
const usStateNebraska = {
  name: "Nebraska",
  alphaCode: "NE",
  numericCode: "31",
  regionId: "_sTXQQ",
};
const usStateColorado = {
  name: "Colorado",
  alphaCode: "CO",
  numericCode: "08",
  regionId: "rXKL7A",
};
const usStateMaryland = {
  name: "Maryland",
  alphaCode: "MD",
  numericCode: "24",
  regionId: "6dV63A",
};
const usStateKansas = {
  name: "Kansas",
  alphaCode: "KS",
  numericCode: "20",
  regionId: "t_AqFQ",
};
const usStateIllinois = {
  name: "Illinois",
  alphaCode: "IL",
  numericCode: "17",
  regionId: "SNJvhg",
};
const usStateWisconsin = {
  name: "Wisconsin",
  alphaCode: "WI",
  numericCode: "55",
  regionId: "afiVnQ",
};
const usStateCalifornia = {
  name: "California",
  alphaCode: "CA",
  numericCode: "06",
  regionId: "neELHw",
};
const usStateIowa = {
  name: "Iowa",
  alphaCode: "IA",
  numericCode: "19",
  regionId: "ZHEqfw",
};
const usStatePennsylvania = {
  name: "Pennsylvania",
  alphaCode: "PA",
  numericCode: "42",
  regionId: "BxhO7g",
};
const usStateMontana = {
  name: "Montana",
  alphaCode: "MT",
  numericCode: "30",
  regionId: "1mY65w",
};
const usStateMissouri = {
  name: "Missouri",
  alphaCode: "MO",
  numericCode: "29",
  regionId: "6Rrtpw",
};
const usStateFlorida = {
  name: "Florida",
  alphaCode: "FL",
  numericCode: "12",
  regionId: "foaqig",
};
const usStateKentucky = {
  name: "Kentucky",
  alphaCode: "KY",
  numericCode: "21",
  regionId: "MaOeBA",
};
const usStateMaine = {
  name: "Maine",
  alphaCode: "ME",
  numericCode: "23",
  regionId: "ZSLGZQ",
};
const usStateUtah = {
  name: "Utah",
  alphaCode: "UT",
  numericCode: "49",
  regionId: "q6oBFg",
};
const usStateOklahoma = {
  name: "Oklahoma",
  alphaCode: "OK",
  numericCode: "40",
  regionId: "AXhhfw",
};
const usStateTennessee = {
  name: "Tennessee",
  alphaCode: "TN",
  numericCode: "47",
  regionId: "Z1LEAg",
};
const usStateOregon = {
  name: "Oregon",
  alphaCode: "OR",
  numericCode: "41",
  regionId: "cz5q3g",
};
const usStateWestVirginia = {
  name: "West Virginia",
  alphaCode: "WV",
  numericCode: "54",
  regionId: "6ydBDg",
};
const usStateArkansas = {
  name: "Arkansas",
  alphaCode: "AR",
  numericCode: "05",
  regionId: "TS0ijQ",
};
const usStateWashington = {
  name: "Washington",
  alphaCode: "WA",
  numericCode: "53",
  regionId: "XRQOMQ",
};
const usStateNorthCarolina = {
  name: "North Carolina",
  alphaCode: "NC",
  numericCode: "37",
  regionId: "BCV7Nw",
};
const usStateVirginia = {
  name: "Virginia",
  alphaCode: "VA",
  numericCode: "51",
  regionId: "76FGNw",
};
const usStateWyoming = {
  name: "Wyoming",
  alphaCode: "WY",
  numericCode: "56",
  regionId: "ack8mw",
};
const usStateAlabama = {
  name: "Alabama",
  alphaCode: "AL",
  numericCode: "01",
  regionId: "8sgtmg",
};
const usStateSouthCarolina = {
  name: "South Carolina",
  alphaCode: "SC",
  numericCode: "45",
  regionId: "BtxKVQ",
};
const usStateNewMexico = {
  name: "New Mexico",
  alphaCode: "NM",
  numericCode: "35",
  regionId: "gr8ZLg",
};
const usStateNewHampshire = {
  name: "New Hampshire",
  alphaCode: "NH",
  numericCode: "33",
  regionId: "VJyF8Q",
};
const usStateAmericanSamoa = {
  name: "American Samoa",
  alphaCode: "AS",
  numericCode: "60",
  regionId: "vZjNOw",
};
const usStateVermont = {
  name: "Vermont",
  alphaCode: "VT",
  numericCode: "50",
  regionId: "8moS7g",
};
const usStateNevada = {
  name: "Nevada",
  alphaCode: "NV",
  numericCode: "32",
  regionId: "QcGTmA",
};
const usStateHawaii = {
  name: "Hawaii",
  alphaCode: "HI",
  numericCode: "15",
  regionId: "kUvFyg",
};
const usStateMassachusetts = {
  name: "Massachusetts",
  alphaCode: "MA",
  numericCode: "25",
  regionId: "2QP19w",
};
const usStateVirginIslands = {
  name: "Virgin Islands",
  alphaCode: "VI",
  numericCode: "78",
  regionId: "Iaj-3g",
};
const usStateRhodeIsland = {
  name: "Rhode Island",
  alphaCode: "RI",
  numericCode: "44",
  regionId: "4uEROw",
};
const usStateNewJersey = {
  name: "New Jersey",
  alphaCode: "NJ",
  numericCode: "34",
  regionId: "7P6DjQ",
};
const usStateDelaware = {
  name: "Delaware",
  alphaCode: "DE",
  numericCode: "10",
  regionId: "BM2ZeQ",
};
const usStateConnecticut = {
  name: "Connecticut",
  alphaCode: "CT",
  numericCode: "09",
  regionId: "iyEwBQ",
};
const usStateMarianaIslands = {
  name: "Mariana Islands",
  alphaCode: "MP",
  numericCode: "69",
  regionId: "bNw3ew",
};
const usStateGuam = {
  name: "Guam",
  alphaCode: "GU",
  numericCode: "66",
  regionId: "CdA6sQ",
};
const usStateDistrictofColumbia = {
  name: "District of Columbia",
  alphaCode: "DC",
  numericCode: "11",
  regionId: "0U163A",
};
const usStates = [
  usStateArizona,
  usStateLouisiana,
  usStateIdaho,
  usStateMinnesota,
  usStateNorthDakota,
  usStateSouthDakota,
  usStateNewYork,
  usStateAlaska,
  usStateGeorgia,
  usStateIndiana,
  usStateMichigan,
  usStateMississippi,
  usStateOhio,
  usStateTexas,
  usStatePuertoRico,
  usStateNebraska,
  usStateColorado,
  usStateMaryland,
  usStateKansas,
  usStateIllinois,
  usStateWisconsin,
  usStateCalifornia,
  usStateIowa,
  usStatePennsylvania,
  usStateMontana,
  usStateMissouri,
  usStateFlorida,
  usStateKentucky,
  usStateMaine,
  usStateUtah,
  usStateOklahoma,
  usStateTennessee,
  usStateOregon,
  usStateWestVirginia,
  usStateArkansas,
  usStateWashington,
  usStateNorthCarolina,
  usStateVirginia,
  usStateWyoming,
  usStateAlabama,
  usStateSouthCarolina,
  usStateNewMexico,
  usStateNewHampshire,
  usStateAmericanSamoa,
  usStateVermont,
  usStateNevada,
  usStateHawaii,
  usStateMassachusetts,
  usStateVirginIslands,
  usStateRhodeIsland,
  usStateNewJersey,
  usStateDelaware,
  usStateConnecticut,
  usStateMarianaIslands,
  usStateGuam,
  usStateDistrictofColumbia,
];

const sortedUsStates = [...usStates].sort(({ name: a }, { name: b }) =>
  a.localeCompare(b),
);
const findUsStateByName = (name) => {
  const nameNormalized = name.trim().toLowerCase();
  for (const usState of usStates) {
    if (usState.name.trim().toLowerCase() === nameNormalized) {
      return usState;
    }
  }
  return null;
};
const usStatesByNumericCode = (() => {
  const byCode = {};
  for (const usState of usStates) {
    byCode[usState.numericCode] = usState;
  }
  return byCode;
})();
const usStatesByLowerAlphaCode = (() => {
  const byCode = {};
  for (const usState of usStates) {
    byCode[usState.alphaCode.toLowerCase()] = usState;
  }
  return byCode;
})();
const usStatesByRegionId = (() => {
  const byId = {};
  for (const usState of usStates) {
    byId[usState.regionId] = usState;
  }
  return byId;
})();
const generateUsStateMapCode = (usState) =>
  `us-${usState.alphaCode.toLowerCase()}`;
const usStateMapCodes = usStates.map(
  (state) => `us-${state.alphaCode.toLowerCase()}`,
);
const isUsStateMapCode = (input) => {
  return usStateMapCodes.includes(input);
};
const usStatesByMapCode = Object.fromEntries(
  usStates.map((usState) => [generateUsStateMapCode(usState), usState]),
);

const countryNames = {
  ad: "Andorra",
  ae: "United Arab Emirates",
  af: "Afghanistan",
  ag: "Antigua and Barbuda",
  al: "Albania",
  am: "Armenia",
  ao: "Angola",
  ar: "Argentina",
  at: "Austria",
  au: "Australia",
  az: "Azerbaijan",
  ba: "Bosnia and Herzegovina",
  bb: "Barbados",
  bd: "Bangladesh",
  be: "Belgium",
  bf: "Burkina Faso",
  bg: "Bulgaria",
  bh: "Bahrain",
  bi: "Burundi",
  bj: "Benin",
  bn: "Brunei",
  bo: "Bolivia",
  br: "Brazil",
  bs: "Bahamas",
  bt: "Bhutan",
  bw: "Botswana",
  by: "Belarus",
  bz: "Belize",
  ca: "Canada",
  cd: "Democratic Republic of the Congo",
  cf: "Central African Republic",
  cg: "Republic of the Congo",
  ch: "Switzerland",
  ci: "Ivory Coast",
  ck: "Cook Islands",
  cl: "Chile",
  cm: "Cameroon",
  cn: "China",
  co: "Colombia",
  cr: "Costa Rica",
  cu: "Cuba",
  cv: "Cape Verde",
  cy: "Cyprus",
  cz: "Czech Republic",
  de: "Germany",
  dj: "Djibouti",
  dk: "Denmark",
  dm: "Dominica",
  do: "Dominican Republic",
  dz: "Algeria",
  ec: "Ecuador",
  ee: "Estonia",
  eg: "Egypt",
  er: "Eritrea",
  es: "Spain",
  et: "Ethiopia",
  fi: "Finland",
  fj: "Fiji",
  fm: "Federated States of Micronesia",
  fr: "France",
  ga: "Gabon",
  gd: "Grenada",
  ge: "Georgia",
  gh: "Ghana",
  gm: "Gambia",
  gn: "Guinea",
  gq: "Equatorial Guinea",
  gr: "Greece",
  gt: "Guatemala",
  gw: "Guinea-Bissau",
  gy: "Guyana",
  hn: "Honduras",
  hr: "Croatia",
  ht: "Haiti",
  hu: "Hungary",
  id: "Indonesia",
  ie: "Ireland",
  il: "Israel",
  in: "India",
  iq: "Iraq",
  ir: "Iran",
  is: "Iceland",
  it: "Italy",
  jm: "Jamaica",
  jo: "Jordan",
  jp: "Japan",
  ke: "Kenya",
  kg: "Kyrgyzstan",
  kh: "Cambodia",
  ki: "Kiribati",
  km: "Comoros",
  kn: "Saint Kitts and Nevis",
  kp: "North Korea",
  kr: "South Korea",
  kw: "Kuwait",
  kz: "Kazakhstan",
  la: "Laos",
  lb: "Lebanon",
  lc: "Saint Lucia",
  li: "Liechtenstein",
  lk: "Sri Lanka",
  lr: "Liberia",
  ls: "Lesotho",
  lt: "Lithuania",
  lu: "Luxembourg",
  lv: "Latvia",
  ly: "Libya",
  ma: "Morocco",
  mc: "Monaco",
  md: "Moldova",
  me: "Montenegro",
  mg: "Madagascar",
  mh: "Marshall Islands",
  mk: "Macedonia",
  ml: "Mali",
  mm: "Myanmar",
  mn: "Mongolia",
  mr: "Mauritania",
  mt: "Malta",
  mu: "Mauritius",
  mv: "Maldives",
  mw: "Malawi",
  mx: "Mexico",
  my: "Malaysia",
  mz: "Mozambique",
  na: "Namibia",
  ne: "Niger",
  ng: "Nigeria",
  ni: "Nicaragua",
  nl: "Netherlands",
  no: "Norway",
  np: "Nepal",
  nr: "Nauru",
  nu: "Niue",
  nz: "New Zealand",
  om: "Oman",
  pa: "Panama",
  pe: "Peru",
  pg: "Papua New Guinea",
  ph: "Philippines",
  pk: "Pakistan",
  pl: "Poland",
  ps: "Palestine",
  pt: "Portugal",
  pw: "Palau",
  py: "Paraguay",
  qa: "Qatar",
  ro: "Romania",
  rs: "Serbia",
  ru: "Russia",
  rw: "Rwanda",
  sa: "Saudi Arabia",
  sb: "Solomon Islands",
  sc: "Seychelles",
  sd: "Sudan",
  se: "Sweden",
  sg: "Singapore",
  si: "Slovenia",
  sk: "Slovakia",
  sl: "Sierra Leone",
  sm: "San Marino",
  sn: "Senegal",
  so: "Somalia",
  sr: "Suriname",
  ss: "South Sudan",
  st: "São Tomé and Príncipe",
  sv: "El Salvador",
  sy: "Syria",
  sz: "Eswatini",
  td: "Chad",
  tg: "Togo",
  th: "Thailand",
  tj: "Tajikistan",
  tl: "Timor-Leste",
  tm: "Turkmenistan",
  tn: "Tunisia",
  to: "Tonga",
  tr: "Turkey",
  tt: "Trinidad and Tobago",
  tv: "Tuvalu",
  tw: "Taiwan",
  tz: "Tanzania",
  ua: "Ukraine",
  ug: "Uganda",
  uk: "United Kingdom",
  us: "United States of America",
  uy: "Uruguay",
  uz: "Uzbekistan",
  va: "Vatican",
  vc: "Saint Vincent and the Grenadines",
  ve: "Venezuela",
  vn: "Vietnam",
  vu: "Vanuatu",
  ws: "Samoa",
  ye: "Yemen",
  za: "South Africa",
  zm: "Zambia",
  zw: "Zimbabwe",
};
const countryMapCodes = Object.keys(countryNames);
const areaNames = { europe: "Europe", world: "World" };
const areaMapCodes = Object.keys(areaNames);
const mapCodes = [...countryMapCodes, ...usStateMapCodes, ...areaMapCodes];
const isMapCode = (input) => {
  return mapCodes.includes(input);
};
const isCountryMapCode = (input) => {
  return countryMapCodes.includes(input);
};
const isAreaMapCode = (input) => {
  return areaMapCodes.includes(input);
};
const isEssentialMapCode = (input) => {
  return isAreaMapCode(input) || (isMapCode(input) && input === "us");
};
const mapHasCountries = (mapCode) => {
  return mapCode === "europe" || mapCode === "world";
};
const mapHasStates = (mapCode) => {
  return mapCode === "us";
};
const getRegionType = (mapCode) => {
  return mapHasCountries(mapCode)
    ? "country"
    : mapHasStates(mapCode)
      ? "state"
      : "region";
};
const mapCodeToName = (mapCode) => {
  if (!isMapCode(mapCode) || mapCode === "__default") {
    return "";
  }
  if (isUsStateMapCode(mapCode)) {
    return usStatesByMapCode[mapCode].name;
  }
  if (isAreaMapCode(mapCode)) {
    return areaNames[mapCode];
  }
  return countryNames[mapCode];
};
const mapCodeToCountryName = (mapCode) => {
  if (!isMapCode(mapCode)) {
    return "";
  }
  if (isUsStateMapCode(mapCode)) {
    return mapCodeToName("us");
  }
  if (isAreaMapCode(mapCode)) {
    return null;
  }
  if (mapCode === "__default") {
    return null;
  }
  return countryNames[mapCode];
};
const sortedCountryMapCodes = [...countryMapCodes].sort((a, b) =>
  mapCodeToName(a).localeCompare(mapCodeToName(b)),
);
const sortedAreaMapCodes = [...areaMapCodes].sort((a, b) =>
  mapCodeToName(a).localeCompare(mapCodeToName(b)),
);
const defaultMapCode = "us";

const isGeoCoordinate = (input) => {
  if (!isRecord(input)) {
    return false;
  }
  const { lat, lon } = input;
  return (
    typeof lat === "number" &&
    lat >= -90 &&
    lat <= 90 &&
    typeof lon === "number" &&
    lon >= -180 &&
    lon <= 180
  );
};
const parseLatitude = (input) => {
  return parseCoordinate(input, -90, 90);
};
const parseLongitude = (input) => {
  return parseCoordinate(input, -180, 180);
};
const parseCoordinate = (input, min, max) => {
  if (typeof input !== "string" && typeof input !== "number") {
    return null;
  }
  const parsed = parseFloat(input.toString());
  return isNaN(parsed) || parsed < min || parsed > max ? null : parsed;
};

const isPin = (input) => {
  if (!isRecord(input)) {
    return false;
  }
  const { name, id } = input;
  if (typeof name !== "string" || typeof id !== "string") {
    return false;
  }
  if (input.type === "coords") {
    const { lat, lon } = input;
    return (
      (lat === null || lat === void 0 || typeof lat === "number") &&
      (lon === null || lon === void 0 || typeof lon === "number")
    );
  }
  return false;
};
const generatePinId = (mapCode) => {
  return "pin-" + (mapCode ? mapCode + "-" : "") + generateRandomId(20);
};
const newPin = (name, mapCode) => {
  return { name, id: generatePinId(mapCode), type: "coords" };
};

const isString = (input) => typeof input === "string";
const getBoolean = (input, defaultValue = false) => {
  return typeof input === "boolean"
    ? input
    : typeof input === "string"
      ? input === "true"
      : defaultValue;
};
const getPositiveInteger = (input) => {
  let value = null;
  if (typeof input === "string") {
    value = parseInt(input, 10);
  } else if (typeof input === "number") {
    value = input;
  }
  if (typeof value === "number") {
    if (!Number.isInteger(value)) {
      value = Math.floor(value);
    }
    if (isNaN(value) || value < 1) {
      return null;
    }
  }
  return value;
};
const extractValues = (input, validator) => {
  if (!isRecord(input)) return {};
  const values = {};
  for (const [key, value] of Object.entries(input)) {
    if (validator(value)) {
      values[key] = value;
    }
  }
  return values;
};
const extractBooleans = (input) => {
  if (!isRecord(input)) return {};
  const values = {};
  for (const [key, value] of Object.entries(input)) {
    if (value === "true" || value === "false") {
      values[key] = value === "true";
    } else if (typeof value === "boolean") {
      values[key] = value;
    }
  }
  return values;
};
const extractPins = (input) => {
  if (!isRecord(input)) return {};
  const pins = {};
  for (const [pinId, encoded] of Object.entries(input)) {
    if (!isRecord(encoded)) {
      continue;
    }
    const pin = {
      ...encoded,
      lat: parseLatitude(encoded.lat),
      lon: parseLongitude(encoded.lon),
    };
    if (isPin(pin)) {
      pins[pinId] = pin;
    }
  }
  return pins;
};
const hasOptional = (input, key, validator) => {
  return !(key in input) || validator(input[key]);
};

const mapDataSections = ["regions", "pins"];
const mapDataSectionSingular = (section) => {
  switch (section) {
    case "regions":
      return "region";
    case "pins":
      return "pin";
  }
};
const dataAttributeBySection = {
  regions: "data-tg-am-id",
  pins: "data-tg-am-pin-id",
};
const dataSetKeyBySection = {
  regions: "tgAmId",
  pins: "tgAmPinId",
};

const isRegionColors = (input) => {
  return (
    isRecord(input) &&
    hasOptional(input, "background", isString) &&
    hasOptional(input, "foreground", isString) &&
    hasOptional(input, "hoverBackground", isString) &&
    hasOptional(input, "hoverForeground", isString)
  );
};
const regionColorsToCssRules = (
  mapCode,
  mapId,
  regionId,
  { background, foreground, hoverBackground, hoverForeground },
  options,
) => {
  const mapSelector = `.tg_am_map[data-tg-am-map-id="${mapId}"][data-tg-am-map-code="${mapCode}"]`;
  const regionSelector = `[${dataAttributeBySection["regions"]}="${regionId}"]`;
  const { inherit } = {};
  let css = "";
  if (isValidColor(background)) {
    css += `--tg-am-theme-region-background-color:${background};`;
  } else if (inherit) {
    css += `--tg-am-theme-region-background-color:inherit;`;
  }
  if (isValidColor(foreground)) {
    css += `--tg-am-theme-region-foreground-color:${foreground};`;
  } else if (inherit) {
    css += `--tg-am-theme-region-foreground-color:inherit;`;
  }
  if (isValidColor(hoverBackground)) {
    css += `--tg-am-theme-region-hover-background-color:${hoverBackground};`;
  } else if (inherit) {
    css += `--tg-am-theme-region-hover-background-color:inherit;`;
  }
  if (isValidColor(hoverForeground)) {
    css += `--tg-am-theme-region-hover-foreground-color:${hoverForeground};`;
  } else if (inherit) {
    css += `--tg-am-theme-region-hover-foreground-color:inherit;`;
  }
  return css ? `${mapSelector} ${regionSelector}{${css}}` : "";
};
const isValidColor = (color) => {
  if (!color) {
    return false;
  }
  if (window.CSS) {
    return CSS.supports("color", color);
  }
  const option = document.createElement("option");
  option.style.color = color;
  return option.style.color !== "";
};
const generateFieldId = (label, componentId) => {
  if (!label || !componentId) {
    return null;
  }
  const slug = label
    .toLowerCase()
    .trim()
    .replace(/[^a-zA-Z0-9]+/g, "_")
    .replace(/^_/, "")
    .replace(/_$/, "");
  return `tg_am_${slug}_${componentId}`;
};
const getElId = (section, el) => {
  if (el instanceof SVGElement || el instanceof HTMLElement) {
    const id = el.dataset[dataSetKeyBySection[section]];
    if (typeof id === "string") {
      return id;
    }
  }
};
const randomAlphabet =
  "Kof9rU0THlAjkaOsMvxtXPwuDYJiCEBR3hnW8yNd427S1gGmqV5pZQeIzF6bLc";
const randomIdCharCount = 26;
const generateRandomId = (charCount = randomIdCharCount) => {
  let id = "";
  let values = crypto.getRandomValues(new Uint8Array(charCount));
  for (let n = 0; n < charCount - 2; n++) {
    id += randomAlphabet[61 & values[n]];
  }
  id += /* @__PURE__ */ new Date()
    .getMilliseconds()
    .toString(36)
    .padStart(2, "0");
  return id;
};
const asInt = (input, defaultValue = 0) => {
  if (typeof input === "number") {
    return Math.round(input);
  } else if (typeof input === "string") {
    const parsed = parseInt(input, 10);
    return isNaN(parsed) ? defaultValue : parsed;
  }
  return defaultValue;
};
const getWpAdminBarHeight = () => {
  return asInt(
    getComputedStyle(document.documentElement).getPropertyValue(
      "--wp-admin--admin-bar--height",
    ),
    document.getElementById("wpadminbar")?.getBoundingClientRect().height ?? 0,
  );
};
const tippyAdminProps = () => {
  const headerHeight = getWpAdminBarHeight();
  const safe = { top: headerHeight + 6, right: 0, bottom: 0, left: 0 };
  return {
    popperOptions: {
      modifiers: [
        { name: "preventOverflow", options: { padding: safe } },
        { name: "flip", options: { padding: safe } },
      ],
    },
  };
};
const adminTippy = (target, props) => {
  const tippyInstance = tippy(target, { ...tippyAdminProps(), ...props });
  setTimeout(() => {
    requestAnimationFrame(() => tippyInstance.popperInstance?.update());
  });
  return tippyInstance;
};
const h = (tag, props, children) => {
  const element = document.createElement(tag);
  if (props) {
    for (const [name, value] of Object.entries(props)) {
      element[name] = value;
    }
  }
  if (children) {
    for (let child of children) {
      if (child) {
        if (typeof child === "function") {
          const resolved = child(element);
          child = resolved;
        }
        if (typeof child === "string") {
          const textNode = document.createTextNode(child);
          element.appendChild(textNode);
        } else {
          element.appendChild(child);
        }
      }
    }
  }
  return element;
};
const fragment = (children) => {
  const fragment2 = document.createDocumentFragment();
  for (const child of children ?? []) {
    fragment2.appendChild(
      typeof child === "string" ? document.createTextNode(child) : child,
    );
  }
  return fragment2;
};
function stagger(items) {
  const mid = Math.ceil(items.length / 2);
  const col1 = items.slice(0, mid);
  const col2 = items.slice(mid);
  const result = [];
  for (let i = 0; i < col1.length; i++) {
    result.push(col1[i]);
    if (col2[i] !== void 0) {
      result.push(col2[i]);
    }
  }
  return result;
}
const camelCaseToDash = (input) => {
  return input.replace(/[A-Z]/g, ([m]) => `-${m.toLowerCase()}`);
};
let ctx;
const normalizedColors = /* @__PURE__ */ new Map();
const toHex = (n) => n.toString(16).padStart(2, "0");
const normalizeColor = (color) => {
  let normalized = normalizedColors.get(color);
  if (normalized) {
    return normalized;
  }
  ctx ??= document.createElement("canvas").getContext("2d");
  ctx.clearRect(0, 0, 1, 1);
  ctx.fillStyle = color;
  ctx.fillRect(0, 0, 1, 1);
  const { data } = ctx.getImageData(0, 0, 1, 1);
  const [r, g, b] = data;
  normalized = `#${toHex(r)}${toHex(g)}${toHex(b)}`;
  normalizedColors.set(color, normalized);
  return normalized;
};

const themeIds = [
  "neutral",
  "sky_blue",
  "coralline",
  "iris",
  "mustard",
  "forest",
  "bubblegum",
  "neo_brutalist",
];
const isCustomThemeId = (input) => {
  return typeof input === "string" && /^theme-\w+$/.test(input);
};
const isThemeId = (input) => {
  return themeIds.includes(input) || isCustomThemeId(input);
};
const validateThemeId = (isPro, themeId) => {
  {
    return proThemeIds.includes(themeId) || isCustomThemeId(themeId)
      ? defaultThemeId
      : themeId;
  }
};
const getThemeClass = (themeId) => {
  return isCustomThemeId(themeId)
    ? `tg_am_theme_custom_${themeId.slice(6)}`
    : `tg_am_theme_${themeId}`;
};
const getCustomThemeStyleId = (themeId) =>
  `tg_am_style_custom_${themeId.replace(/-/g, "_")}`;
const isTheme = (input) => {
  return (
    isRecord(input) && isThemeId(input.id) && typeof input.title === "string"
  );
};
const themesById = {
  neutral: { id: "neutral", title: "Neutral" },
  sky_blue: { id: "sky_blue", title: "Sky Blue" },
  coralline: { id: "coralline", title: "Coralline" },
  iris: { id: "iris", title: "Iris" },
  mustard: { id: "mustard", title: "Mustard" },
  forest: { id: "forest", title: "Forest" },
  bubblegum: { id: "bubblegum", title: "Bubblegum" },
  neo_brutalist: { id: "neo_brutalist", title: "Neo Brutalist" },
};
const proThemeIds = [
  "forest",
  "coralline",
  "iris",
  "bubblegum",
  "neo_brutalist",
];
const defaultThemeId = "neutral";
const customThemeItems = [
  "regionBackgroundColor",
  "regionForegroundColor",
  "regionBorderColor",
  "regionHoverBackgroundColor",
  "regionHoverForegroundColor",
  "regionTooltipBackgroundColor",
  "regionTooltipForegroundColor",
  "regionHighlightBorderColor",
  "regionHighlightForegroundColor",
  "outlineBorderColor",
  "shadowColor",
  "shadowWidth",
  "pinOuterColor",
  "pinOuterStroke",
  "pinOuterStrokeWidth",
  "pinInnerColor",
  "pinInnerStroke",
  "pinInnerStrokeWidth",
];
const isCustomThemeDefinition = (input) => {
  if (!isRecord(input)) {
    return false;
  }
  for (const item of customThemeItems) {
    if (item in input && typeof input[item] !== "string") {
      return false;
    }
  }
  return true;
};
const isCustomTheme = (input) => {
  return (
    isRecord(input) &&
    isCustomThemeDefinition(input.definition) &&
    isTheme(input)
  );
};
const generateCustomThemeId = () => {
  return "theme-" + generateRandomId(20);
};
const white = "#ffffff";
const black = "#000000";
const newCustomTheme = (title) => {
  return {
    title,
    id: generateCustomThemeId(),
    definition: {
      regionBackgroundColor: white,
      regionBorderColor: black,
      regionHoverBackgroundColor: black,
      regionHoverForegroundColor: white,
      regionHighlightBorderColor: black,
      regionHighlightForegroundColor: white,
      pinOuterColor: black,
      pinInnerColor: white,
    },
  };
};
const customThemeToCssRule = (theme) => {
  const className = getThemeClass(theme.id);
  const defaultTheme2 = newCustomTheme("__default");
  let css = `.${className},.tippy-box[data-theme~="${className}"]{`;
  const td = theme.definition;
  const dd = defaultTheme2.definition;
  let shadowColor;
  let shadowWidth;
  for (const item of /* @__PURE__ */ new Set([
    ...Object.keys(td),
    ...Object.keys(dd),
  ])) {
    let value = td[item] ?? dd[item];
    if (typeof value !== "string" || !value) {
      continue;
    }
    if (/Width$/.test(item)) {
      value += "px";
    }
    if (item === "shadowColor") {
      shadowColor = value;
      continue;
    }
    if (item === "shadowWidth") {
      shadowWidth = value;
      continue;
    }
    css += `--tg-am-theme-${camelCaseToDash(item)}:${value};`;
  }
  if (shadowColor) {
    const px = parseInt(shadowWidth ?? "0", 10);
    if (!isNaN(px) && px > 0) {
      let filter = "";
      for (let i = 0; i < px; ++i) {
        filter += ` drop-shadow(1px 1px 0 ${shadowColor})`;
      }
      css += `--tg-am-theme-outline-filter:${filter.slice(1)};`;
    }
  }
  css += "}";
  return css;
};

const pinShapes = ["circle", "icon"];
const isPinShape = (input) => {
  return pinShapes.includes(input);
};
const pinShapeDescriptors = {
  circle: { text: "Circle" },
  icon: { text: "Icon" },
};
const defaultPinShape = "circle";

const isPro = false;
const proFeatureIds = [
  "max_pins",
  "hover_effects",
  "centered_tooltip",
  "interactive_tooltip",
  "theme",
  "pin_shape",
  "map",
  "rich_text",
  "theme_editor",
  "state_labels",
  "custom_regions",
  "region_colors",
];
const isProFeatureId = (input) => {
  return proFeatureIds.includes(input);
};
const setIsProFeature = () => {
  setContext("isProFeature", true);
};
const isProFeature = () => {
  const contextValue = getContext("isProFeature");
  return typeof contextValue === "boolean" ? contextValue : false;
};
const proFeatureToData = (proFeature) => {
  return proFeature?.id
    ? proFeature.id + (proFeature.params ? `:${proFeature.params}` : "")
    : null;
};
const proOptions = (options) => {
  return {
    templateResult: (data) => {
      if (data.disabled) {
        const proFeature = options?.proFeatureForId?.(data);
        const proData = proFeatureToData(proFeature);
        const spread = options?.spread ?? proFeature?.spread ?? true;
        const container = h("div", {}, [
          h("div", { className: "tg_am_pro_body" }, [data.text]),
          h("div", { className: "tg_am_pro_tag" }),
        ]);
        if (proFeature && proData) {
          container.dataset.tgAmPro = proData;
        }
        container.classList.add("tg_am_pro_container");
        if (spread) {
          container.classList.add("tg_am_pro_container_spread");
        } else {
          container.classList.add("tg_am_pro_container_static");
        }
        return container;
      }
      return data.text;
    },
  };
};

const __variableDynamicImportRuntimeHelper = (glob$1, path$13, segs) => {
  const v = glob$1[path$13];
  if (v) return typeof v === "function" ? v() : Promise.resolve(v);
  return new Promise((_, reject) => {
    (typeof queueMicrotask === "function" ? queueMicrotask : setTimeout)(
      reject.bind(
        null,
        /* @__PURE__ */ new Error(
          "Unknown variable dynamic import: " +
            path$13 +
            (path$13.split("/").length !== segs
              ? ". Note that variables only represent file names one level deep."
              : ""),
        ),
      ),
    );
  });
};

const projectionsByMapCode = {
  us: geoAlbersUsaTerritories(),
  europe: geoConicConformal().rotate([-20, 0]).center([0, 52]),
  world: geoNaturalEarth1(),
};
const mapDataCache = /* @__PURE__ */ new Map();
const loadMapData = async (mapCode) => {
  if (mapDataCache.has(mapCode)) {
    return mapDataCache.get(mapCode);
  }
  if (!isEssentialMapCode(mapCode)) {
    return null;
  }
  let topology;
  if (isUsStateMapCode(mapCode)) {
    const file = `${usStatesByMapCode[mapCode].alphaCode.toLowerCase()}`;
    topology = (
      await __variableDynamicImportRuntimeHelper(
        /* #__PURE__ */ Object.assign({
          "../assets/geodata/countries/us/ak.ts": () =>
            import("./tg-am-ak-CCe7piSP-5.js"),
          "../assets/geodata/countries/us/al.ts": () =>
            import("./tg-am-al-CCjmg-pdMg.js"),
          "../assets/geodata/countries/us/ar.ts": () =>
            import("./tg-am-ar-CC-VRJFg-_.js"),
          "../assets/geodata/countries/us/as.ts": () =>
            import("./tg-am-as-CBCzZ8LbX-.js"),
          "../assets/geodata/countries/us/az.ts": () =>
            import("./tg-am-az-CIXmnng_0Q.js"),
          "../assets/geodata/countries/us/ca.ts": () =>
            import("./tg-am-ca-CDZzxJXjcp.js"),
          "../assets/geodata/countries/us/co.ts": () =>
            import("./tg-am-co-CBSO1YnSko.js"),
          "../assets/geodata/countries/us/ct.ts": () =>
            import("./tg-am-ct-CCtiTbHBND.js"),
          "../assets/geodata/countries/us/dc.ts": () =>
            import("./tg-am-dc-C6O5lxl3gZ.js"),
          "../assets/geodata/countries/us/de.ts": () =>
            import("./tg-am-de-CCVg838OWm.js"),
          "../assets/geodata/countries/us/fl.ts": () =>
            import("./tg-am-fl-CDtkDdy2bO.js"),
          "../assets/geodata/countries/us/ga.ts": () =>
            import("./tg-am-ga-CBbI-EoiN2.js"),
          "../assets/geodata/countries/us/gu.ts": () =>
            import("./tg-am-gu-CCmyNceM9-.js"),
          "../assets/geodata/countries/us/hi.ts": () =>
            import("./tg-am-hi-CCQKHTuL-s.js"),
          "../assets/geodata/countries/us/ia.ts": () =>
            import("./tg-am-ia-CB-L3NbeuD.js"),
          "../assets/geodata/countries/us/id.ts": () =>
            import("./tg-am-id-CDSDhO7eEH.js"),
          "../assets/geodata/countries/us/il.ts": () =>
            import("./tg-am-il-CDsFL1esKj.js"),
          "../assets/geodata/countries/us/in.ts": () =>
            import("./tg-am-in-ClbDYKsBFh.js"),
          "../assets/geodata/countries/us/ks.ts": () =>
            import("./tg-am-ks-CPwCIDz670.js"),
          "../assets/geodata/countries/us/ky.ts": () =>
            import("./tg-am-ky-CDhnRAFWRj.js"),
          "../assets/geodata/countries/us/la.ts": () =>
            import("./tg-am-la-CB9e6laiQq.js"),
          "../assets/geodata/countries/us/ma.ts": () =>
            import("./tg-am-ma-CC_KARCb8i.js"),
          "../assets/geodata/countries/us/md.ts": () =>
            import("./tg-am-md-CC2UeO0iUd.js"),
          "../assets/geodata/countries/us/me.ts": () =>
            import("./tg-am-me-CBCdmTzZ5Q.js"),
          "../assets/geodata/countries/us/mi.ts": () =>
            import("./tg-am-mi-CcBq-yxoIZ.js"),
          "../assets/geodata/countries/us/mn.ts": () =>
            import("./tg-am-mn-CC0iBSYQQq.js"),
          "../assets/geodata/countries/us/mo.ts": () =>
            import("./tg-am-mo-CDVNbndMzy.js"),
          "../assets/geodata/countries/us/mp.ts": () =>
            import("./tg-am-mp-CC9CgVQcO7.js"),
          "../assets/geodata/countries/us/ms.ts": () =>
            import("./tg-am-ms-CCpuupwT4p.js"),
          "../assets/geodata/countries/us/mt.ts": () =>
            import("./tg-am-mt-CD6nGg49hm.js"),
          "../assets/geodata/countries/us/nc.ts": () =>
            import("./tg-am-nc-CMq6A02Pnc.js"),
          "../assets/geodata/countries/us/nd.ts": () =>
            import("./tg-am-nd-CDxP9R_kVn.js"),
          "../assets/geodata/countries/us/ne.ts": () =>
            import("./tg-am-ne-Catrb8bO7c.js"),
          "../assets/geodata/countries/us/nh.ts": () =>
            import("./tg-am-nh-C3LNucl66y.js"),
          "../assets/geodata/countries/us/nj.ts": () =>
            import("./tg-am-nj-CDB3kRsKhA.js"),
          "../assets/geodata/countries/us/nm.ts": () =>
            import("./tg-am-nm-CTIR1sl745.js"),
          "../assets/geodata/countries/us/nv.ts": () =>
            import("./tg-am-nv-CDK0cPYN4G.js"),
          "../assets/geodata/countries/us/ny.ts": () =>
            import("./tg-am-ny-CBkiEBMvSV.js"),
          "../assets/geodata/countries/us/oh.ts": () =>
            import("./tg-am-oh-CfCKJesaOc.js"),
          "../assets/geodata/countries/us/ok.ts": () =>
            import("./tg-am-ok-CC5eGuLmSu.js"),
          "../assets/geodata/countries/us/or.ts": () =>
            import("./tg-am-or-C-XR4OpKqV.js"),
          "../assets/geodata/countries/us/pa.ts": () =>
            import("./tg-am-pa-C2QqgNbrzO.js"),
          "../assets/geodata/countries/us/pr.ts": () =>
            import("./tg-am-pr-CBj_VF-nJO.js"),
          "../assets/geodata/countries/us/ri.ts": () =>
            import("./tg-am-ri-CKUU97fpjt.js"),
          "../assets/geodata/countries/us/sc.ts": () =>
            import("./tg-am-sc-CDj2ZMR0Fo.js"),
          "../assets/geodata/countries/us/sd.ts": () =>
            import("./tg-am-sd-CC3Xgi1aWe.js"),
          "../assets/geodata/countries/us/tn.ts": () =>
            import("./tg-am-tn-CCG-KuTeIe.js"),
          "../assets/geodata/countries/us/tx.ts": () =>
            import("./tg-am-tx-C1AW2rfskS.js"),
          "../assets/geodata/countries/us/ut.ts": () =>
            import("./tg-am-ut-CzARNe8c8F.js"),
          "../assets/geodata/countries/us/va.ts": () =>
            import("./tg-am-va-CtsWkFfQ8D.js"),
          "../assets/geodata/countries/us/vi.ts": () =>
            import("./tg-am-vi-CP7K-6BHR4.js"),
          "../assets/geodata/countries/us/vt.ts": () =>
            import("./tg-am-vt-CC4VsJ1WcU.js"),
          "../assets/geodata/countries/us/wa.ts": () =>
            import("./tg-am-wa-CvvvW6L_Ny.js"),
          "../assets/geodata/countries/us/wi.ts": () =>
            import("./tg-am-wi-CCsC_sMSBd.js"),
          "../assets/geodata/countries/us/wv.ts": () =>
            import("./tg-am-wv-CD2HOJf-1y.js"),
          "../assets/geodata/countries/us/wy.ts": () =>
            import("./tg-am-wy-Ck5CH7Ah6M.js"),
        }),
        `../assets/geodata/countries/us/${file}.ts`,
        6,
      )
    ).topology;
  } else if (isCountryMapCode(mapCode)) {
    topology = (
      await __variableDynamicImportRuntimeHelper(
        /* #__PURE__ */ Object.assign({
          "../assets/geodata/countries/ad.ts": () =>
            import("./tg-am-ad-CCtnbLpP_Y.js"),
          "../assets/geodata/countries/ae.ts": () =>
            import("./tg-am-ae-CDmALLI6g0.js"),
          "../assets/geodata/countries/af.ts": () =>
            import("./tg-am-af-CDsYaeWyj4.js"),
          "../assets/geodata/countries/ag.ts": () =>
            import("./tg-am-ag-CBTtUMf-Gc.js"),
          "../assets/geodata/countries/al.ts": () =>
            import("./tg-am-al-C6Wg-5wuqK.js"),
          "../assets/geodata/countries/am.ts": () =>
            import("./tg-am-am-CDaMbZgVDW.js"),
          "../assets/geodata/countries/ao.ts": () =>
            import("./tg-am-ao-CN3UggdjBm.js"),
          "../assets/geodata/countries/ar.ts": () =>
            import("./tg-am-ar-CTt_sNMNQa.js"),
          "../assets/geodata/countries/at.ts": () =>
            import("./tg-am-at-CDfDSz0iiX.js"),
          "../assets/geodata/countries/au.ts": () =>
            import("./tg-am-au-CDZu-HhZPg.js"),
          "../assets/geodata/countries/az.ts": () =>
            import("./tg-am-az-CBpbtThe1b.js"),
          "../assets/geodata/countries/ba.ts": () =>
            import("./tg-am-ba-CDg2fpCXyI.js"),
          "../assets/geodata/countries/bb.ts": () =>
            import("./tg-am-bb-CDbqTkzBDQ.js"),
          "../assets/geodata/countries/bd.ts": () =>
            import("./tg-am-bd-CD7cpoPOyB.js"),
          "../assets/geodata/countries/be.ts": () =>
            import("./tg-am-be-CBBFSehw56.js"),
          "../assets/geodata/countries/bf.ts": () =>
            import("./tg-am-bf-CBZ8zfPVL5.js"),
          "../assets/geodata/countries/bg.ts": () =>
            import("./tg-am-bg-C0Z0Ur0X8R.js"),
          "../assets/geodata/countries/bh.ts": () =>
            import("./tg-am-bh-Ch13lBXinF.js"),
          "../assets/geodata/countries/bi.ts": () =>
            import("./tg-am-bi-CCBrV6FPKR.js"),
          "../assets/geodata/countries/bj.ts": () =>
            import("./tg-am-bj-CCnv2B3_oB.js"),
          "../assets/geodata/countries/bn.ts": () =>
            import("./tg-am-bn-CCPx4ND5KX.js"),
          "../assets/geodata/countries/bo.ts": () =>
            import("./tg-am-bo-CVOTOkcLCw.js"),
          "../assets/geodata/countries/br.ts": () =>
            import("./tg-am-br-CIVfYK_9KT.js"),
          "../assets/geodata/countries/bs.ts": () =>
            import("./tg-am-bs-CCaaf_xZr-.js"),
          "../assets/geodata/countries/bt.ts": () =>
            import("./tg-am-bt-CB-4Refq6E.js"),
          "../assets/geodata/countries/bw.ts": () =>
            import("./tg-am-bw-CD-gnrFK6a.js"),
          "../assets/geodata/countries/by.ts": () =>
            import("./tg-am-by-CDi1S4qw8l.js"),
          "../assets/geodata/countries/bz.ts": () =>
            import("./tg-am-bz-CD6-heHZUu.js"),
          "../assets/geodata/countries/ca.ts": () =>
            import("./tg-am-ca-CDH0DGtQqD.js"),
          "../assets/geodata/countries/cd.ts": () =>
            import("./tg-am-cd-CCDj2TgsAQ.js"),
          "../assets/geodata/countries/cf.ts": () =>
            import("./tg-am-cf-CTJ6wpwRma.js"),
          "../assets/geodata/countries/cg.ts": () =>
            import("./tg-am-cg-CCiRAFx9GD.js"),
          "../assets/geodata/countries/ch.ts": () =>
            import("./tg-am-ch-Cj947t3mKe.js"),
          "../assets/geodata/countries/ci.ts": () =>
            import("./tg-am-ci-CDp9O1OFQ5.js"),
          "../assets/geodata/countries/ck.ts": () =>
            import("./tg-am-ck-CCX4w2mfDi.js"),
          "../assets/geodata/countries/cl.ts": () =>
            import("./tg-am-cl-CCbwQ9LKj2.js"),
          "../assets/geodata/countries/cm.ts": () =>
            import("./tg-am-cm-CFhUYwIFKg.js"),
          "../assets/geodata/countries/cn.ts": () =>
            import("./tg-am-cn-CBmldqmJUR.js"),
          "../assets/geodata/countries/co.ts": () =>
            import("./tg-am-co-CBTjnPhBTA.js"),
          "../assets/geodata/countries/cr.ts": () =>
            import("./tg-am-cr-CB-uKSiHwc.js"),
          "../assets/geodata/countries/cu.ts": () =>
            import("./tg-am-cu-CBjugw8Xin.js"),
          "../assets/geodata/countries/cv.ts": () =>
            import("./tg-am-cv-CC8iNMe1-w.js"),
          "../assets/geodata/countries/cy.ts": () =>
            import("./tg-am-cy-CByCxRlvLK.js"),
          "../assets/geodata/countries/cz.ts": () =>
            import("./tg-am-cz-CDuaRNzVWo.js"),
          "../assets/geodata/countries/de.ts": () =>
            import("./tg-am-de-CCa4gntXia.js"),
          "../assets/geodata/countries/dj.ts": () =>
            import("./tg-am-dj-CB0bWY-PfV.js"),
          "../assets/geodata/countries/dk.ts": () =>
            import("./tg-am-dk-CDo00hUSaF.js"),
          "../assets/geodata/countries/dm.ts": () =>
            import("./tg-am-dm-CC859SrATA.js"),
          "../assets/geodata/countries/do.ts": () =>
            import("./tg-am-do-CDxfnnDcOL.js"),
          "../assets/geodata/countries/dz.ts": () =>
            import("./tg-am-dz-CCkN68Kdxt.js"),
          "../assets/geodata/countries/ec.ts": () =>
            import("./tg-am-ec-Ce-2ZCY1l_.js"),
          "../assets/geodata/countries/ee.ts": () =>
            import("./tg-am-ee-CDXIURP5fN.js"),
          "../assets/geodata/countries/eg.ts": () =>
            import("./tg-am-eg-CDy1ewYt63.js"),
          "../assets/geodata/countries/er.ts": () =>
            import("./tg-am-er-CDFkgidnYC.js"),
          "../assets/geodata/countries/es.ts": () =>
            import("./tg-am-es-CCiIMs-Out.js"),
          "../assets/geodata/countries/et.ts": () =>
            import("./tg-am-et-CDbL0pyPtR.js"),
          "../assets/geodata/countries/fi.ts": () =>
            import("./tg-am-fi-CBMxDUUVdk.js"),
          "../assets/geodata/countries/fj.ts": () =>
            import("./tg-am-fj-CCQPPbwqnC.js"),
          "../assets/geodata/countries/fm.ts": () =>
            import("./tg-am-fm-CCSK1v1PLu.js"),
          "../assets/geodata/countries/fr.ts": () =>
            import("./tg-am-fr-CC3ByZ42Pm.js"),
          "../assets/geodata/countries/ga.ts": () =>
            import("./tg-am-ga-CCWGe2dfyK.js"),
          "../assets/geodata/countries/gd.ts": () =>
            import("./tg-am-gd-CiBHUFC60m.js"),
          "../assets/geodata/countries/ge.ts": () =>
            import("./tg-am-ge-Clg15vtouK.js"),
          "../assets/geodata/countries/gh.ts": () =>
            import("./tg-am-gh-CDwMcFaQ9x.js"),
          "../assets/geodata/countries/gm.ts": () =>
            import("./tg-am-gm-CNb3nIHayA.js"),
          "../assets/geodata/countries/gn.ts": () =>
            import("./tg-am-gn-CDqE1E5Anx.js"),
          "../assets/geodata/countries/gq.ts": () =>
            import("./tg-am-gq-CChmQdCF8G.js"),
          "../assets/geodata/countries/gr.ts": () =>
            import("./tg-am-gr-CCkqqAzZ2_.js"),
          "../assets/geodata/countries/gt.ts": () =>
            import("./tg-am-gt-CDPo_TkrA1.js"),
          "../assets/geodata/countries/gw.ts": () =>
            import("./tg-am-gw-CVxbmjPdqE.js"),
          "../assets/geodata/countries/gy.ts": () =>
            import("./tg-am-gy-CBEv_gghmr.js"),
          "../assets/geodata/countries/hn.ts": () =>
            import("./tg-am-hn-CChp5pfhoo.js"),
          "../assets/geodata/countries/hr.ts": () =>
            import("./tg-am-hr-CDGAA3ewUH.js"),
          "../assets/geodata/countries/ht.ts": () =>
            import("./tg-am-ht-CDKeddHZOJ.js"),
          "../assets/geodata/countries/hu.ts": () =>
            import("./tg-am-hu-C5c9t5aEnr.js"),
          "../assets/geodata/countries/id.ts": () =>
            import("./tg-am-id-CoQj31duRJ.js"),
          "../assets/geodata/countries/ie.ts": () =>
            import("./tg-am-ie-CBHgM9xQEw.js"),
          "../assets/geodata/countries/il.ts": () =>
            import("./tg-am-il-CCpfLy6FIr.js"),
          "../assets/geodata/countries/in.ts": () =>
            import("./tg-am-in-CC2Ek65g2B.js"),
          "../assets/geodata/countries/iq.ts": () =>
            import("./tg-am-iq-CT09ZHa-ff.js"),
          "../assets/geodata/countries/ir.ts": () =>
            import("./tg-am-ir-CBCrzT5Y-D.js"),
          "../assets/geodata/countries/is.ts": () =>
            import("./tg-am-is-CBe01jVD-a.js"),
          "../assets/geodata/countries/it.ts": () =>
            import("./tg-am-it-CC_i1wCKdS.js"),
          "../assets/geodata/countries/jm.ts": () =>
            import("./tg-am-jm-CDv2pyv1CQ.js"),
          "../assets/geodata/countries/jo.ts": () =>
            import("./tg-am-jo-CBwMun2Pej.js"),
          "../assets/geodata/countries/jp.ts": () =>
            import("./tg-am-jp-CChkc2XLoX.js"),
          "../assets/geodata/countries/ke.ts": () =>
            import("./tg-am-ke-CBlOKYlx-Y.js"),
          "../assets/geodata/countries/kg.ts": () =>
            import("./tg-am-kg-CC6RbJ8RPd.js"),
          "../assets/geodata/countries/kh.ts": () =>
            import("./tg-am-kh-CF9td0HLOJ.js"),
          "../assets/geodata/countries/ki.ts": () =>
            import("./tg-am-ki-CBCTtaDRpK.js"),
          "../assets/geodata/countries/km.ts": () =>
            import("./tg-am-km-CGjGyCuNOH.js"),
          "../assets/geodata/countries/kn.ts": () =>
            import("./tg-am-kn-Carg9UHKKe.js"),
          "../assets/geodata/countries/kp.ts": () =>
            import("./tg-am-kp-CFUsQOkIAZ.js"),
          "../assets/geodata/countries/kr.ts": () =>
            import("./tg-am-kr-CDeNwaj9U5.js"),
          "../assets/geodata/countries/kw.ts": () =>
            import("./tg-am-kw-CDHOoOWOwc.js"),
          "../assets/geodata/countries/kz.ts": () =>
            import("./tg-am-kz-CCGex5VF0u.js"),
          "../assets/geodata/countries/la.ts": () =>
            import("./tg-am-la-CC-lBf1zX2.js"),
          "../assets/geodata/countries/lb.ts": () =>
            import("./tg-am-lb-CBldIElSIO.js"),
          "../assets/geodata/countries/lc.ts": () =>
            import("./tg-am-lc-CaHdM0jWRZ.js"),
          "../assets/geodata/countries/li.ts": () =>
            import("./tg-am-li-CoqtcI-Fwm.js"),
          "../assets/geodata/countries/lk.ts": () =>
            import("./tg-am-lk-CC5PJfpJDf.js"),
          "../assets/geodata/countries/lr.ts": () =>
            import("./tg-am-lr-CCg0q4GBdr.js"),
          "../assets/geodata/countries/ls.ts": () =>
            import("./tg-am-ls-CCF0uFIZ68.js"),
          "../assets/geodata/countries/lt.ts": () =>
            import("./tg-am-lt-CilgwRjPr5.js"),
          "../assets/geodata/countries/lu.ts": () =>
            import("./tg-am-lu-CCqfaTyvRK.js"),
          "../assets/geodata/countries/lv.ts": () =>
            import("./tg-am-lv-CD6Ol8Q7jZ.js"),
          "../assets/geodata/countries/ly.ts": () =>
            import("./tg-am-ly-CBMYp_nSpo.js"),
          "../assets/geodata/countries/ma.ts": () =>
            import("./tg-am-ma-CBWwBxRLbK.js"),
          "../assets/geodata/countries/mc.ts": () =>
            import("./tg-am-mc-CD67Zj_657.js"),
          "../assets/geodata/countries/md.ts": () =>
            import("./tg-am-md-CCDfBSmg4O.js"),
          "../assets/geodata/countries/me.ts": () =>
            import("./tg-am-me-CCzF5PS9xO.js"),
          "../assets/geodata/countries/mg.ts": () =>
            import("./tg-am-mg-CC9QgB7cKA.js"),
          "../assets/geodata/countries/mh.ts": () =>
            import("./tg-am-mh-CCBh0ppCJv.js"),
          "../assets/geodata/countries/mk.ts": () =>
            import("./tg-am-mk-CCq84ApRp_.js"),
          "../assets/geodata/countries/ml.ts": () =>
            import("./tg-am-ml-CqXVuVy_nP.js"),
          "../assets/geodata/countries/mm.ts": () =>
            import("./tg-am-mm-CDoJlaqXcq.js"),
          "../assets/geodata/countries/mn.ts": () =>
            import("./tg-am-mn-CCDrQrkjMJ.js"),
          "../assets/geodata/countries/mr.ts": () =>
            import("./tg-am-mr-CCe09GraO5.js"),
          "../assets/geodata/countries/mt.ts": () =>
            import("./tg-am-mt-CBuDtYpksb.js"),
          "../assets/geodata/countries/mu.ts": () =>
            import("./tg-am-mu-CCT2aHKh-R.js"),
          "../assets/geodata/countries/mv.ts": () =>
            import("./tg-am-mv-CCijK_4ttz.js"),
          "../assets/geodata/countries/mw.ts": () =>
            import("./tg-am-mw-CBPh5DJ7S6.js"),
          "../assets/geodata/countries/mx.ts": () =>
            import("./tg-am-mx-C54YWbwtY6.js"),
          "../assets/geodata/countries/my.ts": () =>
            import("./tg-am-my-CDNv1vaCo8.js"),
          "../assets/geodata/countries/mz.ts": () =>
            import("./tg-am-mz-CfHTjl6kZ3.js"),
          "../assets/geodata/countries/na.ts": () =>
            import("./tg-am-na-CCXMGcaemb.js"),
          "../assets/geodata/countries/ne.ts": () =>
            import("./tg-am-ne-CCofFWBPjt.js"),
          "../assets/geodata/countries/ng.ts": () =>
            import("./tg-am-ng-CB3fmM1Zyk.js"),
          "../assets/geodata/countries/ni.ts": () =>
            import("./tg-am-ni-C81MPmWUsj.js"),
          "../assets/geodata/countries/nl.ts": () =>
            import("./tg-am-nl-CC3e826mVz.js"),
          "../assets/geodata/countries/no.ts": () =>
            import("./tg-am-no-CB2g4yuYlD.js"),
          "../assets/geodata/countries/np.ts": () =>
            import("./tg-am-np-CBNEY2drGp.js"),
          "../assets/geodata/countries/nr.ts": () =>
            import("./tg-am-nr-CCA7sf0uIh.js"),
          "../assets/geodata/countries/nu.ts": () =>
            import("./tg-am-nu-CDLlSJLiXT.js"),
          "../assets/geodata/countries/nz.ts": () =>
            import("./tg-am-nz-CD88d4V5R8.js"),
          "../assets/geodata/countries/om.ts": () =>
            import("./tg-am-om-CC0H85CXOv.js"),
          "../assets/geodata/countries/pa.ts": () =>
            import("./tg-am-pa-CDtbs50U_Q.js"),
          "../assets/geodata/countries/pe.ts": () =>
            import("./tg-am-pe-CD2ieYU414.js"),
          "../assets/geodata/countries/pg.ts": () =>
            import("./tg-am-pg-CBYqheuU52.js"),
          "../assets/geodata/countries/ph.ts": () =>
            import("./tg-am-ph-C-0WN0yYLN.js"),
          "../assets/geodata/countries/pk.ts": () =>
            import("./tg-am-pk-CDJxxlLrZN.js"),
          "../assets/geodata/countries/pl.ts": () =>
            import("./tg-am-pl-CF29OGTuS_.js"),
          "../assets/geodata/countries/ps.ts": () =>
            import("./tg-am-ps-CBmvkkLHoH.js"),
          "../assets/geodata/countries/pt.ts": () =>
            import("./tg-am-pt-CB8ttogMNY.js"),
          "../assets/geodata/countries/pw.ts": () =>
            import("./tg-am-pw-CD0ze8D4U0.js"),
          "../assets/geodata/countries/py.ts": () =>
            import("./tg-am-py-CCjv1VjXKx.js"),
          "../assets/geodata/countries/qa.ts": () =>
            import("./tg-am-qa-CDMp7eE1Zt.js"),
          "../assets/geodata/countries/ro.ts": () =>
            import("./tg-am-ro-CD0sL8Ed6X.js"),
          "../assets/geodata/countries/rs.ts": () =>
            import("./tg-am-rs-CCaF6wMcd2.js"),
          "../assets/geodata/countries/ru.ts": () =>
            import("./tg-am-ru-CDqsVEhLcw.js"),
          "../assets/geodata/countries/rw.ts": () =>
            import("./tg-am-rw-CCUMJTOsT7.js"),
          "../assets/geodata/countries/sa.ts": () =>
            import("./tg-am-sa-CDIlWfD7MZ.js"),
          "../assets/geodata/countries/sb.ts": () =>
            import("./tg-am-sb-CBmXlxSA4i.js"),
          "../assets/geodata/countries/sc.ts": () =>
            import("./tg-am-sc-C1K09_8EAW.js"),
          "../assets/geodata/countries/sd.ts": () =>
            import("./tg-am-sd-CBLeb-svx5.js"),
          "../assets/geodata/countries/se.ts": () =>
            import("./tg-am-se-CCO9hOWKcC.js"),
          "../assets/geodata/countries/sg.ts": () =>
            import("./tg-am-sg-CDTYT1SqNK.js"),
          "../assets/geodata/countries/si.ts": () =>
            import("./tg-am-si-CDY1AJE_Sp.js"),
          "../assets/geodata/countries/sk.ts": () =>
            import("./tg-am-sk-CDiPhbLfhy.js"),
          "../assets/geodata/countries/sl.ts": () =>
            import("./tg-am-sl-CDa7N-RVaT.js"),
          "../assets/geodata/countries/sm.ts": () =>
            import("./tg-am-sm-CDY9rkzszg.js"),
          "../assets/geodata/countries/sn.ts": () =>
            import("./tg-am-sn-CDA5fy9vUa.js"),
          "../assets/geodata/countries/so.ts": () =>
            import("./tg-am-so-CQBd91JpWR.js"),
          "../assets/geodata/countries/sr.ts": () =>
            import("./tg-am-sr-CCg5nx2qA1.js"),
          "../assets/geodata/countries/ss.ts": () =>
            import("./tg-am-ss-CC5fHujy-y.js"),
          "../assets/geodata/countries/st.ts": () =>
            import("./tg-am-st-CBPiP8jJp-.js"),
          "../assets/geodata/countries/sv.ts": () =>
            import("./tg-am-sv-CBj9zNSeoi.js"),
          "../assets/geodata/countries/sy.ts": () =>
            import("./tg-am-sy-CDWNCkDM4P.js"),
          "../assets/geodata/countries/sz.ts": () =>
            import("./tg-am-sz-CDDhrEGeYx.js"),
          "../assets/geodata/countries/td.ts": () =>
            import("./tg-am-td-CBm0cbmhiB.js"),
          "../assets/geodata/countries/tg.ts": () =>
            import("./tg-am-tg-CD21ghwFXX.js"),
          "../assets/geodata/countries/th.ts": () =>
            import("./tg-am-th-CCw4Lkghes.js"),
          "../assets/geodata/countries/tj.ts": () =>
            import("./tg-am-tj-CBQtDgZXns.js"),
          "../assets/geodata/countries/tl.ts": () =>
            import("./tg-am-tl-CC1-dILRcO.js"),
          "../assets/geodata/countries/tm.ts": () =>
            import("./tg-am-tm-CBoSNI0cAZ.js"),
          "../assets/geodata/countries/tn.ts": () =>
            import("./tg-am-tn-CKiehIir7X.js"),
          "../assets/geodata/countries/to.ts": () =>
            import("./tg-am-to-CD2WegTtN-.js"),
          "../assets/geodata/countries/tr.ts": () =>
            import("./tg-am-tr-CC6JBTxM2E.js"),
          "../assets/geodata/countries/tt.ts": () =>
            import("./tg-am-tt-CS7D-VjbHV.js"),
          "../assets/geodata/countries/tv.ts": () =>
            import("./tg-am-tv-CBswE8fQMq.js"),
          "../assets/geodata/countries/tw.ts": () =>
            import("./tg-am-tw-CCDaylrOWN.js"),
          "../assets/geodata/countries/tz.ts": () =>
            import("./tg-am-tz-CW6JcgGs7M.js"),
          "../assets/geodata/countries/ua.ts": () =>
            import("./tg-am-ua-CB9_qn_7p1.js"),
          "../assets/geodata/countries/ug.ts": () =>
            import("./tg-am-ug-CBXPlKhQfT.js"),
          "../assets/geodata/countries/uk.ts": () =>
            import("./tg-am-uk-CV3UEZEQtF.js"),
          "../assets/geodata/countries/us.ts": () =>
            import("./tg-am-us-CD1olxcarW.js"),
          "../assets/geodata/countries/uy.ts": () =>
            import("./tg-am-uy-CD8CG9Fin1.js"),
          "../assets/geodata/countries/uz.ts": () =>
            import("./tg-am-uz-CDxXvfsZFD.js"),
          "../assets/geodata/countries/va.ts": () =>
            import("./tg-am-va-CJlX25S0Di.js"),
          "../assets/geodata/countries/vc.ts": () =>
            import("./tg-am-vc-C6n2wLaaDy.js"),
          "../assets/geodata/countries/ve.ts": () =>
            import("./tg-am-ve-CCTaTgd76C.js"),
          "../assets/geodata/countries/vn.ts": () =>
            import("./tg-am-vn-ChD2mMi5mv.js"),
          "../assets/geodata/countries/vu.ts": () =>
            import("./tg-am-vu-CCS_xwl657.js"),
          "../assets/geodata/countries/ws.ts": () =>
            import("./tg-am-ws-CBLjNkD8h4.js"),
          "../assets/geodata/countries/ye.ts": () =>
            import("./tg-am-ye-CDpYH66eJL.js"),
          "../assets/geodata/countries/za.ts": () =>
            import("./tg-am-za-CDSvY8sP4A.js"),
          "../assets/geodata/countries/zm.ts": () =>
            import("./tg-am-zm-CD5FEkyIR3.js"),
          "../assets/geodata/countries/zw.ts": () =>
            import("./tg-am-zw-CCnUTVWOnH.js"),
        }),
        `../assets/geodata/countries/${mapCode}.ts`,
        5,
      )
    ).topology;
  } else {
    topology = (
      await __variableDynamicImportRuntimeHelper(
        /* #__PURE__ */ Object.assign({
          "../assets/geodata/areas/europe.ts": () =>
            import("./tg-am-europe-CsaR3xGQeF.js"),
          "../assets/geodata/areas/world.ts": () =>
            import("./tg-am-world-CBeweCq9be.js"),
        }),
        `../assets/geodata/areas/${mapCode}.ts`,
        5,
      )
    ).topology;
  }
  const { regions } = topology.objects;
  const properties = {};
  if (regions) {
    for (const { properties: p } of regions.geometries) {
      if (!p) {
        continue;
      }
      const { name, regionId } = p;
      if (typeof regionId === "string" && typeof name === "string") {
        properties[regionId] = { regionId, name };
      }
    }
  }
  const mapData = { topology, properties };
  mapDataCache.set(mapCode, mapData);
  return mapData;
};
const projectionForMapCode = (mapCode) => {
  return projectionsByMapCode[mapCode] ?? geoMercator();
};

const tooltipTypes = [
  "default",
  "region_name",
  "pin_name",
  "custom_text",
  "none",
];
const isTooltipType = (input) => {
  return tooltipTypes.includes(input);
};
const getTooltipTypesForSection = (section) => {
  switch (section) {
    case "regions":
      return ["default", "region_name", "custom_text", "none"];
    case "pins":
      return ["default", "pin_name", "custom_text", "none"];
  }
};
const tooltipTypeToText = (type) => {
  switch (type) {
    case "default":
      return "Default";
    case "region_name":
      return "Region name";
    case "pin_name":
      return "Pin name";
    case "custom_text":
      return "Custom text";
    case "none":
      return "None";
  }
};
const getDefaultTooltipTypeForSection = (section) => {
  switch (section) {
    case "regions":
      return defaultRegionTooltipType;
    case "pins":
      return defaultPinTooltipType;
  }
};
const defaultRegionTooltipType = "region_name";
const defaultPinTooltipType = "pin_name";

const actionTypes = ["default", "follow_url", "none"];
const isActionType = (input) => {
  return actionTypes.includes(input);
};
const actionDescriptors = {
  default: { text: "Default" },
  none: { text: "None" },
  follow_url: { text: "Follow URL" },
};
const defaultActionType = "none";

const ecTerritoryGalapagos = {
  name: "Galápagos",
  alphaCode: "GP",
  regionIds: ["gAmbGw"],
};
const ecTerritories = [ecTerritoryGalapagos];

const esTerritoryCanaryIslands = {
  name: "Canary Islands",
  alphaCode: "CI",
  regionIds: [
    "vFXV7Q",
    // Santa Cruz de Tenerife
    "xg1G4Q",
    // Las Palmas
  ],
};
const esTerritoryBaleares = {
  name: "Baleares",
  alphaCode: "BL",
  regionIds: ["32g8kg"],
};
const esTerritoryMelilla = {
  name: "Melilla",
  alphaCode: "ML",
  regionIds: ["tpF86w"],
};
const esTerritories = [
  esTerritoryCanaryIslands,
  esTerritoryBaleares,
  esTerritoryMelilla,
];

const frTerritoryGuyaneFrancaise = {
  name: "Guyane Française",
  alphaCode: "GUF",
  regionIds: [
    "Rdelmw",
    // Guyane Française
  ],
};
const frTerritoryNewCaledonia = {
  name: "New Caledonia",
  alphaCode: "NCL",
  regionIds: [
    "Pq3lGw",
    // New Caledonia Nord
    "A-dYvA",
    // New Caledonia Sud
    "CzmXZg",
    // Îles Loyauté
  ],
};
const frTerritorySaintPierreMiquelon = {
  name: "Saint Pierre and Miquelon",
  alphaCode: "SPM",
  regionIds: [
    "jAFKWA",
    // Saint-Pierre
    "3IqCcg",
    // Miquelon-Langlade
  ],
};
const frTerritoryFrenchPolynesia = {
  name: "French Polynesia",
  alphaCode: "PYF",
  regionIds: [
    "DfB02g",
    // Tuamotu-Gambier
    "IxXPaQ",
    // Windward Islands
    "Qtj29w",
    // Leeward Islands
    "uwJHAQ",
    // Austral Islands
    "qk3C-A",
    // Marquesas Islands
  ],
};
const frTerritoryMartinique = {
  name: "Martinique",
  alphaCode: "MTQ",
  regionIds: [
    "8kuRQw",
    // Martinique
  ],
};
const frTerritoryGuadeloupe = {
  name: "Guadeloupe",
  alphaCode: "GLP",
  regionIds: [
    "cD3msQ",
    // Guadeloupe
  ],
};
const frTerritorySaintBarthelemy = {
  name: "Saint Barthélemy",
  alphaCode: "BLM",
  regionIds: [
    "OrkIvA",
    // Saint Barthélemy
  ],
};
const frTerritoryLaReunion = {
  name: "La Réunion",
  alphaCode: "REU",
  regionIds: [
    "63yzjA",
    // La Réunion
  ],
};
const frTerritoryMayotte = {
  name: "Mayotte",
  alphaCode: "MYT",
  regionIds: [
    "VOClxg",
    // Mayotte
  ],
};
const frTerritoryCorse = {
  name: "Corse",
  alphaCode: "COR",
  regionIds: [
    "XhPY7w",
    // Haute-Corse
    "R6SJaA",
    // Corse-du-Sud
  ],
};
const frTerritoryWallisFutuna = {
  name: "Wallis and Futuna",
  alphaCode: "WLF",
  regionIds: [
    "D5ydMg",
    // Sigave
    "sFu99g",
    // Alo
    "o4DxcQ",
    // Uvea
  ],
};
const frTerritories = [
  frTerritoryGuyaneFrancaise,
  frTerritoryNewCaledonia,
  frTerritorySaintPierreMiquelon,
  frTerritoryFrenchPolynesia,
  frTerritoryMartinique,
  frTerritoryGuadeloupe,
  frTerritorySaintBarthelemy,
  frTerritoryLaReunion,
  frTerritoryMayotte,
  frTerritoryCorse,
  frTerritoryWallisFutuna,
];

const noTerritorySvalbard = {
  name: "Svalbard",
  alphaCode: "SV",
  regionIds: ["D7OOLw"],
};
const noTerritories = [noTerritorySvalbard];

const nzTerritoryChathamIslands = {
  name: "Chatham Islands",
  alphaCode: "CH",
  regionIds: ["NQbVpg"],
};
const nzTerritories = [nzTerritoryChathamIslands];

const ptTerritoryAzores = {
  name: "Azores",
  alphaCode: "AZ",
  regionIds: ["KfJAgA"],
};
const ptTerritoryMadeira = {
  name: "Madeira",
  alphaCode: "MD",
  regionIds: ["UgAVCg"],
};
const ptTerritories = [ptTerritoryAzores, ptTerritoryMadeira];

const defaultUsAlphaCodes = /* @__PURE__ */ new Set([
  usStateAlaska.alphaCode,
  usStateHawaii.alphaCode,
]);
const allCustomRegions = {
  us: [
    usStateAlaska,
    usStateAmericanSamoa,
    usStateGuam,
    usStateHawaii,
    usStateMarianaIslands,
    usStatePuertoRico,
    usStateVirginIslands,
  ].map((usState) => {
    return {
      alphaCode: usState.alphaCode,
      mapCode: "us",
      regionIds: [usState.regionId],
      name: usState.name,
      isProOnly: !defaultUsAlphaCodes.has(usState.alphaCode),
      isEnabledByDefault: defaultUsAlphaCodes.has(usState.alphaCode),
    };
  }),
  fr: frTerritories.map((territory) => ({
    ...territory,
    mapCode: "fr",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
  pt: ptTerritories.map((territory) => ({
    ...territory,
    mapCode: "pt",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
  ec: ecTerritories.map((territory) => ({
    ...territory,
    mapCode: "ec",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
  es: esTerritories.map((territory) => ({
    ...territory,
    mapCode: "es",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
  no: noTerritories.map((territory) => ({
    ...territory,
    mapCode: "no",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
  nz: nzTerritories.map((territory) => ({
    ...territory,
    mapCode: "nz",
    isProOnly: true,
    isEnabledByDefault: false,
  })),
};
const allSortedCustomRegions = Object.fromEntries(
  Object.keys(allCustomRegions).map((mapCode) => [
    mapCode,
    [...allCustomRegions[mapCode]].sort((a, b) => a.name.localeCompare(b.name)),
  ]),
);
const getAllCustomRegionsEnabledByAlphaCode = (mapCode) => {
  const enabledByAlphaCode = {};
  const allRegions = Object.values(allSortedCustomRegions[mapCode]);
  for (const { alphaCode, isEnabledByDefault } of allRegions) {
    enabledByAlphaCode[alphaCode] = isEnabledByDefault;
  }
  return enabledByAlphaCode;
};
const getDisabledCustomRegionIds = (mapCode, options) => {
  const result = /* @__PURE__ */ new Set();
  const enabledByAlphaCode =
    options?.enabledByAlphaCode ??
    getAllCustomRegionsEnabledByAlphaCode(mapCode);
  for (const region of allSortedCustomRegions[mapCode]) {
    if (
      !enabledByAlphaCode[region.alphaCode] || // not enabled
      region.isProOnly
    ) {
      for (const regionId of region.regionIds) {
        result.add(regionId);
      }
    }
  }
  return result;
};
const getCustomRegionsEnabledByAlphaCode = (mapCode, options) => {
  const result = {};
  const enabledByAlphaCode =
    options?.enabledByAlphaCode ??
    getAllCustomRegionsEnabledByAlphaCode(mapCode);
  for (const region of allSortedCustomRegions[mapCode]) {
    if (enabledByAlphaCode[region.alphaCode]) {
      result[region.alphaCode] = !region.isProOnly;
    } else {
      result[region.alphaCode] = false;
    }
  }
  return result;
};

const pinIconWidth = 48;
const pinIconHeight = 48;

D3_map[FILENAME] = "src/lib/components/d3-map.svelte";

var root$2 = add_locations(from_svg(`<svg></svg>`), D3_map[FILENAME], [
  [478, 0],
]);

function D3_map($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, D3_map);

  const props = rest_props(
    $$props,
    [
      "$$slots",
      "$$events",
      "$$legacy",
      "mapCode",
      "themeId",
      "hasActions",
      "hasUsStateLabels",
      "usStateLabelSizePixels",
      "onLoad",
      "canFollowLinks",
      "mapData",
      "customRegions",
      "defaults",
      "onFollowLink",
    ],
    "props",
  );

  const hasHoverEffects = tag(
    user_derived(() => isPro),
    "hasHoverEffects",
  );
  const projection = tag(
    user_derived(() => projectionForMapCode($$props.mapCode)),
    "projection",
  );
  let svgRef = tag(state(void 0), "svgRef");
  const namesByRegionId = tag_proxy(proxy({}), "namesByRegionId");
  const statesByRegionId = tag_proxy(proxy({}), "statesByRegionId");
  let rafId = null;
  const padding = 15;
  const width = 900;
  const height = 520;

  // ---------------------------------------------------------------------------
  const getUrlById = (section, id) => {
    if (!id) {
      return;
    }

    let type = props[section]?.actions?.types?.[id];
    let isDefaultType = false;

    if (!type || strict_equals(type, "default")) {
      isDefaultType = true;
      type =
        $$props.defaults?.[section]?.actions?.types?.__default ??
        defaultActionType;
    }

    if (strict_equals(type, "follow_url")) {
      let defaultUrl = $$props.defaults?.[section]?.actions?.urls?.__default;
      let url = props[section]?.actions?.urls?.[id];

      if (!url || strict_equals(url, "default") || isDefaultType) {
        url = defaultUrl;
      }

      if (strict_equals(typeof url, "string", false)) {
        return null;
      }

      if (
        strict_equals(url[0], "#", false) &&
        strict_equals(url[0], "/", false) &&
        !/^https?:/.test(url)
      ) {
        return `https://${url}`;
      }

      return url;
    }
  };

  const followUrlById = (section, id, url) => {
    {
      location.href = url;
    }

    if ($$props.onFollowLink) {
      $$props.onFollowLink();
    }
  };

  const clearHover = () => {
    if (!get(hasHoverEffects)) {
      return;
    }

    if (strict_equals(rafId, null, false)) {
      cancelAnimationFrame(rafId);
    }

    for (const el of document.querySelectorAll(".tg_am_region_hover")) {
      el.classList.remove("tg_am_region_hover");
    }
  };

  // ---------------------------------------------------------------------------
  // Setup map
  // ---------------------------------------------------------------------------
  const getUsStateById = (id) => {
    return usStatesByNumericCode[id?.toString() ?? ""];
  };

  const getUsStateLabelClassById = (id) => {
    const usState = getUsStateById(id);

    return usState
      ? `tg_am_map_state_label_${usState.alphaCode.toLowerCase()}`
      : null;
  };

  const topoJsonFeatures = tag(
    user_derived(() => {
      const regions = $$props.mapData.topology.objects.regions;

      if (!allSortedCustomRegions[$$props.mapCode]) {
        return regions;
      }

      const disabledRegionIds = getDisabledCustomRegionIds($$props.mapCode, {
        enabledByAlphaCode: $$props.customRegions,
      });
      const geometries = [];

      for (const geometry of regions.geometries) {
        const regionId = geometry.properties?.regionId;

        if (
          strict_equals(typeof regionId, "string") &&
          !disabledRegionIds.has(regionId)
        ) {
          geometries.push(geometry);
        }
      }

      return { ...regions, geometries };
    }),
    "topoJsonFeatures",
  );

  const geoJson = tag(
    user_derived(() =>
      feature($$props.mapData.topology, get(topoJsonFeatures)),
    ),
    "geoJson",
  );

  const geoPath = tag(
    user_derived(() =>
      d3GeoPath(
        get(projection).fitExtent
          ? get(projection).fitExtent(
              [
                [padding, padding],
                [width - padding, height - padding],
              ],
              get(geoJson),
            )
          : get(projection),
      ),
    ),
    "geoPath",
  );

  const generateRegionIdValue = ({ id, properties }) => {
    const { name, regionId } = properties;

    if (
      strict_equals(typeof name, "string") &&
      strict_equals(typeof regionId, "string")
    ) {
      namesByRegionId[regionId] = name;

      if (strict_equals($$props.mapCode, "us")) {
        statesByRegionId[regionId] = usStates.find((state) =>
          strict_equals(state.numericCode, id),
        );
      }

      return regionId;
    }

    return null;
  };

  user_effect(() => {
    if (!get(svgRef)) {
      return;
    }

    get(svgRef).querySelector(".tg_am_map_outline")?.remove();

    const svg = select(get(svgRef));

    svg
      .insert("path", ":first-child")
      .datum(merge($$props.mapData.topology, get(topoJsonFeatures).geometries))
      .attr("d", get(geoPath))
      .classed("tg_am_map_outline", true);

    svg
      .selectAll("path.tg_am_map_region")
      .data(get(geoJson).features, (d) => {
        return d?.properties?.regionId;
      })
      .join(
        (enter) => enter.append("path"),
        (update) => update,
        (exit) => exit.remove(),
      )
      .attr("d", get(geoPath))
      .attr(dataAttributeBySection["regions"], generateRegionIdValue)
      .on("pointerenter", function (_, d) {
        if (!get(hasHoverEffects)) {
          return;
        }

        clearHover();

        const sel = select(this);

        rafId = requestAnimationFrame(() => {
          sel.classed("tg_am_region_hover", true);

          const stateClassName = getUsStateLabelClassById(d.id);

          if (stateClassName) {
            document
              .querySelector(`.${stateClassName}`)
              ?.classList.add("tg_am_region_hover");
          }

          rafId = null;
        });
      })
      .on("pointerleave", function (_, d) {
        if (!get(hasHoverEffects)) {
          return;
        }

        select(this).classed("tg_am_region_hover", false);

        const stateClassName = getUsStateLabelClassById(d.id);

        if (stateClassName) {
          document
            .querySelector(`.${stateClassName}`)
            ?.classList.remove("tg_am_region_hover");
        }
      })
      .classed("tg_am_map_region", true);

    if (get(hasHoverEffects)) {
      svg.on("pointerleave", clearHover);
    }

    $$props.onLoad?.();
  });

  user_effect(() => {
    if (!get(svgRef)) {
      return;
    }

    select(get(svgRef));

    {
      for (const el of get(svgRef).querySelectorAll(
        "text.tg_am_map_state_label",
      )) {
        el.remove();
      }
    }
  });

  // ---------------------------------------------------------------------------
  // Pins
  // ---------------------------------------------------------------------------
  user_effect(() => {
    if (!get(svgRef)) {
      return;
    }

    void $$props.customRegions;
    void get(projection);

    const pinData = [];

    for (const pin of Object.values($$props.pins?.details ?? {})) {
      if (!isGeoCoordinate(pin)) {
        continue;
      }

      if (pinData.length >= 1) {
        break;
      }

      const { lon, lat } = pin;
      const position = geoContains(get(geoJson), [lon, lat])
        ? get(projection)([lon, lat])
        : null;

      if (!position) {
        continue;
      }

      const shape = $$props?.pins?.shapes?.[pin.id] ?? defaultPinShape;
      const [x, y] = position;

      pinData.push({ pin, shape, x, y });
    }

    const radius = 12;

    select(get(svgRef))
      .selectAll("circle.tg_am_map_pin")
      .data(pinData, ({ pin }) => pin.id)
      .join("circle")
      .attr(dataAttributeBySection["pins"], ({ pin }) => pin.id)
      .attr("r", radius)
      .attr("cx", ({ x }) => x)
      .attr("cy", ({ y }) => y)
      .classed("tg_am_map_pin", true);
  });

  // ---------------------------------------------------------------------------
  // Add click handlers
  // ---------------------------------------------------------------------------
  user_effect(() => {
    if (!$$props.canFollowLinks || !$$props.hasActions || !get(svgRef)) {
      return;
    }

    const onClick = (event) => {
      for (const section of mapDataSections) {
        const id = getElId(section, event.target);
        const url = getUrlById(section, id);

        if (id && url) {
          followUrlById(section, id, url);

          return;
        }
      }
    };

    mapDataSections.forEach((section) => {
      const selector = `[${dataAttributeBySection[section]}]`;

      get(svgRef)
        ?.querySelectorAll(selector)
        .forEach((el) => {
          const id = getElId(section, el);
          const url = getUrlById(section, id);

          if (url) {
            el.classList.add("tg_am_clickable");
          }
        });
    });

    get(svgRef)?.addEventListener("click", onClick);

    return () => get(svgRef)?.removeEventListener("click", onClick);
  });

  // ---------------------------------------------------------------------------
  // Hover cleanup
  // ---------------------------------------------------------------------------
  user_effect(() => {
    if (!get(hasHoverEffects)) {
      return;
    }

    const onPointerOut = (event) => {
      if (strict_equals(event.relatedTarget, null)) {
        clearHover();
      }
    };

    const onVisibilityChange = () => {
      if (strict_equals(document.visibilityState, "hidden")) {
        clearHover();
      }
    };

    addEventListener("blur", clearHover);
    addEventListener("pointerout", onPointerOut);
    document.addEventListener("visibilitychange", onVisibilityChange);
  });

  var svg_1 = root$2();

  set_attribute(svg_1, "viewBox", `0 0 ${width} ${height}`);
  bind_this(
    svg_1,
    ($$value) => set(svgRef, $$value),
    () => get(svgRef),
  );
  append($$anchor, svg_1);

  return pop({ ...legacy_api() });
}

Pin_icon[FILENAME] = "src/lib/components/icons/pin-icon.svelte";

const body = wrap_snippet(Pin_icon, function ($$anchor) {
  validate_snippet_args(...arguments);

  var fragment = root_1();

  next();
  append($$anchor, fragment);
});

var root_1 = add_locations(
  from_svg(
    `<path fill="var(--tg-am-icon-outer-fill)" stroke="var(--tg-am-icon-outer-stroke)" stroke-width="var(--tg-am-icon-outer-stroke-width)" style="transition: all 0.2s" d="M24 4c-7.73 0-14 6.27-14 14 0 10.5 14 26 14 26s14-15.5 14-26c0-7.73-6.27-14-14-14zm0 19c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z"></path><circle fill="var(--tg-am-icon-inner-fill)" stroke="var(--tg-am-icon-inner-stroke)" stroke-width="var(--tg-am-icon-inner-stroke-width)" style="transition: all 0.2s" cx="24" cy="18" r="5.2"></circle>`,
    1,
  ),
  Pin_icon[FILENAME],
  [
    [34, 2],
    [41, 2],
  ],
);
var root_2 = add_locations(
  from_svg(`<svg><symbol><!></symbol></svg>`),
  Pin_icon[FILENAME],
  [[16, 2, [[17, 4]]]],
);
var root_3 = add_locations(from_svg(`<svg><!></svg>`), Pin_icon[FILENAME], [
  [22, 2],
]);

function Pin_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_icon);

  // See:
  // Google Material Design Icons
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy", "asSymbol"],
    "props",
  );

  const viewBox = `0 0 ${pinIconWidth} ${pinIconHeight}`;
  var fragment_1 = comment();
  var node = first_child(fragment_1);

  {
    var consequent = ($$anchor) => {
      var svg = root_2();

      attribute_effect(svg, () => ({ style: "display: none", ...props }));

      var symbol = child(svg);
      var node_1 = child(symbol);

      add_svelte_meta(() => body(node_1), "render", Pin_icon, 18, 6);
      reset(symbol);
      reset(svg);

      template_effect(() => {
        set_attribute(symbol, "id", $$props.asSymbol);
        set_attribute(symbol, "width", pinIconWidth);
        set_attribute(symbol, "height", pinIconHeight);
      });

      append($$anchor, svg);
    };

    var alternate = ($$anchor) => {
      var svg_1 = root_3();

      attribute_effect(svg_1, () => ({
        fill: "none",
        color: "currentColor",
        viewBox,
        style: "width: 16px",
        ...props,
      }));

      var node_2 = child(svg_1);

      add_svelte_meta(() => body(node_2), "render", Pin_icon, 29, 4);
      reset(svg_1);
      append($$anchor, svg_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if ($$props.asSymbol) $$render(consequent);
          else $$render(alternate, false);
        }),
      "if",
      Pin_icon,
      15,
      0,
    );
  }

  append($$anchor, fragment_1);

  return pop({ ...legacy_api() });
}

Map_with_data[FILENAME] = "src/lib/components/map-with-data.svelte";

var root$1 = add_locations(
  from_html(`<!> <div><!></div>`, 1),
  Map_with_data[FILENAME],
  [[434, 0]],
);

function Map_with_data($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Map_with_data);

  let themeId = prop($$props, "themeId", 7),
    element = prop($$props, "element", 15),
    props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "mapId",
        "mapData",
        "mapCode",
        "themeId",
        "customThemes",
        "hasRegionColors",
        "hasTooltips",
        "pinnedTooltipId",
        "element",
      ],
      "props",
    );

  themeId(validateThemeId(isPro, themeId()));

  const hasIconPins = tag(
    user_derived(
      () =>
        $$props.pins?.shapes &&
        Object.values($$props.pins?.shapes).includes("icon"),
    ),
    "hasIconPins",
  );
  const themeClass = tag(
    user_derived(() => getThemeClass(themeId())),
    "themeClass",
  );
  const tippyInstances = new Map();
  const defaultTooltipDuration = 150;

  const getTippyProps = (options) => {
    const { regionId, pinId } = options;
    const id = regionId ?? pinId;

    if (!id || !$$props.mapData) {
      return null;
    }

    const section = regionId ? "regions" : "pins";
    const tooltips = props[section]?.tooltips;
    const defaultTooltips = $$props.defaults?.[section]?.tooltips;
    const types = tooltips?.types ?? {};
    const defaultTypes = defaultTooltips?.types ?? {};
    const defaultType =
      defaultTypes.__default ?? getDefaultTooltipTypeForSection(section);
    let type = types[id] ?? "default";
    let isDefault = strict_equals(type, "default");

    if (isDefault) {
      type = defaultType;
    }

    if (strict_equals(type, "none")) {
      return null;
    }

    const name = (
      regionId
        ? $$props.mapData.properties[regionId]?.name
        : pinId
          ? $$props.pins?.details?.[pinId]?.name
          : null
    )?.trim();

    const isRich = false;

    let content;

    switch (type) {
      case "region_name":

      case "pin_name":
        if (!name) {
          return null;
        }
        content = name;
        break;

      case "custom_text": {
        const text = (
          isDefault
            ? defaultTooltips?.customText?.__default
            : tooltips?.customText?.[id]
        )?.trim();

        if (!text) {
          return null;
        }

        content = text;

        if (name) {
          content = content
            .replaceAll("{region-name}", name)
            .replaceAll("{pin-name}", name)
            .replaceAll(
              "{country-name}",
              mapHasCountries($$props.mapCode)
                ? name
                : (mapCodeToCountryName($$props.mapCode) ?? ""),
            );

          let usState;

          if (strict_equals($$props.mapCode, "us") && regionId) {
            usState = usStatesByRegionId[regionId];
          } else if (isUsStateMapCode($$props.mapCode)) {
            usState = usStatesByMapCode[$$props.mapCode];
          }

          if (usState) {
            content = content
              .replaceAll("{state-name}", usState.name)
              .replaceAll(
                "{state-abbreviation}",
                usState.alphaCode.toUpperCase(),
              );
          }
        } else {
          return null;
        }

        break;
      }

      case "default":
        return null;
    }

    const interactive =
      tooltips?.interactive?.[id] ??
      defaultTooltips?.interactive?.__default ??
      false;

    return {
      theme: get(themeClass),
      content: content.trim(),
      allowHTML: strict_equals(type, "custom_text") && isRich,
      interactive,
      interactiveBorder: 8,
      interactiveDebounce: 16,
      appendTo: document.body,
      hideOnClick: false,
      duration: defaultTooltipDuration,
    };
  };

  const getTippyContent = (instance) => {
    return instance.props.content.toString().trim();
  };

  const tippyHasContent = (instance) => {
    return getTippyContent(instance).length > 0;
  };

  const setupTippy = (options) => {
    const { regionId, pinId } = options;
    const id = regionId ?? pinId;

    if (!id) {
      return;
    }

    const target = options.target;
    const { content, ...allTippyProps } = getTippyProps(options) ?? {};
    let instance = tippyInstances.get(id);

    const display = (instance, content) => {
      if (content) {
        instance.setContent(content);
        instance.show();
      } else {
        instance.setContent("");
        instance.setProps({ duration: 0 });
        instance.hide();
      }

      setTimeout(() => {
        instance?.setProps({ duration: defaultTooltipDuration });
      });

      {
        instance.setProps({ getReferenceClientRect: null });
      }
    };

    if (instance) {
      if (allTippyProps) {
        instance.setProps(allTippyProps);
      }
    } else {
      const tippyProps = {
        ...allTippyProps,
        content,
        duration: 0,

        onShow(instance) {
          if (!$$props.hasTooltips || !tippyHasContent(instance)) {
            return false;
          }
        },

        onHide(instance) {
          if (
            $$props.hasTooltips &&
            strict_equals(id, $$props.pinnedTooltipId)
          ) {
            if (tippyHasContent(instance)) {
              return false;
            }
          }
        },
      };

      instance = tippy(target, tippyProps);
      tippyInstances.set(id, instance);
    }

    display(instance, content);
  };

  user_effect(() => {
    if (!element() || !$$props.hasTooltips) {
      return;
    }

    const onHover = (event) => {
      const target = event.target;

      if (
        !(target instanceof SVGElement) ||
        strict_equals(target.id, "tg_am_map_path_highlight_overlay")
      ) {
        return;
      }

      const regionId = target.dataset[dataSetKeyBySection["regions"]];
      const pinId = target.dataset[dataSetKeyBySection["pins"]];

      setupTippy({ regionId, pinId, target });
    };

    element().addEventListener("mouseover", onHover);

    return () => element()?.removeEventListener("mouseover", onHover);
  });

  user_effect(() => {
    if ($$props.pinnedTooltipId) {
      for (const [id, instance] of tippyInstances.entries()) {
        if (strict_equals(id, $$props.pinnedTooltipId)) {
          instance.show();
        } else {
          instance.hide();
        }
      }
    } else {
      for (const instance of tippyInstances.values()) {
        instance.hide();
      }
    }
  });

  user_effect(() => {
    if (!$$props.pinnedTooltipId) {
      return;
    }

    void $$props.regions?.tooltips;
    void $$props.pins?.tooltips;

    for (const [id, instance] of tippyInstances.entries()) {
      if (strict_equals(id, $$props.pinnedTooltipId)) {
        const isPinId = /^pin-/.test($$props.pinnedTooltipId);
        const regionId = isPinId ? null : $$props.pinnedTooltipId;
        const pinId = isPinId ? $$props.pinnedTooltipId : null;
        const target = instance.reference;

        setupTippy({ regionId, pinId, target });
      }
    }
  });

  user_effect(() => {
    if ($$props.hasTooltips && $$props.pinnedTooltipId) {
      for (const [id, instance] of tippyInstances.entries()) {
        if (strict_equals(id, $$props.pinnedTooltipId)) {
          instance.show();
        }
      }

      return;
    }

    for (const instance of tippyInstances.values()) {
      instance.hide();
    }
  });

  user_effect(() => {
    void $$props.customRegions;
    void $$props.mapCode;
    clearTooltips();
  });

  user_effect(() => {
    void $$props.pins?.shapes;

    untrack(() => {
      clearTooltips();

      if ($$props.pinnedTooltipId) {
        const isPinId = /^pin-/.test($$props.pinnedTooltipId);

        if (isPinId) {
          const el = document.querySelector(
            `[${dataAttributeBySection["pins"]}="${$$props.pinnedTooltipId}"]`,
          );

          if (el) {
            setupTippy({
              regionId: null,
              pinId: $$props.pinnedTooltipId,
              target: el,
            });
          }
        } else {
          const el = document.querySelector(
            `[${dataAttributeBySection["regions"]}="${$$props.pinnedTooltipId}"]`,
          );

          if (el) {
            setupTippy({
              regionId: $$props.pinnedTooltipId,
              pinId: null,
              target: el,
            });
          }
        }
      }
    });
  });

  user_effect(() => {
    const onLinkClick = (event) => {
      const target = event.target;

      if (target instanceof HTMLAnchorElement && target.closest(".tippy-box")) {
        clearTooltips();
      }
    };

    document.addEventListener("click", onLinkClick);

    return () => document.removeEventListener("click", onLinkClick);
  });

  const clearTooltips = () => {
    for (const instance of tippyInstances.values()) {
      instance.destroy();
    }

    tippyInstances.clear();
  };

  var fragment = root$1();
  var node = first_child(fragment);

  {
    var consequent = ($$anchor) => {
      add_svelte_meta(
        () => Pin_icon($$anchor, { asSymbol: "tg_am_map_pin_icon" }),
        "component",
        Map_with_data,
        431,
        2,
        { componentTag: "PinIcon" },
      );
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (get(hasIconPins)) $$render(consequent);
        }),
      "if",
      Map_with_data,
      430,
      0,
    );
  }

  var div = sibling(node, 2);
  var node_1 = child(div);

  add_svelte_meta(
    () =>
      D3_map(
        node_1,
        spread_props(
          {
            get mapCode() {
              return $$props.mapCode;
            },

            get themeId() {
              return themeId();
            },

            get mapData() {
              return $$props.mapData;
            },

            onFollowLink: clearTooltips,
          },
          () => props,
        ),
      ),
    "component",
    Map_with_data,
    444,
    2,
    { componentTag: "D3Map" },
  );

  reset(div);
  bind_this(
    div,
    ($$value) => element($$value),
    () => element(),
  );

  template_effect(() => {
    set_class(
      div,
      1,
      clsx([
        "tg_am_map",
        $$props.hasHoverEffects ? "tg_am_map_with_hover" : null,
        get(themeClass),
      ]),
    );

    set_attribute(div, "data-tg-am-map-code", $$props.mapCode);
    set_attribute(div, "data-tg-am-map-id", $$props.mapId);
  });

  append($$anchor, fragment);

  return pop({
    get clearTooltips() {
      return clearTooltips;
    },

    ...legacy_api(),
  });
}

Map$1[FILENAME] = "src/lib/components/map.svelte";

var root = add_locations(from_html(`<div><!></div>`), Map$1[FILENAME], [
  [20, 0],
]);

function Map$1($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Map$1);

  var $$ownership_validator = create_ownership_validator($$props);

  let element = prop($$props, "element", 15),
    props = rest_props(
      $$props,
      ["$$slots", "$$events", "$$legacy", "element", "mapData", "class"],
      "props",
    );

  let mapRef = tag(state(void 0), "mapRef");
  const clearTooltips = () => get(mapRef)?.clearTooltips();
  var div = root();
  var node = child(div);

  {
    var consequent = ($$anchor) => {
      {
        $$ownership_validator.binding("element", Map_with_data, element);

        add_svelte_meta(
          () =>
            bind_this(
              Map_with_data(
                $$anchor,
                spread_props(
                  {
                    get mapData() {
                      return $$props.mapData;
                    },
                  },
                  () => props,
                  {
                    get element() {
                      return element();
                    },

                    set element($$value) {
                      element($$value);
                    },
                  },
                ),
              ),
              ($$value) => set(mapRef, $$value, true),
              () => get(mapRef),
            ),
          "component",
          Map$1,
          22,
          4,
          { componentTag: "MapWithData" },
        );
      }
    };

    var alternate = ($$anchor) => {
      var fragment_1 = comment();
      var node_1 = first_child(fragment_1);

      add_svelte_meta(
        () =>
          await_block(
            node_1,
            () => loadMapData($$props.mapCode),
            null,
            ($$anchor, mapData) => {
              var fragment_2 = comment();
              var node_2 = first_child(fragment_2);

              {
                var consequent_1 = ($$anchor) => {
                  {
                    $$ownership_validator.binding(
                      "element",
                      Map_with_data,
                      element,
                    );

                    add_svelte_meta(
                      () =>
                        bind_this(
                          Map_with_data(
                            $$anchor,
                            spread_props(
                              {
                                get mapData() {
                                  return get(mapData);
                                },
                              },
                              () => props,
                              {
                                get element() {
                                  return element();
                                },

                                set element($$value) {
                                  element($$value);
                                },
                              },
                            ),
                          ),
                          ($$value) => set(mapRef, $$value, true),
                          () => get(mapRef),
                        ),
                      "component",
                      Map$1,
                      26,
                      8,
                      { componentTag: "MapWithData" },
                    );
                  }
                };

                add_svelte_meta(
                  () =>
                    if_block(node_2, ($$render) => {
                      if (get(mapData)) $$render(consequent_1);
                    }),
                  "if",
                  Map$1,
                  25,
                  6,
                );
              }

              append($$anchor, fragment_2);
            },
          ),
        "await",
        Map$1,
        24,
        4,
      );

      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if ($$props.mapData) $$render(consequent);
          else $$render(alternate, false);
        }),
      "if",
      Map$1,
      21,
      2,
    );
  }

  reset(div);
  template_effect(() =>
    set_class(div, 1, clsx(["tg_am_map_container", $$props.class])),
  );
  append($$anchor, div);

  return pop({
    get clearTooltips() {
      return clearTooltips;
    },

    ...legacy_api(),
  });
}

const mount = (component, target, props) => {
  if (target) {
    {
      hydrate(component, { target, props });
    }
  }
  return target;
};

export {
  mount as $,
  ucfirst as A,
  getTooltipTypesForSection as B,
  getDefaultTooltipTypeForSection as C,
  tooltipTypeToText as D,
  loadMapData as E,
  isAreaMapCode as F,
  mapCodeToCountryName as G,
  mapHasCountries as H,
  usStateNewYork as I,
  isUsStateMapCode as J,
  findUsStateByName as K,
  usStatesByMapCode as L,
  Map$1 as M,
  getCustomRegionsEnabledByAlphaCode as N,
  allSortedCustomRegions as O,
  sortedAreaMapCodes as P,
  sortedCountryMapCodes as Q,
  isCountryMapCode as R,
  proOptions as S,
  sortedUsStates as T,
  generateUsStateMapCode as U,
  isCustomThemeId as V,
  getCustomThemeStyleId as W,
  asInt as X,
  themesById as Y,
  proThemeIds as Z,
  isThemeId as _,
  defaultThemeId as a,
  newCustomTheme as a0,
  pinShapeDescriptors as a1,
  isPinShape as a2,
  parseLatitude as a3,
  parseLongitude as a4,
  newPin as a5,
  getRegionType as a6,
  getDisabledCustomRegionIds as a7,
  defaultRegionTooltipType as a8,
  isCustomTheme as a9,
  adminTippy as aA,
  getBoolean as aa,
  getPositiveInteger as ab,
  extractBooleans as ac,
  extractValues as ad,
  extractPins as ae,
  isRegionColors as af,
  isTooltipType as ag,
  isString as ah,
  isActionType as ai,
  ptTerritories as aj,
  nzTerritories as ak,
  frTerritories as al,
  esTerritories as am,
  ecTerritories as an,
  toSlug as ao,
  countryNames as ap,
  isProFeatureId as aq,
  last as ar,
  fragment as as,
  h as at,
  usStatesByLowerAlphaCode as au,
  usStateVirginIslands as av,
  usStatePuertoRico as aw,
  usStateMarianaIslands as ax,
  usStateGuam as ay,
  usStateAmericanSamoa as az,
  isRecord as b,
  customThemeToCssRule as c,
  defaultMapCode as d,
  isProFeature as e,
  isPin as f,
  generateFieldId as g,
  defaultPinShape as h,
  isMapCode as i,
  dataSetKeyBySection as j,
  dataAttributeBySection as k,
  isPro as l,
  isEssentialMapCode as m,
  normalizeColor as n,
  mapCodeToName as o,
  getThemeClass as p,
  localStorageGetItem as q,
  regionColorsToCssRules as r,
  stagger as s,
  localStorageSetItem as t,
  setIsProFeature as u,
  validateThemeId as v,
  proFeatureToData as w,
  defaultActionType as x,
  actionDescriptors as y,
  mapDataSectionSingular as z,
};
