/*!
 * Atlas Maps 1.0.2
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

/* empty css                     */
import {
  b as isRecord,
  i as isMapCode,
  _ as isThemeId,
  a as defaultThemeId,
  aa as getBoolean,
  ac as extractBooleans,
  $ as mount,
  M as Map,
  ae as extractPins,
  ad as extractValues,
  ag as isTooltipType,
  ah as isString,
  ai as isActionType,
} from "./tg-am-mount-CScR2kmj0g.js";
import "./tg-am-vendor-CBMAXaHyD6.js";

const mountFrontendMap = (el, input) => {
  const mapCode = input.mapCode;
  if (!isMapCode(mapCode)) {
    return;
  }
  const mapId = parseInt((input.mapId ?? "").toString(), 10);
  if (!mapId || isNaN(mapId)) {
    return;
  }
  const themeId = isThemeId(input.themeId) ? input.themeId : defaultThemeId;
  const props = {
    mapId,
    mapCode,
    themeId,
    hasTooltips: getBoolean(input.hasTooltips),
    hasActions: getBoolean(input.hasActions),
    canFollowLinks: true,
  };
  if (isRecord(input.mapData)) {
    props.regions = {};
    props.pins = {};
    props.customRegions = extractBooleans(input.mapData.customRegions);
    setupRegions(props.regions, input.mapData.regions);
    setupPins(props.pins, input.mapData.pins);
  }
  if (isRecord(input.__default)) {
    props.defaults = {};
    props.defaults.regions = {};
    props.defaults.pins = {};
    setupRegions(props.defaults.regions, input.__default.regions);
    setupPins(props.defaults.pins, input.__default.pins);
  }
  mount(Map, el, props);
};
const setupRegions = (props, input) => {
  if (!isRecord(input)) return;
  setupTooltips((props.tooltips = {}), input.tooltips);
  setupActions((props.actions = {}), input.actions);
};
const setupPins = (props, input) => {
  if (!isRecord(input)) return;
  setupTooltips((props.tooltips = {}), input.tooltips);
  setupActions((props.actions = {}), input.actions);
  props.details = extractPins(input.details);
};
const setupTooltips = (props, input) => {
  if (!isRecord(input)) return;
  props.types = extractValues(input.types, isTooltipType);
  props.customText = extractValues(input.customText, isString);
};
const setupActions = (props, input) => {
  if (!isRecord(input)) return;
  props.types = extractValues(input.types, isActionType);
  props.urls = extractValues(input.urls, isString);
};
document.querySelectorAll("[id^=tg_am_map_]").forEach((el) => {
  if (!(el instanceof HTMLElement)) {
    return;
  }
  const input = JSON.parse(el.dataset.tgAmProps ?? "{}");
  if (isRecord(input)) {
    mountFrontendMap(el, input);
  }
});
