/*!
 * Atlas Maps 1.0.2
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

import {
  d as defaultMapCode,
  a as defaultThemeId,
  i as isMapCode,
  r as regionColorsToCssRules,
  b as isRecord,
  c as customThemeToCssRule,
  e as isProFeature,
  g as generateFieldId,
  s as stagger,
  n as normalizeColor,
  f as isPin,
  h as defaultPinShape,
  j as dataSetKeyBySection,
  k as dataAttributeBySection,
  l as isPro,
  m as isEssentialMapCode,
  M as Map,
  o as mapCodeToName,
  v as validateThemeId,
  p as getThemeClass,
  q as localStorageGetItem,
  t as localStorageSetItem,
  u as setIsProFeature,
  w as proFeatureToData,
  x as defaultActionType,
  y as actionDescriptors,
  z as mapDataSectionSingular,
  A as ucfirst,
  B as getTooltipTypesForSection,
  C as getDefaultTooltipTypeForSection,
  D as tooltipTypeToText,
  E as loadMapData,
  F as isAreaMapCode,
  G as mapCodeToCountryName,
  H as mapHasCountries,
  I as usStateNewYork,
  J as isUsStateMapCode,
  K as findUsStateByName,
  L as usStatesByMapCode,
  N as getCustomRegionsEnabledByAlphaCode,
  O as allSortedCustomRegions,
  P as sortedAreaMapCodes,
  Q as sortedCountryMapCodes,
  R as isCountryMapCode,
  S as proOptions,
  T as sortedUsStates,
  U as generateUsStateMapCode,
  V as isCustomThemeId,
  W as getCustomThemeStyleId,
  X as asInt,
  Y as themesById,
  Z as proThemeIds,
  _ as isThemeId,
  $ as mount,
  a0 as newCustomTheme,
  a1 as pinShapeDescriptors,
  a2 as isPinShape,
  a3 as parseLatitude,
  a4 as parseLongitude,
  a5 as newPin,
  a6 as getRegionType,
  a7 as getDisabledCustomRegionIds,
  a8 as defaultRegionTooltipType,
  a9 as isCustomTheme,
  aa as getBoolean,
  ab as getPositiveInteger,
  ac as extractBooleans,
  ad as extractValues,
  ae as extractPins,
  af as isRegionColors,
  ag as isTooltipType,
  ah as isString,
  ai as isActionType,
} from "./tg-am-mount-CScR2kmj0g.js";
import {
  t as tag,
  s as state,
  p as proxy,
  g as get,
  a as set,
  w as wrap_snippet,
  c as check_target,
  b as push,
  d as comment,
  f as first_child,
  e as add_svelte_meta,
  h as append,
  i as pop,
  l as legacy_api,
  j as if_block,
  k as strict_equals,
  F as FILENAME,
  n as noop,
  v as validate_snippet_args,
  m as add_locations,
  r as remove_input_defaults,
  o as template_effect,
  q as set_attribute,
  u as set_value,
  x as from_html,
  y as each,
  z as index,
  A as user_derived,
  B as to_array,
  C as sibling,
  D as tippy,
  E as action,
  G as set_class,
  H as clsx,
  I as set_style,
  J as prop,
  K as child,
  L as reset,
  M as set_text,
  N as snippet,
  O as props_id,
  P as spread_props,
  Q as attribute_effect,
  R as rest_props,
  S as user_effect,
  T as validate_binding,
  U as bind_this,
  V as next,
  W as attach,
  X as from_svg,
  Y as delegate,
  Z as create_ownership_validator,
  _ as init,
  $ as derived_safe_equal,
  a0 as reactive_import,
  a1 as key,
  a2 as remove_textarea_child,
  a3 as STYLE,
  a4 as apply,
  a5 as await_block,
  a6 as text,
  a7 as assign,
  a8 as track_reactivity_loss,
} from "./tg-am-vendor-CBMAXaHyD6.js";
/* empty css                     */

const defaultRegionSettingsPane = "region";

/* admin-state.svelte.ts generated by Svelte v5.38.1 */

const removeById = (idRecord, id) => {
  delete idRecord[id];
};

class AdminState {
  #mapCode = tag(state(proxy(defaultMapCode)), "AdminState.mapCode");

  get mapCode() {
    return get(this.#mapCode);
  }

  set mapCode(value) {
    set(this.#mapCode, value, true);
  }

  #themeId = tag(state(proxy(defaultThemeId)), "AdminState.themeId");

  get themeId() {
    return get(this.#themeId);
  }

  set themeId(value) {
    set(this.#themeId, value, true);
  }

  #hasTooltips = tag(state(false), "AdminState.hasTooltips");

  get hasTooltips() {
    return get(this.#hasTooltips);
  }

  set hasTooltips(value) {
    set(this.#hasTooltips, value, true);
  }

  #hasActions = tag(state(false), "AdminState.hasActions");

  get hasActions() {
    return get(this.#hasActions);
  }

  set hasActions(value) {
    set(this.#hasActions, value, true);
  }

  #hasHoverEffects = tag(state(false), "AdminState.hasHoverEffects");

  get hasHoverEffects() {
    return get(this.#hasHoverEffects);
  }

  set hasHoverEffects(value) {
    set(this.#hasHoverEffects, value, true);
  }

  #hasRegionColors = tag(state(false), "AdminState.hasRegionColors");

  get hasRegionColors() {
    return get(this.#hasRegionColors);
  }

  set hasRegionColors(value) {
    set(this.#hasRegionColors, value, true);
  }

  #hasUsStateLabels = tag(state(false), "AdminState.hasUsStateLabels");

  get hasUsStateLabels() {
    return get(this.#hasUsStateLabels);
  }

  set hasUsStateLabels(value) {
    set(this.#hasUsStateLabels, value, true);
  }

  #usStateLabelSizePixels = tag(
    state(null),
    "AdminState.usStateLabelSizePixels",
  );

  get usStateLabelSizePixels() {
    return get(this.#usStateLabelSizePixels);
  }

  set usStateLabelSizePixels(value) {
    set(this.#usStateLabelSizePixels, value, true);
  }

  #mapData = tag(
    state(
      proxy({
        [this.mapCode]: new MapDataState(),
        __default: new MapDataState(),
      }),
    ),
    "AdminState.mapData",
  );

  get mapData() {
    return get(this.#mapData);
  }

  set mapData(value) {
    set(this.#mapData, value, true);
  }

  #customThemes = tag(state(proxy({})), "AdminState.customThemes");

  get customThemes() {
    return get(this.#customThemes);
  }

  set customThemes(value) {
    set(this.#customThemes, value, true);
  }

  #hiddenThemeIds = tag(state(proxy([])), "AdminState.hiddenThemeIds");

  get hiddenThemeIds() {
    return get(this.#hiddenThemeIds);
  }

  set hiddenThemeIds(value) {
    set(this.#hiddenThemeIds, value, true);
  }

  #keepActiveTooltipVisible = tag(
    state(false),
    "AdminState.keepActiveTooltipVisible",
  );

  get keepActiveTooltipVisible() {
    return get(this.#keepActiveTooltipVisible);
  }

  set keepActiveTooltipVisible(value) {
    set(this.#keepActiveTooltipVisible, value, true);
  }

  #highlightedRegionId = tag(state(null), "AdminState.highlightedRegionId");

  get highlightedRegionId() {
    return get(this.#highlightedRegionId);
  }

  set highlightedRegionId(value) {
    set(this.#highlightedRegionId, value, true);
  }

  #highlightedPinId = tag(state(null), "AdminState.highlightedPinId");

  get highlightedPinId() {
    return get(this.#highlightedPinId);
  }

  set highlightedPinId(value) {
    set(this.#highlightedPinId, value, true);
  }

  #pinnedTooltipId = tag(state(null), "AdminState.pinnedTooltipId");

  get pinnedTooltipId() {
    return get(this.#pinnedTooltipId);
  }

  set pinnedTooltipId(value) {
    set(this.#pinnedTooltipId, value, true);
  }

  #regionSettingsPane = tag(
    state(proxy(defaultRegionSettingsPane)),
    "AdminState.regionSettingsPane",
  );

  get regionSettingsPane() {
    return get(this.#regionSettingsPane);
  }

  set regionSettingsPane(value) {
    set(this.#regionSettingsPane, value, true);
  }
}

class MapDataState {
  regions = new RegionState();
  pins = new PinState();
  #customRegions = tag(state(null), "MapDataState.customRegions");

  get customRegions() {
    return get(this.#customRegions);
  }

  set customRegions(value) {
    set(this.#customRegions, value, true);
  }
}

class RegionState {
  tooltips = new TooltipState();
  actions = new ActionState();
  #colors = tag(state(proxy({})), "RegionState.colors");

  get colors() {
    return get(this.#colors);
  }

  set colors(value) {
    set(this.#colors, value, true);
  }

  removeById(id) {
    this.tooltips.removeById(id);
    this.actions.removeById(id);
  }
}

class PinState {
  tooltips = new TooltipState();
  actions = new ActionState();
  #details = tag(state(proxy({})), "PinState.details");

  get details() {
    return get(this.#details);
  }

  set details(value) {
    set(this.#details, value, true);
  }

  #shapes = tag(state(proxy({})), "PinState.shapes");

  get shapes() {
    return get(this.#shapes);
  }

  set shapes(value) {
    set(this.#shapes, value, true);
  }

  removeById(id) {
    this.tooltips.removeById(id);
    this.actions.removeById(id);
    removeById(this.details, id);
    removeById(this.shapes, id);
  }
}

class TooltipState {
  #types = tag(state(proxy({})), "TooltipState.types");

  get types() {
    return get(this.#types);
  }

  set types(value) {
    set(this.#types, value, true);
  }

  #customText = tag(state(proxy({})), "TooltipState.customText");

  get customText() {
    return get(this.#customText);
  }

  set customText(value) {
    set(this.#customText, value, true);
  }

  #customRichText = tag(state(proxy({})), "TooltipState.customRichText");

  get customRichText() {
    return get(this.#customRichText);
  }

  set customRichText(value) {
    set(this.#customRichText, value, true);
  }

  #rich = tag(state(proxy({})), "TooltipState.rich");

  get rich() {
    return get(this.#rich);
  }

  set rich(value) {
    set(this.#rich, value, true);
  }

  #centered = tag(state(proxy({})), "TooltipState.centered");

  get centered() {
    return get(this.#centered);
  }

  set centered(value) {
    set(this.#centered, value, true);
  }

  #interactive = tag(state(proxy({})), "TooltipState.interactive");

  get interactive() {
    return get(this.#interactive);
  }

  set interactive(value) {
    set(this.#interactive, value, true);
  }

  removeById(id) {
    removeById(this.types, id);
    removeById(this.customText, id);
    removeById(this.customRichText, id);
    removeById(this.rich, id);
    removeById(this.centered, id);
    removeById(this.interactive, id);
  }
}

class ActionState {
  #types = tag(state(proxy({})), "ActionState.types");

  get types() {
    return get(this.#types);
  }

  set types(value) {
    set(this.#types, value, true);
  }

  #urls = tag(state(proxy({})), "ActionState.urls");

  get urls() {
    return get(this.#urls);
  }

  set urls(value) {
    set(this.#urls, value, true);
  }

  #urlsInNewTab = tag(state(proxy({})), "ActionState.urlsInNewTab");

  get urlsInNewTab() {
    return get(this.#urlsInNewTab);
  }

  set urlsInNewTab(value) {
    set(this.#urlsInNewTab, value, true);
  }

  removeById(id) {
    removeById(this.types, id);
    removeById(this.urls, id);
    removeById(this.urlsInNewTab, id);
  }
}

const adminState = new AdminState();

const proTitle = "Atlas Maps Pro";

const mapColorsToCssRules = (mapId, options) => {
  let css = "";
  for (const [mapCode, mapData] of Object.entries(adminState.mapData)) {
    if (!isMapCode(mapCode)) {
      continue;
    }
    for (const [regionId, colors] of Object.entries(mapData.regions.colors)) {
      if (colors) {
        css += regionColorsToCssRules(mapCode, mapId, regionId, colors);
      }
    }
  }
  return css;
};

Value_field[FILENAME] = "src/lib/components/form/value-field.svelte";

const input$1 = wrap_snippet(
  Value_field,
  function ($$anchor, name = noop, value = noop) {
    validate_snippet_args(...arguments);

    var fragment = comment();
    var node = first_child(fragment);

    {
      var consequent = ($$anchor) => {
        var input_1 = root_2$9();

        remove_input_defaults(input_1);

        template_effect(() => {
          set_attribute(input_1, "name", name());
          set_value(input_1, value());
        });

        append($$anchor, input_1);
      };

      add_svelte_meta(
        () =>
          if_block(node, ($$render) => {
            if (
              strict_equals(value(), null, false) &&
              strict_equals(value(), undefined, false)
            )
              $$render(consequent);
          }),
        "if",
        Value_field,
        28,
        2,
      );
    }

    append($$anchor, fragment);
  },
);

var root_2$9 = add_locations(
  from_html(`<input type="hidden"/>`),
  Value_field[FILENAME],
  [[29, 4]],
);

function Value_field($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Value_field);

  var fragment_1 = comment();
  var node_1 = first_child(fragment_1);

  {
    var consequent_2 = ($$anchor) => {
      var fragment_2 = comment();
      var node_2 = first_child(fragment_2);

      add_svelte_meta(
        () =>
          each(
            node_2,
            17,
            () => Object.entries($$props.items),
            index,
            ($$anchor, $$item) => {
              var $$array = user_derived(() => to_array(get($$item), 2));
              let key = () => get($$array)[0];

              key();

              let value = () => get($$array)[1];

              value();

              var fragment_3 = comment();
              var node_3 = first_child(fragment_3);

              {
                var consequent_1 = ($$anchor) => {
                  var fragment_4 = comment();
                  var node_4 = first_child(fragment_4);

                  add_svelte_meta(
                    () =>
                      each(
                        node_4,
                        17,
                        () => Object.entries(value()),
                        index,
                        ($$anchor, $$item) => {
                          var $$array_1 = user_derived(() =>
                            to_array(get($$item), 2),
                          );
                          let eKey = () => get($$array_1)[0];

                          eKey();

                          let eValue = () => get($$array_1)[1];

                          eValue();
                          add_svelte_meta(
                            () =>
                              input$1(
                                $$anchor,
                                () => `${$$props.name}[${key()}][${eKey()}]`,
                                eValue,
                              ),
                            "render",
                            Value_field,
                            19,
                            8,
                          );
                        },
                      ),
                    "each",
                    Value_field,
                    18,
                    6,
                  );

                  append($$anchor, fragment_4);
                };

                var alternate = ($$anchor) => {
                  add_svelte_meta(
                    () =>
                      input$1(
                        $$anchor,
                        () => `${$$props.name}[${key()}]`,
                        value,
                      ),
                    "render",
                    Value_field,
                    22,
                    6,
                  );
                };

                add_svelte_meta(
                  () =>
                    if_block(node_3, ($$render) => {
                      if (isRecord(value())) $$render(consequent_1);
                      else $$render(alternate, false);
                    }),
                  "if",
                  Value_field,
                  17,
                  4,
                );
              }

              append($$anchor, fragment_3);
            },
          ),
        "each",
        Value_field,
        16,
        2,
      );

      append($$anchor, fragment_2);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (
            strict_equals($$props.items, null, false) &&
            strict_equals($$props.items, undefined, false)
          )
            $$render(consequent_2);
        }),
      "if",
      Value_field,
      15,
      0,
    );
  }

  append($$anchor, fragment_1);

  return pop({ ...legacy_api() });
}

Admin_state_fields[FILENAME] = "src/lib/components/admin-state-fields.svelte";

const regionState = wrap_snippet(
  Admin_state_fields,
  function ($$anchor, prefix = noop, state = noop) {
    validate_snippet_args(...arguments);

    const field = tag(
      user_derived(() => `${prefix()}[regions]`),
      "field",
    );

    get(field);

    var fragment = root_1$l();
    var node = first_child(fragment);

    add_svelte_meta(
      () =>
        tooltipState(
          node,
          () => get(field),
          () => state().tooltips,
        ),
      "render",
      Admin_state_fields,
      55,
      2,
    );

    var node_1 = sibling(node, 2);

    add_svelte_meta(
      () =>
        actionState(
          node_1,
          () => get(field),
          () => state().actions,
        ),
      "render",
      Admin_state_fields,
      56,
      2,
    );

    var node_2 = sibling(node_1, 2);

    {
      let $0 = user_derived(() => `${get(field)}[colors]`);

      add_svelte_meta(
        () =>
          Value_field(node_2, {
            get name() {
              return get($0);
            },

            get items() {
              return state().colors;
            },
          }),
        "component",
        Admin_state_fields,
        57,
        2,
        { componentTag: "ValueField" },
      );
    }

    append($$anchor, fragment);
  },
);

const pinState = wrap_snippet(
  Admin_state_fields,
  function ($$anchor, prefix = noop, state = noop) {
    validate_snippet_args(...arguments);

    const field = tag(
      user_derived(() => `${prefix()}[pins]`),
      "field",
    );

    get(field);

    var fragment_1 = root_2$8();
    var node_3 = first_child(fragment_1);

    add_svelte_meta(
      () =>
        tooltipState(
          node_3,
          () => get(field),
          () => state().tooltips,
        ),
      "render",
      Admin_state_fields,
      62,
      2,
    );

    var node_4 = sibling(node_3, 2);

    add_svelte_meta(
      () =>
        actionState(
          node_4,
          () => get(field),
          () => state().actions,
        ),
      "render",
      Admin_state_fields,
      63,
      2,
    );

    var node_5 = sibling(node_4, 2);

    {
      let $0 = user_derived(() => `${get(field)}[details]`);

      add_svelte_meta(
        () =>
          Value_field(node_5, {
            get name() {
              return get($0);
            },

            get items() {
              return state().details;
            },
          }),
        "component",
        Admin_state_fields,
        64,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_6 = sibling(node_5, 2);

    {
      let $0 = user_derived(() => `${get(field)}[shapes]`);

      add_svelte_meta(
        () =>
          Value_field(node_6, {
            get name() {
              return get($0);
            },

            get items() {
              return state().shapes;
            },
          }),
        "component",
        Admin_state_fields,
        65,
        2,
        { componentTag: "ValueField" },
      );
    }

    append($$anchor, fragment_1);
  },
);

const tooltipState = wrap_snippet(
  Admin_state_fields,
  function ($$anchor, prefix = noop, state = noop) {
    validate_snippet_args(...arguments);

    const field = tag(
      user_derived(() => `${prefix()}[tooltips]`),
      "field",
    );

    get(field);

    var fragment_2 = root_3$8();
    var node_7 = first_child(fragment_2);

    {
      let $0 = user_derived(() => `${get(field)}[types]`);

      add_svelte_meta(
        () =>
          Value_field(node_7, {
            get name() {
              return get($0);
            },

            get items() {
              return state().types;
            },
          }),
        "component",
        Admin_state_fields,
        70,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_8 = sibling(node_7, 2);

    {
      let $0 = user_derived(() => `${get(field)}[customText]`);

      add_svelte_meta(
        () =>
          Value_field(node_8, {
            get name() {
              return get($0);
            },

            get items() {
              return state().customText;
            },
          }),
        "component",
        Admin_state_fields,
        71,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_9 = sibling(node_8, 2);

    {
      let $0 = user_derived(() => `${get(field)}[customRichText]`);

      add_svelte_meta(
        () =>
          Value_field(node_9, {
            get name() {
              return get($0);
            },

            get items() {
              return state().customRichText;
            },
          }),
        "component",
        Admin_state_fields,
        72,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_10 = sibling(node_9, 2);

    {
      let $0 = user_derived(() => `${get(field)}[rich]`);

      add_svelte_meta(
        () =>
          Value_field(node_10, {
            get name() {
              return get($0);
            },

            get items() {
              return state().rich;
            },
          }),
        "component",
        Admin_state_fields,
        73,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_11 = sibling(node_10, 2);

    {
      let $0 = user_derived(() => `${get(field)}[centered]`);

      add_svelte_meta(
        () =>
          Value_field(node_11, {
            get name() {
              return get($0);
            },

            get items() {
              return state().centered;
            },
          }),
        "component",
        Admin_state_fields,
        74,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_12 = sibling(node_11, 2);

    {
      let $0 = user_derived(() => `${get(field)}[interactive]`);

      add_svelte_meta(
        () =>
          Value_field(node_12, {
            get name() {
              return get($0);
            },

            get items() {
              return state().interactive;
            },
          }),
        "component",
        Admin_state_fields,
        75,
        2,
        { componentTag: "ValueField" },
      );
    }

    append($$anchor, fragment_2);
  },
);

const actionState = wrap_snippet(
  Admin_state_fields,
  function ($$anchor, prefix = noop, state = noop) {
    validate_snippet_args(...arguments);

    const field = tag(
      user_derived(() => `${prefix()}[actions]`),
      "field",
    );

    get(field);

    var fragment_3 = root_4$6();
    var node_13 = first_child(fragment_3);

    {
      let $0 = user_derived(() => `${get(field)}[types]`);

      add_svelte_meta(
        () =>
          Value_field(node_13, {
            get name() {
              return get($0);
            },

            get items() {
              return state().types;
            },
          }),
        "component",
        Admin_state_fields,
        80,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_14 = sibling(node_13, 2);

    {
      let $0 = user_derived(() => `${get(field)}[urls]`);

      add_svelte_meta(
        () =>
          Value_field(node_14, {
            get name() {
              return get($0);
            },

            get items() {
              return state().urls;
            },
          }),
        "component",
        Admin_state_fields,
        81,
        2,
        { componentTag: "ValueField" },
      );
    }

    var node_15 = sibling(node_14, 2);

    {
      let $0 = user_derived(() => `${get(field)}[urlsInNewTab]`);

      add_svelte_meta(
        () =>
          Value_field(node_15, {
            get name() {
              return get($0);
            },

            get items() {
              return state().urlsInNewTab;
            },
          }),
        "component",
        Admin_state_fields,
        82,
        2,
        { componentTag: "ValueField" },
      );
    }

    append($$anchor, fragment_3);
  },
);

const input = wrap_snippet(
  Admin_state_fields,
  function ($$anchor, name = noop, value = noop) {
    validate_snippet_args(...arguments);

    var input_1 = root_5$6();

    remove_input_defaults(input_1);

    template_effect(() => {
      set_attribute(input_1, "name", name());
      set_value(input_1, value());
    });

    append($$anchor, input_1);
  },
);

var root_1$l = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root_2$8 = add_locations(
  from_html(`<!> <!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root_3$8 = add_locations(
  from_html(`<!> <!> <!> <!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root_4$6 = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root_5$6 = add_locations(
  from_html(`<input type="hidden"/>`),
  Admin_state_fields[FILENAME],
  [[86, 2]],
);
var root_8$4 = add_locations(
  from_html(`<!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root_10$5 = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);
var root$p = add_locations(
  from_html(`<!> <!> <!> <!> <!> <!> <!> <!> <!> <!> <!>`, 1),
  Admin_state_fields[FILENAME],
  [],
);

function Admin_state_fields($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Admin_state_fields);

  var fragment_4 = root$p();
  var node_16 = first_child(fragment_4);

  add_svelte_meta(
    () =>
      input(
        node_16,
        () => "tg_am_map[code]",
        () => adminState.mapCode,
      ),
    "render",
    Admin_state_fields,
    19,
    0,
  );

  var node_17 = sibling(node_16, 2);

  add_svelte_meta(
    () =>
      input(
        node_17,
        () => "tg_am_map[themeId]",
        () => adminState.themeId,
      ),
    "render",
    Admin_state_fields,
    20,
    0,
  );

  var node_18 = sibling(node_17, 2);

  add_svelte_meta(
    () =>
      input(
        node_18,
        () => "tg_am_map[hasTooltips]",
        () => adminState.hasTooltips,
      ),
    "render",
    Admin_state_fields,
    21,
    0,
  );

  var node_19 = sibling(node_18, 2);

  add_svelte_meta(
    () =>
      input(
        node_19,
        () => "tg_am_map[hasActions]",
        () => adminState.hasActions,
      ),
    "render",
    Admin_state_fields,
    22,
    0,
  );

  var node_20 = sibling(node_19, 2);

  add_svelte_meta(
    () =>
      input(
        node_20,
        () => "tg_am_map[hasHoverEffects]",
        () => adminState.hasHoverEffects,
      ),
    "render",
    Admin_state_fields,
    23,
    0,
  );

  var node_21 = sibling(node_20, 2);

  add_svelte_meta(
    () =>
      input(
        node_21,
        () => "tg_am_map[hasRegionColors]",
        () => adminState.hasRegionColors,
      ),
    "render",
    Admin_state_fields,
    24,
    0,
  );

  var node_22 = sibling(node_21, 2);

  add_svelte_meta(
    () =>
      input(
        node_22,
        () => "tg_am_map[hasUsStateLabels]",
        () => adminState.hasUsStateLabels,
      ),
    "render",
    Admin_state_fields,
    25,
    0,
  );

  var node_23 = sibling(node_22, 2);

  {
    var consequent = ($$anchor) => {
      {
        let $0 = user_derived(() =>
          adminState.usStateLabelSizePixels.toString(),
        );

        add_svelte_meta(
          () =>
            input(
              $$anchor,
              () => "tg_am_map[usStateLabelSizePixels]",
              () => get($0),
            ),
          "render",
          Admin_state_fields,
          27,
          2,
        );
      }
    };

    add_svelte_meta(
      () =>
        if_block(node_23, ($$render) => {
          if (adminState.usStateLabelSizePixels) $$render(consequent);
        }),
      "if",
      Admin_state_fields,
      26,
      0,
    );
  }

  var node_24 = sibling(node_23, 2);

  {
    let $0 = user_derived(() => mapColorsToCssRules($$props.mapId));

    add_svelte_meta(
      () =>
        input(
          node_24,
          () => "tg_am_map[colorsCss]",
          () => get($0),
        ),
      "render",
      Admin_state_fields,
      32,
      0,
    );
  }

  var node_25 = sibling(node_24, 2);

  add_svelte_meta(
    () =>
      each(
        node_25,
        17,
        () => Object.entries(adminState.customThemes),
        index,
        ($$anchor, $$item) => {
          var $$array = user_derived(() => to_array(get($$item), 2));
          let themeId = () => get($$array)[0];

          themeId();

          let theme = () => get($$array)[1];

          theme();

          var fragment_6 = comment();
          var node_26 = first_child(fragment_6);

          {
            var consequent_1 = ($$anchor) => {
              var fragment_7 = root_8$4();
              var node_27 = first_child(fragment_7);

              {
                let $0 = user_derived(
                  () => `tg_am_map[customThemes][${themeId()}]`,
                );

                add_svelte_meta(
                  () =>
                    Value_field(node_27, {
                      get name() {
                        return get($0);
                      },

                      get items() {
                        return theme();
                      },
                    }),
                  "component",
                  Admin_state_fields,
                  36,
                  4,
                  { componentTag: "ValueField" },
                );
              }

              var node_28 = sibling(node_27, 2);

              {
                let $0 = user_derived(() => customThemeToCssRule(theme()));

                add_svelte_meta(
                  () =>
                    input(
                      node_28,
                      () => `tg_am_map[customThemesCss][${themeId()}]`,
                      () => get($0),
                    ),
                  "render",
                  Admin_state_fields,
                  37,
                  4,
                );
              }

              append($$anchor, fragment_7);
            };

            add_svelte_meta(
              () =>
                if_block(node_26, ($$render) => {
                  if (theme()) $$render(consequent_1);
                }),
              "if",
              Admin_state_fields,
              35,
              2,
            );
          }

          append($$anchor, fragment_6);
        },
      ),
    "each",
    Admin_state_fields,
    34,
    0,
  );

  var node_29 = sibling(node_25, 2);

  add_svelte_meta(
    () =>
      each(
        node_29,
        17,
        () => Object.entries(adminState.mapData),
        index,
        ($$anchor, $$item) => {
          var $$array_1 = user_derived(() => to_array(get($$item), 2));
          let mapCode = () => get($$array_1)[0];

          mapCode();

          let state = () => get($$array_1)[1];

          state();

          const field = tag(
            user_derived(() => `tg_am_map[data][${mapCode()}]`),
            "field",
          );

          get(field);

          var fragment_8 = comment();
          var node_30 = first_child(fragment_8);

          {
            var consequent_2 = ($$anchor) => {
              var fragment_9 = root_10$5();
              var node_31 = first_child(fragment_9);

              add_svelte_meta(
                () =>
                  regionState(
                    node_31,
                    () => get(field),
                    () => state().regions,
                  ),
                "render",
                Admin_state_fields,
                47,
                4,
              );

              var node_32 = sibling(node_31, 2);

              add_svelte_meta(
                () =>
                  pinState(
                    node_32,
                    () => get(field),
                    () => state().pins,
                  ),
                "render",
                Admin_state_fields,
                48,
                4,
              );

              var node_33 = sibling(node_32, 2);

              {
                let $0 = user_derived(() => `${get(field)}[customRegions]`);

                add_svelte_meta(
                  () =>
                    Value_field(node_33, {
                      get name() {
                        return get($0);
                      },

                      get items() {
                        return state().customRegions;
                      },
                    }),
                  "component",
                  Admin_state_fields,
                  49,
                  4,
                  { componentTag: "ValueField" },
                );
              }

              append($$anchor, fragment_9);
            };

            add_svelte_meta(
              () =>
                if_block(node_30, ($$render) => {
                  if (
                    isMapCode(mapCode()) ||
                    strict_equals(mapCode(), "__default")
                  )
                    $$render(consequent_2);
                }),
              "if",
              Admin_state_fields,
              46,
              2,
            );
          }

          append($$anchor, fragment_8);
        },
      ),
    "each",
    Admin_state_fields,
    44,
    0,
  );

  append($$anchor, fragment_4);

  return pop({ ...legacy_api() });
}

/* disable-select-action.svelte.ts generated by Svelte v5.38.1 */

const disableSelectOnDoubleClick = (node) => {
  const onMouseDown = (event) => {
    if (event.detail >= 2) {
      event.preventDefault();
    }
  };

  node.addEventListener("mousedown", onMouseDown);

  return {
    destroy() {
      node.removeEventListener("mousedown", onMouseDown);
    },
  };
};

/* tooltip-action.svelte.ts generated by Svelte v5.38.1 */

const tippyInstances = new WeakMap();

const tooltip = (node, props) => {
  let widthMaxContent = true;

  if (
    strict_equals(typeof props, "string", false) &&
    strict_equals(typeof props?.widthMaxContent, "boolean")
  ) {
    widthMaxContent = props.widthMaxContent;
  }

  if (widthMaxContent) {
    node.style.width = "max-content";
  }

  node.style.maxWidth = "100%";

  let tippyInstance = tippyInstances.get(node);

  if (!tippyInstance) {
    tippyInstance = tippy(node, { delay: [600, 0], hideOnClick: false });
    tippyInstances.set(node, tippyInstance);
  }

  const update = (props2) => {
    const content = (
      (strict_equals(typeof props2, "string") ? props2 : props2?.content) ?? ""
    ).trim();

    if (content) {
      tippyInstance.setContent(content);

      if (!tippyInstance.state.isEnabled) {
        tippyInstance.enable();
      }
    } else {
      tippyInstance.disable();
    }
  };

  update(props);

  return {
    update,

    destroy() {
      tippyInstance.destroy();
      tippyInstances.delete(node);
    },
  };
};

Field[FILENAME] = "src/lib/components/form/field.svelte";

var root_1$k = add_locations(
  from_html(`<label class="tg_am_map_field_label svelte-5psfjc"> </label>`),
  Field[FILENAME],
  [[49, 2]],
);
var root_7$5 = add_locations(
  from_html(`<div style="width: 100%" class="svelte-5psfjc"><!></div>`),
  Field[FILENAME],
  [[66, 6]],
);
var root_9$5 = add_locations(from_html(`<!> <!>`, 1), Field[FILENAME], []);
var root_10$4 = add_locations(from_html(`<!> <!>`, 1), Field[FILENAME], []);
var root_8$3 = add_locations(from_html(`<div><!></div>`), Field[FILENAME], [
  [80, 2],
]);
var root_12$2 = add_locations(
  from_html(
    `<div class="tg_am_field_body svelte-5psfjc"><div class="svelte-5psfjc"><!></div> <!></div>`,
  ),
  Field[FILENAME],
  [[99, 4, [[100, 6]]]],
);
var root_16 = add_locations(
  from_html(`<div class="svelte-5psfjc"><!></div>`),
  Field[FILENAME],
  [[114, 4]],
);

function Field($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Field);

  const labelBody = wrap_snippet(Field, function ($$anchor) {
    validate_snippet_args(...arguments);

    var label_1 = root_1$k();
    var text = child(label_1, true);

    reset(label_1);
    action(label_1, ($$node) => disableSelectOnDoubleClick?.($$node));

    template_effect(() => {
      set_style(label_1, $$props.for ? null : "cursor: default");
      set_attribute(label_1, "for", $$props.for);
      set_text(text, labelText);
    });

    append($$anchor, label_1);
  });

  const labelElement = wrap_snippet(Field, function ($$anchor) {
    validate_snippet_args(...arguments);

    var fragment = comment();
    var node = first_child(fragment);

    {
      var consequent_2 = ($$anchor) => {
        var fragment_1 = comment();
        var node_1 = first_child(fragment_1);

        {
          var consequent = ($$anchor) => {
            add_svelte_meta(() => labelBody($$anchor), "render", Field, 62, 6);
          };

          var alternate_1 = ($$anchor) => {
            var fragment_3 = comment();
            var node_2 = first_child(fragment_3);

            {
              var consequent_1 = ($$anchor) => {
                add_svelte_meta(
                  () => labelBody($$anchor),
                  "render",
                  Field,
                  64,
                  6,
                );
              };

              var alternate = ($$anchor) => {
                var div = root_7$5();
                var node_3 = child(div);

                add_svelte_meta(
                  () => labelBody(node_3),
                  "render",
                  Field,
                  73,
                  8,
                );
                reset(div);

                action(
                  div,
                  ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
                  () => ({
                    content: $$props.tooltip,
                    widthMaxContent: $$props.tooltipWidthMaxContent,
                  }),
                );

                append($$anchor, div);
              };

              add_svelte_meta(
                () =>
                  if_block(
                    node_2,
                    ($$render) => {
                      if (disabledBecauseNotPro) $$render(consequent_1);
                      else $$render(alternate, false);
                    },
                    true,
                  ),
                "if",
                Field,
                63,
                4,
              );
            }

            append($$anchor, fragment_3);
          };

          add_svelte_meta(
            () =>
              if_block(node_1, ($$render) => {
                if (strict_equals($$props.attachTooltip, "field"))
                  $$render(consequent);
                else $$render(alternate_1, false);
              }),
            "if",
            Field,
            61,
            4,
          );
        }

        append($$anchor, fragment_1);
      };

      add_svelte_meta(
        () =>
          if_block(node, ($$render) => {
            if ($$props.label) $$render(consequent_2);
          }),
        "if",
        Field,
        60,
        2,
      );
    }

    append($$anchor, fragment);
  });

  const body = wrap_snippet(Field, function ($$anchor) {
    validate_snippet_args(...arguments);

    var div_1 = root_8$3();
    let classes;
    var node_4 = child(div_1);

    {
      var consequent_3 = ($$anchor) => {
        var fragment_5 = root_9$5();
        var node_5 = first_child(fragment_5);

        add_svelte_meta(() => wrappedBody(node_5), "render", Field, 88, 6);

        var node_6 = sibling(node_5, 2);

        add_svelte_meta(() => labelElement(node_6), "render", Field, 89, 6);
        append($$anchor, fragment_5);
      };

      var alternate_2 = ($$anchor) => {
        var fragment_6 = root_10$4();
        var node_7 = first_child(fragment_6);

        add_svelte_meta(() => labelElement(node_7), "render", Field, 91, 6);

        var node_8 = sibling(node_7, 2);

        add_svelte_meta(() => wrappedBody(node_8), "render", Field, 92, 6);
        append($$anchor, fragment_6);
      };

      add_svelte_meta(
        () =>
          if_block(node_4, ($$render) => {
            if ($$props.labelLast) $$render(consequent_3);
            else $$render(alternate_2, false);
          }),
        "if",
        Field,
        87,
        4,
      );
    }

    reset(div_1);

    template_effect(
      ($0) => {
        classes = set_class(
          div_1,
          1,
          clsx($$props.class),
          "svelte-5psfjc",
          classes,
          $0,
        );
        set_style(div_1, $$props.style);
      },
      [
        () => ({
          tg_am_map_field_disabled: disabledBecauseNotPro,
          tg_am_map_field_horizontal: $$props.horizontal,
          tg_am_map_field_vertical: !$$props.horizontal,
        }),
      ],
    );

    append($$anchor, div_1);
  });

  const wrappedBody = wrap_snippet(Field, function ($$anchor) {
    validate_snippet_args(...arguments);

    var fragment_7 = comment();
    var node_9 = first_child(fragment_7);

    {
      var consequent_4 = ($$anchor) => {
        var div_2 = root_12$2();
        var div_3 = child(div_2);
        var node_10 = child(div_3);

        add_svelte_meta(
          () => snippet(node_10, () => $$props.children),
          "render",
          Field,
          101,
          8,
        );
        reset(div_3);

        var node_11 = sibling(div_3, 2);

        add_svelte_meta(
          () => snippet(node_11, () => $$props.fieldBody),
          "render",
          Field,
          103,
          6,
        );
        reset(div_2);
        append($$anchor, div_2);
      };

      var alternate_3 = ($$anchor) => {
        var fragment_8 = comment();
        var node_12 = first_child(fragment_8);

        add_svelte_meta(
          () => snippet(node_12, () => $$props.children),
          "render",
          Field,
          106,
          4,
        );
        append($$anchor, fragment_8);
      };

      add_svelte_meta(
        () =>
          if_block(node_9, ($$render) => {
            if ($$props.fieldBody) $$render(consequent_4);
            else $$render(alternate_3, false);
          }),
        "if",
        Field,
        98,
        2,
      );
    }

    append($$anchor, fragment_7);
  });

  const labelColon = prop($$props, "labelColon", 3, true);
  const disabledBecauseNotPro = isProFeature();

  const labelText = $$props.label
    ? labelColon() && !/:$/.test($$props.label)
      ? `${$$props.label}:`
      : $$props.label
    : "";

  var fragment_9 = comment();
  var node_13 = first_child(fragment_9);

  {
    var consequent_6 = ($$anchor) => {
      var fragment_10 = comment();
      var node_14 = first_child(fragment_10);

      {
        var consequent_5 = ($$anchor) => {
          add_svelte_meta(() => body($$anchor), "render", Field, 112, 4);
        };

        var alternate_4 = ($$anchor) => {
          var div_4 = root_16();
          var node_15 = child(div_4);

          add_svelte_meta(() => body(node_15), "render", Field, 120, 6);
          reset(div_4);

          action(
            div_4,
            ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
            () => ({
              content: $$props.tooltip,
              widthMaxContent: $$props.tooltipWidthMaxContent,
            }),
          );

          append($$anchor, div_4);
        };

        add_svelte_meta(
          () =>
            if_block(node_14, ($$render) => {
              if (disabledBecauseNotPro) $$render(consequent_5);
              else $$render(alternate_4, false);
            }),
          "if",
          Field,
          111,
          2,
        );
      }

      append($$anchor, fragment_10);
    };

    var alternate_5 = ($$anchor) => {
      add_svelte_meta(() => body($$anchor), "render", Field, 124, 2);
    };

    add_svelte_meta(
      () =>
        if_block(node_13, ($$render) => {
          if (strict_equals($$props.attachTooltip, "field"))
            $$render(consequent_6);
          else $$render(alternate_5, false);
        }),
      "if",
      Field,
      110,
      0,
    );
  }

  append($$anchor, fragment_9);

  return pop({ ...legacy_api() });
}

Checkbox_field[FILENAME] = "src/lib/components/form/checkbox-field.svelte";

var root_1$j = add_locations(from_html(`<input/>`), Checkbox_field[FILENAME], [
  [46, 2],
]);

function Checkbox_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Checkbox_field);

  let value = prop($$props, "value", 15),
    props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "label",
        "tooltip",
        "fieldBody",
        "defaultValue",
        "value",
        "oninput",
        "field",
      ],
      "props",
    );

  const id = generateFieldId($$props.label, componentId);
  const disabled = isProFeature();

  add_svelte_meta(
    () =>
      Field(
        $$anchor,
        spread_props(
          {
            get label() {
              return $$props.label;
            },

            get tooltip() {
              return $$props.tooltip;
            },

            get fieldBody() {
              return $$props.fieldBody;
            },

            attachTooltip: "field",

            get for() {
              return id;
            },

            labelLast: true,
            horizontal: true,
            labelColon: false,
          },
          () => $$props.field,
          {
            children: wrap_snippet(Checkbox_field, ($$anchor, $$slotProps) => {
              var input = root_1$j();

              remove_input_defaults(input);

              var event_handler = (event) => {
                if (disabled) {
                  return;
                }

                $$props.oninput?.(event);

                const newValue = event.currentTarget.checked;

                if (Array.isArray(value())) {
                  value()?.[1](newValue);
                } else {
                  value(newValue);
                }
              };

              attribute_effect(
                input,
                ($0) => ({
                  id,
                  type: "checkbox",
                  checked: $0,
                  disabled,
                  oninput: event_handler,
                  ...props,
                }),
                [
                  () =>
                    (Array.isArray(value())
                      ? (value()?.[0] ?? false)
                      : value()) ?? $$props.defaultValue,
                ],
                undefined,
                "svelte-19fj491",
              );

              action(input, ($$node) => disableSelectOnDoubleClick?.($$node));
              append($$anchor, input);
            }),

            $$slots: { default: true },
          },
        ),
      ),
    "component",
    Checkbox_field,
    35,
    0,
    { componentTag: "Field" },
  );

  return pop({ ...legacy_api() });
}

const colorNames = [
  "neutral",
  "stone",
  "zinc",
  "slate",
  "gray",
  "pink",
  "rose",
  "red",
  "orange",
  "amber",
  "yellow",
  "lime",
  "green",
  "emerald",
  "teal",
  "cyan",
  "sky",
  "blue",
  "indigo",
  "violet",
  "purple",
  "fuchsia",
];
const colorIntensities = [50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 950];
const style =
  typeof window === "undefined"
    ? { getPropertyValue: () => "" }
    : getComputedStyle(document.documentElement);
const computeColors = (colorNames2, swatches) => {
  for (const name of colorNames2) {
    for (const intensity of colorIntensities) {
      const cssVar = `--tg-am-color-${name}-${intensity}`;
      const color = style.getPropertyValue(cssVar);
      swatches.push(normalizeColor(color));
    }
  }
};
class ColorisState {
  isOpen = false;
  constructor() {
    if (typeof window !== "undefined") {
      import("./tg-am-vendor-CBMAXaHyD6.js")
        .then((n) => n.ao)
        .then((coloris) => coloris.init());
    }
  }
  #swatches;
  get swatches() {
    if (!this.#swatches) {
      this.#swatches = [];
      computeColors(colorNames, this.#swatches);
    }
    return this.#swatches;
  }
  #staggeredSwatches;
  get staggeredSwatches() {
    if (!this.#staggeredSwatches) {
      this.#staggeredSwatches = [];
      computeColors(stagger(colorNames), this.#staggeredSwatches);
    }
    return this.#staggeredSwatches;
  }
}
const colorisState = new ColorisState();

Map_box[FILENAME] = "src/lib/components/map-box.svelte";

var root_3$7 = add_locations(
  from_html(
    `<div> <div class="tg_am_pro_tag" style="display: inline-block; margin: 0"></div></div>`,
  ),
  Map_box[FILENAME],
  [[281, 6, [[283, 8]]]],
);
var root_1$i = add_locations(from_html(`<!> <!>`, 1), Map_box[FILENAME], []);
var root_4$5 = add_locations(
  from_html(`<div class="tg_am_controls svelte-i07hzf"><!> <!></div>`),
  Map_box[FILENAME],
  [[294, 4]],
);
var root$o = add_locations(
  from_html(`<!> <div><!> <!></div>`, 1),
  Map_box[FILENAME],
  [[250, 0]],
);

function Map_box($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Map_box);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const mapData = tag(
    user_derived(() => adminState.mapData[get(mapCode)]),
    "mapData",
  );
  const defaultMapData = tag(
    user_derived(() => adminState.mapData.__default),
    "defaultMapData",
  );
  let mapElementRef = tag(state(void 0), "mapElementRef");
  let mapRef = tag(state(void 0), "mapRef");

  const $$d = tag(
      user_derived(() => {
        const pinState = get(mapData).pins;
        const pinDetails = {};
        const pinShapes = {};

        for (const [id, pin] of Object.entries(pinState.details)) {
          if (isPin(pin)) {
            pinDetails[id] = pin;
            pinShapes[id] = pinState.shapes[id] ?? defaultPinShape;
          }
        }

        return [pinDetails, pinShapes];
      }),
      "[$derived iterable]",
    ),
    $$array = tag(
      user_derived(() => to_array(get($$d), 2)),
      "[$derived iterable]",
    ),
    pinDetails = tag(
      user_derived(() => get($$array)[0]),
      "pinDetails",
    ),
    pinShapes = tag(
      user_derived(() => get($$array)[1]),
      "pinShapes",
    );

  let isMapLoaded = tag(state(false), "isMapLoaded");
  const overlayId = "tg_am_map_path_highlight_overlay";

  const removeHighlight = () => {
    get(mapElementRef)?.querySelector(`#${overlayId}`)?.remove();
    get(mapElementRef)
      ?.querySelectorAll(".tg_am_map_path_highlight")
      ?.forEach((el) => el.classList.remove("tg_am_map_path_highlight"));
    get(mapElementRef)
      ?.querySelectorAll(".tg_am_map_pin_highlight")
      ?.forEach((el) => el.classList.remove("tg_am_map_pin_highlight"));
  };

  const resetHighlight = () => {
    adminState.highlightedRegionId = null;
    adminState.highlightedPinId = null;
    adminState.pinnedTooltipId = null;
    adminState.keepActiveTooltipVisible = false;
    adminState.regionSettingsPane = "region";
    removeHighlight();
  };

  const reorderElements = () => {
    const svg = get(mapElementRef)?.querySelector("svg");

    if (!svg) {
      return;
    }

    for (const el of [
      ...svg.querySelectorAll(`text[${dataAttributeBySection["regions"]}]`),
      ...svg.querySelectorAll(`[${dataAttributeBySection["pins"]}]`),
    ]) {
      svg.appendChild(el);
    }
  };

  user_effect(() => {
    void adminState.mapData[get(mapCode)].customRegions;
    resetHighlight();
  });

  user_effect(() => {
    if (!get(mapElementRef)) {
      return;
    }

    const onClick = (event) => {
      if (colorisState.isOpen) {
        return;
      }

      const target = event.target;

      if (target instanceof SVGSVGElement) {
        return resetHighlight();
      }

      if (!(target instanceof SVGElement)) {
        return;
      }

      const regionId = target.dataset[dataSetKeyBySection["regions"]];

      if (regionId) {
        adminState.highlightedRegionId = regionId;

        return;
      }

      const pinId = target.dataset[dataSetKeyBySection["pins"]];

      if (pinId) {
        adminState.highlightedPinId = pinId;

        return;
      }
    };

    get(mapElementRef).addEventListener("mouseup", onClick);

    return () => get(mapElementRef)?.removeEventListener("mouseup", onClick);
  });

  user_effect(() => {
    if (adminState.highlightedRegionId) {
      adminState.regionSettingsPane = "region";
      adminState.highlightedPinId = null;
      adminState.pinnedTooltipId = adminState.highlightedRegionId;
    }
  });

  user_effect(() => {
    if (adminState.highlightedPinId) {
      adminState.regionSettingsPane = "pins";
      adminState.highlightedRegionId = null;
      adminState.pinnedTooltipId = adminState.highlightedPinId;
    }
  });

  user_effect(() => {
    if (!adminState.highlightedRegionId || !get(mapElementRef)) {
      return;
    }

    void adminState.hasHoverEffects;
    void adminState.mapData[get(mapCode)].customRegions;
    removeHighlight();

    const regionId = adminState.highlightedRegionId;
    const selector = `path[${dataAttributeBySection["regions"]}="${regionId}"]`;
    const elRegion = get(mapElementRef).querySelector(selector);

    if (!elRegion) {
      return;
    }

    elRegion.classList.add("tg_am_map_path_highlight");

    const elOverlay = elRegion.cloneNode();

    elOverlay.id = "tg_am_map_path_highlight_overlay";

    const svg = elRegion.closest("svg");

    if (svg) {
      svg.appendChild(elRegion);
      svg.appendChild(elOverlay);
      reorderElements();
    }
  });

  user_effect(() => {
    if (!adminState.highlightedPinId || !get(mapElementRef)) {
      return;
    }

    void adminState.mapData[adminState.mapCode].pins.shapes[
      adminState.highlightedPinId
    ];
    removeHighlight();

    const pinId = adminState.highlightedPinId;
    const selector = `[${dataAttributeBySection["pins"]}="${pinId}"]`;
    const elPin = get(mapElementRef).querySelector(selector);

    elPin?.classList.add("tg_am_map_pin_highlight");
  });

  user_effect(() => {
    void adminState.hasUsStateLabels;
    reorderElements();
  });

  const clearTooltips = () => get(mapRef)?.clearTooltips();
  var fragment = root$o();
  var node = first_child(fragment);

  add_svelte_meta(
    () =>
      Admin_state_fields(node, {
        get mapId() {
          return $$props.mapId;
        },
      }),
    "component",
    Map_box,
    248,
    0,
    { componentTag: "AdminStateFields" },
  );

  var div = sibling(node, 2);
  var node_1 = child(div);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_1 = root_1$i();
      var node_2 = first_child(fragment_1);

      {
        var consequent = ($$anchor) => {
          {
            let $0 = user_derived(() => ({
              ...get(mapData).pins,
              details: get(pinDetails),
              shapes: get(pinShapes),
            }));

            let $1 = user_derived(() =>
              adminState.keepActiveTooltipVisible
                ? adminState.pinnedTooltipId
                : null,
            );

            add_svelte_meta(
              () =>
                bind_this(
                  Map($$anchor, {
                    get mapId() {
                      return $$props.mapId;
                    },

                    get mapCode() {
                      return get(mapCode);
                    },

                    get mapData() {
                      return $$props.mapData;
                    },

                    get themeId() {
                      return adminState.themeId;
                    },

                    get hasTooltips() {
                      return adminState.hasTooltips;
                    },

                    get hasActions() {
                      return adminState.hasActions;
                    },

                    get hasHoverEffects() {
                      return adminState.hasHoverEffects;
                    },

                    get hasRegionColors() {
                      return adminState.hasRegionColors;
                    },

                    get hasUsStateLabels() {
                      return adminState.hasUsStateLabels;
                    },

                    get usStateLabelSizePixels() {
                      return adminState.usStateLabelSizePixels;
                    },

                    get defaults() {
                      return get(defaultMapData);
                    },

                    get customThemes() {
                      return adminState.customThemes;
                    },

                    get regions() {
                      return get(mapData).regions;
                    },

                    get pins() {
                      return get($0);
                    },

                    get customRegions() {
                      return get(mapData).customRegions;
                    },

                    onLoad: () => {
                      set(isMapLoaded, true);
                      $$props.onLoad?.();
                    },

                    canFollowLinks: false,

                    get pinnedTooltipId() {
                      return get($1);
                    },

                    get element() {
                      return get(mapElementRef);
                    },

                    set element($$value) {
                      set(mapElementRef, $$value, true);
                    },
                  }),
                  ($$value) => set(mapRef, $$value, true),
                  () => get(mapRef),
                ),
              "component",
              Map_box,
              253,
              6,
              { componentTag: "Map" },
            );
          }
        };

        var alternate = ($$anchor) => {
          var div_1 = root_3$7();
          var text = child(div_1);

          next();
          reset(div_1);
          template_effect(
            ($0) =>
              set_text(
                text,
                `The ${$0 ?? ""} map is only available in ${proTitle}. `,
              ),
            [() => mapCodeToName(get(mapCode))],
          );
          append($$anchor, div_1);
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (isPro || isEssentialMapCode(get(mapCode)))
                $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          Map_box,
          252,
          4,
        );
      }

      var node_3 = sibling(node_2, 2);

      add_svelte_meta(
        () => snippet(node_3, () => $$props.children ?? noop),
        "render",
        Map_box,
        290,
        4,
      );
      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (get(mapCode)) $$render(consequent_1);
        }),
      "if",
      Map_box,
      251,
      2,
    );
  }

  var node_4 = sibling(node_1, 2);

  {
    var consequent_2 = ($$anchor) => {
      var div_2 = root_4$5();
      var node_5 = child(div_2);

      add_svelte_meta(
        () => snippet(node_5, () => $$props.controls ?? noop),
        "render",
        Map_box,
        295,
        6,
      );

      var node_6 = sibling(node_5, 2);

      validate_binding(
        "bind:value={adminState.keepActiveTooltipVisible}",
        () => adminState,
        () => "keepActiveTooltipVisible",
        300,
        8,
      );

      add_svelte_meta(
        () =>
          Checkbox_field(node_6, {
            label: "Keep active tooltip visible",
            tooltip:
              "Keeps the tooltip of the selected region or pin visible while it is selected.",

            get value() {
              return adminState.keepActiveTooltipVisible;
            },

            set value($$value) {
              adminState.keepActiveTooltipVisible = $$value;
            },
          }),
        "component",
        Map_box,
        297,
        6,
        { componentTag: "CheckboxField" },
      );

      reset(div_2);
      append($$anchor, div_2);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (get(isMapLoaded) && adminState.hasTooltips)
            $$render(consequent_2);
        }),
      "if",
      Map_box,
      293,
      2,
    );
  }

  reset(div);
  template_effect(() =>
    set_class(
      div,
      1,
      clsx(["tg_am_container", $$props.class]),
      "svelte-i07hzf",
    ),
  );
  append($$anchor, fragment);

  return pop({
    get resetHighlight() {
      return resetHighlight;
    },

    get clearTooltips() {
      return clearTooltips;
    },

    ...legacy_api(),
  });
}

const tooltipForCenteredTooltip = `Moving the tooltip to the region's center requires ${proTitle}.`;
const tooltipForInteractiveTooltip = `Allowing users to hover over the tooltip and click inside without the tooltip closing requires ${proTitle}.`;
const tooltipForUrlInNewTab = `Opening the followed URL in a new tab requires ${proTitle}.`;
const tooltipForRichText = `Allowing rich text such as formatting and images inside the tooltip requires ${proTitle}.`;
const tooltipForRegionColors = `Specifying individual colors for each region requires ${proTitle}.`;
const tooltipForHoverEffects = `Changing a region's background color on hover requires ${proTitle}.`;

Field_separator[FILENAME] = "src/lib/components/form/field-separator.svelte";

var root$n = add_locations(
  from_html(`<div></div>`),
  Field_separator[FILENAME],
  [[9, 0]],
);

function Field_separator($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Field_separator);

  const themeId = tag(
    user_derived(() => validateThemeId(isPro, adminState.themeId)),
    "themeId",
  );
  var div = root$n();

  template_effect(
    ($0) => set_class(div, 1, $0, "svelte-1wnlgux"),
    [() => clsx(getThemeClass(get(themeId)))],
  );
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

Select2[FILENAME] = "src/lib/components/ui/select2.svelte";

var root$m = add_locations(
  from_html(`<div><select><!></select></div>`),
  Select2[FILENAME],
  [[86, 0, [[87, 2]]]],
);

function Select2($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Select2);

  const props = rest_props(
    $$props,
    [
      "$$slots",
      "$$events",
      "$$legacy",
      "children",
      "value",
      "id",
      "onchange",
      "fullWidth",
      "searchable",
      "placeholder",
      "options",
      "tooltip",
    ],
    "props",
  );

  let ref;

  const maybeTooltip = (node) => {
    if ($$props.tooltip) {
      return tooltip(node, $$props.tooltip);
    }
  };

  const onAttach = (element) => {
    const s2Options = $$props.options ?? {};

    if (
      strict_equals(typeof $$props.searchable, "boolean") &&
      !$$props.searchable
    ) {
      s2Options.minimumResultsForSearch = -1;
    }

    if (strict_equals(typeof $$props.placeholder, "string")) {
      s2Options.placeholder = $$props.placeholder;
    }

    const jq = jQuery(element).select2(s2Options);

    if ($$props.onchange) {
      jq.on("change", $$props.onchange);
    }
  };

  const open = () => jQuery(ref).select2("open");
  const getValue = () => jQuery(ref).val();
  const setValue = (value) => jQuery(ref).val(value);

  user_effect(() => {
    jQuery(ref).val($$props.value).trigger("change.select2");
  });

  user_effect(() => {
    if ($$props.id) {
      const label = document.querySelector('label[for="' + $$props.id + '"]');

      if (label) {
        label.addEventListener("click", open);

        return () => label.removeEventListener("click", open);
      }
    }
  });

  user_effect(() => {
    const onOpen = $$props.options?.onOpen;

    if (!onOpen) {
      return;
    }

    jQuery(ref).on("select2:open", onOpen);

    return () => jQuery(ref).off("select2:open", onOpen);
  });

  var div = root$m();
  let classes;
  var select = child(div);

  attribute_effect(select, () => ({
    id: $$props.id,
    value: $$props.value,
    ...props,
  }));

  var node_1 = child(select);

  add_svelte_meta(
    () => snippet(node_1, () => $$props.children ?? noop),
    "render",
    Select2,
    88,
    4,
  );
  reset(select);
  bind_this(
    select,
    ($$value) => (ref = $$value),
    () => ref,
  );
  attach(select, () => onAttach);
  reset(div);
  action(div, ($$node) => maybeTooltip?.($$node));

  template_effect(
    ($0) => (classes = set_class(div, 1, "", null, classes, $0)),
    [() => ({ tg_am_full_width_select_container: $$props.fullWidth })],
  );

  append($$anchor, div);

  return pop({
    get open() {
      return open;
    },

    get getValue() {
      return getValue;
    },

    get setValue() {
      return setValue;
    },

    ...legacy_api(),
  });
}

Select_field[FILENAME] = "src/lib/components/form/select-field.svelte";

function Select_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Select_field);

  let value = prop($$props, "value", 15),
    fullWidth = prop($$props, "fullWidth", 3, true),
    select2Props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "label",
        "tooltip",
        "fieldBody",
        "children",
        "defaultValue",
        "value",
        "onchange",
        "fullWidth",
      ],
      "select2Props",
    );

  const id = generateFieldId($$props.label, componentId);
  let ref = tag(state(void 0), "ref");

  {
    let $0 = user_derived(() => ($$props.label ? "label" : "field"));

    add_svelte_meta(
      () =>
        Field($$anchor, {
          get label() {
            return $$props.label;
          },

          get tooltip() {
            return $$props.tooltip;
          },

          tooltipWidthMaxContent: false,

          get fieldBody() {
            return $$props.fieldBody;
          },

          get attachTooltip() {
            return get($0);
          },

          get for() {
            return id;
          },

          children: wrap_snippet(Select_field, ($$anchor, $$slotProps) => {
            {
              let $0 = user_derived(
                () =>
                  (Array.isArray(value()) ? value()?.[0] : value()) ??
                  $$props.defaultValue,
              );

              add_svelte_meta(
                () =>
                  bind_this(
                    Select2(
                      $$anchor,
                      spread_props(
                        {
                          get id() {
                            return id;
                          },

                          get fullWidth() {
                            return fullWidth();
                          },

                          get value() {
                            return get($0);
                          },

                          onchange: (event) => {
                            const newValue = event.currentTarget.value;

                            if (Array.isArray(value())) {
                              if (get(ref)) {
                                value()?.[1](newValue, get(ref));
                              }
                            } else {
                              value(newValue);
                            }
                          },
                        },
                        () => select2Props,
                        {
                          children: wrap_snippet(
                            Select_field,
                            ($$anchor, $$slotProps) => {
                              var fragment_2 = comment();
                              var node = first_child(fragment_2);

                              add_svelte_meta(
                                () =>
                                  snippet(node, () => $$props.children ?? noop),
                                "render",
                                Select_field,
                                62,
                                4,
                              );
                              append($$anchor, fragment_2);
                            },
                          ),

                          $$slots: { default: true },
                        },
                      ),
                    ),
                    ($$value) => set(ref, $$value, true),
                    () => get(ref),
                  ),
                "component",
                Select_field,
                45,
                2,
                { componentTag: "Select2" },
              );
            }
          }),

          $$slots: { default: true },
        }),
      "component",
      Select_field,
      37,
      0,
      { componentTag: "Field" },
    );
  }

  return pop({ ...legacy_api() });
}

Eye_icon[FILENAME] = "src/lib/components/icons/eye-icon.svelte";

var root$l = add_locations(
  from_svg(
    `<svg><path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle></svg>`,
  ),
  Eye_icon[FILENAME],
  [
    [
      10,
      0,
      [
        [20, 2],
        [23, 2],
      ],
    ],
  ],
);

function Eye_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Eye_icon);

  // See:
  // https://lucide.dev/icons/eye
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$l();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Eye_off_icon[FILENAME] = "src/lib/components/icons/eye-off-icon.svelte";

var root$k = add_locations(
  from_svg(
    `<svg><path d="M10.733 5.076a10.744 10.744 0 0 1 11.205 6.575 1 1 0 0 1 0 .696 10.747 10.747 0 0 1-1.444 2.49"></path><path d="M14.084 14.158a3 3 0 0 1-4.242-4.242"></path><path d="M17.479 17.499a10.75 10.75 0 0 1-15.417-5.151 1 1 0 0 1 0-.696 10.75 10.75 0 0 1 4.446-5.143"></path><path d="m2 2 20 20"></path></svg>`,
  ),
  Eye_off_icon[FILENAME],
  [
    [
      10,
      0,
      [
        [20, 2],
        [23, 2],
        [24, 2],
        [27, 2],
      ],
    ],
  ],
);

function Eye_off_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Eye_off_icon);

  // See:
  // https://lucide.dev/icons/eye-off
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$k();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Toggle_checkbox[FILENAME] = "src/lib/components/form/toggle-checkbox.svelte";

const toggle = (_, hasOptions, storageKey) => {
  set(hasOptions, !get(hasOptions));
  localStorageSetItem(storageKey, get(hasOptions).toString());
};

var root_1$h = add_locations(
  from_html(`<button type="button" class="button"><!></button>`),
  Toggle_checkbox[FILENAME],
  [[50, 4]],
);
var root$j = add_locations(
  from_html(
    `<div class="tg_am_toggle"><div class="tg_am_toggle_checkbox svelte-1j6shh"><!></div> <!></div> <!>`,
    1,
  ),
  Toggle_checkbox[FILENAME],
  [[44, 0, [[45, 2]]]],
);

function Toggle_checkbox($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Toggle_checkbox);

  var $$ownership_validator = create_ownership_validator($$props);
  let value = prop($$props, "value", 15);
  const isOpen = tag(
    user_derived(
      () => $$props.children && (Array.isArray(value()) ? value()[0] : value()),
    ),
    "isOpen",
  );
  const storageKey = `${$$props.id}__toggle`;
  const fromStorage = localStorageGetItem(storageKey) ?? false;
  const defaultHasOptions = true;

  let hasOptions = tag(
    state(
      proxy(
        $$props.id
          ? strict_equals(fromStorage, null)
            ? defaultHasOptions
            : strict_equals(fromStorage, "true")
          : defaultHasOptions,
      ),
    ),
    "hasOptions",
  );

  var fragment = root$j();
  var div = first_child(fragment);
  var div_1 = child(div);
  var node = child(div_1);

  {
    $$ownership_validator.binding("value", Checkbox_field, value);

    add_svelte_meta(
      () =>
        Checkbox_field(node, {
          get label() {
            return $$props.label;
          },

          get value() {
            return value();
          },

          set value($$value) {
            value($$value);
          },
        }),
      "component",
      Toggle_checkbox,
      46,
      4,
      { componentTag: "CheckboxField" },
    );
  }

  reset(div_1);

  var node_1 = sibling(div_1, 2);

  {
    var consequent_1 = ($$anchor) => {
      var button = root_1$h();

      button.__click = [toggle, hasOptions, storageKey];

      var node_2 = child(button);

      {
        var consequent = ($$anchor) => {
          add_svelte_meta(
            () => Eye_icon($$anchor, {}),
            "component",
            Toggle_checkbox,
            57,
            8,
            { componentTag: "EyeIcon" },
          );
        };

        var alternate = ($$anchor) => {
          add_svelte_meta(
            () => Eye_off_icon($$anchor, {}),
            "component",
            Toggle_checkbox,
            59,
            8,
            { componentTag: "EyeOffIcon" },
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (get(hasOptions)) $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          Toggle_checkbox,
          56,
          6,
        );
      }

      reset(button);
      template_effect(() =>
        set_attribute(button, "aria-label", get(hasOptions) ? "Show" : "Hide"),
      );
      append($$anchor, button);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (get(isOpen)) $$render(consequent_1);
        }),
      "if",
      Toggle_checkbox,
      49,
      2,
    );
  }

  reset(div);

  var node_3 = sibling(div, 2);

  {
    var consequent_2 = ($$anchor) => {
      var fragment_3 = comment();
      var node_4 = first_child(fragment_3);

      add_svelte_meta(
        () => snippet(node_4, () => $$props.children),
        "render",
        Toggle_checkbox,
        66,
        2,
      );
      append($$anchor, fragment_3);
    };

    add_svelte_meta(
      () =>
        if_block(node_3, ($$render) => {
          if (get(isOpen) && $$props.children && get(hasOptions))
            $$render(consequent_2);
        }),
      "if",
      Toggle_checkbox,
      65,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

With_pro[FILENAME] = "src/lib/components/ui/with-pro.svelte";

var root_2$7 = add_locations(
  from_html(`<div><!> <div class="tg_am_pro_tag"></div></div>`),
  With_pro[FILENAME],
  [[26, 2, [[34, 4]]]],
);

function With_pro($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, With_pro);

  {
    setIsProFeature();
  }

  var fragment = comment();
  var node = first_child(fragment);

  {
    var consequent = ($$anchor) => {
      var fragment_1 = comment();
      var node_1 = first_child(fragment_1);

      add_svelte_meta(
        () => snippet(node_1, () => $$props.children),
        "render",
        With_pro,
        24,
        2,
      );
      append($$anchor, fragment_1);
    };

    var alternate = ($$anchor) => {
      var div = root_2$7();
      var node_2 = child(div);

      add_svelte_meta(
        () => snippet(node_2, () => $$props.children),
        "render",
        With_pro,
        33,
        4,
      );
      next(2);
      reset(div);

      template_effect(
        ($0) => {
          set_class(
            div,
            1,
            clsx([
              "tg_am_pro_container",

              $$props.spread
                ? "tg_am_pro_container_spread"
                : "tg_am_pro_container_static",
            ]),
          );

          set_attribute(div, "data-tg-am-pro", $0);
        },
        [() => proFeatureToData($$props.feature)],
      );

      append($$anchor, div);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (isPro);
          else $$render(alternate, false);
        }),
      "if",
      With_pro,
      23,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Region_colors_checkbox[FILENAME] =
  "src/lib/components/region-colors-checkbox.svelte";

var $$_import_adminState = reactive_import(() => adminState);

function Region_colors_checkbox($$anchor, $$props) {
  check_target(new.target);
  push($$props, false, Region_colors_checkbox);
  init();

  add_svelte_meta(
    () =>
      With_pro($$anchor, {
        feature: { id: "region_colors" },

        children: wrap_snippet(
          Region_colors_checkbox,
          ($$anchor, $$slotProps) => {
            {
              let $0 = derived_safe_equal(() => [
                isPro ? $$_import_adminState().hasRegionColors : false,
                (newValue) =>
                  $$_import_adminState(
                    ($$_import_adminState().hasRegionColors = newValue),
                  ),
              ]);

              add_svelte_meta(
                () =>
                  Checkbox_field($$anchor, {
                    label: "Region Colors",

                    get tooltip() {
                      return tooltipForRegionColors;
                    },

                    get value() {
                      return get($0);
                    },
                  }),
                "component",
                Region_colors_checkbox,
                10,
                2,
                { componentTag: "CheckboxField" },
              );
            }
          },
        ),

        $$slots: { default: true },
      }),
    "component",
    Region_colors_checkbox,
    9,
    0,
    { componentTag: "WithPro" },
  );

  return pop({ ...legacy_api() });
}

Text_field[FILENAME] = "src/lib/components/form/text-field.svelte";

var root_1$g = add_locations(from_html(`<input/>`), Text_field[FILENAME], [
  [30, 2],
]);

function Text_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Text_field);

  let value = prop($$props, "value", 15),
    props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "label",
        "tooltip",
        "fieldBody",
        "defaultValue",
        "value",
        "oninput",
      ],
      "props",
    );

  const id = generateFieldId($$props.label, componentId);

  add_svelte_meta(
    () =>
      Field($$anchor, {
        get label() {
          return $$props.label;
        },

        get tooltip() {
          return $$props.tooltip;
        },

        get fieldBody() {
          return $$props.fieldBody;
        },

        get for() {
          return id;
        },

        children: wrap_snippet(Text_field, ($$anchor, $$slotProps) => {
          var input = root_1$g();

          remove_input_defaults(input);

          var event_handler = (event) => {
            $$props.oninput?.(event);

            const newValue = event.currentTarget.value;

            if (Array.isArray(value())) {
              value()?.[1](newValue);
            } else {
              value(newValue);
            }
          };

          attribute_effect(
            input,
            ($0) => ({
              id,
              style: "width: 100%; transform: translateX(-1px);",
              type: "text",
              value: $0,
              oninput: event_handler,
              ...props,
            }),
            [
              () =>
                (Array.isArray(value()) ? value()?.[0] : value()) ??
                $$props.defaultValue,
            ],
          );

          append($$anchor, input);
        }),

        $$slots: { default: true },
      }),
    "component",
    Text_field,
    29,
    0,
    { componentTag: "Field" },
  );

  return pop({ ...legacy_api() });
}

With_default[FILENAME] = "src/lib/components/ui/with-default.svelte";

const onSetDefaultClick = (event, $$props) => {
  event.preventDefault();
  $$props.setDefault();
};

var root_2$6 = add_locations(
  from_html(`<div class="tg_am_default_text svelte-9ix18t">(default)</div>`),
  With_default[FILENAME],
  [[31, 8]],
);
var root_3$6 = add_locations(
  from_html(`<a href="#" style="display: block">(set default)</a>`),
  With_default[FILENAME],
  [[34, 8]],
);
var root_1$f = add_locations(
  from_html(`<div class="tg_am_default_controls svelte-9ix18t"><!></div>`),
  With_default[FILENAME],
  [[24, 4]],
);
var root$i = add_locations(
  from_html(`<div class="tg_am_default_container svelte-9ix18t"><!> <!></div>`),
  With_default[FILENAME],
  [[20, 0]],
);

function With_default($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, With_default);

  var div = root$i();
  var node = child(div);

  add_svelte_meta(
    () => snippet(node, () => $$props.children),
    "render",
    With_default,
    21,
    2,
  );

  var node_1 = sibling(node, 2);

  {
    var consequent_1 = ($$anchor) => {
      var div_1 = root_1$f();
      var node_2 = child(div_1);

      {
        var consequent = ($$anchor) => {
          var div_2 = root_2$6();

          append($$anchor, div_2);
        };

        var alternate = ($$anchor) => {
          var a = root_3$6();

          a.__click = [onSetDefaultClick, $$props];
          append($$anchor, a);
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if ($$props.isDefault) $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          With_default,
          30,
          6,
        );
      }

      reset(div_1);

      action(
        div_1,
        ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
        () =>
          $$props.isDefault
            ? "This is the default value. You can change the default value under Map Settings."
            : "Resets to the default value.",
      );

      append($$anchor, div_1);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (isPro || isProFeature()) $$render(consequent_1);
        }),
      "if",
      With_default,
      23,
      2,
    );
  }

  reset(div);
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Action_selector[FILENAME] =
  "src/lib/components/region-settings-box/action-selector.svelte";

var root_6$4 = add_locations(
  from_html(`<div><!></div>`),
  Action_selector[FILENAME],
  [[121, 4]],
);
var root_9$4 = add_locations(
  from_html(`<option> </option>`),
  Action_selector[FILENAME],
  [[73, 6]],
);
var root_10$3 = add_locations(
  from_html(`<!> <!>`, 1),
  Action_selector[FILENAME],
  [],
);
var root$h = add_locations(
  from_html(`<!> <!>`, 1),
  Action_selector[FILENAME],
  [],
);

function Action_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Action_selector);

  var $$ownership_validator = create_ownership_validator($$props);

  const inNewTab = wrap_snippet(
    Action_selector,
    function ($$anchor, label = noop) {
      validate_snippet_args(...arguments);

      var fragment_2 = comment();

      const body = wrap_snippet(Action_selector, function ($$anchor) {
        validate_snippet_args(...arguments);

        add_svelte_meta(
          () =>
            With_pro($$anchor, {
              children: wrap_snippet(
                Action_selector,
                ($$anchor, $$slotProps) => {
                  {
                    let $0 = user_derived(() => [
                      isPro
                        ? (actions().urlsInNewTab[$$props.id] ??
                          get(defaultAction).urlsInNewTab.__default ??
                          false)
                        : false,

                      (newValue) =>
                        $$ownership_validator.mutation(
                          "actions",
                          ["actions", "urlsInNewTab", $$props.id],
                          (actions().urlsInNewTab[$$props.id] = newValue),
                          107,
                          25,
                        ),
                    ]);

                    add_svelte_meta(
                      () =>
                        Checkbox_field($$anchor, {
                          get label() {
                            return label();
                          },

                          get tooltip() {
                            return tooltipForUrlInNewTab;
                          },

                          get value() {
                            return get($0);
                          },
                        }),
                      "component",
                      Action_selector,
                      98,
                      6,
                      { componentTag: "CheckboxField" },
                    );
                  }
                },
              ),

              $$slots: { default: true },
            }),
          "component",
          Action_selector,
          97,
          4,
          { componentTag: "WithPro" },
        );
      });

      var node = first_child(fragment_2);

      {
        var consequent = ($$anchor) => {
          {
            let $0 = user_derived(() =>
              strict_equals(
                typeof actions().urlsInNewTab[$$props.id],
                "boolean",
                false,
              ),
            );

            add_svelte_meta(
              () =>
                With_default($$anchor, {
                  get isDefault() {
                    return get($0);
                  },

                  setDefault: () =>
                    $$ownership_validator.mutation(
                      "actions",
                      ["actions", "urlsInNewTab", $$props.id],
                      (actions().urlsInNewTab[$$props.id] = null),
                      116,
                      25,
                    ),

                  children: wrap_snippet(
                    Action_selector,
                    ($$anchor, $$slotProps) => {
                      add_svelte_meta(
                        () => body($$anchor),
                        "render",
                        Action_selector,
                        118,
                        6,
                      );
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Action_selector,
              114,
              4,
              { componentTag: "WithDefault" },
            );
          }
        };

        var alternate = ($$anchor) => {
          var div = root_6$4();

          set_style(div, "", {}, { display: "flex" });

          var node_1 = child(div);

          add_svelte_meta(
            () => body(node_1),
            "render",
            Action_selector,
            122,
            6,
          );
          reset(div);
          append($$anchor, div);
        };

        add_svelte_meta(
          () =>
            if_block(node, ($$render) => {
              if (includeDefault()) $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          Action_selector,
          113,
          2,
        );
      }

      append($$anchor, fragment_2);
    },
  );

  const actions = prop($$props, "actions", 7),
    includeDefault = prop($$props, "includeDefault", 3, true);

  const defaultAction = tag(
    user_derived(() => adminState.mapData.__default[$$props.section].actions),
    "defaultAction",
  );
  const defaultUrl = tag(
    user_derived(() => get(defaultAction).urls.__default),
    "defaultUrl",
  );
  const defaultType = tag(
    user_derived(
      () =>
        adminState.mapData.__default[$$props.section].actions.types.__default ??
        defaultActionType,
    ),
    "defaultType",
  );

  const options = tag(
    user_derived(() => {
      const descriptors = {};

      for (let [actionType, descriptor] of Object.entries(actionDescriptors)) {
        if (strict_equals(actionType, "default")) {
          if (!includeDefault()) {
            continue;
          }

          descriptor = {
            ...descriptor,
            text: `${descriptor.text} (${actionDescriptors[get(defaultType)].text})`,
          };
        }

        descriptors[actionType] = descriptor;
      }

      return descriptors;
    }),
    "options",
  );

  const sectionSingular = mapDataSectionSingular($$props.section);
  var fragment_5 = root$h();
  var node_2 = first_child(fragment_5);

  add_svelte_meta(
    () =>
      key(
        node_2,
        () => get(options),
        ($$anchor) => {
          validate_binding(
            "bind:value={actions.types[id]}",
            () => actions().types,
            () => $$props.id,
            70,
            4,
          );

          {
            let $0 = user_derived(
              () =>
                `Select an action to be performed when a ${sectionSingular} is clicked.`,
            );
            let $1 = user_derived(() =>
              includeDefault() ? "default" : defaultActionType,
            );

            $$ownership_validator.binding(
              "actions",
              Select_field,
              () => actions().types[$$props.id],
            );

            add_svelte_meta(
              () =>
                Select_field($$anchor, {
                  label: "Click Action",

                  get tooltip() {
                    return get($0);
                  },

                  searchable: false,

                  get defaultValue() {
                    return get($1);
                  },

                  get value() {
                    return actions().types[$$props.id];
                  },

                  set value($$value) {
                    $$ownership_validator.mutation(
                      "actions",
                      ["actions", "types", $$props.id],
                      (actions().types[$$props.id] = $$value),
                      70,
                      16,
                    );
                  },

                  children: wrap_snippet(
                    Action_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_7 = comment();
                      var node_3 = first_child(fragment_7);

                      add_svelte_meta(
                        () =>
                          each(
                            node_3,
                            17,
                            () => Object.entries(get(options)),
                            index,
                            ($$anchor, $$item, $$index, $$array) => {
                              var $$array_1 = user_derived(() =>
                                to_array(get($$item), 2),
                              );
                              let id = () => get($$array_1)[0];

                              id();

                              let text = () => get($$array_1)[1].text;

                              text();

                              var option = root_9$4();
                              var text_1 = child(option, true);

                              reset(option);

                              var option_value = {};

                              template_effect(() => {
                                set_text(text_1, text());

                                if (option_value !== (option_value = id())) {
                                  option.value = (option.__value = id()) ?? "";
                                }
                              });

                              append($$anchor, option);
                            },
                          ),
                        "each",
                        Action_selector,
                        72,
                        4,
                      );

                      append($$anchor, fragment_7);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Action_selector,
              65,
              2,
              { componentTag: "SelectField" },
            );
          }
        },
      ),
    "key",
    Action_selector,
    64,
    0,
  );

  var node_4 = sibling(node_2, 2);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_8 = root_10$3();
      var node_5 = first_child(fragment_8);

      validate_binding(
        "bind:value={actions.urls[id]}",
        () => actions().urls,
        () => $$props.id,
        87,
        4,
      );

      {
        let $0 = user_derived(
          () => `URL to follow when a ${sectionSingular} is clicked.`,
        );

        let $1 = user_derived(() =>
          includeDefault()
            ? get(defaultUrl)
              ? `${get(defaultUrl)} (default)`
              : null
            : null,
        );

        $$ownership_validator.binding(
          "actions",
          Text_field,
          () => actions().urls[$$props.id],
        );

        add_svelte_meta(
          () =>
            Text_field(node_5, {
              label: "URL",

              get tooltip() {
                return get($0);
              },

              get placeholder() {
                return get($1);
              },

              get value() {
                return actions().urls[$$props.id];
              },

              set value($$value) {
                $$ownership_validator.mutation(
                  "actions",
                  ["actions", "urls", $$props.id],
                  (actions().urls[$$props.id] = $$value),
                  87,
                  16,
                );
              },
            }),
          "component",
          Action_selector,
          79,
          2,
          { componentTag: "TextField" },
        );
      }

      var node_6 = sibling(node_5, 2);

      add_svelte_meta(
        () => inNewTab(node_6, () => "In new tab"),
        "render",
        Action_selector,
        90,
        2,
      );
      append($$anchor, fragment_8);
    };

    var alternate_1 = ($$anchor) => {
      var fragment_9 = comment();
      var node_7 = first_child(fragment_9);

      {
        var consequent_2 = ($$anchor) => {
          add_svelte_meta(
            () => inNewTab($$anchor, () => "Follow URLs in new tab"),
            "render",
            Action_selector,
            92,
            2,
          );
        };

        add_svelte_meta(
          () =>
            if_block(
              node_7,
              ($$render) => {
                if (
                  !includeDefault() ||
                  ((!actions().types[$$props.id] ||
                    strict_equals(actions().types[$$props.id], "default")) &&
                    strict_equals(get(defaultType), "follow_url"))
                )
                  $$render(consequent_2);
              },
              true,
            ),
          "if",
          Action_selector,
          91,
          0,
        );
      }

      append($$anchor, fragment_9);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (strict_equals(actions().types[$$props.id], "follow_url"))
            $$render(consequent_1);
          else $$render(alternate_1, false);
        }),
      "if",
      Action_selector,
      78,
      0,
    );
  }

  append($$anchor, fragment_5);

  return pop({ ...legacy_api() });
}

Pin_text_examples[FILENAME] = "src/lib/components/pin-text-examples.svelte";

var root$g = add_locations(
  from_html(
    `<div class="tg_am_map_field_example"><div>Replacements:</div> <dl><dt><code></code></dt> <dd> </dd></dl></div>`,
  ),
  Pin_text_examples[FILENAME],
  [
    [
      13,
      0,
      [
        [14, 2],
        [
          15,
          2,
          [
            [16, 4, [[16, 8]]],
            [17, 4],
          ],
        ],
      ],
    ],
  ],
);

function Pin_text_examples($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_text_examples);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const pin = tag(
    user_derived(
      () => adminState.mapData[get(mapCode)].pins.details[$$props.pinId],
    ),
    "pin",
  );
  var div = root$g();
  var dl = sibling(child(div), 2);
  var dt = child(dl);
  var code = child(dt);

  code.textContent = "{pin-name}";
  reset(dt);

  var dd = sibling(dt, 2);
  var text = child(dd);

  reset(dd);
  reset(dl);
  reset(div);
  template_effect(() =>
    set_text(text, `Example: ${get(pin)?.name ?? "Pin 1" ?? ""}`),
  );
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

Text_area_field[FILENAME] = "src/lib/components/form/text-area-field.svelte";

var root_1$e = add_locations(
  from_html(`<textarea></textarea>`),
  Text_area_field[FILENAME],
  [[30, 2]],
);

function Text_area_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Text_area_field);

  let value = prop($$props, "value", 15),
    props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "label",
        "tooltip",
        "defaultValue",
        "fieldBody",
        "value",
        "oninput",
      ],
      "props",
    );

  const id = generateFieldId($$props.label, componentId);

  add_svelte_meta(
    () =>
      Field($$anchor, {
        get label() {
          return $$props.label;
        },

        get tooltip() {
          return $$props.tooltip;
        },

        get fieldBody() {
          return $$props.fieldBody;
        },

        get for() {
          return id;
        },

        children: wrap_snippet(Text_area_field, ($$anchor, $$slotProps) => {
          var textarea = root_1$e();

          remove_textarea_child(textarea);

          var event_handler = (event) => {
            $$props.oninput?.(event);

            const newValue = event.currentTarget.value;

            if (Array.isArray(value())) {
              value()?.[1](newValue);
            } else {
              value(newValue);
            }
          };

          attribute_effect(
            textarea,
            ($0) => ({
              id,
              rows: 4,
              autocomplete: "off",
              oninput: event_handler,
              ...props,
              value: $0,
              [STYLE]: { width: "100%" },
            }),
            [
              () =>
                (Array.isArray(value()) ? (value()?.[0] ?? null) : value()) ??
                $$props.defaultValue ??
                "",
            ],
          );

          append($$anchor, textarea);
        }),

        $$slots: { default: true },
      }),
    "component",
    Text_area_field,
    29,
    0,
    { componentTag: "Field" },
  );

  return pop({ ...legacy_api() });
}

Wp_editor[FILENAME] = "src/lib/components/ui/wp-editor.svelte";

var root$f = add_locations(
  from_html(`<textarea></textarea>`),
  Wp_editor[FILENAME],
  [[223, 0]],
);

function Wp_editor($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Wp_editor);

  const props = rest_props(
    $$props,
    [
      "$$slots",
      "$$events",
      "$$legacy",
      "id",
      "defaultValue",
      "onRichTextChange",
      "class",
    ],
    "props",
  );

  const id = $$props.id ?? "tg_am_rich_editor_" + componentId;

  const toolbar1 = [
    "bold",
    "italic",
    "strikethrough",
    "bullist",
    "numlist",
    "blockquote",
    "hr",
    "alignleft",
    "aligncenter",
    "alignright",
    "link",
    "unlink",
  ].join(",");

  const getStyle = () => {
    let style = "";

    for (const elStyle of document.querySelectorAll("style")) {
      const content = elStyle.textContent;

      if (content.includes("tg_am_")) {
        style += content + "\n\n";
      }
    }

    return style;
  };

  const getStyleLinks = () => {
    const styleLinks = [];

    for (const link of document.querySelectorAll("link[rel=stylesheet]")) {
      const href = link.getAttribute("href") ?? "";

      if (href.includes("/tg-am-")) {
        styleLinks.push(href);
      }
    }

    return styleLinks;
  };

  const themeId = tag(
    user_derived(() => validateThemeId(isPro, adminState.themeId)),
    "themeId",
  );
  let editorBodyRef = tag(state(void 0), "editorBodyRef");

  user_effect(() => {
    if (!get(editorBodyRef)) {
      return;
    }

    void adminState.themeId;
    get(editorBodyRef).dataset.theme = getThemeClass(get(themeId));
  });

  user_effect(() => {
    void adminState.themeId;
    void adminState.customThemes[adminState.themeId]?.definition
      .regionTooltipBackgroundColor;
    void adminState.customThemes[adminState.themeId]?.definition
      .regionTooltipForegroundColor;
    void adminState.customThemes[adminState.themeId]?.definition
      .regionHoverBackgroundColor;
    void adminState.customThemes[adminState.themeId]?.definition
      .regionHoverForegroundColor;

    const editor = tinymce.get(id);

    if (editor) {
      setTimeout(() => tmceSetup(editor));
    }
  });

  const tmceSetup = (editor) => {
    const body = editor?.getBody();

    if (!body) {
      return;
    }

    body.classList.add("tg_am_rich_text_editor", "tippy-box");
    body.dataset.theme = getThemeClass(get(themeId));
    set(editorBodyRef, body, true);

    const head = body.ownerDocument?.head;

    if (!head) {
      return;
    }

    const style = getStyle();

    if (style) {
      let elStyle = head.querySelector(`style[data-tg-am-wp-editor="${id}"]`);

      if (!elStyle) {
        elStyle = document.createElement("style");
        elStyle.dataset.tgAmWpEditor = id;
        head.appendChild(elStyle);
      }

      elStyle.textContent = style;
    }

    const styleLinks = getStyleLinks();

    for (const link of styleLinks) {
      let found = false;

      for (const elLink of head.querySelectorAll('link[rel="stylesheet"]')) {
        if (
          elLink instanceof HTMLLinkElement &&
          strict_equals(elLink.href, link)
        ) {
          found = true;

          break;
        }
      }

      if (!found) {
        const elLink = document.createElement("link");

        elLink.rel = "stylesheet";
        elLink.href = link;
        head.appendChild(elLink);
      }
    }

    editor.on("change keyup paste", () => {
      const content = editor.getContent();

      $$props.onRichTextChange?.(content);
    });
  };

  const open = () => {
    window.wpActiveEditor = id;

    const getSelectedLink = (editor) => {
      var href,
        html,
        node = editor.selection.getStart(),
        link = editor.dom.getParent(node, "a[href]");

      if (!link) {
        html = editor.selection.getContent({ format: "raw" });

        if (html && strict_equals(html.indexOf("</a>"), -1, false)) {
          href = html.match(/href="([^">]+)"/);

          if (href && href[1]) {
            link = editor.jQuery('a[href="' + href[1] + '"]', node)[0];
          }

          if (link) {
            editor.selection.select(link);
          }
        }
      }

      return link;
    };

    const overrideLinkCommand = (editor) => {
      if (window.wpLink) {
        editor.addCommand("WP_Link", () => {
          window.wpActiveEditor = editor.id;

          const linkNode = getSelectedLink(editor);
          let url = undefined;
          let text = undefined;

          if (linkNode) {
            url = linkNode.href;
            text = linkNode.textContent;
            editor.dom.setAttribs(linkNode, { "data-wplink-edit": true });
          }

          wpLink.open(editor.id, url, text);
        });
      }
    };

    wp.editor.initialize(id, {
      tinymce: {
        toolbar1,

        setup(editor) {
          editor.on?.("init", () => {
            tmceSetup(editor);
            overrideLinkCommand(editor);
          });
        },
      },

      quicktags: true,
      mediaButtons: true,
    });
  };

  const close = () => {
    window.wpActiveEditor = null;
    set(editorBodyRef, null);
    wp.editor.remove(id);
  };

  user_effect(() => {
    close();
    open();

    return close;
  });

  const classes = ["wp-editor-area", $$props.class];
  var textarea = root$f();

  remove_textarea_child(textarea);

  attribute_effect(textarea, () => ({
    id,
    class: classes,
    ...props,
    value: $$props.defaultValue ?? "",
  }));

  append($$anchor, textarea);

  return pop({ ...legacy_api() });
}

Wp_editor_field[FILENAME] = "src/lib/components/form/wp-editor-field.svelte";

function Wp_editor_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Wp_editor_field);

  let value = prop($$props, "value", 15),
    props = rest_props(
      $$props,
      [
        "$$slots",
        "$$events",
        "$$legacy",
        "label",
        "tooltip",
        "fieldBody",
        "defaultValue",
        "value",
        "onRichTextChange",
        "oninput",
      ],
      "props",
    );

  const id = generateFieldId($$props.label, componentId);

  const updateValue = (newValue) => {
    if (Array.isArray(value())) {
      value()?.[1](newValue);
    } else {
      value(newValue);
    }
  };

  add_svelte_meta(
    () =>
      Field($$anchor, {
        get label() {
          return $$props.label;
        },

        get tooltip() {
          return $$props.tooltip;
        },

        get fieldBody() {
          return $$props.fieldBody;
        },

        get for() {
          return id;
        },

        children: wrap_snippet(Wp_editor_field, ($$anchor, $$slotProps) => {
          {
            let $0 = user_derived(
              () =>
                (Array.isArray(value()) ? (value()?.[0] ?? null) : value()) ??
                $$props.defaultValue ??
                "",
            );

            add_svelte_meta(
              () =>
                Wp_editor(
                  $$anchor,
                  spread_props(
                    {
                      get id() {
                        return id;
                      },

                      rows: 10,
                      autocomplete: "off",

                      get defaultValue() {
                        return get($0);
                      },

                      oninput: (event) => {
                        $$props.oninput?.(event);
                        updateValue(event.currentTarget.value);
                      },

                      onRichTextChange: (newValue) => {
                        $$props.onRichTextChange?.(newValue);
                        updateValue(newValue);
                      },
                    },
                    () => props,
                  ),
                ),
              "component",
              Wp_editor_field,
              40,
              2,
              { componentTag: "WpEditor" },
            );
          }
        }),

        $$slots: { default: true },
      }),
    "component",
    Wp_editor_field,
    39,
    0,
    { componentTag: "Field" },
  );

  return pop({ ...legacy_api() });
}

/* flash-action.svelte.ts generated by Svelte v5.38.1 */

const flash = (node, props) => {
  const { eventName } = props ?? {};

  if (!eventName) {
    return;
  }

  const onHighlight = () => {
    node.classList.remove("tg_am_flashing");

    setTimeout(() => {
      node.classList.add("tg_am_flashing");
    });
  };

  const removeFlashing = () => {
    node.classList.remove("tg_am_flashing");
  };

  document.addEventListener(eventName, onHighlight);
  document.addEventListener("click", removeFlashing);
  node.addEventListener("animationend", removeFlashing);

  return {
    destroy() {
      document.removeEventListener(eventName, onHighlight);
      document.removeEventListener("click", removeFlashing);
      node.removeEventListener("animationend", removeFlashing);
    },
  };
};

Tooltip_selector[FILENAME] =
  "src/lib/components/region-settings-box/tooltip-selector.svelte";

var root_9$3 = add_locations(
  from_html(`<option> </option>`),
  Tooltip_selector[FILENAME],
  [[122, 6]],
);
var root_15 = add_locations(
  from_html(
    `<div class="tg_am_link_warning svelte-1aps3bi"><strong>Warning:</strong> Tooltip links are only reachable in <a>interactive</a> tooltips.</div>`,
  ),
  Tooltip_selector[FILENAME],
  [
    [
      159,
      8,
      [
        [160, 10],
        [162, 10],
      ],
    ],
  ],
);
var root_13 = add_locations(
  from_html(`<div><!> <!></div>`),
  Tooltip_selector[FILENAME],
  [[142, 4]],
);
var root_10$2 = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Tooltip_selector[FILENAME],
  [],
);
var root$e = add_locations(
  from_html(`<!> <!> <div style="scroll-margin: 12px;"><!></div> <!>`, 1),
  Tooltip_selector[FILENAME],
  [[173, 0]],
);

function Tooltip_selector($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Tooltip_selector);

  var $$ownership_validator = create_ownership_validator($$props);

  const checkbox = wrap_snippet(
    Tooltip_selector,
    function ($$anchor, selector = noop) {
      validate_snippet_args(...arguments);

      var fragment_2 = comment();

      const body = wrap_snippet(Tooltip_selector, function ($$anchor) {
        validate_snippet_args(...arguments);

        const label = tag(
          user_derived(() => ucfirst(selector())),
          "label",
        );

        get(label);

        const tooltip = tag(
          user_derived(() =>
            strict_equals(selector(), "interactive")
              ? tooltipForInteractiveTooltip
              : tooltipForCenteredTooltip,
          ),
          "tooltip",
        );

        get(tooltip);

        const feature = tag(
          user_derived(() => ({
            id: strict_equals(selector(), "interactive")
              ? "interactive_tooltip"
              : "centered_tooltip",
          })),
          "feature",
        );

        get(feature);

        add_svelte_meta(
          () =>
            With_pro($$anchor, {
              get feature() {
                return get(feature);
              },

              children: wrap_snippet(
                Tooltip_selector,
                ($$anchor, $$slotProps) => {
                  {
                    let $0 = user_derived(() => [
                      isPro
                        ? (tooltips()[selector()][$$props.id] ??
                          adminState.mapData.__default[$$props.section]
                            .tooltips[selector()].__default ??
                          false)
                        : false,

                      (newValue) =>
                        $$ownership_validator.mutation(
                          "tooltips",
                          ["tooltips", selector(), $$props.id],
                          tooltips(
                            (tooltips()[selector()][$$props.id] = newValue),
                            true,
                          ),
                          219,
                          25,
                        ),
                    ]);

                    add_svelte_meta(
                      () =>
                        Checkbox_field($$anchor, {
                          get label() {
                            return get(label);
                          },

                          get tooltip() {
                            return get(tooltip);
                          },

                          get value() {
                            return get($0);
                          },
                        }),
                      "component",
                      Tooltip_selector,
                      209,
                      6,
                      { componentTag: "CheckboxField" },
                    );
                  }
                },
              ),

              $$slots: { default: true },
            }),
          "component",
          Tooltip_selector,
          208,
          4,
          { componentTag: "WithPro" },
        );
      });

      var node = first_child(fragment_2);

      {
        var consequent = ($$anchor) => {
          {
            let $0 = user_derived(() =>
              strict_equals(
                typeof tooltips()[selector()][$$props.id],
                "boolean",
                false,
              ),
            );

            add_svelte_meta(
              () =>
                With_default($$anchor, {
                  get isDefault() {
                    return get($0);
                  },

                  setDefault: () =>
                    $$ownership_validator.mutation(
                      "tooltips",
                      ["tooltips", selector(), $$props.id],
                      tooltips(
                        (tooltips()[selector()][$$props.id] = null),
                        true,
                      ),
                      189,
                      25,
                    ),

                  children: wrap_snippet(
                    Tooltip_selector,
                    ($$anchor, $$slotProps) => {
                      add_svelte_meta(
                        () => body($$anchor),
                        "render",
                        Tooltip_selector,
                        191,
                        6,
                      );
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Tooltip_selector,
              187,
              4,
              { componentTag: "WithDefault" },
            );
          }
        };

        var alternate = ($$anchor) => {
          add_svelte_meta(
            () => body($$anchor),
            "render",
            Tooltip_selector,
            194,
            4,
          );
        };

        add_svelte_meta(
          () =>
            if_block(node, ($$render) => {
              if (includeDefault()) $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          Tooltip_selector,
          186,
          2,
        );
      }

      append($$anchor, fragment_2);
    },
  );

  const label = prop($$props, "label", 3, "Tooltip"),
    tooltips = prop($$props, "tooltips", 15),
    includeDefault = prop($$props, "includeDefault", 3, true);

  const options = tag(
    user_derived(() => {
      const descriptors = {};

      for (let type of getTooltipTypesForSection($$props.section)) {
        let text = tooltipTypeToText(type);

        if (strict_equals(type, "default")) {
          if (!includeDefault()) {
            continue;
          }

          const defaultType =
            adminState.mapData.__default[$$props.section].tooltips.types
              .__default ?? getDefaultTooltipTypeForSection($$props.section);

          text += ` (${tooltipTypeToText(defaultType)})`;
        }

        descriptors[type] = { text };
      }

      return descriptors;
    }),
    "options",
  );

  const isInteractive = tag(
    user_derived(
      () =>
        tooltips().interactive[$$props.id] ??
        adminState.mapData.__default[$$props.section].tooltips.interactive
          .__default ??
        false,
    ),
    "isInteractive",
  );
  const interactiveId = tag(
    user_derived(() => `tg_am_interactive_${componentId}`),
    "interactiveId",
  );
  let showLinkWarning = tag(state(false), "showLinkWarning");

  user_effect(() => {
    set(showLinkWarning, false);

    if (get(isInteractive)) {
      return;
    }

    const tooltipHtml = tooltips().customRichText[$$props.id] ?? "";
    const el = document.createElement("div");

    el.innerHTML = tooltipHtml;

    for (const elAnchor of el.querySelectorAll("a[href]")) {
      if (
        elAnchor instanceof HTMLAnchorElement &&
        !/_wp_link_placeholder/.test(elAnchor.href)
      ) {
        set(showLinkWarning, true);

        return;
      }
    }
  });

  const sectionSingular = mapDataSectionSingular($$props.section);
  var fragment_6 = root$e();
  var node_1 = first_child(fragment_6);

  add_svelte_meta(
    () =>
      key(
        node_1,
        () => get(options),
        ($$anchor) => {
          validate_binding(
            "bind:value={tooltips.types[id]}",
            () => tooltips().types,
            () => $$props.id,
            119,
            4,
          );

          {
            let $0 = user_derived(() =>
              includeDefault()
                ? "default"
                : getDefaultTooltipTypeForSection($$props.section),
            );

            $$ownership_validator.binding(
              "tooltips",
              Select_field,
              () => tooltips().types[$$props.id],
            );

            add_svelte_meta(
              () =>
                Select_field($$anchor, {
                  get label() {
                    return label();
                  },

                  get tooltip() {
                    return `Select the content of the tooltip to be displayed when a ${sectionSingular ?? ""} is hovered.`;
                  },

                  searchable: false,

                  get defaultValue() {
                    return get($0);
                  },

                  get value() {
                    return tooltips().types[$$props.id];
                  },

                  set value($$value) {
                    $$ownership_validator.mutation(
                      "tooltips",
                      ["tooltips", "types", $$props.id],
                      tooltips((tooltips().types[$$props.id] = $$value), true),
                      119,
                      16,
                    );
                  },

                  children: wrap_snippet(
                    Tooltip_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_8 = comment();
                      var node_2 = first_child(fragment_8);

                      add_svelte_meta(
                        () =>
                          each(
                            node_2,
                            17,
                            () => Object.entries(get(options)),
                            index,
                            ($$anchor, $$item, $$index, $$array) => {
                              var $$array_1 = user_derived(() =>
                                to_array(get($$item), 2),
                              );
                              let id = () => get($$array_1)[0];

                              id();

                              let text = () => get($$array_1)[1].text;

                              text();

                              var option = root_9$3();
                              var text_1 = child(option, true);

                              reset(option);

                              var option_value = {};

                              template_effect(() => {
                                set_text(text_1, text());

                                if (option_value !== (option_value = id())) {
                                  option.value = (option.__value = id()) ?? "";
                                }
                              });

                              append($$anchor, option);
                            },
                          ),
                        "each",
                        Tooltip_selector,
                        121,
                        4,
                      );

                      append($$anchor, fragment_8);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Tooltip_selector,
              112,
              2,
              { componentTag: "SelectField" },
            );
          }
        },
      ),
    "key",
    Tooltip_selector,
    111,
    0,
  );

  var node_3 = sibling(node_1, 2);

  {
    var consequent_4 = ($$anchor) => {
      var fragment_9 = root_10$2();
      var node_4 = first_child(fragment_9);

      {
        var consequent_1 = ($$anchor) => {
          add_svelte_meta(
            () =>
              With_pro($$anchor, {
                feature: { id: "rich_text" },

                children: wrap_snippet(
                  Tooltip_selector,
                  ($$anchor, $$slotProps) => {
                    {
                      let $0 = user_derived(() => [
                        isPro ? (tooltips().rich[$$props.id] ?? false) : false,
                        (newValue) =>
                          $$ownership_validator.mutation(
                            "tooltips",
                            ["tooltips", "rich", $$props.id],
                            tooltips(
                              (tooltips().rich[$$props.id] = newValue),
                              true,
                            ),
                            135,
                            25,
                          ),
                      ]);

                      add_svelte_meta(
                        () =>
                          Checkbox_field($$anchor, {
                            label: "Rich text",

                            get tooltip() {
                              return tooltipForRichText;
                            },

                            get value() {
                              return get($0);
                            },
                          }),
                        "component",
                        Tooltip_selector,
                        130,
                        6,
                        { componentTag: "CheckboxField" },
                      );
                    }
                  },
                ),

                $$slots: { default: true },
              }),
            "component",
            Tooltip_selector,
            129,
            4,
            { componentTag: "WithPro" },
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_4, ($$render) => {
              if ($$props.canRichEdit) $$render(consequent_1);
            }),
          "if",
          Tooltip_selector,
          128,
          2,
        );
      }

      var node_5 = sibling(node_4, 2);

      {
        var consequent_3 = ($$anchor) => {
          var div = root_13();
          var node_6 = child(div);

          add_svelte_meta(
            () =>
              key(
                node_6,
                () => $$props.id,
                ($$anchor) => {
                  validate_binding(
                    "bind:value={tooltips.customRichText[id]}",
                    () => tooltips().customRichText,
                    () => $$props.id,
                    144,
                    23,
                  );

                  {
                    $$ownership_validator.binding(
                      "tooltips",
                      Wp_editor_field,
                      () => tooltips().customRichText[$$props.id],
                    );

                    add_svelte_meta(
                      () =>
                        Wp_editor_field($$anchor, {
                          get value() {
                            return tooltips().customRichText[$$props.id];
                          },

                          set value($$value) {
                            $$ownership_validator.mutation(
                              "tooltips",
                              ["tooltips", "customRichText", $$props.id],
                              tooltips(
                                (tooltips().customRichText[$$props.id] =
                                  $$value),
                                true,
                              ),
                              144,
                              35,
                            );
                          },
                        }),
                      "component",
                      Tooltip_selector,
                      144,
                      8,
                      { componentTag: "WpEditorField" },
                    );
                  }
                },
              ),
            "key",
            Tooltip_selector,
            143,
            6,
          );

          var node_7 = sibling(node_6, 2);

          {
            var consequent_2 = ($$anchor) => {
              const onclick = tag(
                user_derived(() => (event, interactiveId) => {
                  event.preventDefault();

                  if (event.target instanceof HTMLElement) {
                    event.target.blur();
                  }

                  const el = document.getElementById(get(interactiveId));

                  el?.scrollIntoView({ behavior: "smooth", block: "center" });
                  document.dispatchEvent(
                    new Event(`${get(interactiveId)}_flash`),
                  );
                }),
                "onclick",
              );

              get(onclick);

              var div_1 = root_15();
              var a = sibling(child(div_1), 2);

              a.__click = [
                function (...$$args) {
                  apply(
                    () => get(onclick),
                    this,
                    $$args,
                    Tooltip_selector,
                    [162, 41],
                  );
                },

                interactiveId,
              ];

              next();
              reset(div_1);
              template_effect(() =>
                set_attribute(a, "href", `#${get(interactiveId)}`),
              );
              append($$anchor, div_1);
            };

            add_svelte_meta(
              () =>
                if_block(node_7, ($$render) => {
                  if (get(showLinkWarning)) $$render(consequent_2);
                }),
              "if",
              Tooltip_selector,
              146,
              6,
            );
          }

          reset(div);
          append($$anchor, div);
        };

        var alternate_1 = ($$anchor) => {
          validate_binding(
            "bind:value={tooltips.customText[id]}",
            () => tooltips().customText,
            () => $$props.id,
            167,
            19,
          );

          {
            $$ownership_validator.binding(
              "tooltips",
              Text_area_field,
              () => tooltips().customText[$$props.id],
            );

            add_svelte_meta(
              () =>
                Text_area_field($$anchor, {
                  get value() {
                    return tooltips().customText[$$props.id];
                  },

                  set value($$value) {
                    $$ownership_validator.mutation(
                      "tooltips",
                      ["tooltips", "customText", $$props.id],
                      tooltips(
                        (tooltips().customText[$$props.id] = $$value),
                        true,
                      ),
                      167,
                      31,
                    );
                  },
                }),
              "component",
              Tooltip_selector,
              167,
              4,
              { componentTag: "TextAreaField" },
            );
          }
        };

        add_svelte_meta(
          () =>
            if_block(node_5, ($$render) => {
              if (isPro && tooltips().rich[$$props.id]);
              else $$render(alternate_1, false);
            }),
          "if",
          Tooltip_selector,
          141,
          2,
        );
      }

      var node_8 = sibling(node_5, 2);

      add_svelte_meta(
        () => snippet(node_8, () => $$props.example ?? noop),
        "render",
        Tooltip_selector,
        170,
        2,
      );
      append($$anchor, fragment_9);
    };

    add_svelte_meta(
      () =>
        if_block(node_3, ($$render) => {
          if (strict_equals(tooltips().types[$$props.id], "custom_text"))
            $$render(consequent_4);
        }),
      "if",
      Tooltip_selector,
      127,
      0,
    );
  }

  var div_2 = sibling(node_3, 2);
  var node_9 = child(div_2);

  add_svelte_meta(
    () => checkbox(node_9, () => "interactive"),
    "render",
    Tooltip_selector,
    178,
    2,
  );
  reset(div_2);
  action(
    div_2,
    ($$node, $$action_arg) => flash?.($$node, $$action_arg),
    () => ({ eventName: `${get(interactiveId)}_flash` }),
  );

  var node_10 = sibling(div_2, 2);

  {
    var consequent_5 = ($$anchor) => {
      add_svelte_meta(
        () => checkbox($$anchor, () => "centered"),
        "render",
        Tooltip_selector,
        182,
        2,
      );
    };

    add_svelte_meta(
      () =>
        if_block(node_10, ($$render) => {
          if (strict_equals($$props.section, "regions")) $$render(consequent_5);
        }),
      "if",
      Tooltip_selector,
      181,
      0,
    );
  }

  template_effect(() => set_attribute(div_2, "id", get(interactiveId)));
  append($$anchor, fragment_6);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Pin_tooltip_selector[FILENAME] =
  "src/lib/components/region-settings-box/pin-tooltip-selector.svelte";

function Pin_tooltip_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_tooltip_selector);

  {
    const example = wrap_snippet(Pin_tooltip_selector, function ($$anchor) {
      validate_snippet_args(...arguments);

      add_svelte_meta(
        () =>
          Pin_text_examples($$anchor, {
            get pinId() {
              return $$props.pinId;
            },
          }),
        "component",
        Pin_tooltip_selector,
        34,
        4,
        { componentTag: "PinTextExamples" },
      );
    });

    add_svelte_meta(
      () =>
        Tooltip_selector($$anchor, {
          section: "pins",

          get id() {
            return $$props.pinId;
          },

          get canRichEdit() {
            return $$props.canRichEdit;
          },

          get tooltips() {
            return $$props.tooltips;
          },

          get label() {
            return $$props.label;
          },

          get includeDefault() {
            return $$props.includeDefault;
          },

          example,
          $$slots: { example: true },
        }),
      "component",
      Pin_tooltip_selector,
      25,
      0,
      { componentTag: "TooltipSelector" },
    );
  }

  return pop({ ...legacy_api() });
}

Region_text_examples[FILENAME] =
  "src/lib/components/region-text-examples.svelte";

var root_7$4 = add_locations(
  from_html(
    `<dt><code></code></dt> <dd> </dd> <dt><code></code></dt> <dd> </dd>`,
    1,
  ),
  Region_text_examples[FILENAME],
  [
    [90, 8, [[90, 12]]],
    [91, 8],
    [92, 8, [[92, 12]]],
    [93, 8],
  ],
);
var root_6$3 = add_locations(
  from_html(`<dt><code></code></dt> <dd> </dd> <!>`, 1),
  Region_text_examples[FILENAME],
  [
    [84, 6, [[84, 10]]],
    [85, 6],
  ],
);
var root_5$5 = add_locations(
  from_html(
    `<div>Replacements:</div> <dl><!> <dt><code></code></dt> <dd> </dd></dl>`,
    1,
  ),
  Region_text_examples[FILENAME],
  [
    [81, 2],
    [
      82,
      2,
      [
        [97, 4, [[97, 8]]],
        [98, 4],
      ],
    ],
  ],
);
var root$d = add_locations(
  from_html(`<div class="tg_am_map_field_example"><!></div>`),
  Region_text_examples[FILENAME],
  [[44, 0]],
);

function Region_text_examples($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_text_examples);

  const mapCodeExample = wrap_snippet(
    Region_text_examples,
    function ($$anchor, mapCode = noop) {
      validate_snippet_args(...arguments);

      var fragment = comment();
      var node = first_child(fragment);

      add_svelte_meta(
        () =>
          await_block(
            node,
            () => loadMapData(mapCode()),
            null,
            ($$anchor, mapData) => {
              var fragment_1 = comment();
              var node_1 = first_child(fragment_1);

              {
                var consequent = ($$anchor) => {
                  const geometries = tag(
                    user_derived(
                      () => get(mapData).topology.objects.regions.geometries,
                    ),
                    "geometries",
                  );

                  get(geometries);

                  const geometry = tag(
                    user_derived(
                      () =>
                        (adminState.highlightedRegionId
                          ? get(geometries).find((g) =>
                              strict_equals(
                                g.properties?.regionId,
                                adminState.highlightedRegionId,
                              ),
                            )
                          : get(geometries)[0]) ?? get(geometries)[0],
                    ),
                    "geometry",
                  );

                  get(geometry);

                  const regionName = tag(
                    user_derived(() => get(geometry)?.properties?.name),
                    "regionName",
                  );

                  get(regionName);

                  {
                    let $0 = user_derived(() => ({
                      ...get(mapData).properties[$$props.regionId],
                      regionName: strict_equals(
                        typeof get(regionName),
                        "string",
                      )
                        ? get(regionName)
                        : null,
                    }));

                    add_svelte_meta(
                      () => regionExample($$anchor, () => get($0)),
                      "render",
                      Region_text_examples,
                      66,
                      6,
                    );
                  }
                };

                var alternate = ($$anchor) => {
                  add_svelte_meta(
                    () =>
                      regionExample($$anchor, () => ({
                        regionId: $$props.regionId,
                      })),
                    "render",
                    Region_text_examples,
                    71,
                    6,
                  );
                };

                add_svelte_meta(
                  () =>
                    if_block(node_1, ($$render) => {
                      if (get(mapData)) $$render(consequent);
                      else $$render(alternate, false);
                    }),
                  "if",
                  Region_text_examples,
                  54,
                  4,
                );
              }

              append($$anchor, fragment_1);
            },
          ),
        "await",
        Region_text_examples,
        53,
        2,
      );

      append($$anchor, fragment);
    },
  );

  const regionExample = wrap_snippet(
    Region_text_examples,
    function ($$anchor, region = noop) {
      validate_snippet_args(...arguments);

      const isArea = tag(
        user_derived(() => isAreaMapCode(adminState.mapCode)),
        "isArea",
      );

      get(isArea);

      const defaultRegion = tag(
        user_derived(() => region()?.regionName ?? "Paris"),
        "defaultRegion",
      );

      get(defaultRegion);

      const defaultCountry = tag(
        user_derived(() => "France"),
        "defaultCountry",
      );

      get(defaultCountry);

      var fragment_4 = root_5$5();
      var dl = sibling(first_child(fragment_4), 2);
      var node_2 = child(dl);

      {
        var consequent_2 = ($$anchor) => {
          var fragment_5 = root_6$3();
          var dt = first_child(fragment_5);
          var code = child(dt);

          code.textContent = "{region-name}";
          reset(dt);

          var dd = sibling(dt, 2);
          var text = child(dd);

          reset(dd);

          var node_3 = sibling(dd, 2);

          {
            var consequent_1 = ($$anchor) => {
              const usState = tag(
                user_derived(() => getUsState(region()) ?? usStateNewYork),
                "usState",
              );

              get(usState);

              var fragment_6 = root_7$4();
              var dt_1 = first_child(fragment_6);
              var code_1 = child(dt_1);

              code_1.textContent = "{state-name}";
              reset(dt_1);

              var dd_1 = sibling(dt_1, 2);
              var text_1 = child(dd_1);

              reset(dd_1);

              var dt_2 = sibling(dd_1, 2);
              var code_2 = child(dt_2);

              code_2.textContent = "{state-abbreviation}";
              reset(dt_2);

              var dd_2 = sibling(dt_2, 2);
              var text_2 = child(dd_2);

              reset(dd_2);

              template_effect(() => {
                set_text(text_1, `Example: ${get(usState).name ?? ""}`);
                set_text(text_2, `Example: ${get(usState).alphaCode ?? ""}`);
              });

              append($$anchor, fragment_6);
            };

            add_svelte_meta(
              () =>
                if_block(node_3, ($$render) => {
                  if (
                    strict_equals(adminState.mapCode, "us") ||
                    isUsStateMapCode(adminState.mapCode)
                  )
                    $$render(consequent_1);
                }),
              "if",
              Region_text_examples,
              87,
              6,
            );
          }

          template_effect(() =>
            set_text(
              text,
              `Example: ${region()?.name ?? get(defaultRegion) ?? ""}`,
            ),
          );
          append($$anchor, fragment_5);
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (!get(isArea)) $$render(consequent_2);
            }),
          "if",
          Region_text_examples,
          83,
          4,
        );
      }

      var dt_3 = sibling(node_2, 2);
      var code_3 = child(dt_3);

      code_3.textContent = "{country-name}";
      reset(dt_3);

      var dd_3 = sibling(dt_3, 2);
      var text_3 = child(dd_3);

      reset(dd_3);
      reset(dl);

      template_effect(
        ($0) => set_text(text_3, `Example: ${$0 ?? ""}`),
        [
          () =>
            get(isArea)
              ? get(defaultCountry)
              : mapHasCountries(adminState.mapCode)
                ? (region()?.name ?? get(defaultCountry))
                : mapCodeToCountryName(adminState.mapCode),
        ],
      );

      append($$anchor, fragment_4);
    },
  );

  const getUsState = (region) => {
    if (strict_equals(adminState.mapCode, "us")) {
      return region?.name ? findUsStateByName(region.name) : null;
    }

    if (isUsStateMapCode(adminState.mapCode)) {
      return usStatesByMapCode[adminState.mapCode];
    }

    return null;
  };

  var div = root$d();
  var node_4 = child(div);

  {
    var consequent_3 = ($$anchor) => {
      add_svelte_meta(
        () => mapCodeExample($$anchor, () => $$props.mapCode),
        "render",
        Region_text_examples,
        46,
        4,
      );
    };

    var alternate_1 = ($$anchor) => {
      var fragment_8 = comment();
      var node_5 = first_child(fragment_8);

      {
        var consequent_4 = ($$anchor) => {
          add_svelte_meta(
            () => mapCodeExample($$anchor, () => adminState.mapCode),
            "render",
            Region_text_examples,
            48,
            4,
          );
        };

        add_svelte_meta(
          () =>
            if_block(
              node_5,
              ($$render) => {
                if (strict_equals($$props.mapCode, "__default"))
                  $$render(consequent_4);
              },
              true,
            ),
          "if",
          Region_text_examples,
          47,
          2,
        );
      }

      append($$anchor, fragment_8);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (isMapCode($$props.mapCode)) $$render(consequent_3);
          else $$render(alternate_1, false);
        }),
      "if",
      Region_text_examples,
      45,
      2,
    );
  }

  reset(div);
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

Region_tooltip_selector[FILENAME] =
  "src/lib/components/region-tooltip-selector.svelte";

function Region_tooltip_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_tooltip_selector);

  {
    const example = wrap_snippet(Region_tooltip_selector, function ($$anchor) {
      validate_snippet_args(...arguments);

      add_svelte_meta(
        () =>
          Region_text_examples($$anchor, {
            get mapCode() {
              return $$props.mapCode;
            },

            get regionId() {
              return $$props.regionId;
            },
          }),
        "component",
        Region_tooltip_selector,
        37,
        4,
        { componentTag: "RegionTextExamples" },
      );
    });

    add_svelte_meta(
      () =>
        Tooltip_selector($$anchor, {
          section: "regions",

          get id() {
            return $$props.regionId;
          },

          get canRichEdit() {
            return $$props.canRichEdit;
          },

          get tooltips() {
            return $$props.tooltips;
          },

          get label() {
            return $$props.label;
          },

          get includeDefault() {
            return $$props.includeDefault;
          },

          example,
          $$slots: { example: true },
        }),
      "component",
      Region_tooltip_selector,
      28,
      0,
      { componentTag: "TooltipSelector" },
    );
  }

  return pop({ ...legacy_api() });
}

Toggle[FILENAME] = "src/lib/components/ui/toggle.svelte";

var on_click$2 = (_, toggle) => toggle();
var on_click_1 = (__1, toggle) => toggle();
var root_1$d = add_locations(
  from_html(`<button type="button" class="button"><!></button>`),
  Toggle[FILENAME],
  [[73, 4]],
);
var root$c = add_locations(
  from_html(
    `<div class="tg_am_toggle" style="scroll-margin-top: 6px;"><div class="tg_am_toggle_header svelte-16dz44w"><!></div> <!></div> <!>`,
    1,
  ),
  Toggle[FILENAME],
  [[55, 0, [[64, 2]]]],
);

function Toggle($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Toggle);

  let element = prop($$props, "element", 15);
  const storageKey = `${$$props.id}__toggle`;
  const fromStorage = localStorageGetItem(storageKey) ?? false;
  const defaultHasOptions = true;

  let hasOptions = tag(
    state(
      proxy(
        $$props.id
          ? strict_equals(fromStorage, null)
            ? defaultHasOptions
            : strict_equals(fromStorage, "true")
          : defaultHasOptions,
      ),
    ),
    "hasOptions",
  );

  const toggle = (newValue) => {
    set(
      hasOptions,
      strict_equals(typeof newValue, "boolean") ? newValue : !get(hasOptions),
      true,
    );
    localStorageSetItem(storageKey, get(hasOptions).toString());
  };

  user_effect(() => {
    const onOpen = () => {
      toggle(true);
    };

    document.addEventListener(`tg_am_toggle_open:${$$props.id}`, onOpen);
  });

  var fragment = root$c();
  var div = first_child(fragment);
  var div_1 = child(div);

  div_1.__click = [on_click$2, toggle];

  var node = child(div_1);

  add_svelte_meta(
    () => snippet(node, () => $$props.header ?? noop),
    "render",
    Toggle,
    69,
    4,
  );
  reset(div_1);
  action(div_1, ($$node) => disableSelectOnDoubleClick?.($$node));

  var node_1 = sibling(div_1, 2);

  {
    var consequent_1 = ($$anchor) => {
      var button = root_1$d();

      button.__click = [on_click_1, toggle];

      var node_2 = child(button);

      {
        var consequent = ($$anchor) => {
          add_svelte_meta(
            () => Eye_icon($$anchor, {}),
            "component",
            Toggle,
            80,
            8,
            { componentTag: "EyeIcon" },
          );
        };

        var alternate = ($$anchor) => {
          add_svelte_meta(
            () => Eye_off_icon($$anchor, {}),
            "component",
            Toggle,
            82,
            8,
            { componentTag: "EyeOffIcon" },
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (get(hasOptions)) $$render(consequent);
              else $$render(alternate, false);
            }),
          "if",
          Toggle,
          79,
          6,
        );
      }

      reset(button);
      template_effect(() =>
        set_attribute(button, "aria-label", get(hasOptions) ? "Show" : "Hide"),
      );
      append($$anchor, button);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if ($$props.children) $$render(consequent_1);
        }),
      "if",
      Toggle,
      72,
      2,
    );
  }

  reset(div);
  bind_this(
    div,
    ($$value) => element($$value),
    () => element(),
  );
  action(
    div,
    ($$node, $$action_arg) => flash?.($$node, $$action_arg),
    () => $$props.flash,
  );

  var node_3 = sibling(div, 2);

  {
    var consequent_2 = ($$anchor) => {
      var fragment_3 = comment();
      var node_4 = first_child(fragment_3);

      add_svelte_meta(
        () => snippet(node_4, () => $$props.children),
        "render",
        Toggle,
        89,
        2,
      );
      append($$anchor, fragment_3);
    };

    add_svelte_meta(
      () =>
        if_block(node_3, ($$render) => {
          if ($$props.children && get(hasOptions)) $$render(consequent_2);
        }),
      "if",
      Toggle,
      88,
      0,
    );
  }

  template_effect(() => set_attribute(div, "id", $$props.id));
  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Feature_selector[FILENAME] =
  "src/lib/components/map-settings-box/feature-selector.svelte";

var root_4$4 = add_locations(
  from_html(
    `<option>Default region tooltip</option> <option>Default pin tooltip</option>`,
    1,
  ),
  Feature_selector[FILENAME],
  [
    [45, 6],
    [46, 6],
  ],
);
var root_3$5 = add_locations(
  from_html(
    `<!> <div class="tg_am_defaults_separator svelte-1vq7n4w"></div> <!> <!>`,
    1,
  ),
  Feature_selector[FILENAME],
  [[49, 4]],
);
var root_8$2 = add_locations(
  from_html(
    `<option>Default region actions</option> <option>Default pin actions</option>`,
    1,
  ),
  Feature_selector[FILENAME],
  [
    [78, 6],
    [79, 6],
  ],
);
var root_7$3 = add_locations(
  from_html(
    `<!> <div class="tg_am_defaults_separator svelte-1vq7n4w"></div> <!> <!>`,
    1,
  ),
  Feature_selector[FILENAME],
  [[82, 4]],
);
var root_2$5 = add_locations(
  from_html(`<!> <!> <!> <!>`, 1),
  Feature_selector[FILENAME],
  [],
);

function Feature_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Feature_selector);

  let currentTooltipSection = tag(state("regions"), "currentTooltipSection");
  let currentActionSection = tag(state("regions"), "currentActionSection");

  {
    const header = wrap_snippet(Feature_selector, function ($$anchor) {
      validate_snippet_args(...arguments);
      next();

      var text$1 = text("Features");

      append($$anchor, text$1);
    });

    add_svelte_meta(
      () =>
        Toggle($$anchor, {
          id: "tg_am_map_features",
          flash: { eventName: "tg_am_toggle_open:tg_am_map_features" },
          header,

          children: wrap_snippet(Feature_selector, ($$anchor, $$slotProps) => {
            var fragment_1 = root_2$5();
            var node = first_child(fragment_1);

            validate_binding(
              "bind:value={adminState.hasTooltips}",
              () => adminState,
              () => "hasTooltips",
              35,
              4,
            );

            add_svelte_meta(
              () =>
                Toggle_checkbox(node, {
                  label: "Tooltips",
                  id: "tg_am_toggle_tooltips",

                  get value() {
                    return adminState.hasTooltips;
                  },

                  set value($$value) {
                    adminState.hasTooltips = $$value;
                  },

                  children: wrap_snippet(
                    Feature_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_2 = root_3$5();
                      var node_1 = first_child(fragment_2);

                      {
                        let $0 = user_derived(() =>
                          strict_equals(get(currentTooltipSection), "regions")
                            ? "Default region settings. Can be overridden for each individual region under Region Settings."
                            : "Default pin settings. Can be overridden for each individual region under Region Settings.",
                        );

                        add_svelte_meta(
                          () =>
                            Select_field(node_1, {
                              searchable: false,

                              get tooltip() {
                                return get($0);
                              },

                              get value() {
                                return get(currentTooltipSection);
                              },

                              set value($$value) {
                                set(currentTooltipSection, $$value, true);
                              },

                              children: wrap_snippet(
                                Feature_selector,
                                ($$anchor, $$slotProps) => {
                                  var fragment_3 = root_4$4();
                                  var option = first_child(fragment_3);

                                  option.value = option.__value = "regions";

                                  var option_1 = sibling(option, 2);

                                  option_1.value = option_1.__value = "pins";
                                  append($$anchor, fragment_3);
                                },
                              ),

                              $$slots: { default: true },
                            }),
                          "component",
                          Feature_selector,
                          38,
                          4,
                          { componentTag: "SelectField" },
                        );
                      }

                      var node_2 = sibling(node_1, 4);

                      {
                        var consequent = ($$anchor) => {
                          add_svelte_meta(
                            () =>
                              Region_tooltip_selector($$anchor, {
                                label: "",
                                mapCode: "__default",
                                regionId: "__default",

                                get canRichEdit() {
                                  return $$props.canRichEdit;
                                },

                                get tooltips() {
                                  return adminState.mapData.__default.regions
                                    .tooltips;
                                },

                                includeDefault: false,
                              }),
                            "component",
                            Feature_selector,
                            52,
                            6,
                            { componentTag: "RegionTooltipSelector" },
                          );
                        };

                        var alternate = ($$anchor) => {
                          add_svelte_meta(
                            () =>
                              Pin_tooltip_selector($$anchor, {
                                label: "",

                                get canRichEdit() {
                                  return $$props.canRichEdit;
                                },

                                get tooltips() {
                                  return adminState.mapData.__default.pins
                                    .tooltips;
                                },

                                pinId: "__default",
                                includeDefault: false,
                              }),
                            "component",
                            Feature_selector,
                            61,
                            6,
                            { componentTag: "PinTooltipSelector" },
                          );
                        };

                        add_svelte_meta(
                          () =>
                            if_block(node_2, ($$render) => {
                              if (
                                strict_equals(
                                  get(currentTooltipSection),
                                  "regions",
                                )
                              )
                                $$render(consequent);
                              else $$render(alternate, false);
                            }),
                          "if",
                          Feature_selector,
                          51,
                          4,
                        );
                      }

                      var node_3 = sibling(node_2, 2);

                      add_svelte_meta(
                        () => Field_separator(node_3, {}),
                        "component",
                        Feature_selector,
                        69,
                        4,
                        { componentTag: "FieldSeparator" },
                      );
                      append($$anchor, fragment_2);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Feature_selector,
              33,
              2,
              { componentTag: "ToggleCheckbox" },
            );

            var node_4 = sibling(node, 2);

            validate_binding(
              "bind:value={adminState.hasActions}",
              () => adminState,
              () => "hasActions",
              74,
              4,
            );

            add_svelte_meta(
              () =>
                Toggle_checkbox(node_4, {
                  label: "Click Actions",
                  id: "tg_am_toggle_actions",

                  get value() {
                    return adminState.hasActions;
                  },

                  set value($$value) {
                    adminState.hasActions = $$value;
                  },

                  children: wrap_snippet(
                    Feature_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_6 = root_7$3();
                      var node_5 = first_child(fragment_6);

                      add_svelte_meta(
                        () =>
                          Select_field(node_5, {
                            searchable: false,

                            get value() {
                              return get(currentActionSection);
                            },

                            set value($$value) {
                              set(currentActionSection, $$value, true);
                            },

                            children: wrap_snippet(
                              Feature_selector,
                              ($$anchor, $$slotProps) => {
                                var fragment_7 = root_8$2();
                                var option_2 = first_child(fragment_7);

                                option_2.value = option_2.__value = "regions";

                                var option_3 = sibling(option_2, 2);

                                option_3.value = option_3.__value = "pins";
                                append($$anchor, fragment_7);
                              },
                            ),

                            $$slots: { default: true },
                          }),
                        "component",
                        Feature_selector,
                        77,
                        4,
                        { componentTag: "SelectField" },
                      );

                      var node_6 = sibling(node_5, 4);

                      add_svelte_meta(
                        () =>
                          Action_selector(node_6, {
                            get section() {
                              return get(currentActionSection);
                            },

                            get actions() {
                              return adminState.mapData.__default[
                                get(currentActionSection)
                              ].actions;
                            },

                            id: "__default",
                            includeDefault: false,
                          }),
                        "component",
                        Feature_selector,
                        84,
                        4,
                        { componentTag: "ActionSelector" },
                      );

                      var node_7 = sibling(node_6, 2);

                      add_svelte_meta(
                        () => Field_separator(node_7, {}),
                        "component",
                        Feature_selector,
                        90,
                        4,
                        { componentTag: "FieldSeparator" },
                      );
                      append($$anchor, fragment_6);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Feature_selector,
              72,
              2,
              { componentTag: "ToggleCheckbox" },
            );

            var node_8 = sibling(node_4, 2);

            add_svelte_meta(
              () => Region_colors_checkbox(node_8, {}),
              "component",
              Feature_selector,
              93,
              2,
              { componentTag: "RegionColorsCheckbox" },
            );

            var node_9 = sibling(node_8, 2);

            add_svelte_meta(
              () =>
                With_pro(node_9, {
                  feature: { id: "hover_effects" },

                  children: wrap_snippet(
                    Feature_selector,
                    ($$anchor, $$slotProps) => {
                      {
                        let $0 = user_derived(() => [
                          isPro ? adminState.hasHoverEffects : false,
                          (newValue) =>
                            assign(
                              adminState,
                              "hasHoverEffects",
                              newValue,
                              "src/​lib/​components/​map-settings-box/​feature-selector.svelte:101:23",
                            ),
                        ]);

                        add_svelte_meta(
                          () =>
                            Checkbox_field($$anchor, {
                              label: "Hover Effects",

                              get tooltip() {
                                return tooltipForHoverEffects;
                              },

                              get value() {
                                return get($0);
                              },
                            }),
                          "component",
                          Feature_selector,
                          96,
                          4,
                          { componentTag: "CheckboxField" },
                        );
                      }
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Feature_selector,
              95,
              2,
              { componentTag: "WithPro" },
            );

            append($$anchor, fragment_1);
          }),

          $$slots: { header: true, default: true },
        }),
      "component",
      Feature_selector,
      25,
      0,
      { componentTag: "Toggle" },
    );
  }

  return pop({ ...legacy_api() });
}

Custom_region_checkbox[FILENAME] =
  "src/lib/components/map-settings-box/custom-region-checkbox.svelte";

function Custom_region_checkbox($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Custom_region_checkbox);

  const body = wrap_snippet(Custom_region_checkbox, function ($$anchor) {
    validate_snippet_args(...arguments);

    var fragment = comment();
    var node = first_child(fragment);

    add_svelte_meta(
      () =>
        key(
          node,
          () => [$$props.mapCode, $$props.region.alphaCode],
          ($$anchor) => {
            {
              let $0 = user_derived(() => [
                get(enabledByAlphaCode)[$$props.region.alphaCode],

                (isChecked) => {
                  if (isPro || !$$props.region.isProOnly) {
                    adminState.mapData[$$props.mapCode].customRegions = {
                      ...get(enabledByAlphaCode),
                      [$$props.region.alphaCode]: isChecked,
                    };
                  }
                },
              ]);

              add_svelte_meta(
                () =>
                  Checkbox_field(
                    $$anchor,
                    spread_props(
                      {
                        get field() {
                          return $$props.field;
                        },

                        get label() {
                          return $$props.region.name;
                        },

                        get value() {
                          return get($0);
                        },
                      },
                      () => props,
                    ),
                  ),
                "component",
                Custom_region_checkbox,
                46,
                4,
                { componentTag: "CheckboxField" },
              );
            }
          },
        ),
      "key",
      Custom_region_checkbox,
      45,
      2,
    );

    append($$anchor, fragment);
  });

  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy", "mapCode", "region", "field"],
    "props",
  );

  const enabledByAlphaCode = tag(
    user_derived(() =>
      getCustomRegionsEnabledByAlphaCode($$props.mapCode, {
        enabledByAlphaCode: adminState.mapData[$$props.mapCode].customRegions,
      }),
    ),
    "enabledByAlphaCode",
  );

  var fragment_2 = comment();
  var node_1 = first_child(fragment_2);

  {
    var consequent = ($$anchor) => {
      add_svelte_meta(
        () => body($$anchor),
        "render",
        Custom_region_checkbox,
        32,
        2,
      );
    };

    var alternate = ($$anchor) => {
      {
        let $0 = user_derived(() => ({
          id: "custom_regions",
          params: `${$$props.mapCode} ${$$props.region.alphaCode}`,
        }));

        add_svelte_meta(
          () =>
            With_pro($$anchor, {
              get feature() {
                return get($0);
              },

              children: wrap_snippet(
                Custom_region_checkbox,
                ($$anchor, $$slotProps) => {
                  add_svelte_meta(
                    () => body($$anchor),
                    "render",
                    Custom_region_checkbox,
                    40,
                    4,
                  );
                },
              ),

              $$slots: { default: true },
            }),
          "component",
          Custom_region_checkbox,
          34,
          2,
          { componentTag: "WithPro" },
        );
      }
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (isPro || !$$props.region.isProOnly) $$render(consequent);
          else $$render(alternate, false);
        }),
      "if",
      Custom_region_checkbox,
      31,
      0,
    );
  }

  append($$anchor, fragment_2);

  return pop({ ...legacy_api() });
}

Custom_region_selector[FILENAME] =
  "src/lib/components/map-settings-box/custom-region-selector.svelte";

function Custom_region_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Custom_region_selector);

  const body = wrap_snippet(Custom_region_selector, function ($$anchor) {
    validate_snippet_args(...arguments);

    var fragment = comment();
    var node = first_child(fragment);

    add_svelte_meta(
      () =>
        each(
          node,
          17,
          () => allSortedCustomRegions[get(mapCode)],
          index,
          ($$anchor, region) => {
            var fragment_1 = comment();
            var node_1 = first_child(fragment_1);

            {
              var consequent = ($$anchor) => {
                var fragment_2 = comment();
                var node_2 = first_child(fragment_2);

                add_svelte_meta(
                  () =>
                    snippet(
                      node_2,
                      () => $$props.regionCheckbox,
                      () => get(region),
                    ),
                  "render",
                  Custom_region_selector,
                  38,
                  6,
                );
                append($$anchor, fragment_2);
              };

              var alternate = ($$anchor) => {
                add_svelte_meta(
                  () =>
                    Custom_region_checkbox($$anchor, {
                      get mapCode() {
                        return get(mapCode);
                      },

                      get region() {
                        return get(region);
                      },
                    }),
                  "component",
                  Custom_region_selector,
                  40,
                  6,
                  { componentTag: "CustomRegionCheckbox" },
                );
              };

              add_svelte_meta(
                () =>
                  if_block(node_1, ($$render) => {
                    if ($$props.regionCheckbox) $$render(consequent);
                    else $$render(alternate, false);
                  }),
                "if",
                Custom_region_selector,
                37,
                4,
              );
            }

            append($$anchor, fragment_1);
          },
        ),
      "each",
      Custom_region_selector,
      36,
      2,
    );

    append($$anchor, fragment);
  });

  const toggle = prop($$props, "toggle", 3, true);
  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  var fragment_4 = comment();
  var node_3 = first_child(fragment_4);

  {
    var consequent_2 = ($$anchor) => {
      var fragment_5 = comment();
      var node_4 = first_child(fragment_5);

      {
        var consequent_1 = ($$anchor) => {
          {
            const header = wrap_snippet(
              Custom_region_selector,
              function ($$anchor) {
                validate_snippet_args(...arguments);
                next();

                var text$1 = text("Include");

                append($$anchor, text$1);
              },
            );

            add_svelte_meta(
              () =>
                Toggle($$anchor, {
                  id: "tg_am_toggle_include_regions",
                  header,

                  children: wrap_snippet(
                    Custom_region_selector,
                    ($$anchor, $$slotProps) => {
                      add_svelte_meta(
                        () => body($$anchor),
                        "render",
                        Custom_region_selector,
                        28,
                        6,
                      );
                    },
                  ),

                  $$slots: { header: true, default: true },
                }),
              "component",
              Custom_region_selector,
              24,
              4,
              { componentTag: "Toggle" },
            );
          }
        };

        var alternate_1 = ($$anchor) => {
          add_svelte_meta(
            () => body($$anchor),
            "render",
            Custom_region_selector,
            31,
            4,
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_4, ($$render) => {
              if (toggle()) $$render(consequent_1);
              else $$render(alternate_1, false);
            }),
          "if",
          Custom_region_selector,
          23,
          2,
        );
      }

      append($$anchor, fragment_5);
    };

    add_svelte_meta(
      () =>
        if_block(node_3, ($$render) => {
          if (allSortedCustomRegions[get(mapCode)]) $$render(consequent_2);
        }),
      "if",
      Custom_region_selector,
      22,
      0,
    );
  }

  append($$anchor, fragment_4);

  return pop({ ...legacy_api() });
}

Map_selector[FILENAME] =
  "src/lib/components/map-settings-box/map-selector.svelte";

var root_3$4 = add_locations(
  from_html(`<option> </option>`),
  Map_selector[FILENAME],
  [[76, 12]],
);
var root_4$3 = add_locations(
  from_html(`<option> </option>`),
  Map_selector[FILENAME],
  [[81, 12]],
);
var root_2$4 = add_locations(
  from_html(
    `<optgroup label="Areas"></optgroup> <optgroup label="Countries"></optgroup>`,
    1,
  ),
  Map_selector[FILENAME],
  [
    [74, 8],
    [79, 8],
  ],
);
var root_7$2 = add_locations(
  from_html(`<option> </option>`),
  Map_selector[FILENAME],
  [[113, 14]],
);
var root_6$2 = add_locations(
  from_html(
    `<optgroup label="Country"><option>Entire country</option></optgroup> <optgroup label="States"></optgroup>`,
    1,
  ),
  Map_selector[FILENAME],
  [
    [107, 10, [[108, 12]]],
    [110, 10],
  ],
);
var root_5$4 = add_locations(
  from_html(`<div class="tg_am_map_state_select_field"><!></div>`),
  Map_selector[FILENAME],
  [[90, 6]],
);
var root_1$c = add_locations(
  from_html(`<div><div class="tg_am_map_select_field"><!></div> <!></div>`),
  Map_selector[FILENAME],
  [[44, 2, [[45, 4]]]],
);
var root_9$2 = add_locations(
  from_html(`<div class="tg_am_map_field_label">Map</div>`),
  Map_selector[FILENAME],
  [[126, 4]],
);
var root_8$1 = add_locations(
  from_html(`<!> <!>`, 1),
  Map_selector[FILENAME],
  [],
);
var root$b = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Map_selector[FILENAME],
  [],
);

function Map_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Map_selector);

  const hasSelector = prop($$props, "hasSelector", 3, true);
  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const isUs = tag(
    user_derived(
      () => strict_equals(get(mapCode), "us") || isUsStateMapCode(get(mapCode)),
    ),
    "isUs",
  );

  const selectMapCode = (newCode) => {
    adminState.mapData[newCode] ??= new MapDataState();
    adminState.mapCode = newCode;
    adminState.highlightedRegionId = null;
    adminState.highlightedPinId = null;
    adminState.regionSettingsPane = "region";
  };

  var fragment = root$b();
  var node = first_child(fragment);

  {
    var consequent_1 = ($$anchor) => {
      var div = root_1$c();
      let classes;
      var div_1 = child(div);
      var node_1 = child(div_1);

      {
        let $0 = user_derived(() =>
          proOptions({
            proFeatureForId(data) {
              return { id: "map", params: data.id };
            },
          }),
        );

        let $1 = user_derived(() => [
          ((value) => {
            if (!value) {
              return value;
            }

            if (/^us-/.test(value)) {
              return "us";
            }

            return value;
          })($$props.value ?? get(mapCode)),

          (newCode) => {
            if (isCountryMapCode(newCode) || isAreaMapCode(newCode)) {
              selectMapCode(newCode);
            }
          },
        ]);

        add_svelte_meta(
          () =>
            Select_field(node_1, {
              label: "Map",
              tooltip: "Select one of the available maps.",

              get options() {
                return get($0);
              },

              get value() {
                return get($1);
              },

              children: wrap_snippet(Map_selector, ($$anchor, $$slotProps) => {
                var fragment_1 = root_2$4();
                var optgroup = first_child(fragment_1);

                add_svelte_meta(
                  () =>
                    each(
                      optgroup,
                      21,
                      () => sortedAreaMapCodes,
                      index,
                      ($$anchor, mapCode, $$index, $$array) => {
                        var option = root_3$4();
                        var text = child(option, true);

                        reset(option);

                        var option_value = {};

                        template_effect(
                          ($0) => {
                            set_text(text, $0);

                            if (
                              option_value !== (option_value = get(mapCode))
                            ) {
                              option.value =
                                (option.__value = get(mapCode)) ?? "";
                            }
                          },
                          [() => mapCodeToName(get(mapCode))],
                        );

                        append($$anchor, option);
                      },
                    ),
                  "each",
                  Map_selector,
                  75,
                  10,
                );

                reset(optgroup);

                var optgroup_1 = sibling(optgroup, 2);

                add_svelte_meta(
                  () =>
                    each(
                      optgroup_1,
                      21,
                      () => sortedCountryMapCodes,
                      index,
                      ($$anchor, mapCode, $$index_1, $$array_1) => {
                        var option_1 = root_4$3();
                        var text_1 = child(option_1, true);

                        reset(option_1);

                        var option_1_value = {};

                        template_effect(
                          ($0) => {
                            option_1.disabled =
                              !isPro &&
                              strict_equals(get(mapCode), "us", false);
                            set_text(text_1, $0);

                            if (
                              option_1_value !== (option_1_value = get(mapCode))
                            ) {
                              option_1.value =
                                (option_1.__value = get(mapCode)) ?? "";
                            }
                          },
                          [() => mapCodeToName(get(mapCode))],
                        );

                        append($$anchor, option_1);
                      },
                    ),
                  "each",
                  Map_selector,
                  80,
                  10,
                );

                reset(optgroup_1);
                append($$anchor, fragment_1);
              }),

              $$slots: { default: true },
            }),
          "component",
          Map_selector,
          46,
          6,
          { componentTag: "SelectField" },
        );
      }

      reset(div_1);

      var node_2 = sibling(div_1, 2);

      {
        var consequent = ($$anchor) => {
          var div_2 = root_5$4();

          set_style(div_2, "", {}, { width: "100%" });

          var node_3 = child(div_2);

          {
            let $0 = user_derived(() =>
              proOptions({
                proFeatureForId(data) {
                  return { id: "map", params: data.id };
                },
              }),
            );

            let $1 = user_derived(() => $$props.value ?? get(mapCode));

            add_svelte_meta(
              () =>
                Select2(node_3, {
                  fullWidth: true,
                  tooltip: "Select one of the available United States maps.",

                  get options() {
                    return get($0);
                  },

                  get value() {
                    return get($1);
                  },

                  onchange: (event) => {
                    const newCode = event.currentTarget.value;

                    if (isMapCode(newCode)) {
                      selectMapCode(newCode);
                    }
                  },

                  children: wrap_snippet(
                    Map_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_2 = root_6$2();
                      var optgroup_2 = first_child(fragment_2);
                      var option_2 = child(optgroup_2);

                      option_2.value = option_2.__value = "us";
                      reset(optgroup_2);

                      var optgroup_3 = sibling(optgroup_2, 2);

                      add_svelte_meta(
                        () =>
                          each(
                            optgroup_3,
                            21,
                            () => sortedUsStates,
                            index,
                            ($$anchor, usState, $$index_2, $$array_2) => {
                              const mapCode = tag(
                                user_derived(() =>
                                  generateUsStateMapCode(get(usState)),
                                ),
                                "mapCode",
                              );

                              get(mapCode);

                              var option_3 = root_7$2();
                              var text_2 = child(option_3, true);

                              reset(option_3);

                              var option_3_value = {};

                              template_effect(
                                ($0) => {
                                  option_3.disabled = !isPro;
                                  set_text(text_2, $0);

                                  if (
                                    option_3_value !==
                                    (option_3_value = get(mapCode))
                                  ) {
                                    option_3.value =
                                      (option_3.__value = get(mapCode)) ?? "";
                                  }
                                },
                                [() => mapCodeToName(get(mapCode))],
                              );

                              append($$anchor, option_3);
                            },
                          ),
                        "each",
                        Map_selector,
                        111,
                        12,
                      );

                      reset(optgroup_3);
                      append($$anchor, fragment_2);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Map_selector,
              91,
              8,
              { componentTag: "Select2" },
            );
          }

          reset(div_2);
          append($$anchor, div_2);
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (get(isUs)) $$render(consequent);
            }),
          "if",
          Map_selector,
          89,
          4,
        );
      }

      reset(div);
      template_effect(
        ($0) =>
          (classes = set_class(
            div,
            1,
            "tg_am_subfields svelte-kto4r9",
            null,
            classes,
            $0,
          )),
        [() => ({ tg_am_subfields_us: get(isUs) })],
      );
      append($$anchor, div);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (hasSelector()) $$render(consequent_1);
        }),
      "if",
      Map_selector,
      43,
      0,
    );
  }

  var node_4 = sibling(node, 2);

  {
    var consequent_3 = ($$anchor) => {
      var fragment_3 = root_8$1();
      var node_5 = first_child(fragment_3);

      {
        var consequent_2 = ($$anchor) => {
          var div_3 = root_9$2();

          append($$anchor, div_3);
        };

        add_svelte_meta(
          () =>
            if_block(node_5, ($$render) => {
              if (!hasSelector()) $$render(consequent_2);
            }),
          "if",
          Map_selector,
          125,
          2,
        );
      }

      var node_6 = sibling(node_5, 2);

      add_svelte_meta(
        () =>
          With_pro(node_6, {
            feature: { id: "state_labels" },

            children: wrap_snippet(Map_selector, ($$anchor, $$slotProps) => {
              {
                let $0 = user_derived(() => [
                  isPro ? adminState.hasUsStateLabels : false,
                  (newValue) =>
                    assign(
                      adminState,
                      "hasUsStateLabels",
                      newValue,
                      "src/​lib/​components/​map-settings-box/​map-selector.svelte:134:23",
                    ),
                ]);

                add_svelte_meta(
                  () =>
                    Toggle_checkbox($$anchor, {
                      label: "Display state labels",

                      get value() {
                        return get($0);
                      },

                      id: "tg_am_toggle_state_labels",

                      children: wrap_snippet(
                        Map_selector,
                        ($$anchor, $$slotProps) => {
                          {
                            let $0 = user_derived(() => [
                              adminState.usStateLabelSizePixels?.toString() ??
                                "",

                              (newValue) => {
                                const pixels = parseInt(newValue, 10);

                                if (isNaN(pixels) || pixels < 1) {
                                  adminState.usStateLabelSizePixels = null;
                                } else {
                                  adminState.usStateLabelSizePixels = pixels;
                                }
                              },
                            ]);

                            add_svelte_meta(
                              () =>
                                Text_field($$anchor, {
                                  label: "Pixels",

                                  get value() {
                                    return get($0);
                                  },
                                }),
                              "component",
                              Map_selector,
                              138,
                              6,
                              { componentTag: "TextField" },
                            );
                          }
                        },
                      ),

                      $$slots: { default: true },
                    }),
                  "component",
                  Map_selector,
                  130,
                  4,
                  { componentTag: "ToggleCheckbox" },
                );
              }
            }),

            $$slots: { default: true },
          }),
        "component",
        Map_selector,
        129,
        2,
        { componentTag: "WithPro" },
      );

      append($$anchor, fragment_3);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (get(isUs) && strict_equals(get(mapCode), "us"))
            $$render(consequent_3);
        }),
      "if",
      Map_selector,
      124,
      0,
    );
  }

  var node_7 = sibling(node_4, 2);

  add_svelte_meta(
    () => Custom_region_selector(node_7, {}),
    "component",
    Map_selector,
    156,
    0,
    { componentTag: "CustomRegionSelector" },
  );
  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Shortcode_field[FILENAME] =
  "src/lib/components/map-settings-box/shortcode-field.svelte";

var root_1$b = add_locations(
  from_html(
    `<div class="tg_am_map_field_label">Shortcode:</div> <div class="tg_am_shortcode_block svelte-lw5fsw"><div class="svelte-lw5fsw"> </div> <a href="#" class="svelte-lw5fsw">Copy</a></div>`,
    1,
  ),
  Shortcode_field[FILENAME],
  [
    [37, 2],
    [
      45,
      2,
      [
        [46, 4],
        [48, 4],
      ],
    ],
  ],
);

function Shortcode_field($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Shortcode_field);

  let shortcodeRef;

  const selectShortcode = () => {
    const selection = getSelection();

    if (!selection || !shortcodeRef) {
      return;
    }

    const range = document.createRange();

    range.selectNode(shortcodeRef);
    selection.removeAllRanges();
    selection.addRange(range);
  };

  const selectAndCopyShortcode = (event) => {
    event.stopPropagation();
    selectShortcode();

    navigator.clipboard
      ? navigator.clipboard.writeText(shortcodeRef?.innerText)
      : document.execCommand("copy");
  };

  add_svelte_meta(
    () =>
      Field($$anchor, {
        children: wrap_snippet(Shortcode_field, ($$anchor, $$slotProps) => {
          var fragment_1 = root_1$b();
          var div = first_child(fragment_1);

          div.__click = selectShortcode;
          action(
            div,
            ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
            () =>
              "Copy and paste this shortcode anywhere, such as in a page or a post, to display the map.",
          );
          action(div, ($$node) => disableSelectOnDoubleClick?.($$node));

          var div_1 = sibling(div, 2);
          var div_2 = child(div_1);
          var text = child(div_2);

          reset(div_2);
          bind_this(
            div_2,
            ($$value) => (shortcodeRef = $$value),
            () => shortcodeRef,
          );

          var a = sibling(div_2, 2);

          a.__click = selectAndCopyShortcode;
          reset(div_1);
          template_effect(() =>
            set_text(
              text,
              `[${$$props.mapShortcode ?? ""} ${$$props.mapId ?? ""}]`,
            ),
          );
          append($$anchor, fragment_1);
        }),

        $$slots: { default: true },
      }),
    "component",
    Shortcode_field,
    34,
    0,
    { componentTag: "Field" },
  );

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Plus_icon[FILENAME] = "src/lib/components/icons/plus-icon.svelte";

var root$a = add_locations(
  from_svg(`<svg><path d="M5 12h14"></path><path d="M12 5v14"></path></svg>`),
  Plus_icon[FILENAME],
  [
    [
      10,
      0,
      [
        [20, 2],
        [21, 2],
      ],
    ],
  ],
);

function Plus_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Plus_icon);

  // See:
  // https://lucide.dev/icons/plus
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$a();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Add_button[FILENAME] = "src/lib/components/ui/add-button.svelte";

var root_1$a = add_locations(
  from_html(`<span class="tg_am_pro_tag svelte-1nq31cj"></span>`),
  Add_button[FILENAME],
  [[25, 6]],
);
var root$9 = add_locations(
  from_html(`<div class="tg_am_pro_container"><button><!> <!></button></div>`),
  Add_button[FILENAME],
  [[15, 0, [[16, 2]]]],
);

function Add_button($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Add_button);

  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy", "class", "tooltip", "proFeature"],
    "props",
  );

  var div = root$9();
  var button = child(div);

  attribute_effect(
    button,
    () => ({
      class: ["button", "button-small", "tg_am_add_button", $$props.class],
      type: "button",
      "aria-label": "Add",
      ...props,
    }),
    undefined,
    undefined,
    "svelte-1nq31cj",
  );

  var node = child(button);

  add_svelte_meta(() => Plus_icon(node, {}), "component", Add_button, 23, 4, {
    componentTag: "PlusIcon",
  });

  var node_1 = sibling(node, 2);

  {
    var consequent = ($$anchor) => {
      var span = root_1$a();

      append($$anchor, span);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if ($$props.disabled && $$props.proFeature) $$render(consequent);
        }),
      "if",
      Add_button,
      24,
      4,
    );
  }

  reset(button);
  action(
    button,
    ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
    () => $$props.tooltip,
  );
  reset(div);
  template_effect(
    ($0) => set_attribute(div, "data-tg-am-pro", $0),
    [() => proFeatureToData($$props.proFeature)],
  );
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

X_icon[FILENAME] = "src/lib/components/icons/x-icon.svelte";

var root$8 = add_locations(
  from_svg(
    `<svg><path d="M18 6 6 18"></path><path d="m6 6 12 12"></path></svg>`,
  ),
  X_icon[FILENAME],
  [
    [
      10,
      0,
      [
        [20, 2],
        [21, 2],
      ],
    ],
  ],
);

function X_icon($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, X_icon);

  // See:
  // https://lucide.dev/icons/x
  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy"],
    "props",
  );

  var svg = root$8();

  attribute_effect(svg, () => ({
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    "stroke-width": "2",
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    style: "width: 16px",
    ...props,
  }));

  append($$anchor, svg);

  return pop({ ...legacy_api() });
}

Remove_button[FILENAME] = "src/lib/components/ui/remove-button.svelte";

var root$7 = add_locations(
  from_html(`<button><!></button>`),
  Remove_button[FILENAME],
  [[11, 0]],
);

function Remove_button($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Remove_button);

  const props = rest_props(
    $$props,
    ["$$slots", "$$events", "$$legacy", "class", "tooltip"],
    "props",
  );
  var button = root$7();

  attribute_effect(
    button,
    () => ({
      class: ["button", "button-small", "tg_am_add_remove_button"],
      type: "button",
      "aria-label": "Remove",
      ...props,
    }),
    undefined,
    undefined,
    "svelte-jtecnd",
  );

  var node = child(button);

  add_svelte_meta(
    () => X_icon(node, { style: "width: 12px" }),
    "component",
    Remove_button,
    18,
    2,
    { componentTag: "XIcon" },
  );
  reset(button);
  action(
    button,
    ($$node, $$action_arg) => tooltip?.($$node, $$action_arg),
    () => $$props.tooltip,
  );
  append($$anchor, button);

  return pop({ ...legacy_api() });
}

Color_field[FILENAME] = "src/lib/components/form/color-field.svelte";

var root_1$9 = add_locations(
  from_html(`<div><input tabindex="-1"/></div>`),
  Color_field[FILENAME],
  [[124, 6, [[129, 8]]]],
);
var root$6 = add_locations(
  from_html(`<div class="tg_am_color_field"><!></div>`),
  Color_field[FILENAME],
  [[121, 0]],
);

function Color_field($$anchor, $$props) {
  const componentId = props_id();

  check_target(new.target);
  push($$props, true, Color_field);

  var $$ownership_validator = create_ownership_validator($$props);

  let value = prop($$props, "value", 15),
    props = rest_props(
      $$props,
      ["$$slots", "$$events", "$$legacy", "defaultValue", "value"],
      "props",
    );

  const id = `tg_am_color_field_${componentId}`;
  const color = tag(
    user_derived(
      () =>
        (Array.isArray(value()) ? value()[0] : value()) ?? $$props.defaultValue,
    ),
    "color",
  );
  let colorisInputRef = tag(state(void 0), "colorisInputRef");

  const colorisInputSetup = (options) => {
    if (strict_equals(typeof window, "undefined", false)) {
      import("./tg-am-vendor-CBMAXaHyD6.js")
        .then((n) => n.ao)
        .then(({ coloris }) => {
          coloris({
            el: `#${id}`,
            alpha: false,
            swatches: colorisState.staggeredSwatches,

            onChange(newColor) {
              value(newColor);
            },

            ...options,
          });
        });
    }
  };

  const colorisSetup = () => {
    if (window.innerWidth <= 500) {
      colorisInputSetup({ swatches: colorisState.swatches });
    } else {
      colorisInputSetup({ swatches: colorisState.staggeredSwatches });
    }
  };

  user_effect(() => {
    (window.queueMicrotask || setTimeout)(colorisSetup);
    addEventListener("resize", colorisSetup);

    return () => removeEventListener("resize", colorisSetup);
  });

  user_effect(() => {
    if (get(color) && get(colorisInputRef)) {
      get(colorisInputRef).value = get(color);
    }
  });

  user_effect(() => {
    const updateSelection = () => {
      (window.queueMicrotask || setTimeout)(() => {
        const buttons = document.querySelectorAll("#clr-swatches button");

        for (const button of buttons) {
          if (strict_equals(button.textContent.trim(), get(color))) {
            button.classList.add("tg_am_theme_editor_picked_color");
          } else {
            button.classList.remove("tg_am_theme_editor_picked_color");
          }
        }
      });
    };

    get(colorisInputRef)?.addEventListener("open", updateSelection);
    get(colorisInputRef)?.addEventListener("input", updateSelection);

    return () => {
      get(colorisInputRef)?.removeEventListener("open", updateSelection);
      get(colorisInputRef)?.removeEventListener("input", updateSelection);
    };
  });

  user_effect(() => {
    const onOpen = () => {
      colorisState.isOpen = true;
    };

    const onClose = () => {
      colorisState.isOpen = false;
    };

    get(colorisInputRef)?.addEventListener("open", onOpen);
    get(colorisInputRef)?.addEventListener("close", onClose);

    return () => {
      get(colorisInputRef)?.removeEventListener("open", onOpen);
      get(colorisInputRef)?.removeEventListener("close", onClose);
    };
  });

  const hasColor = () => {
    if (!get(color)) {
      return false;
    }

    if (
      window["CSS"] &&
      CSS["supports"] &&
      !CSS.supports("color", get(color))
    ) {
      return false;
    }

    const test = document.createElement("div");

    test.style.color = get(color);
    test.style.opacity = "0";
    test.style.position = "fixed";
    test.style.pointerEvents = "none";
    document.body.appendChild(test);

    const computedColor = getComputedStyle(test).color;

    document.body.removeChild(test);

    return !!computedColor.trim();
  };

  var div = root$6();

  div.__click = colorisSetup;

  var node = child(div);

  {
    const fieldBody = wrap_snippet(Color_field, function ($$anchor) {
      validate_snippet_args(...arguments);

      var div_1 = root_1$9();
      let classes;
      let styles;
      var input = child(div_1);

      bind_this(
        input,
        ($$value) => set(colorisInputRef, $$value),
        () => get(colorisInputRef),
      );
      reset(div_1);

      template_effect(
        ($0, $1) => {
          classes = set_class(div_1, 1, "tg_am_color_box", null, classes, $0);
          styles = set_style(div_1, "", styles, $1);
          set_attribute(input, "id", id);
        },
        [
          () => ({ tg_am_empty_color: !hasColor() }),
          () => ({ "--tg-am-color": get(color) }),
        ],
      );

      append($$anchor, div_1);
    });

    $$ownership_validator.binding("value", Text_field, value);

    add_svelte_meta(
      () =>
        Text_field(
          node,
          spread_props(() => props, {
            get defaultValue() {
              return $$props.defaultValue;
            },

            get value() {
              return value();
            },

            set value($$value) {
              value($$value);
            },

            fieldBody,
            $$slots: { fieldBody: true },
          }),
        ),
      "component",
      Color_field,
      122,
      2,
      { componentTag: "TextField" },
    );
  }

  reset(div);
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Theme_editor[FILENAME] =
  "src/lib/components/map-settings-box/theme-editor.svelte";

var root_3$3 = add_locations(
  from_html(
    `<div class="tg_am_theme_editor_columns"><!> <!> <!></div> <div class="tg_am_theme_editor_columns"><!> <!></div> <div class="tg_am_theme_editor_columns"><!> <!></div>`,
    1,
  ),
  Theme_editor[FILENAME],
  [
    [45, 4],
    [60, 4],
    [71, 4],
  ],
);
var root_5$3 = add_locations(
  from_html(
    `<div class="tg_am_theme_editor_columns"><!> <!> <div class="tg_am_theme_editor_pixel_input"><!></div></div> <div class="tg_am_theme_editor_columns"><!> <!> <div class="tg_am_theme_editor_pixel_input"><!></div></div>`,
    1,
  ),
  Theme_editor[FILENAME],
  [
    [88, 4, [[97, 6]]],
    [106, 4, [[115, 6]]],
  ],
);
var on_click$1 = (_, theme, px) =>
  (get(theme).definition.shadowWidth = `${px()}px`);
var root_10$1 = add_locations(
  from_html(
    `<span style="position: absolute; top: -1px; bottom: -1px; right: -1px; width: 1px; background-color: #333;"></span>`,
  ),
  Theme_editor[FILENAME],
  [[159, 16]],
);
var root_9$1 = add_locations(
  from_html(`<button class="button button-small" type="button"> <!></button>`),
  Theme_editor[FILENAME],
  [[144, 12]],
);
var root_8 = add_locations(
  from_html(
    `<div style="display: flex; height: 100%"><!> <!> <!> <!> <!></div>`,
  ),
  Theme_editor[FILENAME],
  [[138, 8]],
);
var root_7$1 = add_locations(
  from_html(`<!> <div class="tg_am_theme_editor_columns"><!> <!></div>`, 1),
  Theme_editor[FILENAME],
  [[135, 4]],
);
var root_12$1 = add_locations(
  from_html(`<div class="tg_am_theme_editor_columns"><!> <!></div>`),
  Theme_editor[FILENAME],
  [[181, 4]],
);
var root_1$8 = add_locations(
  from_html(`<!> <!> <!> <!> <!>`, 1),
  Theme_editor[FILENAME],
  [],
);

function Theme_editor($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Theme_editor);

  const theme = tag(
    user_derived(() => adminState.customThemes[$$props.customThemeId]),
    "theme",
  );

  user_effect(() => {
    if (!isCustomThemeId(get(theme)?.id)) {
      return;
    }

    const styleId = getCustomThemeStyleId(get(theme).id);
    let elStyle = document.getElementById(styleId);

    if (!elStyle) {
      elStyle = document.createElement("style");
      elStyle.id = styleId;
      document.head.appendChild(elStyle);
    }

    elStyle.textContent = customThemeToCssRule(get(theme));
  });

  var fragment = comment();
  var node = first_child(fragment);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_1 = root_1$8();
      var node_1 = first_child(fragment_1);

      validate_binding(
        "bind:value={theme.title}",
        () => get(theme),
        () => "title",
        38,
        26,
      );

      add_svelte_meta(
        () =>
          Text_field(node_1, {
            label: "Name",

            get value() {
              return get(theme).title;
            },

            set value($$value) {
              get(theme).title = $$value;
            },
          }),
        "component",
        Theme_editor,
        38,
        2,
        { componentTag: "TextField" },
      );

      var node_2 = sibling(node_1, 2);

      {
        const header = wrap_snippet(Theme_editor, function ($$anchor) {
          validate_snippet_args(...arguments);
          next();

          var text$1 = text("Regions");

          append($$anchor, text$1);
        });

        add_svelte_meta(
          () =>
            Toggle(node_2, {
              id: "tg_am_toggle_theme_region",
              header,

              children: wrap_snippet(Theme_editor, ($$anchor, $$slotProps) => {
                var fragment_2 = root_3$3();
                var div = first_child(fragment_2);
                var node_3 = child(div);

                validate_binding(
                  "bind:value={theme.definition.regionBackgroundColor}",
                  () => get(theme).definition,
                  () => "regionBackgroundColor",
                  48,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_3, {
                      label: "Background",

                      get value() {
                        return get(theme).definition.regionBackgroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionBackgroundColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  46,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_4 = sibling(node_3, 2);

                validate_binding(
                  "bind:value={theme.definition.regionForegroundColor}",
                  () => get(theme).definition,
                  () => "regionForegroundColor",
                  52,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_4, {
                      label: "Text",

                      get value() {
                        return get(theme).definition.regionForegroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionForegroundColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  50,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_5 = sibling(node_4, 2);

                validate_binding(
                  "bind:value={theme.definition.regionBorderColor}",
                  () => get(theme).definition,
                  () => "regionBorderColor",
                  56,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_5, {
                      label: "Border",

                      get value() {
                        return get(theme).definition.regionBorderColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionBorderColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  54,
                  6,
                  { componentTag: "ColorField" },
                );

                reset(div);

                var div_1 = sibling(div, 2);

                set_style(div_1, "", {}, { position: "relative" });

                var node_6 = child(div_1);

                validate_binding(
                  "bind:value={theme.definition.regionHoverBackgroundColor}",
                  () => get(theme).definition,
                  () => "regionHoverBackgroundColor",
                  63,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_6, {
                      label: "Hover Background",

                      get value() {
                        return get(theme).definition.regionHoverBackgroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionHoverBackgroundColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  61,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_7 = sibling(node_6, 2);

                validate_binding(
                  "bind:value={theme.definition.regionHoverForegroundColor}",
                  () => get(theme).definition,
                  () => "regionHoverForegroundColor",
                  67,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_7, {
                      label: "Hover Text",

                      get value() {
                        return get(theme).definition.regionHoverForegroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionHoverForegroundColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  65,
                  6,
                  { componentTag: "ColorField" },
                );

                reset(div_1);

                var div_2 = sibling(div_1, 2);
                var node_8 = child(div_2);

                validate_binding(
                  "bind:value={theme.definition.regionTooltipBackgroundColor}",
                  () => get(theme).definition,
                  () => "regionTooltipBackgroundColor",
                  74,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_8, {
                      label: "Tooltip Background",

                      get value() {
                        return get(theme).definition
                          .regionTooltipBackgroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionTooltipBackgroundColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  72,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_9 = sibling(node_8, 2);

                validate_binding(
                  "bind:value={theme.definition.regionTooltipForegroundColor}",
                  () => get(theme).definition,
                  () => "regionTooltipForegroundColor",
                  78,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_9, {
                      label: "Tooltip Text",

                      get value() {
                        return get(theme).definition
                          .regionTooltipForegroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionTooltipForegroundColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  76,
                  6,
                  { componentTag: "ColorField" },
                );

                reset(div_2);
                append($$anchor, fragment_2);
              }),

              $$slots: { header: true, default: true },
            }),
          "component",
          Theme_editor,
          40,
          2,
          { componentTag: "Toggle" },
        );
      }

      var node_10 = sibling(node_2, 2);

      {
        const header = wrap_snippet(Theme_editor, function ($$anchor) {
          validate_snippet_args(...arguments);
          next();

          var text_1 = text("Pins");

          append($$anchor, text_1);
        });

        add_svelte_meta(
          () =>
            Toggle(node_10, {
              id: "tg_am_toggle_theme_pins",
              header,

              children: wrap_snippet(Theme_editor, ($$anchor, $$slotProps) => {
                var fragment_3 = root_5$3();
                var div_3 = first_child(fragment_3);
                var node_11 = child(div_3);

                validate_binding(
                  "bind:value={theme.definition.pinOuterColor}",
                  () => get(theme).definition,
                  () => "pinOuterColor",
                  91,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_11, {
                      label: "Outer Color",

                      get value() {
                        return get(theme).definition.pinOuterColor;
                      },

                      set value($$value) {
                        get(theme).definition.pinOuterColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  89,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_12 = sibling(node_11, 2);

                validate_binding(
                  "bind:value={theme.definition.pinOuterStroke}",
                  () => get(theme).definition,
                  () => "pinOuterStroke",
                  95,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_12, {
                      label: "Outer Border",

                      get value() {
                        return get(theme).definition.pinOuterStroke;
                      },

                      set value($$value) {
                        get(theme).definition.pinOuterStroke = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  93,
                  6,
                  { componentTag: "ColorField" },
                );

                var div_4 = sibling(node_12, 2);
                var node_13 = child(div_4);

                validate_binding(
                  "bind:value={theme.definition.pinOuterStrokeWidth}",
                  () => get(theme).definition,
                  () => "pinOuterStrokeWidth",
                  101,
                  10,
                );

                add_svelte_meta(
                  () =>
                    Text_field(node_13, {
                      label: "Pixels",
                      defaultValue: "0",

                      get value() {
                        return get(theme).definition.pinOuterStrokeWidth;
                      },

                      set value($$value) {
                        get(theme).definition.pinOuterStrokeWidth = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  98,
                  8,
                  { componentTag: "TextField" },
                );

                reset(div_4);
                reset(div_3);

                var div_5 = sibling(div_3, 2);
                var node_14 = child(div_5);

                validate_binding(
                  "bind:value={theme.definition.pinInnerColor}",
                  () => get(theme).definition,
                  () => "pinInnerColor",
                  109,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_14, {
                      label: "Inner Color",

                      get value() {
                        return get(theme).definition.pinInnerColor;
                      },

                      set value($$value) {
                        get(theme).definition.pinInnerColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  107,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_15 = sibling(node_14, 2);

                validate_binding(
                  "bind:value={theme.definition.pinInnerStroke}",
                  () => get(theme).definition,
                  () => "pinInnerStroke",
                  113,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_15, {
                      label: "Inner Border",

                      get value() {
                        return get(theme).definition.pinInnerStroke;
                      },

                      set value($$value) {
                        get(theme).definition.pinInnerStroke = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  111,
                  6,
                  { componentTag: "ColorField" },
                );

                var div_6 = sibling(node_15, 2);
                var node_16 = child(div_6);

                validate_binding(
                  "bind:value={theme.definition.pinInnerStrokeWidth}",
                  () => get(theme).definition,
                  () => "pinInnerStrokeWidth",
                  119,
                  10,
                );

                add_svelte_meta(
                  () =>
                    Text_field(node_16, {
                      label: "Pixels",
                      defaultValue: "0",

                      get value() {
                        return get(theme).definition.pinInnerStrokeWidth;
                      },

                      set value($$value) {
                        get(theme).definition.pinInnerStrokeWidth = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  116,
                  8,
                  { componentTag: "TextField" },
                );

                reset(div_6);
                reset(div_5);
                append($$anchor, fragment_3);
              }),

              $$slots: { header: true, default: true },
            }),
          "component",
          Theme_editor,
          83,
          2,
          { componentTag: "Toggle" },
        );
      }

      var node_17 = sibling(node_10, 2);

      {
        const header = wrap_snippet(Theme_editor, function ($$anchor) {
          validate_snippet_args(...arguments);
          next();

          var text_2 = text("Map");

          append($$anchor, text_2);
        });

        add_svelte_meta(
          () =>
            Toggle(node_17, {
              id: "tg_am_toggle_theme_map",
              header,

              children: wrap_snippet(Theme_editor, ($$anchor, $$slotProps) => {
                var fragment_4 = root_7$1();
                var node_18 = first_child(fragment_4);

                validate_binding(
                  "bind:value={theme.definition.outlineBorderColor}",
                  () => get(theme).definition,
                  () => "outlineBorderColor",
                  132,
                  6,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_18, {
                      label: "Outline",

                      get value() {
                        return get(theme).definition.outlineBorderColor;
                      },

                      set value($$value) {
                        get(theme).definition.outlineBorderColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  130,
                  4,
                  { componentTag: "ColorField" },
                );

                var div_7 = sibling(node_18, 2);
                var node_19 = child(div_7);

                validate_binding(
                  "bind:value={theme.definition.shadowColor}",
                  () => get(theme).definition,
                  () => "shadowColor",
                  136,
                  33,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_19, {
                      label: "Shadow",

                      get value() {
                        return get(theme).definition.shadowColor;
                      },

                      set value($$value) {
                        get(theme).definition.shadowColor = $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  136,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_20 = sibling(node_19, 2);

                add_svelte_meta(
                  () =>
                    Field(node_20, {
                      label: "Pixels",

                      children: wrap_snippet(
                        Theme_editor,
                        ($$anchor, $$slotProps) => {
                          var div_8 = root_8();

                          {
                            const shadowWidthButton = wrap_snippet(
                              Theme_editor,
                              function ($$anchor, px = noop, position = noop) {
                                validate_snippet_args(...arguments);

                                const isCurrent = tag(
                                  user_derived(() =>
                                    strict_equals(
                                      asInt(get(theme).definition.shadowWidth),
                                      px(),
                                    ),
                                  ),
                                  "isCurrent",
                                );

                                get(isCurrent);

                                var button = root_9$1();

                                button.__click = [on_click$1, theme, px];

                                var text_3 = child(button);
                                var node_21 = sibling(text_3);

                                {
                                  var consequent = ($$anchor) => {
                                    var span = root_10$1();

                                    append($$anchor, span);
                                  };

                                  add_svelte_meta(
                                    () =>
                                      if_block(node_21, ($$render) => {
                                        if (
                                          get(isCurrent) &&
                                          (strict_equals(position(), "first") ||
                                            strict_equals(position(), "middle"))
                                        )
                                          $$render(consequent);
                                      }),
                                    "if",
                                    Theme_editor,
                                    158,
                                    14,
                                  );
                                }

                                reset(button);

                                template_effect(() => {
                                  set_style(
                                    button,
                                    (get(isCurrent)
                                      ? "font-weight: bold; border-color: #333; color: #333; background-color: transparent; box-shadow: 0 0 0 0.5px #333 inset; position: relative; "
                                      : "") +
                                      (strict_equals(position(), "first")
                                        ? "border-right: 0; border-top-right-radius: 0; border-bottom-right-radius: 0;"
                                        : strict_equals(position(), "middle")
                                          ? "border-radius: 0; border-right: 0;"
                                          : "border-top-left-radius: 0; border-bottom-left-radius: 0;"),
                                  );

                                  set_text(text_3, `${px() ?? ""} `);
                                });

                                append($$anchor, button);
                              },
                            );

                            var node_22 = child(div_8);

                            add_svelte_meta(
                              () =>
                                shadowWidthButton(
                                  node_22,
                                  () => 0,
                                  () => "first",
                                ),
                              "render",
                              Theme_editor,
                              166,
                              10,
                            );

                            var node_23 = sibling(node_22, 2);

                            add_svelte_meta(
                              () =>
                                shadowWidthButton(
                                  node_23,
                                  () => 1,
                                  () => "middle",
                                ),
                              "render",
                              Theme_editor,
                              167,
                              10,
                            );

                            var node_24 = sibling(node_23, 2);

                            add_svelte_meta(
                              () =>
                                shadowWidthButton(
                                  node_24,
                                  () => 2,
                                  () => "middle",
                                ),
                              "render",
                              Theme_editor,
                              168,
                              10,
                            );

                            var node_25 = sibling(node_24, 2);

                            add_svelte_meta(
                              () =>
                                shadowWidthButton(
                                  node_25,
                                  () => 3,
                                  () => "middle",
                                ),
                              "render",
                              Theme_editor,
                              169,
                              10,
                            );

                            var node_26 = sibling(node_25, 2);

                            add_svelte_meta(
                              () =>
                                shadowWidthButton(
                                  node_26,
                                  () => 4,
                                  () => "last",
                                ),
                              "render",
                              Theme_editor,
                              170,
                              10,
                            );
                            reset(div_8);
                          }

                          append($$anchor, div_8);
                        },
                      ),

                      $$slots: { default: true },
                    }),
                  "component",
                  Theme_editor,
                  137,
                  6,
                  { componentTag: "Field" },
                );

                reset(div_7);
                append($$anchor, fragment_4);
              }),

              $$slots: { header: true, default: true },
            }),
          "component",
          Theme_editor,
          125,
          2,
          { componentTag: "Toggle" },
        );
      }

      var node_27 = sibling(node_17, 2);

      {
        const header = wrap_snippet(Theme_editor, function ($$anchor) {
          validate_snippet_args(...arguments);
          next();

          var text_4 = text("Admin");

          append($$anchor, text_4);
        });

        add_svelte_meta(
          () =>
            Toggle(node_27, {
              id: "tg_am_toggle_theme_admin",
              header,

              children: wrap_snippet(Theme_editor, ($$anchor, $$slotProps) => {
                var div_9 = root_12$1();
                var node_28 = child(div_9);

                validate_binding(
                  "bind:value={theme.definition.regionHighlightBorderColor}",
                  () => get(theme).definition,
                  () => "regionHighlightBorderColor",
                  184,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_28, {
                      label: "Highlight Border",

                      get value() {
                        return get(theme).definition.regionHighlightBorderColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionHighlightBorderColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  182,
                  6,
                  { componentTag: "ColorField" },
                );

                var node_29 = sibling(node_28, 2);

                validate_binding(
                  "bind:value={theme.definition.regionHighlightForegroundColor}",
                  () => get(theme).definition,
                  () => "regionHighlightForegroundColor",
                  188,
                  8,
                );

                add_svelte_meta(
                  () =>
                    Color_field(node_29, {
                      label: "Highlight Color",

                      get value() {
                        return get(theme).definition
                          .regionHighlightForegroundColor;
                      },

                      set value($$value) {
                        get(theme).definition.regionHighlightForegroundColor =
                          $$value;
                      },
                    }),
                  "component",
                  Theme_editor,
                  186,
                  6,
                  { componentTag: "ColorField" },
                );

                reset(div_9);
                append($$anchor, div_9);
              }),

              $$slots: { header: true, default: true },
            }),
          "component",
          Theme_editor,
          176,
          2,
          { componentTag: "Toggle" },
        );
      }

      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (get(theme)) $$render(consequent_1);
        }),
      "if",
      Theme_editor,
      37,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Theme_selector_option[FILENAME] =
  "src/lib/components/map-settings-box/theme-selector-option.svelte";

const swatch = wrap_snippet(
  Theme_selector_option,
  function ($$anchor, cssVar = noop) {
    validate_snippet_args(...arguments);

    var div = root_1$7();
    let styles;

    template_effect(
      ($0) => (styles = set_style(div, "", styles, $0)),
      [() => ({ "background-color": `var(${cssVar() ?? ""})` })],
    );
    append($$anchor, div);
  },
);

var root_1$7 = add_locations(
  from_html(`<div class="svelte-mxip2p"></div>`),
  Theme_selector_option[FILENAME],
  [[26, 2]],
);
var root_4$2 = add_locations(
  from_html(`<div class="svelte-mxip2p"> </div>`),
  Theme_selector_option[FILENAME],
  [[16, 4]],
);
var root$5 = add_locations(
  from_html(
    `<div><!> <div class="tg_am_theme_option_swatches svelte-mxip2p"><!> <!> <!></div></div>`,
  ),
  Theme_selector_option[FILENAME],
  [[10, 0, [[18, 2]]]],
);

function Theme_selector_option($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Theme_selector_option);

  var div_1 = root$5();
  var node = child(div_1);

  {
    var consequent = ($$anchor) => {
      {
        let $0 = user_derived(() => ({
          id: "theme",
          params: $$props.theme.id,
        }));

        add_svelte_meta(
          () =>
            With_pro($$anchor, {
              spread: true,

              get feature() {
                return get($0);
              },

              children: wrap_snippet(
                Theme_selector_option,
                ($$anchor, $$slotProps) => {
                  next();

                  var text$1 = text();

                  template_effect(() => set_text(text$1, $$props.theme.title));
                  append($$anchor, text$1);
                },
              ),

              $$slots: { default: true },
            }),
          "component",
          Theme_selector_option,
          12,
          4,
          { componentTag: "WithPro" },
        );
      }
    };

    var alternate = ($$anchor) => {
      var div_2 = root_4$2();
      var text_1 = child(div_2, true);

      reset(div_2);
      template_effect(() => set_text(text_1, $$props.theme.title));
      append($$anchor, div_2);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if ($$props.isProTheme) $$render(consequent);
          else $$render(alternate, false);
        }),
      "if",
      Theme_selector_option,
      11,
      2,
    );
  }

  var div_3 = sibling(node, 2);
  var node_1 = child(div_3);

  add_svelte_meta(
    () => swatch(node_1, () => "--tg-am-theme-region-background-color"),
    "render",
    Theme_selector_option,
    19,
    4,
  );

  var node_2 = sibling(node_1, 2);

  add_svelte_meta(
    () => swatch(node_2, () => "--tg-am-theme-region-border-color"),
    "render",
    Theme_selector_option,
    20,
    4,
  );

  var node_3 = sibling(node_2, 2);

  add_svelte_meta(
    () => swatch(node_3, () => "--tg-am-theme-region-hover-background-color"),
    "render",
    Theme_selector_option,
    21,
    4,
  );
  reset(div_3);
  reset(div_1);

  template_effect(
    ($0) => set_class(div_1, 1, $0, "svelte-mxip2p"),
    [() => clsx(["tg_am_theme_option", getThemeClass($$props.theme.id)])],
  );

  append($$anchor, div_1);

  return pop({ ...legacy_api() });
}

Theme_selector[FILENAME] =
  "src/lib/components/map-settings-box/theme-selector.svelte";

var root_1$6 = add_locations(
  from_html(`<!> <!>`, 1),
  Theme_selector[FILENAME],
  [],
);
var root_6$1 = add_locations(
  from_html(`<option> </option>`),
  Theme_selector[FILENAME],
  [[112, 8]],
);
var root_9 = add_locations(
  from_html(`<option> </option>`),
  Theme_selector[FILENAME],
  [[125, 12]],
);
var root_7 = add_locations(
  from_html(`<optgroup label="Custom"></optgroup>`),
  Theme_selector[FILENAME],
  [[122, 6]],
);
var root_4$1 = add_locations(
  from_html(`<!>  <!>`, 1),
  Theme_selector[FILENAME],
  [],
);
var root_11 = add_locations(
  from_html(`<option> </option>`),
  Theme_selector[FILENAME],
  [[138, 6]],
);
var root_12 = add_locations(
  from_html(`<option disabled> </option>`),
  Theme_selector[FILENAME],
  [[144, 6]],
);
var root_10 = add_locations(
  from_html(`<!> <!>`, 1),
  Theme_selector[FILENAME],
  [],
);
var root$4 = add_locations(
  from_html(`<!> <!>`, 1),
  Theme_selector[FILENAME],
  [],
);

function Theme_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Theme_selector);

  const isMissingCustomThemeId = tag(
    user_derived(
      () =>
        isCustomThemeId(adminState.themeId) &&
        !adminState.customThemes[adminState.themeId],
    ),
    "isMissingCustomThemeId",
  );

  const themeId = tag(
    user_derived(() => validateThemeId(isPro, adminState.themeId)),
    "themeId",
  );

  user_effect(() => {
    if (get(isMissingCustomThemeId)) {
      adminState.themeId = defaultThemeId;
    }
  });

  const templateResult = ({ id: themeId, disabled, text }) => {
    if (!isThemeId(themeId)) {
      return text;
    }

    const theme = isCustomThemeId(themeId)
      ? adminState.customThemes[themeId]
      : themesById[themeId];

    if (!theme) {
      return text;
    }

    const element = document.createElement("div");

    element.classList.add("tg_am_theme_option", getThemeClass(theme.id));
    mount(Theme_selector_option, element, { theme, isProTheme: !!disabled });

    return element;
  };

  const addTheme = () => {
    const themeCount = Object.keys(adminState.customThemes ?? {}).length;
    const name = `Theme ${themeCount + 1}`;
    const customTheme = newCustomTheme(name);
    const id = customTheme.id;

    adminState.customThemes[id] = customTheme;
    adminState.themeId = id;
  };

  const removeTheme = () => {
    const themeId = adminState.themeId;
    const theme = adminState.customThemes[themeId];

    if (theme) {
      const message = `Are you sure you want to delete theme "${theme.title}"?`;

      if (confirm(message)) {
        removeById(adminState.customThemes, themeId);
        adminState.themeId = defaultThemeId;
      }
    }
  };

  var fragment = root$4();
  var node = first_child(fragment);

  {
    const fieldBody = wrap_snippet(Theme_selector, function ($$anchor) {
      validate_snippet_args(...arguments);

      var fragment_1 = root_1$6();
      var node_1 = first_child(fragment_1);

      {
        let $0 = user_derived(() => !isPro);

        add_svelte_meta(
          () =>
            Add_button(node_1, {
              onclick: addTheme,

              get disabled() {
                return get($0);
              },

              proFeature: { id: "theme_editor" },
              tooltip: "Create new theme.",
            }),
          "component",
          Theme_selector,
          151,
          4,
          { componentTag: "AddButton" },
        );
      }

      var node_2 = sibling(node_1, 2);

      {
        var consequent = ($$anchor) => {
          add_svelte_meta(
            () =>
              Remove_button($$anchor, {
                onclick: removeTheme,
                tooltip: "Remove theme.",
                style: "transform: translate(-60px, -50%)",
              }),
            "component",
            Theme_selector,
            159,
            6,
            { componentTag: "RemoveButton" },
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_2, ($$render) => {
              if (isPro && isCustomThemeId(adminState.themeId));
            }),
          "if",
          Theme_selector,
          158,
          4,
        );
      }

      append($$anchor, fragment_1);
    });

    let $0 = user_derived(() => [
      get(themeId),

      (newValue) => {
        if (isThemeId(newValue)) {
          adminState.themeId = newValue;
        }
      },
    ]);

    add_svelte_meta(
      () =>
        Select_field(node, {
          label: "Theme",
          tooltip:
            "Select one of the available color themes to apply to the map.",

          options: {
            templateResult,

            templateSelection({ id, text }) {
              return isCustomThemeId(id)
                ? (adminState.customThemes[id]?.title ?? text)
                : text;
            },
          },

          get value() {
            return get($0);
          },

          fieldBody,

          children: wrap_snippet(Theme_selector, ($$anchor, $$slotProps) => {
            var fragment_3 = comment();
            var node_3 = first_child(fragment_3);

            {
              var consequent_4 = ($$anchor) => {
                const customThemes = tag(
                  user_derived(() => Object.entries(adminState.customThemes)),
                  "customThemes",
                );

                get(customThemes);

                const hasCustomThemes = tag(
                  user_derived(() => isPro && get(customThemes).length > 0),
                  "hasCustomThemes",
                );

                get(hasCustomThemes);

                var fragment_4 = root_4$1();
                var node_4 = first_child(fragment_4);

                add_svelte_meta(
                  () =>
                    each(
                      node_4,
                      17,
                      () => Object.entries(themesById),
                      index,
                      ($$anchor, $$item) => {
                        var $$array = user_derived(() =>
                          to_array(get($$item), 2),
                        );
                        let id = () => get($$array)[0];

                        id();

                        let title = () => get($$array)[1].title;

                        title();

                        var fragment_5 = comment();
                        var node_5 = first_child(fragment_5);

                        {
                          var consequent_1 = ($$anchor) => {
                            var option = root_6$1();
                            var text_1 = child(option, true);

                            reset(option);

                            var option_value = {};

                            template_effect(() => {
                              set_text(text_1, title());

                              if (option_value !== (option_value = id())) {
                                option.value = (option.__value = id()) ?? "";
                              }
                            });

                            append($$anchor, option);
                          };

                          add_svelte_meta(
                            () =>
                              if_block(node_5, ($$render) => {
                                if (!adminState.hiddenThemeIds.includes(id()))
                                  $$render(consequent_1);
                              }),
                            "if",
                            Theme_selector,
                            111,
                            6,
                          );
                        }

                        append($$anchor, fragment_5);
                      },
                    ),
                  "each",
                  Theme_selector,
                  110,
                  4,
                );

                var node_6 = sibling(node_4, 2);

                {
                  var consequent_3 = ($$anchor) => {
                    var optgroup = root_7();

                    add_svelte_meta(
                      () =>
                        each(
                          optgroup,
                          21,
                          () => get(customThemes),
                          index,
                          ($$anchor, $$item) => {
                            var $$array_1 = user_derived(() =>
                              to_array(get($$item), 2),
                            );
                            let id = () => get($$array_1)[0];

                            id();

                            let theme = () => get($$array_1)[1];

                            theme();

                            var fragment_6 = comment();
                            var node_7 = first_child(fragment_6);

                            {
                              var consequent_2 = ($$anchor) => {
                                var option_1 = root_9();
                                var text_2 = child(option_1, true);

                                reset(option_1);

                                var option_1_value = {};

                                template_effect(() => {
                                  option_1.disabled = !isPro;
                                  set_text(text_2, theme().title);

                                  if (
                                    option_1_value !== (option_1_value = id())
                                  ) {
                                    option_1.value =
                                      (option_1.__value = id()) ?? "";
                                  }
                                });

                                append($$anchor, option_1);
                              };

                              add_svelte_meta(
                                () =>
                                  if_block(node_7, ($$render) => {
                                    if (
                                      theme() &&
                                      !adminState.hiddenThemeIds.includes(id())
                                    )
                                      $$render(consequent_2);
                                  }),
                                "if",
                                Theme_selector,
                                124,
                                10,
                              );
                            }

                            append($$anchor, fragment_6);
                          },
                        ),
                      "each",
                      Theme_selector,
                      123,
                      8,
                    );

                    reset(optgroup);
                    append($$anchor, optgroup);
                  };

                  add_svelte_meta(
                    () =>
                      if_block(node_6, ($$render) => {
                        if (get(hasCustomThemes)) $$render(consequent_3);
                      }),
                    "if",
                    Theme_selector,
                    121,
                    4,
                  );
                }

                append($$anchor, fragment_4);
              };

              var alternate = ($$anchor) => {
                const all = tag(
                  user_derived(() => Object.entries(themesById)),
                  "all",
                );

                get(all);

                const pro = tag(
                  user_derived(() =>
                    get(all).filter(([id]) => proThemeIds.includes(id)),
                  ),
                  "pro",
                );

                get(pro);

                const rest = tag(
                  user_derived(() =>
                    get(all).filter(([id]) => !proThemeIds.includes(id)),
                  ),
                  "rest",
                );

                get(rest);

                var fragment_7 = root_10();
                var node_8 = first_child(fragment_7);

                add_svelte_meta(
                  () =>
                    each(
                      node_8,
                      17,
                      () => get(rest),
                      index,
                      ($$anchor, $$item) => {
                        var $$array_2 = user_derived(() =>
                          to_array(get($$item), 2),
                        );
                        let id = () => get($$array_2)[0];

                        id();

                        let title = () => get($$array_2)[1].title;

                        title();

                        var option_2 = root_11();
                        var text_3 = child(option_2, true);

                        reset(option_2);

                        var option_2_value = {};

                        template_effect(() => {
                          set_text(text_3, title());

                          if (option_2_value !== (option_2_value = id())) {
                            option_2.value = (option_2.__value = id()) ?? "";
                          }
                        });

                        append($$anchor, option_2);
                      },
                    ),
                  "each",
                  Theme_selector,
                  137,
                  4,
                );

                var node_9 = sibling(node_8, 2);

                add_svelte_meta(
                  () =>
                    each(
                      node_9,
                      17,
                      () => get(pro),
                      index,
                      ($$anchor, $$item) => {
                        var $$array_3 = user_derived(() =>
                          to_array(get($$item), 2),
                        );
                        let id = () => get($$array_3)[0];

                        id();

                        let title = () => get($$array_3)[1].title;

                        title();

                        var option_3 = root_12();
                        var text_4 = child(option_3, true);

                        reset(option_3);

                        var option_3_value = {};

                        template_effect(() => {
                          set_text(text_4, title());

                          if (option_3_value !== (option_3_value = id())) {
                            option_3.value = (option_3.__value = id()) ?? "";
                          }
                        });

                        append($$anchor, option_3);
                      },
                    ),
                  "each",
                  Theme_selector,
                  143,
                  4,
                );

                append($$anchor, fragment_7);
              };

              add_svelte_meta(
                () =>
                  if_block(node_3, ($$render) => {
                    if (isPro);
                    else $$render(alternate, false);
                  }),
                "if",
                Theme_selector,
                109,
                2,
              );
            }

            append($$anchor, fragment_3);
          }),

          $$slots: { fieldBody: true, default: true },
        }),
      "component",
      Theme_selector,
      89,
      0,
      { componentTag: "SelectField" },
    );
  }

  var node_10 = sibling(node, 2);

  {
    var consequent_5 = ($$anchor) => {
      add_svelte_meta(
        () =>
          Theme_editor($$anchor, {
            get customThemeId() {
              return adminState.themeId;
            },
          }),
        "component",
        Theme_selector,
        169,
        2,
        { componentTag: "ThemeEditor" },
      );
    };

    add_svelte_meta(
      () =>
        if_block(node_10, ($$render) => {
          if (isPro && isCustomThemeId(adminState.themeId));
        }),
      "if",
      Theme_selector,
      168,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Map_settings_box[FILENAME] = "src/lib/components/map-settings-box.svelte";

var root_1$5 = add_locations(
  from_html(`<div class="tg_am_field_group"><!></div>`),
  Map_settings_box[FILENAME],
  [[24, 2]],
);
var root$3 = add_locations(
  from_html(
    `<!> <div class="tg_am_field_group tg_am_fields"><!></div> <div class="tg_am_field_group tg_am_fields"><!></div> <div class="tg_am_field_group tg_am_fields"><!></div>`,
    1,
  ),
  Map_settings_box[FILENAME],
  [
    [29, 0],
    [33, 0],
    [37, 0],
  ],
);

function Map_settings_box($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Map_settings_box);

  const hasMapSelector = prop($$props, "hasMapSelector", 3, true);
  var fragment = root$3();
  var node = first_child(fragment);

  {
    var consequent = ($$anchor) => {
      var div = root_1$5();
      var node_1 = child(div);

      add_svelte_meta(
        () =>
          Shortcode_field(node_1, {
            get mapShortcode() {
              return $$props.mapShortcode;
            },

            get mapId() {
              return $$props.mapId;
            },
          }),
        "component",
        Map_settings_box,
        25,
        4,
        { componentTag: "ShortcodeField" },
      );

      reset(div);
      append($$anchor, div);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if ($$props.mapShortcode) $$render(consequent);
        }),
      "if",
      Map_settings_box,
      23,
      0,
    );
  }

  var div_1 = sibling(node, 2);
  var node_2 = child(div_1);

  add_svelte_meta(
    () =>
      Map_selector(node_2, {
        get hasSelector() {
          return hasMapSelector();
        },
      }),
    "component",
    Map_settings_box,
    30,
    2,
    { componentTag: "MapSelector" },
  );

  reset(div_1);

  var div_2 = sibling(div_1, 2);
  var node_3 = child(div_2);

  add_svelte_meta(
    () => Theme_selector(node_3, {}),
    "component",
    Map_settings_box,
    34,
    2,
    { componentTag: "ThemeSelector" },
  );
  reset(div_2);

  var div_3 = sibling(div_2, 2);
  var node_4 = child(div_3);

  add_svelte_meta(
    () =>
      Feature_selector(node_4, {
        get canRichEdit() {
          return $$props.canRichEdit;
        },
      }),
    "component",
    Map_settings_box,
    38,
    2,
    { componentTag: "FeatureSelector" },
  );

  reset(div_3);
  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Feature_notification[FILENAME] =
  "src/lib/components/feature-notification.svelte";

var root_3$2 = add_locations(
  from_html(`<em> </em> `, 1),
  Feature_notification[FILENAME],
  [[52, 6]],
);

var on_click = () => {
  document.dispatchEvent(new Event("tg_am_toggle_open:tg_am_map_features"));
};

var root_1$4 = add_locations(
  from_html(
    `<!> <div> <!> Features can be enabled under <a href="#tg_am_map_features">Map Settings</a>.</div>`,
    1,
  ),
  Feature_notification[FILENAME],
  [[48, 2, [[56, 4]]]],
);

function Feature_notification($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Feature_notification);

  const hasTooltips = tag(
    user_derived(() => adminState.hasTooltips),
    "hasTooltips",
  );
  const hasActions = tag(
    user_derived(() => adminState.hasActions),
    "hasActions",
  );
  tag(
    user_derived(() => adminState.hasRegionColors),
    "hasRegionColors",
  );

  const hasAllFeaturesEnabled = tag(
    user_derived(() => false),
    "hasAllFeaturesEnabled",
  );

  const features = tag(
    user_derived(() => {
      const features = [];

      if (!get(hasTooltips)) {
        features.push("Tooltips");
      }

      if (!get(hasActions)) {
        features.push("Click Actions");
      }

      {
        features.push("Region Colors");
      }

      return features;
    }),
    "features",
  );

  const count = tag(
    user_derived(() => get(features).length),
    "count",
  );

  const separator = (i) => {
    return i < get(count) - 1 ? (i < get(count) - 2 ? ", " : " and ") : ".";
  };

  var fragment = comment();
  var node = first_child(fragment);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_1 = root_1$4();
      var node_1 = first_child(fragment_1);

      {
        var consequent = ($$anchor) => {
          add_svelte_meta(
            () => Field_separator($$anchor, {}),
            "component",
            Feature_notification,
            45,
            4,
            { componentTag: "FieldSeparator" },
          );
        };

        add_svelte_meta(
          () =>
            if_block(node_1, ($$render) => {
              if ($$props.separated) $$render(consequent);
            }),
          "if",
          Feature_notification,
          44,
          2,
        );
      }

      var div = sibling(node_1, 2);
      var text = child(div);
      var node_2 = sibling(text);

      add_svelte_meta(
        () =>
          each(
            node_2,
            17,
            () => get(features),
            index,
            ($$anchor, feature, i) => {
              var fragment_3 = root_3$2();
              var em = first_child(fragment_3);

              set_style(em, "", {}, { "font-weight": "bold" });

              var text_1 = child(em, true);

              reset(em);

              var text_2 = sibling(em, 1, true);

              template_effect(
                ($0) => {
                  set_text(text_1, get(feature));
                  set_text(text_2, $0);
                },
                [() => separator(i)],
              );

              append($$anchor, fragment_3);
            },
          ),
        "each",
        Feature_notification,
        51,
        4,
      );

      var a = sibling(node_2, 2);

      a.__click = [on_click];
      next();
      reset(div);
      template_effect(() =>
        set_text(
          text,
          `Extra feature${strict_equals(get(count), 1) ? "" : "s"} available: `,
        ),
      );
      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (!get(hasAllFeaturesEnabled)) $$render(consequent_1);
        }),
      "if",
      Feature_notification,
      43,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

delegate(["click"]);

Pin_detail_fields[FILENAME] =
  "src/lib/components/region-settings-box/pin-detail-fields.svelte";

var root_3$1 = add_locations(
  from_html(`<option> </option>`),
  Pin_detail_fields[FILENAME],
  [[52, 6]],
);
var root_1$3 = add_locations(
  from_html(
    `<!> <!> <div class="tg_am_subfields" style="flex-direction: row"><!> <!></div>`,
    1,
  ),
  Pin_detail_fields[FILENAME],
  [[58, 2]],
);

function Pin_detail_fields($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_detail_fields);

  const pinState = tag(
    user_derived(() => adminState.mapData[adminState.mapCode].pins),
    "pinState",
  );
  const pin = tag(
    user_derived(() => get(pinState).details[$$props.pinId]),
    "pin",
  );
  tag(
    user_derived(() => get(pinState).shapes[$$props.pinId]),
    "pinShape",
  );
  var fragment = comment();
  var node = first_child(fragment);

  {
    var consequent = ($$anchor) => {
      var fragment_1 = root_1$3();
      var node_1 = first_child(fragment_1);

      validate_binding(
        "bind:value={pin.name}",
        () => get(pin),
        () => "name",
        28,
        4,
      );

      add_svelte_meta(
        () =>
          Text_field(node_1, {
            tooltip:
              "Pin name to be used as reference and optionally part of the tooltip.",
            label: "Name",

            get value() {
              return get(pin).name;
            },

            set value($$value) {
              get(pin).name = $$value;
            },
          }),
        "component",
        Pin_detail_fields,
        25,
        2,
        { componentTag: "TextField" },
      );

      var node_2 = sibling(node_1, 2);

      {
        let $0 = user_derived(() =>
          proOptions({
            spread: false,

            proFeatureForId(data) {
              if (strict_equals(data.id, "circle", false)) {
                return { id: "pin_shape", params: data.id };
              }
            },
          }),
        );

        let $1 = user_derived(() => [
          "circle",

          (newShape) => {
            if (isPinShape(newShape)) {
              get(pinState).shapes[$$props.pinId] = newShape;
            }
          },
        ]);

        add_svelte_meta(
          () =>
            Select_field(node_2, {
              label: "Shape",
              searchable: false,

              get options() {
                return get($0);
              },

              get value() {
                return get($1);
              },

              children: wrap_snippet(
                Pin_detail_fields,
                ($$anchor, $$slotProps) => {
                  var fragment_2 = comment();
                  var node_3 = first_child(fragment_2);

                  add_svelte_meta(
                    () =>
                      each(
                        node_3,
                        17,
                        () => Object.entries(pinShapeDescriptors),
                        index,
                        ($$anchor, $$item) => {
                          var $$array = user_derived(() =>
                            to_array(get($$item), 2),
                          );
                          let id = () => get($$array)[0];

                          id();

                          let text = () => get($$array)[1].text;

                          text();

                          var option = root_3$1();
                          var text_1 = child(option, true);

                          reset(option);

                          var option_value = {};

                          template_effect(() => {
                            option.disabled =
                              !isPro && strict_equals(id(), "circle", false);
                            set_text(text_1, text());

                            if (option_value !== (option_value = id())) {
                              option.value = (option.__value = id()) ?? "";
                            }
                          });

                          append($$anchor, option);
                        },
                      ),
                    "each",
                    Pin_detail_fields,
                    51,
                    4,
                  );

                  append($$anchor, fragment_2);
                },
              ),

              $$slots: { default: true },
            }),
          "component",
          Pin_detail_fields,
          31,
          2,
          { componentTag: "SelectField" },
        );
      }

      var div = sibling(node_2, 2);
      var node_4 = child(div);

      {
        let $0 = user_derived(() => [
          get(pin)?.lat?.toString() ?? null,
          (c) => (get(pin).lat = parseLatitude(c)),
        ]);

        add_svelte_meta(
          () =>
            Text_field(node_4, {
              label: "Latitude",
              tooltip: "Latitude where the pin should be placed.",

              get value() {
                return get($0);
              },
            }),
          "component",
          Pin_detail_fields,
          59,
          4,
          { componentTag: "TextField" },
        );
      }

      var node_5 = sibling(node_4, 2);

      {
        let $0 = user_derived(() => [
          get(pin)?.lon?.toString() ?? null,
          (c) => (get(pin).lon = parseLongitude(c)),
        ]);

        add_svelte_meta(
          () =>
            Text_field(node_5, {
              label: "Longitude",
              tooltip: "Longitude where the pin should be placed.",

              get value() {
                return get($0);
              },
            }),
          "component",
          Pin_detail_fields,
          67,
          4,
          { componentTag: "TextField" },
        );
      }

      reset(div);
      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (get(pin)) $$render(consequent);
        }),
      "if",
      Pin_detail_fields,
      24,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Pin_fields[FILENAME] =
  "src/lib/components/region-settings-box/pin-fields.svelte";

var root_1$2 = add_locations(from_html(`<!> <!>`, 1), Pin_fields[FILENAME], []);
var root_2$3 = add_locations(from_html(`<!> <!>`, 1), Pin_fields[FILENAME], []);
var root$2 = add_locations(
  from_html(`<!> <!> <!> <!>`, 1),
  Pin_fields[FILENAME],
  [],
);

function Pin_fields($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_fields);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const mapData = tag(
    user_derived(() => adminState.mapData[get(mapCode)]),
    "mapData",
  );
  const tooltips = tag(
    user_derived(() => get(mapData).pins.tooltips),
    "tooltips",
  );
  var fragment = root$2();
  var node = first_child(fragment);

  add_svelte_meta(
    () =>
      Pin_detail_fields(node, {
        get pinId() {
          return $$props.pinId;
        },
      }),
    "component",
    Pin_fields,
    18,
    0,
    { componentTag: "PinDetailFields" },
  );

  var node_1 = sibling(node, 2);

  {
    var consequent = ($$anchor) => {
      var fragment_1 = root_1$2();
      var node_2 = first_child(fragment_1);

      add_svelte_meta(
        () => Field_separator(node_2, {}),
        "component",
        Pin_fields,
        21,
        2,
        { componentTag: "FieldSeparator" },
      );

      var node_3 = sibling(node_2, 2);

      add_svelte_meta(
        () =>
          Pin_tooltip_selector(node_3, {
            get pinId() {
              return $$props.pinId;
            },

            get canRichEdit() {
              return $$props.canRichEdit;
            },

            get tooltips() {
              return get(tooltips);
            },
          }),
        "component",
        Pin_fields,
        22,
        2,
        { componentTag: "PinTooltipSelector" },
      );

      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node_1, ($$render) => {
          if (adminState.hasTooltips) $$render(consequent);
        }),
      "if",
      Pin_fields,
      20,
      0,
    );
  }

  var node_4 = sibling(node_1, 2);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_2 = root_2$3();
      var node_5 = first_child(fragment_2);

      add_svelte_meta(
        () => Field_separator(node_5, {}),
        "component",
        Pin_fields,
        26,
        2,
        { componentTag: "FieldSeparator" },
      );

      var node_6 = sibling(node_5, 2);

      add_svelte_meta(
        () =>
          Action_selector(node_6, {
            section: "pins",

            get actions() {
              return adminState.mapData[get(mapCode)].pins.actions;
            },

            get id() {
              return $$props.pinId;
            },
          }),
        "component",
        Pin_fields,
        27,
        2,
        { componentTag: "ActionSelector" },
      );

      append($$anchor, fragment_2);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (adminState.hasActions) $$render(consequent_1);
        }),
      "if",
      Pin_fields,
      25,
      0,
    );
  }

  var node_7 = sibling(node_4, 2);

  add_svelte_meta(
    () => Feature_notification(node_7, { separated: true }),
    "component",
    Pin_fields,
    34,
    0,
    { componentTag: "FeatureNotification" },
  );
  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Pin_selector[FILENAME] =
  "src/lib/components/region-settings-box/pin-selector.svelte";

var root_2$2 = add_locations(
  from_html(`<option> </option>`),
  Pin_selector[FILENAME],
  [[64, 8]],
);
var root$1 = add_locations(
  from_html(
    `<div class="tg_am_pin_selector"><div class="tg_am_pin_field"><!> <!></div> <!></div>`,
  ),
  Pin_selector[FILENAME],
  [[45, 0, [[46, 2]]]],
);

function Pin_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Pin_selector);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const mapData = tag(
    user_derived(() => adminState.mapData[get(mapCode)]),
    "mapData",
  );
  const pins = tag(
    user_derived(() => get(mapData).pins.details),
    "pins",
  );
  const pinCount = tag(
    user_derived(() => Object.keys(get(pins)).length),
    "pinCount",
  );
  const filteredPins = tag(
    user_derived(() => Object.values(get(pins)).filter((pin) => !!pin)),
    "filteredPins",
  );

  const addPin = () => {
    const pin = newPin(`Pin ${get(pinCount) + 1}`, get(mapCode));

    get(pins)[pin.id] = pin;
    adminState.highlightedPinId = pin.id;
  };

  const removePin = () => {
    const pinId = adminState.highlightedPinId;
    const pin = pinId ? get(pins)[pinId] : null;

    if (pin) {
      const message = `Are you sure you want to delete pin "${pin.name}"?`;

      if (confirm(message)) {
        adminState.mapData[get(mapCode)].pins.removeById(pin.id);
        adminState.highlightedPinId = null;
      }
    }
  };

  const getPinText = ({ id, text }) => {
    return (id ? get(pins)[id]?.name : null) ?? text;
  };

  const maxEssentialPinCount = 5;
  const isAddDisabled = tag(
    user_derived(() => get(pinCount) >= maxEssentialPinCount),
    "isAddDisabled",
  );
  var div = root$1();
  var div_1 = child(div);
  var node = child(div_1);

  validate_binding(
    "bind:value={adminState.highlightedPinId}",
    () => adminState,
    () => "highlightedPinId",
    61,
    6,
  );

  {
    let $0 = user_derived(
      () =>
        "Select a pin to customize." +
        (get(filteredPins).length > 1
          ? ` Access to all pins is enabled in ${proTitle}.`
          : ""),
    );

    add_svelte_meta(
      () =>
        Select_field(node, {
          placeholder: "Select a pin",

          get tooltip() {
            return get($0);
          },

          get searchable() {
            return isPro;
          },

          options: {
            language: { noResults: () => "No pins found." },
            templateSelection: getPinText,
            templateResult: getPinText,
          },

          get value() {
            return adminState.highlightedPinId;
          },

          set value($$value) {
            adminState.highlightedPinId = $$value;
          },

          children: wrap_snippet(Pin_selector, ($$anchor, $$slotProps) => {
            var fragment = comment();
            var node_1 = first_child(fragment);

            add_svelte_meta(
              () =>
                each(
                  node_1,
                  17,
                  () => get(filteredPins),
                  index,
                  ($$anchor, pin, i) => {
                    var option = root_2$2();
                    var text_1 = child(option, true);

                    reset(option);

                    var option_value = {};

                    template_effect(() => {
                      option.disabled = !isPro && i >= 1;
                      set_text(text_1, get(pin).name);

                      if (option_value !== (option_value = get(pin).id)) {
                        option.value = (option.__value = get(pin).id) ?? "";
                      }
                    });

                    append($$anchor, option);
                  },
                ),
              "each",
              Pin_selector,
              63,
              6,
            );

            append($$anchor, fragment);
          }),

          $$slots: { default: true },
        }),
      "component",
      Pin_selector,
      47,
      4,
      { componentTag: "SelectField" },
    );
  }

  var node_2 = sibling(node, 2);

  {
    var consequent = ($$anchor) => {
      add_svelte_meta(
        () =>
          Remove_button($$anchor, {
            onclick: removePin,
            tooltip: "Remove pin.",
            style: "transform: translate(-21px, -50%)",
          }),
        "component",
        Pin_selector,
        69,
        6,
        { componentTag: "RemoveButton" },
      );
    };

    add_svelte_meta(
      () =>
        if_block(node_2, ($$render) => {
          if (adminState.highlightedPinId) $$render(consequent);
        }),
      "if",
      Pin_selector,
      68,
      4,
    );
  }

  reset(div_1);

  var node_3 = sibling(div_1, 2);

  add_svelte_meta(
    () =>
      Add_button(node_3, {
        onclick: addPin,

        get disabled() {
          return get(isAddDisabled);
        },

        proFeature: { id: "max_pins", params: maxEssentialPinCount },
        tooltip: "Add new pin.",
      }),
    "component",
    Pin_selector,
    77,
    2,
    { componentTag: "AddButton" },
  );

  reset(div);
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

Region_color_selector[FILENAME] =
  "src/lib/components/region-settings-box/region-color-selector.svelte";

const backgroundField = wrap_snippet(
  Region_color_selector,
  function ($$anchor, colors = noop) {
    validate_snippet_args(...arguments);
    validate_binding(
      "bind:value={colors.background}",
      colors,
      () => "background",
      39,
      33,
    );

    add_svelte_meta(
      () =>
        Color_field($$anchor, {
          label: "Background",

          get value() {
            return colors().background;
          },

          set value($$value) {
            colors().background = $$value;
          },
        }),
      "component",
      Region_color_selector,
      39,
      2,
      { componentTag: "ColorField" },
    );
  },
);

const foregroundField = wrap_snippet(
  Region_color_selector,
  function ($$anchor, colors = noop) {
    validate_snippet_args(...arguments);
    validate_binding(
      "bind:value={colors.foreground}",
      colors,
      () => "foreground",
      43,
      27,
    );

    add_svelte_meta(
      () =>
        Color_field($$anchor, {
          label: "Text",

          get value() {
            return colors().foreground;
          },

          set value($$value) {
            colors().foreground = $$value;
          },
        }),
      "component",
      Region_color_selector,
      43,
      2,
      { componentTag: "ColorField" },
    );
  },
);

const hoverBackgroundField = wrap_snippet(
  Region_color_selector,
  function ($$anchor, colors = noop) {
    validate_snippet_args(...arguments);
    validate_binding(
      "bind:value={colors.hoverBackground}",
      colors,
      () => "hoverBackground",
      47,
      39,
    );

    add_svelte_meta(
      () =>
        Color_field($$anchor, {
          label: "Hover Background",

          get value() {
            return colors().hoverBackground;
          },

          set value($$value) {
            colors().hoverBackground = $$value;
          },
        }),
      "component",
      Region_color_selector,
      47,
      2,
      { componentTag: "ColorField" },
    );
  },
);

const hoverForegroundField = wrap_snippet(
  Region_color_selector,
  function ($$anchor, colors = noop) {
    validate_snippet_args(...arguments);
    validate_binding(
      "bind:value={colors.hoverForeground}",
      colors,
      () => "hoverForeground",
      51,
      33,
    );

    add_svelte_meta(
      () =>
        Color_field($$anchor, {
          label: "Hover Text",

          get value() {
            return colors().hoverForeground;
          },

          set value($$value) {
            colors().hoverForeground = $$value;
          },
        }),
      "component",
      Region_color_selector,
      51,
      2,
      { componentTag: "ColorField" },
    );
  },
);

var root_6 = add_locations(
  from_html(`<div class="tg_am_theme_editor_columns"><!> <!></div>`),
  Region_color_selector[FILENAME],
  [[31, 4]],
);
var root_5$2 = add_locations(
  from_html(`<div class="tg_am_theme_editor_columns"><!> <!></div> <!>`, 1),
  Region_color_selector[FILENAME],
  [[25, 2]],
);

function Region_color_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_color_selector);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const regionId = tag(
    user_derived(() => adminState.highlightedRegionId),
    "regionId",
  );

  user_effect(() => {
    if (!get(regionId)) {
      return;
    }

    if (!adminState.mapData[get(mapCode)].regions.colors[get(regionId)]) {
      adminState.mapData[get(mapCode)].regions.colors[get(regionId)] = {};
    }
  });

  const colors = tag(
    user_derived(() =>
      get(regionId)
        ? adminState.mapData[get(mapCode)].regions.colors[get(regionId)]
        : null,
    ),
    "colors",
  );

  var fragment_4 = comment();
  var node = first_child(fragment_4);

  {
    var consequent_1 = ($$anchor) => {
      var fragment_5 = root_5$2();
      var div = first_child(fragment_5);
      var node_1 = child(div);

      add_svelte_meta(
        () => backgroundField(node_1, () => get(colors)),
        "render",
        Region_color_selector,
        26,
        4,
      );

      var node_2 = sibling(node_1, 2);

      add_svelte_meta(
        () => foregroundField(node_2, () => get(colors)),
        "render",
        Region_color_selector,
        27,
        4,
      );
      reset(div);

      var node_3 = sibling(div, 2);

      {
        var consequent = ($$anchor) => {
          var div_1 = root_6();
          var node_4 = child(div_1);

          add_svelte_meta(
            () => hoverBackgroundField(node_4, () => get(colors)),
            "render",
            Region_color_selector,
            32,
            6,
          );

          var node_5 = sibling(node_4, 2);

          add_svelte_meta(
            () => hoverForegroundField(node_5, () => get(colors)),
            "render",
            Region_color_selector,
            33,
            6,
          );
          reset(div_1);
          append($$anchor, div_1);
        };

        add_svelte_meta(
          () =>
            if_block(node_3, ($$render) => {
              if (adminState.hasHoverEffects) $$render(consequent);
            }),
          "if",
          Region_color_selector,
          30,
          2,
        );
      }

      append($$anchor, fragment_5);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (get(colors)) $$render(consequent_1);
        }),
      "if",
      Region_color_selector,
      24,
      0,
    );
  }

  append($$anchor, fragment_4);

  return pop({ ...legacy_api() });
}

Region_fields[FILENAME] =
  "src/lib/components/region-settings-box/region-fields.svelte";

var root_3 = add_locations(
  from_html(`<!> <!>`, 1),
  Region_fields[FILENAME],
  [],
);
var root_4 = add_locations(
  from_html(`<!> <!>`, 1),
  Region_fields[FILENAME],
  [],
);
var root_5$1 = add_locations(
  from_html(`<!> <!>`, 1),
  Region_fields[FILENAME],
  [],
);
var root_2$1 = add_locations(
  from_html(`<!> <!> <!>`, 1),
  Region_fields[FILENAME],
  [],
);
var root_1$1 = add_locations(
  from_html(`<!> <!>`, 1),
  Region_fields[FILENAME],
  [],
);

function Region_fields($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_fields);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const mapData = tag(
    user_derived(() => adminState.mapData[adminState.mapCode]),
    "mapData",
  );
  const tooltips = tag(
    user_derived(() => get(mapData).regions.tooltips),
    "tooltips",
  );
  const hasSettings = tag(
    user_derived(
      () =>
        adminState.hasTooltips ||
        adminState.hasActions ||
        adminState.hasRegionColors,
    ),
    "hasSettings",
  );
  var fragment = comment();
  var node = first_child(fragment);

  {
    var consequent_4 = ($$anchor) => {
      var fragment_1 = root_1$1();
      var node_1 = first_child(fragment_1);

      {
        var consequent_3 = ($$anchor) => {
          var fragment_2 = root_2$1();
          var node_2 = first_child(fragment_2);

          {
            var consequent = ($$anchor) => {
              var fragment_3 = root_3();
              var node_3 = first_child(fragment_3);

              add_svelte_meta(
                () => Field_separator(node_3, {}),
                "component",
                Region_fields,
                28,
                6,
                { componentTag: "FieldSeparator" },
              );

              var node_4 = sibling(node_3, 2);

              add_svelte_meta(
                () =>
                  Region_tooltip_selector(node_4, {
                    get mapCode() {
                      return get(mapCode);
                    },

                    get regionId() {
                      return $$props.regionId;
                    },

                    get canRichEdit() {
                      return $$props.canRichEdit;
                    },

                    get tooltips() {
                      return get(tooltips);
                    },
                  }),
                "component",
                Region_fields,
                29,
                6,
                { componentTag: "RegionTooltipSelector" },
              );

              append($$anchor, fragment_3);
            };

            add_svelte_meta(
              () =>
                if_block(node_2, ($$render) => {
                  if (adminState.hasTooltips) $$render(consequent);
                }),
              "if",
              Region_fields,
              27,
              4,
            );
          }

          var node_5 = sibling(node_2, 2);

          {
            var consequent_1 = ($$anchor) => {
              var fragment_4 = root_4();
              var node_6 = first_child(fragment_4);

              add_svelte_meta(
                () => Field_separator(node_6, {}),
                "component",
                Region_fields,
                33,
                6,
                { componentTag: "FieldSeparator" },
              );

              var node_7 = sibling(node_6, 2);

              add_svelte_meta(
                () => Region_color_selector(node_7, {}),
                "component",
                Region_fields,
                34,
                6,
                { componentTag: "RegionColorSelector" },
              );
              append($$anchor, fragment_4);
            };

            add_svelte_meta(
              () =>
                if_block(node_5, ($$render) => {
                  if (isPro && adminState.hasRegionColors);
                }),
              "if",
              Region_fields,
              32,
              4,
            );
          }

          var node_8 = sibling(node_5, 2);

          {
            var consequent_2 = ($$anchor) => {
              var fragment_5 = root_5$1();
              var node_9 = first_child(fragment_5);

              add_svelte_meta(
                () => Field_separator(node_9, {}),
                "component",
                Region_fields,
                38,
                6,
                { componentTag: "FieldSeparator" },
              );

              var node_10 = sibling(node_9, 2);

              add_svelte_meta(
                () =>
                  Action_selector(node_10, {
                    section: "regions",

                    get actions() {
                      return adminState.mapData[get(mapCode)].regions.actions;
                    },

                    get id() {
                      return $$props.regionId;
                    },
                  }),
                "component",
                Region_fields,
                39,
                6,
                { componentTag: "ActionSelector" },
              );

              append($$anchor, fragment_5);
            };

            add_svelte_meta(
              () =>
                if_block(node_8, ($$render) => {
                  if (adminState.hasActions) $$render(consequent_2);
                }),
              "if",
              Region_fields,
              37,
              4,
            );
          }

          append($$anchor, fragment_2);
        };

        add_svelte_meta(
          () =>
            if_block(node_1, ($$render) => {
              if (get(hasSettings)) $$render(consequent_3);
            }),
          "if",
          Region_fields,
          26,
          2,
        );
      }

      var node_11 = sibling(node_1, 2);

      add_svelte_meta(
        () =>
          Feature_notification(node_11, {
            get separated() {
              return get(hasSettings);
            },
          }),
        "component",
        Region_fields,
        47,
        2,
        { componentTag: "FeatureNotification" },
      );

      append($$anchor, fragment_1);
    };

    add_svelte_meta(
      () =>
        if_block(node, ($$render) => {
          if (get(mapCode)) $$render(consequent_4);
        }),
      "if",
      Region_fields,
      25,
      0,
    );
  }

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Region_selector[FILENAME] =
  "src/lib/components/region-settings-box/region-selector.svelte";

var root_5 = add_locations(
  from_html(`<option> </option>`),
  Region_selector[FILENAME],
  [[94, 10]],
);

function Region_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_selector);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const regionType = tag(
    user_derived(() => getRegionType(get(mapCode))),
    "regionType",
  );
  const defaultInteractive = false;
  const defaultCentered = false;

  const templateResult = ({ id, text }) => {
    if (!id) {
      return text;
    }

    const mapData = adminState.mapData[get(mapCode)];

    if (!mapData) {
      return text;
    }

    const tooltipType =
      mapData.regions.tooltips.types[id] ?? defaultRegionTooltipType;
    const isCentered = mapData.regions.tooltips.centered[id] ?? defaultCentered;
    const isInteractive =
      mapData.regions.tooltips.interactive[id] ?? defaultInteractive;
    const actionType = mapData.regions.actions.types[id] ?? defaultActionType;
    const isModified =
      strict_equals(tooltipType, defaultRegionTooltipType, false) ||
      strict_equals(isCentered, defaultCentered, false) ||
      strict_equals(isInteractive, defaultInteractive, false) ||
      strict_equals(actionType, defaultActionType, false);

    return isModified ? `<div class="tg_am_modified">${text}*</div>` : text;
  };

  const entriesPromise = tag(
    user_derived(async () => {
      const enabledByAlphaCode = adminState.mapData[get(mapCode)].customRegions;
      const mapData =
        $$props.mapData ??
        (await track_reactivity_loss(loadMapData(adminState.mapCode)))();

      if (!mapData) {
        return [];
      }

      let allProperties = mapData.properties;

      if (allSortedCustomRegions[get(mapCode)]) {
        allProperties = {};

        const disabledRegionIds = getDisabledCustomRegionIds(get(mapCode), {
          enabledByAlphaCode,
        });

        for (const properties of Object.values(mapData.properties)) {
          const regionId = properties.regionId;

          if (!disabledRegionIds.has(regionId)) {
            allProperties[regionId] = properties;
          }
        }
      }

      return Object.values(allProperties).sort(({ name: a }, { name: b }) =>
        a.localeCompare(b),
      );
    }),
    "entriesPromise",
  );

  var fragment = comment();
  var node = first_child(fragment);

  add_svelte_meta(
    () =>
      key(
        node,
        () => get(regionType),
        ($$anchor) => {
          validate_binding(
            "bind:value={adminState.highlightedRegionId}",
            () => adminState,
            () => "highlightedRegionId",
            89,
            4,
          );

          {
            let $0 = user_derived(() => `Select a ${get(regionType)}`);
            let $1 = user_derived(
              () =>
                `Select a ${get(regionType)} from the current map to apply customizations to.`,
            );

            add_svelte_meta(
              () =>
                Select_field($$anchor, {
                  get placeholder() {
                    return get($0);
                  },

                  get tooltip() {
                    return get($1);
                  },

                  options: { templateResult, escapeMarkup: (markup) => markup },

                  get value() {
                    return adminState.highlightedRegionId;
                  },

                  set value($$value) {
                    adminState.highlightedRegionId = $$value;
                  },

                  children: wrap_snippet(
                    Region_selector,
                    ($$anchor, $$slotProps) => {
                      var fragment_2 = comment();
                      var node_1 = first_child(fragment_2);

                      add_svelte_meta(
                        () =>
                          await_block(
                            node_1,
                            () => get(entriesPromise),
                            null,
                            ($$anchor, entries) => {
                              var fragment_3 = comment();
                              var node_2 = first_child(fragment_3);

                              add_svelte_meta(
                                () =>
                                  each(
                                    node_2,
                                    17,
                                    () => get(entries),
                                    index,
                                    ($$anchor, $$item) => {
                                      let regionId = () => get($$item).regionId;

                                      regionId();

                                      let name = () => get($$item).name;

                                      name();

                                      var fragment_4 = comment();
                                      var node_3 = first_child(fragment_4);

                                      {
                                        var consequent = ($$anchor) => {
                                          var option = root_5();
                                          var text_1 = child(option, true);

                                          reset(option);

                                          var option_value = {};

                                          template_effect(() => {
                                            set_text(text_1, name());

                                            if (
                                              option_value !==
                                              (option_value = regionId())
                                            ) {
                                              option.value =
                                                (option.__value = regionId()) ??
                                                "";
                                            }
                                          });

                                          append($$anchor, option);
                                        };

                                        add_svelte_meta(
                                          () =>
                                            if_block(node_3, ($$render) => {
                                              if (name()) $$render(consequent);
                                            }),
                                          "if",
                                          Region_selector,
                                          93,
                                          8,
                                        );
                                      }

                                      append($$anchor, fragment_4);
                                    },
                                  ),
                                "each",
                                Region_selector,
                                92,
                                6,
                              );

                              append($$anchor, fragment_3);
                            },
                          ),
                        "await",
                        Region_selector,
                        91,
                        4,
                      );

                      append($$anchor, fragment_2);
                    },
                  ),

                  $$slots: { default: true },
                }),
              "component",
              Region_selector,
              85,
              2,
              { componentTag: "SelectField" },
            );
          }
        },
      ),
    "key",
    Region_selector,
    84,
    0,
  );

  append($$anchor, fragment);

  return pop({ ...legacy_api() });
}

Settings_pane_selector[FILENAME] =
  "src/lib/components/region-settings-box/settings-pane-selector.svelte";

var root_2 = add_locations(
  from_html(`<option> </option>`),
  Settings_pane_selector[FILENAME],
  [[22, 4]],
);
var root_1 = add_locations(
  from_html(`<!> <option>Pins</option>`, 1),
  Settings_pane_selector[FILENAME],
  [[24, 2]],
);

function Settings_pane_selector($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Settings_pane_selector);

  const regionType = tag(
    user_derived(() => getRegionType(adminState.mapCode)),
    "regionType",
  );

  const clearHighlights = () => {
    adminState.highlightedPinId = null;
    adminState.highlightedRegionId = null;
  };

  validate_binding(
    "bind:value={adminState.regionSettingsPane}",
    () => adminState,
    () => "regionSettingsPane",
    18,
    2,
  );

  add_svelte_meta(
    () =>
      Select_field($$anchor, {
        searchable: false,
        tooltip: "Choose the settings you'd like to customize.",
        onchange: clearHighlights,

        get value() {
          return adminState.regionSettingsPane;
        },

        set value($$value) {
          adminState.regionSettingsPane = $$value;
        },

        children: wrap_snippet(
          Settings_pane_selector,
          ($$anchor, $$slotProps) => {
            var fragment_1 = root_1();
            var node = first_child(fragment_1);

            add_svelte_meta(
              () =>
                key(
                  node,
                  () => adminState.mapCode,
                  ($$anchor) => {
                    var option = root_2();
                    var text = child(option, true);

                    reset(option);
                    option.value = option.__value = "region";
                    template_effect(
                      ($0) => set_text(text, $0),
                      [() => ucfirst(get(regionType))],
                    );
                    append($$anchor, option);
                  },
                ),
              "key",
              Settings_pane_selector,
              21,
              2,
            );

            var option_1 = sibling(node, 2);

            option_1.value = option_1.__value = "pins";
            append($$anchor, fragment_1);
          },
        ),

        $$slots: { default: true },
      }),
    "component",
    Settings_pane_selector,
    15,
    0,
    { componentTag: "SelectField" },
  );

  return pop({ ...legacy_api() });
}

Region_settings_box[FILENAME] = "src/lib/components/region-settings-box.svelte";

var root = add_locations(
  from_html(
    `<div><div class="tg_am_field_selectors svelte-feb6a4"><div><!></div> <div style="flex: 1"><!></div></div> <!></div>`,
  ),
  Region_settings_box[FILENAME],
  [
    [
      35,
      0,
      [
        [
          36,
          2,
          [
            [37, 4],
            [41, 4],
          ],
        ],
      ],
    ],
  ],
);

function Region_settings_box($$anchor, $$props) {
  check_target(new.target);
  push($$props, true, Region_settings_box);

  const mapCode = tag(
    user_derived(() => adminState.mapCode),
    "mapCode",
  );
  const regionId = tag(
    user_derived(() => adminState.highlightedRegionId),
    "regionId",
  );
  const pinId = tag(
    user_derived(() => adminState.highlightedPinId),
    "pinId",
  );
  const settingsPane = tag(
    user_derived(() => adminState.regionSettingsPane),
    "settingsPane",
  );
  const hasSelection = tag(
    user_derived(() => !!(get(mapCode) && (get(regionId) || get(pinId)))),
    "hasSelection",
  );

  user_effect(() => {
    if (strict_equals(get(settingsPane), "region")) {
      adminState.highlightedPinId = null;
    } else {
      adminState.highlightedRegionId = null;
    }
  });

  var div = root();
  var div_1 = child(div);
  var div_2 = child(div_1);

  set_style(div_2, "", {}, { width: "5rem" });

  var node = child(div_2);

  add_svelte_meta(
    () => Settings_pane_selector(node, {}),
    "component",
    Region_settings_box,
    38,
    6,
    { componentTag: "SettingsPaneSelector" },
  );
  reset(div_2);

  var div_3 = sibling(div_2, 2);
  var node_1 = child(div_3);

  add_svelte_meta(
    () =>
      key(
        node_1,
        () => adminState.mapCode,
        ($$anchor) => {
          var fragment = comment();
          var node_2 = first_child(fragment);

          {
            var consequent = ($$anchor) => {
              add_svelte_meta(
                () =>
                  Region_selector($$anchor, {
                    get mapData() {
                      return $$props.mapData;
                    },
                  }),
                "component",
                Region_settings_box,
                44,
                10,
                { componentTag: "RegionSelector" },
              );
            };

            var alternate = ($$anchor) => {
              var fragment_2 = comment();
              var node_3 = first_child(fragment_2);

              {
                var consequent_1 = ($$anchor) => {
                  add_svelte_meta(
                    () => Pin_selector($$anchor, {}),
                    "component",
                    Region_settings_box,
                    46,
                    10,
                    { componentTag: "PinSelector" },
                  );
                };

                add_svelte_meta(
                  () =>
                    if_block(
                      node_3,
                      ($$render) => {
                        if (get(mapCode)) $$render(consequent_1);
                      },
                      true,
                    ),
                  "if",
                  Region_settings_box,
                  45,
                  8,
                );
              }

              append($$anchor, fragment_2);
            };

            add_svelte_meta(
              () =>
                if_block(node_2, ($$render) => {
                  if (strict_equals(get(settingsPane), "region"))
                    $$render(consequent);
                  else $$render(alternate, false);
                }),
              "if",
              Region_settings_box,
              43,
              8,
            );
          }

          append($$anchor, fragment);
        },
      ),
    "key",
    Region_settings_box,
    42,
    6,
  );

  reset(div_3);
  reset(div_1);

  var node_4 = sibling(div_1, 2);

  {
    var consequent_4 = ($$anchor) => {
      var fragment_4 = comment();
      var node_5 = first_child(fragment_4);

      {
        var consequent_2 = ($$anchor) => {
          add_svelte_meta(
            () =>
              Region_fields($$anchor, {
                get regionId() {
                  return get(regionId);
                },

                get canRichEdit() {
                  return $$props.canRichEdit;
                },
              }),
            "component",
            Region_settings_box,
            54,
            6,
            { componentTag: "RegionFields" },
          );
        };

        var alternate_1 = ($$anchor) => {
          var fragment_6 = comment();
          var node_6 = first_child(fragment_6);

          {
            var consequent_3 = ($$anchor) => {
              add_svelte_meta(
                () =>
                  Pin_fields($$anchor, {
                    get pinId() {
                      return get(pinId);
                    },

                    get canRichEdit() {
                      return $$props.canRichEdit;
                    },
                  }),
                "component",
                Region_settings_box,
                56,
                6,
                { componentTag: "PinFields" },
              );
            };

            add_svelte_meta(
              () =>
                if_block(
                  node_6,
                  ($$render) => {
                    if (get(pinId)) $$render(consequent_3);
                  },
                  true,
                ),
              "if",
              Region_settings_box,
              55,
              4,
            );
          }

          append($$anchor, fragment_6);
        };

        add_svelte_meta(
          () =>
            if_block(node_5, ($$render) => {
              if (get(regionId)) $$render(consequent_2);
              else $$render(alternate_1, false);
            }),
          "if",
          Region_settings_box,
          53,
          4,
        );
      }

      append($$anchor, fragment_4);
    };

    add_svelte_meta(
      () =>
        if_block(node_4, ($$render) => {
          if (get(hasSelection)) $$render(consequent_4);
        }),
      "if",
      Region_settings_box,
      52,
      2,
    );
  }

  reset(div);
  template_effect(() =>
    set_class(div, 1, clsx(["tg_am_fields", $$props.class]), "svelte-feb6a4"),
  );
  append($$anchor, div);

  return pop({ ...legacy_api() });
}

{
  import("./tg-am-pro-tooltips-CDfsVut2GA.js");
}
const mountMapBox = (el, props) => {
  mount(Map_box, el, props);
};
const mountMapSettingsBox = (el, props) => {
  mount(Map_settings_box, el, props);
};
const mountRegionSettingsBox = (el, props) => {
  mount(Region_settings_box, el, props);
};
const setupBoxes = (input) => {
  if (isMapCode(input.code)) {
    adminState.mapCode = input.code;
    adminState.mapData[input.code] = new MapDataState();
  }
  if (isThemeId(input.themeId)) {
    adminState.themeId = input.themeId;
  }
  if (isRecord(input.customThemes)) {
    for (const [id, theme] of Object.entries(input.customThemes)) {
      if (isCustomTheme(theme) && theme.id === id) {
        adminState.customThemes[theme.id] = theme;
        const styleId = getCustomThemeStyleId(theme.id);
        if (!document.querySelector(`style#${styleId}`)) {
          const elStyle = document.createElement("style");
          elStyle.id = styleId;
          elStyle.textContent = customThemeToCssRule(theme);
          document.head.appendChild(elStyle);
        }
      }
    }
  }
  adminState.hasTooltips = getBoolean(input.hasTooltips);
  adminState.hasActions = getBoolean(input.hasActions);
  adminState.hasHoverEffects = getBoolean(input.hasHoverEffects);
  adminState.hasRegionColors = getBoolean(input.hasRegionColors);
  adminState.hasUsStateLabels = getBoolean(input.hasUsStateLabels);
  adminState.usStateLabelSizePixels = getPositiveInteger(
    input.usStateLabelSizePixels,
  );
  if (isRecord(input.data)) {
    for (const [mapCode, data] of Object.entries(input.data)) {
      if (!(isMapCode(mapCode) || mapCode === "__default") || !isRecord(data)) {
        continue;
      }
      adminState.mapData[mapCode] ??= new MapDataState();
      const mapDataState = adminState.mapData[mapCode];
      setupRegions(mapDataState, data.regions);
      setupPins(mapDataState, data.pins);
      mapDataState.customRegions = extractBooleans(data.customRegions);
    }
  }
};
const setupRegions = (state, input) => {
  if (!isRecord(input)) return;
  setupTooltips(state.regions.tooltips, input.tooltips);
  setupActions(state.regions.actions, input.actions);
  state.regions.colors = extractValues(input.colors, isRegionColors);
};
const setupPins = (state, input) => {
  if (!isRecord(input)) return;
  setupTooltips(state.pins.tooltips, input.tooltips);
  setupActions(state.pins.actions, input.actions);
  state.pins.details = extractPins(input.details);
  state.pins.shapes = extractValues(input.shapes, isPinShape);
};
const setupTooltips = (state, input) => {
  if (!isRecord(input)) return;
  state.types = extractValues(input.types, isTooltipType);
  state.customText = extractValues(input.customText, isString);
  state.customRichText = extractValues(input.customRichText, isString);
  state.rich = extractBooleans(input.rich);
  state.centered = extractBooleans(input.centered);
  state.interactive = extractBooleans(input.interactive);
};
const setupActions = (state, input) => {
  if (!isRecord(input)) return;
  state.types = extractValues(input.types, isActionType);
  state.urls = extractValues(input.urls, isString);
  state.urlsInNewTab = extractBooleans(input.urlsInNewTab);
};
if (tg_am_data) {
  const data = tg_am_data;
  const { meta, mapId, canRichEdit } = tg_am_data;
  const hasMeta = !!meta;
  const hasMapId = !!mapId;
  const hasCanRichEdit = typeof canRichEdit === "boolean";
  if (hasMeta) {
    setupBoxes(meta);
  }
  if (hasMapId) {
    mountMapBox(document.querySelector("#tg_am_map_meta .inside"), data);
  }
  if (hasMapId && hasCanRichEdit) {
    mountMapSettingsBox(document.querySelector("#tg_am_map_settings"), data);
  }
  if (hasCanRichEdit) {
    mountRegionSettingsBox(
      document.querySelector("#tg_am_region_settings"),
      data,
    );
  }
}

export {
  tooltipForRichText as a,
  tooltipForInteractiveTooltip as b,
  tooltipForCenteredTooltip as c,
  tooltipForHoverEffects as d,
  proTitle as p,
  tooltipForRegionColors as t,
};
