<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function tg_am_save_post( $post_id ) {
  if (
    empty( $post_id ) ||
    !is_numeric( $post_id ) ||
    ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) ||
    ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ||
    ( defined( 'DOING_CRON' ) && DOING_CRON ) ||
    ! current_user_can( 'edit_post', $post_id )
  ) {
    return;
  }

  $nonce = isset( $_POST['tg_am_map_nonce'] )
    ? sanitize_text_field( wp_unslash( $_POST['tg_am_map_nonce'] ) )
    : null;

  $map = isset( $_POST['tg_am_map'] )
    ? map_deep( wp_unslash( $_POST['tg_am_map'] ), 'wp_kses_post' )
    : null;

  if (
    empty( $nonce ) ||
    ! wp_verify_nonce( $nonce, 'tg_am_map_save' ) ||
    empty( $map ) ||
    ! is_array( $map )
  ) {
    return;
  }

  $as_bool = function( &$input, $key ) {
    if ( ! empty( $input[$key] ) ) {
      $input[$key] = $input[$key] === 'true' ? 'true' : 'false';
    }
  };

  $as_int = function( &$input, $key ) {
    if ( ! empty( $input[$key] ) ) {
      $input[$key] = (string) ( (int) $input[$key] );
    }
  };

  $as_bool( $map, 'hasTooltips' );
  $as_bool( $map, 'hasActions' );
  $as_bool( $map, 'hasHoverEffects' );
  $as_bool( $map, 'hasRegionColors' );
  $as_bool( $map, 'hasUsStateLabels' );
  $as_int( $map, 'usStateLabelSizePixels' );

  update_post_meta( $post_id, TG_AM_META_MAP, $map );
}
