<?php

if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_enqueue_scripts', function() {
  wp_enqueue_style(
    /* handle */ 'tg_am_admin_style',
    /* src    */ TG_AM_ASSETS_URL . 'admin.css',
    /* deps   */ array(),
    /* ver    */ tg_am_asset_style_version()
  );
} );

add_action( 'admin_menu', function() {
  add_menu_page(
    /* page_title */ 'Atlas Maps',
    /* menu_title */ 'Atlas Maps',
    /* capability */ 'manage_options',
    /* menu_slug  */ 'edit.php?post_type=tg_am_map',
    /* function   */ null,
    /* icon_url   */ '',
    /* position   */ 50  // content section
  );
}, 9 );

add_action( 'admin_init', function () {
  register_post_type( 'tg_am_map', array(
    'labels' => array(
      'name'                     => 'Atlas Maps',
      'singular_name'            => 'Atlas Map',
      'add_new'                  => 'Add New Map',
      'add_new_item'             => 'Add New Map',
      'edit_item'                => 'Edit Atlas Map',
      'new_item'                 => 'New Atlas Map',
      'view_item'                => 'View Atlas Map',
      'view_items'               => 'View Atlas Maps',
      'search_items'             => 'Search Atlas Maps',
      'not_found'                => 'No maps found',
      'not_found_in_trash'       => 'No maps found in Trash',
      'parent_item_colon'        => 'Parent Map',
      'all_items'                => 'All Maps',
      'archives'                 => 'Map Archives',
      'attributes'               => 'Map Attributes',
      'insert_into_item'         => 'Insert into map',
      'uploaded_to_this_item'    => 'Uploaded to this map',
      'filter_items_list'        => 'Filter map list',
      'items_list_navigation'    => 'Maps list navigation',
      'items_list'               => 'Maps list',
      'item_published'           => 'Map published.',
      'item_published_privately' => 'Map published privately.',
      'item_reverted_to_draft'   => 'Map reverted to draft.',
      'item_trashed'             => 'Map trashed.',
      'item_scheduled'           => 'Map scheduled.',
      'item_updated'             => 'Map updated.',
      'item_link'                => 'Map Link',
      'item_link_description'    => 'A link to a map.',
    ),
    'public'             => false,
    'publicly_queryable' => false,
    'show_ui'            => true,
    'show_in_menu'       => 'tg_am_maps',
    'menu_icon'          => '',
    'supports'           => array( 'title', 'author', 'revisions' ),
    'capability_type'    => 'post',
    'map_meta_cap'       => true,
  ));
});

add_action( 'add_meta_boxes_tg_am_map', function() {
  require_once __DIR__ . '/boxes.php';
  tg_am_add_meta_boxes();
} );

add_action( 'save_post_tg_am_map', function( $post_id ) {
  require_once __DIR__ . '/save-post.php';
  tg_am_save_post( $post_id );
} );
