<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function tg_am_render_shortcode_error( $tag, $attrs, $error_id, $data ) {
  $tag_text = '[' .
    $tag .
    (empty($attrs) ? '' : (' ' . implode(' ', $attrs))) .
  ']';

  $complete_shortcode_message = 'You can find the complete shortcode in the Settings section of your map.';

  $has_map_id = empty( $data ) || ! is_array( $data ) || ! isset( $data['id'] );

  $map_id_title = $has_map_id
    ? ''
    : ( 'ID ' . ( (string) $data['id'] ) );

  $map_id_body = $has_map_id
    ? 'the specified ID'
    : ( 'ID ' . ( (string) $data['id'] ) );

  ob_start();

?>
  <p>
    <div class="tg_am_error_box">
      <div class="tg_am_error_box_header">
        <span class="tg_am_error_box_title">Atlas Maps Error</span>
        <code><?php echo esc_html( $tag_text ) ?></code>
      </div>

      <div class="tg_am_error_box_overview tg_am_error_box_text">
        <?php if ( $error_id === 'expected_map_id' ) { ?>
          Expected map ID
        <?php } elseif ( $error_id === 'map_not_found' ) { ?>
          Map <?php echo esc_html( $map_id_title ) ?> not found.
        <?php } elseif ($error_id === 'map_load_error') { ?>
          Map <?php echo esc_html( $map_id_title ) ?> could not be loaded.
        <?php } ?>
      </div>

      <?php if ( $error_id === 'expected_map_id' ) { ?>
        <div class="tg_am_error_box_text">
          Example:
          <code>[<?php echo esc_html( $tag ) ?> <b>123</b>]</code>,
          where <code><b>123</b></code> is the ID of the map you'd like to display.
          <?php echo esc_html( $complete_shortcode_message ) ?>
        </div>
      <?php } elseif ( $error_id === 'map_not_found' ) { ?>
        <div class="tg_am_error_box_text">
          Please make sure the map with <?php echo esc_html( $map_id_body ) ?>
          exists and is <b>published</b>.
          <?php echo esc_html( $complete_shortcode_message ) ?>
        </div>
      <?php } elseif ( $error_id === 'map_load_error' ) { ?>
        <div class="tg_am_error_box_text">
          There was an error loading the map with
          <?php echo esc_html( $map_id_body ) ?>.
          Please try re-publishing it.
        </div>
      <?php } ?>
    </div>
  </p>
<?php

  return ob_get_clean();
}
