<?php

if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_enqueue_scripts', function( $hook_suffix ) {
  if ( $hook_suffix !== 'post.php' && $hook_suffix !== 'post-new.php' ) {
    return;
  }

  $post_id = get_the_ID();
  if ( empty( $post_id ) ) {
    return;
  }

  $ver = '4.0.13';

  wp_enqueue_script(
    /* handle    */ 'tg_am_select2_script',
    /* src       */ TG_AM_ASSETS_URL . 'select2-' . $ver . '/js/select2.min.js',
    /* deps      */ array('jquery'),
    /* ver       */ $ver,
    /* in_footer */ false
  );

  wp_enqueue_style(
    /* handle */ 'tg_am_select2_style',
    /* src    */ TG_AM_ASSETS_URL . 'select2-' . $ver . '/css/select2.min.css',
    /* deps   */ array(),
    /* ver    */ $ver
  );

  wp_enqueue_script(
    /* handle */ 'tg_am_admin_script',
    /* src    */ tg_am_asset_admin_js(),
    /* deps   */ array(),
    /* ver    */ $ver,
    /* args   */ array( 'in_footer' => true )
  );

  $meta = get_post_meta( $post_id, TG_AM_META_MAP, true );
  if ( ! is_array($meta) ) {
    $meta = array(
      'code' => TG_AM_DEFAULT_MAP_CODE,
      'themeId' => TG_AM_DEFAULT_MAP_THEME_ID,
    );
  }

  $js_data = array(
    'assetsBaseUrl' => tg_am_assets_base_url(),
    'meta' => $meta,
    'mapId' => $post_id,
    'mapShortcode' => TG_AM_SHORTCODE_MAP,
    'canRichEdit' => user_can_richedit()
  );

  wp_add_inline_script(
    'tg_am_admin_script',
    'window.tg_am_data = ' . wp_json_encode( $js_data ),
    'before'
  );
} );

add_filter( 'script_loader_tag', function ( $tag, $handle ) {
  if ( $handle === 'tg_am_admin_script' ) {
    return str_replace('<script', '<script type="module"', $tag);
  }

  return $tag;
}, 10, 2 );

add_action( 'edit_form_top', function() {
  wp_nonce_field( 'tg_am_map_save', 'tg_am_map_nonce' );
} );

function tg_am_add_meta_boxes() {
  add_meta_box(
    /* id       */ 'tg_am_map_meta',
    /* title    */ 'Map',
    /* callback */ function() {},
    /* screen   */ 'tg_am_map',
    /* context  */ 'normal',
    /* priority */ 'high'
  );

  add_meta_box(
    /* id       */ 'tg_am_map_settings_meta',
    /* title    */ 'Map Settings',
    /* callback */ function() { ?><div id="tg_am_map_settings"></div><?php },
    /* screen   */ 'tg_am_map',
    /* context  */ 'side',
    /* priority */ 'high'
  );

  add_meta_box(
    /* id       */ 'tg_am_region_settings_meta',
    /* title    */ 'Region Settings',
    /* callback */ function() {
      do_action( 'tg_am_region_settings_meta_box' );
      ?>
        <div class="tg_am_relative">
          <div id="tg_am_region_settings"></div>
        </div>
      <?php
    },
    /* screen   */ 'tg_am_map',
    /* context  */ 'side',
    /* priority */ 'high'
  );
}
