<?php
/**
 * Askova – Smart FAQ Chat Uninstall
 *
 * Fired when the plugin is deleted (not just deactivated).
 * Removes all plugin data from the database.
 *
 * @package Askova
 */

// Exit if not called by WordPress.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// 1. Delete plugin settings.
delete_option( 'wpfaqcb_settings' );

// 2. Delete admin language preference.
delete_option( 'wpfaqcb_admin_lang' );

// 3. Delete DB version tracker.
delete_option( 'wpfaqcb_db_version' );

// 4. Delete any transients.
delete_transient( 'wpfaqcb_activation_redirect' );

// 5. Drop the submissions table.
global $wpdb;
$wpfaqcb_table = $wpdb->prefix . 'wpfaqcb_submissions';
$wpdb->query( "DROP TABLE IF EXISTS `{$wpfaqcb_table}`" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Uninstall cleanup.

// 6. Drop the ratings table.
$wpfaqcb_ratings = $wpdb->prefix . 'wpfaqcb_ratings';
$wpdb->query( "DROP TABLE IF EXISTS `{$wpfaqcb_ratings}`" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Uninstall cleanup.

// 7. Clear rate-limit transients.
$wpdb->query( "DELETE FROM `{$wpdb->options}` WHERE `option_name` LIKE '_transient_wpfaqcb_rl_%' OR `option_name` LIKE '_transient_timeout_wpfaqcb_rl_%'" ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Uninstall cleanup.

// 8. Clear any cached data.
wp_cache_delete( 'wpfaqcb_logs_count', 'wpfaqcb' );
