<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_Chat_Renderer {
	public function __construct() {
		add_action( 'wp_footer', array( $this, 'render' ) );
	}
	public function render() {
		if ( '1' !== WPFAQCB_Settings_Manager::get( 'chat_enabled' ) ) return;
		$pages = WPFAQCB_Settings_Manager::get( 'load_on_pages' );
		if ( ! empty( $pages ) ) {
			$ids = array_map( 'absint', array_filter( explode( ',', $pages ) ) );
			if ( ! in_array( get_queried_object_id(), $ids, true ) ) return;
		}
		$s    = WPFAQCB_Settings_Manager::get_all();
		$fl   = WPFAQCB_Settings_Manager::detect_front_lang();
		$dir  = ( 'ar' === $fl ) ? 'rtl' : 'ltr';
		$cd   = WPFAQCB_Settings_Manager::content_defaults();

		/* Resolve UI texts for detected language */
		foreach ( $cd as $k => $pair ) {
			$ar_default = isset( $pair['ar'] ) ? $pair['ar'] : '';
			$en_default = isset( $pair['en'] ) ? $pair['en'] : '';
			$saved_val  = isset( $s[ $k ] ) ? $s[ $k ] : '';
			if ( '' === $saved_val || $saved_val === $ar_default || $saved_val === $en_default ) {
				$s[ $k ] = isset( $pair[ $fl ] ) ? $pair[ $fl ] : $saved_val;
			}
		}
		?>
		<div class="wpfaqcb-popup" dir="<?php echo esc_attr( $dir ); ?>" aria-hidden="true">
			<button class="wpfaqcb-popup-close" aria-label="Close">&times;</button>
			<div class="wpfaqcb-popup-text"><?php echo esc_html( $s['popup_text'] ); ?></div>
		</div>
		<button class="wpfaqcb-fab" aria-label="Open chat">
			<img src="<?php echo esc_url( WPFAQCB_URL . 'assets/images/fab-icon.png' ); ?>" alt="Chat" width="60" height="60" aria-hidden="true" />
		</button>
		<div class="wpfaqcb-container" dir="<?php echo esc_attr( $dir ); ?>" aria-hidden="true" role="dialog">
			<div class="wpfaqcb-header">
				<div class="wpfaqcb-header-content">
					<h2><?php echo esc_html( $s['header_title'] ); ?></h2>
					<p><?php echo esc_html( $s['header_subtitle'] ); ?></p>
				</div>
				<button class="wpfaqcb-close" aria-label="Close">&times;</button>
			</div>
			<div class="wpfaqcb-body"></div>
			<div class="wpfaqcb-input">
				<input type="text" placeholder="<?php echo esc_attr( $s['input_placeholder'] ); ?>" />
				<button class="wpfaqcb-send" aria-label="Send">
					<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="22" y1="2" x2="11" y2="13"/><polygon points="22 2 15 22 11 13 2 9 22 2"/></svg>
				</button>
			</div>
		</div>
		<?php
	}
}
