<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_Shortcode {

	public function __construct() {
		add_shortcode( 'askova', array( $this, 'render' ) );
	}

	public function render( $atts ) {
		$atts = shortcode_atts( array(
			'section' => '',
		), $atts, 'askova' );

		$s        = WPFAQCB_Settings_Manager::get_all();
		$sections = $s['faq_sections'];
		$dir      = 'rtl' === $s['chat_direction'] ? 'rtl' : 'ltr';

		if ( empty( $sections ) ) {
			return '<p>' . esc_html__( 'No FAQ sections configured.', 'askova' ) . '</p>';
		}

		/* Filter specific section */
		if ( ! empty( $atts['section'] ) ) {
			$target = absint( $atts['section'] );
			if ( $target > 0 && $target <= count( $sections ) ) {
				$sections = array( $sections[ $target - 1 ] );
			}
		}

		/* Enqueue frontend styles */
		$font = sanitize_text_field( $s['google_font'] );
		if ( ! empty( $font ) ) {
			wp_enqueue_style( 'wpfaqcb-gfont', 'https://fonts.googleapis.com/css2?family=' . rawurlencode( $font ) . ':wght@300;400;500;600;700&display=swap', array(), WPFAQCB_VERSION );
		}
		wp_enqueue_style( 'wpfaqcb-front', WPFAQCB_URL . 'assets/css/chatbot.css', array(), WPFAQCB_VERSION );

		ob_start();
		?>
		<div class="wpfaqcb-inline" dir="<?php echo esc_attr( $dir ); ?>">
			<div class="wpfaqcb-inline-sections">
				<?php foreach ( $sections as $idx => $sec ) : ?>
					<div class="wpfaqcb-inline-section">
						<h3 class="wpfaqcb-inline-section-title">
							<?php if ( ! empty( $sec['icon_url'] ) ) : ?>
								<img src="<?php echo esc_url( $sec['icon_url'] ); ?>" alt="" class="wpfaqcb-inline-icon" />
							<?php endif; ?>
							<?php echo esc_html( $sec['title'] ); ?>
						</h3>
						<?php
						if ( '1' === $sec['has_subs'] && ! empty( $sec['subs'] ) ) {
							foreach ( $sec['subs'] as $sub ) {
								if ( ! empty( $sub['items'] ) ) {
									echo '<h4 class="wpfaqcb-inline-sub-title">' . esc_html( $sub['title'] ) . '</h4>';
									foreach ( $sub['items'] as $it ) {
										self::render_accordion_item( $it );
									}
								}
							}
						} elseif ( ! empty( $sec['items'] ) ) {
							foreach ( $sec['items'] as $it ) {
								self::render_accordion_item( $it );
							}
						}
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<script>
		(function(){
			document.querySelectorAll('.wpfaqcb-inline').forEach(function(wrap){
				wrap.addEventListener('click',function(e){
					var t=e.target.closest('.wpfaqcb-inline-q');
					if(!t)return;
					var a=t.nextElementSibling;
					if(a&&a.classList.contains('wpfaqcb-inline-a')){
						a.style.display=a.style.display==='none'?'block':'none';
						t.classList.toggle('active');
					}
				});
			});
		})();
		</script>
		<?php
		return ob_get_clean();
	}

	private static function render_accordion_item( $item ) {
		?>
		<div class="wpfaqcb-inline-item">
			<div class="wpfaqcb-inline-q"><?php echo esc_html( $item['question'] ); ?></div>
			<div class="wpfaqcb-inline-a" style="display:none;"><?php echo wp_kses_post( $item['answer'] ); ?></div>
		</div>
		<?php
	}
}
