<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_Settings_Manager {

	const OPTION_KEY = 'wpfaqcb_settings';

	public static function content_defaults() {
		return array(
			'header_title'       => array( 'ar' => 'مساعد الأسئلة',                          'en' => 'FAQ Assistant' ),
			'header_subtitle'    => array( 'ar' => 'كيف نقدر نساعدك؟',                       'en' => 'How can we help you?' ),
			'welcome_title'      => array( 'ar' => 'أهلاً ومرحبًا بك',                        'en' => 'Welcome!' ),
			'welcome_text'       => array( 'ar' => 'يرجى اختيار القسم المطلوب للمتابعة.',      'en' => 'Please select a section to continue.' ),
			'popup_text'         => array( 'ar' => 'مرحبا هل يمكنني مساعدتك ؟',              'en' => 'Hi! Can I help you?' ),
			'input_placeholder'  => array( 'ar' => 'اكتب رقم الخدمة...',                      'en' => 'Type service number...' ),
			'back_main_label'    => array( 'ar' => '← العودة للقائمة الرئيسية',               'en' => '← Back to main menu' ),
			'back_section_label' => array( 'ar' => '← العودة للقسم السابق',                   'en' => '← Back to section' ),
			'answer_label'       => array( 'ar' => '✓ الإجابة',                               'en' => '✓ Answer' ),
			'contact_btn_label'  => array( 'ar' => 'تحدث مع مختص',                            'en' => 'Talk to a specialist' ),
			'request_btn_label'  => array( 'ar' => 'احصل على عرض',                            'en' => 'Get a quote' ),
			'helpme_title'       => array( 'ar' => 'لا أعرف ما الخدمة المناسبة لي',           'en' => "I don't know which service I need" ),
			'helpme_question'    => array( 'ar' => 'عندك تحدي في:',                           'en' => 'Do you have a challenge with:' ),
			'form_title'         => array( 'ar' => 'طلب خدمة',                                'en' => 'Service Request' ),
			'form_subtitle'      => array( 'ar' => 'املأ البيانات وسنتواصل معك',              'en' => "Fill in the details and we'll contact you" ),
			'form_submit_label'  => array( 'ar' => 'إرسال الطلب',                             'en' => 'Submit Request' ),
			'form_success_msg'   => array( 'ar' => 'تم إرسال طلبك بنجاح. سيتم التواصل معكم في أقرب وقت.', 'en' => "Your request has been submitted successfully. We'll contact you soon." ),
			'rating_question'    => array( 'ar' => 'هل كانت الإجابة مفيدة؟',                  'en' => 'Was this answer helpful?' ),
			'rating_thanks'      => array( 'ar' => 'شكراً لتقييمك!',                          'en' => 'Thanks for your feedback!' ),
			'quick_reply_label'  => array( 'ar' => 'أسئلة أخرى قد تهمك:',                     'en' => 'Other questions you may like:' ),
			'copy_success'       => array( 'ar' => 'تم نسخ الإجابة!',                         'en' => 'Answer copied!' ),
		);
	}

	public static function get_defaults( $lang = 'ar' ) {
		$cd = self::content_defaults();
		$d  = array(
			'chat_enabled'       => '1',
			'chat_position'      => 'left',
			'popup_enabled'      => '1',
			'popup_delay'        => 3,
			'popup_duration'     => 8,
			'chat_direction'     => 'ar' === $lang ? 'rtl' : 'ltr',
			'google_font'        => 'Almarai',
			'faq_sections'       => array(),
			'helpme_enabled'     => '1',
			'helpme_options'     => array(),
			'form_enabled'       => '1',
			'form_email_notify'  => '0',
			'form_email_to'      => '',
			'form_fields'        => array(),
			'contact_enabled'    => '0',
			'contact_phone'      => '',
			'contact_email'      => '',
			'contact_whatsapp'   => '',
			'contact_website'    => '',
			'color_primary'      => '#1a5276',
			'color_header'       => '#1a5276',
			'color_header_text'  => '#ffffff',
			'color_chat_bg'      => '#f4f6f8',
			'color_button'       => '#1a5276',
			'color_button_text'  => '#ffffff',
			'color_text'         => '#2c3e50',
			'color_accent'       => '#c9942e',
			'chat_width'         => 390,
			'chat_max_height'    => 600,
			'border_radius'      => 16,
			'load_on_pages'      => '',
			/* v2 settings */
			'typing_animation'   => '1',
			'rating_enabled'     => '1',
			'session_memory'     => '1',
			'lazy_load'          => '0',
			'antispam_honeypot'  => '1',
			'antispam_rate_limit'=> '1',
			'quick_reply_enabled'=> '1',
			'copy_answer_enabled'=> '1',
			'print_answer_enabled'=> '1',
			'welcome_variations' => '',
		);
		foreach ( $cd as $k => $v ) {
			$d[ $k ] = isset( $v[ $lang ] ) ? $v[ $lang ] : $v['ar'];
		}
		return $d;
	}

	public static function get_all() {
		$saved = get_option( self::OPTION_KEY, array() );
		if ( ! is_array( $saved ) ) $saved = array();
		return wp_parse_args( $saved, self::get_defaults( 'ar' ) );
	}

	public static function get( $key, $default = null ) {
		$s = self::get_all();
		return isset( $s[ $key ] ) ? $s[ $key ] : $default;
	}

	public static function save( $data ) {
		return update_option( self::OPTION_KEY, $data );
	}

	public static function activate() {
		if ( false === get_option( self::OPTION_KEY ) ) {
			add_option( self::OPTION_KEY, self::get_defaults( 'ar' ) );
		}
	}

	public static function swap_content_lang( $from, $to ) {
		$s  = self::get_all();
		$cd = self::content_defaults();
		$changed = false;
		foreach ( $cd as $k => $pair ) {
			$old_default = isset( $pair[ $from ] ) ? $pair[ $from ] : '';
			$new_default = isset( $pair[ $to ] )   ? $pair[ $to ]   : '';
			if ( isset( $s[ $k ] ) && ( $s[ $k ] === $old_default || '' === $s[ $k ] ) ) {
				$s[ $k ] = $new_default;
				$changed = true;
			}
		}
		if ( $changed ) {
			self::save( $s );
		}
	}

	public static function sanitize( $r ) {
		$c = array();
		$c['chat_enabled']       = ! empty( $r['chat_enabled'] ) ? '1' : '0';
		$c['chat_position']      = isset( $r['chat_position'] ) && 'right' === $r['chat_position'] ? 'right' : 'left';
		$c['popup_enabled']      = ! empty( $r['popup_enabled'] ) ? '1' : '0';
		$c['popup_delay']        = isset( $r['popup_delay'] ) ? absint( $r['popup_delay'] ) : 3;
		$c['popup_duration']     = isset( $r['popup_duration'] ) ? absint( $r['popup_duration'] ) : 8;
		$c['chat_direction']     = isset( $r['chat_direction'] ) && 'ltr' === $r['chat_direction'] ? 'ltr' : 'rtl';
		$c['google_font']        = isset( $r['google_font'] ) ? sanitize_text_field( $r['google_font'] ) : '';
		$c['header_title']       = isset( $r['header_title'] ) ? sanitize_text_field( $r['header_title'] ) : '';
		$c['header_subtitle']    = isset( $r['header_subtitle'] ) ? sanitize_text_field( $r['header_subtitle'] ) : '';
		$c['welcome_title']      = isset( $r['welcome_title'] ) ? sanitize_text_field( $r['welcome_title'] ) : '';
		$c['welcome_text']       = isset( $r['welcome_text'] ) ? sanitize_textarea_field( $r['welcome_text'] ) : '';
		$c['popup_text']         = isset( $r['popup_text'] ) ? sanitize_text_field( $r['popup_text'] ) : '';
		$c['input_placeholder']  = isset( $r['input_placeholder'] ) ? sanitize_text_field( $r['input_placeholder'] ) : '';
		$c['back_main_label']    = isset( $r['back_main_label'] ) ? sanitize_text_field( $r['back_main_label'] ) : '';
		$c['back_section_label'] = isset( $r['back_section_label'] ) ? sanitize_text_field( $r['back_section_label'] ) : '';
		$c['answer_label']       = isset( $r['answer_label'] ) ? sanitize_text_field( $r['answer_label'] ) : '';
		$c['contact_btn_label']  = isset( $r['contact_btn_label'] ) ? sanitize_text_field( $r['contact_btn_label'] ) : '';
		$c['request_btn_label']  = isset( $r['request_btn_label'] ) ? sanitize_text_field( $r['request_btn_label'] ) : '';
		$c['faq_sections']       = self::sanitize_sections( isset( $r['faq_sections'] ) ? $r['faq_sections'] : array() );
		$c['helpme_enabled']     = ! empty( $r['helpme_enabled'] ) ? '1' : '0';
		$c['helpme_title']       = isset( $r['helpme_title'] ) ? sanitize_text_field( $r['helpme_title'] ) : '';
		$c['helpme_question']    = isset( $r['helpme_question'] ) ? sanitize_text_field( $r['helpme_question'] ) : '';
		$c['helpme_options']     = self::sanitize_helpme( isset( $r['helpme_options'] ) ? $r['helpme_options'] : array() );
		$c['form_enabled']       = ! empty( $r['form_enabled'] ) ? '1' : '0';
		$c['form_title']         = isset( $r['form_title'] ) ? sanitize_text_field( $r['form_title'] ) : '';
		$c['form_subtitle']      = isset( $r['form_subtitle'] ) ? sanitize_text_field( $r['form_subtitle'] ) : '';
		$c['form_submit_label']  = isset( $r['form_submit_label'] ) ? sanitize_text_field( $r['form_submit_label'] ) : '';
		$c['form_success_msg']   = isset( $r['form_success_msg'] ) ? sanitize_textarea_field( $r['form_success_msg'] ) : '';
		$c['form_email_notify']  = ! empty( $r['form_email_notify'] ) ? '1' : '0';
		$c['form_email_to']      = isset( $r['form_email_to'] ) ? sanitize_email( $r['form_email_to'] ) : '';
		$c['form_fields']        = self::sanitize_fields( isset( $r['form_fields'] ) ? $r['form_fields'] : array() );
		$c['contact_enabled']    = ! empty( $r['contact_enabled'] ) ? '1' : '0';
		$c['contact_phone']      = isset( $r['contact_phone'] ) ? sanitize_text_field( $r['contact_phone'] ) : '';
		$c['contact_email']      = isset( $r['contact_email'] ) ? sanitize_email( $r['contact_email'] ) : '';
		$c['contact_whatsapp']   = isset( $r['contact_whatsapp'] ) ? sanitize_text_field( $r['contact_whatsapp'] ) : '';
		$c['contact_website']    = isset( $r['contact_website'] ) ? esc_url_raw( $r['contact_website'] ) : '';
		$c['color_primary']      = self::hex( $r, 'color_primary' );
		$c['color_header']       = self::hex( $r, 'color_header' );
		$c['color_header_text']  = self::hex( $r, 'color_header_text' );
		$c['color_chat_bg']      = self::hex( $r, 'color_chat_bg' );
		$c['color_button']       = self::hex( $r, 'color_button' );
		$c['color_button_text']  = self::hex( $r, 'color_button_text' );
		$c['color_text']         = self::hex( $r, 'color_text' );
		$c['color_accent']       = self::hex( $r, 'color_accent' );
		$c['chat_width']         = isset( $r['chat_width'] ) ? absint( $r['chat_width'] ) : 390;
		$c['chat_max_height']    = isset( $r['chat_max_height'] ) ? absint( $r['chat_max_height'] ) : 600;
		$c['border_radius']      = isset( $r['border_radius'] ) ? absint( $r['border_radius'] ) : 16;
		$c['load_on_pages']      = isset( $r['load_on_pages'] ) ? sanitize_text_field( $r['load_on_pages'] ) : '';
		/* v2 */
		$c['typing_animation']   = ! empty( $r['typing_animation'] ) ? '1' : '0';
		$c['rating_enabled']     = ! empty( $r['rating_enabled'] ) ? '1' : '0';
		$c['rating_question']    = isset( $r['rating_question'] ) ? sanitize_text_field( $r['rating_question'] ) : '';
		$c['rating_thanks']      = isset( $r['rating_thanks'] ) ? sanitize_text_field( $r['rating_thanks'] ) : '';
		$c['session_memory']     = ! empty( $r['session_memory'] ) ? '1' : '0';
		$c['lazy_load']          = ! empty( $r['lazy_load'] ) ? '1' : '0';
		$c['antispam_honeypot']  = ! empty( $r['antispam_honeypot'] ) ? '1' : '0';
		$c['antispam_rate_limit']= ! empty( $r['antispam_rate_limit'] ) ? '1' : '0';
		$c['quick_reply_enabled']= ! empty( $r['quick_reply_enabled'] ) ? '1' : '0';
		$c['quick_reply_label']  = isset( $r['quick_reply_label'] ) ? sanitize_text_field( $r['quick_reply_label'] ) : '';
		$c['copy_answer_enabled']= ! empty( $r['copy_answer_enabled'] ) ? '1' : '0';
		$c['print_answer_enabled']= ! empty( $r['print_answer_enabled'] ) ? '1' : '0';
		$c['copy_success']       = isset( $r['copy_success'] ) ? sanitize_text_field( $r['copy_success'] ) : '';
		$c['welcome_variations'] = isset( $r['welcome_variations'] ) ? sanitize_textarea_field( $r['welcome_variations'] ) : '';
		return $c;
	}

	private static function sanitize_sections( $sections ) {
		if ( ! is_array( $sections ) ) return array();
		$out = array();
		foreach ( $sections as $s ) {
			if ( ! is_array( $s ) ) continue;
			$sec = array(
				'title'    => isset( $s['title'] ) ? sanitize_text_field( $s['title'] ) : '',
				'icon_url' => isset( $s['icon_url'] ) ? esc_url_raw( $s['icon_url'] ) : '',
				'lang'     => isset( $s['lang'] ) && in_array( $s['lang'], array( 'ar', 'en', 'all' ), true ) ? $s['lang'] : 'all',
				'has_subs' => ! empty( $s['has_subs'] ) ? '1' : '0',
				'sub_label'=> isset( $s['sub_label'] ) ? sanitize_text_field( $s['sub_label'] ) : '',
				'subs'     => array(),
				'items'    => array(),
			);
			if ( '1' === $sec['has_subs'] && ! empty( $s['subs'] ) && is_array( $s['subs'] ) ) {
				foreach ( $s['subs'] as $sub ) {
					if ( ! is_array( $sub ) ) continue;
					$sb = array( 'title' => isset( $sub['title'] ) ? sanitize_text_field( $sub['title'] ) : '', 'icon_url' => isset( $sub['icon_url'] ) ? esc_url_raw( $sub['icon_url'] ) : '', 'items' => array() );
					if ( ! empty( $sub['items'] ) && is_array( $sub['items'] ) ) {
						foreach ( $sub['items'] as $it ) {
							if ( ! is_array( $it ) ) continue;
							$sb['items'][] = array(
								'question' => isset( $it['question'] ) ? sanitize_text_field( $it['question'] ) : '',
								'answer'   => isset( $it['answer'] ) ? wp_kses_post( $it['answer'] ) : '',
							);
						}
					}
					$sec['subs'][] = $sb;
				}
			} else {
				if ( ! empty( $s['items'] ) && is_array( $s['items'] ) ) {
					foreach ( $s['items'] as $it ) {
						if ( ! is_array( $it ) ) continue;
						$sec['items'][] = array(
							'question' => isset( $it['question'] ) ? sanitize_text_field( $it['question'] ) : '',
							'answer'   => isset( $it['answer'] ) ? wp_kses_post( $it['answer'] ) : '',
						);
					}
				}
			}
			if ( '' !== $sec['title'] ) $out[] = $sec;
		}
		return $out;
	}

	private static function sanitize_helpme( $opts ) {
		if ( ! is_array( $opts ) ) return array();
		$out = array();
		foreach ( $opts as $o ) {
			if ( ! is_array( $o ) ) continue;
			$out[] = array(
				'text'       => isset( $o['text'] ) ? sanitize_text_field( $o['text'] ) : '',
				'suggest'    => isset( $o['suggest'] ) ? sanitize_text_field( $o['suggest'] ) : '',
				'section_id' => isset( $o['section_id'] ) ? absint( $o['section_id'] ) : 0,
				'lang'       => isset( $o['lang'] ) && in_array( $o['lang'], array( 'ar', 'en', 'all' ), true ) ? $o['lang'] : 'all',
			);
		}
		return $out;
	}

	private static function sanitize_fields( $fields ) {
		if ( ! is_array( $fields ) ) return array();
		$allowed = array( 'text', 'email', 'tel', 'select', 'textarea', 'checkbox', 'radio', 'date' );
		$out = array();
		foreach ( $fields as $f ) {
			if ( ! is_array( $f ) ) continue;
			$out[] = array(
				'label'       => isset( $f['label'] ) ? sanitize_text_field( $f['label'] ) : '',
				'type'        => isset( $f['type'] ) && in_array( $f['type'], $allowed, true ) ? $f['type'] : 'text',
				'required'    => ! empty( $f['required'] ) ? '1' : '0',
				'placeholder' => isset( $f['placeholder'] ) ? sanitize_text_field( $f['placeholder'] ) : '',
				'options'     => isset( $f['options'] ) ? sanitize_text_field( $f['options'] ) : '',
				'lang'        => isset( $f['lang'] ) && in_array( $f['lang'], array( 'ar', 'en', 'all' ), true ) ? $f['lang'] : 'all',
			);
		}
		return $out;
	}

	private static function hex( $r, $k ) {
		$c = isset( $r[ $k ] ) ? sanitize_hex_color( $r[ $k ] ) : '';
		return $c ? $c : '#1a5276';
	}

	/**
	 * Detect the current front-end language.
	 * Supports WPML, Polylang, TranslatePress, and plain WordPress locale.
	 */
	public static function detect_front_lang() {
		/* WPML */
		if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
			return ( 0 === strpos( ICL_LANGUAGE_CODE, 'ar' ) ) ? 'ar' : 'en';
		}
		/* Polylang */
		if ( function_exists( 'pll_current_language' ) ) {
			$pl = pll_current_language( 'slug' );
			return ( 0 === strpos( $pl, 'ar' ) ) ? 'ar' : 'en';
		}
		/* TranslatePress */
		if ( class_exists( 'TRP_Translate_Press' ) ) {
			global $TRP_LANGUAGE;
			if ( ! empty( $TRP_LANGUAGE ) ) {
				return ( 0 === strpos( $TRP_LANGUAGE, 'ar' ) ) ? 'ar' : 'en';
			}
		}
		/* WordPress locale fallback */
		$locale = get_locale();
		return ( 0 === strpos( $locale, 'ar' ) ) ? 'ar' : 'en';
	}

	/**
	 * Filter sections by language.
	 */
	public static function filter_by_lang( $items, $lang ) {
		if ( empty( $items ) || ! is_array( $items ) ) {
			return array();
		}
		$out = array();
		foreach ( $items as $item ) {
			$item_lang = isset( $item['lang'] ) ? $item['lang'] : 'all';
			if ( 'all' === $item_lang || $item_lang === $lang ) {
				$out[] = $item;
			}
		}
		return array_values( $out );
	}
}
