<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_I18n {

	const LANG_OPTION = 'wpfaqcb_admin_lang';

	public static function get_lang() {
		$lang = get_option( self::LANG_OPTION, '' );
		return in_array( $lang, array( 'ar', 'en' ), true ) ? $lang : '';
	}

	public static function is_rtl() {
		return 'ar' === self::get_lang();
	}

	public static function has_lang() {
		return '' !== self::get_lang();
	}

	public static function t( $key ) {
		$all  = self::strings();
		$lang = self::get_lang();
		if ( ! $lang ) $lang = 'en';
		return isset( $all[ $key ][ $lang ] ) ? $all[ $key ][ $lang ] : ( isset( $all[ $key ]['en'] ) ? $all[ $key ]['en'] : $key );
	}

	public static function e( $key ) {
		echo esc_html( self::t( $key ) );
	}

	public static function google_fonts() {
		return array(
			''                      => '— Default (System) —',
			'Almarai'               => 'Almarai (عربي)',
			'Cairo'                 => 'Cairo (عربي)',
			'Tajawal'               => 'Tajawal (عربي)',
			'Changa'                => 'Changa (عربي)',
			'El Messiri'            => 'El Messiri (عربي)',
			'Amiri'                 => 'Amiri (عربي)',
			'Noto Sans Arabic'      => 'Noto Sans Arabic (عربي)',
			'Noto Kufi Arabic'      => 'Noto Kufi Arabic (عربي)',
			'IBM Plex Sans Arabic'  => 'IBM Plex Sans Arabic (عربي)',
			'Readex Pro'            => 'Readex Pro (عربي)',
			'Baloo Bhaijaan 2'      => 'Baloo Bhaijaan 2 (عربي)',
			'Reem Kufi'             => 'Reem Kufi (عربي)',
			'Scheherazade New'      => 'Scheherazade New (عربي)',
			'Lateef'                => 'Lateef (عربي)',
			'Harmattan'             => 'Harmattan (عربي)',
			'Mada'                  => 'Mada (عربي)',
			'Markazi Text'          => 'Markazi Text (عربي)',
			'Mirza'                 => 'Mirza (عربي)',
			'Aref Ruqaa'            => 'Aref Ruqaa (عربي)',
			'Lalezar'               => 'Lalezar (عربي)',
			'Rubik'                 => 'Rubik',
			'Inter'                 => 'Inter',
			'Open Sans'             => 'Open Sans',
			'Roboto'                => 'Roboto',
			'Poppins'               => 'Poppins',
			'Montserrat'            => 'Montserrat',
			'Lato'                  => 'Lato',
			'Nunito'                => 'Nunito',
			'Raleway'               => 'Raleway',
			'Source Sans 3'         => 'Source Sans 3',
			'Outfit'                => 'Outfit',
			'DM Sans'              => 'DM Sans',
			'Manrope'               => 'Manrope',
			'Space Grotesk'         => 'Space Grotesk',
			'Plus Jakarta Sans'     => 'Plus Jakarta Sans',
			'Lexend'                => 'Lexend',
			'Quicksand'             => 'Quicksand',
			'Cabin'                 => 'Cabin',
			'Mulish'                => 'Mulish',
			'Ubuntu'                => 'Ubuntu',
			'Karla'                 => 'Karla',
			'Work Sans'             => 'Work Sans',
			'Josefin Sans'          => 'Josefin Sans',
			'Barlow'                => 'Barlow',
			'Playfair Display'      => 'Playfair Display',
			'Merriweather'          => 'Merriweather',
			'Libre Baskerville'     => 'Libre Baskerville',
			'PT Sans'               => 'PT Sans',
			'Fira Sans'             => 'Fira Sans',
			'Exo 2'                 => 'Exo 2',
		);
	}

	public static function strings() {
		return array(
			/* ====== Tabs ====== */
			'tab_general'        => array( 'en' => 'General',           'ar' => 'عام' ),
			'tab_content'        => array( 'en' => 'Content',           'ar' => 'المحتوى' ),
			'tab_faq'            => array( 'en' => 'FAQ Sections',      'ar' => 'أقسام الأسئلة' ),
			'tab_helpme'         => array( 'en' => 'Help Me',           'ar' => 'ساعدني' ),
			'tab_form'           => array( 'en' => 'Request Form',      'ar' => 'نموذج الطلبات' ),
			'tab_design'         => array( 'en' => 'Design',            'ar' => 'التصميم' ),
			'tab_advanced'       => array( 'en' => 'Advanced',          'ar' => 'متقدم' ),
			'tab_docs'           => array( 'en' => 'Documentation',     'ar' => 'التوثيق' ),
			'save_settings'      => array( 'en' => 'Save Settings',     'ar' => 'حفظ الإعدادات' ),
			'saved'              => array( 'en' => 'Settings saved successfully.', 'ar' => 'تم حفظ الإعدادات بنجاح.' ),
			'error'              => array( 'en' => 'An error occurred.', 'ar' => 'حدث خطأ.' ),
			'confirm_delete'     => array( 'en' => 'Are you sure?',     'ar' => 'هل أنت متأكد؟' ),

			/* ====== General ====== */
			'enable_chatbot'     => array( 'en' => 'Enable Chatbot',                    'ar' => 'تفعيل الشات بوت' ),
			'show_frontend'      => array( 'en' => 'Show chatbot on front end',         'ar' => 'إظهار الشات بوت في الواجهة' ),
			'position'           => array( 'en' => 'Position',                           'ar' => 'الموقع' ),
			'left'               => array( 'en' => 'Left',                               'ar' => 'يسار' ),
			'right'              => array( 'en' => 'Right',                              'ar' => 'يمين' ),
			'direction'          => array( 'en' => 'Text Direction',                     'ar' => 'اتجاه النص' ),
			'rtl_label'          => array( 'en' => 'RTL (Arabic)',                       'ar' => 'RTL (عربي)' ),
			'ltr_label'          => array( 'en' => 'LTR (English)',                      'ar' => 'LTR (إنجليزي)' ),
			'show_popup'         => array( 'en' => 'Popup Bubble',                       'ar' => 'فقاعة منبثقة' ),
			'popup_auto'         => array( 'en' => 'Auto-show popup bubble after delay', 'ar' => 'إظهار الفقاعة تلقائياً بعد تأخير' ),
			'popup_delay'        => array( 'en' => 'Popup Delay (sec)',                  'ar' => 'تأخير الفقاعة (ث)' ),
			'popup_duration'     => array( 'en' => 'Popup Duration (sec)',               'ar' => 'مدة الفقاعة (ث)' ),

			/* ====== Content ====== */
			'header_title'       => array( 'en' => 'Header Title',        'ar' => 'عنوان الهيدر' ),
			'header_subtitle'    => array( 'en' => 'Header Subtitle',     'ar' => 'العنوان الفرعي' ),
			'welcome_title'      => array( 'en' => 'Welcome Title',       'ar' => 'عنوان الترحيب' ),
			'welcome_text'       => array( 'en' => 'Welcome Text',        'ar' => 'نص الترحيب' ),
			'welcome_variations_lbl' => array( 'en' => 'Welcome Variations',  'ar' => 'رسائل ترحيب متنوعة' ),
			'welcome_variations_desc'=> array( 'en' => 'One message per line. A random message will be shown each time the chat opens. Leave empty to always use the main welcome text.', 'ar' => 'رسالة واحدة في كل سطر. ستظهر رسالة عشوائية في كل مرة يُفتح الشات. اتركه فارغاً لاستخدام نص الترحيب الرئيسي دائماً.' ),
			'popup_text'         => array( 'en' => 'Popup Text',          'ar' => 'نص الفقاعة' ),
			'input_placeholder'  => array( 'en' => 'Input Placeholder',   'ar' => 'نص حقل الإدخال' ),
			'back_main_label'    => array( 'en' => 'Back to Main Label',  'ar' => 'زر العودة الرئيسية' ),
			'back_section_label' => array( 'en' => 'Back to Section',     'ar' => 'زر العودة للقسم' ),
			'answer_lbl'         => array( 'en' => 'Answer Label',        'ar' => 'عنوان الإجابة' ),
			'contact_btn_label'  => array( 'en' => 'Contact Button',      'ar' => 'زر التواصل' ),
			'request_btn_label'  => array( 'en' => 'Request Button',      'ar' => 'زر الطلب' ),
			'rating_question_lbl'=> array( 'en' => 'Rating Question',     'ar' => 'سؤال التقييم' ),
			'rating_thanks_lbl'  => array( 'en' => 'Rating Thanks',       'ar' => 'شكر التقييم' ),
			'quick_reply_label_lbl' => array( 'en' => 'Quick Reply Label', 'ar' => 'عنوان الردود السريعة' ),
			'copy_success_lbl'   => array( 'en' => 'Copy Success Message', 'ar' => 'رسالة نجاح النسخ' ),

			/* ====== FAQ Sections ====== */
			'faq_desc'           => array( 'en' => 'Build your FAQ sections. Each section represents a service or category.', 'ar' => 'بناء أقسام الأسئلة الشائعة. كل قسم يمثل خدمة أو تصنيف.' ),
			'add_section'        => array( 'en' => '+ Add Section',       'ar' => '+ إضافة قسم' ),
			'section_title'      => array( 'en' => 'Section Title',       'ar' => 'عنوان القسم' ),
			'lang_all'           => array( 'en' => 'All Languages',       'ar' => 'كل اللغات' ),
			'has_subs'           => array( 'en' => 'Has Sub-Sections',    'ar' => 'أقسام فرعية' ),
			'sub_label'          => array( 'en' => 'Sub-Section Label',   'ar' => 'عنوان الأقسام الفرعية' ),
			'add_sub'            => array( 'en' => '+ Add Sub-Section',   'ar' => '+ قسم فرعي' ),
			'sub_title'          => array( 'en' => 'Sub-Section Title',   'ar' => 'عنوان القسم الفرعي' ),
			'add_question'       => array( 'en' => '+ Add Question',      'ar' => '+ إضافة سؤال' ),
			'question'           => array( 'en' => 'Question',            'ar' => 'السؤال' ),
			'answer'             => array( 'en' => 'Answer',              'ar' => 'الإجابة' ),
			'choose_image'       => array( 'en' => 'Choose Image',        'ar' => 'اختر صورة' ),
			'change'             => array( 'en' => 'Change',              'ar' => 'تغيير' ),
			'direct_questions'   => array( 'en' => 'Direct Questions (no sub-sections)', 'ar' => 'أسئلة مباشرة (بدون أقسام فرعية)' ),

			/* ====== Help Me ====== */
			'helpme_desc'        => array( 'en' => 'Configure the "I don\'t know which service" helper. Each option links to a FAQ section.', 'ar' => 'إعداد مساعد "لا أعرف الخدمة المناسبة". كل خيار يربط بقسم أسئلة.' ),
			'helpme_enabled'     => array( 'en' => 'Enable Help Me',      'ar' => 'تفعيل ساعدني' ),
			'helpme_title'       => array( 'en' => 'Button Title',        'ar' => 'عنوان الزر' ),
			'helpme_question'    => array( 'en' => 'Question Text',       'ar' => 'نص السؤال' ),
			'option_text'        => array( 'en' => 'Option Text',         'ar' => 'نص الخيار' ),
			'option_suggest'     => array( 'en' => 'Suggestion Text',     'ar' => 'نص الاقتراح' ),
			'linked_section'     => array( 'en' => 'Linked Section',      'ar' => 'القسم المرتبط' ),
			'select_section'     => array( 'en' => '— Select Section —',  'ar' => '— اختر القسم —' ),
			'add_option'         => array( 'en' => '+ Add Option',        'ar' => '+ إضافة خيار' ),

			/* ====== Form ====== */
			'form_desc'          => array( 'en' => 'Build a service request form shown inside the chatbot. Add fields from the ready templates below.', 'ar' => 'بناء نموذج طلب خدمة يظهر داخل الشات بوت. أضف الحقول من القوالب الجاهزة أدناه.' ),
			'form_enabled'       => array( 'en' => 'Enable Form',           'ar' => 'تفعيل النموذج' ),
			'form_show'          => array( 'en' => 'Show request button in chat', 'ar' => 'إظهار زر الطلب في الشات' ),
			'form_title'         => array( 'en' => 'Form Title',            'ar' => 'عنوان النموذج' ),
			'form_subtitle'      => array( 'en' => 'Form Subtitle',         'ar' => 'وصف النموذج' ),
			'form_submit_label'  => array( 'en' => 'Submit Button',         'ar' => 'نص زر الإرسال' ),
			'form_success_msg'   => array( 'en' => 'Success Message',       'ar' => 'رسالة النجاح' ),
			'form_email_notify'  => array( 'en' => 'Email Notification',    'ar' => 'إشعار بريد' ),
			'form_email_desc'    => array( 'en' => 'Send email on new submission', 'ar' => 'إرسال بريد عند طلب جديد' ),
			'form_email_to'      => array( 'en' => 'Notification Email',    'ar' => 'بريد الإشعارات' ),
			'field_label'        => array( 'en' => 'Label',                 'ar' => 'العنوان' ),
			'field_type'         => array( 'en' => 'Type',                  'ar' => 'النوع' ),
			'field_required'     => array( 'en' => 'Required',              'ar' => 'مطلوب' ),
			'field_placeholder'  => array( 'en' => 'Placeholder',           'ar' => 'نص توضيحي' ),
			'field_options'      => array( 'en' => 'Options (comma separated)', 'ar' => 'الخيارات (مفصولة بفاصلة)' ),
			'add_field'          => array( 'en' => '+ Add Custom Field',    'ar' => '+ حقل مخصص' ),
			'form_fields'        => array( 'en' => 'Form Fields',           'ar' => 'حقول النموذج' ),
			'quick_add'          => array( 'en' => 'Quick Add Field',       'ar' => 'إضافة سريعة' ),
			'tpl_name'           => array( 'en' => 'Full Name',             'ar' => 'الاسم الكامل' ),
			'tpl_email'          => array( 'en' => 'Email Address',         'ar' => 'البريد الإلكتروني' ),
			'tpl_phone'          => array( 'en' => 'Phone Number',          'ar' => 'رقم الهاتف' ),
			'tpl_company'        => array( 'en' => 'Company Name',          'ar' => 'اسم الشركة' ),
			'tpl_service'        => array( 'en' => 'Service Type',          'ar' => 'نوع الخدمة' ),
			'tpl_message'        => array( 'en' => 'Message',               'ar' => 'الرسالة' ),
			'tpl_city'           => array( 'en' => 'City',                  'ar' => 'المدينة' ),

			/* ====== Contact ====== */
			'contact_info'       => array( 'en' => 'Contact Information',          'ar' => 'معلومات التواصل' ),
			'enable_contact'     => array( 'en' => 'Enable Contact',               'ar' => 'تفعيل التواصل' ),
			'show_contact_chat'  => array( 'en' => 'Show contact button in chat',  'ar' => 'إظهار زر التواصل في الشات' ),
			'phone'              => array( 'en' => 'Phone',     'ar' => 'الهاتف' ),
			'email_addr'         => array( 'en' => 'Email',     'ar' => 'البريد' ),
			'whatsapp'           => array( 'en' => 'WhatsApp',  'ar' => 'واتساب' ),
			'website_url'        => array( 'en' => 'Website',   'ar' => 'الموقع' ),

			/* ====== Design ====== */
			'color_primary'      => array( 'en' => 'Primary Color',          'ar' => 'اللون الأساسي' ),
			'color_primary_d'    => array( 'en' => 'FAB button, section headers, links, and main accents', 'ar' => 'الزر العائم، عناوين الأقسام، الروابط، والتمييز الأساسي' ),
			'color_header'       => array( 'en' => 'Header Background',      'ar' => 'خلفية الهيدر' ),
			'color_header_d'     => array( 'en' => 'Top bar background of the chat window',              'ar' => 'خلفية الشريط العلوي لنافذة الشات' ),
			'color_header_text'  => array( 'en' => 'Header Text',            'ar' => 'نص الهيدر' ),
			'color_header_text_d'=> array( 'en' => 'Title and subtitle text in the header bar',          'ar' => 'نص العنوان والعنوان الفرعي في الهيدر' ),
			'color_chat_bg'      => array( 'en' => 'Chat Background',        'ar' => 'خلفية الشات' ),
			'color_chat_bg_d'    => array( 'en' => 'Background of the messages area',                    'ar' => 'خلفية منطقة الرسائل والأسئلة' ),
			'color_button'       => array( 'en' => 'Action Buttons',         'ar' => 'أزرار الإجراءات' ),
			'color_button_d'     => array( 'en' => 'Contact and request service buttons at the bottom',  'ar' => 'أزرار التواصل وطلب الخدمة في الأسفل' ),
			'color_button_text'  => array( 'en' => 'Button Text',            'ar' => 'نص الأزرار' ),
			'color_button_text_d'=> array( 'en' => 'Text color inside action buttons',                   'ar' => 'لون النص داخل الأزرار' ),
			'color_text'         => array( 'en' => 'Text Color',             'ar' => 'لون النص' ),
			'color_text_d'       => array( 'en' => 'Questions, answers, and general body text',          'ar' => 'الأسئلة والإجابات والنصوص العامة' ),
			'color_accent'       => array( 'en' => 'Accent Color',           'ar' => 'اللون المميز' ),
			'color_accent_d'     => array( 'en' => 'Answer left border, hover highlights, and notification badge', 'ar' => 'حد الإجابة، التمييز عند المرور، ونقطة الإشعار' ),
			'chat_width'         => array( 'en' => 'Chat Width (px)',        'ar' => 'عرض الشات (px)' ),
			'chat_max_height'    => array( 'en' => 'Max Height (px)',        'ar' => 'أقصى ارتفاع (px)' ),
			'border_radius'      => array( 'en' => 'Border Radius (px)',     'ar' => 'استدارة الحواف (px)' ),
			'google_font'        => array( 'en' => 'Google Font',            'ar' => 'خط جوجل' ),
			'google_font_d'      => array( 'en' => 'Font used in the chatbot widget on front end',       'ar' => 'الخط المستخدم في الشات بوت على الواجهة' ),

			/* ====== Advanced ====== */
			'load_on_pages'      => array( 'en' => 'Load Only on Pages',     'ar' => 'صفحات محددة فقط' ),
			'load_pages_desc'    => array( 'en' => 'Comma-separated page/post IDs. Leave empty for all pages.', 'ar' => 'أرقام الصفحات مفصولة بفاصلة. اتركه فارغاً لكل الصفحات.' ),
			'quick_reply_enabled'   => array( 'en' => 'Quick Reply Buttons',    'ar' => 'أزرار الرد السريع' ),
			'quick_reply_enabled_d' => array( 'en' => 'Show related questions after each answer', 'ar' => 'عرض أسئلة مقترحة بعد كل إجابة' ),
			'copy_answer_enabled'   => array( 'en' => 'Copy Answer Button',     'ar' => 'زر نسخ الإجابة' ),
			'copy_answer_enabled_d' => array( 'en' => 'Allow visitors to copy answer text to clipboard', 'ar' => 'السماح للزوار بنسخ نص الإجابة' ),
			'print_answer_enabled'  => array( 'en' => 'Print Answer Button',    'ar' => 'زر طباعة الإجابة' ),
			'print_answer_enabled_d'=> array( 'en' => 'Allow visitors to print or save answer as PDF', 'ar' => 'السماح للزوار بطباعة الإجابة أو حفظها كـ PDF' ),
			'typing_animation'   => array( 'en' => 'Typing Animation',       'ar' => 'تأثير الكتابة' ),
			'typing_animation_d' => array( 'en' => 'Show typing animation before answers appear', 'ar' => 'إظهار تأثير الكتابة قبل ظهور الإجابات' ),
			'rating_enabled'     => array( 'en' => 'Answer Rating',          'ar' => 'تقييم الإجابات' ),
			'rating_enabled_d'   => array( 'en' => 'Let visitors rate answers with thumbs up/down', 'ar' => 'السماح للزوار بتقييم الإجابات بإعجاب/عدم إعجاب' ),
			'session_memory'     => array( 'en' => 'Session Memory',         'ar' => 'ذاكرة الجلسة' ),
			'session_memory_d'   => array( 'en' => 'Remember chat state when visitor reopens the widget', 'ar' => 'تذكر حالة الشات عند إعادة فتح النافذة' ),
			'lazy_load'          => array( 'en' => 'Lazy Load',              'ar' => 'تحميل كسول' ),
			'lazy_load_d'        => array( 'en' => 'Load chatbot assets only when visitor clicks the button', 'ar' => 'تحميل ملفات الشات فقط عند ضغط الزائر على الزر' ),
			'antispam_label'     => array( 'en' => 'Anti-Spam Protection',   'ar' => 'حماية من السبام' ),
			'honeypot_enabled'   => array( 'en' => 'Honeypot Field',         'ar' => 'حقل مصيدة' ),
			'honeypot_d'         => array( 'en' => 'Add hidden field to catch bots', 'ar' => 'إضافة حقل مخفي لكشف البوتات' ),
			'rate_limit_enabled' => array( 'en' => 'Rate Limiting',          'ar' => 'تحديد معدل الإرسال' ),
			'rate_limit_d'       => array( 'en' => 'Limit form submissions to 3 per minute per visitor', 'ar' => 'تحديد الإرسال إلى 3 طلبات في الدقيقة لكل زائر' ),
			'shortcode_label'    => array( 'en' => 'Shortcode',              'ar' => 'الشورت كود' ),
			'shortcode_desc'     => array( 'en' => 'Use [askova] shortcode to embed FAQ inline on any page.', 'ar' => 'استخدم شورت كود [askova] لعرض الأسئلة في أي صفحة.' ),

			/* ====== Form Logs ====== */
			'form_logs'          => array( 'en' => 'Form Logs',            'ar' => 'سجل الطلبات' ),
			'no_logs'            => array( 'en' => 'No submissions yet.',  'ar' => 'لا توجد طلبات بعد.' ),
			'date'               => array( 'en' => 'Date',                 'ar' => 'التاريخ' ),
			'delete'             => array( 'en' => 'Delete',               'ar' => 'حذف' ),
			'total_submissions'  => array( 'en' => 'Total Submissions',    'ar' => 'إجمالي الطلبات' ),
			'showing'            => array( 'en' => 'Showing last',         'ar' => 'عرض آخر' ),
			'entries'            => array( 'en' => 'entries',              'ar' => 'طلبات' ),
			'export_csv'         => array( 'en' => 'Export CSV',           'ar' => 'تصدير CSV' ),
		);
	}

	public static function js_strings() {
		$all  = self::strings();
		$lang = self::get_lang();
		if ( ! $lang ) $lang = 'en';
		$out = array();
		foreach ( $all as $k => $v ) {
			$out[ $k ] = isset( $v[ $lang ] ) ? $v[ $lang ] : $v['en'];
		}
		return $out;
	}
}
