<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_Assets_Loader {

	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'frontend' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin' ) );
	}

	private function should_load() {
		if ( '1' !== WPFAQCB_Settings_Manager::get( 'chat_enabled' ) ) return false;
		$pages = WPFAQCB_Settings_Manager::get( 'load_on_pages' );
		if ( ! empty( $pages ) ) {
			$ids = array_map( 'absint', array_filter( explode( ',', $pages ) ) );
			if ( ! in_array( get_queried_object_id(), $ids, true ) ) return false;
		}
		return true;
	}

	public function frontend() {
		if ( ! $this->should_load() ) return;
		$s = WPFAQCB_Settings_Manager::get_all();

		/* Auto-detect front-end language */
		$front_lang = WPFAQCB_Settings_Manager::detect_front_lang();
		$cd         = WPFAQCB_Settings_Manager::content_defaults();

		/* Auto direction */
		$direction = ( 'ar' === $front_lang ) ? 'rtl' : 'ltr';

		/* Resolve UI texts: use saved value if customized, otherwise use default for detected lang */
		foreach ( $cd as $k => $pair ) {
			$ar_default = isset( $pair['ar'] ) ? $pair['ar'] : '';
			$en_default = isset( $pair['en'] ) ? $pair['en'] : '';
			$saved_val  = isset( $s[ $k ] ) ? $s[ $k ] : '';
			/* If saved value matches either default, swap to detected lang default */
			if ( '' === $saved_val || $saved_val === $ar_default || $saved_val === $en_default ) {
				$s[ $k ] = isset( $pair[ $front_lang ] ) ? $pair[ $front_lang ] : $saved_val;
			}
		}

		/* Filter sections, helpme, and form fields by language */
		$filtered_sections = WPFAQCB_Settings_Manager::filter_by_lang( $s['faq_sections'], $front_lang );
		$filtered_helpme   = WPFAQCB_Settings_Manager::filter_by_lang( $s['helpme_options'], $front_lang );
		$filtered_fields   = WPFAQCB_Settings_Manager::filter_by_lang( $s['form_fields'], $front_lang );

		$font = sanitize_text_field( $s['google_font'] );
		if ( ! empty( $font ) ) {
			$font_url = 'https://fonts.googleapis.com/css2?family=' . rawurlencode( $font ) . ':wght@300;400;500;600;700&display=swap';
			wp_enqueue_style( 'wpfaqcb-gfont', $font_url, array(), WPFAQCB_VERSION );
		}
		wp_enqueue_style( 'wpfaqcb-front', WPFAQCB_URL . 'assets/css/chatbot.css', array(), WPFAQCB_VERSION );

		wp_enqueue_script( 'wpfaqcb-front', WPFAQCB_URL . 'assets/js/chatbot.js', array(), WPFAQCB_VERSION, true );

		/* Build welcome variations array */
		$welcome_list = array( $s['welcome_text'] );
		if ( ! empty( $s['welcome_variations'] ) ) {
			$extras = array_filter( array_map( 'trim', explode( "\n", $s['welcome_variations'] ) ) );
			if ( ! empty( $extras ) ) {
				$welcome_list = array_merge( $welcome_list, $extras );
			}
		}

		wp_localize_script( 'wpfaqcb-front', 'wpfaqcbData', array(
			'ajaxurl'  => admin_url( 'admin-ajax.php' ),
			'nonce'    => wp_create_nonce( 'wpfaqcb_form_nonce' ),
			'cfg'      => array(
				'position'          => $s['chat_position'],
				'direction'         => $direction,
				'frontLang'         => $front_lang,
				'popupEnabled'      => $s['popup_enabled'],
				'popupDelay'        => absint( $s['popup_delay'] ),
				'popupDuration'     => absint( $s['popup_duration'] ),
				'headerTitle'       => $s['header_title'],
				'headerSubtitle'    => $s['header_subtitle'],
				'welcomeTitle'      => $s['welcome_title'],
				'welcomeText'       => $s['welcome_text'],
				'welcomeVariations' => $welcome_list,
				'popupText'         => $s['popup_text'],
				'inputPlaceholder'  => $s['input_placeholder'],
				'backMainLabel'     => $s['back_main_label'],
				'backSectionLabel'  => $s['back_section_label'],
				'answerLabel'       => $s['answer_label'],
				'contactBtnLabel'   => $s['contact_btn_label'],
				'requestBtnLabel'   => $s['request_btn_label'],
				'contactEnabled'    => $s['contact_enabled'],
				'contactPhone'      => $s['contact_phone'],
				'contactEmail'      => $s['contact_email'],
				'contactWhatsapp'   => $s['contact_whatsapp'],
				'contactWebsite'    => $s['contact_website'],
				'formEnabled'       => $s['form_enabled'],
				'formTitle'         => $s['form_title'],
				'formSubtitle'      => $s['form_subtitle'],
				'formSubmitLabel'   => $s['form_submit_label'],
				'formSuccessMsg'    => $s['form_success_msg'],
				'helpmeEnabled'     => $s['helpme_enabled'],
				'helpmeTitle'       => $s['helpme_title'],
				'helpmeQuestion'    => $s['helpme_question'],
				/* v2 config */
				'typingAnimation'   => $s['typing_animation'],
				'ratingEnabled'     => $s['rating_enabled'],
				'ratingQuestion'    => $s['rating_question'],
				'ratingThanks'      => $s['rating_thanks'],
				'sessionMemory'     => $s['session_memory'],
				'honeypotEnabled'   => $s['antispam_honeypot'],
				'quickReplyEnabled' => $s['quick_reply_enabled'],
				'quickReplyLabel'   => $s['quick_reply_label'],
				'copyAnswerEnabled' => $s['copy_answer_enabled'],
				'printAnswerEnabled'=> $s['print_answer_enabled'],
				'copySuccess'       => $s['copy_success'],
			),
			'sections'      => $filtered_sections,
			'helpmeOptions' => $filtered_helpme,
			'formFields'    => $filtered_fields,
		) );

		/* Override direction in dynamic CSS */
		$s['chat_direction'] = $direction;
		wp_add_inline_style( 'wpfaqcb-front', self::dynamic_css( $s ) );
	}

	public function admin( $hook ) {
		if ( false === strpos( $hook, 'askova' ) ) return;
		wp_enqueue_media();
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style( 'wpfaqcb-admin-font', 'https://fonts.googleapis.com/css2?family=Almarai:wght@300;400;700;800&display=swap', array(), WPFAQCB_VERSION );
		wp_enqueue_style( 'wpfaqcb-admin', WPFAQCB_URL . 'assets/css/admin.css', array( 'wp-color-picker' ), WPFAQCB_VERSION );
		wp_enqueue_script( 'wpfaqcb-sortable', WPFAQCB_URL . 'assets/js/Sortable.min.js', array(), '1.15.3', true );
		wp_enqueue_script( 'wpfaqcb-admin', WPFAQCB_URL . 'assets/js/admin.js', array( 'wp-color-picker', 'wpfaqcb-sortable' ), WPFAQCB_VERSION, true );
		wp_localize_script( 'wpfaqcb-admin', 'wpfaqcbAdmin', array(
			'nonce'    => wp_create_nonce( 'wpfaqcb_save_settings' ),
			'ajaxurl'  => admin_url( 'admin-ajax.php' ),
			'i18n'     => WPFAQCB_I18n::js_strings(),
			'lang'     => WPFAQCB_I18n::get_lang(),
			'sections' => array_map( function( $sec ) { return $sec['title']; }, WPFAQCB_Settings_Manager::get( 'faq_sections', array() ) ),
		) );
	}

	private static function dynamic_css( $s ) {
		$pos  = 'right' === $s['chat_position'] ? 'right' : 'left';
		$font = sanitize_text_field( $s['google_font'] );
		$ff   = ! empty( $font ) ? "'" . $font . "', " : '';
		$css  = ':root{';
		$css .= '--wpfaqcb-primary:' . esc_attr( $s['color_primary'] ) . ';';
		$css .= '--wpfaqcb-header:' . esc_attr( $s['color_header'] ) . ';';
		$css .= '--wpfaqcb-header-text:' . esc_attr( $s['color_header_text'] ) . ';';
		$css .= '--wpfaqcb-bg:' . esc_attr( $s['color_chat_bg'] ) . ';';
		$css .= '--wpfaqcb-btn:' . esc_attr( $s['color_button'] ) . ';';
		$css .= '--wpfaqcb-btn-text:' . esc_attr( $s['color_button_text'] ) . ';';
		$css .= '--wpfaqcb-text:' . esc_attr( $s['color_text'] ) . ';';
		$css .= '--wpfaqcb-accent:' . esc_attr( $s['color_accent'] ) . ';';
		$css .= '--wpfaqcb-width:' . absint( $s['chat_width'] ) . 'px;';
		$css .= '--wpfaqcb-maxh:' . absint( $s['chat_max_height'] ) . 'px;';
		$css .= '--wpfaqcb-radius:' . absint( $s['border_radius'] ) . 'px;';
		$css .= '--wpfaqcb-font:' . $ff . 'sans-serif;';
		$css .= '}';
		$css .= '.wpfaqcb-fab{' . $pos . ':28px;}.wpfaqcb-popup{' . $pos . ':28px;}.wpfaqcb-container{' . $pos . ':28px;}';
		return $css;
	}
}
