(function(){
'use strict';
if(typeof wpfaqcbData==='undefined')return;
var c=wpfaqcbData.cfg,sections=wpfaqcbData.sections||[],hmOpts=wpfaqcbData.helpmeOptions||[],fields=wpfaqcbData.formFields||[];
var fab=document.querySelector('.wpfaqcb-fab'),popup=document.querySelector('.wpfaqcb-popup'),box=document.querySelector('.wpfaqcb-container'),body=document.querySelector('.wpfaqcb-body'),closeBtn=document.querySelector('.wpfaqcb-close'),sendBtn=document.querySelector('.wpfaqcb-send'),inp=document.querySelector('.wpfaqcb-input input'),popClose=document.querySelector('.wpfaqcb-popup-close');
if(!fab||!box||!body)return;
var open=false,curSec=null,curSub=null,curQs=null,curSecTitle='';

/* === SESSION MEMORY === */
var memoryKey='wpfaqcb_session';
function saveSession(){
	if(c.sessionMemory!=='1')return;
	try{localStorage.setItem(memoryKey,JSON.stringify({curSec:curSec,curSub:curSub,open:open}));}catch(e){}
}
function loadSession(){
	if(c.sessionMemory!=='1')return null;
	try{return JSON.parse(localStorage.getItem(memoryKey));}catch(e){return null;}
}
function clearSession(){try{localStorage.removeItem(memoryKey);}catch(e){}}

/* === WELCOME VARIATIONS === */
function getWelcomeText(){
	var v=c.welcomeVariations;
	if(v&&v.length>1){return v[Math.floor(Math.random()*v.length)];}
	return c.welcomeText;
}

/* === POPUP === */
var popupDismissed=false;
if(c.popupEnabled==='1'&&popup){
	setTimeout(function(){if(!popupDismissed)popup.classList.add('wpfaqcb-show');},c.popupDelay*1000);
	setTimeout(function(){popup.classList.remove('wpfaqcb-show');},(c.popupDelay+c.popupDuration)*1000);
}
function hidePopup(){if(popup){popup.classList.remove('wpfaqcb-show');popup.style.display='none';popupDismissed=true;}}
if(popClose)popClose.addEventListener('click',function(e){e.stopPropagation();hidePopup();});
if(popup)popup.addEventListener('click',function(){hidePopup();if(!open)toggle();});
fab.addEventListener('click',function(){hidePopup();toggle();});
closeBtn.addEventListener('click',function(){box.classList.remove('wpfaqcb-open');box.setAttribute('aria-hidden','true');open=false;saveSession();});

function toggle(){
	open=!open;
	if(open){
		box.classList.add('wpfaqcb-open');box.setAttribute('aria-hidden','false');
		var sess=loadSession();
		if(sess&&sess.curSec!==null&&sections[sess.curSec]){
			curSec=sess.curSec;
			if(sess.curSub!==null)showSubSection(sess.curSub);
			else showSection(sess.curSec);
		}else{showMain();}
	}else{
		box.classList.remove('wpfaqcb-open');box.setAttribute('aria-hidden','true');
	}
	saveSession();
}

function icon(sec){
	if(!sec||!sec.icon_url)return '';
	return '<img src="'+esc(sec.icon_url)+'" class="wpfaqcb-menu-img" alt="" /> ';
}

/* === MAIN MENU === */
function showMain(){
	curSec=null;curSub=null;curQs=null;curSecTitle='';
	var wText=getWelcomeText();
	var h='<div class="wpfaqcb-welcome"><h3>'+esc(c.welcomeTitle)+'</h3><p>'+nl2br(esc(wText))+'</p></div>';
	h+='<div class="wpfaqcb-menu">';
	for(var i=0;i<sections.length;i++){
		h+='<div class="wpfaqcb-menu-item" data-section="'+i+'"><span class="wpfaqcb-menu-num">'+(i+1)+'</span>'+icon(sections[i])+'<span class="wpfaqcb-menu-text">'+esc(sections[i].title)+'</span><span class="wpfaqcb-menu-arrow">&lsaquo;</span></div>';
	}
	if(c.helpmeEnabled==='1'&&hmOpts.length>0){
		h+='<div class="wpfaqcb-menu-item wpfaqcb-helpme-item" data-action="helpme"><span class="wpfaqcb-menu-num">?</span><span class="wpfaqcb-menu-text">'+esc(c.helpmeTitle)+'</span><span class="wpfaqcb-menu-arrow">&lsaquo;</span></div>';
	}
	h+='</div>';
	h+=actionBtns();
	body.innerHTML=h;sb();
	saveSession();
}

function actionBtns(){
	var h='<div class="wpfaqcb-actions">';
	if(c.contactEnabled==='1')h+='<button class="wpfaqcb-action-btn wpfaqcb-accent-btn" data-action="contact">'+esc(c.contactBtnLabel)+'</button>';
	if(c.formEnabled==='1')h+='<button class="wpfaqcb-action-btn wpfaqcb-primary-btn" data-action="form">'+esc(c.requestBtnLabel)+'</button>';
	h+='</div>';return h;
}

function showSection(idx){
	var s=sections[idx];if(!s)return;curSec=idx;curSub=null;curSecTitle=s.title;
	if(s.has_subs==='1'&&s.subs&&s.subs.length>0){showSubMenu(s);return;}
	curQs=s.items||[];renderQs(s.title,s,curQs);
	saveSession();
}

function showSubMenu(s){
	curQs=null;
	var h=backBtn('main');
	h+='<div class="wpfaqcb-section-hdr"><h3>'+icon(s)+esc(s.title)+'</h3>'+(s.sub_label?'<p>'+esc(s.sub_label)+'</p>':'')+'</div>';
	for(var i=0;i<s.subs.length;i++){
		h+='<div class="wpfaqcb-menu-item" data-sub="'+i+'"><span class="wpfaqcb-menu-num">'+(i+1)+'</span>'+icon(s.subs[i])+'<span class="wpfaqcb-menu-text">'+esc(s.subs[i].title)+'</span><span class="wpfaqcb-menu-arrow">&lsaquo;</span></div>';
	}
	h+=actionBtns();body.innerHTML=h;sb();
	saveSession();
}

function showSubSection(subIdx){
	var s=sections[curSec];if(!s||!s.subs||!s.subs[subIdx])return;
	curSub=subIdx;curQs=s.subs[subIdx].items||[];curSecTitle=s.title;
	var sub=s.subs[subIdx];
	var h=backBtn('main')+backBtn('section');
	h+='<div class="wpfaqcb-section-hdr"><h3>'+icon(sub)+esc(sub.title)+'</h3></div>';
	for(var i=0;i<curQs.length;i++){h+=qCard(i,curQs[i]);}
	h+=actionBtns();body.innerHTML=h;sb();
	saveSession();
}

function renderQs(title,sec,qs){
	var h=backBtn('main');
	h+='<div class="wpfaqcb-section-hdr"><h3>'+icon(sec)+esc(title)+'</h3></div>';
	for(var i=0;i<qs.length;i++){h+=qCard(i,qs[i]);}
	h+=actionBtns();body.innerHTML=h;sb();
}

function qCard(i,q){return '<div class="wpfaqcb-q-card" data-qi="'+i+'"><span class="wpfaqcb-q-num">'+(i+1)+'</span><span class="wpfaqcb-q-text">'+esc(q.question)+'</span></div>';}
function backBtn(type){
	if(type==='main')return '<button class="wpfaqcb-back" data-action="main">'+esc(c.backMainLabel)+'</button>';
	return '<button class="wpfaqcb-back" data-action="backsection">'+esc(c.backSectionLabel)+'</button>';
}

/* === ANSWER HTML with Rich Text + Rating + Copy + Quick Reply === */
function answerBlock(answerText,secTitle,questionText,qIdx){
	var h='<div class="wpfaqcb-answer"><h4>'+esc(c.answerLabel);
	/* Copy button */
	if(c.copyAnswerEnabled==='1'){
		h+=' <button class="wpfaqcb-copy-btn" data-copy-target="1" title="📋">📋</button>';
	}
	/* Print button */
	if(c.printAnswerEnabled==='1'){
		h+=' <button class="wpfaqcb-print-btn" title="🖨️">🖨️</button>';
	}
	h+='</h4><div class="wpfaqcb-answer-body" data-copy-src="1">'+renderRichText(answerText)+'</div>';
	/* Rating */
	if(c.ratingEnabled==='1'){
		h+='<div class="wpfaqcb-rating" data-sec="'+esc(secTitle)+'" data-q="'+esc(questionText)+'">';
		h+='<span class="wpfaqcb-rating-label">'+esc(c.ratingQuestion)+'</span>';
		h+='<button class="wpfaqcb-rate-btn" data-rate="1" title="👍">👍</button>';
		h+='<button class="wpfaqcb-rate-btn" data-rate="-1" title="👎">👎</button>';
		h+='</div>';
	}
	h+='</div>';
	/* Quick Reply Buttons */
	if(c.quickReplyEnabled==='1'&&curQs&&curQs.length>1){
		var others=[];
		for(var i=0;i<curQs.length;i++){
			if(i!==qIdx)others.push(i);
		}
		if(others.length>0){
			/* Show max 3 quick replies */
			var show=others.slice(0,3);
			h+='<div class="wpfaqcb-quick-reply"><span class="wpfaqcb-qr-label">'+esc(c.quickReplyLabel)+'</span><div class="wpfaqcb-qr-btns">';
			for(var j=0;j<show.length;j++){
				h+='<button class="wpfaqcb-qr-btn" data-qi="'+show[j]+'">'+esc(curQs[show[j]].question)+'</button>';
			}
			h+='</div></div>';
		}
	}
	return h;
}

function renderRichText(text){
	if(/<[a-z][\s\S]*>/i.test(text)){return text;}
	return '<p>'+nl2br(esc(text))+'</p>';
}

/* === COPY ANSWER === */
function copyAnswer(btn){
	var answer=btn.closest('.wpfaqcb-answer');
	if(!answer)return;
	var src=answer.querySelector('.wpfaqcb-answer-body');
	if(!src)return;
	var text=src.innerText||src.textContent;
	if(navigator.clipboard&&navigator.clipboard.writeText){
		navigator.clipboard.writeText(text).then(function(){showCopyFeedback(btn);});
	}else{
		/* Fallback */
		var ta=document.createElement('textarea');
		ta.value=text;ta.style.position='fixed';ta.style.opacity='0';
		document.body.appendChild(ta);ta.select();
		try{document.execCommand('copy');showCopyFeedback(btn);}catch(e){}
		document.body.removeChild(ta);
	}
}
function showCopyFeedback(btn){
	var orig=btn.innerHTML;
	btn.innerHTML='✓';btn.classList.add('wpfaqcb-copied');
	setTimeout(function(){btn.innerHTML=orig;btn.classList.remove('wpfaqcb-copied');},1500);
	/* Show toast */
	var toast=document.createElement('div');toast.className='wpfaqcb-toast';toast.textContent=c.copySuccess;
	body.appendChild(toast);
	setTimeout(function(){toast.classList.add('wpfaqcb-toast-show');},10);
	setTimeout(function(){toast.classList.remove('wpfaqcb-toast-show');setTimeout(function(){if(toast.parentNode)toast.parentNode.removeChild(toast);},300);},1800);
}

/* === PRINT ANSWER === */
function printAnswer(btn){
	var answer=btn.closest('.wpfaqcb-answer');
	if(!answer)return;
	var src=answer.querySelector('.wpfaqcb-answer-body');
	if(!src)return;
	var title=answer.querySelector('h4');
	var dir=c.direction||'rtl';
	var font=c.fontFamily||'sans-serif';
	var w=window.open('','_blank','width=600,height=500');
	if(!w)return;
	w.document.write('<!DOCTYPE html><html dir="'+dir+'"><head><meta charset="utf-8"><title>Askova</title><style>body{font-family:'+font+';padding:30px 40px;color:#2c3e50;line-height:1.8;max-width:700px;margin:0 auto;}h2{color:#1a5276;border-bottom:2px solid #c9942e;padding-bottom:8px;margin-bottom:16px;font-size:18px;}.content{font-size:15px;}.footer{margin-top:30px;padding-top:10px;border-top:1px solid #e5e8eb;color:#999;font-size:12px;text-align:center;}@media print{.no-print{display:none;}}</style></head><body>');
	if(title)w.document.write('<h2>'+title.innerHTML.replace(/<button[^>]*>.*?<\/button>/g,'')+'</h2>');
	w.document.write('<div class="content">'+src.innerHTML+'</div>');
	w.document.write('<div class="footer">Powered by Askova – Smart FAQ Chat</div>');
	w.document.write('<script>setTimeout(function(){window.print();},300);<\/script></body></html>');
	w.document.close();
}

/* Help Me */
function showHelpMe(){
	curSec=null;curSub=null;curQs=null;
	var h=backBtn('main')+'<div class="wpfaqcb-section-hdr"><h3>'+esc(c.helpmeTitle)+'</h3><p>'+esc(c.helpmeQuestion)+'</p></div>';
	for(var i=0;i<hmOpts.length;i++){
		h+='<div class="wpfaqcb-menu-item" data-hm="'+i+'"><span class="wpfaqcb-menu-num">'+(i+1)+'</span><span class="wpfaqcb-menu-text">'+esc(hmOpts[i].text)+'</span><span class="wpfaqcb-menu-arrow">&lsaquo;</span></div>';
	}
	body.innerHTML=h;sb();
}

function showHmResult(idx){
	var o=hmOpts[idx];if(!o)return;
	if(o.section_id>0&&o.section_id<=sections.length){showSection(o.section_id-1);return;}
	var h=backBtn('main')+'<div class="wpfaqcb-answer"><h4>✓ '+esc(o.suggest)+'</h4><div class="wpfaqcb-answer-body"><p>'+esc(o.suggest)+'</p></div></div>';
	h+=actionBtns();body.innerHTML=h;sb();
}

/* Contact */
function showContact(){
	var h=backBtn('main')+'<div class="wpfaqcb-answer"><h4>📞 '+esc(c.contactBtnLabel)+'</h4><div class="wpfaqcb-answer-body">';
	if(c.contactPhone)h+='<p>📱 <a href="tel:'+esc(c.contactPhone)+'" dir="ltr">'+esc(c.contactPhone)+'</a></p>';
	if(c.contactEmail)h+='<p>✉️ <a href="mailto:'+esc(c.contactEmail)+'">'+esc(c.contactEmail)+'</a></p>';
	if(c.contactWhatsapp){var wa=c.contactWhatsapp.replace(/[^0-9+]/g,'');h+='<p>💬 <a href="https://wa.me/'+esc(wa.replace('+',''))+'" target="_blank" rel="noopener" dir="ltr">'+esc(c.contactWhatsapp)+'</a></p>';}
	if(c.contactWebsite)h+='<p>🌐 <a href="'+esc(c.contactWebsite)+'" target="_blank" rel="noopener">'+esc(c.contactWebsite)+'</a></p>';
	h+='</div></div>';h+=actionBtns();body.innerHTML=h;sb();
}

/* === FORM with new field types + honeypot === */
function showForm(){
	var h=backBtn('main')+'<div class="wpfaqcb-form-header"><h3>'+esc(c.formTitle)+'</h3><p>'+esc(c.formSubtitle)+'</p></div><div class="wpfaqcb-form-wrap">';
	if(c.honeypotEnabled==='1'){
		h+='<div style="position:absolute;left:-9999px;top:-9999px;opacity:0;height:0;overflow:hidden;" aria-hidden="true"><input type="text" name="wpfaqcb_website_url" class="wpfaqcb-honey" tabindex="-1" autocomplete="off" /></div>';
	}
	for(var i=0;i<fields.length;i++){
		var f=fields[i];
		h+='<div class="wpfaqcb-form-group"><label>'+esc(f.label)+(f.required==='1'?' *':'')+'</label>';
		if(f.type==='textarea'){
			h+='<textarea data-fi="'+i+'" placeholder="'+esc(f.placeholder)+'"></textarea>';
		}else if(f.type==='select'){
			h+='<select data-fi="'+i+'"><option value="">'+esc(f.placeholder||'...')+'</option>';
			if(f.options){f.options.split(',').forEach(function(o){o=o.trim();h+='<option value="'+esc(o)+'">'+esc(o)+'</option>';});}
			h+='</select>';
		}else if(f.type==='checkbox'){
			h+='<div class="wpfaqcb-checkbox-group" data-fi="'+i+'">';
			if(f.options){f.options.split(',').forEach(function(o){o=o.trim();h+='<label class="wpfaqcb-check-label"><input type="checkbox" value="'+esc(o)+'" /> '+esc(o)+'</label>';});}
			h+='</div>';
		}else if(f.type==='radio'){
			h+='<div class="wpfaqcb-radio-group" data-fi="'+i+'">';
			if(f.options){f.options.split(',').forEach(function(o){o=o.trim();h+='<label class="wpfaqcb-radio-label"><input type="radio" name="wpfaqcb_radio_'+i+'" value="'+esc(o)+'" /> '+esc(o)+'</label>';});}
			h+='</div>';
		}else if(f.type==='date'){
			h+='<input type="date" data-fi="'+i+'" placeholder="'+esc(f.placeholder)+'" />';
		}else{
			h+='<input type="'+esc(f.type)+'" data-fi="'+i+'" placeholder="'+esc(f.placeholder)+'" />';
		}
		h+='</div>';
	}
	h+='<button class="wpfaqcb-form-submit" data-action="submitform">'+esc(c.formSubmitLabel)+'</button></div>';
	body.innerHTML=h;sb();
}

function submitForm(){
	var data=[],valid=true;
	if(c.honeypotEnabled==='1'){
		var honey=body.querySelector('.wpfaqcb-honey');
		if(honey&&honey.value){
			body.innerHTML='<div class="wpfaqcb-answer"><h4>✓</h4><div class="wpfaqcb-answer-body"><p>'+esc(c.formSuccessMsg)+'</p></div></div>';
			return;
		}
	}
	for(var i=0;i<fields.length;i++){
		var f=fields[i],val='';
		if(f.type==='checkbox'){
			var grp=body.querySelector('[data-fi="'+i+'"]');
			if(grp){var checked=[];grp.querySelectorAll('input:checked').forEach(function(cb){checked.push(cb.value);});val=checked.join(', ');}
		}else if(f.type==='radio'){
			var grp=body.querySelector('[data-fi="'+i+'"]');
			if(grp){var sel=grp.querySelector('input:checked');val=sel?sel.value:'';}
		}else{
			var el=body.querySelector('[data-fi="'+i+'"]');
			val=el?el.value.trim():'';
		}
		if(f.required==='1'&&!val){
			valid=false;
			var el=body.querySelector('[data-fi="'+i+'"]');
			if(el)el.style.borderColor='#dc3232';
		}
		data.push({label:f.label,value:val});
	}
	if(!valid)return;
	var fd=new FormData();
	fd.append('action','wpfaqcb_submit_form');
	fd.append('nonce',wpfaqcbData.nonce);
	fd.append('fields',JSON.stringify(data));
	var honey=body.querySelector('.wpfaqcb-honey');
	if(honey)fd.append('wpfaqcb_website_url',honey.value);

	fetch(wpfaqcbData.ajaxurl,{method:'POST',credentials:'same-origin',body:fd}).then(function(r){return r.json();}).then(function(res){
		if(res.success){
			body.innerHTML='<div class="wpfaqcb-answer"><h4>✓</h4><div class="wpfaqcb-answer-body"><p>'+esc(res.data)+'</p></div></div><div class="wpfaqcb-actions"><button class="wpfaqcb-action-btn wpfaqcb-primary-btn" data-action="main" style="width:100%">'+esc(c.backMainLabel)+'</button></div>';
		}else{
			var err=body.querySelector('.wpfaqcb-form-error');
			if(!err){err=document.createElement('div');err.className='wpfaqcb-form-error';var sub=body.querySelector('.wpfaqcb-form-submit');if(sub)sub.parentNode.insertBefore(err,sub);}
			err.textContent=res.data||'Error';
		}
	});
}

/* === TYPING ANIMATION + ANSWER DISPLAY === */
function showAnswerWithTyping(qi){
	if(!curQs||!curQs[qi])return;
	var card=body.querySelector('.wpfaqcb-q-card[data-qi="'+qi+'"]');if(!card)return;
	/* Remove existing answer/typing/quick-reply */
	var next=card.nextElementSibling;
	while(next&&(next.classList.contains('wpfaqcb-answer')||next.classList.contains('wpfaqcb-typing')||next.classList.contains('wpfaqcb-quick-reply'))){
		var rem=next;next=next.nextElementSibling;rem.remove();
	}
	/* Check if toggling off (click same question again) */
	if(card.classList.contains('wpfaqcb-q-card-active')){
		card.classList.remove('wpfaqcb-q-card-active');
		return;
	}
	/* Remove other active states */
	body.querySelectorAll('.wpfaqcb-q-card-active').forEach(function(c){c.classList.remove('wpfaqcb-q-card-active');});
	body.querySelectorAll('.wpfaqcb-answer,.wpfaqcb-typing,.wpfaqcb-quick-reply').forEach(function(a){a.remove();});
	card.classList.add('wpfaqcb-q-card-active');

	var ansHtml=answerBlock(curQs[qi].answer,curSecTitle,curQs[qi].question,qi);

	if(c.typingAnimation==='1'){
		var typing=document.createElement('div');typing.className='wpfaqcb-typing';
		typing.innerHTML='<span class="wpfaqcb-dot"></span><span class="wpfaqcb-dot"></span><span class="wpfaqcb-dot"></span>';
		card.parentNode.insertBefore(typing,card.nextSibling);
		setTimeout(function(){
			typing.remove();
			card.insertAdjacentHTML('afterend',ansHtml);
			setTimeout(sb,50);
		},800);
	}else{
		card.insertAdjacentHTML('afterend',ansHtml);
		setTimeout(sb,50);
	}
}

/* === RATING HANDLER === */
function submitRating(btn){
	var wrap=btn.closest('.wpfaqcb-rating');if(!wrap)return;
	var rate=parseInt(btn.dataset.rate);
	var sec=wrap.dataset.sec||'';
	var q=wrap.dataset.q||'';
	var fd=new FormData();
	fd.append('action','wpfaqcb_submit_rating');
	fd.append('nonce',wpfaqcbData.nonce);
	fd.append('section',sec);
	fd.append('question',q);
	fd.append('rating',rate);
	fetch(wpfaqcbData.ajaxurl,{method:'POST',credentials:'same-origin',body:fd});
	wrap.innerHTML='<span class="wpfaqcb-rating-thanks">'+esc(c.ratingThanks)+'</span>';
}

/* === EVENT DELEGATION === */
body.addEventListener('click',function(e){
	var t;
	if((t=e.target.closest('[data-section]'))){showSection(parseInt(t.dataset.section));return;}
	if((t=e.target.closest('[data-sub]'))){showSubSection(parseInt(t.dataset.sub));return;}
	if((t=e.target.closest('.wpfaqcb-q-card[data-qi]'))){showAnswerWithTyping(parseInt(t.dataset.qi));return;}
	if((t=e.target.closest('.wpfaqcb-qr-btn'))){showAnswerWithTyping(parseInt(t.dataset.qi));return;}
	if((t=e.target.closest('[data-hm]'))){showHmResult(parseInt(t.dataset.hm));return;}
	if((t=e.target.closest('.wpfaqcb-rate-btn'))){submitRating(t);return;}
	if((t=e.target.closest('.wpfaqcb-copy-btn'))){copyAnswer(t);return;}
	if((t=e.target.closest('.wpfaqcb-print-btn'))){printAnswer(t);return;}
	if((t=e.target.closest('[data-action]'))){
		var a=t.dataset.action;
		if(a==='main'){showMain();}
		else if(a==='contact')showContact();
		else if(a==='helpme')showHelpMe();
		else if(a==='form')showForm();
		else if(a==='submitform')submitForm();
		else if(a==='backsection'){var s=sections[curSec];if(s&&s.has_subs==='1')showSubMenu(s);else showMain();}
	}
});

function handleInput(){
	var v=inp.value.trim();if(!v)return;inp.value='';
	v=v.replace(/[\u0660-\u0669]/g,function(d){return d.charCodeAt(0)-1632;}).replace(/[\u06F0-\u06F9]/g,function(d){return d.charCodeAt(0)-1776;});
	var n=parseInt(v,10);
	if(isNaN(n))return;
	if(n===0){showMain();return;}
	if(curSec===null){if(n>=1&&n<=sections.length)showSection(n-1);}
	else if(curQs){if(n>=1&&n<=curQs.length)showAnswerWithTyping(n-1);}
}
sendBtn.addEventListener('click',handleInput);
inp.addEventListener('keypress',function(e){if(e.key==='Enter')handleInput();});

function sb(){body.scrollTop=body.scrollHeight;}
function esc(s){if(!s)return '';var e=document.createElement('span');e.textContent=s;return e.innerHTML;}
function nl2br(s){return s.replace(/\n/g,'<br>');}

window.addEventListener('beforeunload',function(){if(!open)clearSession();});
})();
