(function(){
'use strict';
if(typeof wpfaqcbAdmin==='undefined')return;
var i=wpfaqcbAdmin.i18n,lang=wpfaqcbAdmin.lang;
var secTitles=wpfaqcbAdmin.sections||[];

/* SVG icons */
var dragSVG='<svg width="16" height="16" viewBox="0 0 16 16" fill="#bbb"><circle cx="5" cy="3" r="1.5"/><circle cx="11" cy="3" r="1.5"/><circle cx="5" cy="8" r="1.5"/><circle cx="11" cy="8" r="1.5"/><circle cx="5" cy="13" r="1.5"/><circle cx="11" cy="13" r="1.5"/></svg>';
var chevSVG='<svg width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M5 8l5 5 5-5" stroke="#555" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>';
var chevUpSVG='<svg width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M5 12l5-5 5 5" stroke="#555" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>';
function langSelect(cls,sel){return '<select class="'+cls+'"><option value="all"'+(sel==='all'?' selected':'')+'>'+esc(i.lang_all||'All Languages')+'</option><option value="ar"'+(sel==='ar'?' selected':'')+'>العربية</option><option value="en"'+(sel==='en'?' selected':'')+'>English</option></select>';}

function sectionOptions(selected){
	var h='<option value="0">'+esc(i.select_section||'-- Select --')+'</option>';
	var titles=[];
	document.querySelectorAll('#wpfaqcb-faq-sections > .wpfaqcb-sec-block .sec-title').forEach(function(el){titles.push(el.value||'');});
	if(titles.length===0)titles=secTitles;
	titles.forEach(function(t,idx){h+='<option value="'+(idx+1)+'"'+((selected==idx+1)?' selected':'')+'>'+esc((idx+1)+'. '+(t||'...'))+' </option>';});
	return h;
}

/* Field Templates - Arabic */
var tplsAr=[
	{label:'الاسم الكامل',type:'text',required:'1',placeholder:'أدخل اسمك الكامل',lang:'ar'},
	{label:'البريد الإلكتروني',type:'email',required:'1',placeholder:'أدخل بريدك الإلكتروني',lang:'ar'},
	{label:'رقم الهاتف',type:'tel',required:'1',placeholder:'أدخل رقم هاتفك',lang:'ar'},
	{label:'اسم الشركة',type:'text',required:'0',placeholder:'اسم الشركة (اختياري)',lang:'ar'},
	{label:'نوع الخدمة',type:'select',required:'1',placeholder:'اختر الخدمة',options:'',lang:'ar'},
	{label:'الرسالة',type:'textarea',required:'0',placeholder:'اكتب رسالتك هنا',lang:'ar'},
	{label:'المدينة',type:'text',required:'0',placeholder:'المدينة',lang:'ar'},
];
/* Field Templates - English */
var tplsEn=[
	{label:'Full Name',type:'text',required:'1',placeholder:'Enter your full name',lang:'en'},
	{label:'Email Address',type:'email',required:'1',placeholder:'Enter your email',lang:'en'},
	{label:'Phone Number',type:'tel',required:'1',placeholder:'Enter your phone number',lang:'en'},
	{label:'Company Name',type:'text',required:'0',placeholder:'Company name (optional)',lang:'en'},
	{label:'Service Type',type:'select',required:'1',placeholder:'Select service',options:'',lang:'en'},
	{label:'Message',type:'textarea',required:'0',placeholder:'Write your message here',lang:'en'},
	{label:'City',type:'text',required:'0',placeholder:'City',lang:'en'},
];
var icons=['👤','📧','📱','🏢','📋','💬','📍'];
var tplGrid=document.getElementById('wpfaqcb-field-tpls');
if(tplGrid){
	/* Arabic header */
	var arH=document.createElement('div');arH.className='wpfaqcb-tpl-section-label';arH.textContent='🇸🇦 حقول عربية';tplGrid.appendChild(arH);
	tplsAr.forEach(function(t,idx){var b=document.createElement('button');b.type='button';b.className='wpfaqcb-tpl-btn';b.setAttribute('dir','rtl');b.innerHTML='<span class="wpfaqcb-tpl-icon">'+(icons[idx]||'📋')+'</span><span>'+esc(t.label)+'</span>';b.addEventListener('click',function(){addFieldRow(t);});tplGrid.appendChild(b);});
	/* English header */
	var enH=document.createElement('div');enH.className='wpfaqcb-tpl-section-label';enH.textContent='🇬🇧 English Fields';tplGrid.appendChild(enH);
	tplsEn.forEach(function(t,idx){var b=document.createElement('button');b.type='button';b.className='wpfaqcb-tpl-btn';b.setAttribute('dir','ltr');b.innerHTML='<span class="wpfaqcb-tpl-icon">'+(icons[idx]||'📋')+'</span><span>'+esc(t.label)+'</span>';b.addEventListener('click',function(){addFieldRow(t);});tplGrid.appendChild(b);});
}

/* Tabs */
document.querySelectorAll('.wpfaqcb-tab-btn').forEach(function(b){b.addEventListener('click',function(){document.querySelectorAll('.wpfaqcb-tab-btn').forEach(function(x){x.classList.remove('active');});document.querySelectorAll('.wpfaqcb-panel').forEach(function(x){x.classList.remove('active');});b.classList.add('active');var p=document.querySelector('[data-panel="'+b.dataset.tab+'"]');if(p)p.classList.add('active');if(b.dataset.tab==='helpme')refreshHM();});});

function refreshHM(){document.querySelectorAll('#wpfaqcb-helpme-options .hm-section').forEach(function(sel){var cur=sel.value;sel.innerHTML=sectionOptions(cur);});}

/* Color Picker */
if(typeof jQuery!=='undefined'&&jQuery.fn.wpColorPicker){jQuery('.wpfaqcb-color').wpColorPicker();}

/* Language Switch */
document.querySelectorAll('.wpfaqcb-lang-switch button').forEach(function(b){b.addEventListener('click',function(){var fd=new FormData();fd.append('action','wpfaqcb_switch_lang');fd.append('nonce',wpfaqcbAdmin.nonce);fd.append('lang',b.dataset.lang);fetch(wpfaqcbAdmin.ajaxurl,{method:'POST',credentials:'same-origin',body:fd}).then(function(){location.reload();});});});

/* Sortable */
function initSort(){['#wpfaqcb-faq-sections','#wpfaqcb-helpme-options','#wpfaqcb-form-fields'].forEach(function(sel){var el=document.querySelector(sel);if(el&&typeof Sortable!=='undefined')Sortable.create(el,{handle:'.wpfaqcb-drag',animation:200});});document.querySelectorAll('.wpfaqcb-items-list,.wpfaqcb-subs-list').forEach(function(el){if(typeof Sortable!=='undefined')Sortable.create(el,{handle:'.wpfaqcb-drag',animation:200});});}
initSort();

/* Chevron Toggle */
document.addEventListener('click',function(e){
	var chev=e.target.closest('.wpfaqcb-chevron');
	if(chev){var block=chev.closest('.wpfaqcb-sec-block,.wpfaqcb-sub-block');if(!block)return;var bd=block.querySelector('.wpfaqcb-sec-body')||block.querySelector('.wpfaqcb-sub-body');if(!bd)return;if(bd.style.display==='none'){bd.style.display='block';chev.innerHTML=chevUpSVG;chev.classList.add('is-open');}else{bd.style.display='none';chev.innerHTML=chevSVG;chev.classList.remove('is-open');}return;}
	if(e.target.classList.contains('wpfaqcb-remove-sec')){if(confirm(i.confirm_delete))e.target.closest('.wpfaqcb-sec-block').remove();}
	if(e.target.classList.contains('wpfaqcb-remove-sub')){if(confirm(i.confirm_delete))e.target.closest('.wpfaqcb-sub-block').remove();}
	if(e.target.classList.contains('wpfaqcb-remove-item')){if(confirm(i.confirm_delete))e.target.closest('.wpfaqcb-item').remove();}
	if(e.target.classList.contains('wpfaqcb-remove-helpme')){if(confirm(i.confirm_delete))e.target.closest('.wpfaqcb-helpme-row').remove();}
	if(e.target.classList.contains('wpfaqcb-remove-field')){if(confirm(i.confirm_delete))e.target.closest('.wpfaqcb-field-row').remove();}
});

document.addEventListener('change',function(e){
	if(e.target.classList.contains('sec-has-subs')){var block=e.target.closest('.wpfaqcb-sec-block');block.querySelector('.wpfaqcb-subs-area').style.display=e.target.checked?'block':'none';block.querySelector('.wpfaqcb-direct-area').style.display=e.target.checked?'none':'block';}
	if(e.target.classList.contains('ff-type')){var opt=e.target.closest('.wpfaqcb-field-row').querySelector('.ff-options');if(opt)opt.style.display=['select','checkbox','radio'].includes(e.target.value)?'':'none';}
});

/* Media uploader */
document.addEventListener('click',function(e){if(!e.target.classList.contains('wpfaqcb-media-btn'))return;e.preventDefault();var btn=e.target,wrap=btn.parentElement;var frame=wp.media({title:i.choose_image||'Choose Icon',multiple:false,library:{type:['image','image/svg+xml']}});frame.on('select',function(){var att=frame.state().get('selection').first().toJSON();wrap.querySelector('input[type="hidden"]').value=att.url;var img=wrap.querySelector('img');if(!img){img=document.createElement('img');img.className=wrap.className.indexOf('sec')>-1?'sec-icon-preview':'sub-icon-preview';wrap.insertBefore(img,btn);}img.src=att.url;btn.textContent=i.change||'Change';});frame.open();});

/* Add Section */
var addSecBtn=document.getElementById('wpfaqcb-add-section');if(addSecBtn)addSecBtn.addEventListener('click',function(){var w=document.getElementById('wpfaqcb-faq-sections'),d=document.createElement('div');d.className='wpfaqcb-sec-block';d.innerHTML='<div class="wpfaqcb-sec-head"><span class="wpfaqcb-drag">'+dragSVG+'</span><span class="sec-icon-wrap"><input type="hidden" class="sec-icon-url" value="" /><button type="button" class="button button-small wpfaqcb-media-btn">'+esc(i.choose_image)+'</button></span><input type="text" class="sec-title" placeholder="'+esc(i.section_title)+'" />'+langSelect('sec-lang','all')+'<label class="sec-has-subs-label"><input type="checkbox" class="sec-has-subs" /> '+esc(i.has_subs)+'</label><button type="button" class="wpfaqcb-chevron">'+chevSVG+'</button><button type="button" class="button wpfaqcb-remove-sec">&times;</button></div><div class="wpfaqcb-sec-body"><div class="wpfaqcb-subs-area" style="display:none;"><input type="text" class="sec-sub-label" placeholder="'+esc(i.sub_label)+'" style="width:100%;margin-bottom:8px;" /><div class="wpfaqcb-subs-list"></div><button type="button" class="button wpfaqcb-add-sub">'+esc(i.add_sub)+'</button></div><div class="wpfaqcb-direct-area"><div class="wpfaqcb-items-list"></div><button type="button" class="button wpfaqcb-add-item">'+esc(i.add_question)+'</button></div></div>';w.appendChild(d);initSort();});

document.addEventListener('click',function(e){if(!e.target.classList.contains('wpfaqcb-add-sub'))return;var list=e.target.previousElementSibling,d=document.createElement('div');d.className='wpfaqcb-sub-block';d.innerHTML='<div class="wpfaqcb-sub-head"><span class="wpfaqcb-drag">'+dragSVG+'</span><span class="sub-icon-wrap"><input type="hidden" class="sub-icon-url" value="" /><button type="button" class="button button-small wpfaqcb-media-btn">'+esc(i.choose_image)+'</button></span><input type="text" class="sub-title" placeholder="'+esc(i.sub_title)+'" /><button type="button" class="wpfaqcb-chevron">'+chevSVG+'</button><button type="button" class="button wpfaqcb-remove-sub">&times;</button></div><div class="wpfaqcb-sub-body"><div class="wpfaqcb-items-list"></div><button type="button" class="button wpfaqcb-add-item">'+esc(i.add_question)+'</button></div>';list.appendChild(d);initSort();});

document.addEventListener('click',function(e){if(!e.target.classList.contains('wpfaqcb-add-item'))return;var list=e.target.previousElementSibling,d=document.createElement('div');d.className='wpfaqcb-item';d.innerHTML='<span class="wpfaqcb-drag">'+dragSVG+'</span><div class="wpfaqcb-item-fields"><input type="text" class="item-q" placeholder="'+esc(i.question)+'" /><textarea class="item-a" rows="2" placeholder="'+esc(i.answer)+'"></textarea></div><button type="button" class="button wpfaqcb-remove-item">&times;</button>';list.appendChild(d);initSort();});

var addHelpBtn=document.getElementById('wpfaqcb-add-helpme-option');if(addHelpBtn)addHelpBtn.addEventListener('click',function(){var w=document.getElementById('wpfaqcb-helpme-options'),d=document.createElement('div');d.className='wpfaqcb-helpme-row';d.innerHTML='<span class="wpfaqcb-drag">'+dragSVG+'</span><input type="text" class="hm-text" placeholder="'+esc(i.option_text)+'" /><input type="text" class="hm-suggest" placeholder="'+esc(i.option_suggest)+'" /><select class="hm-section">'+sectionOptions(0)+'</select>'+langSelect('hm-lang','all')+'<button type="button" class="button wpfaqcb-remove-helpme">&times;</button>';w.appendChild(d);initSort();});

var addFieldBtn=document.getElementById('wpfaqcb-add-field');if(addFieldBtn)addFieldBtn.addEventListener('click',function(){addFieldRow({label:'',type:'text',required:'0',placeholder:'',options:''});});
function addFieldRow(f){var w=document.getElementById('wpfaqcb-form-fields'),d=document.createElement('div');d.className='wpfaqcb-field-row';d.innerHTML='<span class="wpfaqcb-drag">'+dragSVG+'</span><input type="text" class="ff-label" placeholder="'+esc(i.field_label)+'" value="'+esc(f.label)+'" /><select class="ff-type"><option value="text"'+(f.type==='text'?' selected':'')+'>text</option><option value="email"'+(f.type==='email'?' selected':'')+'>email</option><option value="tel"'+(f.type==='tel'?' selected':'')+'>tel</option><option value="select"'+(f.type==='select'?' selected':'')+'>select</option><option value="textarea"'+(f.type==='textarea'?' selected':'')+'>textarea</option><option value="checkbox"'+(f.type==='checkbox'?' selected':'')+'>checkbox</option><option value="radio"'+(f.type==='radio'?' selected':'')+'>radio</option><option value="date"'+(f.type==='date'?' selected':'')+'>date</option></select><label class="ff-req-label"><input type="checkbox" class="ff-required"'+(f.required==='1'?' checked':'')+' /> '+esc(i.field_required)+'</label><input type="text" class="ff-placeholder" placeholder="'+esc(i.field_placeholder)+'" value="'+esc(f.placeholder)+'" /><input type="text" class="ff-options" placeholder="'+esc(i.field_options)+'" value="'+esc(f.options||'')+'" style="'+(!['select','checkbox','radio'].includes(f.type)?'display:none;':'')+'" />'+langSelect('ff-lang',f.lang||'all')+'<button type="button" class="button wpfaqcb-remove-field">&times;</button>';w.appendChild(d);initSort();}

function collect(){var f=document.getElementById('wpfaqcb-form'),d={};['chat_enabled','chat_position','popup_enabled','popup_delay','popup_duration','chat_direction','google_font','header_title','header_subtitle','welcome_title','welcome_text','popup_text','input_placeholder','back_main_label','back_section_label','answer_label','contact_btn_label','request_btn_label','contact_enabled','contact_phone','contact_email','contact_whatsapp','contact_website','form_enabled','form_title','form_subtitle','form_submit_label','form_success_msg','form_email_notify','form_email_to','chat_width','chat_max_height','border_radius','load_on_pages','helpme_enabled','helpme_title','helpme_question','typing_animation','rating_enabled','rating_question','rating_thanks','session_memory','lazy_load','antispam_honeypot','antispam_rate_limit','quick_reply_enabled','quick_reply_label','copy_answer_enabled','print_answer_enabled','copy_success'].forEach(function(n){var el=f.querySelector('[name="'+n+'"]');if(!el)return;d[n]=el.type==='checkbox'?(el.checked?'1':'0'):el.value;});
/* Welcome variations (textarea) */
var wvEl=f.querySelector('[name="welcome_variations"]');if(wvEl)d.welcome_variations=wvEl.value;
if(typeof jQuery!=='undefined'&&jQuery.fn.wpColorPicker){['color_primary','color_header','color_header_text','color_chat_bg','color_button','color_button_text','color_text','color_accent'].forEach(function(k){var $e=jQuery('[name="'+k+'"]');if($e.length)d[k]=$e.wpColorPicker('color')||$e.val();});}
d.faq_sections=[];document.querySelectorAll('#wpfaqcb-faq-sections > .wpfaqcb-sec-block').forEach(function(block){var sec={title:block.querySelector('.sec-title').value,icon_url:block.querySelector('.sec-icon-url')?block.querySelector('.sec-icon-url').value:'',lang:block.querySelector('.sec-lang')?block.querySelector('.sec-lang').value:'all',has_subs:block.querySelector('.sec-has-subs').checked?'1':'0',sub_label:block.querySelector('.sec-sub-label')?block.querySelector('.sec-sub-label').value:'',subs:[],items:[]};if(sec.has_subs==='1'){block.querySelectorAll('.wpfaqcb-subs-list > .wpfaqcb-sub-block').forEach(function(sb){var sub={title:sb.querySelector('.sub-title').value,icon_url:sb.querySelector('.sub-icon-url')?sb.querySelector('.sub-icon-url').value:'',items:[]};sb.querySelectorAll('.wpfaqcb-item').forEach(function(it){sub.items.push({question:it.querySelector('.item-q').value,answer:it.querySelector('.item-a').value});});sec.subs.push(sub);});}else{block.querySelectorAll('.wpfaqcb-direct-area .wpfaqcb-item').forEach(function(it){sec.items.push({question:it.querySelector('.item-q').value,answer:it.querySelector('.item-a').value});});}d.faq_sections.push(sec);});
d.helpme_options=[];document.querySelectorAll('#wpfaqcb-helpme-options .wpfaqcb-helpme-row').forEach(function(r){d.helpme_options.push({text:r.querySelector('.hm-text').value,suggest:r.querySelector('.hm-suggest').value,section_id:parseInt(r.querySelector('.hm-section').value)||0,lang:r.querySelector('.hm-lang')?r.querySelector('.hm-lang').value:'all'});});
d.form_fields=[];document.querySelectorAll('#wpfaqcb-form-fields .wpfaqcb-field-row').forEach(function(r){d.form_fields.push({label:r.querySelector('.ff-label').value,type:r.querySelector('.ff-type').value,required:r.querySelector('.ff-required').checked?'1':'0',placeholder:r.querySelector('.ff-placeholder').value,options:r.querySelector('.ff-options').value,lang:r.querySelector('.ff-lang')?r.querySelector('.ff-lang').value:'all'});});
return d;}

var mainForm=document.getElementById('wpfaqcb-form');if(mainForm)mainForm.addEventListener('submit',function(e){e.preventDefault();var sp=document.getElementById('wpfaqcb-spinner');sp.classList.add('is-active');var fd=new FormData();fd.append('action','wpfaqcb_save_settings');fd.append('nonce',wpfaqcbAdmin.nonce);fd.append('settings',JSON.stringify(collect()));fetch(wpfaqcbAdmin.ajaxurl,{method:'POST',credentials:'same-origin',body:fd}).then(function(r){return r.json();}).then(function(res){sp.classList.remove('is-active');notice(res.success?'success':'error',res.data||i.error);secTitles=[];document.querySelectorAll('#wpfaqcb-faq-sections > .wpfaqcb-sec-block .sec-title').forEach(function(el){secTitles.push(el.value);});}).catch(function(){sp.classList.remove('is-active');notice('error',i.error);});});

function notice(t,m){var w=document.getElementById('wpfaqcb-notices');w.innerHTML='<div class="notice notice-'+t+' is-dismissible"><p>'+esc(m)+'</p></div>';setTimeout(function(){w.innerHTML='';},4000);}
function esc(s){if(!s)return '';var e=document.createElement('span');e.textContent=s;return e.innerHTML;}
})();
