<?php
/**
 * Plugin Name: Askova – Smart FAQ Chat
 * Description: A lightweight FAQ chatbot for WordPress with floating widget, form builder, bilingual admin (AR/EN), multi-language support (auto-detect WPML/Polylang), sub-sections, quick replies, print/copy answers, ratings, and full dashboard control. No coding required.
 * Version:     2.0.4
 * Author:      Hossam Hamed
 * Author URI:  https://hossamhamed.online
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: askova
 * Domain Path: /languages
 * Requires at least: 5.6
 * Requires PHP: 7.4
 *
 * @package Askova
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'WPFAQCB_VERSION', '2.0.4' );
define( 'WPFAQCB_FILE', __FILE__ );
define( 'WPFAQCB_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPFAQCB_URL', plugin_dir_url( __FILE__ ) );
define( 'WPFAQCB_BASENAME', plugin_basename( __FILE__ ) );

require_once WPFAQCB_PATH . 'includes/class-i18n-manager.php';
require_once WPFAQCB_PATH . 'includes/class-settings-manager.php';
require_once WPFAQCB_PATH . 'includes/class-form-handler.php';
require_once WPFAQCB_PATH . 'includes/class-assets-loader.php';
require_once WPFAQCB_PATH . 'includes/class-shortcode.php';
require_once WPFAQCB_PATH . 'admin/class-admin-settings.php';
require_once WPFAQCB_PATH . 'admin/class-admin-form-logs.php';
require_once WPFAQCB_PATH . 'public/class-chat-renderer.php';
require_once WPFAQCB_PATH . 'includes/class-plugin-loader.php';

function wpfaqcb_init() {
	return WPFAQCB_Plugin_Loader::get_instance();
}
wpfaqcb_init();

register_activation_hook( __FILE__, 'wpfaqcb_activate' );

function wpfaqcb_activate() {
	WPFAQCB_Settings_Manager::activate();
	WPFAQCB_Form_Handler::create_table();
	WPFAQCB_Form_Handler::create_ratings_table();
	set_transient( 'wpfaqcb_activation_redirect', true, 30 );
}

/* ===== UPGRADE ROUTINE ===== */
add_action( 'admin_init', 'wpfaqcb_maybe_upgrade' );

function wpfaqcb_maybe_upgrade() {
	$db_version = get_option( 'wpfaqcb_db_version', '0' );
	if ( version_compare( $db_version, WPFAQCB_VERSION, '>=' ) ) {
		return;
	}
	/* Merge new default keys into existing saved settings */
	$saved    = get_option( WPFAQCB_Settings_Manager::OPTION_KEY, array() );
	if ( ! is_array( $saved ) ) {
		$saved = array();
	}
	$lang     = WPFAQCB_I18n::get_lang();
	$defaults = WPFAQCB_Settings_Manager::get_defaults( $lang ? $lang : 'ar' );
	$updated  = false;
	foreach ( $defaults as $key => $val ) {
		if ( ! array_key_exists( $key, $saved ) ) {
			$saved[ $key ] = $val;
			$updated       = true;
		}
	}
	if ( $updated ) {
		update_option( WPFAQCB_Settings_Manager::OPTION_KEY, $saved );
	}
	update_option( 'wpfaqcb_db_version', WPFAQCB_VERSION );
}

add_action( 'admin_init', function() {
	if ( get_transient( 'wpfaqcb_activation_redirect' ) ) {
		delete_transient( 'wpfaqcb_activation_redirect' );
		if ( ! isset( $_GET['activate-multi'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			wp_safe_redirect( admin_url( 'admin.php?page=askova&welcome=1' ) );
			exit;
		}
	}
} );
