<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WPFAQCB_Admin_Form_Logs {

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_submenu' ) );
	}

	public function add_submenu() {
		add_submenu_page( 'askova', WPFAQCB_I18n::t( 'form_logs' ), WPFAQCB_I18n::t( 'form_logs' ), 'manage_options', 'askova-logs', array( $this, 'render_page' ) );
	}

	public function render_page() {
		if ( ! current_user_can( 'manage_options' ) ) return;
		$logs  = WPFAQCB_Form_Handler::get_logs( 200 );
		$total = WPFAQCB_Form_Handler::count_logs();
		$rtl   = WPFAQCB_I18n::is_rtl();
		$dir   = $rtl ? 'rtl' : 'ltr';
		$nonce = wp_create_nonce( 'wpfaqcb_logs_nonce' );
		$export_url = wp_nonce_url( admin_url( 'admin-ajax.php?action=wpfaqcb_export_csv' ), 'wpfaqcb_export_csv' );
		?>
		<div class="wrap wpfaqcb-logs-wrap" dir="<?php echo esc_attr( $dir ); ?>">
			<div class="wpfaqcb-logs-header">
				<h1><span class="dashicons dashicons-list-view"></span> <?php WPFAQCB_I18n::e( 'form_logs' ); ?></h1>
				<div class="wpfaqcb-logs-stats">
					<span class="wpfaqcb-stat-badge"><?php WPFAQCB_I18n::e( 'total_submissions' ); ?>: <strong><?php echo esc_html( $total ); ?></strong></span>
					<?php if ( count( $logs ) < $total ) : ?>
						<span class="wpfaqcb-stat-info"><?php WPFAQCB_I18n::e( 'showing' ); ?> <?php echo count( $logs ); ?> <?php WPFAQCB_I18n::e( 'entries' ); ?></span>
					<?php endif; ?>
					<?php if ( $total > 0 ) : ?>
						<a href="<?php echo esc_url( $export_url ); ?>" class="button button-secondary" style="margin-inline-start:10px;">
							<span class="dashicons dashicons-download" style="margin-top:3px;"></span> <?php WPFAQCB_I18n::e( 'export_csv' ); ?>
						</a>
					<?php endif; ?>
				</div>
			</div>

			<?php if ( empty( $logs ) ) : ?>
				<div class="wpfaqcb-empty-state">
					<span class="dashicons dashicons-inbox"></span>
					<p><?php WPFAQCB_I18n::e( 'no_logs' ); ?></p>
				</div>
			<?php else : ?>
				<div class="wpfaqcb-logs-grid">
					<?php foreach ( $logs as $idx => $log ) :
						$data = json_decode( $log->form_data, true );
						if ( ! is_array( $data ) ) continue;
					?>
						<div class="wpfaqcb-log-card" data-id="<?php echo esc_attr( $log->id ); ?>">
							<div class="wpfaqcb-log-card-header">
								<span class="wpfaqcb-log-id">#<?php echo esc_html( $log->id ); ?></span>
								<span class="wpfaqcb-log-date"><?php echo esc_html( $log->created_at ); ?></span>
								<button class="wpfaqcb-delete-log" data-id="<?php echo esc_attr( $log->id ); ?>" data-nonce="<?php echo esc_attr( $nonce ); ?>" title="<?php WPFAQCB_I18n::e( 'delete' ); ?>"><span class="dashicons dashicons-trash"></span></button>
							</div>
							<div class="wpfaqcb-log-card-body">
								<?php foreach ( $data as $cell ) : ?>
									<div class="wpfaqcb-log-field">
										<span class="wpfaqcb-log-label"><?php echo esc_html( $cell['label'] ); ?></span>
										<span class="wpfaqcb-log-value"><?php echo esc_html( $cell['value'] ); ?></span>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
		wp_enqueue_script( 'wpfaqcb-logs', WPFAQCB_URL . 'assets/js/logs.js', array(), WPFAQCB_VERSION, true );
		wp_localize_script( 'wpfaqcb-logs', 'wpfaqcbLogs', array(
			'ajaxurl'     => admin_url( 'admin-ajax.php' ),
			'confirmText' => WPFAQCB_I18n::t( 'confirm_delete' ),
		) );
	}
}
