<?php
if (!defined('ABSPATH')) { exit; }

class ALBP_WXR {
    public function export_albp_posts() {
        $posts = get_posts([
            'post_type' => 'post',
            'post_status' => ['draft','publish','pending','future'],
            'numberposts' => -1,
            'meta_key' => '_albp_generated_by',
            'meta_value' => 'ALBP',
        ]);

        $xml  = '<?xml version="1.0" encoding="UTF-8" ?>' . "\n";
        $xml .= '<rss version="2.0"
            xmlns:excerpt="http://wordpress.org/export/1.2/excerpt/"
            xmlns:content="http://purl.org/rss/1.0/modules/content/"
            xmlns:wfw="http://wellformedweb.org/CommentAPI/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:wp="http://wordpress.org/export/1.2/">' . "\n";
        $xml .= "<channel>\n";
        $xml .= '<title>'.esc_html(get_bloginfo('name'))."</title>\n";
        $xml .= '<link>'.esc_url(home_url('/'))."</link>\n";
        $xml .= '<description>Articla Lite export</description>'."\n";
        $xml .= '<wp:wxr_version>1.2</wp:wxr_version>'."\n";
        $xml .= '<generator>Articla Lite</generator>'."\n";

        foreach ($posts as $p) {
            setup_postdata($p);
            $xml .= "<item>\n";
            $xml .= '<title>'.esc_html(get_the_title($p))."</title>\n";
            $xml .= '<link>'.esc_url(get_permalink($p))."</link>\n";
            $xml .= '<pubDate>'.esc_html(mysql2date('D, d M Y H:i:s +0000', $p->post_date_gmt, false))."</pubDate>\n";
            $xml .= '<dc:creator>'.esc_html(get_the_author_meta('user_login', $p->post_author))."</dc:creator>\n";
            $xml .= '<guid isPermaLink="false">'.esc_html($p->ID)."</guid>\n";
            $xml .= '<description></description>'."\n";
            $xml .= '<content:encoded><![CDATA['.$p->post_content.']]></content:encoded>'."\n";
            $xml .= '<excerpt:encoded><![CDATA['.get_the_excerpt($p).']]></excerpt:encoded>'."\n";
            $xml .= '<wp:post_id>'.$p->ID.'</wp:post_id>'."\n";
            $xml .= '<wp:post_date_gmt>'.esc_html($p->post_date_gmt).'</wp:post_date_gmt>'."\n";
            $xml .= '<wp:post_type>post</wp:post_type>'."\n";
            $xml .= '<wp:status>'.esc_html($p->post_status).'</wp:status>'."\n";
            $qc = get_post_meta($p->ID, '_albp_qc', true);
            if ($qc) { $xml .= "<wp:postmeta><wp:meta_key>_albp_qc</wp:meta_key><wp:meta_value><![CDATA[$qc]]></wp:meta_value></wp:postmeta>\n"; }
            $no = get_post_meta($p->ID, '_albp_noindex', true);
            if ($no) { $xml .= "<wp:postmeta><wp:meta_key>_albp_noindex</wp:meta_key><wp:meta_value><![CDATA[$no]]></wp:meta_value></wp:postmeta>\n"; }
            $xml .= "</item>\n";
        }
        wp_reset_postdata();

        $xml .= "</channel>\n</rss>";
        return $xml;
    }
}