jQuery(function($){
  let running = false;
  let total = 0, done = 0;
  let delayMs = 5000;

  function log(msg){ $('#albp-log').append(String(msg)+'\n').scrollTop(999999); }
  function progress(){ const pct = total>0 ? Math.floor((done/total)*100) : 0; $('#albp-progress span').css('width', pct+'%'); }

  const $flag = $('#albp_publish_if_qc');
  const $hidden = $('#albp_default_status');
  function syncFlagToHidden(){ $hidden.val($flag.is(':checked') ? 'publish_if_qc' : 'draft'); }
  if ($flag.length) { $flag.on('change', syncFlagToHidden); }

  $('.albp-eye').on('click', function(){
    const id = $(this).data('for');
    const $inp = $('#'+id);
    if (!$inp.length) return;
    $inp.attr('type', $inp.attr('type') === 'password' ? 'text' : 'password');
  });

  $('#albp-start').on('click', function(e){
    e.preventDefault();
    if (running) return;
    running = true; done = 0;
    const rows = $('#albp_rows').val();
    if (!rows || rows.trim().length === 0){ log('Please paste some CSV rows first.'); running=false; return; }

    const cats = $('.albp-cat:checked').map(function(){ return $(this).val(); }).get();
    var $delay = $('#albp_delay_ms');
    delayMs = parseInt(($delay.prop('disabled') ? '5000' : ($delay.val() || '5000')), 10);

    $.post(ALBP.ajaxurl, { action:'albp_start_processing', nonce: ALBP.nonce, rows, cats, delay_ms: delayMs }, function(res){
      if (res?.success){
        total = res.data.total || 0; done = 0;
        delayMs = res.data.delay_ms || delayMs;
        log('Ready: '+total+' items. '+(res.data.pro ? 'Pro mode.' : 'Free mode.')+' Starting…'); progress(); step();
      } else {
        log('Error: '+(res?.data?.msg || 'unknown')); running=false;
      }
    });
  });

  function step(){
    if (!running) return;
    $.post(ALBP.ajaxurl, { action:'albp_process_next', nonce: ALBP.nonce }, function(res){
      if (res?.success){
        done++;
        const name = (res && res.data && res.data.title) ? res.data.title : 'Untitled';
        log('Processed "' + name + '": ' + JSON.stringify(res.data.result));
        progress();
        if (res.data.pro_note){ log(res.data.pro_note); }
        if (res.data.done){ running=false; log('All done.'); return; }
        const waitMs = res.data.delay_ms ?? delayMs;
        log('Waiting '+waitMs+' ms…');
        setTimeout(step, 200);
      } else {
        log('Error: '+(res?.data?.msg || 'unknown')); running=false;
      }
    });
  }

  $('#albp-stop').on('click', function(e){
    e.preventDefault();
    const wasRunning = running;
    running=false;
    log('Processing stopped by user.');
    if (wasRunning) progress();
  });
});