<?php
/**
 * Uninstall script for Armory Atlas for WooCommerce
 * 
 * This file is executed when the plugin is uninstalled (deleted) from WordPress.
 * It removes all plugin data from the database.
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('armory_atlas_settings');

// Remove any transients
delete_transient('armory_atlas_cache');

// Clear any scheduled hooks
wp_clear_scheduled_hook('armory_atlas_cleanup');

// Note: We don't remove user meta or post meta as this plugin doesn't store any
// The plugin only stores configuration options which are safely removed above
