<?php
/**
 * Template: Armory Atlas Button
 *
 * Override by placing a copy at:
 *   your-theme/armory-atlas/button.php
 * or in a child theme:
 *   your-child-theme/armory-atlas/button.php
 *
 * Variables from plugin:
 * - $btn_text (string)
 * - $scheme_url (string)
 * - $fallback_url (string)
 * - $wrapper_class (string)
 * - $wrapper_style (string)
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Guard against empty scheme URL causing same-page reloads.
$primary_href = ! empty( $scheme_url ) ? $scheme_url : $fallback_url;
$wrapper_classes = isset( $wrapper_class ) ? $wrapper_class : 'armoryatlas-cta armory-atlas-cta';
?>
<div class="<?php echo esc_attr( $wrapper_classes ); ?>" data-aa="armoryatlas" style="<?php echo isset( $wrapper_style ) ? esc_attr( $wrapper_style ) : ''; ?>">
    <a href="<?php echo esc_url( $primary_href ); ?>"
        rel="nofollow noindex noopener noreferrer"
        class="<?php echo esc_attr( isset( $btn_class ) ? $btn_class : 'armoryatlas-link armory-atlas-button button' ); ?>"
        data-scheme="<?php echo esc_url( $scheme_url ); ?>"
        data-fallback="<?php echo esc_url( $fallback_url ); ?>"
        target="_blank" 
        title="<?php echo esc_attr( $btn_text ?? 'Add to Armory Atlas' ); ?>"
        aria-label="<?php echo esc_attr( $btn_text ?? 'Add to Armory Atlas' ); ?>">
        <span class="armoryatlas-button-content">
            <?php if ( ! empty( $icon_url ) ) : ?>
                <span class="armoryatlas-icon-wrap" aria-hidden="true">
                    <img class="armoryatlas-icon armory-atlas-icon" src="<?php echo esc_url( $icon_url ); ?>?v=1" alt="" />
                </span>
            <?php endif; ?>
            <span class="armoryatlas-label armory-atlas-text"><?php echo esc_html( $btn_text ?? 'Add to Armory Atlas' ); ?></span>
        </span>
    </a>
</div>