(function(){
  if (typeof window === 'undefined' || typeof document === 'undefined') {
    return;
  }

  function b64url(str){
    try {
      return btoa(unescape(encodeURIComponent(str)))
        .replace(/\+/g,'-').replace(/\//g,'_').replace(/=+$/,'');
    } catch(e) {
      console.error('ArmoryAtlas base64url error', e);
      return '';
    }
  }

  function getConfig(){
    var cfg = window.ArmoryAtlasConfig || {};
    return {
      scheme: cfg.scheme || 'ArmoryAtlas://import',
      fallback: cfg.fallback || 'https://www.armoryatlas.com/import'
    };
  }

  function openLink(options){
    var scheme = options.scheme || '';
    var fallback = options.fallback || '';

    if (!scheme) {
      if (fallback) {
        try { window.open(fallback, '_blank'); } catch(e) { window.location.href = fallback; }
      }
      return;
    }

    var navigated = false;
    var timer = null;

    function clearGuards(){
      window.removeEventListener('blur', onBlur);
      document.removeEventListener('visibilitychange', onVisibility);
    }

    function onBlur(){
      navigated = true;
      if (timer) { clearTimeout(timer); }
      clearGuards();
    }

    function onVisibility(){
      if (document.hidden) {
        onBlur();
      }
    }

    window.addEventListener('blur', onBlur);
    document.addEventListener('visibilitychange', onVisibility);

    timer = setTimeout(function(){
      if (!navigated && fallback) {
        try { window.open(fallback, '_blank'); } catch(e) { window.location.href = fallback; }
      }
      clearGuards();
    }, 900);

    try {
      var ua = navigator.userAgent || '';
      var isIOS = /iphone|ipad|ipod/i.test(ua);
      if (isIOS) {
        var iframe = document.createElement('iframe');
        iframe.style.display = 'none';
        iframe.src = scheme;
        document.body.appendChild(iframe);
        setTimeout(function(){
          try { document.body.removeChild(iframe); } catch (err) {}
        }, 2000);
      } else {
        window.location.href = scheme;
      }
    } catch (err) {
      if (timer) { clearTimeout(timer); }
      if (fallback) {
        try { window.open(fallback, '_blank'); } catch (error) { window.location.href = fallback; }
      }
      clearGuards();
    }
  }

  function buildLinkFromPayload(payload){
    var cfg = getConfig();
    try {
      var data = b64url(JSON.stringify(payload || {}));
      var encoded = encodeURIComponent(data);
      var type = payload && payload.prefill && payload.prefill.type ? '&type=' + encodeURIComponent(String(payload.prefill.type).toLowerCase()) : '';
      return {
        scheme: cfg.scheme + '?data=' + encoded + type,
        fallback: cfg.fallback + '?data=' + encoded + type
      };
    } catch (err) {
      console.error('ArmoryAtlas payload encoding error', err);
      return cfg;
    }
  }

  function handleAnchorClick(event){
    var anchor = event.target && event.target.closest ? event.target.closest('a.armoryatlas-link, a.armory-atlas-button') : null;
    if (!anchor) { return; }

    event.preventDefault();

    var cfg = getConfig();
    var scheme = anchor.getAttribute('data-scheme') || anchor.getAttribute('href') || cfg.scheme;
    var fallback = anchor.getAttribute('data-fallback') || cfg.fallback;

    openLink({ scheme: scheme, fallback: fallback });
  }

  document.addEventListener('click', handleAnchorClick, { passive: false });

  window.ArmoryAtlasOpen = function(payload){
    openLink(buildLinkFromPayload(payload));
  };
})();
