(function(){
    if (typeof window === 'undefined' || typeof document === 'undefined') {
        return;
    }

    function onReady(callback){
        if (document.readyState === 'complete' || document.readyState === 'interactive') {
            callback();
        } else {
            document.addEventListener('DOMContentLoaded', callback, { once: true });
        }
    }

    function initSuggestButtons(){
        function scoreOption(label, key){
            label = (label || '').toLowerCase();
            key = (key || '').toLowerCase();
            var score = 0;

            if (key === 'make' && label.indexOf('manufacturer') > -1) score += 15;
            if (key === 'model' && label.indexOf('model') > -1) score += 15;
            if (key === 'caliber' && (label.indexOf('caliber-gauge') > -1 || label.indexOf('caliber') > -1)) score += 15;
            if (key === 'upc' && label.indexOf('upc') > -1) score += 15;
            if (key === 'ammo_type' && label.indexOf('product-type') > -1) score += 15;
            if (key === 'bullet_weight_grains' && label.indexOf('bullet-weight-grains') > -1) score += 15;
            if (key === 'units_per_box' && label.indexOf('units-per-box') > -1) score += 15;
            if (key === 'cost_per_round' && label.indexOf('cost-per-round') > -1) score += 15;
            if (key === 'case_material' && label.indexOf('case-material') > -1) score += 15;
            if (key === 'mpn' && label.indexOf('manufacturer-part-number') > -1) score += 15;

            if (key === 'type' && label.indexOf('product category') > -1) score += 10;
            if (key === 'make' && label.indexOf('brand') > -1) score += 8;
            if (key === 'model' && (label.indexOf('name/title') > -1 || label.indexOf('name') > -1)) score += 6;
            if (key === 'caliber'){
                if (label.indexOf('caliber') > -1) score += 10;
                if (label.indexOf('attribute') > -1 && label.indexOf('caliber') > -1) score += 2;
            }
            if (key === 'upc'){
                if (label.indexOf('upc') > -1) score += 10;
                if (label.indexOf('meta') > -1) score += 1;
            }
            if (key === 'sku' && label.indexOf('sku') > -1) score += 10;
            if (key === 'ammo_type' && (label.indexOf('ammo type') > -1 || label.indexOf('type') > -1)) score += 9;
            if (key === 'bullet_weight_grains' && (label.indexOf('bullet weight') > -1 || label.indexOf('grains') > -1)) score += 10;
            if (key === 'units_per_box' && (label.indexOf('units per box') > -1 || label.indexOf('quantity') > -1 || label.indexOf('rounds') > -1)) score += 9;
            if (key === 'cost_per_round' && (label.indexOf('cost per round') > -1 || label.indexOf('price') > -1)) score += 6;
            if (key === 'case_material' && (label.indexOf('case material') > -1 || label.indexOf('brass') > -1 || label.indexOf('steel') > -1)) score += 7;
            if (key === 'mpn' && (label.indexOf('manufacturer part number') > -1 || label.indexOf('mpn') > -1)) score += 10;
            if (key === 'length' && (label.indexOf('length') > -1 || label.indexOf('oal') > -1)) score += 6;
            if (key === 'category' && (label.indexOf('primary category') > -1 || label.indexOf('product category') > -1)) score += 5;
            if (key === 'category_slug' && (label.indexOf('primary category') > -1 || label.indexOf('product category') > -1)) score += 5;
            if (key === 'title' && (label.indexOf('name/title') > -1 || label.indexOf('name') > -1)) score += 10;
            if (key === 'description' && label.indexOf('full description') > -1) score += 10;
            if (key === 'description' && label.indexOf('short description') > -1) score += 5;
            if (key === 'price' && label.indexOf('price') > -1) score += 10;
            if (key === 'image_url' && label.indexOf('image') > -1) score += 10;
            if (key === 'product_url' && (label.indexOf('product url') > -1 || label.indexOf('permalink') > -1)) score += 10;

            return score;
        }

        function suggestRow(row){
            if (!row) { return; }
            var key = row.getAttribute('data-map-key') || '';
            var select = row.querySelector('select');
            if (!select) { return; }

            var bestValue = '';
            var bestScore = -1;
            select.querySelectorAll('option').forEach(function(opt){
                var score = scoreOption(opt.textContent || '', key);
                if (score > bestScore) {
                    bestScore = score;
                    bestValue = opt.value;
                }
            });
            if (bestValue) {
                select.value = bestValue;
            }

            var meta = row.querySelector('.aa-map-meta');
            if (!meta || meta.value) { return; }
            if (key === 'upc') meta.value = 'upc';
            if (key === 'make') meta.value = 'manufacturer';
            if (key === 'model') meta.value = 'model';
            if (key === 'caliber') meta.value = 'caliber';
            if (key === 'ammo_type') meta.value = 'product_type';
            if (key === 'bullet_weight_grains') meta.value = 'bullet_weight';
            if (key === 'units_per_box') meta.value = 'units_per_box';
            if (key === 'cost_per_round') meta.value = 'cost_per_round';
            if (key === 'case_material') meta.value = 'case_material';
            if (key === 'mpn') meta.value = 'manufacturer_part_number';
        }

        document.addEventListener('click', function(event){
            var button = event.target && event.target.closest ? event.target.closest('.aa-suggest') : null;
            if (!button) { return; }
            event.preventDefault();
            var row = button.closest('.aa-map-row');
            if (row) {
                suggestRow(row);
            }
        });
    }

    function buildDescendantsMap(elements, idAttr, parentAttr){
        var byId = new Map();
        var children = new Map();

        elements.forEach(function(el){
            var id = String(el.getAttribute(idAttr) || '');
            var parent = String(el.getAttribute(parentAttr) || '0');
            if (id) {
                byId.set(id, el);
            }
            if (!children.has(parent)) {
                children.set(parent, []);
            }
            children.get(parent).push(id);
        });

        function descendants(root){
            var stack = [String(root)];
            var out = [];
            while (stack.length) {
                var current = stack.pop();
                var kids = children.get(current) || [];
                for (var i = 0; i < kids.length; i++) {
                    out.push(kids[i]);
                    stack.push(kids[i]);
                }
            }
            return out;
        }

        return { byId: byId, descendants: descendants };
    }

    function initCategoryCheckboxCascade(){
        var boxes = Array.prototype.slice.call(document.querySelectorAll('input[type="checkbox"][name="armory_atlas_settings[trigger_categories_ids][]"]'));
        if (!boxes.length) { return; }

        var map = buildDescendantsMap(boxes, 'data-term-id', 'data-parent-id');

        boxes.forEach(function(box){
            box.addEventListener('change', function(){
                var id = String(box.getAttribute('data-term-id') || '');
                if (!id) { return; }
                var checked = box.checked;
                map.descendants(id).forEach(function(childId){
                    var child = map.byId.get(childId);
                    if (child) {
                        child.checked = checked;
                    }
                });
            });
        });
    }

    function initCategoryTypeMapping(){
        var selectors = Array.prototype.slice.call(document.querySelectorAll('select[name^="armory_atlas_settings[category_type_map]"]'));
        if (!selectors.length) { return; }

        var map = buildDescendantsMap(selectors, 'data-term-id', 'data-parent-id');

        function propagate(id, value){
            if (!id || !value) { return; }
            map.descendants(id).forEach(function(childId){
                var child = map.byId.get(childId);
                if (child && child.value === '') {
                    child.value = value;
                }
            });
        }

        selectors.forEach(function(select){
            select.addEventListener('change', function(event){
                var target = event && event.target ? event.target : select;
                var id = String(target.getAttribute('data-term-id') || '');
                propagate(id, target.value);
            });
        });

        selectors.forEach(function(select){
            var id = String(select.getAttribute('data-term-id') || '');
            if (select.value) {
                propagate(id, select.value);
            }
        });

        var resetButtons = document.querySelectorAll('.aa-reset-children');
        resetButtons.forEach(function(button){
            button.addEventListener('click', function(event){
                event.preventDefault();
                var id = String(button.getAttribute('data-term-id') || '');
                if (!id) { return; }
                map.descendants(id).forEach(function(childId){
                    var child = map.byId.get(childId);
                    if (child) {
                        child.value = '';
                    }
                });
            });
        });
    }

    onReady(function(){
        initSuggestButtons();
        initCategoryCheckboxCascade();
        initCategoryTypeMapping();
    });
})();
