/**
 * Uninstall script
 *
 * @package AutoTOCSEO
 */

// If uninstall is not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete plugin options.
 */
function auto_toc_seo_uninstall() {
	// Delete plugin settings.
	delete_option( 'auto_toc_seo_settings' );

	// Delete transients if any.
	delete_transient( 'auto_toc_seo_version_check' );

	// For multisite, delete options for all sites.
	if ( is_multisite() ) {
		global $wpdb;

		$blog_ids = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );

		foreach ( $blog_ids as $blog_id ) {
			switch_to_blog( $blog_id );
			delete_option( 'auto_toc_seo_settings' );
			delete_transient( 'auto_toc_seo_version_check' );
			restore_current_blog();
		}
	}
}

auto_toc_seo_uninstall();

