# Screenshots for WordPress.org

This directory should contain screenshots for the WordPress.org plugin repository.

## Required Screenshots

For submission to WordPress.org, add the following screenshots with these exact filenames:

### screenshot-1.png
**Title:** Table of Contents display on frontend
**Description:** Shows how the TOC appears in a post with collapsible functionality, numbered list, and smooth scrolling.

### screenshot-2.png
**Title:** Admin settings page
**Description:** The comprehensive settings page where users can configure TOC behavior, appearance, and schema settings.

### screenshot-3.png
**Title:** Gutenberg TOC block in editor
**Description:** The Table of Contents block in the Gutenberg editor with customization options in the sidebar.

### screenshot-4.png
**Title:** Gutenberg FAQ block in editor
**Description:** The FAQ block in the Gutenberg editor showing question and answer fields with reordering controls.

### screenshot-5.png
**Title:** Mobile responsive design
**Description:** Shows how the TOC looks on mobile devices with responsive layout.

### screenshot-6.png
**Title:** Dark mode support
**Description:** TOC displaying in dark mode, automatically adapting to system preferences.

### screenshot-7.png
**Title:** Active heading highlight
**Description:** Shows the active section highlighting as users scroll through content.

### screenshot-8.png
**Title:** Collapsible TOC feature
**Description:** Demonstrates the collapse/expand functionality of the TOC.

## Screenshot Guidelines

- **Format:** PNG
- **Size:** 1200x900px (4:3 ratio) or 1600x1200px
- **File size:** Under 1MB each
- **Quality:** High quality, clear, and professional
- **Content:** 
  - Use lorem ipsum or appropriate demo content
  - Show the plugin in action
  - Highlight key features
  - Use clean, professional themes
  - Avoid personal information

## How to Capture Screenshots

1. Set up a clean WordPress installation with a modern theme
2. Install and activate the plugin
3. Create sample content with multiple h2 and h3 headings
4. Add the TOC block and FAQ block to demonstrate functionality
5. Use browser developer tools to set exact viewport sizes
6. Capture screenshots at the recommended resolution
7. Optimize images before uploading (using tools like TinyPNG)

## Naming Convention

Screenshots must be named exactly as shown:
- screenshot-1.png
- screenshot-2.png
- screenshot-3.png
- etc.

The number in the filename corresponds to the order they appear in the WordPress.org listing.

## Adding Screenshots to readme.txt

Descriptions for each screenshot are already included in the readme.txt file under the `== Screenshots ==` section.

## Tools for Screenshots

Recommended tools for capturing professional screenshots:
- Browser DevTools (Chrome/Firefox) for exact sizing
- Snagit or Greenshot for Windows
- CleanShot X or Skitch for Mac
- GIMP or Photoshop for editing
- TinyPNG or ImageOptim for optimization

## Important Notes

- Screenshots are NOT included in the plugin ZIP file
- Upload screenshots separately through the WordPress.org plugin dashboard
- Update screenshots when adding major new features
- Keep screenshots current with the latest plugin version

