/**
 * TOC Block for Gutenberg Editor
 */
(function (wp) {
	const { registerBlockType } = wp.blocks;
	const { InspectorControls } = wp.blockEditor;
	const { PanelBody, TextControl, ToggleControl } = wp.components;
	const { __ } = wp.i18n;
	const { ServerSideRender } = wp.serverSideRender || wp.editor;

	registerBlockType('aria-auto-table-of-contents/toc', {
		title: __('Table of Contents', 'aria-auto-table-of-contents'),
		description: __('Display an automatic table of contents based on headings', 'aria-auto-table-of-contents'),
		category: 'widgets',
		icon: 'list-view',
		keywords: [__('toc', 'aria-auto-table-of-contents'), __('table of contents', 'aria-auto-table-of-contents'), __('headings', 'aria-auto-table-of-contents')],
		supports: {
			align: true,
			html: false,
		},
		attributes: {
			title: {
				type: 'string',
				default: __('Table of Contents', 'aria-auto-table-of-contents'),
			},
			showNumbers: {
				type: 'boolean',
				default: true,
			},
			collapsible: {
				type: 'boolean',
				default: true,
			},
		},

		edit: function (props) {
			const { attributes, setAttributes } = props;
			const { title, showNumbers, collapsible } = attributes;

			return wp.element.createElement(
				'div',
				{ className: props.className },
				[
					wp.element.createElement(
						InspectorControls,
						{ key: 'inspector' },
						wp.element.createElement(
							PanelBody,
							{
								title: __('TOC Settings', 'aria-auto-table-of-contents'),
								initialOpen: true,
							},
							[
								wp.element.createElement(TextControl, {
									key: 'title',
									label: __('Title', 'aria-auto-table-of-contents'),
									value: title,
									onChange: function (value) {
										setAttributes({ title: value });
									},
								}),
								wp.element.createElement(ToggleControl, {
									key: 'showNumbers',
									label: __('Show Numbers', 'aria-auto-table-of-contents'),
									checked: showNumbers,
									onChange: function (value) {
										setAttributes({ showNumbers: value });
									},
								}),
								wp.element.createElement(ToggleControl, {
									key: 'collapsible',
									label: __('Collapsible', 'aria-auto-table-of-contents'),
									checked: collapsible,
									onChange: function (value) {
										setAttributes({ collapsible: value });
									},
								}),
							]
						)
					),
					wp.element.createElement(ServerSideRender, {
						key: 'preview',
						block: 'aria-auto-table-of-contents/toc',
						attributes: attributes,
					}),
				]
			);
		},

		save: function () {
			return null; // Server-side render
		},
	});
})(window.wp);

