<?php
/**
 * Plugin Name: Aria Auto Table of Contents (SEO Friendly)
 * Description: Automatically generate Table of Contents (TOC) with h2-h3 tags, expandable in Gutenberg blocks with schema support
 * Version: 1.4.0
 * Author: Alireza Aminzadeh
 * Author URI: https://aryait.net
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: aria-auto-table-of-contents
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 *
 * @package AutoTOCSEO
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'AUTO_TOC_SEO_VERSION', '1.4.0' );
define( 'AUTO_TOC_SEO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AUTO_TOC_SEO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'AUTO_TOC_SEO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Main plugin class.
 */
class Auto_TOC_SEO {

	/**
	 * Instance of this class.
	 *
	 * @var Auto_TOC_SEO
	 */
	private static $instance = null;

	/**
	 * Get instance of the class.
	 *
	 * @return Auto_TOC_SEO
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {
		$this->load_dependencies();
		$this->init_hooks();
	}

	/**
	 * Load required dependencies.
	 */
	private function load_dependencies() {
		require_once AUTO_TOC_SEO_PLUGIN_DIR . 'includes/class-toc-generator.php';
		require_once AUTO_TOC_SEO_PLUGIN_DIR . 'includes/class-schema-generator.php';
		require_once AUTO_TOC_SEO_PLUGIN_DIR . 'includes/class-settings.php';
		require_once AUTO_TOC_SEO_PLUGIN_DIR . 'includes/class-gutenberg-block.php';
	}

	/**
	 * Initialize WordPress hooks.
	 */
	private function init_hooks() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_assets' ) );
		add_action( 'init', array( $this, 'init_components' ) );
	}

	/**
   * Note: Translations are auto-loaded by WordPress.org for hosted plugins.
   */

	/**
	 * Enqueue frontend assets.
	 */
	public function enqueue_frontend_assets() {
		wp_enqueue_style(
			'auto-toc-seo-style',
			AUTO_TOC_SEO_PLUGIN_URL . 'assets/css/frontend.css',
			array(),
			AUTO_TOC_SEO_VERSION
		);

		wp_enqueue_script(
			'auto-toc-seo-script',
			AUTO_TOC_SEO_PLUGIN_URL . 'assets/js/frontend.js',
			array(),
			AUTO_TOC_SEO_VERSION,
			true
		);
	}

	/**
	 * Initialize plugin components.
	 */
	public function init_components() {
		Auto_TOC_SEO_Settings::get_instance();
		Auto_TOC_SEO_TOC_Generator::get_instance();
		Auto_TOC_SEO_Schema_Generator::get_instance();
		Auto_TOC_SEO_Gutenberg_Block::get_instance();
	}
}

/**
 * Initialize the plugin.
 */
function auto_toc_seo_init() {
	return Auto_TOC_SEO::get_instance();
}

// Start the plugin.
auto_toc_seo_init();

