/**
 * Arewa Recently Viewed Content - Admin Settings (Export/Import)
 *
 * @package Arewa_Recently_Viewed_Content
 */

(function() {
	'use strict';

	window.arwrevExportData = function() {
		if ( typeof arwrevAdminSettings === 'undefined' ) {
			console.error( 'arwrevAdminSettings is not defined.' );
			return;
		}
		var ajaxurl = arwrevAdminSettings.ajaxurl;
		var nonce   = arwrevAdminSettings.exportNonce;
		var i18n    = arwrevAdminSettings.i18n || {};

		fetch(
			ajaxurl,
			{
				method: 'POST',
				headers: {
					'Content-Type': 'application/x-www-form-urlencoded',
				},
				body: new URLSearchParams(
					{
						action: 'arwrev_export_data',
						nonce: nonce
					}
				)
			}
		)
		.then( function( response ) { return response.json(); } )
		.then(
			function( data ) {
				if ( data.success ) {
					var blob   = new Blob( [ data.data ], { type: 'application/json' } );
					var url    = window.URL.createObjectURL( blob );
					var a      = document.createElement( 'a' );
					a.href     = url;
					a.download = 'arwrev-backup-' + new Date().toISOString().split( 'T' )[0] + '.json';
					document.body.appendChild( a );
					a.click();
					window.URL.revokeObjectURL( url );
					document.body.removeChild( a );
					alert( i18n.backupExportedSuccess || 'Backup exported successfully!' );
				} else {
					alert( ( i18n.exportFailed || 'Export failed: ' ) + ( data.data || 'Unknown error' ) );
				}
			}
		)
		.catch(
			function( error ) {
				console.error( 'Export error:', error );
				alert( i18n.exportFailedRetry || 'Export failed. Please try again.' );
			}
		);
	};

	window.arwrevImportData = function() {
		if ( typeof arwrevAdminSettings === 'undefined' ) {
			console.error( 'arwrevAdminSettings is not defined.' );
			return;
		}
		var fileInput = document.getElementById( 'arwrev-import-file' );
		if ( ! fileInput ) {
			return;
		}
		var file = fileInput.files[0];
		var i18n = arwrevAdminSettings.i18n || {};

		if ( ! file ) {
			alert( i18n.pleaseSelectFile || 'Please select a backup file to import.' );
			return;
		}

		var reader    = new FileReader();
		reader.onload = function( e ) {
			var formData = new FormData();
			formData.append( 'action', 'arwrev_import_data' );
			formData.append( 'nonce', arwrevAdminSettings.importNonce );
			formData.append( 'backup_data', e.target.result );

			fetch(
				arwrevAdminSettings.ajaxurl,
				{
					method: 'POST',
					body: formData
				}
			)
			.then( function( response ) { return response.json(); } )
			.then(
				function( data ) {
					if ( data.success ) {
						alert( i18n.importSuccess || 'Data imported successfully! The page will reload to reflect changes.' );
						window.location.reload();
					} else {
						alert( ( i18n.importFailed || 'Import failed: ' ) + ( data.data || 'Unknown error' ) );
					}
				}
			)
			.catch(
				function( error ) {
					console.error( 'Import error:', error );
					alert( i18n.importFailedFormat || 'Import failed. Please check the file format and try again.' );
				}
			);
		};
		reader.readAsText( file );
	};
})();
