import "../../style.css";
import moment from "moment";
import TabView from "./TabView";
import TableView from "./TableView";
import CategoryView from "./CategoryView";
import { useEffect, useState } from "react";

function Calendar() {
	const [wpUserLoggedIn, setHasBodyClass] = useState(false);
	const [activeTab, setActiveTab] = useState(0);
	const [currentWeek, setCurrentWeek] = useState(moment());
	const [arena, setArena] = useState([]);
	const [categories, setCategories] = useState([]);
	const [freemiusStatus, setFreemiusStatus] = useState("");

	const handleTabSelect = (tabId) => {
		// Update active tab when a new tab is selected
		setActiveTab(tabId);
	};

	useEffect(() => {
		const checkBodyClass = () => {
			if (document.body.classList.contains("logged-in")) {
				setHasBodyClass(true);
			} else {
				setHasBodyClass(false);
			}
		};

		console.log(process.env.REACT_APP_ENV);
		if (process.env.REACT_APP_ENV === "local") {
			setFreemiusStatus(true);
		} else {
			// Otherwise, read the freemius-status meta tag
			const status = document.querySelector('meta[name="freemius-status"]')?.getAttribute('content');
			if (status === 'free') {
				setFreemiusStatus(false);
			} else {
				setFreemiusStatus(true);
			}
		}

		checkBodyClass();
	}, []);

	return (
		<div className={wpUserLoggedIn ? "admin-view" : "public-view"}>
			<TabView
				arena={arena}
				setArena={setArena}
				handleTabSelect={handleTabSelect}
			/>

			{activeTab > 0 && (
				<CategoryView
					categories={categories}
					setCategories={setCategories}
				/>
			)}

			{activeTab > 0 && (
				<TableView
					wpUserLoggedIn={wpUserLoggedIn}
					freemiusStatus={freemiusStatus}
					activeTab={activeTab}
					currentWeek={currentWeek}
					setCurrentWeek={setCurrentWeek}
					categories={categories}
					arena={arena}
				/>
			)}
		</div>
	);
}

export default Calendar;
