<?php

/**
 * Archivio Anchor -- Admin Page Template
 *
 * Rendered by MDSM_External_Anchoring::render_admin_page() as a standalone
 * Tools submenu page. All output is escaped. Token is never echoed in cleartext.
 *
 * @package ArchivioMD
 * @since   1.5.0
 * @updated 1.6.0 -- RFC 3161 TSA support
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'You do not have sufficient permissions to access this page.', 'archiviomd' ) );
}

$anchoring = MDSM_External_Anchoring::get_instance();
$settings  = $anchoring->get_settings();

$provider          = $settings['provider'];
$visibility        = $settings['visibility'];
$has_token         = ! empty( $settings['token'] );
$repo_owner        = $settings['repo_owner'];
$repo_name         = $settings['repo_name'];
$branch            = $settings['branch'];
$folder_path       = $settings['folder_path'];
$commit_msg        = $settings['commit_message'];
$rfc3161_provider  = $settings['rfc3161_provider'];
$rfc3161_custom    = $settings['rfc3161_custom_url'];
$rfc3161_username  = $settings['rfc3161_username'];
$has_rfc3161_pass  = ! empty( $settings['rfc3161_password'] );
$queue_count       = MDSM_Anchor_Queue::count();
$is_enabled        = $anchoring->is_enabled();
$active_providers  = $anchoring->get_active_providers();
$perm_failures     = (int) get_option( 'mdsm_anchor_perm_failures', 0 );
$log_retention     = (int) $settings['log_retention_days'];
$tsa_profiles      = MDSM_TSA_Profiles::all();
?>
<div class="wrap mdsm-anchor-wrap">
	<h1 class="mdsm-anchor-title">
		<span class="dashicons dashicons-admin-links" style="font-size:26px;margin-right:8px;vertical-align:middle;color:#2271b1;"></span>
		<?php esc_html_e( 'Git Distribution', 'archiviomd' ); ?>
	</h1>

	<p class="mdsm-anchor-intro">
		<?php esc_html_e( 'Push document integrity hashes to a Git repository (GitHub or GitLab) for tamper-evident, independently verifiable records. Anchoring runs asynchronously via WP-Cron and never interrupts document saving.', 'archiviomd' ); ?>
	</p>

	<?php if ( 'public' === $visibility && in_array( $provider, array( 'github', 'gitlab' ), true ) ) : ?>
	<div class="notice notice-warning mdsm-anchor-notice" id="mdsm-visibility-warning">
		<p>
			<strong><?php esc_html_e( 'Public Repository Warning:', 'archiviomd' ); ?></strong>
			<?php esc_html_e( 'You have selected a public repository. All anchored hash records — including document IDs, timestamps, hash values, and author names — will be publicly visible on your repository. Consider switching to a private repository unless public transparency is intentional.', 'archiviomd' ); ?>
		</p>
	</div>
	<?php endif; ?>

	<?php if ( $perm_failures > 0 ) : ?>
	<div class="notice notice-error mdsm-anchor-notice" id="mdsm-perm-failure-notice">
		<p>
			<strong><?php esc_html_e( 'Anchor Job Failure:', 'archiviomd' ); ?></strong>
			<?php
			echo esc_html(
				sprintf(
					/* translators: %d: number of permanently failed jobs */
					_n(
						'%d anchoring job permanently failed after all retries were exhausted. Check the Anchor Activity Log below for details.',
						'%d anchoring jobs permanently failed after all retries were exhausted. Check the Anchor Activity Log below for details.',
						$perm_failures,
						'archiviomd'
					),
					$perm_failures
				)
			);
			?>
		</p>
		<button type="button" class="notice-dismiss" id="mdsm-dismiss-fail-notice">
			<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'archiviomd' ); ?></span>
		</button>
	</div>
	<?php endif; ?>

	<?php
	// Separate git providers from RFC 3161 for this page's banners.
	$_git_active     = array_values( array_filter( $active_providers, function( $_pk ) { return 'rfc3161' !== $_pk; } ) );
	$_rfc3161_active = in_array( 'rfc3161', $active_providers, true );
	?>

	<?php if ( ! empty( $_git_active ) ) : ?>
	<div class="notice notice-success mdsm-anchor-notice" style="border-left-color:#00a32a;">
		<p>
			<strong><?php esc_html_e( 'Anchoring Active', 'archiviomd' ); ?></strong> —
			<?php
			$_provider_labels = array_map( 'strtoupper', $_git_active );
			/* translators: %s: comma-separated list of provider names */
			echo esc_html( sprintf( __( 'Documents will be anchored to %s asynchronously via WP-Cron.', 'archiviomd' ), implode( ' + ', $_provider_labels ) ) );
			?>
		</p>
	</div>
	<?php endif; ?>

	<?php if ( $_rfc3161_active ) : ?>
	<div class="notice notice-info mdsm-anchor-notice">
		<p>
			<?php esc_html_e( 'RFC 3161 Trusted Timestamps are active. TSA settings and the full timestamp explainer are on the', 'archiviomd' ); ?>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=archivio-rfc3161' ) ); ?>"><?php esc_html_e( 'Trusted Timestamps page', 'archiviomd' ); ?></a>.
		</p>
	</div>
	<?php endif; ?>

	<!-- Status bar -->
	<div class="mdsm-anchor-status-bar">
		<div class="mdsm-anchor-status-item">
			<span class="mdsm-anchor-label"><?php esc_html_e( 'Provider(s):', 'archiviomd' ); ?></span>
			<strong>
				<?php
				// This page is for Git providers only; RFC 3161 is managed on the Trusted Timestamps page.
				$_git_providers = array_filter( $active_providers, function( $_pk ) {
					return 'rfc3161' !== $_pk;
				} );
				if ( empty( $_git_providers ) ) {
					echo esc_html__( 'None (disabled)', 'archiviomd' );
				} else {
					$_status_labels = array();
					foreach ( $_git_providers as $_pk ) {
						$_status_labels[] = strtoupper( $_pk );
					}
					echo esc_html( implode( ' + ', $_status_labels ) );
				}
				?>
			</strong>
		</div>
		<div class="mdsm-anchor-status-item">
			<span class="mdsm-anchor-label"><?php esc_html_e( 'Queue:', 'archiviomd' ); ?></span>
			<strong id="mdsm-queue-count"><?php echo esc_html( $queue_count ); ?></strong>
			<?php esc_html_e( 'pending job(s)', 'archiviomd' ); ?>
		</div>
		<div class="mdsm-anchor-status-item">
			<span class="mdsm-anchor-label"><?php esc_html_e( 'Next cron run:', 'archiviomd' ); ?></span>
			<?php
			$next = wp_next_scheduled( MDSM_External_Anchoring::CRON_HOOK );
			if ( $next ) {
				$diff = $next - time();
				echo esc_html( $diff > 0
					? sprintf( esc_html__(  'in %d minute(s)', 'archiviomd' ), max( 1, ceil( $diff / 60 ) ) )
					: __( 'imminent', 'archiviomd' )
				);
			} else {
				esc_html_e( 'not scheduled', 'archiviomd' );
			}
			?>
		</div>
	</div>

	<!-- Settings card -->
	<div class="mdsm-anchor-card">
		<h2 class="mdsm-anchor-card-title"><?php esc_html_e( 'Anchoring Configuration', 'archiviomd' ); ?></h2>

		<div id="mdsm-anchor-feedback" class="mdsm-anchor-feedback" style="display:none;"></div>

		<table class="form-table mdsm-anchor-table" role="presentation">

			<!-- Provider -->
			<tr>
				<th scope="row">
					<label for="mdsm-provider"><?php esc_html_e( 'Anchoring Provider', 'archiviomd' ); ?></label>
				</th>
				<td>
					<select id="mdsm-provider" name="provider" class="regular-text">
						<option value="none"    <?php selected( $provider, 'none' ); ?>><?php esc_html_e( 'None (disabled)', 'archiviomd' ); ?></option>
						<option value="github"  <?php selected( $provider, 'github' ); ?>><?php esc_html_e( 'GitHub', 'archiviomd' ); ?></option>
						<option value="gitlab"  <?php selected( $provider, 'gitlab' ); ?>><?php esc_html_e( 'GitLab', 'archiviomd' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Select the Git provider for this installation. RFC 3161 timestamping is configured independently on the Trusted Timestamps page.', 'archiviomd' ); ?></p>
				</td>
			</tr>

			<!-- ═══════════════════════════════════════════════════════════════ -->
			<!-- Git provider fields — shown for GitHub / GitLab                -->
			<!-- ═══════════════════════════════════════════════════════════════ -->

			<!-- Visibility -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-visibility"><?php esc_html_e( 'Repository Visibility', 'archiviomd' ); ?></label>
				</th>
				<td>
					<select id="mdsm-visibility" name="visibility" class="regular-text">
						<option value="private" <?php selected( $visibility, 'private' ); ?>><?php esc_html_e( 'Private (recommended)', 'archiviomd' ); ?></option>
						<option value="public"  <?php selected( $visibility, 'public' ); ?>><?php esc_html_e( 'Public — metadata will be publicly exposed', 'archiviomd' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'This setting is informational — it documents your intent and controls the public-visibility warning. The repository must already exist with the correct visibility on the provider.', 'archiviomd' ); ?></p>
				</td>
			</tr>

			<!-- Token -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-token"><?php esc_html_e( 'Personal Access Token', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input
						type="password"
						id="mdsm-token"
						name="token"
						class="regular-text"
						autocomplete="new-password"
						placeholder="<?php echo $has_token ? esc_attr__( '(token saved — enter new value to replace)', 'archiviomd' ) : esc_attr__( 'Paste your PAT here', 'archiviomd' ); ?>"
						value=""
					/>
					<?php if ( $has_token ) : ?>
						<span class="mdsm-token-saved"><?php esc_html_e( '✓ Token saved', 'archiviomd' ); ?></span>
					<?php endif; ?>
					<p class="description">
						<?php esc_html_e( 'The token is stored securely in the WordPress database and never printed in source code, JavaScript, or logs. Leave blank to keep the current token.', 'archiviomd' ); ?><br>
						<strong><?php esc_html_e( 'GitHub:', 'archiviomd' ); ?></strong> <?php esc_html_e( 'Requires the "Contents" repository permission (read & write).', 'archiviomd' ); ?><br>
						<strong><?php esc_html_e( 'GitLab:', 'archiviomd' ); ?></strong> <?php esc_html_e( 'Requires the "api" scope.', 'archiviomd' ); ?>
					</p>
				</td>
			</tr>

			<!-- Repo Owner -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-repo-owner"><?php esc_html_e( 'Repository Owner / Group', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="text" id="mdsm-repo-owner" name="repo_owner" class="regular-text"
						value="<?php echo esc_attr( $repo_owner ); ?>"
						placeholder="<?php esc_attr_e( 'e.g. myusername or my-org', 'archiviomd' ); ?>" />
					<p class="description"><?php esc_html_e( 'GitHub: your username or organisation. GitLab: your username or group path.', 'archiviomd' ); ?></p>
				</td>
			</tr>

			<!-- Repo Name -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-repo-name"><?php esc_html_e( 'Repository Name', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="text" id="mdsm-repo-name" name="repo_name" class="regular-text"
						value="<?php echo esc_attr( $repo_name ); ?>"
						placeholder="<?php esc_attr_e( 'e.g. document-hashes', 'archiviomd' ); ?>" />
				</td>
			</tr>

			<!-- Branch -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-branch"><?php esc_html_e( 'Branch', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="text" id="mdsm-branch" name="branch" class="regular-text"
						value="<?php echo esc_attr( $branch ); ?>"
						placeholder="main" />
					<p class="description"><?php esc_html_e( 'The branch must already exist in the repository.', 'archiviomd' ); ?></p>
				</td>
			</tr>

			<!-- Folder Path -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-folder-path"><?php esc_html_e( 'Folder Path', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="text" id="mdsm-folder-path" name="folder_path" class="regular-text"
						value="<?php echo esc_attr( $folder_path ); ?>"
						placeholder="hashes/YYYY-MM-DD" />
					<p class="description">
						<?php esc_html_e( 'Path within the repository where anchor files are stored. Supports date tokens: YYYY, MM, DD.', 'archiviomd' ); ?>
						<?php esc_html_e( 'Example: hashes/YYYY-MM-DD → hashes/2025-06-15/', 'archiviomd' ); ?>
					</p>
				</td>
			</tr>

			<!-- Commit message -->
			<tr class="mdsm-anchor-git-field">
				<th scope="row">
					<label for="mdsm-commit-message"><?php esc_html_e( 'Commit Message Template', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="text" id="mdsm-commit-message" name="commit_message" class="large-text"
						value="<?php echo esc_attr( $commit_msg ); ?>"
						placeholder="chore: anchor {doc_id}" />
					<p class="description"><?php esc_html_e( 'Use {doc_id} as a placeholder for the document identifier.', 'archiviomd' ); ?></p>
				</td>
			</tr>

			<tr>
				<th scope="row">
					<label for="mdsm-log-retention"><?php esc_html_e( 'Log Retention', 'archiviomd' ); ?></label>
				</th>
				<td>
					<input type="number" id="mdsm-log-retention" name="log_retention_days" min="0" step="1"
						value="<?php echo esc_attr( $log_retention ); ?>" style="width:90px;" />
					<span class="description">
						<?php esc_html_e( 'days (0 = keep forever). Older entries are pruned daily.', 'archiviomd' ); ?>
					</span>
				</td>
			</tr>

		</table>

		<!-- Action buttons -->
		<div class="mdsm-anchor-actions">
			<button type="button" id="mdsm-anchor-save" class="button button-primary">
				<?php esc_html_e( 'Save Settings', 'archiviomd' ); ?>
			</button>

			<button type="button" id="mdsm-anchor-test" class="button button-secondary" id="mdsm-anchor-test">
				<?php esc_html_e( 'Test Connection', 'archiviomd' ); ?>
			</button>
		</div>

		<!-- Test result area -->
		<div id="mdsm-test-result" class="mdsm-anchor-test-result" style="display:none;"></div>
	</div>


	<!-- Queue management card -->
	<div class="mdsm-anchor-card">
		<h2 class="mdsm-anchor-card-title"><?php esc_html_e( 'Anchor Queue', 'archiviomd' ); ?></h2>

		<p>
			<?php esc_html_e( 'The queue holds pending anchor jobs. Jobs run every 5 minutes via WP-Cron. Failed jobs are retried automatically using exponential back-off (up to 5 attempts).', 'archiviomd' ); ?>
		</p>

		<div class="mdsm-anchor-status-item" style="margin-bottom:12px;">
			<span class="mdsm-anchor-label"><?php esc_html_e( 'Pending jobs:', 'archiviomd' ); ?></span>
			<strong id="mdsm-queue-count-detail"><?php echo esc_html( $queue_count ); ?></strong>
		</div>

		<button type="button" id="mdsm-anchor-clear-queue" class="button button-secondary" <?php echo $queue_count === 0 ? 'disabled' : ''; ?>>
			<?php esc_html_e( 'Clear Anchor Queue', 'archiviomd' ); ?>
		</button>
		<p class="description" style="margin-top:6px;">
			<?php esc_html_e( 'Clears all pending and failed anchor jobs. Hashes already stored in the database are unaffected.', 'archiviomd' ); ?>
		</p>

		<div id="mdsm-queue-feedback" class="mdsm-anchor-feedback" style="display:none;margin-top:10px;"></div>
	</div>

	<!-- Activity Log card -->
	<div class="mdsm-anchor-card">
		<h2 class="mdsm-anchor-card-title"><?php esc_html_e( 'Anchor Activity Log', 'archiviomd' ); ?></h2>

		<?php
		$log_counts    = MDSM_Anchor_Log::get_counts( 'git' );
		$is_rfc3161    = in_array( 'rfc3161', $active_providers, true );
		$zip_available = class_exists( 'ZipArchive' );
		$upload_dir    = wp_upload_dir();
		$tsr_dir       = trailingslashit( $upload_dir['basedir'] ) . 'meta-docs/tsr-timestamps';
		$tsr_count     = is_dir( $tsr_dir ) ? count( glob( $tsr_dir . '/*.tsr' ) ?: array() ) : 0;
		?>

		<!-- Summary badges -->
		<div class="mdsm-anchor-log-summary">
			<span class="mdsm-log-badge mdsm-log-badge--all active" data-filter="all">
				<?php esc_html_e( 'All', 'archiviomd' ); ?>
				<strong><?php echo esc_html( $log_counts['total'] ); ?></strong>
			</span>
			<span class="mdsm-log-badge mdsm-log-badge--anchored" data-filter="anchored">
				<?php esc_html_e( 'Anchored', 'archiviomd' ); ?>
				<strong><?php echo esc_html( $log_counts['anchored'] ); ?></strong>
			</span>
			<span class="mdsm-log-badge mdsm-log-badge--retry" data-filter="retry">
				<?php esc_html_e( 'Retry', 'archiviomd' ); ?>
				<strong><?php echo esc_html( $log_counts['retry'] ); ?></strong>
			</span>
			<span class="mdsm-log-badge mdsm-log-badge--failed" data-filter="failed">
				<?php esc_html_e( 'Failed', 'archiviomd' ); ?>
				<strong><?php echo esc_html( $log_counts['failed'] ); ?></strong>
			</span>
		</div>

		<!-- Log table: sits in its own scroll container that spans edge-to-edge of the card.
		     margin+width trick: negative margins shift the div left/right, calc(100%+56px)
		     gives it the extra width so overflow-x:auto has a real scroll range to work with. -->
		<div id="mdsm-log-table-wrap" style="margin-top:16px;margin-left:-28px;width:calc(100% + 56px);overflow-x:auto;-webkit-overflow-scrolling:touch;">
			<table id="mdsm-log-table" style="border-collapse:collapse;white-space:nowrap;font-size:12.5px;width:max-content;min-width:100%;">
				<thead>
					<tr style="background:#f6f7f7;border-bottom:2px solid #c3c4c7;">
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Timestamp (UTC)', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Status', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Document ID', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Provider', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Algorithm', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Hash (truncated)', 'archiviomd' ); ?></th>
						<th style="padding:8px 14px;text-align:left;font-weight:600;color:#1d2327;"><?php esc_html_e( 'Anchor / TSR', 'archiviomd' ); ?></th>
					</tr>
				</thead>
				<tbody id="mdsm-log-tbody">
					<tr><td colspan="7" style="text-align:center;padding:20px;color:#666;white-space:normal;">
						<?php esc_html_e( 'Loading…', 'archiviomd' ); ?>
					</td></tr>
				</tbody>
			</table>

			<div id="mdsm-log-pagination" style="margin-top:10px;display:flex;align-items:center;gap:8px;">
				<button type="button" id="mdsm-log-prev" class="button button-secondary" disabled>
					&laquo; <?php esc_html_e( 'Prev', 'archiviomd' ); ?>
				</button>
				<span id="mdsm-log-page-info" style="font-size:12px;color:#666;"></span>
				<button type="button" id="mdsm-log-next" class="button button-secondary" disabled>
					<?php esc_html_e( 'Next', 'archiviomd' ); ?> &raquo;
				</button>
			</div>

			<div id="mdsm-log-feedback" class="mdsm-anchor-feedback" style="display:none;margin-top:8px;"></div>
		</div>

		<!-- Export actions -->
		<div class="mdsm-anchor-actions" style="margin-top:18px;flex-wrap:wrap;gap:8px;">

			<a href="<?php echo esc_url( add_query_arg( array(
				'action' => 'mdsm_anchor_download_log',
				'nonce'  => wp_create_nonce( 'mdsm_anchor_nonce' ),
			), admin_url( 'admin-ajax.php' ) ) ); ?>"
			   class="button button-secondary">
				<span class="dashicons dashicons-media-text" style="vertical-align:middle;margin-top:-2px;"></span>
				<?php esc_html_e( 'Export .txt Log', 'archiviomd' ); ?>
			</a>

			<a href="<?php echo esc_url( add_query_arg( array(
				'action' => 'mdsm_anchor_download_csv',
				'nonce'  => wp_create_nonce( 'mdsm_anchor_nonce' ),
			), admin_url( 'admin-ajax.php' ) ) ); ?>"
			   class="button button-secondary">
				<span class="dashicons dashicons-list-view" style="vertical-align:middle;margin-top:-2px;"></span>
				<?php esc_html_e( 'Export .csv (Auditor)', 'archiviomd' ); ?>
			</a>

			<?php if ( $is_rfc3161 ) : ?>
			<a href="<?php echo esc_url( add_query_arg( array(
				'action' => 'mdsm_anchor_download_tsr_zip',
				'nonce'  => wp_create_nonce( 'mdsm_anchor_nonce' ),
			), admin_url( 'admin-ajax.php' ) ) ); ?>"
			   class="button button-secondary"
			   <?php echo ( ! $zip_available || $tsr_count === 0 ) ? 'disabled title="' . esc_attr( ! $zip_available ? __( 'PHP ZipArchive extension not available on this server', 'archiviomd' ) : __( 'No .tsr files stored yet', 'archiviomd' ) ) . '"' : ''; ?>>
				<span class="dashicons dashicons-archive" style="vertical-align:middle;margin-top:-2px;"></span>
				<?php
				echo esc_html( sprintf(
					/* translators: %d: number of .tsr files */
					__( 'Download .tsr Archive (%d files)', 'archiviomd' ),
					$tsr_count
				) );
				?>
			</a>
			<?php endif; ?>

		</div>

		<p class="description" style="margin-top:8px;">
			<?php esc_html_e( 'The .txt and .csv exports contain the complete log history with all hash values. The .csv is formatted for Excel and Google Sheets and suitable for auditor handoff. For RFC 3161: the .tsr archive contains all timestamp token binary files verifiable offline with OpenSSL, plus a MANIFEST.txt with SHA-256 checksums of every file.', 'archiviomd' ); ?>
		</p>

		<!-- Danger zone -->
		<div style="margin-top:24px;padding:14px 16px;border:1px solid #d63638;border-radius:4px;background:#fef6f6;">
			<h3 style="margin:0 0 6px;color:#d63638;font-size:13px;">
				<?php esc_html_e( 'Danger Zone', 'archiviomd' ); ?>
			</h3>
			<p style="margin:0 0 10px;font-size:12px;color:#50575e;">
				<?php esc_html_e( 'Clearing the log permanently deletes all anchor activity records from the database. TSR files on disk are not deleted. Export before clearing if you need to retain a record.', 'archiviomd' ); ?>
			</p>
			<button type="button" id="mdsm-anchor-clear-log" class="button"
				style="border-color:#d63638;color:#d63638;"
				<?php echo $log_counts['total'] === 0 ? 'disabled' : ''; ?>>
				<?php esc_html_e( 'Clear Entire Log…', 'archiviomd' ); ?>
			</button>
		</div>

		<!-- Confirmation modal (hidden) -->
		<div id="mdsm-clear-log-modal" style="display:none;position:fixed;inset:0;background:rgba(0,0,0,.6);z-index:100000;align-items:center;justify-content:center;">
			<div style="background:#fff;border-radius:6px;padding:28px 32px;max-width:420px;width:90%;box-shadow:0 8px 32px rgba(0,0,0,.25);">
				<h2 style="margin:0 0 10px;font-size:16px;color:#d63638;">
					&#9888; <?php esc_html_e( 'Clear Anchor Log?', 'archiviomd' ); ?>
				</h2>
				<p style="margin:0 0 6px;font-size:13px;color:#50575e;">
					<?php
					echo esc_html( sprintf(
						/* translators: %d: number of log entries */
						__( 'This will permanently delete all %d log entries from the database. This cannot be undone.', 'archiviomd' ),
						(int) $log_counts['total']
					) );
					?>
				</p>
				<p style="margin:0 0 14px;font-size:13px;color:#50575e;">
					<?php esc_html_e( 'Type CLEAR LOG below to confirm:', 'archiviomd' ); ?>
				</p>
				<input type="text" id="mdsm-clear-log-confirm-input"
					placeholder="<?php esc_attr_e( 'CLEAR LOG', 'archiviomd' ); ?>"
					style="width:100%;margin-bottom:16px;font-size:13px;"
					class="regular-text" autocomplete="off" />
				<div style="display:flex;gap:10px;justify-content:flex-end;">
					<button type="button" id="mdsm-clear-log-cancel" class="button button-secondary">
						<?php esc_html_e( 'Cancel', 'archiviomd' ); ?>
					</button>
					<button type="button" id="mdsm-clear-log-confirm" class="button" disabled
						style="border-color:#d63638;color:#fff;background:#d63638;opacity:.5;">
						<?php esc_html_e( 'Yes, Clear Log', 'archiviomd' ); ?>
					</button>
				</div>
				<div id="mdsm-clear-log-modal-feedback" class="mdsm-anchor-feedback" style="display:none;margin-top:12px;"></div>
			</div>
		</div>

	</div>

	<!-- How anchoring works card -->
	<div class="mdsm-anchor-card mdsm-anchor-card-info">
		<h2 class="mdsm-anchor-card-title"><?php esc_html_e( 'How External Anchoring Works', 'archiviomd' ); ?></h2>

		<ol class="mdsm-anchor-howto">
			<li><?php esc_html_e( 'When a WordPress post/page is saved or a Markdown document is updated, ArchivioMD computes its integrity hash (SHA-256/SHA-512/BLAKE2b, with optional HMAC).', 'archiviomd' ); ?></li>
			<li><?php esc_html_e( 'A lightweight JSON anchor record is placed in the queue — this takes milliseconds and never delays saving.', 'archiviomd' ); ?></li>
			<li><?php esc_html_e( 'WP-Cron dispatches the queue every 5 minutes, pushing each record as a JSON file to your chosen repository.', 'archiviomd' ); ?></li>
			<li><?php esc_html_e( 'If the provider API is unreachable, the job is automatically retried with exponential back-off. All failures are written to the ArchivioMD audit log.', 'archiviomd' ); ?></li>
			<li><?php esc_html_e( 'Each anchored JSON file contains: Document ID, Post ID (if applicable), post type, hash algorithm, hash value, HMAC value (if enabled), author, timestamp, plugin version, and integrity mode.', 'archiviomd' ); ?></li>
		</ol>

		<div class="mdsm-anchor-note">
			<strong><?php esc_html_e( 'Security note:', 'archiviomd' ); ?></strong>
			<?php esc_html_e( 'Your API token is stored in the WordPress database (wp_options) and is never printed in HTML source, JavaScript, or log files. Ensure your database connection is secured via SSL and that wp-config.php has appropriate file permissions.', 'archiviomd' ); ?>
		</div>
	</div>

</div><!-- .mdsm-anchor-wrap -->
