jQuery(document).ready(function($) {
    // Hide the message box initially
    $('#aptranet-cdn-message').hide();

    // If there's a saved distribution ID on page load, set the Manage Distribution button
    var savedDistId = $('#aptranet_cdn_distribution').val();
    toggleManageDistributionButton(savedDistId);

    // Handle the Fetch Distributions button click.
    $('#fetch-distributions').on('click', function(e) {
        e.preventDefault();
        
        // Clear old messages and show a "fetching" message
        $('#aptranet-cdn-message')
            .show()
            .html('Fetching distributions...');

        $.ajax({
            url: aptranetCdn.ajax_url,
            method: 'POST',
            data: {
                action: 'aptranet_cdn_fetch_distributions',
                nonce: aptranetCdn.nonce
            },
            success: function(response) {
                if (response.success) {
                    var distributions = response.data;
                    var $dropdown = $('#aptranet_cdn_distribution');
                    $dropdown.empty();
                    $dropdown.append('<option value="">-- Select Distribution --</option>');
                    
                    // Populate the dropdown using ID, name, and hostname
                    $.each(distributions, function(index, dist) {
                        var label = dist.name ? dist.name : ('Distribution ' + dist.id);
                        $dropdown.append(
                            '<option value="' + dist.id + '" data-name="' + dist.name + '" data-hostname="' + dist.hostname + '">' +
                            label +
                            '</option>'
                        );
                    });
                    $('#aptranet-cdn-message')
                        .show()
                        .html('<span style="color:green;">Distributions fetched successfully.</span>');
                } else {
                    $('#aptranet-cdn-message')
                        .show()
                        .html('<span style="color:red;">Error: ' + response.data + '</span>');
                }
            },
            error: function(xhr, status, error) {
                $('#aptranet-cdn-message')
                    .show()
                    .html('<span style="color:red;">AJAX error: ' + error + '</span>');
            }
        });
    });

    // When a distribution is selected, update the read-only CDN base URL field, the hidden name field,
    // and the "Manage Distribution" button.
    $('#aptranet_cdn_distribution').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var distId   = selectedOption.val();
        var distName = selectedOption.data('name') || '';
        var hostname = selectedOption.data('hostname') || '';

        // Store the distribution name in the hidden field
        $('#aptranet_cdn_distribution_name').val(distName);

        // Construct the CDN URL using the hostname
        var cdnUrl = hostname ? 'https://' + hostname + '/' : '';
        $('#aptranet_cdn_base_url').val(cdnUrl);

        // Update the Manage Distribution button link
        toggleManageDistributionButton(distId);
    });

    // Show spinner overlay when user clicks "Save Changes"
    $('#aptranet-cdn-save-button').on('click', function() {
        $('#aptranet-cdn-save-spinner-overlay').show();
    });

    /**
     * Show/hide the "Manage Distribution" button based on distribution ID.
     */
    function toggleManageDistributionButton(distId) {
        var $manageBtn = $('#aptranet-manage-distribution');
        if (distId) {
            var consoleUrl = 'https://console.aptranet.com/cdn/distributions/' + distId + '/analytics';
            $manageBtn.attr('href', consoleUrl).show();
        } else {
            $manageBtn.hide();
        }
    }
});
