<?php
/**
 * Widget: UTM Smart Welcome (Lite)
 */
class MMAWL_UTM_Welcome_Widget extends MMAWL_Widget_Base {

    public function get_name()   { return 'mmawl-utm-welcome'; }
    public function get_title()  { return __( 'APPSADM – UTM Smart Welcome', 'appsadm-utm-widgets-for-elementor' ); }
    public function get_icon()   { return 'eicon-editor-bold'; }
    public function get_categories() { return [ 'appsadm-utm-widgets' ]; }

    /*-------------------------------------------------------------------
     * Controls
     *------------------------------------------------------------------*/
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [ 'label' => __( 'Message', 'appsadm-utm-widgets-for-elementor' ) ]
        );

        $this->add_control(
            'utm_source',
            [
                'label'       => __( 'UTM Source equals…', 'appsadm-utm-widgets-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => 'facebook',
            ]
        );

        $this->add_control(
            'message',
            [
                'label'       => __( 'Message', 'appsadm-utm-widgets-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => 'Welcome, {utm_source} visitor!',
                'default'     => 'Welcome!',
            ]
        );

        $this->add_control(
            'fallback',
            [
                'label'       => __( 'Fallback Message', 'appsadm-utm-widgets-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => __( 'Hello there!', 'appsadm-utm-widgets-for-elementor' ),
            ]
        );

        $this->end_controls_section();
    }

    /*-------------------------------------------------------------------
     * Output
     *------------------------------------------------------------------*/
    protected function render() {
        $s = $this->get_settings_for_display();

        // Leer de forma segura sin acceder directamente a $_GET
        $utm_raw = filter_input( INPUT_GET, 'utm_source', FILTER_SANITIZE_FULL_SPECIAL_CHARS );
        $utm     = $utm_raw ? sanitize_text_field( wp_unslash( $utm_raw ) ) : '';

        if ( $utm && strtolower( $utm ) === strtolower( $s['utm_source'] ) ) {
            $msg = str_replace( '{utm_source}', esc_html( $utm ), $s['message'] );
        } else {
            $msg = $s['fallback'];
        }

        echo '<div class="mmawl-utm-welcome">' . wp_kses_post( $msg ) . '</div>';
    }
}
