<?php
/**
 * Widget: Sticky CTA (Lite con lógica UTM)
 */
class MMAWL_Sticky_CTA_Widget extends MMAWL_Widget_Base {

    public function get_name()   { return 'mmawl-sticky-cta'; }
    public function get_title()  { return __( 'APPSADM – Sticky CTA', 'appsadm-utm-widgets-for-elementor' ); }
    public function get_icon()   { return 'eicon-button'; }
    public function get_categories() { return [ 'appsadm-utm-widgets' ]; }

    /*-------------------------------------------------------------------
     *  Controls
     *------------------------------------------------------------------*/
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [ 'label' => __( 'CTA', 'appsadm-utm-widgets-for-elementor' ) ]
        );

        $this->add_control(
            'text',
            [
                'label'   => __( 'Button Text', 'appsadm-utm-widgets-for-elementor' ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Book Now', 'appsadm-utm-widgets-for-elementor' ),
            ]
        );

        $this->add_control(
            'url',
            [
                'label'       => __( 'URL', 'appsadm-utm-widgets-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com',
                'default'     => [ 'url' => '#' ],
            ]
        );

        $this->add_control(
            'position',
            [
                'label'   => __( 'Position', 'appsadm-utm-widgets-for-elementor' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'bottom-right' => __( 'Bottom-Right', 'appsadm-utm-widgets-for-elementor' ),
                    'bottom-left'  => __( 'Bottom-Left',  'appsadm-utm-widgets-for-elementor' ),
                ],
                'default' => 'bottom-right',
            ]
        );

        $this->add_control(
            'enable_utm_logic',
            [
                'label'        => __( 'Enable UTM Logic', 'appsadm-utm-widgets-for-elementor' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'appsadm-utm-widgets-for-elementor' ),
                'label_off'    => __( 'No', 'appsadm-utm-widgets-for-elementor' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'utm_rules',
            [
                'label'       => __( 'UTM Rules', 'appsadm-utm-widgets-for-elementor' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => [
                    [
                        'name'  => 'utm_key',
                        'label' => __( 'UTM Key (e.g., utm_source)', 'appsadm-utm-widgets-for-elementor' ),
                        'type'  => \Elementor\Controls_Manager::TEXT,
                    ],
                    [
                        'name'  => 'utm_value',
                        'label' => __( 'UTM Value (e.g., facebook)', 'appsadm-utm-widgets-for-elementor' ),
                        'type'  => \Elementor\Controls_Manager::TEXT,
                    ],
                    [
                        'name'  => 'utm_text',
                        'label' => __( 'Button Text', 'appsadm-utm-widgets-for-elementor' ),
                        'type'  => \Elementor\Controls_Manager::TEXT,
                    ],
                    [
                        'name'  => 'utm_url',
                        'label' => __( 'Button URL', 'appsadm-utm-widgets-for-elementor' ),
                        'type'  => \Elementor\Controls_Manager::URL,
                    ],
                ],
                'default' => [],
                'condition' => [ 'enable_utm_logic' => 'yes' ],
            ]
        );

        $this->end_controls_section();
    }

    /*-------------------------------------------------------------------
     *  Output
     *------------------------------------------------------------------*/
    protected function render() {
        $s      = $this->get_settings_for_display();
        $text   = $s['text'];
        $url    = $s['url']['url'] ?: '#';
        $target = $s['url']['is_external'] ? '_blank' : '_self';

        // Obtiene todos los parámetros GET de forma segura.
        $query_params = filter_input_array( INPUT_GET, FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ?: [];

        if ( 'yes' === $s['enable_utm_logic'] && ! empty( $s['utm_rules'] ) ) {
            foreach ( $s['utm_rules'] as $rule ) {
                $key   = $rule['utm_key'];
                $value = $rule['utm_value'];

                if ( isset( $query_params[ $key ] ) && sanitize_text_field( wp_unslash( $query_params[ $key ] ) ) === $value ) {
                    $text   = $rule['utm_text'] ?: $text;
                    $url    = $rule['utm_url']['url'] ?: $url;
                    $target = $rule['utm_url']['is_external'] ? '_blank' : '_self';
                    break;
                }
            }
        }

        printf(
            '<a href="%1$s" class="mmawl-sticky-cta %2$s" target="%3$s" rel="noopener">%4$s</a>',
            esc_url( $url ),
            esc_attr( $s['position'] ),
            esc_attr( $target ),
            esc_html( $text )
        );
    }

    public function get_style_depends() {
        wp_register_style(
            'mmawl-sticky-cta-inline',
            false,
            [],
            MMAWL_VERSION
        );
        wp_add_inline_style(
            'mmawl-sticky-cta-inline',
            '.mmawl-sticky-cta{position:fixed;z-index:9999;padding:12px 20px;border-radius:4px;background:#007cba;color:#fff;font-weight:600;text-decoration:none}.mmawl-sticky-cta.bottom-right{bottom:20px;right:20px}.mmawl-sticky-cta.bottom-left{bottom:20px;left:20px}.mmawl-sticky-cta:hover{background:#006ba1}'
        );
        return [ 'mmawl-sticky-cta-inline' ];
    }
}
