<?php
/**
 * Plugin Name: APPSADM UTM Widgets for Elementor
 * Plugin URI:  https://appsadm.com/widgets-lite
 * Description: Two free Elementor widgets — Smart UTM Welcome and Sticky CTA. Upgrade to Pro for 4 extra marketing widgets.
 * Version:     1.0.0
 * Author:      APPSADM
 * Author URI:  https://appsadm.com
 * Text Domain: appsadm-utm-widgets-for-elementor
 * Requires Plugins: elementor
 * Requires PHP: 7.4
 * Requires at least: 6.0
 * Tested up to: 6.8.1
 * Elementor tested up to: 3.29.2
 * License: GPL-2.0+
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'MMAWL_VERSION', '1.0.0' );
define( 'MMAWL_PATH', plugin_dir_path( __FILE__ ) );
define( 'MMAWL_URL',  plugin_dir_url(  __FILE__ ) );

add_action( 'plugins_loaded', function () {
	if ( ! did_action( 'elementor/loaded' ) ) {
		add_action( 'admin_notices', function () {
			echo '<div class="notice notice-error"><p><strong>APPSADM UTM Widgets</strong> requiere que Elementor esté instalado y activo.</p></div>';
		} );
		return;
	}

	// ✅ Categoría personalizada (fuera del hook de registro de widgets)
	add_action( 'elementor/elements/categories_registered', function( $elements_manager ) {
		$elements_manager->add_category(
			'appsadm-utm-widgets',
			[
				'title' => __( 'APPSADM UTM Widgets for Elementor', 'appsadm-utm-widgets-for-elementor' ),
				'icon'  => 'eicon-plugin',
			]
		);
	});

	// Encola estilos comunes
	add_action( 'wp_enqueue_scripts', function () {
		wp_register_style(
			'mmawl-common',
			MMAWL_URL . 'assets/css/mma-widgets-common.css',
			[],
			MMAWL_VERSION
		);
		wp_enqueue_style( 'mmawl-common' );
	} );

	// Registra los widgets
	add_action( 'elementor/widgets/register', function ( $widgets_manager ) {
		require_once MMAWL_PATH . 'includes/class-widget-base.php';
		require_once MMAWL_PATH . 'includes/class-utm-welcome-widget.php';
		require_once MMAWL_PATH . 'includes/class-sticky-cta-widget.php';

		$widgets_manager->register( new MMAWL_UTM_Welcome_Widget() );
		$widgets_manager->register( new MMAWL_Sticky_CTA_Widget() );
	} );
} );
