<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$randomId = uniqid('aac-');


wp_register_script('appiapp-carousel-js-'.$randomId, false, array(), '1.0.0', true);


$custom_css = $attributes['customCss'] ?? '';
if(!empty($custom_css)){
    //echo '<style>'.$custom_css.'</style>';
    // Usa un handle unico per ogni blocco    
    wp_register_style('appiapp-carousel-css-'.$randomId, false, array(), '1.0.0');
    wp_enqueue_style('appiapp-carousel-css-'.$randomId);
    wp_add_inline_style('appiapp-carousel-css-'.$randomId, str_replace('selector', '.'.$randomId, $custom_css));
}

$carousel_type = esc_attr($attributes['carouselType']) ?? 'embla';


$override_options = "";
if($carousel_type === 'swiper' && !empty($attributes['swiperOptions']['overrideOptions'])){

    $override_options = $attributes['swiperOptions']['overrideOptions'];

    /*
    echo "<script>
    window.swiperOverrideOptions = window.swiperOverrideOptions || {};
    window.swiperOverrideOptions['{$randomId}'] = function(carouselEl) { 
        {$override_options}
    }
    </script>";
    */

    $inline_script = "window.swiperOverrideOptions = window.swiperOverrideOptions || {};
    window.swiperOverrideOptions['{$randomId}'] = function(carouselEl) { 
        {$override_options}
    }";

    wp_add_inline_script('appiapp-carousel-js-'.$randomId, $inline_script);

    unset($attributes['swiperOptions']['overrideOptions']);   

}

if($carousel_type === 'embla' && !empty($attributes['emblaOptions']['overrideOptions'])){

    $override_options = $attributes['emblaOptions']['overrideOptions'];

    /*
    echo "<script>
    window.emblaOverrideOptions = window.emblaOverrideOptions || {};
    window.emblaOverrideOptions['{$randomId}'] = function(carouselEl) { 
        {$override_options}
    }
    </script>";
    */

    $inline_script = "window.emblaOverrideOptions = window.emblaOverrideOptions || {};
    window.emblaOverrideOptions['{$randomId}'] = function(carouselEl) { 
        {$override_options}
    }";

    wp_add_inline_script('appiapp-carousel-js-'.$randomId, $inline_script);

    unset($attributes['emblaOptions']['overrideOptions']);   

}




if ($carousel_type === 'swiper' && $attributes['swiperOptions']['saveInstance'] == true && isset($attributes['swiperOptions']['customJs'])){    
    $inline_script = $attributes['swiperOptions']['customJs'];
    wp_add_inline_script('appiapp-carousel-js-'.$randomId, $inline_script);     
    
    unset($attributes['swiperOptions']['customJs']);   
}

if ($carousel_type === 'embla' && $attributes['emblaOptions']['saveInstance'] == true && isset($attributes['emblaOptions']['customJs'])){
    $inline_script = $attributes['emblaOptions']['customJs'];
    wp_add_inline_script('appiapp-carousel-js-'.$randomId, $inline_script);    

    unset($attributes['emblaOptions']['customJs']);
}

$embla_options = esc_attr(wp_json_encode($attributes['emblaOptions']) ?? []);
$swiper_options = esc_attr(wp_json_encode($attributes['swiperOptions']) ?? []);
$css_options = esc_attr(wp_json_encode($attributes['onlycssOptions']) ?? []);



$style = sprintf(
    '--aac-columns-desktop: %.2f; --aac-columns-tablet: %.2f; --aac-columns-mobile: %.2f; ' .
    '--aac-columns-space-desktop: %dpx; --aac-columns-space-tablet: %dpx; --aac-columns-space-mobile: %dpx;',
    $attributes['columnsDesktop'] ?? 4,
    $attributes['columnsTablet'] ?? 2,
    $attributes['columnsMobile'] ?? 1,
    $attributes['gapDesktop'] ?? 30,
    $attributes['gapTablet'] ?? 20,
    $attributes['gapMobile'] ?? 15
);


$wrapper_attributes = get_block_wrapper_attributes([
    'class' => 'wp-block-appiapp-carousel '.$randomId
]);

?>
<div <?php echo wp_kses_post($wrapper_attributes); ?> 

     data-carousel-type="<?php echo esc_attr($carousel_type); ?>"
     data-carousel-id="<?php echo esc_attr($randomId); ?>"
    
    <?php if ($carousel_type === 'embla'): ?>
        data-embla-options="<?php echo esc_attr($embla_options); ?>"
    <?php endif; ?>

    <?php if ($carousel_type === 'onlycss'): ?>
        data-css-options="<?php echo esc_attr($css_options); ?>"
    <?php endif; ?>

    <?php if ($carousel_type === 'swiper'): ?>
        data-swiper-options="<?php echo esc_attr($swiper_options); ?>"
    <?php endif; ?>

    style="<?php echo esc_attr($style); ?>">

    <?php echo $content; ?>

    <?php
    /*
    <?php if ($carousel_type === 'embla'): ?>
        <?php echo $content; ?>
    <?php endif; ?>

    <?php if ($carousel_type === 'onlycss'): ?>
        <?php echo $content; ?>
    <?php endif; ?>

    <?php if ($carousel_type === 'swiper'): ?>
        <?php echo $content; ?>
    <?php endif; ?>
    */
    ?>
</div>

<?php
/*

<?php if ($carousel_type === 'swiper' && $attributes['swiperOptions']['saveInstance'] == true && isset($attributes['swiperOptions']['customJs'])): ?>
    <?php
    
    
    <script>
        <?php echo  $attributes['swiperOptions']['customJs']; ?>
    </script>
    
    
    ?>



<?php endif; ?>

<?php if ($carousel_type === 'embla' && $attributes['emblaOptions']['saveInstance'] == true && isset($attributes['emblaOptions']['customJs'])): ?>

    

    <?php
    
    
    <script>
        <?php echo  $attributes['emblaOptions']['customJs']; ?>
    </script>
    
    
    ?>
<?php endif; ?>
*/
?>

<?php

wp_enqueue_script('appiapp-carousel-js-'.$randomId);


?>

<?php

/**
 * 
    document.addEventListener('DOMContentLoaded', function () {

        const mySwiper = window.swiperInstances['carousel-1'];

        function stopC(){
            const swiperT = mySwiper.getTranslate();
            mySwiper.setTranslate(swiperT);
            mySwiper.autoplay.stop()
        }

        function startC (){
            mySwiper.slideTo(mySwiper.activeIndex, <?php echo $attributes['swiperOptions']['speed'];?>, false);
            mySwiper.autoplay.start()
        }

        const containerC = document.querySelector(".<?php echo $randomId; ?> .swiper__viewport");
        containerC.addEventListener('mouseenter', ()=>stopC());
        containerC.addEventListener('mouseleave', ()=>startC());
        
        
    });
 */
?>