<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// Prepare CSS custom properties for dots
/*
$wrapper_attributes = get_block_wrapper_attributes([
    'class' => 'wp-block-appiapp-carousel-pagination embla__controls'
]);
*/

$new_attributes = WP_Block_Supports::get_instance()->apply_block_supports();
//var_dump($new_attributes);

/*
array(2) { [“class”]=> 
string(180) “aligncenter wp-elements-aef6de9c3890093192f6b5e926697bcf wp-block-appiapp-carousel-pagination has-text-color has-custom-accent-1-color has-background has-vivid-red-background-color” 
[“style”]=> string(161) “padding-right:10px;padding-left:10px;padding-top:var(–wp–preset–spacing–70);padding-bottom:var(–wp–preset–spacing–70);margin-top:10px;margin-bottom:10px;” }


*/

$carouselType = $block->context['appiapp-carousel/carouselType'];
$wrapper_attributes = get_block_wrapper_attributes([
    'class' => 'wp-block-appiapp-carousel-pagination '.$carouselType.'__controls'
]);

if(isset($new_attributes['style'])){
    $wrapper_attributes = str_replace('style="' .$new_attributes['style'].'"', '', $wrapper_attributes);
}
/*
var_dump($wrapper_attributes);

//var_dump($wrapper_attributes);
echo '<pre>';
print_r($attributes);
echo '</pre>';
*/
$styles = [];

// Handle border styles
if (!empty($attributes['style']['border'])) {
    $styles = array_merge($styles, appiappcf_carousel_free_get_border_css_variables($attributes['style']['border']));
}

// Handle spacing styles
if (!empty($attributes['style']['spacing'])) {
    $styles = array_merge($styles, appiappcf_carousel_free_get_spacing_css_variables($attributes['style']['spacing']));
}

if (isset($attributes['backgroundColor'])) {
    //$dot_styles[] = sprintf('--embla-dot-background: var(--wp--preset--color--%s)', $attributes['backgroundColor']);
    //$styles[] = 
    $background_class = sprintf('has-%s-background-color', $attributes['backgroundColor']);
    $wrapper_attributes = str_replace([$background_class, 'has-background'], '', $wrapper_attributes );


    $styles[] = sprintf('--aac-dot-background: var(--wp--preset--color--%s)', $attributes['backgroundColor']);
   
}

if (isset($attributes['borderColor'])) {

    $border_class = sprintf('has-%s-border-color', $attributes['borderColor']);
    $wrapper_attributes = str_replace([$border_class, 'has-border-color'], '', $wrapper_attributes );

    $styles[] = sprintf('--aac-dot-border-color: var(--wp--preset--color--%s)', $attributes['borderColor']);
   
}

if (isset($attributes['style']['color']['background'])) {
    $styles[] = sprintf('--aac-dot-background: %s', $attributes['style']['color']['background']);

    $wrapper_attributes = str_replace(['has-background'], '', $wrapper_attributes );
    $wrapper_attributes = preg_replace('/\s*style="[^"]*"/', '', $wrapper_attributes);
}

if (isset($attributes['style']['color']['text'])) {
    $styles[] = sprintf('--aac-dot-text: %s', $attributes['style']['color']['text']);

    $wrapper_attributes = str_replace(['has-background'], '', $wrapper_attributes );
    $wrapper_attributes = preg_replace('/\s*style="[^"]*"/', '', $wrapper_attributes);
}

if (isset($attributes['width'])) {
    $styles[] = sprintf('--aac-dot-width: %s', $attributes['width']);
}

if (isset($attributes['height'])) {
    $styles[] = sprintf('--aac-dot-height: %s', $attributes['height']);
}

$style = !empty($styles) ? sprintf(' style="%s"', implode('; ', $styles)) : '';

$position = $attributes['position'] ?? '';
$stylePagination = '';
if ($position != '') {

    $stylePagination = "position: " . esc_attr($position) . ";";

    foreach (['top', 'right', 'bottom', 'left'] as $prop) {
        if (!empty($attributes[$prop])) {
            $stylePagination .= " $prop: " . esc_attr($attributes[$prop]) . ";";
        }
    }
}

$paginationType = $attributes['paginationType'];

if(isset($new_attributes['style'])){
    $stylePagination .= $new_attributes['style'];

    if($paginationType== "progressbar"){
        //remove bg color
        $stylePagination = preg_replace('/background-color:\s*[^;]+;/', '', $stylePagination);

    }
}

if(!empty($stylePagination)){
    $stylePagination = 'style="'.$stylePagination.'"';
}

//$new_attributes['style']

//var_dump($wrapper_attributes);
$orientation_class = "";
if (isset($attributes['orientation'])) {
    $orientation_class .= "orientation_".$attributes['orientation'];
}

?>

<div <?php echo wp_kses_post($wrapper_attributes . $style); ?>>
    <div data-pagination-type="<?php echo esc_attr($paginationType); ?>" <?php echo wp_kses_post($stylePagination); ?> class="<?php echo esc_attr($carouselType); ?>__dots <?php echo esc_attr($orientation_class); ?>"></div>
</div>


