<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$carouselType = $block->context['appiapp-carousel/carouselType'];
$enable_captions_lightbox = $attributes['enableCaptionsLightbox'] ?? true;
$captions_source = $attributes['captionSource'];

$additionalClass = '';
if($carouselType === 'swiper'){
    $additionalClass = 'swiper-wrapper';
}


$wrapper_attributes = get_block_wrapper_attributes([
    'class' => $carouselType,
    'data-captions-lightbox' => $enable_captions_lightbox,
]);

$images = $attributes['images'] ?? [];
$enable_caption_under = $attributes['enableCaptionUnderImage'] ?? true;
$style_visibility = $enable_caption_under ? '' : 'style="display:none;"';

$enable_lightbox = $attributes['enableLightbox'] ?? true;

$aspect_ratio = $attributes['aspectRatio'] ?? '';
$object_fit = $attributes['objectFit'] ?? 'cover';

if( isset($attributes['verticalAlignment'])){
    $additionalClass .= ' align-'.$attributes['verticalAlignment'];
}



$innerAdditionalClass = '';
if($carouselType === 'swiper'){
    $innerAdditionalClass = 'swiper-slide';
}


//$gallery_id = 'gallery-' . uniqid();
//$output = sprintf('<div id="%s" class="%s">', esc_attr($gallery_id), esc_attr($gallery_class));
$output = '';
foreach ($images as $image) {
    // Get the full image dimensions
    
    
    $full_image_meta = wp_get_attachment_metadata($image['id']);
    $full_width = $full_image_meta['width'] ?? 1920;
    $full_height = $full_image_meta['height'] ?? 1080;
    
    //var_dump($full_image_meta);
    
    $style = '';
    
    // Use image-specific aspect ratio if available, otherwise use gallery default
    $image_aspect_ratio = $image['aspectRatio'] == '' ? $aspect_ratio : $image['aspectRatio'];
    
    if ($image_aspect_ratio) {
        list($width, $height) = explode('/', $image_aspect_ratio);
        $style .=  sprintf('aspect-ratio: %s/%s;', esc_attr($width), esc_attr($height));
    }

    // Calculate style with object-fit and aspect ratio
    //verifco che sia setto aspectratio altrimenti se setto objectfit c'è un incompatibilità con contain-intrinsic-size setta da wp
    if($image_aspect_ratio != ''){
        $image_object_fit = $image['objectFit'] == '' ? $object_fit : $image['objectFit'];
        if($image_object_fit){
            $style .= sprintf(
                'object-fit: %s;',
                esc_attr($image_object_fit)
            );
        }    
    }
    

    //$style = 'style="--aac-image-aspect-ratio: 1/1; --aac-image-object-fit:cover;"';

    
    $output .= '<div class="'.$innerAdditionalClass.' '.$carouselType.'__slide'.'">';
    
    if (!empty($image['link'])) {
        $target = isset($image['target']) ? $image['target'] : '_self';
        $output .= sprintf(
            '<a href="%s" target="%s">',
            esc_url($image['link']), $target
        );
    } elseif ($enable_lightbox) {
        $output .= sprintf(
            '<a href="%s" class="aa-gallery-lightbox" data-pswp-width="%d" data-pswp-height="%d" data-cropped="true">',
            esc_url($image['fullUrl']),
            $full_width,
            $full_height
        );
    }

    /*
    $img_tag = wp_get_attachment_image($image['id'], $image['size'], false, ['class' => 'aac-image aac-image-aspect','srcset' => false]);

    if($style != ''){
        $style = 'style="'.$style.'"';
        $output .= str_replace('<img ', '<img '.$style.' ', $img_tag);

    }else{
        $output .= $img_tag;
    }
    */

    $image_src = wp_get_attachment_image_src($image['id'], $image['size']);
    $alt = esc_attr(get_post_meta($image['id'], '_wp_attachment_image_alt', true));
    $width_thumb = $image_src[1];
    $height_thumb = $image_src[2];
    $src = esc_url($image_src[0]);

    if($style != ''){
        $style = 'style="'.$style.'"';
    }

    $output .= sprintf(
        '<img src="%s" width="%d" height="%d" alt="%s" loading="lazy" class="aac-image" %s>',
        $src, $width_thumb, $height_thumb, $alt, $style 
    );


    if (!empty($image['link']) || $enable_lightbox) {
        $output .= '</a>';
    }


    //if (!empty($image['caption'])) {

        //dynamic caption, not used
        if($captions_source == 'image-caption'){
            $caption_wp = wp_get_attachment_caption($image['id']);
            $output .= sprintf(
                '<div %s class="app-gallery-caption">%s</div>',
                $style_visibility,
                wp_kses_post($caption_wp)
            );
        }

        /*
        loaded from gallery, caption is not update
        */
        if($captions_source == 'caption' && !empty($image['caption'])){
            $output .= sprintf(
                '<div %s class="app-gallery-caption">%s</div>',
                $style_visibility,
                wp_kses_post($image['caption'])
            );
            
        }
        
        if($captions_source == 'alt'){
            $output .= sprintf(
                '<div %s class="app-gallery-caption">%s</div>',
                $style_visibility,
                $alt
            );
        }
        
    //}

    $output .= '</div>';


}


 if ($enable_lightbox) {
    wp_enqueue_script('appiapp_carousel_photoswipe');
    wp_enqueue_style('appiapp_carousel_photoswipe');
}



?>

<div <?php echo wp_kses_post($wrapper_attributes); ?>>
    <div class="<?php echo esc_attr($carouselType); ?>__viewport">
        <div class="<?php echo esc_attr($carouselType); ?>__container <?php echo esc_attr($additionalClass); ?>">
            <?php echo $output; ?>
        </div>
    </div>
</div>



