<?php
/**
 * Plugin Name:       appiapp Carousel Block
 * Description:       appiapp Carousel allows you to create highly customizable carousels directly in Gutenberg. Build unique sliders for posts, images, and any block.
 * Requires at least: 6.6
 * Requires PHP:      7.4
 * Version:           2.0.0
 * Author:            appiapp
 * Requires Plugins:  icon-block
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       appiapp-carousel-free
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


function appiappcf_carousel_free_init() {
	register_block_type( __DIR__ . '/build/carousel' );
	register_block_type( __DIR__ . '/build/carousel-items-container' );
	register_block_type( __DIR__ . '/build/carousel-query-container' );
	register_block_type( __DIR__ . '/build/carousel-gallery-container' );
	register_block_type( __DIR__ . '/build/carousel-item' );
	register_block_type( __DIR__ . '/build/carousel-pagination' );
	register_block_type( __DIR__ . '/build/carousel-prev-arrow' );
	register_block_type( __DIR__ . '/build/carousel-next-arrow' );

}
add_action( 'init', 'appiappcf_carousel_free_init' );


function appiappcf_carousel_free_enqueue_scripts() {


    wp_register_style(
        'appiapp_carousel_swiper',
        plugin_dir_url(__FILE__) . 'build/carousel/view-swiper.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-swiper.css')
    );

    wp_register_script(
            'appiapp_carousel_swiper',
            plugins_url('build/carousel/view-swiper.js', __FILE__),
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-swiper.js'),
            true
    );


    wp_register_script(
            'appiapp_carousel_embla',
            plugins_url('build/carousel/view-embla.js', __FILE__),
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-embla.js'),
            true
    );

    wp_register_script(
            'appiapp_carousel_onlycss',
            plugins_url('build/carousel/view-css.js', __FILE__),
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-css.js'),
            true
    );

    wp_register_script(
            'appiapp_carousel_photoswipe',
            plugins_url('build/carousel/view-photoswipe.js', __FILE__),
            array(),
            filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-photoswipe.js'),
            true
    );

    
    wp_register_style(
        'appiapp_carousel_photoswipe',
        plugin_dir_url(__FILE__) . 'build/carousel/view-photoswipe.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'build/carousel/view-photoswipe.css')
    );
    
    /*

    wp_register_style(
        'appiapp_carousel_photoswipe',
        plugin_dir_url(__FILE__) . 'node_modules/photoswipe/dist/photoswipe.css',
        array(),
        filemtime(plugin_dir_path(__FILE__) . 'node_modules/photoswipe/dist/photoswipe.css')
    );
    
    */
    

}
add_action('wp_enqueue_scripts', 'appiappcf_carousel_free_enqueue_scripts');



function appiappcf_carousel_free_render($block_content, $block) {

    //default is swiper
    if(!isset($block['attrs']['carouselType']) || ($block['attrs']['carouselType'] === '' || $block['attrs']['carouselType'] === 'swiper')){
        wp_enqueue_script('appiapp_carousel_swiper');
        wp_enqueue_style('appiapp_carousel_swiper');
    }

    if(isset($block['attrs']['carouselType']) && $block['attrs']['carouselType'] === 'embla'){
        wp_enqueue_script('appiapp_carousel_embla');
    }
    

    if(isset($block['attrs']['carouselType']) && $block['attrs']['carouselType'] === 'onlycss'){
        wp_enqueue_script('appiapp_carousel_onlycss');
    }

    return $block_content;

}
add_filter( 'render_block_appiapp-carousel/carousel', 'appiappcf_carousel_free_render', 10, 2 );


function appiappcf_carousel_free_query_block_custom_render($block_content, $block) {

    if ($block['blockName'] === 'core/query' && isset($block['attrs']['queryId']) && isset($block['attrs']['customAppAppLayout'])) {

        $carouselType = $block['attrs']['customAppAppLayout']['type'];
        if($block['attrs']['customAppAppLayout']['enabled'] === true && in_array($carouselType, ['swiper', 'embla', 'onlycss'])){              

            $block_content = preg_replace('/<div[^>]*wp-block-query[^>]*>(.*?)<\/div>\s*$/s', '$1', $block_content);

            // Estrae il contenuto dell'attributo class
            $class_wp_block_post_template = '';
            if (preg_match('/class="([^"]*)"/', $block_content, $class_matches)) {
                $class_string = $class_matches[1];
                
                // Cerca tutte le classi prima di wp-block-post-template
                preg_match('/^(.*?)wp-block-post-template/', $class_string, $matches);
                if(count( $matches) > 1){
                    $class_wp_block_post_template = $matches[0];
                }
            }

            $additionalClass = $carouselType.'__slide ';

            if($carouselType === 'swiper'){
                $additionalClass .= 'swiper-slide ';
            }

            $block_content = preg_replace(
                '/<li([^>]*)class="([^"]*)"([^>]*)>/',
                '<div$1class="$2 '.$class_wp_block_post_template.' '.$additionalClass.'"$3>',
                $block_content
            );
            $block_content = preg_replace('/<\/li>/', '</div>', $block_content);

            $block_content = preg_replace('/<ul[^>]*wp-block-post-template[^>]*>(.*?)<\/ul>/s', '$1', $block_content);
            
            return $block_content;
        }
        
    }

   
    return $block_content;
}
add_filter( 'render_block_core/query', 'appiappcf_carousel_free_query_block_custom_render', 10, 2 );


function appiappcf_carousel_free_add_upgrade_link( $links ) {
    $pro_link = '<a target="_blank" href="https://www.appiapp-themes.com/advanced-carousel-slider-gutenberg-wordpress/?utm_source=plugin&utm_medium=bannerpluginlist&utm_campaign=free_plugin" style="color: #d54e21; font-weight: bold;">' . __( 'Premium Templates', 'appiapp-carousel-free') . '</a>';
    array_push( $links, $pro_link );
    $pro_link = '<a target="_blank" href="https://www.appiapp-themes.com/carousel-docs/why-choose-appiapp-carousel-pro/?utm_source=plugin&utm_medium=bannerpluginlist&utm_campaign=free_plugin" style="color: #00b615ff; font-weight: bold;">' . __( 'Documentation', 'appiapp-carousel-free') . '</a>';
    array_push( $links, $pro_link );
    return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'appiappcf_carousel_free_add_upgrade_link' );


function appiappcf_carousel_free_get_spacing_css_variables($spacing) {
    $styles = [];
    
    // Handle individual border sides
    if (!empty($spacing['padding'])) {

        /*
        if (is_string($border['radius'])) {
            // Single value for all corners
            $styles[] = sprintf('--aac-dot-border-radius: %s', $border['radius']);
        } else {
            // Individual corner values
        */
            $corners = [
                'left',
                'right',
                'top',
                'bottom'
            ];
            
            foreach ($corners as $value) {
                if (isset($spacing['padding'][$value])) {
                    $styles[] = sprintf('--aac-dot-p-%s: %s', $value, $spacing['padding'][$value]);
                }
            }
        //}
    }

    return $styles;

}

function appiappcf_carousel_free_get_border_css_variables($border) {
    $styles = [];
    
    // Handle individual border sides
    $sides = ['top', 'right', 'bottom', 'left'];
    foreach ($sides as $side) {
        if (!empty($border[$side])) {
            $border_side = $border[$side];
            
            if (!empty($border_side['width'])) {
                $styles[] = sprintf('--aac-dot-border-%s-width: %s', $side, $border_side['width']);
            }
            if (!empty($border_side['style'])) {
                $styles[] = sprintf('--aac-dot-border-%s-style: %s', $side, $border_side['style']);
            }
            if (!empty($border_side['color'])) {
                $color = $border_side['color'];
                if (strpos($color, 'var:preset|color|') === 0) {
                    $color_slug = str_replace('var:preset|color|', '', $color);
                    $styles[] = sprintf('--aac-dot-border-%s-color: var(--wp--preset--color--%s)', $side, $color_slug);
                } else {
                    $styles[] = sprintf('--aac-dot-border-%s-color: %s', $side, $color);
                }
            }
            
            
        }
    }
    

	if (!empty($border['width'])) {
        if (is_string($border['width'])) {
			$styles[] = sprintf('--aac-dot-border-top-width: %s', $border['width']);
            $styles[] = sprintf('--aac-dot-border-right-width: %s', $border['width']);
            $styles[] = sprintf('--aac-dot-border-bottom-width: %s', $border['width']);
            $styles[] = sprintf('--aac-dot-border-left-width: %s', $border['width']);
		}
	}

	if (!empty($border['style'])) {
        if (is_string($border['style'])) {
			$styles[] = sprintf('--aac-dot-border-top-style: %s', $border['style']);
            $styles[] = sprintf('--aac-dot-border-right-style: %s', $border['style']);
            $styles[] = sprintf('--aac-dot-border-bottom-style: %s', $border['style']);
            $styles[] = sprintf('--aac-dot-border-left-style: %s', $border['style']);
		}
	}

	if (!empty($border['color'])) {
        if (is_string($border['color'])) {

            // Single color value for all sides
            $color = $border['color'];
            if (strpos($color, 'var:preset|color|') === 0) {
                $color_slug = str_replace('var:preset|color|', '', $color);
                $color_value = sprintf('var(--wp--preset--color--%s)', $color_slug);
            } else {
                $color_value = $color;
            }
            
            $styles[] = sprintf('--aac-dot-border-top-color: %s', $color_value);
            $styles[] = sprintf('--aac-dot-border-right-color: %s', $color_value);
            $styles[] = sprintf('--aac-dot-border-bottom-color: %s', $color_value);
            $styles[] = sprintf('--aac-dot-border-left-color: %s', $color_value);
        }
	}
    
    // Handle border radius
    if (!empty($border['radius'])) {
        if (is_string($border['radius'])) {
            // Single value for all corners
            $styles[] = sprintf('--aac-dot-border-radius: %s', $border['radius']);
        } else {
            // Individual corner values
            $corners = [
                'topLeft' => 'top-left',
                'topRight' => 'top-right',
                'bottomLeft' => 'bottom-left',
                'bottomRight' => 'bottom-right'
            ];
            
            foreach ($corners as $key => $value) {
                if (isset($border['radius'][$key])) {
                    $styles[] = sprintf('--aac-dot-border-%s-radius: %s', $value, $border['radius'][$key]);
                }
            }
        }
    }
    
    return $styles;
}

function appiappcf_carousel_free_split_block_attributes($original_attributes, $carouselType) {
    preg_match('/class="([^"]*)"/', $original_attributes, $class_matches);
    preg_match('/style="([^"]*)"/', $original_attributes, $style_matches);
    
    $classes = isset($class_matches[1]) ? explode(' ', $class_matches[1]) : [];
    $style = isset($style_matches[1]) ? $style_matches[1] : '';

    
    $outer_classes = [];
    $inner_classes = [];
    
    foreach ($classes as $class) {
        if (preg_match('/^has-.*-background-color$/', $class) || $class === 'has-background') {
            $inner_classes[] = $class;
        } else {
            $outer_classes[] = $class;
        }
    }
    
    return [
        'outer' => [
            'class' => implode(' ', $outer_classes),
        ],
        'inner' => [
            'class' =>  $carouselType . '__slide__inner ' . implode(' ', $inner_classes),
            'style' => $style
        ]
    ];
}
