<?php

namespace WBCR\Titan\Page;

/**
 * Step
 *
 * @author Webcraftic <wordpress.webraftic@gmail.com>
 * @copyright (c) 23.07.2020, Webcraftic
 * @version 1.0
 */
class Step_Scan_Malware extends \WBCR\Factory_Templates_128\Pages\Step_Custom {

	protected $prev_id = 'step2';
	protected $id = 'step3';
	protected $next_id = 'step4';

	public function get_title()
	{
		return __("Scan Malware", 'titan-security');
	}

	public function html()
	{
		/** @var \WBCR\Titan\MalwareScanner\Scanner $scanner */
		$scanner = get_option($this->plugin->getPrefix() . 'scanner');

		if( !$scanner ) {
			$chart_data = [
				//'scanner_started' => 0,
				'matched' => false,
				'progress' => [0, 0, 100],
				'cleaned' => 0,
				'suspicious' => 0,
				'scanned' => 0,
				'notverified' => 0,
				'files_count' => 0,
			];
		} else {
			$matched = get_option($this->plugin->getPrefix() . 'scanner_malware_matched', false);
			$scanner_started = $this->plugin->getOption('scanner_status') == 'started';
			$files_count = $this->plugin->getOption('scanner_files_count', 0);

			$progress = [
				$files_count > 0 ? floor($scanner->cleaned_count / $files_count * 100) : 0,
				$files_count > 0 ? ceil($scanner->suspicious_count / $files_count * 100) : 0,
				$files_count > 0 ? floor($scanner->files_count / $files_count * 100) : 0
			];

			$chart_data = [
				//'scanner_started' => $scanner_started,
				'matched' => $matched,
				'cleaned' => $scanner->cleaned_count,
				'suspicious' => $scanner->suspicious_count,
				'scanned' => $scanner->cleaned_count + $scanner->suspicious_count,
				'notverified' => $scanner->files_count,
				'files_count' => $files_count,
				'progress' => $progress,
			];
		}

		?>
		<div class="w-factory-templates-128-setup__inner-wrap">
			<h3><?php _e("Scan Malware", 'titan-security'); ?></h3>
			<p style="text-align: left;">
				<?php _e("Titan Scanner to check your website for viruses and malicious code. After scan, you will receive a detailed report on the crawl of your site.", 'titan-security'); ?>
			</p>
			<div>
				<div class="wt-scanner-chart">
					<div class="wt-scanner-chart-clean" style="width: <?php echo $chart_data['progress'][0]; ?>%;"></div>
					<div class="wt-scanner-chart-suspicious" style="width: <?php echo $chart_data['progress'][1]; ?>%;"></div>
					<div class="wt-scanner-chart-notverified"
					     style="width: <?php echo $chart_data['progress'][2]; ?>%;"></div>
				</div>
			</div>
			<div>
				<div class="wt-scanner-legend">
					<table>
						<tbody>
						<tr>
							<td><span class="wt-scanner-chart-clean wt-legend-item"></span></td>
							<td><?php _e("Cleaned", 'titan-security'); ?> -
								<span id="wtitan-cleaned-num"><?php echo $chart_data['cleaned']; ?></span>
							</td>

							<td><span class="wt-scanner-chart-suspicious wt-legend-item"></span></td>
							<td><?php _e("Suspicious", 'titan-security'); ?> -
								<span id="wtitan-suspicious-num"><?php echo $chart_data['suspicious']; ?></span>
							</td>

							<td><span class="wt-scanner-chart-notverified wt-legend-item"></span></td>
							<td><?php _e("Not verified", 'titan-security'); ?> -
								<span id="wtitan-notverified-num"><?php echo $chart_data['notverified']; ?></span></td>
						</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<?php $this->render_button(!$scanner_started, true, 'Start Scan And Continue'); ?>
		<?php
	}

	protected function continue_step($skip = false)
	{
		if( !current_user_can('install_plugins') ) {
			wp_die(__('Sorry, you are not allowed to access this page.'), 403);
		}

		titan_create_scheduler_scanner();
		parent::continue_step($skip);
	}
}