<?php
/**
 * Disable Admin Bloats Settings Page
 * 
 * @package DisableAdminBloats
 * @version 1.1.0
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get current options
$options = get_option( 'disable_admin_bloats_options', array() );
$is_active = isset( $options['disable_all_bloat'] ) && $options['disable_all_bloat'];
?>

<div class="wrap disable-admin-bloats-settings">
    <div class="disable-admin-bloats-header">
        <div class="header-content">
            <div class="header-icon">
                <span class="dashicons dashicons-shield-alt"></span>
            </div>
            <div class="header-text">
                <h1><?php _e( 'Disable Admin Bloats', 'disable-admin-bloats' ); ?></h1>
                <p class="subtitle"><?php _e( 'Clean up your WordPress admin interface by removing unwanted bloat and notices', 'disable-admin-bloats' ); ?></p>
            </div>
            <div class="header-status">
                <?php if ( $is_active ): ?>
                    <div class="status-badge active">
                        <span class="dashicons dashicons-yes-alt"></span>
                        <?php _e( 'Active', 'disable-admin-bloats' ); ?>
                    </div>
                <?php else: ?>
                    <div class="status-badge inactive">
                        <span class="dashicons dashicons-dismiss"></span>
                        <?php _e( 'Inactive', 'disable-admin-bloats' ); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <?php if ( $is_active ): ?>
            <div class="notice notice-info inline">
                <p><strong><?php _e( 'Disable Admin Bloats is currently active!', 'disable-admin-bloats' ); ?></strong> 
                <?php _e( 'Admin notices and interface bloat are being removed from your dashboard.', 'disable-admin-bloats' ); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <div class="disable-admin-bloats-nav">
        <nav class="nav-tab-wrapper nav-tab-wrapper-modern">
            <a href="#general" class="nav-tab nav-tab-active">
                <span class="dashicons dashicons-admin-generic"></span>
                <?php _e( 'General', 'disable-admin-bloats' ); ?>
            </a>
            <a href="#notices" class="nav-tab">
                <span class="dashicons dashicons-visibility"></span>
                <?php _e( 'Notices', 'disable-admin-bloats' ); ?>
            </a>
            <a href="#interface" class="nav-tab">
                <span class="dashicons dashicons-admin-appearance"></span>
                <?php _e( 'Interface', 'disable-admin-bloats' ); ?>
            </a>
            <a href="#performance" class="nav-tab">
                <span class="dashicons dashicons-performance"></span>
                <?php _e( 'Performance', 'disable-admin-bloats' ); ?>
            </a>
            <a href="#tools" class="nav-tab">
                <span class="dashicons dashicons-admin-tools"></span>
                <?php _e( 'Tools', 'disable-admin-bloats' ); ?>
            </a>
        </nav>
    </div>

    <div class="disable-admin-bloats-content">
        <form method="post" action="options.php" class="disable-admin-bloats-form">
            <?php settings_fields( 'disable-admin-bloats-settings' ); ?>
            
            <div id="general" class="tab-content active">
                <div class="settings-card">
                    <div class="card-header">
                        <h3><span class="dashicons dashicons-admin-generic"></span><?php _e( 'General Settings', 'disable-admin-bloats' ); ?></h3>
                        <p class="card-description"><?php _e( 'Master controls and general plugin settings.', 'disable-admin-bloats' ); ?></p>
                    </div>
                    <div class="card-content">
                        <table class="form-table" role="presentation">
                            <tbody>
                                <?php do_settings_fields( 'disable-admin-bloats', 'disable-admin-bloats-general-section' ); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div id="notices" class="tab-content">
                <div class="settings-card">
                    <div class="card-header">
                        <h3><span class="dashicons dashicons-visibility"></span><?php _e( 'Notice Controls', 'disable-admin-bloats' ); ?></h3>
                        <p class="card-description"><?php _e( 'Control which admin notices and messages to hide from your dashboard.', 'disable-admin-bloats' ); ?></p>
                    </div>
                    <div class="card-content">
                        <table class="form-table" role="presentation">
                            <tbody>
                                <?php do_settings_fields( 'disable-admin-bloats', 'disable-admin-bloats-notices-section' ); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div id="interface" class="tab-content">
                <div class="settings-card">
                    <div class="card-header">
                        <h3><span class="dashicons dashicons-admin-appearance"></span><?php _e( 'Interface Cleanup', 'disable-admin-bloats' ); ?></h3>
                        <p class="card-description"><?php _e( 'Remove unnecessary interface elements to create a cleaner admin experience.', 'disable-admin-bloats' ); ?></p>
                    </div>
                    <div class="card-content">
                        <table class="form-table" role="presentation">
                            <tbody>
                                <?php do_settings_fields( 'disable-admin-bloats', 'disable-admin-bloats-interface-section' ); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div id="performance" class="tab-content">
                <div class="settings-card">
                    <div class="card-header">
                        <h3><span class="dashicons dashicons-performance"></span><?php _e( 'Performance Settings', 'disable-admin-bloats' ); ?></h3>
                        <p class="card-description"><?php _e( 'Optimize WordPress admin performance by disabling resource-intensive features.', 'disable-admin-bloats' ); ?></p>
                    </div>
                    <div class="card-content">
                        <table class="form-table" role="presentation">
                            <tbody>
                                <?php do_settings_fields( 'disable-admin-bloats', 'disable-admin-bloats-performance-section' ); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div id="tools" class="tab-content">
                <div class="settings-card">
                    <div class="card-header">
                        <h3><span class="dashicons dashicons-admin-tools"></span><?php _e( 'Tools & Information', 'disable-admin-bloats' ); ?></h3>
                        <p class="card-description"><?php _e( 'Plugin information and import/export tools.', 'disable-admin-bloats' ); ?></p>
                    </div>
                    <div class="card-content">
                        <div class="tools-grid">
                            <div class="tool-section">
                                <h4><?php _e( 'Plugin Information', 'disable-admin-bloats' ); ?></h4>
                                <table class="widefat striped">
                                    <tbody>
                                        <tr>
                                            <td><strong><?php _e( 'Plugin Version', 'disable-admin-bloats' ); ?></strong></td>
                                            <td><?php echo esc_html( DISABLE_ADMIN_BLOATS_VERSION ); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php _e( 'WordPress Version', 'disable-admin-bloats' ); ?></strong></td>
                                            <td><?php echo esc_html( get_bloginfo( 'version' ) ); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php _e( 'PHP Version', 'disable-admin-bloats' ); ?></strong></td>
                                            <td><?php echo esc_html( PHP_VERSION ); ?></td>
                                        </tr>
                                        <?php if ( class_exists( 'WooCommerce' ) ): ?>
                                        <tr>
                                            <td><strong><?php _e( 'WooCommerce Version', 'disable-admin-bloats' ); ?></strong></td>
                                            <td><?php echo esc_html( WC()->version ); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <tr>
                                            <td><strong><?php _e( 'Active Features', 'disable-admin-bloats' ); ?></strong></td>
                                            <td>
                                                <?php 
                                                $active_features = array();
                                                if ( $options['disable_all_bloat'] ) {
                                                    $active_features[] = __( 'All Bloats Disabled', 'disable-admin-bloats' );
                                                } else {
                                                    if ( $options['disable_admin_notices'] ) $active_features[] = __( 'Admin Notices', 'disable-admin-bloats' );
                                                    if ( $options['disable_woocommerce_notices'] ) $active_features[] = __( 'WooCommerce Notices', 'disable-admin-bloats' );
                                                    if ( $options['disable_dashboard_widgets'] ) $active_features[] = __( 'Dashboard Widgets', 'disable-admin-bloats' );
                                                    if ( $options['performance_mode'] ) $active_features[] = __( 'Performance Mode', 'disable-admin-bloats' );
                                                }
                                                
                                                if ( empty( $active_features ) ) {
                                                    echo '<span class="description">' . __( 'No features currently active', 'disable-admin-bloats' ) . '</span>';
                                                } else {
                                                    echo '<span class="active-features">' . esc_html( implode( ', ', $active_features ) ) . '</span>';
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="tool-section">
                                <h4><?php _e( 'Import/Export Settings', 'disable-admin-bloats' ); ?></h4>
                                <div class="tool-buttons">
                                    <button type="button" class="button button-secondary" id="export-settings">
                                        <span class="dashicons dashicons-download"></span>
                                        <?php _e( 'Export Settings', 'disable-admin-bloats' ); ?>
                                    </button>
                                    <button type="button" class="button button-secondary" id="import-settings">
                                        <span class="dashicons dashicons-upload"></span>
                                        <?php _e( 'Import Settings', 'disable-admin-bloats' ); ?>
                                    </button>
                                    <button type="button" class="button button-secondary" id="reset-settings">
                                        <span class="dashicons dashicons-update"></span>
                                        <?php _e( 'Reset All Settings', 'disable-admin-bloats' ); ?>
                                    </button>
                                </div>
                                <input type="file" id="import-file" accept=".json" style="display: none;">
                                <p class="description">
                                    <?php _e( 'Use these tools to manage your plugin configuration. Export to backup your settings or import previously saved configurations.', 'disable-admin-bloats' ); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="submit-section">
                <div class="submit-card">
                    <?php submit_button( __( 'Save Settings', 'disable-admin-bloats' ), 'primary large', 'submit', false, array( 'id' => 'save-settings-btn' ) ); ?>
                    <p class="submit-description"><?php _e( 'Save your changes to apply the selected bloat removal settings.', 'disable-admin-bloats' ); ?></p>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
/* Modern Enhanced CSS for the settings page */
.disable-admin-bloats-settings {
    margin: 20px 20px 0 2px;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
}

.disable-admin-bloats-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 30px;
    border-radius: 12px;
    margin-bottom: 30px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
}

.header-icon {
    font-size: 48px;
    margin-right: 20px;
    opacity: 0.9;
}

.header-text h1 {
    color: white;
    margin: 0;
    font-size: 32px;
    font-weight: 600;
    line-height: 1.2;
}

.header-text .subtitle {
    margin: 8px 0 0 0;
    font-size: 16px;
    opacity: 0.9;
    font-weight: 400;
}

.status-badge {
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
}

.status-badge.active {
    background: rgba(46, 160, 67, 0.2);
    color: #4caf50;
    border: 2px solid rgba(76, 175, 80, 0.3);
}

.status-badge.inactive {
    background: rgba(244, 67, 54, 0.2);
    color: #f44336;
    border: 2px solid rgba(244, 67, 54, 0.3);
}

.disable-admin-bloats-header .notice {
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: white;
    border-radius: 8px;
    margin: 0;
}

.disable-admin-bloats-nav {
    margin-bottom: 30px;
}

.nav-tab-wrapper-modern {
    border: none;
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    padding: 0;
    overflow: hidden;
}

.nav-tab-wrapper-modern .nav-tab {
    border: none;
    background: transparent;
    color: #666;
    padding: 16px 24px;
    margin: 0;
    border-radius: 0;
    font-weight: 500;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
}

.nav-tab-wrapper-modern .nav-tab:hover {
    background: #f8f9fa;
    color: #333;
}

.nav-tab-wrapper-modern .nav-tab.nav-tab-active {
    background: #667eea;
    color: white;
    font-weight: 600;
}

.nav-tab-wrapper-modern .nav-tab .dashicons {
    font-size: 16px;
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

.settings-card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    overflow: hidden;
}

.card-header {
    background: #f8f9fa;
    padding: 24px 30px;
    border-bottom: 1px solid #e9ecef;
}

.card-header h3 {
    margin: 0 0 8px 0;
    color: #333;
    font-size: 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 10px;
}

.card-header .dashicons {
    color: #667eea;
    font-size: 20px;
}

.card-description {
    margin: 0;
    color: #666;
    font-size: 14px;
    line-height: 1.5;
}

.card-content {
    padding: 30px;
}

.form-table {
    margin: 0;
}

.form-table th {
    width: 280px;
    font-weight: 600;
    color: #333;
    padding: 16px 10px 16px 0;
    vertical-align: top;
}

.form-table td {
    padding: 16px 0;
    vertical-align: top;
}

.form-table input[type="checkbox"] {
    margin-right: 8px;
    transform: scale(1.1);
}

.form-table label {
    font-weight: 500;
    color: #333;
    cursor: pointer;
    display: flex;
    align-items: flex-start;
    gap: 8px;
}

.form-table .description {
    margin-top: 8px;
    font-style: italic;
    color: #666;
    font-size: 13px;
    line-height: 1.4;
}

.tools-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
}

.tool-section h4 {
    margin: 0 0 16px 0;
    color: #333;
    font-size: 16px;
    font-weight: 600;
}

.tool-buttons {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-bottom: 16px;
}

.tool-buttons .button {
    display: flex;
    align-items: center;
    gap: 8px;
    justify-content: flex-start;
    padding: 10px 16px;
    height: auto;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.tool-buttons .button:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.widefat.striped tbody tr:nth-child(odd) {
    background: #f9f9f9;
}

.widefat td {
    padding: 12px;
    border-bottom: 1px solid #e9ecef;
}

.active-features {
    color: #2e7d32;
    font-weight: 500;
}

.submit-section {
    margin-top: 40px;
}

.submit-card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    padding: 30px;
    text-align: center;
}

.submit-card #save-settings-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 8px;
    padding: 12px 32px;
    font-size: 16px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 2px 10px rgba(102, 126, 234, 0.3);
}

.submit-card #save-settings-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.4);
}

.submit-description {
    margin: 16px 0 0 0;
    color: #666;
    font-size: 14px;
}

/* Responsive design */
@media (max-width: 1200px) {
    .tools-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .disable-admin-bloats-settings {
        margin: 20px 10px 0 10px;
    }
    
    .header-content {
        flex-direction: column;
        text-align: center;
        gap: 20px;
    }
    
    .header-icon {
        margin: 0;
    }
    
    .nav-tab-wrapper-modern {
        flex-direction: column;
    }
    
    .nav-tab-wrapper-modern .nav-tab {
        text-align: center;
        border-bottom: 1px solid #e9ecef;
    }
    
    .nav-tab-wrapper-modern .nav-tab:last-child {
        border-bottom: none;
    }
    
    .form-table th {
        width: auto;
        display: block;
        padding-bottom: 8px;
    }
    
    .form-table td {
        display: block;
        padding-left: 0;
        padding-top: 0;
    }
    
    .card-content {
        padding: 20px;
    }
}

/* Loading animation */
.loading {
    opacity: 0.6;
    pointer-events: none;
}

/* Success feedback */
.success-feedback {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
    border-radius: 6px;
    padding: 12px;
    margin: 16px 0;
    animation: fadeIn 0.3s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Custom checkbox styling */
.form-table input[type="checkbox"] {
    appearance: none;
    width: 18px;
    height: 18px;
    border: 2px solid #ddd;
    border-radius: 3px;
    background: white;
    cursor: pointer;
    position: relative;
    margin-right: 10px;
    flex-shrink: 0;
}

.form-table input[type="checkbox"]:checked {
    background: #667eea;
    border-color: #667eea;
}

.form-table input[type="checkbox"]:checked::before {
    content: '✓';
    position: absolute;
    top: -2px;
    left: 1px;
    color: white;
    font-size: 14px;
    font-weight: bold;
}

.form-table input[type="checkbox"]:hover {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}
</style>

<script>
jQuery(document).ready(function($) {
    // Tab functionality
    $('.nav-tab').click(function(e) {
        e.preventDefault();
        
        // Remove active class from all tabs and content
        $('.nav-tab').removeClass('nav-tab-active');
        $('.tab-content').removeClass('active');
        
        // Add active class to clicked tab
        $(this).addClass('nav-tab-active');
        
        // Show corresponding content
        var target = $(this).attr('href');
        $(target).addClass('active');
        
        // Smooth scroll to content
        $('html, body').animate({
            scrollTop: $('.disable-admin-bloats-content').offset().top - 20
        }, 300);
    });
    
    // Reset settings
    $('#reset-settings').click(function() {
        if (confirm('<?php echo esc_js( __( 'Are you sure you want to reset all settings? This cannot be undone.', 'disable-admin-bloats' ) ); ?>')) {
            $('input[type="checkbox"]').prop('checked', false);
            showSuccessMessage('<?php echo esc_js( __( 'Settings have been reset. Don\'t forget to save changes.', 'disable-admin-bloats' ) ); ?>');
        }
    });
    
    // Export settings
    $('#export-settings').click(function() {
        var settings = {};
        $('input[type="checkbox"]').each(function() {
            var name = $(this).attr('name');
            if (name && name.indexOf('disable_admin_bloats_options[') === 0) {
                var key = name.replace('disable_admin_bloats_options[', '').replace(']', '');
                settings[key] = $(this).is(':checked') ? 1 : 0;
            }
        });
        
        var exportData = {
            plugin: 'disable-admin-bloats',
            version: '<?php echo esc_js( DISABLE_ADMIN_BLOATS_VERSION ); ?>',
            export_date: new Date().toISOString(),
            settings: settings
        };
        
        var dataStr = "data:text/json;charset=utf-8," + encodeURIComponent(JSON.stringify(exportData, null, 2));
        var downloadAnchorNode = document.createElement('a');
        downloadAnchorNode.setAttribute("href", dataStr);
        downloadAnchorNode.setAttribute("download", "disable-admin-bloats-settings-" + new Date().toISOString().slice(0,10) + ".json");
        document.body.appendChild(downloadAnchorNode);
        downloadAnchorNode.click();
        downloadAnchorNode.remove();
        
        showSuccessMessage('<?php echo esc_js( __( 'Settings exported successfully!', 'disable-admin-bloats' ) ); ?>');
    });
    
    // Import settings
    $('#import-settings').click(function() {
        $('#import-file').click();
    });
    
    $('#import-file').change(function(e) {
        var file = e.target.files[0];
        if (!file) return;
        
        if (file.type !== 'application/json') {
            alert('<?php echo esc_js( __( 'Please select a valid JSON file.', 'disable-admin-bloats' ) ); ?>');
            return;
        }
        
        var reader = new FileReader();
        reader.onload = function(e) {
            try {
                var importData = JSON.parse(e.target.result);
                
                // Validate the import data
                if (!importData.plugin || importData.plugin !== 'disable-admin-bloats') {
                    alert('<?php echo esc_js( __( 'Invalid Disable Admin Bloats settings file.', 'disable-admin-bloats' ) ); ?>');
                    return;
                }
                
                if (!importData.settings) {
                    alert('<?php echo esc_js( __( 'No settings found in the file.', 'disable-admin-bloats' ) ); ?>');
                    return;
                }
                
                // Confirm import
                var confirmMessage = '<?php echo esc_js( __( 'This will replace your current settings. Continue?', 'disable-admin-bloats' ) ); ?>';
                if (importData.export_date) {
                    confirmMessage += '\n\n' + '<?php echo esc_js( __( 'Export Date:', 'disable-admin-bloats' ) ); ?> ' + new Date(importData.export_date).toLocaleDateString();
                }
                if (importData.version) {
                    confirmMessage += '\n' + '<?php echo esc_js( __( 'Version:', 'disable-admin-bloats' ) ); ?> ' + importData.version;
                }
                
                if (!confirm(confirmMessage)) {
                    return;
                }
                
                // Apply settings
                var importedCount = 0;
                $('input[type="checkbox"]').each(function() {
                    var name = $(this).attr('name');
                    if (name && name.indexOf('disable_admin_bloats_options[') === 0) {
                        var key = name.replace('disable_admin_bloats_options[', '').replace(']', '');
                        if (importData.settings.hasOwnProperty(key)) {
                            $(this).prop('checked', importData.settings[key] == 1);
                            importedCount++;
                        }
                    }
                });
                
                showSuccessMessage('<?php echo esc_js( __( 'Settings imported successfully!', 'disable-admin-bloats' ) ); ?>' + ' (' + importedCount + ' ' + '<?php echo esc_js( __( 'settings', 'disable-admin-bloats' ) ); ?>' + ')\n\n' + '<?php echo esc_js( __( 'Don\'t forget to save your changes.', 'disable-admin-bloats' ) ); ?>');
                
                // Trigger the disable_all_bloat logic if it was imported
                if (importData.settings.disable_all_bloat == 1) {
                    $('#disable_admin_bloats_options_disable_all_bloat').trigger('change');
                }
                
            } catch (error) {
                console.error('Import error:', error);
                alert('<?php echo esc_js( __( 'Error reading the settings file. Please check if it\'s a valid JSON file.', 'disable-admin-bloats' ) ); ?>');
            }
        };
        
        reader.readAsText(file);
        
        // Reset the file input
        $(this).val('');
    });
    
    // Master toggle functionality
    $('#disable_admin_bloats_options_disable_all_bloat').change(function() {
        var isChecked = $(this).is(':checked');
        if (isChecked) {
            if (confirm('<?php echo esc_js( __( 'This will enable all bloat removal features. Continue?', 'disable-admin-bloats' ) ); ?>')) {
                $('input[type="checkbox"]').not(this).prop('checked', false).prop('disabled', true);
                showSuccessMessage('<?php echo esc_js( __( 'All bloat removal features enabled. Don\'t forget to save!', 'disable-admin-bloats' ) ); ?>');
            } else {
                $(this).prop('checked', false);
            }
        } else {
            $('input[type="checkbox"]').prop('disabled', false);
        }
    });
    
    // Initial state for master toggle
    if ($('#disable_admin_bloats_options_disable_all_bloat').is(':checked')) {
        $('input[type="checkbox"]').not('#disable_admin_bloats_options_disable_all_bloat').prop('disabled', true);
    }
    
    // Success message function
    function showSuccessMessage(message) {
        var successDiv = $('<div class="success-feedback">' + message + '</div>');
        $('.submit-card').prepend(successDiv);
        setTimeout(function() {
            successDiv.fadeOut(function() {
                $(this).remove();
            });
        }, 4000);
    }
    
    // Form submission feedback
    $('#save-settings-btn').click(function() {
        $(this).text('<?php echo esc_js( __( 'Saving...', 'disable-admin-bloats' ) ); ?>').prop('disabled', true);
        setTimeout(function() {
            $('#save-settings-btn').text('<?php echo esc_js( __( 'Save Settings', 'disable-admin-bloats' ) ); ?>').prop('disabled', false);
        }, 1000);
    });
    
    // Add smooth hover effects
    $('.nav-tab, .button, input[type="checkbox"]').hover(
        function() { $(this).addClass('hover'); },
        function() { $(this).removeClass('hover'); }
    );
});
</script>