<?php
/*
Plugin Name: Anti Bloat - Disable WordPress Bloat & Notices
Plugin URI: https://wp-zip.com/anti-bloat
Description: A comprehensive plugin to disable WordPress bloats, notices, and performance hindrances. Features granular controls for admin notices, WooCommerce messages, dashboard widgets, and more. Perfect for developers!
Version: 3.0.0
Author: wp-zip
Author URI: https://wp-zip.com
Text Domain: anti-bloat
Domain Path: /languages
Requires at least: 5.0
Tested up to: 6.8.3
Requires PHP: 7.4
WC requires at least: 5.0
WC tested up to: 10.8.4
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Network: false
*/

// If this file is called directly, abort!!!
defined( 'ABSPATH' ) or die( 'Hey, what are you doing here?' );

// Define plugin constants
define( 'ANTI_BLOAT_VERSION', '3.0.0' );
define( 'ANTI_BLOAT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'ANTI_BLOAT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'ANTI_BLOAT_BASENAME', plugin_basename( __FILE__ ) );

// Include the plugin class file
require_once ANTI_BLOAT_PLUGIN_DIR . 'includes/class-anti-bloat.php';

// Initialize the plugin
function anti_bloat_init() {
    // Load text domain for internationalization
    load_plugin_textdomain( 'anti-bloat', false, dirname( ANTI_BLOAT_BASENAME ) . '/languages' );
    
    // Instantiate the plugin class
    new AntiBloatPlugin();
}

// Hook the initialization
add_action( 'plugins_loaded', 'anti_bloat_init' );
