<?php
/**
 * Canonical option getter for AnchorKit settings.
 *
 * Keep this lightweight so it can be loaded early by `includes/init.php`.
 *
 * @package AnchorKit_TOC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Get an AnchorKit option value.
 *
 * @param string $option_name The option name.
 * @param mixed  $default     The default value.
 * @return mixed
 */
function anchorkit_get_option( $option_name, $default = false ) {
	$option_name = is_string( $option_name ) ? sanitize_key( $option_name ) : '';
	if ( '' === $option_name ) {
		return $default;
	}

	return get_option( $option_name, $default );
}
