<?php
/**
 * Layout and branding functions.
 *
 * @package AnchorKit_TOC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Render the AnchorKit branding header.
 *
 * @return void
 */
function anchorkit_render_branding() {
	$logo_url = plugins_url( 'assets/anchorkit-logo.svg', ANCHORKIT_PLUGIN_FILE );
	?>
	<div class="anchorkit-header">
		<!-- Animated Square Logo -->
		<div class="anchorkit-animated-logo">
			<svg width="48" height="48" viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg">
				<rect width="200" height="200" fill="transparent" />
				<path id="anchorkit-square-1" d="M0 0H100V100H0V0Z" fill="#BBD0FF" />
				<path id="anchorkit-square-2" d="M100 0H200V100H100V0Z" fill="#E7C6FF" />
				<path id="anchorkit-square-3" d="M100 100H200V200H100V100Z" fill="#B8C0FF" />
				<path id="anchorkit-square-4" d="M0 100H100V200H0V100Z" fill="#C8B6FF" />
			</svg>
		</div>

		<!-- AnchorKit Text Logo -->
		<h1 class="anchorkit-text-logo">AnchorKit</h1>
	</div>
	<?php
}
