<?php
class AmwalpBa
{
    public static function HttpRequest($apiPath, $data = array())
    {
        try {
            $args = array(
                'headers' => array(
                    'Content-Type' => 'application/json',
                    'User-Agent' => self::sanitizeVar('HTTP_USER_AGENT', 'SERVER')
                ),
                'body' => wp_json_encode($data),
                'method' => 'POST',
                'data_format' => 'body',
                'timeout' => 15,
            );

            $response = wp_remote_post($apiPath, $args);

            if (is_wp_error($response)) {
                throw new Exception('HTTP request error: ' . $response->get_error_message());
            }

            $body = wp_remote_retrieve_body($response);

            return json_decode($body, false);
        } catch (\Exception $e) {
            WC_Admin_Settings::add_error($e->getMessage());
        }
    }
    public static function CreateBaAmwalpayCardsTable()
    {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}ba_amwalpay_cards_token (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			user_id bigint(20) NOT NULL,
			token varchar(56) DEFAULT '' NOT NULL,
            merchant_id varchar(56) DEFAULT '' NOT NULL,
			environment varchar(56) DEFAULT '' NOT NULL,
			PRIMARY KEY  (id),
			KEY user_id (user_id)
		) $charset_collate;";
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function getUserTokens($live, $merchant_id, $secret_key)
    {
        $token = '';
        if (is_user_logged_in()) {
            global $wpdb;
            $current_user = wp_get_current_user();
            $user_id = $current_user->ID;
            $results = $wpdb->get_results(
                 $wpdb->prepare(
                    "SELECT * FROM {$wpdb->prefix}ba_amwalpay_cards_token WHERE user_id = %d and merchant_id = %s and environment = %s",
                    $user_id,
                    $merchant_id,
                    $live
                ),
                OBJECT
            );

            if ($results) {
                $api_url = self::getApiUrl($live);
                $data['customerId'] = $results[0]->token;
                $data['merchantId'] = $merchant_id;
                $data['secureHashValue'] = self::generateStringForFilter($data, $secret_key);

                $webhook_url = $api_url['webhook'];
                $sessionTokenRes = self::HttpRequest($webhook_url . 'Customer/GetSmartboxDirectCallSessionToken', $data);
                AmwalpBa::addLogs('1', WP_CONTENT_DIR . '/uploads/ba_amwalpay.log', 'In api Customer/GetSmartboxDirectCallSessionToken: ', print_r($sessionTokenRes, 1));
                if (isset($sessionTokenRes) && isset($sessionTokenRes->data) && isset($sessionTokenRes->data->sessionToken)) {
                    $token = $sessionTokenRes->data->sessionToken;
                }
            }
        }
        return $token;
    }
    public static function getApiUrl($env)
    {
        if ($env == "prod") {
            return ['smartbox' => 'https://checkout.amwalpg.com/js/SmartBox.js?v=1.1', 'webhook' => 'https://webhook.amwalpg.com/'];
        } else if ($env == "uat") {
            return ['smartbox' => 'https://test.amwalpg.com:7443/js/SmartBox.js?v=1.1', 'webhook' => 'https://test.amwalpg.com:14443/'];
        } else if ($env == "sit") {
            return ['smartbox' => 'https://test.amwalpg.com:19443/js/SmartBox.js?v=1.1', 'webhook' => 'https://test.amwalpg.com:24443/'];
        }
    }
    public static function getCurrentUrlWithoutSmartbox()
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'
            || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

        $host = $_SERVER['HTTP_HOST'];
        $requestUri = $_SERVER['REQUEST_URI'];

        // Parse URL
        $urlParts = parse_url($protocol . $host . $requestUri);

        $query = [];
        if (isset($urlParts['query'])) {
            parse_str($urlParts['query'], $query);

            // Remove smartbox parameter
            unset($query['ba_smartbox']);
        }

        // Build new URL
        $newUrl = $protocol . $host . $urlParts['path'];
        if (!empty($query)) {
            $newUrl .= '?' . http_build_query($query);
        }

        return $newUrl;
    }
    public static function generateString(
        $amount,
        $currencyId,
        $merchantId,
        $merchantReference,
        $terminalId,
        $hmacKey,
        $trxDateTime,
        $sessionToken
    ) {

        $string = "Amount={$amount}&CurrencyId={$currencyId}&MerchantId={$merchantId}&MerchantReference={$merchantReference}&RequestDateTime={$trxDateTime}&SessionToken={$sessionToken}&TerminalId={$terminalId}";

        $sign = self::encryptWithSHA256($string, $hmacKey);
        return strtoupper($sign);
    }

    public static function encryptWithSHA256($input, $hexKey)
    {
        // Convert the hex key to binary
        $binaryKey = hex2bin($hexKey);
        // Calculate the SHA-256 hash using hash_hmac
        $hash = hash_hmac('sha256', $input, $binaryKey);
        return $hash;
    }
    public static function generateStringForFilter(
        $data,
        $hmacKey

    ) {
        // Convert data array to string key value with and sign
        $string = '';
        foreach ($data as $key => $value) {
            $string .= $key . '=' . ($value === "null" || $value === "undefined" ? '' : $value) . '&';
        }
        $string = rtrim($string, '&');
        // Generate SIGN
        $sign = self::encryptWithSHA256($string, $hmacKey);
        return strtoupper($sign);
    }
    public static function sanitizeVar($name, $global = 'GET')
    {
        if (isset($GLOBALS['_' . $global][$name])) {
            if (is_array($GLOBALS['_' . $global][$name])) {
                return $GLOBALS['_' . $global][$name];
            }
            return htmlspecialchars($GLOBALS['_' . $global][$name], ENT_QUOTES);
        }
        return null;
    }

    public static function addLogs($debug, $file, $note, $data = false)
    {
        if (is_bool($data)) {
            ('1' === $debug) ? error_log(PHP_EOL . gmdate('d.m.Y h:i:s') . ' - ' . $note, 3, $file) : false;
        } else {
            ('1' === $debug) ? error_log(PHP_EOL . gmdate('d.m.Y h:i:s') . ' - ' . $note . ' -- ' . json_encode($data), 3, $file) : false;
        }
    }

}