<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

/**
 * Class LiteBackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class LiteBackendStrings
{
    /**
     * @var array|null
     */
    protected static $liteStrings = null;

    /**
     * Returns a single settings string by key
     *
     * @param string $key
     *
     * @return string
     */
    public static function get($key)
    {
        if (self::$liteStrings === null) {
            self::$liteStrings = self::getAllStrings();
        }

        return self::$liteStrings[$key] ?? '';
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getAllStrings()
    {
        return [
            'admin'                                            => __('Admin', 'ameliabooking'),
            'add_date'                                         => __('Add Date', 'ameliabooking'),
            'add_period'                                       => __('Add period', 'ameliabooking'),
            'all_services'                                     => __('All services', 'ameliabooking'),
            'amount_colon'                                     => __('Amount:', 'ameliabooking'),
            'appointment'                                      => __('Appointment', 'ameliabooking'),
            'appointments'                                     => __('Appointments', 'ameliabooking'),
            'approved'                                         => __('Approved', 'ameliabooking'),
            'attendee'                                         => __('Attendee', 'ameliabooking'),
            'birthday'                                         => __('Birthday', 'ameliabooking'),
            'booked'                                           => __('Booked', 'ameliabooking'),
            'booking'                                          => __('Booking', 'ameliabooking'),
            'bookings'                                         => __('Bookings', 'ameliabooking'),
            'cancel'                                           => __('Cancel', 'ameliabooking'),
            'canceled'                                         => __('Canceled', 'ameliabooking'),
            'content_mode_tooltip'                             => __('HTML formatting may be overridden by plain text formatting upon switching between modes.', 'ameliabooking'),
            'close'                                            => __('Close', 'ameliabooking'),
            'closed'                                           => __('Closed', 'ameliabooking'),
            'csv_delimiter'                                    => __('Select delimiter', 'ameliabooking'),
            'csv_delimiter_comma'                              => __('Comma (,)', 'ameliabooking'),
            'continue'                                         => __('Continue', 'ameliabooking'),
            'coupon_code'                                      => __('Coupon code', 'ameliabooking'),
            'customer'                                         => __('Customer', 'ameliabooking'),
            'minutes'                                          => __('Minutes', 'ameliabooking'),
            'hour'                                             => __('Hour', 'ameliabooking'),
            'hours'                                            => __('Hours', 'ameliabooking'),
            'day'                                              => __('Day', 'ameliabooking'),
            'days'                                             => __('Days', 'ameliabooking'),
            'week'                                             => __('Week', 'ameliabooking'),
            'weeks'                                            => __('Weeks', 'ameliabooking'),
            'month'                                            => __('Month', 'ameliabooking'),
            'months'                                           => __('Months', 'ameliabooking'),
            'year'                                             => __('Year', 'ameliabooking'),
            'date'                                             => __('Date', 'ameliabooking'),
            'delete'                                           => __('Delete', 'ameliabooking'),
            'description'                                      => __('Description', 'ameliabooking'),
            'details'                                          => __('Details', 'ameliabooking'),
            'disabled'                                         => __('Disabled', 'ameliabooking'),
            'duration'                                         => __('Duration', 'ameliabooking'),
            'duplicate'                                        => __('Duplicate', 'ameliabooking'),
            'edit'                                             => __('Edit', 'ameliabooking'),
            'employee'                                         => __('Employee', 'ameliabooking'),
            'employees'                                        => __('Employees', 'ameliabooking'),
            'employee_badge'                                   => __('Employee Badge', 'ameliabooking'),
            'employee_badges'                                  => __('Employee badges', 'ameliabooking'),
            'company_days_off'                                 => __('Company days off', 'ameliabooking'),
            'employee_days_off'                                => __('Employee days off', 'ameliabooking'),
            'enter_email_warning'                              => __('Please enter an email.', 'ameliabooking'),
            'enter_valid_email_warning'                        => __('Please enter a valid email address', 'ameliabooking'),
            'error'                                            => __('Error', 'ameliabooking'),
            'error_occurred'                                   => __('Error occurred', 'ameliabooking'),
            'event'                                            => __('Event', 'ameliabooking'),
            'events'                                           => __('Events', 'ameliabooking'),
            'export'                                           => __('Export', 'ameliabooking'),
            'extra'                                            => __('Extra', 'ameliabooking'),
            'extras'                                           => __('Extras', 'ameliabooking'),
            'extras_total_price'                               => __('Extras total price', 'ameliabooking'),
            'google_calendar'                                  => __('Google Calendar', 'ameliabooking'),
            'google_meet_join'                                 => __('Join with Google Meet', 'ameliabooking'),
            'outlook_calendar'                                 => __('Outlook Calendar', 'ameliabooking'),
            'microsoft_teams_join'                             => __('Join with Microsoft Teams', 'ameliabooking'),
            'apple_calendar'                                   => __('Apple Calendar', 'ameliabooking'),
            'h'                                                => __('h', 'ameliabooking'),
            'id'                                               => __('ID', 'ameliabooking'),
            'lesson_space'                                     => __('Lesson Space', 'ameliabooking'),
            'licence_description'                              => __('Interested in unlocking this feature?', 'ameliabooking'),
            'licence_start_description'                        => __('Available from Starter license', 'ameliabooking'),
            'licence_basic_description'                        => __('Available from Standard license', 'ameliabooking'),
            'licence_pro_description'                          => __('Available from Pro license', 'ameliabooking'),
            'licence_dev_description'                          => __('Available in Elite licence', 'ameliabooking'),
            'licence_button_text'                              => __('Upgrade', 'ameliabooking'),
            'delete_amelia_short'                              => __('Delete Amelia content', 'ameliabooking'),
            'delete_amelia'                                    => __('Delete tables, roles, files and settings once the Amelia plugin is deleted.', 'ameliabooking'),
            'delete_amelia_tooltip'                            => __('Enable this option if you want to delete plugin tables, roles, files and settings<br>when deleting the plugin from plugins page', 'ameliabooking'),
            'appointment_space_name'                           => __('Appointment space name', 'ameliabooking'),
            'event_space_name'                                 => __('Event space name', 'ameliabooking'),
            'lesson_space_join'                                => __('Join Space', 'ameliabooking'),
            'lesson_space_pending'                             => __('Create spaces for pending appointments', 'ameliabooking'),
            'limit_extra_people'                               => __('Limit additional people', 'ameliabooking'),
            'limit_extra_people_tooltip'                       => __('Set a maximum number of people a customer can add when booking.', 'ameliabooking'),
            'location'                                         => __('Location', 'ameliabooking'),
            'locations'                                        => __('Locations', 'ameliabooking'),
            'min'                                              => __('min', 'ameliabooking'),
            'measurement_id'                                   => __('Measurement ID', 'ameliabooking'),
            'name'                                             => __('Name', 'ameliabooking'),
            'enter_name_warning'                               => __('Please enter a name.', 'ameliabooking'),
            'name_ascending'                                   => __('Name Asc', 'ameliabooking'),
            'name_descending'                                  => __('Name Desc', 'ameliabooking'),
            'need_help'                                        => __('Need help?', 'ameliabooking'),
            'no'                                               => __('No', 'ameliabooking'),
            'no-show'                                          => __('No-show', 'ameliabooking'),
            'note'                                             => __('Note', 'ameliabooking'),
            'note_internal'                                    => __('Note (internal)', 'ameliabooking'),
            'notifications'                                    => __('Notifications', 'ameliabooking'),
            'on_site'                                          => __('On-site', 'ameliabooking'),
            'opened'                                           => __('Opened', 'ameliabooking'),
            'open'                                             => __('Open', 'ameliabooking'),
            'packages'                                         => __('Packages', 'ameliabooking'),
            'paid'                                             => __('Paid', 'ameliabooking'),
            'partially_paid'                                   => __('Partially paid', 'ameliabooking'),
            'payment'                                          => __('Payment', 'ameliabooking'),
            'payment_amount'                                   => __('Payment amount', 'ameliabooking'),
            'payment_id_colon'                                 => __('Payment ID:', 'ameliabooking'),
            'payment_method'                                   => __('Payment method', 'ameliabooking'),
            'payment_status'                                   => __('Payment status', 'ameliabooking'),
            'payment_tooltip'                                  => __('If all payment methods are disabled on the service/event, the default payment method will be used.', 'ameliabooking'),
            'pdf'                                              => __('PDF', 'ameliabooking'),
            'pending'                                          => __('Pending', 'ameliabooking'),
            'phone'                                            => __('Phone', 'ameliabooking'),
            'refunded'                                         => __('Refunded', 'ameliabooking'),
            'rejected'                                         => __('Rejected', 'ameliabooking'),
            'resources'                                        => __('Resources', 'ameliabooking'),
            'save'                                             => __('Save', 'ameliabooking'),
            'select_date_warning'                              => __('Please select a date.', 'ameliabooking'),
            'select_time_warning'                              => __('Please select a time.', 'ameliabooking'),
            'service'                                          => __('Service', 'ameliabooking'),
            'services'                                         => __('Services', 'ameliabooking'),
            'settings_saved'                                   => __('Settings have been saved.', 'ameliabooking'),
            'social_login'                                     => __('Social login', 'ameliabooking'),
            'status'                                           => __('Status', 'ameliabooking'),
            'status_colon'                                     => __('Status:', 'ameliabooking'),
            'success'                                          => __('Success', 'ameliabooking'),
            'text_mode'                                        => __('Text', 'ameliabooking'),
            'html_mode'                                        => __('HTML', 'ameliabooking'),
            'tag'                                              => __('Tag', 'ameliabooking'),
            'to'                                               => __('To', 'ameliabooking'),
            'today'                                            => __('Today', 'ameliabooking'),
            'tomorrow'                                         => __('Tomorrow', 'ameliabooking'),
            'total'                                            => __('Total', 'ameliabooking'),
            'translate'                                        => __('Translate', 'ameliabooking'),
            'waiting'                                          => __('Waiting', 'ameliabooking'),
            'weekday_friday'                                   => __('Friday', 'ameliabooking'),
            'weekday_monday'                                   => __('Monday', 'ameliabooking'),
            'weekday_saturday'                                 => __('Saturday', 'ameliabooking'),
            'weekday_sunday'                                   => __('Sunday', 'ameliabooking'),
            'weekday_thursday'                                 => __('Thursday', 'ameliabooking'),
            'weekday_tuesday'                                  => __('Tuesday', 'ameliabooking'),
            'weekday_wednesday'                                => __('Wednesday', 'ameliabooking'),
            'yes'                                              => __('Yes', 'ameliabooking'),
            'zoom'                                             => __('Zoom', 'ameliabooking'),
            'zoom_click_to_join'                               => __('Join Zoom', 'ameliabooking'),
            'zoom_click_to_start'                              => __('Start Zoom', 'ameliabooking'),
            'view_grid'                                        => __('Grid view', 'ameliabooking'),
            'view_list'                                        => __('List view', 'ameliabooking'),
            'whats_new'                                        => __('What\'s New', 'ameliabooking'),
            'layout_select_label'                              => __('Choose layout version', 'ameliabooking'),
            'layout_dropdown'                                  => __('Dropdown layout', 'ameliabooking'),
            'layout_list'                                      => __('List layout', 'ameliabooking'),
            'layout_description'                               => __('Choosing layout of first step in step by step form', 'ameliabooking'),
            'xml'                                              => __('XML', 'ameliabooking'),
            'recurring'                                        => __('Recurring', 'ameliabooking'),
            'payment_warning'                                  => __('You have disabled all available payment methods. The default payment method from the general settings will be used instead.', 'ameliabooking'),
            'type'                                             => __('Type', 'ameliabooking'),
            'all_events'                                       => __('All events', 'ameliabooking'),
            'add'                                              => __('Add', 'ameliabooking'),
            'integrations'                                     => __('Integrations', 'ameliabooking'),
            'import'                                           => __('Import', 'ameliabooking'),
            'all'                                              => __('All', 'ameliabooking'),
            'from'                                             => __('From', 'ameliabooking'),
            'tax'                                              => __('Tax', 'ameliabooking'),
            'event_tickets'                                    => __('Tickets', 'ameliabooking'),
            '1year'                                            => __('1 year', 'ameliabooking'),
            'activate'                                         => __('Activate', 'ameliabooking'),
            'activation'                                       => __('Activation', 'ameliabooking'),
            'address'                                          => __('Address', 'ameliabooking'),
            'after'                                            => __('After', 'ameliabooking'),
            'after_with_space'                                 => __('After with space', 'ameliabooking'),
            'allow_booking_if_pending_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to book appointment with Pending status above the maximum capacity. Once the maximum capacity is reached appointment will close and time slot will become unavailable.', 'ameliabooking'),
            'allow_booking_if_not_min_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to submit a booking unless they fill in the minimum service capacity, but once they book for any capacity above minimum, the time slot will become unavailable for booking for others. If enabled, multiple customers will be able to book the same time slot, without having to fill in the minimum capacity.', 'ameliabooking'),
            'allow_booking_if_not_min'                         => __('Allow booking below minimum capacity', 'ameliabooking'),
            'allow_admin_book_at_any_time'                     => __('Allow admin to book appointment at any time', 'ameliabooking'),
            'allow_admin_book_over_app'                        => __('Allow admin to book over an existing appointment', 'ameliabooking'),
            'allow_admin_book_at_any_time_tooltip'             => __('If you enable this option, Admin will be able to book appointment at any time (working hours, special days and days off for all employees will be ignored).', 'ameliabooking'),
            'allow_admin_book_over_app_tooltip'                => __('If you enable this option, Admin will be able to book appointment over or during another appointment.', 'ameliabooking'),
            'allow_configure_days_off'                         => __('Allow employees to manage their special days', 'ameliabooking'),
            'allow_configure_services'                         => __('Allow employees to manage their services', 'ameliabooking'),
            'allow_configure_schedule'                         => __('Allow employees to manage their schedule', 'ameliabooking'),
            'allow_configure_special_days'                     => __('Allow employees to manage their days off', 'ameliabooking'),
            'allow_booking_if_pending'                         => __('Allow booking above maximum capacity', 'ameliabooking'),
            'allow_customer_reschedule'                        => __('Allow customers to reschedule their own appointments', 'ameliabooking'),
            'allow_customer_reschedule_tooltip'                => __('Enable this option if you want to allow your customers to reschedule their own appointments.', 'ameliabooking'),
            'allow_customer_delete_profile'                    => __('Allow customers to delete their profile', 'ameliabooking'),
            'allow_customer_cancel_packages'                   => __('Allow customers to cancel packages', 'ameliabooking'),
            'allow_write_appointments'                         => __('Allow employees to manage their appointments', 'ameliabooking'),
            'allow_write_events'                               => __('Allow employees to manage their events', 'ameliabooking'),
            'allow_write_customers'                            => __('Allow employees to manage customers', 'ameliabooking'),
            'api_url'                                          => __('API base URL: ', 'ameliabooking'),
            'maximum_capacity'                                 => __('Maximum capacity', 'ameliabooking'),
            'waiting_list'                                     => __('Waiting list', 'ameliabooking'),
            'events_waiting_list'                              => __('Events waiting list', 'ameliabooking'),
            'appointments_waiting_list'                        => __('Appointments waiting list', 'ameliabooking'),
            'show_waiting_list_booking_full'                   => __('Show waiting list after booking is full', 'ameliabooking'),
            'approve_appointment_success_url'                  => __('Redirect URL for successfully approved booking', 'ameliabooking'),
            'approve_appointment_error_url'                    => __('Redirect URL for unsuccessfully approved booking', 'ameliabooking'),
            'automatically_create_customer'                    => __('Automatically create Amelia Customer user', 'ameliabooking'),
            'automatically_create_customer_tooltip'            => __('If you enable this option every time a new customer schedules the appointment he will get Amelia Customer user role and automatic email with login details.', 'ameliabooking'),
            'back_links'                                       => __('Support Amelia by displaying a backlink', 'ameliabooking'),
            'back_links_tooltip'                               => __('Allow the short description below the booking form to support Amelia Booking Plugin and spread the word about it.', 'ameliabooking'),
            'bcc_email'                                        => __('Send all notifications to additional addresses', 'ameliabooking'),
            'bcc_email_tooltip'                                => __('Here you can enter additional email addresses where all notifications will be sent. To add an address click Enter.', 'ameliabooking'),
            'bcc_sms'                                          => __('Send all SMS messages to additional numbers', 'ameliabooking'),
            'bcc_sms_tooltip'                                  => __('Here you can enter additional phone numbers where all SMS messages will be sent. To add a number click Enter.', 'ameliabooking'),
            'before'                                           => __('Before', 'ameliabooking'),
            'before_with_space'                                => __('Before with space', 'ameliabooking'),
            'bringing_anyone_logic'                            => __('People counting logic', 'ameliabooking'),
            'bringing_anyone_logic_additional'                 => __('Customer plus additional people', 'ameliabooking'),
            'bringing_anyone_logic_additional_tt'              => __('Counts one primary customer plus any additional people they add.', 'ameliabooking'),
            'bringing_anyone_logic_total'                      => __('Total people', 'ameliabooking'),
            'bringing_anyone_logic_total_tt'                   => __('Counts the total number of people entered, including the primary customer.', 'ameliabooking'),
            'buffer_time_in_slot'                              => __('Include service buffer time in time slots', 'ameliabooking'),
            'buffer_time_in_slot_tooltip'                      => __('Include buffer time in slot calculation. When disabled, slots are based only on service duration.', 'ameliabooking'),
            'coupons_case_insensitive'                         => __('Set coupons to be case insensitive', 'ameliabooking'),
            'calendar'                                         => __('Calendar', 'ameliabooking'), // duplicate value 'show_event_view_calendar'
            'cancel_error_url'                                 => __('Unsuccessful cancellation redirect URL', 'ameliabooking'),
            'cancel_error_url_tooltip'                         => __('URL on which will user be redirected if appointment can\'t be canceled because of \'Minimum time required before canceling\' value', 'ameliabooking'),
            'cancel_success_url'                               => __('Successful cancellation redirect URL', 'ameliabooking'),
            'comma_dot'                                        => __('Comma-dot', 'ameliabooking'),
            'company'                                          => __('Company', 'ameliabooking'),
            'country'                                          => __('Country', 'ameliabooking'),
            'coupons'                                          => __('Coupons', 'ameliabooking'),
            'facebook_pixel'                                   => __('Meta Pixel', 'ameliabooking'),
            'google_analytics'                                 => __('Google Analytics', 'ameliabooking'),
            'generate'                                         => __('Generate', 'ameliabooking'),
            'employee_selection_logic'                         => __('Employee selection logic', 'ameliabooking'),
            'employee_selection_logic_random'                  => __('Random', 'ameliabooking'),
            'currency'                                         => __('Currency', 'ameliabooking'),
            'customers_as_attendees'                           => __('Add event attendees', 'ameliabooking'),
            'customer_cabinet'                                 => __('Customer Panel Page URL', 'ameliabooking'),
            'employee_cabinet'                                 => __('Employee panel page URL', 'ameliabooking'),
            'default_appointment_status'                       => __('Default appointment status', 'ameliabooking'),
            'default_appointment_status_tooltip'               => __('All appointments will be scheduled with the status selected here.', 'ameliabooking'),
            'default_items_per_page'                           => __('Default number of items per page on the front end', 'ameliabooking'),
            'default_items_per_page_backend'                   => __('Default number of items per page on the back end', 'ameliabooking'),
            'default_page_on_backend'                          => __('Default back‑end page', 'ameliabooking'),
            'default_payment_method'                           => __('Default payment method', 'ameliabooking'),
            'default_phone_country_code'                       => __('Default phone country code', 'ameliabooking'),
            'default_time_slot_step'                           => __('Default time slot step', 'ameliabooking'),
            'default_time_slot_step_tooltip'                   => __('The time slot step defined here will apply to all time slots across the plugin.', 'ameliabooking'),
            'dot_comma'                                        => __('Dot-comma', 'ameliabooking'),
            'see_unavailable_features'                         => __('Hide locked features', 'ameliabooking'),
            'envato_api_activate'                              => __('Activate with Envato', 'ameliabooking'),
            'event_title_and_description'                      => __('Event title and description', 'ameliabooking'),
            'mailchimp'                                        => __('Mailchimp', 'ameliabooking'),
            'meeting_title'                                    => __('Meeting title', 'ameliabooking'),
            'meeting_agenda'                                   => __('Meeting agenda', 'ameliabooking'),
            'facebook_app_id'                                  => __('Facebook app ID', 'ameliabooking'),
            'facebook_app_secret'                              => __('Facebook app secret', 'ameliabooking'),
            'general'                                          => __('General', 'ameliabooking'),
            'gMap_api_key'                                     => __('Google Map API key', 'ameliabooking'),
            'gMap_api_key_tooltip'                             => __('Add Google Map API Key to show Google static map on "Locations" page.', 'ameliabooking'),
            'google_client_id'                                 => __('Client ID', 'ameliabooking'),
            'google_client_secret'                             => __('Client secret', 'ameliabooking'),
            'outlook_client_id'                                => __('Application (client) ID', 'ameliabooking'),
            'outlook_client_secret'                            => __('Client secret', 'ameliabooking'),
            'google_redirect_uri'                              => __('Redirect URI', 'ameliabooking'),
            'outlook_redirect_uri'                             => __('Redirect URI', 'ameliabooking'),
            'apple_client_id'                                  => __('iCloud Email Address', 'ameliabooking'),
            'apple_redirect_uri'                               => __('Redirect URI', 'ameliabooking'),
            'zoom_account_id'                                  => __('Account ID', 'ameliabooking'),
            'zoom_client_id'                                   => __('Client ID', 'ameliabooking'),
            'zoom_client_secret'                               => __('Client secret', 'ameliabooking'),
            'lesson_space_api_key'                             => __('Lesson Space API key', 'ameliabooking'),
            'limit_app_per_customer'                           => __('Limit appointments per customer', 'ameliabooking'),
            'limit_package_per_customer'                       => __('Limit package purchases per customer', 'ameliabooking'),
            'limit_events_per_customer'                        => __('Limit events per customer', 'ameliabooking'),
            'limit_app_per_customer_tt'                        => __('This limit is based on the customer\'s email address.', 'ameliabooking'),
            'log_in'                                           => __('Log In', 'ameliabooking'),
            'log_out'                                          => __('Log out', 'ameliabooking'),
            'invoice_format'                                   => __('Invoice Format', 'ameliabooking'),
            'h1'                                               => __('1h', 'ameliabooking'),
            'h10'                                              => __('10h', 'ameliabooking'),
            'h11'                                              => __('11h', 'ameliabooking'),
            'h12'                                              => __('12h', 'ameliabooking'),
            'h1min30'                                          => __('1h 30min', 'ameliabooking'),
            'h2'                                               => __('2h', 'ameliabooking'),
            'h3'                                               => __('3h', 'ameliabooking'),
            'h4'                                               => __('4h', 'ameliabooking'),
            'h6'                                               => __('6h', 'ameliabooking'),
            'h8'                                               => __('8h', 'ameliabooking'),
            'h9'                                               => __('9h', 'ameliabooking'),
            'identify_country_code'                            => __('Identify country code by user\'s IP address', 'ameliabooking'),
            'insert_pending_appointments'                      => __('Insert pending appointments', 'ameliabooking'),
            'pending_appointments_meetings'                    => __('Create meetings for pending appointments', 'ameliabooking'),
            'inspect_customer_info'                            => __('Check customer\'s name for existing email/phone when booking', 'ameliabooking'),
            'inspect_customer_info_tooltip'                    => __('Enable this option to ensure that customers using an existing email or phone number maintain consistent first and last names.', 'ameliabooking'),
            'mail_service'                                     => __('Mail service', 'ameliabooking'),
            'mailgun'                                          => __('Mailgun', 'ameliabooking'),
            'manage_languages_tooltip'                         => __('Here you can define languages that you want to have in the plugin for translating dynamic strings (names, descriptions, notifications).', 'ameliabooking'),
            'min1'                                             => __('1min', 'ameliabooking'),
            'min10'                                            => __('10min', 'ameliabooking'),
            'min12'                                            => __('12min', 'ameliabooking'),
            'min15'                                            => __('15min', 'ameliabooking'),
            'min2'                                             => __('2min', 'ameliabooking'),
            'min20'                                            => __('20min', 'ameliabooking'),
            'min30'                                            => __('30min', 'ameliabooking'),
            'min45'                                            => __('45min', 'ameliabooking'),
            'min5'                                             => __('5min', 'ameliabooking'),
            'minimum_time_before_booking'                      => __('Minimum time required before booking', 'ameliabooking'),
            'minimum_time_before_booking_tooltip'              => __('Define the time before the appointment during which customers can\'t book.', 'ameliabooking'),
            'minimum_time_before_canceling'                    => __('Minimum time required before canceling', 'ameliabooking'),
            'minimum_time_before_canceling_tooltip'            => __('Define the time before the appointment during which customers can\'t cancel.', 'ameliabooking'),
            'minimum_time_before_rescheduling'                 => __('Minimum time required before rescheduling', 'ameliabooking'),
            'minimum_time_before_rescheduling_tooltip'         => __('Define the time before the appointment during which customers can\'t reschedule.', 'ameliabooking'),
            'notify_customers_default'                         => __('Notify the customer(s) by default', 'ameliabooking'),
            'number_of_events_returned'                        => __('Maximum number of events returned', 'ameliabooking'),
            'or_enter_details_below'                           => __('Or enter details below', 'ameliabooking'),
            'outlook_mail_api'                                 => __('Outlook Mailer', 'ameliabooking'),
            'payment_links_enable'                             => __('Pay with payment link', 'ameliabooking'),
            'payment_links_enable_tooltip'                     => __('If enabled, customers can complete their payment using the link in their email notifications or through the customer panel.', 'ameliabooking'),
            'payments'                                         => __('Payments', 'ameliabooking'),
            'period_available_for_booking'                     => __('Period available for booking in advance', 'ameliabooking'),
            'period_available_for_booking_tooltip'             => __('Define how far into the future customers can book appointments.', 'ameliabooking'),
            'php_mail'                                         => __('PHP Mail', 'ameliabooking'),
            'price_number_of_decimals'                         => __('Price number of decimals', 'ameliabooking'),
            'price_separator'                                  => __('Price separator', 'ameliabooking'),
            'price_symbol_position'                            => __('Price symbol position', 'ameliabooking'),
            'purchase_code'                                    => __('Purchase code', 'ameliabooking'),
            'redirect_urls'                                    => __('Redirect URLs', 'ameliabooking'),
            'redirect_url_after_appointment'                   => __('Redirect URL after booking', 'ameliabooking'),
            'redirect_url_after_appointment_tooltip'           => __('Customers will be redirected to this URL after scheduling an appointment.', 'ameliabooking'),
            'redirect_url_after_event_tooltip'                 => __('Customers will be redirected to this URL after booking an event.', 'ameliabooking'),
            'remove_google_busy_slots'                         => __('Remove Google Calendar busy slots', 'ameliabooking'),
            'remove_outlook_busy_slots'                        => __('Remove Outlook Calendar busy slots', 'ameliabooking'),
            'remove_apple_busy_slots'                          => __('Remove Apple Calendar busy slots', 'ameliabooking'),
            'reject_appointment_success_url'                   => __('Redirect URL for successfully rejected booking', 'ameliabooking'),
            'reject_appointment_error_url'                     => __('Redirect URL for unsuccessfully rejected booking', 'ameliabooking'),
            'reply_to'                                         => __('Reply-to email', 'ameliabooking'),
            'require_cabinet_password'                         => __('Require password for login', 'ameliabooking'),
            'send_event_invitation_email'                      => __('Send event invitation email', 'ameliabooking'),
            'send_invoice_by_default'                          => __('Send invoice to customer by default', 'ameliabooking'),
            'send_invoice_by_default_description'              => __('Enable this option to make sure that the invoice will be sent to the customer after booking.', 'ameliabooking'),
            'send_ics_attachment_approved'                     => __('Send ICS file for approved bookings', 'ameliabooking'),
            'send_ics_attachment_pending'                      => __('Send ICS file for pending bookings', 'ameliabooking'),
            'send_ics_attachment_approved_tooltip'             => __('Enable this option if you want to send ics file in email after approved bookings.', 'ameliabooking'),
            'send_ics_attachment_pending_tooltip'              => __('Enable this option if you want to send ics file in email after pending bookings.', 'ameliabooking'),
            'send_sms_balance_low_email'                       => __('Remind me when my SMS balance is low', 'ameliabooking'),
            'send_sms_balance_low_email_tooltip'               => __('Enable this option to receive a reminder email when your SMS balance reaches set minimum', 'ameliabooking'),
            'send_sms_balance_low_minimum'                     => __('Credit minimum to send reminder', 'ameliabooking'),
            'send_sms_balance_low_to_email'                    => __('Send to e-mail', 'ameliabooking'),
            'sender_email'                                     => __('Sender email', 'ameliabooking'),
            'sender_email_warning'                             => __('Please enter a sender email.', 'ameliabooking'),
            'sender_name'                                      => __('Sender name', 'ameliabooking'),
            'sender_name_warning'                              => __('Please enter a sender name.', 'ameliabooking'),
            'service_duration_as_slot'                         => __('Use service duration for booking a time slot', 'ameliabooking'),
            'service_duration_as_slot_tooltip'                 => __('Enable this option if you want to make time slot step the same as service duration in the booking process', 'ameliabooking'),
            'set_ics_description'                              => __('Set ICS file description', 'ameliabooking'),
            'set_metaData_and_description'                     => __('Set metadata and description', 'ameliabooking'),
            'settings'                                         => __('Settings', 'ameliabooking'),
            'show_attendees'                                   => __('Allow customers to see other attendees', 'ameliabooking'),
            'show_client_time_zone'                            => __('Show booking slots in client\'s time zone', 'ameliabooking'),
            'show_client_time_zone_tooltip'                    => __('Enable to display booking slots based on the client\'s time zone.', 'ameliabooking'),
            'show_add_to_calendar'                             => __('Show Add To Calendar option to customers', 'ameliabooking'),
            'show_add_to_calendar_tooltip'                     => __('Suggest customers to add an appointment to their calendar when booking is finalized.', 'ameliabooking'),
            'smtp'                                             => __('SMTP', 'ameliabooking'),
            'space_comma'                                      => __('Space-comma', 'ameliabooking'),
            'space_dot'                                        => __('Space-dot', 'ameliabooking'),
            'stash_entities'                                   => __('Preload entities when page loads', 'ameliabooking'),
            'stash_entities_tooltip'                           => __('When enabled, all entities (services, employees, locations, packages, and tags) load as soon as the page opens, instead of being loaded dynamically via AJAX.', 'ameliabooking'),
            'square'                                           => __('Square', 'ameliabooking'),
            'square_disconnected'                              => __('Square account successfully disconnected', 'ameliabooking'),
            'square_currency_error'                            => __('The currency in Amelia does not match the currency of your chosen Square location', 'ameliabooking'),
            'square_default_location'                          => __('Default Square location', 'ameliabooking'),
            'square_login_error'                               => __('Please log in to Square', 'ameliabooking'),
            'square_location_error'                            => __('Select your Square Location', 'ameliabooking'),
            'square_location_info'                             => __('Locations must be active and have card processing enabled', 'ameliabooking'),
            'update_for_all'                                   => __('Update for All', 'ameliabooking'),
            'custom_fields_backend_validation'                 => __('Validate required custom fields in the backend', 'ameliabooking'),
            'custom_fields_upload_path'                        => __('Attachment upload path', 'ameliabooking'),
            'custom_fields_upload_path_tooltip'                => __('If left empty, attachments will be uploaded to the default WordPress uploads folder.', 'ameliabooking'),
            'vat_number'                                       => __('VAT number', 'ameliabooking'),
            'website'                                          => __('Website', 'ameliabooking'),
            'wp_mail'                                          => __('WP Mail', 'ameliabooking'),
            'custom_currency_symbol'                           => __('Custom currency symbol', 'ameliabooking'),
            'your_api_key'                                     => __('Your API key', 'ameliabooking'),
            'admin_time_slot_service_duration'                 => __('Booking time slots will depend on the service duration', 'ameliabooking'),
            'admin_time_slot_service_duration_tt'              => __('When this option is deactivated, the booking will be<br/>determined based on the Default Time Slot Step', 'ameliabooking'),
            'cart'                                             => __('Cart', 'ameliabooking'),
            'wc_name'                                          => __('WooCommerce', 'ameliabooking'),
            'payPal'                                           => __('PayPal', 'ameliabooking'),
            'stripe'                                           => __('Stripe', 'ameliabooking'),
            'razorpay'                                         => __('Razorpay', 'ameliabooking'),
            'barion'                                           => __('Barion', 'ameliabooking'),
            'amelia_sms'                                       => __('Amelia SMS', 'ameliabooking'),
            'balance_colon'                                    => __('Balance', 'ameliabooking'),
            'balance_recharged'                                => __('Your balance has been recharged.', 'ameliabooking'),
            'carrier'                                          => __('Carrier:', 'ameliabooking'),
            'change_password'                                  => __('Change password', 'ameliabooking'),
            'cost_colon'                                       => __('Cost:', 'ameliabooking'),
            'current_password_colon'                           => __('Current password', 'ameliabooking'),
            'current_password_required'                        => __('Please enter current password', 'ameliabooking'),
            'customer_appointment_approved'                    => __('Approved', 'ameliabooking'),
            'customer_appointment_canceled'                    => __('Canceled', 'ameliabooking'),
            'customer_appointment_follow_up'                   => __('Follow up', 'ameliabooking'),
            'customer_appointment_next_day_reminder'           => __('Next day reminder', 'ameliabooking'),
            'customer_appointment_pending'                     => __('Pending', 'ameliabooking'),
            'customer_appointment_rejected'                    => __('Rejected', 'ameliabooking'),
            'customer_appointment_rescheduled'                 => __('Rescheduled', 'ameliabooking'),
            'customer_account_recovery'                        => __('Panel access', 'ameliabooking'),
            'customer_appointment_updated'                     => __('Details changed', 'ameliabooking'),
            'customer_birthday_greeting'                       => __('Birthday greeting', 'ameliabooking'),
            'customer_event_approved'                          => __('Booked', 'ameliabooking'),
            'customer_event_canceled'                          => __('Canceled by attendee', 'ameliabooking'),
            'customer_event_follow_up'                         => __('Follow up', 'ameliabooking'),
            'customer_event_next_day_reminder'                 => __('Next day reminder', 'ameliabooking'),
            'customer_event_rejected'                          => __('Canceled by admin', 'ameliabooking'),
            'customer_event_rescheduled'                       => __('Rescheduled', 'ameliabooking'),
            'customer_event_updated'                           => __('Details changed', 'ameliabooking'),
            'customer_event_qr_code'                           => __('Event e-ticket', 'ameliabooking'),
            'customer_other_notifications'                     => __('Other', 'ameliabooking'),
            'customer_event_waiting'                           => __('Waiting list confirmation', 'ameliabooking'),
            'customer_appointment_waiting'                     => __('Waiting list confirmation', 'ameliabooking'),
            'customer_appointment_waiting_available_spot'      => __('Waiting list availability', 'ameliabooking'),
            'customer_cart'                                    => __('Cart purchased', 'ameliabooking'),
            'customer_invoice'                                 => __('Booking invoice', 'ameliabooking'),
            'customer_package_canceled'                        => __('Package canceled', 'ameliabooking'),
            'customer_package_purchased'                       => __('Package purchased', 'ameliabooking'),
            'date_colon'                                       => __('Date:', 'ameliabooking'),
            'dont_have_an_account'                             => __('Don\'t have an account?', 'ameliabooking'),
            'dont_import'                                      => __('Don\'t Import', 'ameliabooking'),
            'enter_password_warning'                           => __('Please enter a password.', 'ameliabooking'),
            'enter_recipient_phone_warning'                    => __('Please enter a recipient phone.', 'ameliabooking'),
            'forgot_password'                                  => __('Forgot password?', 'ameliabooking'),
            'incorrect_email'                                  => __('You have entered an incorrect email.', 'ameliabooking'),
            'incorrect_password'                               => __('You have entered an incorrect password.', 'ameliabooking'),
            'logout'                                           => __('Logout', 'ameliabooking'),
            'new_password_colon'                               => __('New password', 'ameliabooking'),
            'new_password_required'                            => __('Please enter a new password.', 'ameliabooking'),
            'notification_saved'                               => __('Notification has been saved.', 'ameliabooking'),
            'notification_template'                            => __('Notification template', 'ameliabooking'),
            'payment_history'                                  => __('Payment history', 'ameliabooking'),
            'ph_appointment_date'                              => __('Appointment date', 'ameliabooking'),
            'ph_appointment_date_time'                         => __('Appointment date & time', 'ameliabooking'),
            'ph_appointment_duration'                          => __('Appointment duration', 'ameliabooking'),
            'ph_appointment_end_time'                          => __('Appointment end time', 'ameliabooking'),
            'ph_appointment_id'                                => __('Appointment ID', 'ameliabooking'),
            'ph_payment_due_amount'                            => __('Payment due amount', 'ameliabooking'),
            'ph_appointment_notes'                             => __('Appointment notes', 'ameliabooking'),
            'ph_appointment_price'                             => __('Appointment price', 'ameliabooking'),
            'ph_payment_type'                                  => __('Payment type', 'ameliabooking'),
            'ph_appointment_status'                            => __('Appointment status', 'ameliabooking'),
            'ph_appointment_start_time'                        => __('Appointment start time', 'ameliabooking'),
            'ph_attendee_code'                                 => __('Attendee code', 'ameliabooking'),
            'ph_booked_customer'                               => __('Booked customer (full name, email, phone)', 'ameliabooking'),
            'ph_booking_number_of_persons'                     => __('Number of people', 'ameliabooking'),
            'ph_category_id'                                   => __('Category ID', 'ameliabooking'),
            'ph_category_name'                                 => __('Category name', 'ameliabooking'),
            'ph_company_address'                               => __('Company address', 'ameliabooking'),
            'ph_company_name'                                  => __('Company name', 'ameliabooking'),
            'ph_company_phone'                                 => __('Company phone', 'ameliabooking'),
            'ph_company_website'                               => __('Company website', 'ameliabooking'),
            'ph_company_email'                                 => __('Company email', 'ameliabooking'),
            'ph_company_vat_number'                            => __('Company VAT number', 'ameliabooking'),
            'ph_customer_email'                                => __('Customer email', 'ameliabooking'),
            'ph_customer_first_name'                           => __('Customer first name', 'ameliabooking'),
            'ph_customer_full_name'                            => __('Customer full name', 'ameliabooking'),
            'ph_customer_last_name'                            => __('Customer last name', 'ameliabooking'),
            'ph_customer_note'                                 => __('Customer note', 'ameliabooking'),
            'ph_customer_phone'                                => __('Customer phone', 'ameliabooking'),
            'ph_employee_description'                          => __('Employee description', 'ameliabooking'),
            'ph_employee_id'                                   => __('Employee ID', 'ameliabooking'),
            'ph_employee_email'                                => __('Employee email', 'ameliabooking'),
            'ph_employee_first_name'                           => __('Employee first name', 'ameliabooking'),
            'ph_employee_full_name'                            => __('Employee full name', 'ameliabooking'),
            'ph_employee_last_name'                            => __('Employee last name', 'ameliabooking'),
            'ph_employee_name_email_phone'                     => __('Employee name, email & phone', 'ameliabooking'),
            'ph_employee_note'                                 => __('Employee note', 'ameliabooking'),
            'ph_employee_phone'                                => __('Employee phone', 'ameliabooking'),
            'ph_event_description'                             => __('Event description', 'ameliabooking'),
            'ph_event_location'                                => __('Event location', 'ameliabooking'),
            'ph_event_end_date'                                => __('Event end date', 'ameliabooking'),
            'ph_event_end_date_time'                           => __('Event end date & time', 'ameliabooking'),
            'ph_event_end_time'                                => __('Event end time', 'ameliabooking'),
            'ph_event_id'                                      => __('Event ID', 'ameliabooking'),
            'ph_event_name'                                    => __('Event name', 'ameliabooking'),
            'ph_event_period_date'                             => __('Event date period', 'ameliabooking'),
            'ph_event_period_date_time'                        => __('Event date & time period', 'ameliabooking'),
            'ph_event_price'                                   => __('Event price', 'ameliabooking'),
            'ph_booking_price'                                 => __('Booking price', 'ameliabooking'),
            'ph_event_start_date'                              => __('Event start date', 'ameliabooking'),
            'ph_event_start_date_time'                         => __('Event start date & time', 'ameliabooking'),
            'ph_event_start_time'                              => __('Event start time', 'ameliabooking'),
            'ph_group_event_details'                           => __('Group event details', 'ameliabooking'),
            'ph_service_description'                           => __('Service description', 'ameliabooking'),
            'ph_service_duration'                              => __('Service duration', 'ameliabooking'),
            'ph_service_id'                                    => __('Service ID', 'ameliabooking'),
            'ph_service_name'                                  => __('Service name', 'ameliabooking'),
            'ph_service_price'                                 => __('Service price', 'ameliabooking'),
            'ph_time_zone'                                     => __('Time zone', 'ameliabooking'),
            'provider_cart'                                    => __('Cart purchased', 'ameliabooking'),
            'companyPlaceholders'                              => __('Company', 'ameliabooking'),
            'customerPlaceholders'                             => __('Customer', 'ameliabooking'),
            'paymentPlaceholders'                              => __('Payment', 'ameliabooking'),
            'employeePlaceholders'                             => __('Employee', 'ameliabooking'),
            'categoryPlaceholders'                             => __('Category', 'ameliabooking'),
            'locationPlaceholders'                             => __('Location', 'ameliabooking'),
            'appointmentPlaceholders'                          => __('Appointment', 'ameliabooking'),
            'eventPlaceholders'                                => __('Event', 'ameliabooking'),
            'extrasPlaceholders'                               => __('Extra', 'ameliabooking'),
            'price'                                            => __('Price', 'ameliabooking'),
            'pricing'                                          => __('Pricing', 'ameliabooking'),
            'provider_appointment_approved'                    => __('Approved', 'ameliabooking'),
            'provider_appointment_canceled'                    => __('Canceled', 'ameliabooking'),
            'provider_appointment_next_day_reminder'           => __('Next day reminder', 'ameliabooking'),
            'provider_appointment_updated'                     => __('Details changed', 'ameliabooking'),
            'provider_package_canceled'                        => __('Package canceled', 'ameliabooking'),
            'provider_package_purchased'                       => __('Package purchased', 'ameliabooking'),
            'provider_panel_access'                            => __('Panel access', 'ameliabooking'),
            'provider_panel_recovery'                          => __('Panel recovery', 'ameliabooking'),
            'provider_appointment_pending'                     => __('Pending', 'ameliabooking'),
            'provider_appointment_rejected'                    => __('Rejected', 'ameliabooking'),
            'provider_appointment_rescheduled'                 => __('Rescheduled', 'ameliabooking'),
            'provider_event_approved'                          => __('Booked', 'ameliabooking'),
            'provider_event_canceled'                          => __('Canceled by attendee', 'ameliabooking'),
            'provider_event_next_day_reminder'                 => __('Next day reminder', 'ameliabooking'),
            'provider_event_rejected'                          => __('Canceled by admin', 'ameliabooking'),
            'provider_event_rescheduled'                       => __('Rescheduled', 'ameliabooking'),
            'provider_event_updated'                           => __('Details changed', 'ameliabooking'),
            'provider_event_waiting'                           => __('Waiting list confirmation', 'ameliabooking'),
            'provider_appointment_waiting'                     => __('Waiting list confirmation', 'ameliabooking'),
            'provider_appointment_waiting_available_spot'      => __('Waiting list availability', 'ameliabooking'),
            'queued'                                           => __('Queued', 'ameliabooking'),
            're_type_required'                                 => __('Please enter a new password again.', 'ameliabooking'),
            'recharge'                                         => __('Recharge', 'ameliabooking'),
            'recharge_balance'                                 => __('Recharge balance', 'ameliabooking'),
            'recipient_email'                                  => __('Recipient email', 'ameliabooking'),
            'requires_scheduling_setup'                        => __('Schedule setup required', 'ameliabooking'),
            'segments_colon'                                   => __('Segments', 'ameliabooking'),
            'send'                                             => __('Send', 'ameliabooking'),
            'send_test_email'                                  => __('Test email', 'ameliabooking'),
            'send_test_sms'                                    => __('Test SMS', 'ameliabooking'),
            'sender_id_colon'                                  => __('Alpha sender ID', 'ameliabooking'),
            'sign_in'                                          => __('Sign in', 'ameliabooking'),
            'sign_up'                                          => __('Sign up', 'ameliabooking'),
            'sms_history'                                      => __('SMS history', 'ameliabooking'),
            'sms_vat_apply'                                    => __('If you are in a country where VAT or GST applies, the applicable tax will be added to your transaction.', 'ameliabooking'),
            'subject'                                          => __('Subject', 'ameliabooking'),
            'test_email_error'                                 => __('Failed to send test email.', 'ameliabooking'),
            'test_email_success'                               => __('Test email sent successfully.', 'ameliabooking'),
            'test_email_warning'                               => __('To send a test email, please configure the \'Sender Email\' in Notification Settings.', 'ameliabooking'),
            'test_sms_warning'                                 => __('To send a test SMS, please recharge your balance.', 'ameliabooking'),
            'text_colon'                                       => __('Text:', 'ameliabooking'),
            'time_colon'                                       => __('Time:', 'ameliabooking'),
            'type_colon'                                       => __('Type:', 'ameliabooking'),
            'to_customer'                                      => __('To customer', 'ameliabooking'),
            'to_employee'                                      => __('To employee', 'ameliabooking'),
            'user_colon'                                       => __('User', 'ameliabooking'),
            'user_profile'                                     => __('User profile', 'ameliabooking'),
            'view_pricing_for'                                 => __('View pricing for', 'ameliabooking'),
            'whatsapp_access_token'                            => __('Permanent access token', 'ameliabooking'),
            'whatsapp_auto_reply_enable'                       => __('Enable auto-reply message', 'ameliabooking'),
            'whatsapp_auto_reply_notice'                       => __('Messages sent through WhatsApp are without a reply option, so we advise setting the “Auto-reply” message', 'ameliabooking'),
            'whatsapp_auto_reply_token'                        => __('WhatsApp webhook verify token', 'ameliabooking'),
            'whatsapp_auto_reply_msg'                          => __('WhatsApp auto-reply message', 'ameliabooking'),
            'whatsapp_business_id'                             => __('WhatsApp business account ID', 'ameliabooking'),
            'whatsapp_default_language'                        => __('Default language', 'ameliabooking'),
            'whatsapp_phone_id'                                => __('Phone number ID', 'ameliabooking'),
            'whatsapp_webhook_url_callback'                    => __('WhatsApp webhook callback URL', 'ameliabooking'),
            'configure'                                        => __('Configure', 'ameliabooking'),
            'ph_location_id'                                   => __('Location ID', 'ameliabooking'),
            'ph_location_latitude'                             => __('Location latitude', 'ameliabooking'),
            'ph_location_longitude'                            => __('Location longitude', 'ameliabooking'),
            'password'                                         => __('Password', 'ameliabooking'),
            'segment_colon'                                    => __('Segment:', 'ameliabooking'),
            'already_have_an_account'                          => __('Already have an account?', 'ameliabooking'),
            'email_taken'                                      => __('This email is already in use. Please enter a different email address.', 'ameliabooking'),
            'appointments_count'                               => __('# of appointments', 'ameliabooking'),
            'bookings_revenue'                                 => __('Sum of payments', 'ameliabooking'),
            'appointments_hours'                               => __('# of Hours in appointment', 'ameliabooking'),
            'dashboard'                                        => __('Dashboard', 'ameliabooking'),
            'new'                                              => __('New', 'ameliabooking'),
            'pending_appointments'                             => __('Pending appointments', 'ameliabooking'),
            'percentage_of_load'                               => __('Percentage of Load', 'ameliabooking'),
            'returning'                                        => __('Returning', 'ameliabooking'),
            'revenue'                                          => __('Revenue', 'ameliabooking'),
            'time'                                             => __('Time', 'ameliabooking'),
            'upcoming_appointments'                            => __('Upcoming appointments', 'ameliabooking'),
            'add_day_off'                                      => __('Add day off', 'ameliabooking'),
            'add_special_day'                                  => __('Add special day', 'ameliabooking'),
            'apply_to_all_days'                                => __('Apply to all days', 'ameliabooking'),
            'day_off_name'                                     => __('Day off name', 'ameliabooking'),
            'days_off_repeat_yearly'                           => __('Repeat yearly', 'ameliabooking'),
            'days_off'                                         => __('Days off', 'ameliabooking'),
            'work_hours'                                       => __('Work hours', 'ameliabooking'),
            'visibility_hide'                                  => __('Hide', 'ameliabooking'),
            'visibility_show'                                  => __('Show', 'ameliabooking'),
            'block'                                            => __('Block', 'ameliabooking'),
            'unblock'                                          => __('Unblock', 'ameliabooking'),
            'visible'                                          => __('Visible', 'ameliabooking'),
            'locations_search_placeholder'                     => __('Search locations', 'ameliabooking'),
            'google_maps_notice'                               => __('To enable Google Maps, enter your Google Maps API key in the Google General Settings.', 'ameliabooking'),
            'add_category'                                     => __('Add category', 'ameliabooking'),
            'add_extra'                                        => __('Add Extra', 'ameliabooking'),
            'categories'                                       => __('Categories', 'ameliabooking'),
            'categories_positions_saved'                       => __('Categories positions updated successfully.', 'ameliabooking'),
            'category_deleted'                                 => __('Category has been deleted.', 'ameliabooking'),
            'confirm_delete_service'                           => __('Are you sure you want to delete this service?', 'ameliabooking'),
            'confirm_duplicate_service'                        => __('Are you sure you want to duplicate this service?', 'ameliabooking'),
            'confirm_global_change_service'                    => __('You\'re changing settings that have been individually configured for employees. Do you want to apply these changes to all employees?', 'ameliabooking'),
            'confirm_hide_service'                             => __('Are you sure you want to hide this service?', 'ameliabooking'),
            'confirm_show_service'                             => __('Are you sure you want to show this service?', 'ameliabooking'),
            'delete_category_confirmation'                     => __('Are you sure you want to delete this category?', 'ameliabooking'),
            'duplicate_category_confirmation'                  => __('Are you sure you want to duplicate this category?', 'ameliabooking'),
            'duration_and_pricing'                             => __('Pricing & duration ', 'ameliabooking'),
            'edit_service'                                     => __('Edit service', 'ameliabooking'),
            'edit_category'                                    => __('Edit Category', 'ameliabooking'),
            'gallery'                                          => __('Gallery', 'ameliabooking'),
            'maximum_capacity_tooltip'                         => __('Set the maximum number of people allowed per appointment for this service.', 'ameliabooking'),
            'minimum_capacity'                                 => __('Minimum capacity', 'ameliabooking'),
            'minimum_capacity_tooltip'                         => __('Set the minimum number of people required per appointment for this service.', 'ameliabooking'),
            'new_category'                                     => __('New category', 'ameliabooking'),
            'new_service'                                      => __('New service', 'ameliabooking'),
            'select_service_duration_warning'                  => __('Please select a duration.', 'ameliabooking'),
            'select_service_category_warning'                  => __('Please select a category.', 'ameliabooking'),
            'service_buffer_time_after'                        => __('Buffer time after', 'ameliabooking'),
            'service_buffer_time_after_tooltip'                => __('Time needed after the appointment for rest, cleanup, or transition. During this period, the employee cannot be booked for any service.', 'ameliabooking'),
            'service_buffer_time_before'                       => __('Buffer time before', 'ameliabooking'),
            'service_buffer_time_before_tooltip'               => __('Time needed before the appointment for preparation. During this period, the employee cannot be booked for any service.', 'ameliabooking'),
            'service_deleted'                                  => __('Service has been deleted.', 'ameliabooking'),
            'service_hidden'                                   => __('Service has been hidden.', 'ameliabooking'),
            'service_visible'                                  => __('Service is now visible.', 'ameliabooking'),
            'services_sorting_price_asc'                       => __('Price Asc', 'ameliabooking'),
            'services_sorting_price_desc'                      => __('Price Desc', 'ameliabooking'),
            'service_show_on_site'                             => __('Show on website', 'ameliabooking'),
            'service_show_on_site_tooltip'                     => __('If this option is disabled, the service will be bookable only from the back end.', 'ameliabooking'),
            'service_recurring_cycle'                          => __('Recurring appointments', 'ameliabooking'),
            'service_recurring_cycle_tooltip'                  => __("Choose how recurring appointments can be booked. 'Disabled' turns recurring booking off, while 'All' allows customers to choose between available recurrence options.", 'ameliabooking'),
            'notify_customer'                                  => __('Notify the customer(s)', 'ameliabooking'),
            'service_details'                                  => __('Service details', 'ameliabooking'),
            'create_new'                                       => __('Create new', 'ameliabooking'),
            'email'                                            => __('Email', 'ameliabooking'),
            'enter_first_name_warning'                         => __('Please enter a first name.', 'ameliabooking'),
            'enter_last_name_warning'                          => __('Please enter a last name', 'ameliabooking'),
            'first_name'                                       => __('First name', 'ameliabooking'),
            'last_name'                                        => __('Last name', 'ameliabooking'),
            'female'                                           => __('Female', 'ameliabooking'),
            'male'                                             => __('Male', 'ameliabooking'),
            'notification_language'                            => __('Notification language', 'ameliabooking'),
            'wp_user'                                          => __('WordPress user', 'ameliabooking'),
            'wp_user_customer_tooltip'                         => __('Link this customer to a WordPress user so they can log in and view their appointments in Amelia’s back end.', 'ameliabooking'),
            'wp_user_employee_tooltip'                         => __('Map a WordPress user to this employee to give them access to view their appointments in the plugin’s back-end.', 'ameliabooking'),
            'wp_customer_lang_tooltip'                         => __('Defines the language used for notifications sent to this customer for bookings created from the admin or employee panel. If a supported language was used in a previous booking, it will be automatically selected; otherwise, you can set it manually.', 'ameliabooking'),
            'edit_employee'                                    => __('Edit employee', 'ameliabooking'),
            'employee_show_on_site'                            => __('Show on website', 'ameliabooking'),
            'employee_show_on_site_tooltip'                    => __('If this option is disabled, the employee will only be available for booking through the back-end', 'ameliabooking'),
            'employee_panel_password'                          => __('Employee panel password', 'ameliabooking'),
            'special_days'                                     => __('Special days', 'ameliabooking'),
            'timezone'                                         => __('Time zone', 'ameliabooking'),
            'away'                                             => __('Away', 'ameliabooking'),
            'new_employee'                                     => __('New employee', 'ameliabooking'),
            'confirm_hide_employee'                            => __('Are you sure you want to hide this employee?', 'ameliabooking'),
            'confirm_show_employee'                            => __('Are you sure you want to show this employee?', 'ameliabooking'),
            'employee_visible'                                 => __('Employee is now visible.', 'ameliabooking'),
            'employee_hidden'                                  => __('Employee has been hidden.', 'ameliabooking'),
            'confirm_delete_employee'                          => __('Are you sure you want to delete this employee?', 'ameliabooking'),
            'confirm_delete_customer'                          => __('Are you sure you want to delete this customer?', 'ameliabooking'),
            'confirm_block_customer'                           => __('Are you sure you want to block this customer?', 'ameliabooking'),
            'confirm_unblock_customer'                         => __('Are you sure you want to unblock this customer?', 'ameliabooking'),
            'customer_deleted'                                 => __('Customer has been deleted.', 'ameliabooking'),
            'customer_blocked'                                 => __('Customer has been blocked.', 'ameliabooking'),
            'customer_phone'                                   => __('Customer phone', 'ameliabooking'),
            'customer_unblocked'                               => __('Customer has been unblocked.', 'ameliabooking'),
            'customer_note'                                    => __('Note', 'ameliabooking'),
            'customer_name'                                    => __('Customer name', 'ameliabooking'),
            'customers'                                        => __('Customers', 'ameliabooking'),
            'customers_search_placeholder'                     => __('Search customers', 'ameliabooking'),
            'date_of_birth'                                    => __('Date of birth', 'ameliabooking'),
            'edit_customer'                                    => __('Edit customer', 'ameliabooking'),
            'gender'                                           => __('Gender', 'ameliabooking'),
            'imported_customers'                               => __('Customers imported from file:', 'ameliabooking'),
            'last_booking'                                     => __('Last booking', 'ameliabooking'),
            'new_customer'                                     => __('New customer', 'ameliabooking'),
            'required_data'                                    => __('Required fields: <b>First Name</b> and <b>Last Name</b>.', 'ameliabooking'),
            'total_appointments'                               => __('Total appointments', 'ameliabooking'),
            'total_bookings'                                   => __('Total bookings', 'ameliabooking'),
            'total_events'                                     => __('Total events', 'ameliabooking'),
            'view_appointments'                                => __('View appointments', 'ameliabooking'),
            'view_events'                                      => __('View events', 'ameliabooking'),
            'drag_drop'                                        => __('Drop files here or click to upload', 'ameliabooking'),
            'import_rules'                                     => __('Import Rules', 'ameliabooking'),
            'import_successful'                                => __('Import successful', 'ameliabooking'),
            'map_data'                                         => __('Please map corresponding data to columns:', 'ameliabooking'),
            'wrong_format'                                     => __('Some records have an incorrect format.', 'ameliabooking'),
            'amount'                                           => __('Amount', 'ameliabooking'),
            'booking_start'                                    => __('Booking start', 'ameliabooking'),
            'customer_email'                                   => __('Customer email', 'ameliabooking'),
            'employee_email'                                   => __('Employee email', 'ameliabooking'),
            'method'                                           => __('Method', 'ameliabooking'),
            'payment_date'                                     => __('Payment date', 'ameliabooking'),
            'payment_created'                                  => __('Payment created', 'ameliabooking'),
            'rate'                                             => __('Rate', 'ameliabooking'),
            'invoice_qty'                                      => __('Qty', 'ameliabooking'),
            'invoice_total_item_price'                         => __('Total price', 'ameliabooking'),
            'invoices'                                         => __('Invoices', 'ameliabooking'),
            'discount_amount'                                  => __('Discount', 'ameliabooking'),
            'due'                                              => __('Due', 'ameliabooking'),
            'finance'                                          => __('Finance', 'ameliabooking'),
            'payment_details'                                  => __('Payment details', 'ameliabooking'),
            'service_price'                                    => __('Service price', 'ameliabooking'),
            'subtotal'                                         => __('Subtotal', 'ameliabooking'),
            'total_price'                                      => __('Total price', 'ameliabooking'),
            'event_price'                                      => __('Event price', 'ameliabooking'),
            'appointment_deleted'                              => __('Appointment has been deleted.', 'ameliabooking'),
            'appointment_rescheduled'                          => __('Appointment has been rescheduled', 'ameliabooking'),
            'appointment_status_changed'                       => __('Appointment status has been changed to ', 'ameliabooking'),
            'category'                                         => __('Category', 'ameliabooking'),
            'confirm_delete_appointment'                       => __('Are you sure? This action can\'t be undone.', 'ameliabooking'),
            'confirm_duplicate_appointment'                    => __('Are you sure you want to duplicate this appointment?', 'ameliabooking'),
            'custom_fields'                                    => __('Custom fields', 'ameliabooking'),
            'edit_appointment'                                 => __('Edit appointment', 'ameliabooking'),
            'end_time'                                         => __('End time', 'ameliabooking'),
            'new_appointment'                                  => __('New appointment', 'ameliabooking'),
            'notify_attendees'                                 => __('Notify the attendees', 'ameliabooking'),
            'notify_attendees_tooltip'                         => __('Notify attendees by email when event information is updated.', 'ameliabooking'),
            'over_booking_message'                             => __('By continuing, you will set the appointment to a time slot that already has an existing appointment!', 'ameliabooking'),
            'select_service_warning'                           => __('Please select a service.', 'ameliabooking'),
            'start_time'                                       => __('Start time', 'ameliabooking'),
            'booking_reschedule_exception'                     => __('Appointment can\'t be rescheduled', 'ameliabooking'),
            'booking_status_changed'                           => __('Booking status has been changed to ', 'ameliabooking'),
            'wc'                                               => __('WooCommerce', 'ameliabooking'),
            'select_a_customer_warning'                        => __('Please select a customer.', 'ameliabooking'),
            'select_employee_warning'                          => __('Please select an employee.', 'ameliabooking'),
            'deposit_enabled'                                  => __('Deposit payment', 'ameliabooking'),
            'custom_pricing'                                   => __('Custom pricing', 'ameliabooking'),
            'custom_duration_pricing_enabled'                  => __('Pricing by duration', 'ameliabooking'),
            'custom_person_pricing_enabled'                    => __('Pricing by number of people', 'ameliabooking'),
            'custom_period_pricing_enabled'                    => __('Pricing by date & time', 'ameliabooking'),
            'recurring_appointments'                           => __('Recurring appointments', 'ameliabooking'),
            'confirm_duplicate_event'                          => __('Are you sure you want to duplicate this event?', 'ameliabooking'),
            'confirm_cancel'                                   => __('Are you sure you want to cancel this event?', 'ameliabooking'),
            'confirm_open'                                     => __('Are you sure you want to open this event?', 'ameliabooking'),
            'event_cancel_before_delete'                       => __('Please cancel the event first before deleting it.', 'ameliabooking'),
            'customize'                                        => __('Customize', 'ameliabooking'),
            'full'                                             => __('Full', 'ameliabooking'),
            'upcoming'                                         => __('Upcoming', 'ameliabooking'),
            'edit_event'                                       => __('Edit event', 'ameliabooking'),
            'event_book_persons'                               => __('Number of people', 'ameliabooking'),
            'event_book_status'                                => __('Status', 'ameliabooking'),
            'event_book_tickets'                               => __('Number of Tickets', 'ameliabooking'),
            'event_aggregated_price'                           => __('Multiply price by number of people', 'ameliabooking'),
            'event_book_more_than_once'                        => __('Allow multiple bookings per customer', 'ameliabooking'),
            'event_bringing_anyone'                            => __('Allow additional people', 'ameliabooking'),
            'event_cancel'                                     => __('Cancel Event', 'ameliabooking'),
            'event_close_after_min'                            => __('Close event when minimum capacity is reached', 'ameliabooking'),
            'event_close_min_total'                            => __('Minimum number of attendees', 'ameliabooking'),
            'event_close_min_bookings'                         => __('Minimum number of bookings', 'ameliabooking'),
            'event_close_min_total_tt'                         => __('Each spot counts as one attendee.', 'ameliabooking'),
            'event_close_min_bookings_tt'                      => __('A single booking may include multiple attendees (spots).', 'ameliabooking'),
            'event_close_minimum'                              => __('Set minimum', 'ameliabooking'),
            'event_custom_address'                             => __('Custom address', 'ameliabooking'),
            'event_delete'                                     => __('Delete Event', 'ameliabooking'),
            'event_deleted'                                    => __('Event has been deleted.', 'ameliabooking'),
            'event_booking_closes_on'                          => __('Closes on', 'ameliabooking'),
            'event_booking_opens_on'                           => __('Opens on', 'ameliabooking'),
            'event_booking_closes_after'                       => __('Booking closes when event starts', 'ameliabooking'),
            'event_booking_opens_now'                          => __('Booking opens immediately', 'ameliabooking'),
            'event_open'                                       => __('Open Event', 'ameliabooking'),
            'event_opened'                                     => __('Event has been opened.', 'ameliabooking'),
            'event_canceled'                                   => __('Event has been canceled.', 'ameliabooking'),
            'event_search_placeholder'                         => __('Search events', 'ameliabooking'),
            'event_staff'                                      => __('Staff', 'ameliabooking'),
            'event_organizer'                                  => __('Organizer', 'ameliabooking'),
            'event_organizer_tooltip'                          => __('Select the employee who will be added as the organizer of the Google/Outlook/Apple Calendar event. Employees selected under Staff will be added as guests.', 'ameliabooking'),
            'event_tags'                                       => __('Tags', 'ameliabooking'),
            'event_show_on_site'                               => __('Show on website', 'ameliabooking'),
            'event_status_changed'                             => __('Booking status has been changed to ', 'ameliabooking'),
            'new_event'                                        => __('New event', 'ameliabooking'),
            'maximum_capacity_reached'                         => __('Maximum capacity is reached', 'ameliabooking'),
            'confirm'                                          => __('Confirm', 'ameliabooking'),
            'add_custom_field'                                 => __('Add custom field', 'ameliabooking'),
            'reset_form_settings'                              => __('Reset form settings', 'ameliabooking'),
            'are_you_sure_reset_customize'                     => __('Are you sure you want to reset your form settings?', 'ameliabooking'),
            'current_changes_will_be_lost'                     => __('Your current changes will be lost.', 'ameliabooking'),
            'reset_yes'                                        => __('Reset', 'ameliabooking'),
            'reset_form'                                       => __('Reset Form', 'ameliabooking'),
            'package_available'                                => __('Available in package', 'ameliabooking'),
            'bringing_anyone_with_you'                         => __('Bringing anyone with you?', 'ameliabooking'),
            'buttons'                                          => __('Buttons', 'ameliabooking'),
            'package_discount_text'                            => __('Save', 'ameliabooking'),
            'default_label'                                    => __('Default Label', 'ameliabooking'),
            'duration_colon'                                   => __('Duration', 'ameliabooking'),
            'checkbox'                                         => __('Checkbox', 'ameliabooking'),
            'click_add_custom_field'                           => __('Start by clicking the add custom field button', 'ameliabooking'),
            'text_content'                                     => __('Text content', 'ameliabooking'),
            'custom_fields_title'                              => __('Custom Fields', 'ameliabooking'),
            'font'                                             => __('Font', 'ameliabooking'),
            'no_custom_fields_yet'                             => __('You don\'t have any custom fields here yet...', 'ameliabooking'),
            'options'                                          => __('Options:', 'ameliabooking'),
            'pick_date_and_time'                               => __('Pick date & time', 'ameliabooking'),
            'please_select_service'                            => __('Please select service', 'ameliabooking'),
            'primary'                                          => __('Primary', 'ameliabooking'),
            'primary_color'                                    => __('Primary color', 'ameliabooking'),
            'success_color'                                    => __('Success', 'ameliabooking'),
            'warning_color'                                    => __('Warning', 'ameliabooking'),
            'error_color'                                      => __('Error', 'ameliabooking'),
            'radio'                                            => __('Radio button', 'ameliabooking'),
            'reset'                                            => __('Reset', 'ameliabooking'),
            'select'                                           => __('Select Box', 'ameliabooking'),
            'steps'                                            => __('Steps', 'ameliabooking'),
            'select_service'                                   => __('Select service', 'ameliabooking'),
            'text'                                             => __('Text', 'ameliabooking'),
            'text-area'                                        => __('Text area', 'ameliabooking'),
            'text_color'                                       => __('Text color', 'ameliabooking'),
            'placeholder_color'                                => __('Placeholder Color', 'ameliabooking'),
            'text_color_on_background'                         => __('Text color on background', 'ameliabooking'),
            'file'                                             => __('Attachment', 'ameliabooking'),
            'datepicker'                                       => __('Date picker', 'ameliabooking'),
            'preview'                                          => __('Preview', 'ameliabooking'),
            'bgr_color'                                        => __('Background Color', 'ameliabooking'),
            'bgr_gradient_color1'                              => __('Background Gradient Color 1', 'ameliabooking'),
            'bgr_gradient_color2'                              => __('Background Gradient Color 2', 'ameliabooking'),
            'bgr_gradient_angle'                               => __('Background Gradient Angle', 'ameliabooking'),
            'input_color'                                      => __('Input Color', 'ameliabooking'),
            'input_text_color'                                 => __('Input Text Color', 'ameliabooking'),
            'dropdown_color'                                   => __('Dropdown Color', 'ameliabooking'),
            'dropdown_text_color'                              => __('Dropdown Text Color', 'ameliabooking'),
            'image_color'                                      => __('Image Color', 'ameliabooking'),
            'recurring_active'                                 => __('Repeat this appointment', 'ameliabooking'),
            'first_name_colon'                                 => __('First name', 'ameliabooking'),
            'last_name_colon'                                  => __('Last name', 'ameliabooking'),
            'last_name_input_field'                            => __('Last name', 'ameliabooking'),
            'email_colon'                                      => __('Email', 'ameliabooking'),
            'email_input_field'                                => __('Email', 'ameliabooking'),
            'phone_colon'                                      => __('Phone', 'ameliabooking'),
            'phone_input_field'                                => __('Phone', 'ameliabooking'),
            'go_back'                                          => __('Go back', 'ameliabooking'),
            'service_name'                                     => __('Service name', 'ameliabooking'),
            'display_field'                                    => __('Display Field:', 'ameliabooking'),
            'filterable_field'                                 => __('Filterable Field:', 'ameliabooking'),
            'mandatory_field'                                  => __('Mandatory Field:', 'ameliabooking'),
            'event_type'                                       => __('Event type', 'ameliabooking'),
            'event_location'                                   => __('Event location', 'ameliabooking'),
            'event_free'                                       => __('Free', 'ameliabooking'),
            'service_badge'                                    => __('Service badge', 'ameliabooking'),
            'package_name'                                     => __('Package name', 'ameliabooking'),
            'congratulations'                                  => __('Congratulations!', 'ameliabooking'),
            'add_to_calendar'                                  => __('Add to calendar', 'ameliabooking'),
            'finish_appointment'                               => __('Finish', 'ameliabooking'),
            'form_type_step_by_step'                           => __('Step By Step Booking Form', 'ameliabooking'),
            'event_status'                                     => __('Event status', 'ameliabooking'),
            'event_filters'                                    => __('Filters', 'ameliabooking'),
            'event_book_event'                                 => __('Book event', 'ameliabooking'),
            'form_block_service'                               => __('Service', 'ameliabooking'),
            'form'                                             => __('Form', 'ameliabooking'),
            'form_flow'                                        => __('Form Flow', 'ameliabooking'),
            'use_global_colors'                                => __('Use Global Colors', 'ameliabooking'),
            'service_selection'                                => __('Service selection', 'ameliabooking'),
            'employee_selection'                               => __('Employee selection', 'ameliabooking'),
            'location_selection'                               => __('Location selection', 'ameliabooking'),
            'service_colon'                                    => __('Service', 'ameliabooking'),
            'dropdown_category_heading'                        => __('Category', 'ameliabooking'),
            'dropdown_items_heading'                           => __('Service', 'ameliabooking'),
            'dropdown_empty'                                   => __('No matching data', 'ameliabooking'),
            'bringing_anyone'                                  => __('Bringing anyone with you', 'ameliabooking'),
            'show_more'                                        => __('Show more', 'ameliabooking'),
            'show_less'                                        => __('Show less', 'ameliabooking'),
            'date_time'                                        => __('Date & time', 'ameliabooking'),
            'date_time_slots_selected'                         => __('All slots are selected', 'ameliabooking'),
            'info_step'                                        => __('Your information', 'ameliabooking'),
            'enter_first_name'                                 => __('Enter first name', 'ameliabooking'),
            'enter_last_name'                                  => __('Enter last name', 'ameliabooking'),
            'enter_email'                                      => __('Enter email', 'ameliabooking'),
            'enter_phone'                                      => __('Enter phone', 'ameliabooking'),
            'enter_phone_warning'                              => __('Please enter phone', 'ameliabooking'),
            'payment_step'                                     => __('Payment', 'ameliabooking'),
            'summary'                                          => __('Summary', 'ameliabooking'),
            'summary_services'                                 => __('Services', 'ameliabooking'),
            'summary_services_subtotal'                        => __('Service subtotal', 'ameliabooking'),
            'summary_persons'                                  => __('people', 'ameliabooking'),
            'total_amount_colon'                               => __('Total amount', 'ameliabooking'),
            'payment_onsite_sentence'                          => __('The payment will be done on-site.', 'ameliabooking'),
            'appointment_id'                                   => __('Appointment ID', 'ameliabooking'),
            'congrats_total_amount'                            => __('Total amount', 'ameliabooking'),
            'congrats_payment'                                 => __('Payment', 'ameliabooking'),
            'your_name_colon'                                  => __('Your name', 'ameliabooking'),
            'email_address_colon'                              => __('Email address', 'ameliabooking'),
            'phone_number_colon'                               => __('Phone number', 'ameliabooking'),
            'congrats_date'                                    => __('Date', 'ameliabooking'),
            'congrats_time'                                    => __('Local time', 'ameliabooking'),
            'congrats_service'                                 => __('Service', 'ameliabooking'),
            'congrats_employee'                                => __('Employee', 'ameliabooking'),
            'congrats_location'                                => __('Location', 'ameliabooking'),
            'choose_form'                                      => __('Choose a Form', 'ameliabooking'),
            'choose_form_for_customize'                        => __('Choose a form you want to customize. The Step-by-Step 2.0 form is the new and improved version which provides you with better design and user experience, as well as better speed.', 'ameliabooking'),
            'sbs_booking_form'                                 => __('Step-by-step', 'ameliabooking'),
            'sbs_booking_form_old'                             => __('Booking Forms 1.0', 'ameliabooking'),
            'redesigned_sbs_booking_form'                      => __('Provide a simplified, guided booking experience on your website. Customize the design and labels to improve usability and align with your business needs.', 'ameliabooking'),
            'old_forms_text'                                   => __('The original booking forms—Step-by-Step, Catalog, Event List, and Event Calendar—feature basic customization and label changes, serving as the foundation for our newer versions.', 'ameliabooking'),
            'primary_and_state_colors'                         => __('Primary and state colors', 'ameliabooking'),
            'sidebar'                                          => __('Sidebar area', 'ameliabooking'),
            'background_color'                                 => __('Background Color', 'ameliabooking'),
            'content'                                          => __('Content', 'ameliabooking'),
            'heading_text_color'                               => __('Heading Text Color', 'ameliabooking'),
            'content_text_color'                               => __('Content Text Color', 'ameliabooking'),
            'input_fields'                                     => __('Input fields', 'ameliabooking'),
            'border_color'                                     => __('Border color', 'ameliabooking'),
            'dropdowns'                                        => __('Dropdowns', 'ameliabooking'),
            'lower_price_background'                           => __('Lower price background', 'ameliabooking'),
            'higher_price_background'                          => __('Higher price background', 'ameliabooking'),
            'lower_price_text'                                 => __('Lower price text', 'ameliabooking'),
            'higher_price_text'                                => __('Higher price text', 'ameliabooking'),
            'waiting_list_background'                          => __('Waiting list background', 'ameliabooking'),
            'waiting_list_text'                                => __('Waiting list text', 'ameliabooking'),
            'primary_text'                                     => __('Primary text', 'ameliabooking'),
            'secondary_color'                                  => __('Secondary color', 'ameliabooking'),
            'danger_background'                                => __('Danger button background color', 'ameliabooking'),
            'danger_text'                                      => __('Danger button text color', 'ameliabooking'),
            'layout_and_inputs'                                => __('Layout & Inputs', 'ameliabooking'),
            'colors'                                           => __('Colors', 'ameliabooking'),
            'fonts'                                            => __('Fonts', 'ameliabooking'),
            'order'                                            => __('Order', 'ameliabooking'),
            'step_title'                                       => __('Title section', 'ameliabooking'),
            'footer_buttons'                                   => __('Footer buttons', 'ameliabooking'),
            'step_content'                                     => __('Step content', 'ameliabooking'),
            'finish_btn_type'                                  => __('Finish Button Type', 'ameliabooking'),
            'panel_btn_type'                                   => __('Panel Button Type', 'ameliabooking'),
            'summary_segment'                                  => __('Summary segment', 'ameliabooking'),
            'payment_segment'                                  => __('Payment segment', 'ameliabooking'),
            'heading_title'                                    => __('Heading title', 'ameliabooking'),
            'sub_steps'                                        => __('Sub Steps', 'ameliabooking'),
            'step_popups'                                      => __('Step Popups', 'ameliabooking'),
            'csb_global_settings_content'                      => __('Fonts and colors', 'ameliabooking'),
            'csb_sidebar_content'                              => __('Set up Sidebar visibility and its content', 'ameliabooking'),
            'csb_packages'                                     => __('Packages popup', 'ameliabooking'),
            'csb_services_content'                             => __('Set up Services, Locations, Employees selection options', 'ameliabooking'),
            'csb_services_only_content'                        => __('Set up Services selection options', 'ameliabooking'),
            'csb_employees_only_content'                       => __('Set up Employees selection options', 'ameliabooking'),
            'csb_locations_only_content'                       => __('Set up Locations selection options', 'ameliabooking'),
            'csb_date_time_content'                            => __('Set up Calendar layout and Recurring popup options', 'ameliabooking'),
            'csb_info_step'                                    => __('Customer information', 'ameliabooking'),
            'csb_info_step_content'                            => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_payment'                                      => __('Payment summary', 'ameliabooking'),
            'csb_payment_content'                              => __('Set up labels and buttons', 'ameliabooking'),
            'cpb_congratulations_content'                      => __('Set up button types and labels', 'ameliabooking'),
            'plus_more'                                        => __('+more', 'ameliabooking'),
            'cb_global_settings_heading'                       => __('Global Settings', 'ameliabooking'),
            'cb_sidebar'                                       => __('Sidebar area', 'ameliabooking'),
            'cb_section'                                       => __('Section', 'ameliabooking'),
            'cb_field_order_heading'                           => __('Field Order', 'ameliabooking'),
            'cb_congratulations_heading'                       => __('Congratulations', 'ameliabooking'),
            'sidebar_footer'                                   => __('Footer', 'ameliabooking'),
            'get_in_touch'                                     => __('Get in touch', 'ameliabooking'),
            'collapse_menu'                                    => __('Collapse menu', 'ameliabooking'),
            'sb_radio_filled'                                  => __('Filled', 'ameliabooking'),
            'sb_radio_plain'                                   => __('Plain', 'ameliabooking'),
            'sb_radio_text'                                    => __('Text', 'ameliabooking'),
            'continue_button_type'                             => __('\'Continue\' button style', 'ameliabooking'),
            'calendar_slot_end_time'                           => __('Slot end time', 'ameliabooking'),
            'show_busy_slots'                                  => __('Busy slots', 'ameliabooking'),
            'show_estimated_pricing'                           => __('Estimated price', 'ameliabooking'),
            'show_slot_pricing'                                => __('Time slot price', 'ameliabooking'),
            'show_indicator_pricing'                           => __('Price indicators', 'ameliabooking'),
            'show_people_waiting'                              => __('Number of people on waiting list', 'ameliabooking'),
            'calendar_time_zone'                               => __('Time zone', 'ameliabooking'),
            'finish_button_type'                               => __('\'Finish\' button style', 'ameliabooking'),
            'panel_button_type'                                => __('\'Customer panel\' button style', 'ameliabooking'),
            'sidebar_visibility'                               => __('Sidebar visibility', 'ameliabooking'),
            'publish_form'                                     => __('Publish Form', 'ameliabooking'),
            'view_all'                                         => __('View all', 'ameliabooking'),
            'csb_categories'                                   => __('Categories', 'ameliabooking'),
            'csb_categories_content'                           => __('Set up categories cards', 'ameliabooking'),
            'cards'                                            => __('Cards', 'ameliabooking'),
            'card_button_type'                                 => __('Button style', 'ameliabooking'),
            'csb_category_services'                            => __('Services overview', 'ameliabooking'),
            'csb_category_services_content'                    => __('Set up Services view', 'ameliabooking'),
            'csb_category_service'                             => __('Service details', 'ameliabooking'),
            'csb_category_service_content'                     => __('Set up Service detailed view', 'ameliabooking'),
            'booking_form'                                     => __('Booking Form', 'ameliabooking'),
            'booking_form_content'                             => __('Set options, colors and labels for booking form', 'ameliabooking'),
            'cat_booking_form'                                 => __('Catalog', 'ameliabooking'),
            'redesigned_cat_booking_form'                      => __('Showcase your services in stylish card layouts. Easily organize them by category and tailor the appearance to match your brand.', 'ameliabooking'),
            'card_services_number'                             => __('Service count', 'ameliabooking'),
            'back_btn_heading'                                 => __('Back button', 'ameliabooking'),
            'back_btn_type'                                    => __('\'Back\' button style', 'ameliabooking'),
            'back_btn'                                         => __('Go back', 'ameliabooking'),
            'booking_btn_type'                                 => __('\'Book now\' button style', 'ameliabooking'),
            'cl_btn'                                           => __('Main category button', 'ameliabooking'),
            'cl_side_color'                                    => __('Ribbon', 'ameliabooking'),
            'cl_color'                                         => __('Color', 'ameliabooking'),
            'cil_filter_menu_btn'                              => __('\'Filter\' button style', 'ameliabooking'),
            'cil_sidebar'                                      => __('Categories sidebar', 'ameliabooking'),
            'cil_filter_block'                                 => __('Filters block', 'ameliabooking'),
            'cil_side_menu_block'                              => __('Categories sidebar', 'ameliabooking'),
            'cil_main_header'                                  => __('Page header', 'ameliabooking'),
            'cil_main_content'                                 => __('Main content', 'ameliabooking'),
            'service_category'                                 => __('Service category', 'ameliabooking'),
            'service_duration'                                 => __('Service duration', 'ameliabooking'),
            'service_about'                                    => __('About service', 'ameliabooking'),
            'cil_filter_input'                                 => __('Search', 'ameliabooking'),
            'cli_item_color'                                   => __('Card color', 'ameliabooking'),
            'page_scroll_visibility'                           => __('Page scroll', 'ameliabooking'),
            'filter_input'                                     => __('Search', 'ameliabooking'),
            'available'                                        => __('Available', 'ameliabooking'),
            'heading_service'                                  => __('Service', 'ameliabooking'),
            'heading_services'                                 => __('Services', 'ameliabooking'),
            'no_search_data'                                   => __('No results', 'ameliabooking'),
            'free'                                             => __('Free', 'ameliabooking'),
            'book_now'                                         => __('Book now', 'ameliabooking'),
            'about_service'                                    => __('About service', 'ameliabooking'),
            'view_all_photos'                                  => __('View all photos', 'ameliabooking'),
            'contact_message'                                  => __('Contact message', 'ameliabooking'),
            'company_phone'                                    => __('Company Phone:', 'ameliabooking'),
            'company_email'                                    => __('Company Email:', 'ameliabooking'),
            'elf_booking_form'                                 => __('Events list', 'ameliabooking'),
            'redesigned_elf_booking_form'                      => __('Offer a clean, list-based booking experience with a design that grabs attention. Customers can easily explore and book from your full event lineup.', 'ameliabooking'),
            'csb_events_list'                                  => __('Events list', 'ameliabooking'),
            'csb_events_list_content'                          => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'ameliabooking'),
            'csb_event_info'                                   => __('Event info', 'ameliabooking'),
            'csb_event_info_content'                           => __('Set up staff, location, gallery and other event information visibility', 'ameliabooking'),
            'csb_event_customer'                               => __('Customer information', 'ameliabooking'),
            'csb_event_customer_content'                       => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_event_payment'                                => __('Payment', 'ameliabooking'),
            'csb_event_payment_content'                        => __('Set up labels and buttons', 'ameliabooking'),
            'csb_event_congratulations'                        => __('Congratulations', 'ameliabooking'),
            'csb_event_congratulations_content'                => __('Set up button types and labels', 'ameliabooking'),
            'events_available'                                 => __('Events available', 'ameliabooking'),
            'event_available'                                  => __('Event available', 'ameliabooking'),
            'event_page'                                       => __('Page', 'ameliabooking'),
            'event_search'                                     => __('Search for events', 'ameliabooking'),
            'event_begins'                                     => __('Begins', 'ameliabooking'),
            'event_slot_left'                                  => __('slot left', 'ameliabooking'),
            'event_slots_left'                                 => __('slots left', 'ameliabooking'),
            'event_learn_more'                                 => __('Learn more', 'ameliabooking'),
            'event_read_more'                                  => __('Read more', 'ameliabooking'),
            'event_close'                                      => __('Close', 'ameliabooking'),
            'event_customer_info'                              => __('Your information', 'ameliabooking'),
            'summary_event'                                    => __('Event', 'ameliabooking'),
            'event_id'                                         => __('Event ID', 'ameliabooking'),
            'about'                                            => __('About', 'ameliabooking'),
            'event_info'                                       => __('Event info', 'ameliabooking'),
            'event_timetable'                                  => __('Timetable', 'ameliabooking'),
            'event_payment'                                    => __('Payment', 'ameliabooking'),
            'event_congrats'                                   => __('Congratulations', 'ameliabooking'),
            'event_about_list'                                 => __('About event', 'ameliabooking'),
            'event_start'                                      => __('Event starts', 'ameliabooking'),
            'event_end'                                        => __('Event ends', 'ameliabooking'),
            'event_at'                                         => __('at', 'ameliabooking'),
            'event_bringing'                                   => __('How many attendees do you want to book event for?', 'ameliabooking'),
            'step_filters'                                     => __('Filter', 'ameliabooking'),
            'event_card'                                       => __('Event card', 'ameliabooking'),
            'step_pagination'                                  => __('Step pagination', 'ameliabooking'),
            'event_slots_capacity'                             => __('Event slots capacity', 'ameliabooking'),
            'filters_button_type'                              => __('\'Filter\' button style', 'ameliabooking'),
            'read_more_button_type'                            => __('\'Read more\' button style', 'ameliabooking'),
            'learn_more_button_type'                           => __('\'Learn more\' button style', 'ameliabooking'),
            'event_tab_img'                                    => __('Image', 'ameliabooking'),
            'step_header'                                      => __('Step header', 'ameliabooking'),
            'step_info_tab'                                    => __('Step info tab', 'ameliabooking'),
            'booking_event_btn'                                => __('\'Book\' button style', 'ameliabooking'),
            'finish_event_btn'                                 => __('\'Finish\' button style', 'ameliabooking'),
            'close_event_btn'                                  => __('\'Close\' button style', 'ameliabooking'),
            'event_gallery'                                    => __('Event gallery', 'ameliabooking'),
            'event_description'                                => __('Event description', 'ameliabooking'),
            'summary_person'                                   => __('person', 'ameliabooking'),
            'event_employees'                                  => __('Event employees', 'ameliabooking'),
            'learn_more'                                       => __('Learn more', 'ameliabooking'),
            'service_information'                              => __('Service information', 'ameliabooking'),
            'learn_more_button'                                => __('\'Learn more\' button', 'ameliabooking'),
            'location_address'                                 => __('Location address', 'ameliabooking'),
            'no_results_found'                                 => __('No results found...', 'ameliabooking'),
            'card_field'                                       => __('Card field', 'ameliabooking'),
            'popup_content'                                    => __('Description', 'ameliabooking'),
            'layout'                                           => __('Layout', 'ameliabooking'),
            'search_input_field'                               => __('Search Input Field', 'ameliabooking'),
            'category_input_field'                             => __('Category Input Field', 'ameliabooking'),
            'select_service_category'                          => __('Select Service Category', 'ameliabooking'),
            'visibility'                                       => __('Visibility', 'ameliabooking'),
            'bringing_people_total'                            => __('Total people', 'ameliabooking'),
            'attendees'                                        => __('Attendees', 'ameliabooking'),
            'event_upcoming_events'                            => __('Upcoming events', 'ameliabooking'),
            'book_appointment'                                 => __('Book appointment', 'ameliabooking'),
            'custom'                                           => __('Custom', 'ameliabooking'),
            'ecf_booking_form'                                 => __('Events calendar', 'ameliabooking'),
            'redesigned_ecf_booking_form'                      => __('Display events in a calendar view, allowing customers to browse, search, and book directly. A great way to highlight upcoming events in an interactive format.', 'ameliabooking'),
            'capc_form'                                        => __('Customer panel', 'ameliabooking'),
            'redesigned_capc_form'                             => __('Enable customers to manage their appointments and events efficiently. Personalize colors and labels to create a seamless and branded experience.', 'ameliabooking'),
            'cape_form'                                        => __('Employee panel', 'ameliabooking'),
            'redesigned_cape_form'                             => __('Allow employees to manage appointments and events with ease. Customize colors to match your branding and improve usability.', 'ameliabooking'),
            'new_password_colon_retype'                        => __('Re-type new password', 'ameliabooking'),
            'catalog'                                          => __('Catalog', 'ameliabooking'),
            'choose_category'                                  => __('Choose Category', 'ameliabooking'),
            'choose_service'                                   => __('Choose Service', 'ameliabooking'),
            'choose_package'                                   => __('Choose Package', 'ameliabooking'),
            'filter'                                           => __('Preselect Booking Parameters', 'ameliabooking'),
            'skip_categories'                                  => __('Skip Categories step', 'ameliabooking'),
            'insert_amelia_shortcode'                          => __('Insert Amelia Booking Shortcode', 'ameliabooking'),
            'select_catalog_view'                              => __('Select Catalog View', 'ameliabooking'),
            'select_category'                                  => __('Select category', 'ameliabooking'),
            'select_employee'                                  => __('Select employee', 'ameliabooking'),
            'select_location'                                  => __('Select location', 'ameliabooking'),
            'select_package'                                   => __('Select Package', 'ameliabooking'),
            'select_event'                                     => __('Select Event', 'ameliabooking'),
            'select_events'                                    => __('Select Events', 'ameliabooking'),
            'select_tag'                                       => __('Select Tag', 'ameliabooking'),
            'select_tags'                                      => __('Select Tags', 'ameliabooking'),
            'select_view'                                      => __('Select View', 'ameliabooking'),
            'show'                                             => __('Show', 'ameliabooking'),
            'show_all'                                         => __('Show All', 'ameliabooking'),
            'manually_loading'                                 => __('Load booking form manually', 'ameliabooking'),
            'manually_loading_description'                     => __('Add element (button, link...) ID, that will manually load amelia shortcode content', 'ameliabooking'),
            'multiselect_note'                                 => __('For multiselect: hold CTRL / Command (⌘).', 'ameliabooking'),
            'show_all_categories'                              => __('Show all categories', 'ameliabooking'),
            'show_all_employees'                               => __('Show all employees', 'ameliabooking'),
            'show_all_locations'                               => __('Show all locations', 'ameliabooking'),
            'show_all_services'                                => __('Show all services', 'ameliabooking'),
            'show_all_events'                                  => __('Show all events', 'ameliabooking'),
            'show_all_packages'                                => __('Show all packages', 'ameliabooking'),
            'show_all_tags'                                    => __('Show all tags', 'ameliabooking'),
            'show_catalog'                                     => __('Show catalog of all categories', 'ameliabooking'),
            'show_category'                                    => __('Show specific category', 'ameliabooking'),
            'show_categories'                                  => __('Show specific categories', 'ameliabooking'),
            'show_package'                                     => __('Show specific package', 'ameliabooking'),
            'show_packages'                                    => __('Show specific packages', 'ameliabooking'),
            'show_event'                                       => __('Show event', 'ameliabooking'),
            'show_event_view_type'                             => __('Show Type', 'ameliabooking'),
            'show_event_view_list'                             => __('List (default)', 'ameliabooking'),
            'show_event_view_calendar'                         => __('Calendar', 'ameliabooking'),
            'show_tag'                                         => __('Show tag', 'ameliabooking'),
            'show_service'                                     => __('Show specific service', 'ameliabooking'),
            'show_services'                                    => __('Show specific services', 'ameliabooking'),
            'trigger_type'                                     => __('Trigger type', 'ameliabooking'),
            'trigger_type_id'                                  => __('Id', 'ameliabooking'),
            'trigger_type_class'                               => __('Class', 'ameliabooking'),
            'trigger_type_tooltip'                             => __('Trigger by attribute', 'ameliabooking'),
            'step_booking'                                     => __('Step Booking', 'ameliabooking'),
            'catalog_booking'                                  => __('Catalog Booking', 'ameliabooking'),
            'events_list_booking'                              => __('Events List Booking', 'ameliabooking'),
            'recurring_event'                                  => __('Show recurring events', 'ameliabooking'),
            'in_dialog'                                        => __('Show in Amelia Popup', 'ameliabooking'),
            'booking_divi'                                     => __('AM - Booking view', 'ameliabooking'),
            'step_booking_divi'                                => __('AM - Step Booking', 'ameliabooking'),
            'catalog_booking_divi'                             => __('AM - Catalog Booking', 'ameliabooking'),
            'catalog_divi'                                     => __('AM - Catalog view', 'ameliabooking'),
            'events_divi'                                      => __('AM - Events view', 'ameliabooking'),
            'events_list_booking_divi'                         => __('AM - Events List Booking', 'ameliabooking'),
            'events_calendar_booking_divi'                     => __('AM - Events Calendar Booking', 'ameliabooking'),
            'booking_gutenberg_block'                          => [
                'title'       => __('Amelia - Booking view', 'ameliabooking'),
                'description' => __('Step-By-Step Booking Wizard gives your customers the option to choose everything about the booking in a few steps', 'ameliabooking'),
            ],
            'step_booking_gutenberg_block'                     => [
                'title'       => __('Amelia - Step-By-Step Booking', 'ameliabooking'),
                'description' => __('Step-by-Step booking view guides the customers through several steps in order to make their bookings.', 'ameliabooking'),
            ],
            'catalog_booking_gutenberg_block'                  => [
                'title'       => __('Amelia - Catalog Booking', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a catalog', 'ameliabooking'),
            ],
            'catalog_gutenberg_block'                          => [
                'title'       => __('Amelia - Catalog view', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a cataloge', 'ameliabooking'),
            ],
            'events_gutenberg_block'                           => [
                'title'       => __('Amelia - Events', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_list_booking_gutenberg_block'              => [
                'title'       => __('Amelia - Events List', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_calendar_booking_gutenberg_block'          => [
                'title'       => __('Amelia - Events Calendar', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event calendar view.', 'ameliabooking'),
            ],
            'outdated_booking_gutenberg_block'                 => __('You are using a form that will be outdated soon!', 'ameliabooking'),
            'search'                                           => __('Search', 'ameliabooking'),
            'red_activation_settings'                          => __('Activation settings', 'ameliabooking'),
            'red_action_triggered'                             => __('Action Triggered', 'ameliabooking'),
            'red_add_custom_notification'                      => __('Add custom notification', 'ameliabooking'),
            'red_add_work_hours'                               => __('Add work hours', 'ameliabooking'),
            'red_agencies'                                     => __('Agencies', 'ameliabooking'),
            'red_api'                                          => __('API', 'ameliabooking'),
            'red_appointment_created_success'                  => __('Appointment has been created.', 'ameliabooking'),
            'red_appointment_status_updated'                   => __('Appointment status has been updated.'),
            'red_appointment_details'                          => __('Appointment details', 'ameliabooking'),
            'red_appointment_note_updated'                     => __('Appointment note has been updated.', 'ameliabooking'),
            'red_app_max_capacity_warning'                     => __('The total number of persons ({approvedPersonsCount}) exceeds the maximum capacity of {maxAppointmentCapacity}.', 'ameliabooking'),
            'red_are_you_sure_delete_items'                    => __('Are you sure you want to delete these items?', 'ameliabooking'),
            'red_at_time'                                      => __('at {time}', 'ameliabooking'),
            'red_attendee_asc'                                 => __('Attendee Asc', 'ameliabooking'),
            'red_attendee_desc'                                => __('Attendee Desc', 'ameliabooking'),
            'red_beauty'                                       => __('Beauty', 'ameliabooking'),
            'red_blog'                                         => __('Blog', 'ameliabooking'),
            'red_book'                                         => __('Book', 'ameliabooking'),
            'red_booking_closes_asc'                           => __('Booking Closes Asc', 'ameliabooking'),
            'red_booking_closes_desc'                          => __('Booking Closes Desc', 'ameliabooking'),
            'red_booking_closes'                               => __('Booking closes', 'ameliabooking'),
            'red_booking_number_count'                         => __('Booking #{count}', 'ameliabooking'),
            'red_booking_opens_asc'                            => __('Booking Opens Asc', 'ameliabooking'),
            'red_booking_opens_desc'                           => __('Booking Opens Desc', 'ameliabooking'),
            'red_booking_opens'                                => __('Booking opens', 'ameliabooking'),
            'red_booking_type'                                 => __('Booking type', 'ameliabooking'),
            'red_bookings_count'                               => __('# of bookings', 'ameliabooking'),
            'red_buddyboss'                                    => __('BuddyBoss', 'ameliabooking'),
            'red_cancel_and_delete'                            => __('Cancel and Delete', 'ameliabooking'),
            'red_configure_combined_placeholder_tooltip'       => __('Click "Configure" to edit the text that will appear when this placeholder is used in notifications.', 'ameliabooking'),
            'red_content_placeholders'                         => __('Content placeholders', 'ameliabooking'),
            'red_catalog'                                      => __('Catalog', 'ameliabooking'),
            'red_clear_filters'                                => __('Clear filters', 'ameliabooking'),
            'red_clear'                                        => __('Clear', 'ameliabooking'),
            'red_click_to_upload'                              => __('Click to upload', 'ameliabooking'),
            'red_coaching'                                     => __('Coaching', 'ameliabooking'),
            'red_color'                                        => __('Color', 'ameliabooking'),
            'red_compared_stats'                               => __('Compared to previous range', 'ameliabooking'),
            'red_consulting'                                   => __('Consulting', 'ameliabooking'),
            'red_contact_support'                              => __('Contact support.', 'ameliabooking'),
            'red_count_attendees'                              => __('{count} Attendee | {count} Attendees', 'ameliabooking'),
            'red_count_days'                                   => __('{count} day | {count} days', 'ameliabooking'),
            'red_count_hours'                                  => __('{count} hour | {count} hours', 'ameliabooking'),
            'red_count_minutes'                                => __('{count} minute | {count} minutes', 'ameliabooking'),
            'red_count_months'                                 => __('{count} month | {count} months', 'ameliabooking'),
            'red_booking_updated'                              => __('Booking has been updated.', 'ameliabooking'),
            'red_count_appointments_deleted'                   => __('{count} appointment has been deleted. | {count} appointments have been deleted.', 'ameliabooking'),
            'red_count_appointments_failed_to_be_deleted'      => __('{count} appointment has not been deleted. | {count} appointments have not been deleted.', 'ameliabooking'),
            'red_count_event_bookings_deleted'                 => __('{count} event booking has been deleted. | {count} event bookings have been deleted.', 'ameliabooking'),
            'red_count_event_bookings_failed_to_be_deleted'    => __('{count} event booking has not been deleted. | {count} event bookings have not been deleted.', 'ameliabooking'),
            'red_count_events_deleted'                         => __('{count} event has been deleted. | {count} events have been deleted.', 'ameliabooking'),
            'red_count_selected'                               => __('{count} Selected', 'ameliabooking'),
            'red_count_services_deleted'                       => __('{count} service has been deleted. | {count} services have been deleted.', 'ameliabooking'),
            'red_count_services_failed_to_be_deleted'          => __('{count} service has not been deleted. | {count} services have not been deleted.', 'ameliabooking'),
            'red_count_weeks'                                  => __('{count} week | {count} weeks', 'ameliabooking'),
            'red_table_settings_updated'                       => __('Table settings have been updated.', 'ameliabooking'),
            'red_custom_notifications'                         => __('Custom notifications', 'ameliabooking'),
            'red_customer_configuration'                       => __('Customer configuration', 'ameliabooking'),
            'red_customer_asc'                                 => __('Customer Asc', 'ameliabooking'),
            'red_customer_desc'                                => __('Customer Desc', 'ameliabooking'),
            'red_customer_note'                                => __('Customer note', 'ameliabooking'),
            'red_customers_detected_in_file'                   => __('Customers detected in file:', 'ameliabooking'),
            'red_daily_occupancy'                              => __('Daily occupancy', 'ameliabooking'),
            'red_enter_phone_number_then_press_enter_to_add'   => __('Enter a phone number, then press Enter to add', 'ameliabooking'),
            'red_dark_theme'                                   => __('Dark Theme', 'ameliabooking'),
            'red_date_asc'                                     => __('Date Asc', 'ameliabooking'),
            'red_date_desc'                                    => __('Date Desc', 'ameliabooking'),
            'red_delete_appointment'                           => __('Delete appointment', 'ameliabooking'),
            'red_delete_booking'                               => __('Delete booking', 'ameliabooking'),
            'red_delete_service_effect_past'                   => __('This service has {count} appointment in the past. | This service has {count} appointments in the past.', 'ameliabooking'),
            'red_documentation'                                => __('Documentation', 'ameliabooking'),
            'red_duplicate_appointment'                        => __('Duplicate appointment', 'ameliabooking'),
            'red_duration_asc'                                 => __('Duration Asc', 'ameliabooking'),
            'red_duration_desc'                                => __('Duration Desc', 'ameliabooking'),
            'red_e_ticket_qr_code'                             => __('E-ticket QR code', 'ameliabooking'),
            'red_edit_booking'                                 => __('Edit booking', 'ameliabooking'),
            'red_edit_event'                                   => __('Edit event', 'ameliabooking'),
            'red_edit_table_subtitle'                          => __('Drag to rearrange columns and/or choose which ones to display.', 'ameliabooking'),
            'red_edit_transaction'                             => __('Edit transaction', 'ameliabooking'),
            'red_edit_table'                                   => __('Edit table', 'ameliabooking'),
            'red_enable'                                       => __('Enable', 'ameliabooking'),
            'red_end_date'                                     => __('End date', 'ameliabooking'),
            'red_event_asc'                                    => __('Event Asc', 'ameliabooking'),
            'red_event_booking_details'                        => __('Event Booking Details', 'ameliabooking'),
            'red_event_desc'                                   => __('Event Desc', 'ameliabooking'),
            'red_event_details'                                => __('Event details', 'ameliabooking'),
            'red_export_bookings'                              => __('Export bookings', 'ameliabooking'),
            'red_facebook_social_login_description'            => __('Allow customers and employees to quickly sign in using their Facebook account, making the login process faster, simpler, and more secure.', 'ameliabooking'),
            'red_facebook_social_login'                        => __('Facebook social login', 'ameliabooking'),
            'red_feature_api_description'                      => __('Connect APIs effortlessly for smooth, integrated workflows.', 'ameliabooking'),
            'red_feature_apple_calendar_description'           => __('Connect Apple Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_barion_description'                   => __('Simple, secure payments powered by Barion.', 'ameliabooking'),
            'red_feature_buddyboss_description'                => __('Display Amelia booking forms and panels on BuddyBoss member profiles.', 'ameliabooking'),
            'red_feature_cart_description'                     => __('Allow customers to book multiple services in a single transaction for a streamlined experience.', 'ameliabooking'),
            'red_feature_coupons_description'                  => __('Offer discounts or free appointments with customizable coupons.', 'ameliabooking'),
            'red_feature_custom_duration_description'          => __('Offer services with multiple duration options for customers to choose from.', 'ameliabooking'),
            'red_feature_custom_fields_description'            => __('Use custom fields as intake forms to collect customer information during booking.', 'ameliabooking'),
            'red_feature_custom_notifications_description'     => __('Send personalized email and SMS notifications tailored to your business.', 'ameliabooking'),
            'red_feature_custom_pricing_description'           => __('Set dynamic pricing for services based on various conditions.', 'ameliabooking'),
            'red_feature_deposit_payment_description'          => __('Allow clients to secure bookings with partial payments.', 'ameliabooking'),
            'red_feature_e_ticket_qr_code_description'         => __('Enable quick, contactless event check-ins with unique QR codes for each ticket.', 'ameliabooking'),
            'red_feature_employee_badge_description'           => __('Enhance bookings with customizable badges to strengthen your brand identity.', 'ameliabooking'),
            'red_feature_event_tickets_description'            => __('Set flexible ticket pricing with categories and date-based ranges to maximize accessibility and revenue.', 'ameliabooking'),
            'red_feature_extras_description'                   => __('Offer upsells or additional benefits within a service using extras.', 'ameliabooking'),
            'red_feature_facebook_pixel_description'           => __('Add Meta Pixel to track ad conversions and optimize marketing.', 'ameliabooking'),
            'red_feature_google_analytics_description'         => __('Add a Google Analytics tracking code to your booking page to gain insights into visitor behavior.', 'ameliabooking'),
            'red_feature_google_calendar_description'          => __('Connect Google Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_google_disconnect'                    => __('Disconnect account', 'ameliabooking'),
            'red_feature_google_general_description'           => __('Sync your and your employees\' personal and professional events by connecting Google calendars.', 'ameliabooking'),
            'red_feature_google_sign_in_button'                => __('Sign in with Google', 'ameliabooking'),
            'red_feature_invoices_description'                 => __('Generate invoices automatically for bookings to streamline payments and improve client experience.', 'ameliabooking'),
            'red_feature_lesson_space_description'             => __('Create online classrooms automatically for each booked appointment or event.', 'ameliabooking'),
            'red_feature_mailchimop_description'               => __('Send your customer data to Mailchimp quickly and effortlessly.', 'ameliabooking'),
            'red_feature_mollie_description'                   => __('Accept payments seamlessly through the Mollie payment gateway.', 'ameliabooking'),
            'red_feature_no_show_tag_description'              => __('Track customers who miss appointments or events without sending notifications.', 'ameliabooking'),
            'red_feature_outlook_calendar_description'         => __('Connect Outlook Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_packages_description'                 => __('Bundle multiple appointments or services at discounted rates to encourage customers to book more.', 'ameliabooking'),
            'red_feature_paypal_description'                   => __('Accept payments for bookings and services via PayPal.', 'ameliabooking'),
            'red_feature_razorpay_description'                 => __('Accept payments via Razorpay, ideal for Indian businesses.', 'ameliabooking'),
            'red_feature_recaptcha_description'                => __('Protect your booking system from bots by integrating reCAPTCHA keys.', 'ameliabooking'),
            'red_feature_recurring_appointments_description'   => __('Allow customers to book repeating appointments with customizable recurrence.', 'ameliabooking'),
            'red_feature_resources_description'                => __('Create resources like rooms or chairs that can be shared across services, locations, and employees.', 'ameliabooking'),
            'red_feature_square_description'                   => __('Process payments easily with Square.', 'ameliabooking'),
            'red_feature_stripe_description'                   => __('Securely process payments using Stripe.', 'ameliabooking'),
            'red_feature_tax_description'                      => __('Automatically calculate and apply taxes for hassle-free compliance and accurate billing.', 'ameliabooking'),
            'red_feature_time_zones_description'               => __('Set individual time zones for employees so availability and bookings are shown correctly for clients worldwide.', 'ameliabooking'),
            'red_feature_event_waiting_list_description'       => __('Manage event cancellations efficiently by allowing customers to join waiting lists and filling open spots manually.', 'ameliabooking'),
            'red_feature_appointment_waiting_list_description' => __('Efficiently manage appointment cancellations by allowing customers to join a waiting list and manually fill newly opened time slots.', 'ameliabooking'),
            'red_feature_webhooks_description'                 => __('Connect with web apps to automate messaging and send updates to custom URLs.', 'ameliabooking'),
            'red_feature_whatsapp_description'                 => __('Send appointment notifications directly via WhatsApp.', 'ameliabooking'),
            'red_feature_woocommerce_description'              => __('Integrate with WooCommerce to enable advanced e-commerce capabilities.', 'ameliabooking'),
            'red_feature_zoom_description'                     => __('Automatically create Zoom meetings for bookings and notify customers and employees.', 'ameliabooking'),
            'red_features_integrations'                        => __('Features & Integrations', 'ameliabooking'),
            'red_features'                                     => __('Features', 'ameliabooking'),
            'red_fri'                                          => __('Fri', 'ameliabooking'),
            'red_full_events'                                  => __('Full events', 'ameliabooking'),
            'red_go_to_custom_fields'                          => __('Go to Custom Fields', 'ameliabooking'),
            'red_google_calendar_and_google_meet'              => __('Google Calendar & Google Meet', 'ameliabooking'),
            'red_google_meet'                                  => __('Google Meet', 'ameliabooking'),
            'red_google_social_login_description'              => __('Allow customers and employees to quickly sign in using their Google account, making the login process faster, simpler, and more secure.', 'ameliabooking'),
            'red_google_social_login'                          => __('Google social login', 'ameliabooking'),
            'red_gyms'                                         => __('Gyms', 'ameliabooking'),
            'red_healthcare'                                   => __('Healthcare', 'ameliabooking'),
            'red_hidden'                                       => __('Hidden', 'ameliabooking'),
            'red_hour_short'                                   => __('h', 'ameliabooking'),
            'red_id_asc'                                       => __('ID Asc', 'ameliabooking'),
            'red_id_desc'                                      => __('ID Desc', 'ameliabooking'),
            'red_import_rules_1'                               => __('You can import the following columns: First name, Last name, Email, Phone, Gender, Birthday, Note.', 'ameliabooking'),
            'red_industries'                                   => __('Industries', 'ameliabooking'),
            'red_import_rules_2'                               => __('The first row should not contain column names.', 'ameliabooking'),
            'red_import_rules_3'                               => __('Valid first and last names are required fields.', 'ameliabooking'),
            'red_import_rules_4'                               => __('First and last names must be in two separate fields.', 'ameliabooking'),
            'red_import_rules_5'                               => __('Date of birth must be in the same format as chosen in your WP settings. If a date format with a comma is used, the dates should be in quotes.', 'ameliabooking'),
            'red_import_rules_6'                               => __('Phone number must include a country code.', 'ameliabooking'),
            'red_import_rules_7'                               => __('Gender should be specified as either \'male\' or \'female\'.', 'ameliabooking'),
            'red_import_rules_8'                               => __('If multiple customers have the same email address, only the first one will be imported.', 'ameliabooking'),
            'red_import_rules_9'                               => __('If invalid, other values will be skipped and not imported.', 'ameliabooking'),
            'red_last_booking_asc'                             => __('Last Booking Asc', 'ameliabooking'),
            'red_last_booking_desc'                            => __('Last Booking Desc', 'ameliabooking'),
            'red_less_options'                                 => __('Less options', 'ameliabooking'),
            'red_light_theme'                                  => __('Light Theme', 'ameliabooking'),
            'red_manage_bookings'                              => __('Manage bookings', 'ameliabooking'),
            'red_max_capacity_asc'                             => __('Max Capacity Asc', 'ameliabooking'),
            'red_max_capacity_desc'                            => __('Max Capacity Desc', 'ameliabooking'),
            'red_microsoft_teams'                              => __('Microsoft Teams', 'ameliabooking'),
            'red_message'                                      => __('Message', 'ameliabooking'),
            'red_message_content'                              => __('Message content', 'ameliabooking'),
            'red_message_template'                             => __('Message template', 'ameliabooking'),
            'red_minute_short'                                 => __('min', 'ameliabooking'),
            'red_mon'                                          => __('Mon', 'ameliabooking'),
            'red_more_features_zero_limits'                    => __('More Features Zero Limits', 'ameliabooking'),
            'red_more_options'                                 => __('More options', 'ameliabooking'),
            'red_need_additional_fields'                       => __('Need additional fields?', 'ameliabooking'),
            'red_new_attendee'                                 => __('New Attendee', 'ameliabooking'),
            'red_new_event_booking'                            => __('New event booking', 'ameliabooking'),
            'red_new_update'                                   => __('New Update', 'ameliabooking'),
            'red_no_appointments_subtitle_1'                   => __('Once you receive bookings, your appointments will be displayed here. You can also get started by clicking the Add button below.', 'ameliabooking'),
            'red_no_appointments_yet'                          => __('No appointments yet', 'ameliabooking'),
            'red_no_attendees_found'                           => __('No attendees found', 'ameliabooking'),
            'red_no_event_bookings_subtitle_1'                 => __('Once you receive event bookings, they will be displayed here. You can also get started by clicking the Book Event button below.', 'ameliabooking'),
            'red_no_event_bookings_yet'                        => __('No event bookings yet', 'ameliabooking'),
            'red_no_events_subtitle_1'                         => __('Once you add your first event, it will appear here. Click + Event below to get started.', 'ameliabooking'),
            'red_no_events_yet'                                => __('No events yet', 'ameliabooking'),
            'red_no_results_found_empty'                       => __('No results found', 'ameliabooking'),
            'red_no_results_found'                             => __('No results found', 'ameliabooking'),
            'red_no_results_found_for'                         => __('No results found for', 'ameliabooking'),
            'red_no_search_results_subtitle'                   => __('Try adjusting your search or filters.', 'ameliabooking'),
            'red_no_services_or_employees_available_subtitle'  => __('Please ensure that services and employees are created and that services are assigned to employees.', 'ameliabooking'),
            'red_no_services_or_employees_available'           => __('No services or employees available', 'ameliabooking'),
            'red_no_services_subtitle_1_part_1'                => __('Once you add your first service, it will appear here.', 'ameliabooking'),
            'red_no_services_subtitle_1_part_2'                => __('Click + Service below to get started.', 'ameliabooking'),
            'red_no_services_subtitle_2_part_1'                => __('Try adjusting your filters or search criteria to find the services you\'re looking for.', 'ameliabooking'),
            'red_no_services_subtitle_2_part_2'                => __('You can also clear all filters to view all services.', 'ameliabooking'),
            'red_no_services_yet'                              => __('No services yet', 'ameliabooking'),
            'red_no_show_1'                                    => __('No Show (1)', 'ameliabooking'),
            'red_no_show_2'                                    => __('No Show (2)', 'ameliabooking'),
            'red_no_show_3_plus'                               => __('No Show (3+)', 'ameliabooking'),
            'red_no_show_tag'                                  => __('No-show tag', 'ameliabooking'),
            'red_no_top_trends'                                => __('No top trends', 'ameliabooking'),
            'red_no_transactions_subtitle_1'                   => __('Once you start receiving bookings, transactions will be displayed here.', 'ameliabooking'),
            'red_no_transactions_title'                        => __('No transactions yet', 'ameliabooking'),
            'red_no_upcoming_events_subtitle'                  => __('There are no future events scheduled. Please create a new event.', 'ameliabooking'),
            'red_no_upcoming_events'                           => __('No upcoming events', 'ameliabooking'),
            'red_no_wp_users_with_amelia_customer_role'        => __('No WordPress users with the Amelia Customer role are available.', 'ameliabooking'),
            'red_notifications'                                => __('Notifications', 'ameliabooking'),
            'red_occupancy_rate_info'                          => __('This widget shows monthly data instead of using the global date range.', 'ameliabooking'),
            'red_occupancy_rate'                               => __('Occupancy rate', 'ameliabooking'),
            'red_occupied'                                     => __('Occupied', 'ameliabooking'),
            'red_on_site_payment'                              => __('On-site payment', 'ameliabooking'),
            'red_organizers'                                   => __('Organizers', 'ameliabooking'),
            'red_payment_methods'                              => __('Payment methods', 'ameliabooking'),
            'red_payment_methods_compatibility_rules'          => __('Some payment methods cannot be used together due to compatibility rules', 'ameliabooking'),
            'red_outlook_calendar_and_microsoft_teams'         => __('Outlook Calendar & Microsoft Teams', 'ameliabooking'),
            'red_paragraph'                                    => __('Paragraph', 'ameliabooking'),
            'red_placeholder_tooltip'                          => __('Select a placeholder to insert it where your cursor is placed.', 'ameliabooking'),
            'red_plans'                                        => __('Plans', 'ameliabooking'),
            'red_please_enter_content'                         => __('Please enter a content.', 'ameliabooking'),
            'red_please_enter_notification_name'               => __('Please enter a notification name.', 'ameliabooking'),
            'red_please_enter_subject'                         => __('Please enter a subject.', 'ameliabooking'),
            'red_please_enter_ticket_name'                     => __('Please enter a ticket name.', 'ameliabooking'),
            'red_recaptcha'                                    => __('reCAPTCHA', 'ameliabooking'),
            'red_recurring_alert_setup'                        => __('Before enabling the recurring option, ensure that all required fields are set, including the service, employee, date, time, and location (if applicable).', 'ameliabooking'),
            'red_reorder_on_website'                           => __('Reorder on website', 'ameliabooking'),
            'red_reorder_services_description'                 => __('Reordering services affects how they are displayed on the website.', 'ameliabooking'),
            'red_reorder_services'                             => __('Reorder Services', 'ameliabooking'),
            'red_reorder_services_failed'                      => __('Failed to reorder services.', 'ameliabooking'),
            'red_reorder_services_successfully'                => __('Services have been reordered.', 'ameliabooking'),
            'red_replace'                                      => __('Replace', 'ameliabooking'),
            'red_revenue_prev_range'                           => __('Previous range', 'ameliabooking'),
            'red_revenue_this_range'                           => __('This range', 'ameliabooking'),
            'red_roles_permissions'                            => __('Roles & permissions', 'ameliabooking'),
            'red_same_day'                                     => __('Same day', 'ameliabooking'),
            'red_sat'                                          => __('Sat', 'ameliabooking'),
            'red_scheduled'                                    => __('Scheduled', 'ameliabooking'),
            'red_scope'                                        => __('Scope', 'ameliabooking'),
            'red_scopes'                                       => __('Scopes', 'ameliabooking'),
            'red_search_bookings'                              => __('Search bookings', 'ameliabooking'),
            'red_search_features'                              => __('Search features', 'ameliabooking'),
            'red_search_integrations'                          => __('Search integrations', 'ameliabooking'),
            'red_search_invoices'                              => __('Search invoices', 'ameliabooking'),
            'red_search_notifications'                         => __('Search notifications', 'ameliabooking'),
            'red_search_packages'                              => __('Search packages', 'ameliabooking'),
            'red_search_services'                              => __('Search services', 'ameliabooking'),
            'red_select_attendee_warning'                      => __('Please select an attendee.', 'ameliabooking'),
            'red_select_booking_closes_date_warning'           => __('Please select a closing date.', 'ameliabooking'),
            'red_select_booking_closes_time_warning'           => __('Please select a closing time.', 'ameliabooking'),
            'red_select_booking_opens_date_warning'            => __('Please select an opening date.', 'ameliabooking'),
            'red_select_booking_opens_time_warning'            => __('Please select an opening time.', 'ameliabooking'),
            'red_select_box'                                   => __('Select box', 'ameliabooking'),
            'red_select_color_warning'                         => __('Please select a color.', 'ameliabooking'),
            'red_select_date_range_warning'                    => __('Please select a date range.', 'ameliabooking'),
            'red_select_end_time_warning'                      => __('Please select an end time.', 'ameliabooking'),
            'red_select_event_warning'                         => __('Please select an event.', 'ameliabooking'),
            'red_select_start_time_warning'                    => __('Please select a start time.', 'ameliabooking'),
            'red_send_test'                                    => __('Send test', 'ameliabooking'),
            'red_service_asc'                                  => __('Service Asc', 'ameliabooking'),
            'red_service_categories'                           => __('Service Categories', 'ameliabooking'),
            'red_service_desc'                                 => __('Service Desc', 'ameliabooking'),
            'red_service_event'                                => __('Service/Event', 'ameliabooking'),
            'red_service_updated_success'                      => __('Service has been updated.', 'ameliabooking'),
            'red_services_count'                               => __('{count} Service | {count} Services', 'ameliabooking'),
            'red_show_bookings'                                => __('Show bookings', 'ameliabooking'),
            'red_show_event'                                   => __('Show event', 'ameliabooking'),
            'red_show_event_subtitle'                          => __('Are you sure you want to show this event?', 'ameliabooking'),
            'red_show_in_calendar'                             => __('View in Calendar', 'ameliabooking'),
            'red_single_booking'                               => __('Single booking', 'ameliabooking'),
            'red_sms'                                          => __('SMS', 'ameliabooking'),
            'red_sms_balance'                                  => __('SMS balance', 'ameliabooking'),
            'red_sms_settings'                                 => __('SMS Settings', 'ameliabooking'),
            'red_spots'                                        => __('Spots', 'ameliabooking'),
            'red_booked'                                       => __('Booked', 'ameliabooking'),
            'red_start_date'                                   => __('Start date', 'ameliabooking'),
            'red_status_asc'                                   => __('Status Asc', 'ameliabooking'),
            'red_status_desc'                                  => __('Status Desc', 'ameliabooking'),
            'red_studios'                                      => __('Studios', 'ameliabooking'),
            'red_subject_placeholders'                         => __('Subject placeholders', 'ameliabooking'),
            'red_sun'                                          => __('Sun', 'ameliabooking'),
            'red_support'                                      => __('Support', 'ameliabooking'),
            'red_thu'                                          => __('Thu', 'ameliabooking'),
            'red_time_zones'                                   => __('Time zones', 'ameliabooking'),
            'red_tip_appointment_management_guide'             => __('Appointment management guide', 'ameliabooking'),
            'red_tip_custom_service_duration'                  => __('Custom service duration', 'ameliabooking'),
            'red_tip_event_calendar_booking_from'              => __('Event calendar booking from', 'ameliabooking'),
            'red_tip_event_list_booking_from'                  => __('Event list booking from', 'ameliabooking'),
            'red_tip_event_management_guide'                   => __('Events setup', 'ameliabooking'),
            'red_tip_event_pricing_setup'                      => __('Events custom pricing', 'ameliabooking'),
            'red_tip_event_ticketing'                          => __('Event ticketing', 'ameliabooking'),
            'red_tip_events_list_view'                         => __('Events list view', 'ameliabooking'),
            'red_tip_events_pricing'                           => __('Events pricing', 'ameliabooking'),
            'red_tip_front_end_customer_panel'                 => __('Front-end customer panel', 'ameliabooking'),
            'red_tip_importing_customers'                      => __('Importing customers', 'ameliabooking'),
            'red_tip_notification_settings'                    => __('Notification settings', 'ameliabooking'),
            'red_tip_notifications_in_amelia'                  => __('Notifications in Amelia', 'ameliabooking'),
            'red_tip_recurring_appointments_setup'             => __('Recurring appointments setup', 'ameliabooking'),
            'red_tip_recurring_events_description'             => __('Create and manage recurring events with customizable schedules for flexibility and convenience.', 'ameliabooking'),
            'red_tip_recurring_events'                         => __('Recurring events', 'ameliabooking'),
            'red_tip_services_categories_setup'                => __('Services & categories setup', 'ameliabooking'),
            'red_tip_services_setup'                           => __('Services setup', 'ameliabooking'),
            'red_tip_step_by_step_booking_form_guide'          => __('Step-by-step booking form guide', 'ameliabooking'),
            'red_tips_and_suggestions'                         => __('Tips & suggestions', 'ameliabooking'),
            'red_total_capacity'                               => __('Total capacity', 'ameliabooking'),
            'red_trainers'                                     => __('Trainers', 'ameliabooking'),
            'red_transaction'                                  => __('Transaction', 'ameliabooking'),
            'red_transaction_details'                          => __('Transaction details', 'ameliabooking'),
            'red_transaction_number_count'                     => __('Transaction #{count}', 'ameliabooking'),
            'red_transactions'                                 => __('Transactions', 'ameliabooking'),
            'red_try_adjusting_search'                         => __('Try adjusting your search to find what you are looking for.', 'ameliabooking'),
            'red_tue'                                          => __('Tue', 'ameliabooking'),
            'red_update_service_settings'                      => __('Update Service Settings', 'ameliabooking'),
            'red_updates'                                      => __('Updates', 'ameliabooking'),
            'red_upgrade'                                      => __('Upgrade', 'ameliabooking'),
            'red_upload_avatar'                                => __('Upload image', 'ameliabooking'),
            'red_upload'                                       => __('Upload', 'ameliabooking'),
            'red_videos'                                       => __('Videos', 'ameliabooking'),
            'red_view_booking'                                 => __('View booking', 'ameliabooking'),
            'red_view_invoice'                                 => __('View invoice', 'ameliabooking'),
            'red_watch_tutorials'                              => __('Video tutorials', 'ameliabooking'),
            'red_web'                                          => __('Web', 'ameliabooking'),
            'red_webhooks'                                     => __('Webhooks', 'ameliabooking'),
            'red_wed'                                          => __('Wed', 'ameliabooking'),
            'red_wellness'                                     => __('Wellness', 'ameliabooking'),
            'red_whatsapp'                                     => __('WhatsApp', 'ameliabooking'),
            'red_working_hours'                                => __('Working hours', 'ameliabooking'),
            'red_yoga'                                         => __('Yoga', 'ameliabooking'),
            'top_trends'                                       => __('Top trends', 'ameliabooking'),
            'red_no_customers_title'                           => __('No customers yet', 'ameliabooking'),
            'red_no_customers_subtitle_1'                      => __('Once you start receiving bookings, your customers will be displayed here. You can also get started by clicking the Add button below.', 'ameliabooking'),
            'red_tip_customer_setup'                           => __('Customer setup', 'ameliabooking'),
            'red_how_to'                                       => __('How to', 'ameliabooking'),
            'red_packages_locked_heading'                      => __('Boost revenue with bundled service packages', 'ameliabooking'),
            'red_packages_locked_description'                  => __('Turn your services into high-value packages that customers love. Combine multiple appointments into a single, discounted offer that drives bigger, more confident purchases.', 'ameliabooking'),
            'red_packages_feature_1'                           => __('Increase sales volume by encouraging customers to book more appointments at once', 'ameliabooking'),
            'red_packages_feature_2'                           => __('Flexible pricing lets you set a fixed package price and offer attractive discounts', 'ameliabooking'),
            'red_packages_feature_3'                           => __('Improved customer retention as clients return to use the remaining sessions in their package', 'ameliabooking'),
            'red_resources_locked_heading'                     => __('Manage shared resources with ease', 'ameliabooking'),
            'red_resources_locked_description'                 => __('Create rooms, equipment, or other resources that can be shared across employees, services, or locations, ensuring customers only see time slots when everything they need is truly available.', 'ameliabooking'),
            'red_resources_feature_1'                          => __('Avoid double-booking by automatically coordinating shared rooms, equipment, or tools', 'ameliabooking'),
            'red_resources_feature_2'                          => __('Streamline operations with one central place to manage all resources across your business', 'ameliabooking'),
            'red_resources_feature_3'                          => __('Deliver a smoother booking experience by showing customers only real, available time slots', 'ameliabooking'),
            'red_extras_locked_heading'                        => __('Boost revenue with valuable extras', 'ameliabooking'),
            'red_extras_locked_description'                    => __('Offer optional or mandatory extras during the booking process - upsell additional services, products, or experiences to enhance appointments and delight your customers.', 'ameliabooking'),
            'red_extras_feature_1'                             => __('Increase revenue by encouraging customers to purchase additional services or products', 'ameliabooking'),
            'red_extras_feature_2'                             => __('Customize offerings to match specific services and meet diverse client needs', 'ameliabooking'),
            'red_extras_feature_3'                             => __('Enhance the customer experience with tailored add-ons that add convenience and value', 'ameliabooking'),
            'red_locations_locked_heading'                     => __('Effortless management for every location', 'ameliabooking'),
            'red_locations_locked_description'                 => __('Easily organize multiple business locations in one place, ensuring smooth operations and a consistent booking experience no matter where your services are offered.', 'ameliabooking'),
            'red_locations_feature_1'                          => __('Centralize scheduling across all branches for clearer, simpler management', 'ameliabooking'),
            'red_locations_feature_2'                          => __('Improve customer experience by letting clients choose the location that suits them best', 'ameliabooking'),
            'red_locations_feature_3'                          => __('Keep operations aligned with unified settings, availability, and resource control', 'ameliabooking'),
            'red_custom_fields_locked_heading'                 => __('Collect the information your business truly needs', 'ameliabooking'),
            'red_custom_fields_locked_description'             => __('Build tailored forms across services, events, and customer profiles using custom fields. Capture exactly the details you need with checkboxes, text areas, and more, turning every booking and registration into a powerful intake process.', 'ameliabooking'),
            'red_custom_fields_feature_1'                      => __('Customize every interaction by gathering the right information for services, events, and customer records', 'ameliabooking'),
            'red_custom_fields_feature_2'                      => __('Keep your data organized and meaningful with structured fields that standardize the information you collect', 'ameliabooking'),
            'red_custom_fields_feature_3'                      => __('Enhance the customer experience with clear, intuitive forms designed around your business needs', 'ameliabooking'),
            'red_invoices_locked_heading'                      => __('Automated invoices for a smoother payment experience', 'ameliabooking'),
            'red_invoices_locked_description'                  => __('Automatically generate invoices for every booking, making payments easier, more transparent, and fully streamlined for both you and your clients.', 'ameliabooking'),
            'red_invoices_feature_1'                           => __('Save time and reduce manual work with instant, auto-generated invoices', 'ameliabooking'),
            'red_invoices_feature_2'                           => __('Improve accuracy and professionalism with consistent, clearly formatted billing', 'ameliabooking'),
            'red_invoices_feature_3'                           => __('Enhance client trust by providing transparent, documented payment details for every booking', 'ameliabooking'),
            'red_coupons_locked_heading'                       => __('Drive bookings with irresistible coupon offers', 'ameliabooking'),
            'red_coupons_locked_description'                   => __('Create unique coupon codes that customers can redeem during booking-offer discounts or even free appointments to boost engagement, satisfaction, and sales.', 'ameliabooking'),
            'red_coupons_feature_1'                            => __('Increase conversions by motivating customers with attractive, limited-time deals', 'ameliabooking'),
            'red_coupons_feature_2'                            => __('Flexible discount options let you set custom values or offer full-price waivers', 'ameliabooking'),
            'red_coupons_feature_3'                            => __('Enhance customer loyalty by rewarding clients with exclusive, personalized offers', 'ameliabooking'),
            'red_taxes_locked_heading'                         => __('Effortless tax management for every booking', 'ameliabooking'),
            'red_taxes_locked_description'                     => __('Automatically calculate and apply taxes to your services and events, ensuring accurate billing and hassle-free compliance with every transaction.', 'ameliabooking'),
            'red_taxes_feature_1'                              => __('Eliminate manual calculations with smart, automated tax application', 'ameliabooking'),
            'red_taxes_feature_2'                              => __('Ensure accurate billing by applying the correct tax rates every time', 'ameliabooking'),
            'red_taxes_feature_3'                              => __('Stay compliant with ease through consistent, reliable tax handling across your business', 'ameliabooking'),
            'red_whatsapp_locked_heading'                      => __('Stay connected with WhatsApp notifications', 'ameliabooking'),
            'red_whatsapp_locked_description'                  => __('Keep customers and employees informed by sending appointment and event notifications directly through WhatsApp - choose predefined messages or customize your own for a personal touch.', 'ameliabooking'),
            'red_whatsapp_feature_1'                           => __('Boost engagement by reaching clients instantly on a platform they use every day', 'ameliabooking'),
            'red_whatsapp_feature_2'                           => __('Reduce no-shows with timely reminders sent automatically', 'ameliabooking'),
            'red_whatsapp_feature_3'                           => __('Simplify communication with customizable messages for both customers and employees', 'ameliabooking'),
            'red_recurring_events_locked_heading'              => __('Simplify scheduling with recurring events', 'ameliabooking'),
            'red_recurring_events_locked_description'          => __('Effortlessly set up and manage events that repeat on your preferred schedule-offering flexibility, consistency, and a smooth experience for both your business and your customers.', 'ameliabooking'),
            'red_recurring_events_feature_1'                   => __('Save time by automating repeating events instead of creating them manually', 'ameliabooking'),
            'red_recurring_events_feature_2'                   => __('Maintain consistent scheduling with customizable frequencies and patterns', 'ameliabooking'),
            'red_recurring_events_feature_3'                   => __('Improve customer convenience by offering predictable, easy-to-book recurring options', 'ameliabooking'),
            'red_employee_integrations_locked_heading'         => __('Empower your team with seamless integrations', 'ameliabooking'),
            'red_employee_integrations_locked_description'     => __('Connect employee calendars, meeting tools, and other integrations to keep schedules perfectly synced and communication effortless across your entire team.', 'ameliabooking'),
            'red_employee_integrations_feature_1'              => __('Prevent scheduling conflicts with real-time calendar syncing for every employee.', 'ameliabooking'),
            'red_employee_integrations_feature_2'              => __('Streamline virtual meetings by integrating popular meeting platforms directly into bookings.', 'ameliabooking'),
            'red_employee_integrations_feature_3'              => __('Boost team productivity with automated updates and fewer manual tasks.', 'ameliabooking'),
            'red_employee_note_updated'                        => __('Employee note has been updated.', 'ameliabooking'),
            'red_customer_note_updated'                        => __('Customer note has been updated.', 'ameliabooking'),
            'red_need_to_update_company_days_off'             => __('Need to update your company\'s days off?', 'ameliabooking'),
            'red_manage_company_days_off'                     => __('Manage company days off', 'ameliabooking'),
            'red_learn_more'                                   => __('Learn more', 'ameliabooking'),
            'red_no_employees_yet'                             => __('No employees yet', 'ameliabooking'),
            'red_no_employees_subtitle_1'                      => __('Once you add your first employee, it will appear here. Click + Employee below to get started.', 'ameliabooking'),
            'red_attendees_search_placeholder'                 => __('Search attendees', 'ameliabooking'),
            'red_total_payments'                               => __('Total payments', 'ameliabooking'),
            'red_event_booking_closes_at'                      => __('Closes at', 'ameliabooking'),
            'red_booking_source'                               => __('Booking source', 'ameliabooking'),
            'red_edit_event_booking'                           => __('Edit event booking', 'ameliabooking'),
            'red_availability'                                 => __('Availability', 'ameliabooking'),
            'red_employee_details'                             => __('Employee details', 'ameliabooking'),
            'red_show_more_count'                              => __('Show more ({count})', 'ameliabooking'),
            'red_actions'                                      => __('Actions', 'ameliabooking'),
            'red_tip_employee_setup'                           => __('Employee setup', 'ameliabooking'),
            'red_tip_managing_assigned_services'               => __('Managing assigned services', 'ameliabooking'),
            'red_tip_special_days_setup'                       => __('Special days setup', 'ameliabooking'),
            'red_tip_setting_up_days_off'                      => __('Setting up days off', 'ameliabooking'),
            'red_tip_employee_badges_management'               => __('Employee badges management', 'ameliabooking'),
            'red_tip_google_meet_setup'                        => __('Google Meet setup', 'ameliabooking'),
            'red_tip_work_hours_setup'                         => __('Work hours setup', 'ameliabooking'),
            'red_all_assigned_services'                        => __('All assigned services', 'ameliabooking'),
            'red_default_location'                             => __('Default location', 'ameliabooking'),
            'red_tip_zoom_setup'                               => __('Zoom setup', 'ameliabooking'),
            'red_tip_front_end_employee_panel'                 => __('Front-end employee panel', 'ameliabooking'),
            'red_tip_roles_settings'                           => __('Roles settings', 'ameliabooking'),
            'red_hide_service'                                 => __('Hide service', 'ameliabooking'),
            'red_duplicate_service'                            => __('Duplicate service', 'ameliabooking'),
            'red_duplicate_category'                           => __('Duplicate category', 'ameliabooking'),
            'red_delete_category_effect_future'                => __('Could not delete category. This category has services with {count} future appointment. | Could not delete category. This category has services with {count} future appointments.', 'ameliabooking'),
            'red_delete_category_effect_past'                  => __('This category has services with {count} past appointment. | This category has services with {count} past appointments.', 'ameliabooking'),
            'red_delete_service_effect_future'                 => __('Could not delete service. This service has {count} appointment in the future. | Could not delete service. This service has {count} appointments in the future.', 'ameliabooking'),
            'red_hide_employee'                                => __('Hide employee', 'ameliabooking'),
            'red_show_employee'                                => __('Show employee', 'ameliabooking'),
            'red_show_service'                                 => __('Show service', 'ameliabooking'),
            'red_delete_customer'                              => __('Delete customer', 'ameliabooking'),
            'red_delete_employee'                              => __('Delete employee', 'ameliabooking'),
            'red_delete_user_effect_future'                    => __('Could not delete user. This user has {count} appointment in the future. | Could not delete user. This user has {count} appointments in the future.', 'ameliabooking'),
            'red_block_customer'                               => __('Block customer', 'ameliabooking'),
            'red_unblock_customer'                             => __('Unblock customer', 'ameliabooking'),
            'red_hide_event'                                   => __('Hide event', 'ameliabooking'),
            'red_hide_event_subtitle'                          => __('Are you sure you want to hide this event?', 'ameliabooking'),
            'red_event_cancel_delete'                          => __('Are you sure you want to cancel and delete this event?', 'ameliabooking'),
            'red_confirm_delete_event_booking'                 => __('Are you sure you want to delete this event booking?', 'ameliabooking'),
            'red_notification_status_updated'                  => __('Notification status has been updated.', 'ameliabooking'),
            'red_notification_status_failed'                   => __('Notification status has not been updated.', 'ameliabooking'),
            'red_draft'                                        => __('Draft', 'ameliabooking'),
            'red_customers_deleted_success'                    => __('{count} customer deleted. | {count} customers deleted.', 'ameliabooking'),
            'red_event_hidden'                                 => __('Event has been hidden.', 'ameliabooking'),
            'red_event_visible'                                => __('Event is now visible.', 'ameliabooking'),
            'red_customer_details'                             => __('Customer details', 'ameliabooking'),
            'red_last_on'                                      => __('Last on {date}', 'ameliabooking'),
            'red_customers_deleted_error'                      => __('{count} customer could not be deleted due to future bookings. | {count} customers could not be deleted due to future bookings.', 'ameliabooking'),
            'red_customer_updated_success'                     => __('Customer has been updated.', 'ameliabooking'),
            'red_watch_on_youtube'                             => __('Watch on YouTube', 'ameliabooking'),
            'red_repeat_every_year'                            => __('Repeat every year', 'ameliabooking'),
            'red_edit_work_hours'                              => __('Edit work hours', 'ameliabooking'),
            'red_edit_day_off'                                 => __('Edit day off', 'ameliabooking'),
            'red_hide_tips_and_suggestions'                    => __('Hide tips & suggestions', 'ameliabooking'),
            'red_export_appointments_locked_title'             => __('Export appointment data with ease', 'ameliabooking'),
            'red_export_appointments_locked_description'       => __('Quickly download all appointment details from the Bookings page, making reporting, analysis, and record-keeping simple and efficient.', 'ameliabooking'),
            'red_export_appointments_locked_feature_1'         => __('Save time with fast, one-click appointment exports', 'ameliabooking'),
            'red_export_appointments_locked_feature_2'         => __('Improve reporting accuracy by accessing complete appointment data instantly', 'ameliabooking'),
            'red_export_appointments_locked_feature_3'         => __('Stay organized with export files ready for analysis or external tools', 'ameliabooking'),
            'red_export_customers_locked_title'                => __('Easily export your customer data in one click', 'ameliabooking'),
            'red_export_customers_locked_description'          => __('Download your customer list instantly for reporting, marketing, or external system use, making data management faster and more convenient than ever.', 'ameliabooking'),
            'red_export_customers_locked_feature_1'            => __('Save time with quick, hassle-free customer data exports', 'ameliabooking'),
            'red_export_customers_locked_feature_2'            => __('Support deeper insights by using exported data for analysis and reporting', 'ameliabooking'),
            'red_export_customers_locked_feature_3'            => __('Enhance flexibility with customer information ready for marketing tools or external platforms', 'ameliabooking'),
            'red_custom_notifications_locked_title'            => __('Send smart, personalized notifications your way', 'ameliabooking'),
            'red_custom_notifications_locked_description'      => __('Create custom notifications that trigger based on booking status or schedule reminders, keeping customers and employees informed at exactly the right time.', 'ameliabooking'),
            'red_custom_notifications_locked_feature_1'        => __('Automate communication with notifications triggered by booking status, time, or custom rules', 'ameliabooking'),
            'red_custom_notifications_locked_feature_2'        => __('Keep everyone on track using scheduled reminders that reduce no-shows and confusion', 'ameliabooking'),
            'red_custom_notifications_locked_feature_3'        => __('Deliver personalized messages tailored to your business tone, branding, and workflow', 'ameliabooking'),
            'red_export_payments_locked_title'                 => __('Access your financial data in seconds', 'ameliabooking'),
            'red_export_payments_locked_description'           => __('Export all transaction records from the Finance page for effortless accounting, reconciliation, or sharing with your finance tools.', 'ameliabooking'),
            'red_export_payments_locked_feature_1'             => __('Simplify financial management with easy, one-click transaction exports', 'ameliabooking'),
            'red_export_payments_locked_feature_2'             => __('Ensure accurate bookkeeping with clear, organized financial data', 'ameliabooking'),
            'red_export_payments_locked_feature_3'             => __('Support external workflows by seamlessly moving financial records into other systems', 'ameliabooking'),
            'red_multiple_employees_locked_title'              => __('Grow your team with unlimited employee management', 'ameliabooking'),
            'red_multiple_employees_locked_description'        => __('Add multiple employees to your booking system, manage their schedules, and assign them to services or events, making it easy to scale your business and coordinate your team.', 'ameliabooking'),
            'red_multiple_employees_locked_feature_1'          => __('Expand your capacity by adding as many employees as your business needs', 'ameliabooking'),
            'red_multiple_employees_locked_feature_2'          => __('Simplify scheduling with individual availability, working hours, and assignments', 'ameliabooking'),
            'red_multiple_employees_locked_feature_3'          => __('Improve customer choice by letting clients book with the employee that suits them best', 'ameliabooking'),
            'red_notification'                                 => __('Notification', 'ameliabooking'),
            'red_confirm_delete_event'                         => __('Are you sure you want to delete this event?', 'ameliabooking'),
            'red_delete_category'                              => __('Delete category', 'ameliabooking'),
            'red_delete_service'                               => __('Delete service', 'ameliabooking'),
            'red_configuration'                                => __('Configuration', 'ameliabooking'),
            'red_delete_user_effect_past'                      => __('This user has {count} appointment in the past. | This user has {count} appointments in the past.', 'ameliabooking'),
            'red_delete_user_event_effect_future'              => __('This user is an attendee in future event. Are you sure you want to delete this user? | This user is an attendee in future events. Are you sure you want to delete this user?', 'ameliabooking'),
            'red_no_wp_users_with_amelia_employee_role'        => __('No WordPress users with the Amelia Employee role are available.', 'ameliabooking'),
            'red_set_up'                                       => __('Set up', 'ameliabooking'),
            'red_disable'                                      => __('Disable', 'ameliabooking'),
            'enter_email_then_press_enter_to_add'              => __('Enter email, then press Enter to add', 'ameliabooking'),
            'payment_links_warning'                            => __('This option requires adding the payment link placeholder to your message templates.', 'ameliabooking'),
            'payment_links_redirect'                           => __('Redirect URL after payment', 'ameliabooking'),
            'payment_links_redirect_tooltip'                   => __('Customers will be redirected to this URL after they complete their payment.', 'ameliabooking'),
            'basic'                                            => __('Basic', 'ameliabooking'),
            'advanced'                                         => __('Advanced', 'ameliabooking'),
            'field_options'                                    => __('Options', 'ameliabooking'),
            'field_order'                                      => __('Field order', 'ameliabooking'),
            'button'                                           => __('Button', 'ameliabooking'),
            'language'                                         => __('Language', 'ameliabooking'),
            'go_to_sbs_form'                                   => __('Go to Step-by-step form', 'ameliabooking'),
            'go_to_cat_form'                                   => __('Go to Catalog form', 'ameliabooking'),
            'redirect'                                         => __('Redirect', 'ameliabooking'),
            'save_data_on_redirect'                            => __('Your data will be saved before redirecting to another form.', 'ameliabooking'),
            'steps_order'                                      => __('Steps order', 'ameliabooking'),
            'labels'                                           => __('Labels', 'ameliabooking'),
            'forms_picker'                                     => __('Forms', 'ameliabooking'),
            'accent'                                           => __('Accent', 'ameliabooking'),
            'accent_text'                                      => __('Accent text', 'ameliabooking'),
            'secondary'                                        => __('Secondary', 'ameliabooking'),
            'secondary_text'                                   => __('Secondary text', 'ameliabooking'),
            'body_text'                                        => __('Body text', 'ameliabooking'),
            'publish'                                          => __('Publish', 'ameliabooking'),
            'red_employee_added_success'                       => __('Employee has been created.', 'ameliabooking'),
            'red_employee_updated_success'                     => __('Employee has been updated.', 'ameliabooking'),
            'employee_deleted'                                 => __('Employee has been deleted.', 'ameliabooking'),
            'red_update'                                       => __('Update', 'ameliabooking'),
            'background'                                       => __('Background', 'ameliabooking'),
            'outline'                                          => __('Outline', 'ameliabooking'),
            'placeholder_text'                                 => __('Placeholder text', 'ameliabooking'),
            'available_date_background'                        => __('Available date background', 'ameliabooking'),
            'available_date_text'                              => __('Available date text', 'ameliabooking'),
            'selected_date_background'                         => __('Selected date background', 'ameliabooking'),
            'selected_date_text'                               => __('Selected date text', 'ameliabooking'),
            'unavailable_date_background'                      => __('Unavailable date background', 'ameliabooking'),
            'unavailable_date_text'                            => __('Unavailable date text', 'ameliabooking'),
            'employee_description'                             => __('Employee description popup', 'ameliabooking'),
            'content_area'                                     => __('Content area', 'ameliabooking'),
            'filters'                                          => __('Filters', 'ameliabooking'),
            'red_categories_positions_failed'                  => __('Failed to update category positions.', 'ameliabooking'),
            'red_category_added_success'                       => __('Category has been created.', 'ameliabooking'),
            'red_category_updated_success'                     => __('Category has been updated.', 'ameliabooking'),
            'red_customer_added_success'                       => __('Customer has been created.', 'ameliabooking'),
            'red_event_booking_updated_success'                => __('Event booking has been updated.', 'ameliabooking'),
            'red_event_created_success'                        => __('Event has been created.', 'ameliabooking'),
            'red_event_updated_success'                        => __('Event has been updated.', 'ameliabooking'),
            'red_event_booking_created_success'                => __('Event booking has been created.', 'ameliabooking'),
            'red_service_added_success'                        => __('Service has been added.', 'ameliabooking'),
            'csb_events_calendar'                              => __('Events calendar', 'ameliabooking'),
            'csb_event_tickets'                                => __('Event tickets', 'ameliabooking'),
            'upcoming_events_block'                            => __('Upcoming events section', 'ameliabooking'),
            'step_search'                                      => __('Search', 'ameliabooking'),
            'customer_panel_btn'                               => __('\'Customer panel\' button style', 'ameliabooking'),
            'step_heading'                                     => __('Step heading', 'ameliabooking'),
            'event_today'                                      => __('Today', 'ameliabooking'),
            'event_no_spots'                                   => __('No spots left', 'ameliabooking'),
            'evt_empty_message'                                => __('There are no upcoming events for this period', 'ameliabooking'),
            'taxes'                                            => __('Taxes', 'ameliabooking'),
            'title_text'                                       => __('Title text', 'ameliabooking'),
            'info_text'                                        => __('Info text', 'ameliabooking'),
            'primary_button_type'                              => __('Primary button style', 'ameliabooking'),
            'secondary_button_type'                            => __('Secondary button style', 'ameliabooking'),
            'font_family'                                      => __('Font family', 'ameliabooking'),
            'red_event_booking_opens_at'                       => __('Opens at', 'ameliabooking'),
            'bringing_people'                                  => __('Additional people', 'ameliabooking'),
            'add_ticket_category'                              => __('Add pricing category', 'ameliabooking'),
            'red_shared_category_capacity'                     => __('Shared category capacity', 'ameliabooking'),
            'red_maximum_spots'                                => __('Maximum spots', 'ameliabooking'),
            'red_continue_setup'                               => __('Continue setup', 'ameliabooking'),
            'red_skip_setup'                                   => __('Skip setup', 'ameliabooking'),
            'red_welcome_amelia'                               => __('Welcome to Amelia!', 'ameliabooking'),
            'red_welcome_amelia_desc'                          => __('It looks like this is your first time here, so let’s walk through a few simple steps to help you get started.', 'ameliabooking'),
            'red_set_general_settings'                         => __('Set general settings', 'ameliabooking'),
            'red_set_general_settings_desc'                    =>__('Set your company working hours. This schedule will be used for all new employees, however you can customize schedule for each employee later.', 'ameliabooking'),
            'red_default_time_slot_step_desc'                  => __('Choose a time interval that will be used when defining all time based settings.', 'ameliabooking'),
            'red_currency_desc'                                => __('Choose a currency that will be used for all price based settings.', 'ameliabooking'),
            'red_next'                                         => __('Next', 'ameliabooking'),
            'red_create_employee'                              => __('Create employee', 'ameliabooking'),
            'red_create_employee_desc'                         => __('In Amelia, an employee is a team member who provides services or hosts events, with their own schedule, working hours, and assigned offerings.', 'ameliabooking'),
            'red_skip_setup_confirmation_desc'                 => __('Are you sure you want to skip the setup? Once skipped, the guided setup will no longer be available. All settings will need to be configured later.', 'ameliabooking'),
            'red_step_1'                                       => __('Step 1', 'ameliabooking'),
            'red_step_2'                                       => __('Step 2', 'ameliabooking'),
            'red_step_3'                                       => __('Step 3', 'ameliabooking'),
            'red_step_4'                                       => __('Step 4', 'ameliabooking'),
            'red_how_will_use_amelia'                          => __('How will you use Amelia?', 'ameliabooking'),
            'red_how_will_use_amelia_desc'                     => __('Choose whether you want to manage services, events, or both.', 'ameliabooking'),
            'red_create_service'                               => __('Create service', 'ameliabooking'),
            'red_create_service_desc'                          => __('Book time-based appointments with configurable durations, prices, and availability.', 'ameliabooking'),
            'red_create_service_page_desc'                     => __('In Amelia, a “service” is a specific appointment-type offering your business provides to clients - such as consultations, treatments, or classes - that can be fully customized with its own name, duration, price, capacity, availability, and extras, and booked online with assigned employees.', 'ameliabooking'),
            'red_create_event'                                 => __('Create event', 'ameliabooking'),
            'red_create_event_desc'                            => __('Create scheduled events with fixed dates, prices and capacities.', 'ameliabooking'),
            'red_create_event_page_desc'                       => __('In Amelia, an event is a booking-type offering designed for group activities or multi-day occasions - such as workshops, conferences, tours, or training series - that can be configured with its own schedule, capacity, pricing structure and assigned staff.', 'ameliabooking'),
            'red_finish'                                       => __('Finish', 'ameliabooking'),
            'red_select_at_least_one_option'                   => __('Select at least one option.', 'ameliabooking'),
            'red_employee_name'                                => __('Employee name', 'ameliabooking'),
            'red_appointment_title'                            => __('Appointment title', 'ameliabooking'),
            'filter_all'                                       => __('All', 'ameliabooking'),
            'red_feature_outlook_general_description'          => __('Sync your and your employee\'s personal and professional events by connection Outlook calendars.', 'ameliabooking'),
            'red_feature_outlook_sign_in_button'               => __('Sign in with Microsoft', 'ameliabooking'),
            'red_smtp_validation_failed'                       => __('SMTP credentials validation failed. Please check your settings.', 'ameliabooking'),
        ];
    }
}
