import af from 'element-plus/dist/locale/af.mjs'
import ar from 'element-plus/dist/locale/ar.mjs'
import bg from 'element-plus/dist/locale/bg.mjs'
import bn from 'element-plus/dist/locale/bn.mjs'
import ca from 'element-plus/dist/locale/ca.mjs'
import cs from 'element-plus/dist/locale/cs.mjs'
import da from 'element-plus/dist/locale/da.mjs'
import de from 'element-plus/dist/locale/de.mjs'
import el from 'element-plus/dist/locale/el.mjs'
import en from 'element-plus/dist/locale/en.mjs'
import es from 'element-plus/dist/locale/es.mjs'
import et from 'element-plus/dist/locale/et.mjs'
import eu from 'element-plus/dist/locale/eu.mjs'
import fa from 'element-plus/dist/locale/fa.mjs'
import fi from 'element-plus/dist/locale/fi.mjs'
import fr from 'element-plus/dist/locale/fr.mjs'
import he from 'element-plus/dist/locale/he.mjs'
import hr from 'element-plus/dist/locale/hr.mjs'
import hu from 'element-plus/dist/locale/hu.mjs'
import hyAm from 'element-plus/dist/locale/hy-am.mjs'
import id from 'element-plus/dist/locale/id.mjs'
import it from 'element-plus/dist/locale/it.mjs'
import ja from 'element-plus/dist/locale/ja.mjs'
import kk from 'element-plus/dist/locale/kk.mjs'
import km from 'element-plus/dist/locale/km.mjs'
import ko from 'element-plus/dist/locale/ko.mjs'
import lt from 'element-plus/dist/locale/lt.mjs'
import lv from 'element-plus/dist/locale/lv.mjs'
import mn from 'element-plus/dist/locale/mn.mjs'
import nbNo from 'element-plus/dist/locale/nb-no.mjs'
import nl from 'element-plus/dist/locale/nl.mjs'
import pa from 'element-plus/dist/locale/pa.mjs'
import pl from 'element-plus/dist/locale/pl.mjs'
import pt from 'element-plus/dist/locale/pt.mjs'
import ptBr from 'element-plus/dist/locale/pt-br.mjs'
import ro from 'element-plus/dist/locale/ro.mjs'
import ru from 'element-plus/dist/locale/ru.mjs'
import sk from 'element-plus/dist/locale/sk.mjs'
import sl from 'element-plus/dist/locale/sl.mjs'
import sr from 'element-plus/dist/locale/sr.mjs'
import sv from 'element-plus/dist/locale/sv.mjs'
import ta from 'element-plus/dist/locale/ta.mjs'
import th from 'element-plus/dist/locale/th.mjs'
import tr from 'element-plus/dist/locale/tr.mjs'
import ugCn from 'element-plus/dist/locale/ug-cn.mjs'
import uk from 'element-plus/dist/locale/uk.mjs'
import uzUz from 'element-plus/dist/locale/uz-uz.mjs'
import vi from 'element-plus/dist/locale/vi.mjs'
import zhCn from 'element-plus/dist/locale/zh-cn.mjs'
import zhTw from 'element-plus/dist/locale/zh-tw.mjs'
function elementPlusTranslations (lang) {
  let translation
  switch (lang) {
    case 'af':
      translation = af
      break
    case 'ar':
      translation = ar
      break
    case 'bg_BG':
      translation = bg
      break
    case 'bn_BD':
      translation = bn
      break
    case 'ca':
      translation = ca
      break
    case 'cs_CZ':
      translation = cs
      break
    case 'da_DK':
      translation = da
      break
    case 'de_DE_formal':
    case 'de_AT':
    case 'de_DE':
    case 'de_CH':
    case 'de_CH_informal':
      translation = de
      break
    case 'el':
      translation = el
      break
    case 'en_AU':
    case 'en_CA':
    case 'en_GB':
    case 'en_US':
    case 'en_NZ':
    case 'en_ZA':
      translation = en
      break
    case 'es_PE':
    case 'es_CR':
    case 'es_EC':
    case 'es_CO':
    case 'es_UY':
    case 'es_PR':
    case 'es_GT':
    case 'es_AR':
    case 'es_CL':
    case 'es_MX':
    case 'es_ES':
    case 'es_VE':
      translation = es
      break
    case 'et':
      translation = et
      break
    case 'eu':
      translation = eu
      break
    case 'fa_IR':
    case 'fa_AF':
      translation = fa
      break
    case 'fi':
      translation = fi
      break
    case 'fr_FR':
    case 'fr_CA':
    case 'fr_BE':
      translation = fr
      break
    case 'he_IL':
      translation = he
      break
    case 'hr':
      translation = hr
      break
    case 'hu_HU':
      translation = hu
      break
    case 'hy':
      translation = hyAm
      break
    case 'id_ID':
      translation = id
      break
    case 'it_IT':
      translation = it
      break
    case 'ja':
      translation = ja
      break
    case 'kk':
      translation = kk
      break
    case 'km':
      translation = km
      break
    case 'ko_KR':
      translation = ko
      break
    case 'lt_LT':
      translation = lt
      break
    case 'lv':
      translation = lv
      break
    case 'mn':
      translation = mn
      break
    case 'nb_NO':
      translation = nbNo
      break
    case 'nl_BE':
    case 'nl_NL':
    case 'nl_NL_formal':
      translation = nl
      break
    case 'pa_IN':
      translation = pa
      break
    case 'pl_PL':
      translation = pl
      break
    case 'pt_PT_ao90':
    case 'pt_PT':
    case 'pt_AO':
      translation = pt
      break
    case 'pt_BR':
      translation = ptBr
      break
    case 'ro_RO':
      translation = ro
      break
    case 'ru_RU':
      translation = ru
      break
    case 'sk_SK':
      translation = sk
      break
    case 'sl_SI':
      translation = sl
      break
    case 'sr_RS':
      translation = sr
      break
    case 'sv_SE':
      translation = sv
      break
    case 'ta_IN':
    case 'ta_LK':
      translation = ta
      break
    case 'th':
      translation = th
      break
    case 'tr_TR':
      translation = tr
      break
    case 'ug_CN':
      translation = ugCn
      break
    case 'uk':
      translation = uk
      break
    case 'uz_UZ':
      translation = uzUz
      break
    case 'vi':
      translation = vi
      break
    case 'zh_CN':
      translation = zhCn
      break
    case 'zh_TW':
      translation = zhTw
      break
    default:
      translation = en
  }

  return translation
}

function monthsTranslationsShort (lang) {
  let months = {}
  let obj = elementPlusTranslations(lang).el.datepicker.months
  Object.keys(obj).forEach((month, index) => {
    months[index+1] = obj[month]
  })

  return months
}

export {
  elementPlusTranslations,
  monthsTranslationsShort
}