<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

/**
 * Class LiteBackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class LiteBackendStrings
{
    /**
     * @var array|null
     */
    protected static $liteStrings = null;

    /**
     * Returns a single settings string by key
     *
     * @param string $key
     *
     * @return string
     */
    public static function get($key)
    {
        if (self::$liteStrings === null) {
            self::$liteStrings = self::getAllStrings();
        }

        return self::$liteStrings[$key] ?? '';
    }

    /**
     * Returns the array for the settings strings
     *
     * @return array
     */
    public static function getAllStrings()
    {
        return [
            'admin'                                            => __('Admin', 'ameliabooking'),
            'add_date'                                         => __('Add Date', 'ameliabooking'), // Used in Redesign
            'add_period'                                       => __('Add period', 'ameliabooking'), // Used in Redesign
            'all_services'                                     => __('All services', 'ameliabooking'), // Used in Redesign
            'amount_colon'                                     => __('Amount:', 'ameliabooking'), // Used in Redesign
            'appointment'                                      => __('Appointment', 'ameliabooking'), // Used in Redesign
            'appointments'                                     => __('Appointments', 'ameliabooking'), // Used in Redesign
            'approved'                                         => __('Approved', 'ameliabooking'), // Used in Redesign
            'attendee'                                         => __('Attendee', 'ameliabooking'), // Used in Redesign
            'birthday'                                         => __('Birthday', 'ameliabooking'), // Used in Redesign
            'booked'                                           => __('Booked', 'ameliabooking'), // Used in Redesign
            'booking'                                          => __('Booking', 'ameliabooking'), // Used in Redesign
            'bookings'                                         => __('Bookings', 'ameliabooking'), // Used in Redesign
            'cancel'                                           => __('Cancel', 'ameliabooking'),
            'canceled'                                         => __('Canceled', 'ameliabooking'), // Used in Redesign
            'content_mode_tooltip'                             => __('HTML formatting may be overridden by plain text formatting upon switching between modes.', 'ameliabooking'), // Used in Redesign
            'close'                                            => __('Close', 'ameliabooking'), // Used in Redesign
            'closed'                                           => __('Closed', 'ameliabooking'), // Used in Redesign
            'csv_delimiter'                                    => __('Select delimiter', 'ameliabooking'), // Used in Redesign
            'csv_delimiter_comma'                              => __('Comma (,)', 'ameliabooking'),
            'continue'                                         => __('Continue', 'ameliabooking'), // Used in Redesign
            'coupon_code'                                      => __('Coupon code', 'ameliabooking'), // Used in Redesign | Updated
            'customer'                                         => __('Customer', 'ameliabooking'), // Used in Redesign
            'minutes'                                          => __('Minutes', 'ameliabooking'),
            'hour'                                             => __('Hour', 'ameliabooking'), // Used in Redesign
            'hours'                                            => __('Hours', 'ameliabooking'),
            'day'                                              => __('Day', 'ameliabooking'), // Used in Redesign
            'days'                                             => __('Days', 'ameliabooking'), // Used in Redesign
            'week'                                             => __('Week', 'ameliabooking'), // Used in Redesign
            'weeks'                                            => __('Weeks', 'ameliabooking'), // Used in Redesign
            'month'                                            => __('Month', 'ameliabooking'), // Used in Redesign
            'months'                                           => __('Months', 'ameliabooking'), // Used in Redesign
            'year'                                             => __('Year', 'ameliabooking'), // Used in Redesign
            'date'                                             => __('Date', 'ameliabooking'), // Used in Redesign
            'delete'                                           => __('Delete', 'ameliabooking'), // Used in Redesign
            'description'                                      => __('Description', 'ameliabooking'),
            'details'                                          => __('Details', 'ameliabooking'), // Used in Redesign
            'disabled'                                         => __('Disabled', 'ameliabooking'), // Used in Redesign
            'duration'                                         => __('Duration', 'ameliabooking'), // Used in Redesign
            'duplicate'                                        => __('Duplicate', 'ameliabooking'), // Used in Redesign
            'edit'                                             => __('Edit', 'ameliabooking'), // Used in Redesign
            'employee'                                         => __('Employee', 'ameliabooking'), // Used in Redesign
            'employees'                                        => __('Employees', 'ameliabooking'), // Used in Redesign
            'employee_badge'                                   => __('Employee Badge', 'ameliabooking'), // Used in Redesign
            'employee_badges'                                  => __('Employee badges', 'ameliabooking'),
            'company_days_off'                                 => __('Company days off', 'ameliabooking'), // Used in Redesign | Updated
            'employee_days_off'                                => __('Employee days off', 'ameliabooking'), // Used in Redesign | Updated
            'enter_email_warning'                              => __('Please enter an email.', 'ameliabooking'), // Used in Redesign  Updated
            'enter_valid_email_warning'                        => __('Please enter a valid email address', 'ameliabooking'), // Used in Redesign  Updated
            'error'                                            => __('Error', 'ameliabooking'),
            'event'                                            => __('Event', 'ameliabooking'), // Used in Redesign
            'events'                                           => __('Events', 'ameliabooking'), // Used in Redesign
            'export'                                           => __('Export', 'ameliabooking'), // Used in Redesign
            'extra'                                            => __('Extra', 'ameliabooking'), // Used in Redesign
            'extras'                                           => __('Extras', 'ameliabooking'), // Used in Redesign
            'extras_total_price'                               => __('Extras total price', 'ameliabooking'),
            'google_calendar'                                  => __('Google Calendar', 'ameliabooking'), // Used in Redesign
            'google_meet_join'                                 => __('Join with Google Meet', 'ameliabooking'),
            'outlook_calendar'                                 => __('Outlook Calendar', 'ameliabooking'), // Used in Redesign
            'microsoft_teams_join'                             => __('Join with Microsoft Teams', 'ameliabooking'),
            'apple_calendar'                                   => __('Apple Calendar', 'ameliabooking'), // Used in Redesign
            'h'                                                => __('h', 'ameliabooking'), // Used in Redesign
            'id'                                               => __('ID', 'ameliabooking'), // Used in Redesign
            'lesson_space'                                     => __('Lesson Space', 'ameliabooking'), // Used in Redesign
            'licence_description'                              => __('Interested in unlocking this feature?', 'ameliabooking'),
            'licence_start_description'                        => __('Available from Starter license', 'ameliabooking'),
            'licence_basic_description'                        => __('Available from Standard license', 'ameliabooking'),
            'licence_pro_description'                          => __('Available from Pro license', 'ameliabooking'),
            'licence_dev_description'                          => __('Available in Elite licence', 'ameliabooking'),
            'licence_button_text'                              => __('Upgrade', 'ameliabooking'),
            'delete_amelia_short'                              => __('Delete Amelia content', 'ameliabooking'),
            'delete_amelia'                                    => __('Delete tables, roles, files and settings once the Amelia plugin is deleted.', 'ameliabooking'),
            'delete_amelia_tooltip'                            => __('Enable this option if you want to delete plugin tables, roles, files and settings<br>when deleting the plugin from plugins page', 'ameliabooking'),
            'appointment_space_name'                           => __('Appointment space name', 'ameliabooking'), // Used in Redesign
            'event_space_name'                                 => __('Event space name', 'ameliabooking'), // Used in Redesign
            'lesson_space_join'                                => __('Join Space', 'ameliabooking'),
            'lesson_space_pending'                             => __('Create spaces for pending appointments', 'ameliabooking'), // Used in Redesign  Updated
            'limit_extra_people'                               => __('Limit additional people', 'ameliabooking'), // Used in Redesign  Updated
            'limit_extra_people_tooltip'                       => __('Set a maximum number of people a customer can add when booking.', 'ameliabooking'), // Used in Redesign  Updated
            'location'                                         => __('Location', 'ameliabooking'), // Used in Redesign
            'locations'                                        => __('Locations', 'ameliabooking'), // Used in Redesign
            'min'                                              => __('min', 'ameliabooking'), // Used in Redesign
            'measurement_id'                                   => __('Measurement ID', 'ameliabooking'), // Used in Redesign
            'name'                                             => __('Name', 'ameliabooking'), // Used in Redesign
            'enter_name_warning'                               => __('Please enter a name.', 'ameliabooking'), // Used in Redesign | Updated
            'name_ascending'                                   => __('Name Asc', 'ameliabooking'), // Used in Redesign
            'name_descending'                                  => __('Name Desc', 'ameliabooking'), // Used in Redesign
            'need_help'                                        => __('Need help?', 'ameliabooking'), // Used in Redesign  Updated
            'no'                                               => __('No', 'ameliabooking'), // Used in Redesign  Updated
            'no-show'                                          => __('No-show', 'ameliabooking'), // Used in Redesign  Updated
            'note'                                             => __('Note', 'ameliabooking'), // Used in Redesign
            'note_internal'                                    => __('Note (internal)', 'ameliabooking'), // Used in Redesign
            'notifications'                                    => __('Notifications', 'ameliabooking'), // Used in Redesign - duplicate value 'red_notifications'
            'on_site'                                          => __('On-site', 'ameliabooking'), // Used in Redesign  Updated
            'opened'                                           => __('Opened', 'ameliabooking'),
            'open'                                             => __('Open', 'ameliabooking'), // Used in Redesign
            'packages'                                         => __('Packages', 'ameliabooking'), // Used in Redesign
            'paid'                                             => __('Paid', 'ameliabooking'), // Used in Redesign
            'partially_paid'                                   => __('Partially paid', 'ameliabooking'), // Used in Redesign
            'payment'                                          => __('Payment', 'ameliabooking'),
            'payment_amount'                                   => __('Payment amount', 'ameliabooking'), // Used in Redesign
            'payment_id_colon'                                 => __('Payment ID:', 'ameliabooking'), // Used in Redesign
            'payment_method'                                   => __('Payment method', 'ameliabooking'), // Used in Redesign
            'payment_status'                                   => __('Payment status', 'ameliabooking'), // Used in Redesign
            'payment_tooltip'                                  => __('If all payment methods are disabled on the service/event, the default payment method will be used.', 'ameliabooking'),
            'pdf'                                              => __('PDF', 'ameliabooking'),
            'pending'                                          => __('Pending', 'ameliabooking'), // Used in Redesign
            'phone'                                            => __('Phone', 'ameliabooking'), // Used in Redesign - duplicate value 'phone_colon'
            'refunded'                                         => __('Refunded', 'ameliabooking'), // Used in Redesign
            'rejected'                                         => __('Rejected', 'ameliabooking'), // Used in Redesign
            'resources'                                        => __('Resources', 'ameliabooking'), // Used in Redesign
            'save'                                             => __('Save', 'ameliabooking'), // Used in Redesign
            'select_date_warning'                              => __('Please select a date.', 'ameliabooking'), // Used in Redesign  Updated
            'select_time_warning'                              => __('Please select a time.', 'ameliabooking'), // Used in Redesign  Updated
            'service'                                          => __('Service', 'ameliabooking'), // Used in Redesign
            'services'                                         => __('Services', 'ameliabooking'), // Used in Redesign
            'settings_saved'                                   => __('Settings have been saved.', 'ameliabooking'), // Used in Redesign  Updated
            'social_login'                                     => __('Social login', 'ameliabooking'),
            'status'                                           => __('Status', 'ameliabooking'), // Used in Redesign
            'status_colon'                                     => __('Status:', 'ameliabooking'),
            'success'                                          => __('Success', 'ameliabooking'),
            'text_mode'                                        => __('Text', 'ameliabooking'), // Used in Redesign  Updated
            'html_mode'                                        => __('HTML', 'ameliabooking'), // Used in Redesign  Updated
            'tag'                                              => __('Tag', 'ameliabooking'),
            'to'                                               => __('To', 'ameliabooking'), // Used in Redesign  Updated
            'today'                                            => __('Today', 'ameliabooking'), // Used in Redesign
            'tomorrow'                                         => __('Tomorrow', 'ameliabooking'), // Used in Redesign
            'total'                                            => __('Total', 'ameliabooking'), // Used in Redesign
            'translate'                                        => __('Translate', 'ameliabooking'), // Used in Redesign
            'waiting'                                          => __('Waiting', 'ameliabooking'),
            'weekday_friday'                                   => __('Friday', 'ameliabooking'),
            'weekday_monday'                                   => __('Monday', 'ameliabooking'), // Used in Redesign
            'weekday_saturday'                                 => __('Saturday', 'ameliabooking'), // Used in Redesign
            'weekday_sunday'                                   => __('Sunday', 'ameliabooking'), // Used in Redesign
            'weekday_thursday'                                 => __('Thursday', 'ameliabooking'),
            'weekday_tuesday'                                  => __('Tuesday', 'ameliabooking'),
            'weekday_wednesday'                                => __('Wednesday', 'ameliabooking'),
            'yes'                                              => __('Yes', 'ameliabooking'), // Used in Redesign
            'zoom'                                             => __('Zoom', 'ameliabooking'), // Used in Redesign
            'zoom_click_to_join'                               => __('Join Zoom', 'ameliabooking'), // Used in Redesign  Updated
            'zoom_click_to_start'                              => __('Start Zoom', 'ameliabooking'), // Used in Redesign  Updated
            'view_grid'                                        => __('Grid view', 'ameliabooking'), // Used in Redesign
            'view_list'                                        => __('List view', 'ameliabooking'), // Used in Redesign
            'whats_new'                                        => __('What\'s New', 'ameliabooking'),
            'layout_select_label'                              => __('Choose layout version', 'ameliabooking'),
            'layout_dropdown'                                  => __('Dropdown layout', 'ameliabooking'),
            'layout_list'                                      => __('List layout', 'ameliabooking'),
            'layout_description'                               => __('Choosing layout of first step in step by step form', 'ameliabooking'),
            'xml'                                              => __('XML', 'ameliabooking'),
            'recurring'                                        => __('Recurring', 'ameliabooking'), // Used in Redesign
            'payment_warning'                                  => __('You have disabled all available payment methods. The default payment method from the general settings will be used instead.', 'ameliabooking'), // Used in Redesign | Updated
            'type'                                             => __('Type', 'ameliabooking'), // Used in Redesign
            'all_events'                                       => __('All events', 'ameliabooking'), // Used in Redesign
            'add'                                              => __('Add', 'ameliabooking'), // Used in Redesign
            'integrations'                                     => __('Integrations', 'ameliabooking'), // Used in Redesign
            'import'                                           => __('Import', 'ameliabooking'), // Used in Redesign
            'all'                                              => __('All', 'ameliabooking'), // Used in Redesign
            'from'                                             => __('From', 'ameliabooking'),
            'tax'                                              => __('Tax', 'ameliabooking'), // Used in Redesign
            'event_tickets'                                    => __('Tickets', 'ameliabooking'), // Used in Redesign
            '1year'                                            => __('1 year', 'ameliabooking'), // Used in Redesign
            'activate'                                         => __('Activate', 'ameliabooking'), // Used in Redesign
            'activation'                                       => __('Activation', 'ameliabooking'), // Used in Redesign
            'address'                                          => __('Address', 'ameliabooking'), // Used in Redesign
            'after'                                            => __('After', 'ameliabooking'), // Used in Redesign
            'after_with_space'                                 => __('After with space', 'ameliabooking'),
            'allow_booking_if_pending_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to book appointment with Pending status above the maximum capacity. Once the maximum capacity is reached appointment will close and time slot will become unavailable.', 'ameliabooking'),
            'allow_booking_if_not_min_tooltip'                 => __('If this is disabled, your front-end customers won\'t be able to submit a booking unless they fill in the minimum service capacity, but once they book for any capacity above minimum, the time slot will become unavailable for booking for others. If enabled, multiple customers will be able to book the same time slot, without having to fill in the minimum capacity.', 'ameliabooking'),
            'allow_booking_if_not_min'                         => __('Allow booking below minimum capacity', 'ameliabooking'),
            'allow_admin_book_at_any_time'                     => __('Allow admin to book appointment at any time', 'ameliabooking'),
            'allow_admin_book_over_app'                        => __('Allow admin to book over an existing appointment', 'ameliabooking'),
            'allow_admin_book_at_any_time_tooltip'             => __('If you enable this option, Admin will be able to book appointment at any time (working hours, special days and days off for all employees will be ignored).', 'ameliabooking'),
            'allow_admin_book_over_app_tooltip'                => __('If you enable this option, Admin will be able to book appointment over or during another appointment.', 'ameliabooking'),
            'allow_configure_days_off'                         => __('Allow employees to manage their special days', 'ameliabooking'),
            'allow_configure_services'                         => __('Allow employees to manage their services', 'ameliabooking'),
            'allow_configure_schedule'                         => __('Allow employees to manage their schedule', 'ameliabooking'),
            'allow_configure_special_days'                     => __('Allow employees to manage their days off', 'ameliabooking'),
            'allow_booking_if_pending'                         => __('Allow booking above maximum capacity', 'ameliabooking'),
            'allow_customer_reschedule'                        => __('Allow customers to reschedule their own appointments', 'ameliabooking'),
            'allow_customer_reschedule_tooltip'                => __('Enable this option if you want to allow your customers to reschedule their own appointments.', 'ameliabooking'),
            'allow_customer_delete_profile'                    => __('Allow customers to delete their profile', 'ameliabooking'),
            'allow_customer_cancel_packages'                   => __('Allow customers to cancel packages', 'ameliabooking'),
            'allow_write_appointments'                         => __('Allow employees to manage their appointments', 'ameliabooking'),
            'allow_write_events'                               => __('Allow employees to manage their events', 'ameliabooking'),
            'allow_write_customers'                            => __('Allow employees to manage customers', 'ameliabooking'),
            'api_url'                                          => __('API base URL: ', 'ameliabooking'), // Used in Redesign | Updated
            'maximum_capacity'                                 => __('Maximum capacity', 'ameliabooking'), // Used in Redesign | Updated
            'waiting_list'                                     => __('Waiting list', 'ameliabooking'), // Used in Redesign | Updated
            'events_waiting_list'                              => __('Events waiting list', 'ameliabooking'),
            'appointments_waiting_list'                        => __('Appointments waiting list', 'ameliabooking'),
            'show_waiting_list_booking_full'                   => __('Show waiting list after booking is full', 'ameliabooking'), // Used in Redesign | Updated
            'approve_appointment_success_url'                  => __('Redirect URL for successfully approved booking', 'ameliabooking'),
            'approve_appointment_error_url'                    => __('Redirect URL for unsuccessfully approved booking', 'ameliabooking'),
            'automatically_create_customer'                    => __('Automatically create Amelia Customer user', 'ameliabooking'),
            'automatically_create_customer_tooltip'            => __('If you enable this option every time a new customer schedules the appointment he will get Amelia Customer user role and automatic email with login details.', 'ameliabooking'),
            'back_links'                                       => __('Support Amelia by displaying a backlink', 'ameliabooking'),  // Used in Redesign | Updated
            'back_links_tooltip'                               => __('Allow the short description below the booking form to support Amelia Booking Plugin and spread the word about it.', 'ameliabooking'),
            'bcc_email'                                        => __('Send all notifications to additional addresses', 'ameliabooking'),
            'bcc_email_tooltip'                                => __('Here you can enter additional email addresses where all notifications will be sent. To add an address click Enter.', 'ameliabooking'),
            'bcc_sms'                                          => __('Send all SMS messages to additional numbers', 'ameliabooking'),
            'bcc_sms_tooltip'                                  => __('Here you can enter additional phone numbers where all SMS messages will be sent. To add a number click Enter.', 'ameliabooking'),
            'before'                                           => __('Before', 'ameliabooking'), // Used in Redesign
            'before_with_space'                                => __('Before with space', 'ameliabooking'),
            'bringing_anyone_logic'                            => __('People counting logic', 'ameliabooking'),
            'bringing_anyone_logic_additional'                 => __('Customer plus additional people', 'ameliabooking'),
            'bringing_anyone_logic_additional_tt'              => __('Counts one primary customer plus any additional people they add.', 'ameliabooking'),
            'bringing_anyone_logic_total'                      => __('Total people', 'ameliabooking'),
            'bringing_anyone_logic_total_tt'                   => __('Counts the total number of people entered, including the primary customer.', 'ameliabooking'),
            'buffer_time_in_slot'                              => __('Include service buffer time in time slots', 'ameliabooking'),
            'buffer_time_in_slot_tooltip'                      => __('If this option is enabled time slots will be shown with included service buffer time.', 'ameliabooking'),
            'coupons_case_insensitive'                         => __('Set coupons to be case insensitive', 'ameliabooking'),
            'calendar'                                         => __('Calendar', 'ameliabooking'), // duplicate value 'show_event_view_calendar'
            'cancel_error_url'                                 => __('Unsuccessful cancellation redirect URL', 'ameliabooking'),
            'cancel_error_url_tooltip'                         => __('URL on which will user be redirected if appointment can\'t be canceled because of \'Minimum time required before canceling\' value', 'ameliabooking'),
            'cancel_success_url'                               => __('Successful cancellation redirect URL', 'ameliabooking'),
            'comma_dot'                                        => __('Comma-dot', 'ameliabooking'),
            'company'                                          => __('Company', 'ameliabooking'), // Used in Redesign
            'country'                                          => __('Country', 'ameliabooking'),
            'coupons'                                          => __('Coupons', 'ameliabooking'), // Used in Redesign
            'facebook_pixel'                                   => __('Meta Pixel', 'ameliabooking'), // Used in Redesign
            'google_analytics'                                 => __('Google Analytics', 'ameliabooking'), // Used in Redesign | Updated
            'generate'                                         => __('Generate', 'ameliabooking'), // Used in Redesign
            'employee_selection_logic'                         => __('Employee selection logic', 'ameliabooking'),
            'employee_selection_logic_random'                  => __('Random', 'ameliabooking'),
            'currency'                                         => __('Currency', 'ameliabooking'),
            'customers_as_attendees'                           => __('Add event attendees', 'ameliabooking'), // Used in Redesign
            'customer_cabinet'                                 => __('Customer Panel Page URL', 'ameliabooking'),
            'employee_cabinet'                                 => __('Employee panel page URL', 'ameliabooking'),
            'default_appointment_status'                       => __('Default appointment status', 'ameliabooking'), // Used in Redesign
            'default_appointment_status_tooltip'               => __('All appointments will be scheduled with the status selected here.', 'ameliabooking'), // Used in Redesign | Updated
            'default_items_per_page'                           => __('Default number of items per page on the front end', 'ameliabooking'),
            'default_items_per_page_backend'                   => __('Default number of items per page on the back end', 'ameliabooking'),
            'default_page_on_backend'                          => __('Default back‑end page', 'ameliabooking'), // Used in Redesign | Updated
            'default_payment_method'                           => __('Default payment method', 'ameliabooking'),
            'default_phone_country_code'                       => __('Default phone country code', 'ameliabooking'), // Used in Redesign | Updated
            'default_time_slot_step'                           => __('Default time slot step', 'ameliabooking'),
            'default_time_slot_step_tooltip'                   => __('The time slot step defined here will apply to all time slots across the plugin.', 'ameliabooking'),  // Used in Redesign | Updated
            'dot_comma'                                        => __('Dot-comma', 'ameliabooking'),
            'see_unavailable_features'                         => __('Hide locked features', 'ameliabooking'),
            'envato_api_activate'                              => __('Activate with Envato', 'ameliabooking'),
            'event_title_and_description'                      => __('Event title and description', 'ameliabooking'), // Used in Redesign
            'mailchimp'                                        => __('Mailchimp', 'ameliabooking'),
            'meeting_title'                                    => __('Meeting title', 'ameliabooking'), // Used in Redesign
            'meeting_agenda'                                   => __('Meeting agenda', 'ameliabooking'), // Used in Redesign
            'facebook_app_id'                                  => __('Facebook app ID', 'ameliabooking'), // Used in Redesign
            'facebook_app_secret'                              => __('Facebook app secret', 'ameliabooking'), // Used in Redesign
            'general'                                          => __('General', 'ameliabooking'), // Used in Redesign
            'gMap_api_key'                                     => __('Google Map API key', 'ameliabooking'),
            'gMap_api_key_tooltip'                             => __('Add Google Map API Key to show Google static map on "Locations" page.', 'ameliabooking'),
            'google_client_id'                                 => __('Client ID', 'ameliabooking'), // Used in Redesign
            'google_client_secret'                             => __('Client secret', 'ameliabooking'), // Used in Redesign
            'outlook_client_id'                                => __('Application (client) ID', 'ameliabooking'), // Used in Redesign | Updated
            'outlook_client_secret'                            => __('Client secret', 'ameliabooking'), // Used in Redesign | Updated
            'google_redirect_uri'                              => __('Redirect URI', 'ameliabooking'), // Used in Redesign
            'outlook_redirect_uri'                             => __('Redirect URI', 'ameliabooking'), // Used in Redesign
            'apple_client_id'                                  => __('iCloud Email Address', 'ameliabooking'),
            'apple_redirect_uri'                               => __('Redirect URI', 'ameliabooking'), // Used in Redesign
            'zoom_account_id'                                  => __('Account ID', 'ameliabooking'), // Used in Redesign
            'zoom_client_id'                                   => __('Client ID', 'ameliabooking'),
            'zoom_client_secret'                               => __('Client secret', 'ameliabooking'),
            'lesson_space_api_key'                             => __('Lesson Space API key', 'ameliabooking'), // Used in Redesign
            'limit_app_per_customer'                           => __('Limit appointments per customer', 'ameliabooking'), // Used in Redesign | Updated
            'limit_package_per_customer'                       => __('Limit package purchases per customer', 'ameliabooking'), // Used in Redesign | Updated
            'limit_events_per_customer'                        => __('Limit events per customer', 'ameliabooking'),
            'limit_app_per_customer_tt'                        => __('This limit is based on the customer\'s email address.', 'ameliabooking'), // Used in Redesign | Updated
            'log_in'                                           => __('Log In', 'ameliabooking'),
            'log_out'                                          => __('Log out', 'ameliabooking'),
            'invoice_format'                                   => __('Invoice Format', 'ameliabooking'),
            'h1'                                               => __('1h', 'ameliabooking'),
            'h10'                                              => __('10h', 'ameliabooking'),
            'h11'                                              => __('11h', 'ameliabooking'),
            'h12'                                              => __('12h', 'ameliabooking'),
            'h1min30'                                          => __('1h 30min', 'ameliabooking'),
            'h2'                                               => __('2h', 'ameliabooking'),
            'h3'                                               => __('3h', 'ameliabooking'),
            'h4'                                               => __('4h', 'ameliabooking'),
            'h6'                                               => __('6h', 'ameliabooking'),
            'h8'                                               => __('8h', 'ameliabooking'),
            'h9'                                               => __('9h', 'ameliabooking'),
            'identify_country_code'                            => __('Identify country code by user\'s IP address', 'ameliabooking'),
            'insert_pending_appointments'                      => __('Insert pending appointments', 'ameliabooking'), // Used in Redesign
            'pending_appointments_meetings'                    => __('Create meetings for pending appointments', 'ameliabooking'), // Used in Redesign | Updated
            'inspect_customer_info'                            => __('Check customer\'s name for existing email/phone when booking', 'ameliabooking'),
            'inspect_customer_info_tooltip'                    => __('Enable this option to ensure that customers using an existing email or phone number maintain consistent first and last names.', 'ameliabooking'),
            'mail_service'                                     => __('Mail service', 'ameliabooking'),
            'mailgun'                                          => __('Mailgun', 'ameliabooking'),
            'manage_languages_tooltip'                         => __('Here you can define languages that you want to have in the plugin for translating dynamic strings (names, descriptions, notifications).', 'ameliabooking'),
            'min1'                                             => __('1min', 'ameliabooking'),
            'min10'                                            => __('10min', 'ameliabooking'),
            'min12'                                            => __('12min', 'ameliabooking'),
            'min15'                                            => __('15min', 'ameliabooking'),
            'min2'                                             => __('2min', 'ameliabooking'),
            'min20'                                            => __('20min', 'ameliabooking'),
            'min30'                                            => __('30min', 'ameliabooking'),
            'min45'                                            => __('45min', 'ameliabooking'),
            'min5'                                             => __('5min', 'ameliabooking'),
            'minimum_time_before_booking'                      => __('Minimum time required before booking', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_time_before_booking_tooltip'              => __('Define the time before the appointment during which customers can\'t book.', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_time_before_canceling'                    => __('Minimum time required before canceling', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_time_before_canceling_tooltip'            => __('Define the time before the appointment during which customers can\'t cancel.', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_time_before_rescheduling'                 => __('Minimum time required before rescheduling', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_time_before_rescheduling_tooltip'         => __('Define the time before the appointment during which customers can\'t reschedule.', 'ameliabooking'), // Used in Redesign | Updated
            'notify_customers_default'                         => __('Notify the customer(s) by default', 'ameliabooking'),
            'number_of_events_returned'                        => __('Maximum number of events returned', 'ameliabooking'),
            'or_enter_details_below'                           => __('Or enter details below', 'ameliabooking'),
            'outlook_mail_api'                                 => __('Outlook Mailer', 'ameliabooking'), // Used in Redesign
            'payment_links_enable'                             => __('Pay with payment link', 'ameliabooking'), // Used in Redesign | Updated
            'payment_links_enable_tooltip'                     => __('If enabled, customers can complete their payment using the link in their email notifications or through the customer panel.', 'ameliabooking'), // Used in Redesign | Updated
            'payments'                                         => __('Payments', 'ameliabooking'), // Used in Redesign
            'period_available_for_booking'                     => __('Period available for booking in advance', 'ameliabooking'), // Used in Redesign | Updated
            'period_available_for_booking_tooltip'             => __('Define how far into the future customers can book appointments.', 'ameliabooking'), // Used in Redesign | Updated
            'php_mail'                                         => __('PHP Mail', 'ameliabooking'),
            'price_number_of_decimals'                         => __('Price number of decimals', 'ameliabooking'),
            'price_separator'                                  => __('Price separator', 'ameliabooking'),
            'price_symbol_position'                            => __('Price symbol position', 'ameliabooking'),
            'purchase_code'                                    => __('Purchase code', 'ameliabooking'), // Used in Redesign | Updated
            'redirect_urls'                                    => __('Redirect URLs', 'ameliabooking'),
            'redirect_url_after_appointment'                   => __('Redirect URL after booking', 'ameliabooking'), // Used in Redesign
            'redirect_url_after_appointment_tooltip'           => __('Customers will be redirected to this URL after scheduling an appointment.', 'ameliabooking'), // Used in Redesign | Updated
            'remove_google_busy_slots'                         => __('Remove Google Calendar busy slots', 'ameliabooking'), // Used in Redesign
            'remove_outlook_busy_slots'                        => __('Remove Outlook Calendar busy slots', 'ameliabooking'), // Used in Redesign
            'remove_apple_busy_slots'                          => __('Remove Apple Calendar busy slots', 'ameliabooking'), // Used in Redesign
            'reject_appointment_success_url'                   => __('Redirect URL for successfully rejected booking', 'ameliabooking'),
            'reject_appointment_error_url'                     => __('Redirect URL for unsuccessfully rejected booking', 'ameliabooking'),
            'reply_to'                                         => __('Reply-to email', 'ameliabooking'),
            'require_cabinet_password'                         => __('Require password for login', 'ameliabooking'),
            'send_event_invitation_email'                      => __('Send event invitation email', 'ameliabooking'), // Used in Redesign
            'send_invoice_by_default'                          => __('Send invoice to customer by default', 'ameliabooking'),
            'send_invoice_by_default_description'              => __('Enable this option to make sure that the invoice will be sent to the customer after booking.', 'ameliabooking'),
            'send_ics_attachment_approved'                     => __('Send ICS file for approved bookings', 'ameliabooking'),
            'send_ics_attachment_pending'                      => __('Send ICS file for pending bookings', 'ameliabooking'),
            'send_ics_attachment_approved_tooltip'             => __('Enable this option if you want to send ics file in email after approved bookings.', 'ameliabooking'),
            'send_ics_attachment_pending_tooltip'              => __('Enable this option if you want to send ics file in email after pending bookings.', 'ameliabooking'),
            'send_sms_balance_low_email'                       => __('Remind me when my SMS balance is low', 'ameliabooking'),
            'send_sms_balance_low_email_tooltip'               => __('Enable this option to receive a reminder email when your SMS balance reaches set minimum', 'ameliabooking'),
            'send_sms_balance_low_minimum'                     => __('Credit minimum to send reminder', 'ameliabooking'),
            'send_sms_balance_low_to_email'                    => __('Send to e-mail', 'ameliabooking'),
            'sender_email'                                     => __('Sender email', 'ameliabooking'),
            'sender_email_warning'                             => __('Please enter a sender email.', 'ameliabooking'),
            'sender_name'                                      => __('Sender name', 'ameliabooking'),
            'sender_name_warning'                              => __('Please enter a sender name.', 'ameliabooking'),
            'service_duration_as_slot'                         => __('Use service duration for booking a time slot', 'ameliabooking'),
            'service_duration_as_slot_tooltip'                 => __('Enable this option if you want to make time slot step the same as service duration in the booking process', 'ameliabooking'),
            'set_ics_description'                              => __('Set ICS file description', 'ameliabooking'),
            'set_metaData_and_description'                     => __('Set metadata and description', 'ameliabooking'),
            'settings'                                         => __('Settings', 'ameliabooking'), // Used in Redesign | Updated
            'show_attendees'                                   => __('Allow customers to see other attendees', 'ameliabooking'), // Used in Redesign | Updated
            'show_client_time_zone'                            => __('Show booking slots in client\'s time zone', 'ameliabooking'), // Used in Redesign | Updated
            'show_client_time_zone_tooltip'                    => __('Enable to display booking slots based on the client\'s time zone.', 'ameliabooking'), // Used in Redesign | Updated
            'smtp'                                             => __('SMTP', 'ameliabooking'), // Used in Redesign
            'space_comma'                                      => __('Space-comma', 'ameliabooking'),
            'space_dot'                                        => __('Space-dot', 'ameliabooking'),
            'stash_entities'                                   => __('Preload entities when page loads', 'ameliabooking'),
            'stash_entities_tooltip'                           => __('When enabled, all entities (services, employees, locations, packages, and tags) load as soon as the page opens, instead of being loaded dynamically via AJAX.', 'ameliabooking'), // Used in Redesign | Updated
            'square'                                           => __('Square', 'ameliabooking'), // Used in Redesign
            'square_disconnected'                              => __('Square account successfully disconnected', 'ameliabooking'),
            'square_currency_error'                            => __('The currency in Amelia does not match the currency of your chosen Square location', 'ameliabooking'),
            'square_default_location'                          => __('Default Square location', 'ameliabooking'),
            'square_login_error'                               => __('Please log in to Square', 'ameliabooking'),
            'square_location_error'                            => __('Select your Square Location', 'ameliabooking'),
            'square_location_info'                             => __('Locations must be active and have card processing enabled', 'ameliabooking'),
            'update_for_all'                                   => __('Update for All', 'ameliabooking'), // Used in Redesign | Updated
            'custom_fields_backend_validation'                 => __('Validate required custom fields in the backend', 'ameliabooking'), // Used in Redesign | Updated
            'custom_fields_upload_path'                        => __('Attachment upload path', 'ameliabooking'), // Used in Redesign | Updated
            'custom_fields_upload_path_tooltip'                => __('If left empty, attachments will be uploaded to the default WordPress uploads folder.', 'ameliabooking'),
            'vat_number'                                       => __('VAT number', 'ameliabooking'),
            'website'                                          => __('Website', 'ameliabooking'),
            'wp_mail'                                          => __('WP Mail', 'ameliabooking'),
            'custom_currency_symbol'                           => __('Custom currency symbol', 'ameliabooking'),
            'your_api_key'                                     => __('Your API key', 'ameliabooking'), // Used in Redesign | Updated
            'admin_time_slot_service_duration'                 => __('Booking time slots will depend on the service duration', 'ameliabooking'),
            'admin_time_slot_service_duration_tt'              => __('When this option is deactivated, the booking will be<br/>determined based on the Default Time Slot Step', 'ameliabooking'),
            'cart'                                             => __('Cart', 'ameliabooking'), // Used in Redesign
            'wc_name'                                          => __('WooCommerce', 'ameliabooking'), // Used in Redesign
            'payPal'                                           => __('PayPal', 'ameliabooking'), // Used in Redesign
            'stripe'                                           => __('Stripe', 'ameliabooking'), // Used in Redesign
            'razorpay'                                         => __('Razorpay', 'ameliabooking'), // Used in Redesign
            'barion'                                           => __('Barion', 'ameliabooking'),
            'amelia_sms'                                       => __('Amelia SMS', 'ameliabooking'), // Used in Redesign
            'balance_colon'                                    => __('Balance', 'ameliabooking'),
            'balance_recharged'                                => __('Your balance has been recharged.', 'ameliabooking'), // Used in Redesign | Updated
            'carrier'                                          => __('Carrier:', 'ameliabooking'),
            'change_password'                                  => __('Change password', 'ameliabooking'),
            'cost_colon'                                       => __('Cost:', 'ameliabooking'),
            'current_password_colon'                           => __('Current password', 'ameliabooking'),
            'current_password_required'                        => __('Please enter current password', 'ameliabooking'),
            'customer_appointment_approved'                    => __('Approved', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_canceled'                    => __('Canceled', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_follow_up'                   => __('Follow up', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_next_day_reminder'           => __('Next day reminder', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_pending'                     => __('Pending', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_rejected'                    => __('Rejected', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_rescheduled'                 => __('Rescheduled', 'ameliabooking'), // Used in Redesign | Updated
            'customer_account_recovery'                        => __('Panel access', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_updated'                     => __('Details changed', 'ameliabooking'), // Used in Redesign | Updated
            'customer_birthday_greeting'                       => __('Birthday greeting', 'ameliabooking'), // Used in Redesign
            'customer_event_approved'                          => __('Booked', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_canceled'                          => __('Canceled by attendee', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_follow_up'                         => __('Follow up', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_next_day_reminder'                 => __('Next day reminder', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_rejected'                          => __('Canceled by admin', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_rescheduled'                       => __('Rescheduled', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_updated'                           => __('Details changed', 'ameliabooking'), // Used in Redesign | Updated
            'customer_event_qr_code'                           => __('Event e-ticket', 'ameliabooking'),
            'customer_other_notifications'                     => __('Other', 'ameliabooking'), // Used in Redesign
            'customer_event_waiting'                           => __('Waiting list confirmation', 'ameliabooking'), // Used in Redesign | Updated
            'customer_appointment_waiting'                     => __('Waiting list confirmation', 'ameliabooking'),
            'customer_appointment_waiting_available_spot'      => __('Waiting list availability', 'ameliabooking'),
            'customer_cart'                                    => __('Cart purchased', 'ameliabooking'), // Used in Redesign | Updated
            'customer_invoice'                                 => __('Booking invoice', 'ameliabooking'),
            'customer_package_canceled'                        => __('Package canceled', 'ameliabooking'),
            'customer_package_purchased'                       => __('Package purchased', 'ameliabooking'),
            'date_colon'                                       => __('Date:', 'ameliabooking'),
            'dont_have_an_account'                             => __('Don\'t have an account?', 'ameliabooking'),
            'dont_import'                                      => __('Don\'t Import', 'ameliabooking'), // Used in Redesign | Updated
            'enter_password_warning'                           => __('Please enter a password.', 'ameliabooking'), // Used in Redesign | Updated
            'enter_recipient_phone_warning'                    => __('Please enter a recipient phone.', 'ameliabooking'), // Used in Redesign | Updated
            'forgot_password'                                  => __('Forgot password?', 'ameliabooking'), // Used in Redesign
            'incorrect_email'                                  => __('You have entered an incorrect email.', 'ameliabooking'), // Used in Redesign
            'incorrect_password'                               => __('You have entered an incorrect password.', 'ameliabooking'), // Used in Redesign
            'logout'                                           => __('Logout', 'ameliabooking'),
            'new_password_colon'                               => __('New password', 'ameliabooking'),
            'new_password_required'                            => __('Please enter a new password.', 'ameliabooking'), // Used in Redesign
            'notification_saved'                               => __('Notification has been saved.', 'ameliabooking'), // Used in Redesign | Updated
            'notification_template'                            => __('Notification template', 'ameliabooking'), // Used in Redesign
            'payment_history'                                  => __('Payment history', 'ameliabooking'),
            'ph_appointment_date'                              => __('Appointment date', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_date_time'                         => __('Appointment date & time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_duration'                          => __('Appointment duration', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_end_time'                          => __('Appointment end time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_id'                                => __('Appointment ID', 'ameliabooking'), // Used in Redesign | Updated
            'ph_payment_due_amount'                            => __('Payment due amount', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_notes'                             => __('Appointment notes', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_price'                             => __('Appointment price', 'ameliabooking'), // Used in Redesign | Updated
            'ph_payment_type'                                  => __('Payment type', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_status'                            => __('Appointment status', 'ameliabooking'), // Used in Redesign | Updated
            'ph_appointment_start_time'                        => __('Appointment start time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_attendee_code'                                 => __('Attendee code', 'ameliabooking'), // Used in Redesign | Updated
            'ph_booked_customer'                               => __('Booked customer (full name, email, phone)', 'ameliabooking'), // Used in Redesign | Updated
            'ph_booking_number_of_persons'                     => __('Number of people', 'ameliabooking'), // Used in Redesign | Updated
            'ph_category_id'                                   => __('Category ID', 'ameliabooking'), // Used in Redesign
            'ph_category_name'                                 => __('Category name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_address'                               => __('Company address', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_name'                                  => __('Company name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_phone'                                 => __('Company phone', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_website'                               => __('Company website', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_email'                                 => __('Company email', 'ameliabooking'), // Used in Redesign | Updated
            'ph_company_vat_number'                            => __('Company VAT number', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_email'                                => __('Customer email', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_first_name'                           => __('Customer first name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_full_name'                            => __('Customer full name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_last_name'                            => __('Customer last name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_note'                                 => __('Customer note', 'ameliabooking'), // Used in Redesign | Updated
            'ph_customer_phone'                                => __('Customer phone', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_description'                          => __('Employee description', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_id'                                   => __('Employee ID', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_email'                                => __('Employee email', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_first_name'                           => __('Employee first name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_full_name'                            => __('Employee full name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_last_name'                            => __('Employee last name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_name_email_phone'                     => __('Employee name, email & phone', 'ameliabooking'),
            'ph_employee_note'                                 => __('Employee note', 'ameliabooking'), // Used in Redesign | Updated
            'ph_employee_phone'                                => __('Employee phone', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_description'                             => __('Event description', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_location'                                => __('Event location', 'ameliabooking'), // Used in Redesign
            'ph_event_end_date'                                => __('Event end date', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_end_date_time'                           => __('Event end date & time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_end_time'                                => __('Event end time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_id'                                      => __('Event ID', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_name'                                    => __('Event name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_period_date'                             => __('Event date period', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_period_date_time'                        => __('Event date & time period', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_price'                                   => __('Event price', 'ameliabooking'), // Used in Redesign | Updated
            'ph_booking_price'                                 => __('Booking price', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_start_date'                              => __('Event start date', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_start_date_time'                         => __('Event start date & time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_event_start_time'                              => __('Event start time', 'ameliabooking'), // Used in Redesign | Updated
            'ph_group_event_details'                           => __('Group event details', 'ameliabooking'), // Used in Redesign | Updated
            'ph_service_description'                           => __('Service description', 'ameliabooking'), // Used in Redesign | Updated
            'ph_service_duration'                              => __('Service duration', 'ameliabooking'), // Used in Redesign | Updated
            'ph_service_id'                                    => __('Service ID', 'ameliabooking'), // Used in Redesign
            'ph_service_name'                                  => __('Service name', 'ameliabooking'), // Used in Redesign | Updated
            'ph_service_price'                                 => __('Service price', 'ameliabooking'), // Used in Redesign | Updated
            'ph_time_zone'                                     => __('Time zone', 'ameliabooking'), // Used in Redesign | Updated
            'provider_cart'                                    => __('Cart purchased', 'ameliabooking'), // Used in Redesign | Updated
            'companyPlaceholders'                              => __('Company', 'ameliabooking'),
            'customerPlaceholders'                             => __('Customer', 'ameliabooking'),
            'paymentPlaceholders'                              => __('Payment', 'ameliabooking'),
            'employeePlaceholders'                             => __('Employee', 'ameliabooking'),
            'categoryPlaceholders'                             => __('Category', 'ameliabooking'),
            'locationPlaceholders'                             => __('Location', 'ameliabooking'),
            'appointmentPlaceholders'                          => __('Appointment', 'ameliabooking'),
            'eventPlaceholders'                                => __('Event', 'ameliabooking'),
            'extrasPlaceholders'                               => __('Extra', 'ameliabooking'),
            'price'                                            => __('Price', 'ameliabooking'), // Used in Redesign
            'pricing'                                          => __('Pricing', 'ameliabooking'), // Used in Redesign
            'provider_appointment_approved'                    => __('Approved', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_canceled'                    => __('Canceled', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_next_day_reminder'           => __('Next day reminder', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_updated'                     => __('Details changed', 'ameliabooking'), // Used in Redesign | Updated
            'provider_package_canceled'                        => __('Package canceled', 'ameliabooking'), // Used in Redesign
            'provider_package_purchased'                       => __('Package purchased', 'ameliabooking'), // Used in Redesign
            'provider_panel_access'                            => __('Panel access', 'ameliabooking'), // Used in Redesign | Updated
            'provider_panel_recovery'                          => __('Panel recovery', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_pending'                     => __('Pending', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_rejected'                    => __('Rejected', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_rescheduled'                 => __('Rescheduled', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_approved'                          => __('Booked', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_canceled'                          => __('Canceled by attendee', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_next_day_reminder'                 => __('Next day reminder', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_rejected'                          => __('Canceled by admin', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_rescheduled'                       => __('Rescheduled', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_updated'                           => __('Details changed', 'ameliabooking'), // Used in Redesign | Updated
            'provider_event_waiting'                           => __('Waiting list confirmation', 'ameliabooking'), // Used in Redesign | Updated
            'provider_appointment_waiting'                     => __('Waiting list confirmation', 'ameliabooking'),
            'provider_appointment_waiting_available_spot'      => __('Waiting list availability', 'ameliabooking'),
            'queued'                                           => __('Queued', 'ameliabooking'),
            're_type_required'                                 => __('Please enter a new password again.', 'ameliabooking'), // Used in Redesign | Updated
            'recharge'                                         => __('Recharge', 'ameliabooking'),
            'recharge_balance'                                 => __('Recharge balance', 'ameliabooking'), // Used in Redesign
            'recipient_email'                                  => __('Recipient email', 'ameliabooking'), // Used in Redesign | Updated
            'requires_scheduling_setup'                        => __('Schedule setup required', 'ameliabooking'), // Used in Redesign | Updated
            'segments_colon'                                   => __('Segments', 'ameliabooking'),
            'send'                                             => __('Send', 'ameliabooking'),
            'send_test_email'                                  => __('Test email', 'ameliabooking'), // Used in Redesign | Updated
            'send_test_sms'                                    => __('Test SMS', 'ameliabooking'), // Used in Redesign | Updated
            'sender_id_colon'                                  => __('Alpha sender ID', 'ameliabooking'),
            'sign_in'                                          => __('Sign in', 'ameliabooking'),
            'sign_up'                                          => __('Sign up', 'ameliabooking'),
            'sms_history'                                      => __('SMS history', 'ameliabooking'), // Used in Redesign
            'sms_vat_apply'                                    => __('If you are in a country where VAT or GST applies, the applicable tax will be added to your transaction.', 'ameliabooking'), // Used in Redesign | Updated
            'subject'                                          => __('Subject', 'ameliabooking'), // Used in Redesign
            'test_email_error'                                 => __('Failed to send test email.', 'ameliabooking'), // Used in Redesign | Updated
            'test_email_success'                               => __('Test email sent successfully.', 'ameliabooking'), // Used in Redesign | Updated
            'test_email_warning'                               => __('To send a test email, please configure the \'Sender Email\' in Notification Settings.', 'ameliabooking'), // Used in Redesign | Updated
            'test_sms_warning'                                 => __('To send a test SMS, please recharge your balance.', 'ameliabooking'), // Used in Redesign | Updated
            'text_colon'                                       => __('Text:', 'ameliabooking'),
            'time_colon'                                       => __('Time:', 'ameliabooking'),
            'type_colon'                                       => __('Type:', 'ameliabooking'), // Used in Redesign
            'to_customer'                                      => __('To customer', 'ameliabooking'), // Used in Redesign
            'to_employee'                                      => __('To employee', 'ameliabooking'), // Used in Redesign
            'user_colon'                                       => __('User', 'ameliabooking'),
            'user_profile'                                     => __('User profile', 'ameliabooking'),
            'view_pricing_for'                                 => __('View pricing for', 'ameliabooking'),
            'whatsapp_access_token'                            => __('Permanent access token', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_auto_reply_enable'                       => __('Enable auto-reply message', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_auto_reply_notice'                       => __('Messages sent through WhatsApp are without a reply option, so we advise setting the “Auto-reply” message', 'ameliabooking'),
            'whatsapp_auto_reply_token'                        => __('WhatsApp webhook verify token', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_auto_reply_msg'                          => __('WhatsApp auto-reply message', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_business_id'                             => __('WhatsApp business account ID', 'ameliabooking'), // Used in Redesign
            'whatsapp_default_language'                        => __('Default language', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_phone_id'                                => __('Phone number ID', 'ameliabooking'), // Used in Redesign | Updated
            'whatsapp_webhook_url_callback'                    => __('WhatsApp webhook callback URL', 'ameliabooking'), // Used in Redesign
            'configure'                                        => __('Configure', 'ameliabooking'), // Used in Redesign
            'ph_location_id'                                   => __('Location ID', 'ameliabooking'), // Used in Redesign
            'ph_location_latitude'                             => __('Location latitude', 'ameliabooking'), // Used in Redesign
            'ph_location_longitude'                            => __('Location longitude', 'ameliabooking'), // Used in Redesign
            'password'                                         => __('Password', 'ameliabooking'),
            'segment_colon'                                    => __('Segment:', 'ameliabooking'),
            'already_have_an_account'                          => __('Already have an account?', 'ameliabooking'),
            'email_taken'                                      => __('This email is already in use. Please enter a different email address.', 'ameliabooking'), // Used in Redesign | Updated
            'appointments_count'                               => __('# of appointments', 'ameliabooking'), // Used in Redesign
            'bookings_revenue'                                 => __('Sum of payments', 'ameliabooking'), // Used in Redesign
            'appointments_hours'                               => __('# of Hours in appointment', 'ameliabooking'), // Used in Redesign
            'dashboard'                                        => __('Dashboard', 'ameliabooking'),
            'new'                                              => __('New', 'ameliabooking'), // Used in Redesign
            'pending_appointments'                             => __('Pending appointments', 'ameliabooking'), // Used in Redesign
            'percentage_of_load'                               => __('Percentage of Load', 'ameliabooking'), // Used in Redesign
            'returning'                                        => __('Returning', 'ameliabooking'), // Used in Redesign
            'revenue'                                          => __('Revenue', 'ameliabooking'), // Used in Redesign
            'time'                                             => __('Time', 'ameliabooking'), // Used in Redesign
            'upcoming_appointments'                            => __('Upcoming appointments', 'ameliabooking'), // Used in Redesign | Updated
            'add_day_off'                                      => __('Add day off', 'ameliabooking'), // Used in Redesign
            'add_special_day'                                  => __('Add special day', 'ameliabooking'), // Used in Redesign
            'apply_to_all_days'                                => __('Apply to all days', 'ameliabooking'), // Used in Redesign
            'day_off_name'                                     => __('Day off name', 'ameliabooking'), // Used in Redesign | Updated
            'days_off_repeat_yearly'                           => __('Repeat yearly', 'ameliabooking'), // Used in Redesign
            'days_off'                                         => __('Days off', 'ameliabooking'), // Used in Redesign
            'work_hours'                                       => __('Work hours', 'ameliabooking'), // Used in Redesign
            'visibility_hide'                                  => __('Hide', 'ameliabooking'), // Used in Redesign
            'visibility_show'                                  => __('Show', 'ameliabooking'), // Used in Redesign
            'block'                                            => __('Block', 'ameliabooking'), // Used in Redesign
            'unblock'                                          => __('Unblock', 'ameliabooking'), // Used in Redesign
            'visible'                                          => __('Visible', 'ameliabooking'), // Used in Redesign
            'locations_search_placeholder'                     => __('Search locations', 'ameliabooking'), // Used in Redesign | Updated
            'google_maps_notice'                               => __('To enable Google Maps, enter your Google Maps API key in the Google General Settings.', 'ameliabooking'), // Used in Redesign | Updated
            'add_category'                                     => __('Add category', 'ameliabooking'), // Used in Redesign
            'add_extra'                                        => __('Add Extra', 'ameliabooking'), // Used in Redesign
            'categories'                                       => __('Categories', 'ameliabooking'),
            'categories_positions_saved'                       => __('Categories positions updated successfully.', 'ameliabooking'),
            'category_deleted'                                 => __('Category has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'confirm_delete_service'                           => __('Are you sure you want to delete this service?', 'ameliabooking'), // Used in Redesign
            'confirm_duplicate_service'                        => __('Are you sure you want to duplicate this service?', 'ameliabooking'), // Used in Redesign
            'confirm_global_change_service'                    => __('You\'re changing settings that have been individually configured for employees. Do you want to apply these changes to all employees?', 'ameliabooking'),
            'confirm_hide_service'                             => __('Are you sure you want to hide this service?', 'ameliabooking'),
            'confirm_show_service'                             => __('Are you sure you want to show this service?', 'ameliabooking'), // Used in Redesign
            'delete_category_confirmation'                     => __('Are you sure you want to delete this category?', 'ameliabooking'), // Used in Redesign | Updated
            'duplicate_category_confirmation'                  => __('Are you sure you want to duplicate this category?', 'ameliabooking'), // Used in Redesign
            'duration_and_pricing'                             => __('Pricing & duration ', 'ameliabooking'), // Used in Redesign | Updated
            'edit_service'                                     => __('Edit service', 'ameliabooking'), // Used in Redesign
            'edit_category'                                    => __('Edit Category', 'ameliabooking'), // Used in Redesign
            'gallery'                                          => __('Gallery', 'ameliabooking'), // Used in Redesign
            'maximum_capacity_tooltip'                         => __('Set the maximum number of people allowed per appointment for this service.', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_capacity'                                 => __('Minimum capacity', 'ameliabooking'), // Used in Redesign | Updated
            'minimum_capacity_tooltip'                         => __('Set the minimum number of people required per appointment for this service.', 'ameliabooking'),
            'new_category'                                     => __('New category', 'ameliabooking'), // Used in Redesign
            'new_service'                                      => __('New service', 'ameliabooking'), // Used in Redesign
            'select_service_duration_warning'                  => __('Please select a duration.', 'ameliabooking'), // Used in Redesign | Updated
            'select_service_category_warning'                  => __('Please select a category.', 'ameliabooking'), // Used in Redesign | Updated
            'service_buffer_time_after'                        => __('Buffer time after', 'ameliabooking'), // Used in Redesign
            'service_buffer_time_after_tooltip'                => __('Time needed after the appointment for rest, cleanup, or transition. During this period, the employee cannot be booked for any service.', 'ameliabooking'), // Used in Redesign | Updated
            'service_buffer_time_before'                       => __('Buffer time before', 'ameliabooking'), // Used in Redesign
            'service_buffer_time_before_tooltip'               => __('Time needed before the appointment for preparation. During this period, the employee cannot be booked for any service.', 'ameliabooking'), // Used in Redesign | Updated
            'service_deleted'                                  => __('Service has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'service_hidden'                                   => __('Service has been hidden.', 'ameliabooking'), // Used in Redesign | Updated
            'service_visible'                                  => __('Service is now visible.', 'ameliabooking'), // Used in Redesign | Updated
            'services_sorting_price_asc'                       => __('Price Asc', 'ameliabooking'), // Used in Redesign | Updated
            'services_sorting_price_desc'                      => __('Price Desc', 'ameliabooking'), // Used in Redesign | Updated
            'service_show_on_site'                             => __('Show on website', 'ameliabooking'), // Used in Redesign | Updated
            'service_show_on_site_tooltip'                     => __('If this option is disabled, the service will be bookable only from the back end.', 'ameliabooking'), // Used in Redesign | Updated
            'service_recurring_cycle'                          => __('Recurring appointments', 'ameliabooking'), // Used in Redesign | Updated
            'service_recurring_cycle_tooltip'                  => __("Choose how recurring appointments can be booked. 'Disabled' turns recurring booking off, while 'All' allows customers to choose between available recurrence options.", 'ameliabooking'), // Used in Redesign | Updated
            'notify_customer'                                  => __('Notify the customer(s)', 'ameliabooking'), // Used in Redesign | Updated
            'service_details'                                  => __('Service details', 'ameliabooking'), // Used in Redesign
            'create_new'                                       => __('Create new', 'ameliabooking'), // Used in Redesign
            'email'                                            => __('Email', 'ameliabooking'), // Used in Redesign - duplicate value 'email_colon'
            'enter_first_name_warning'                         => __('Please enter a first name.', 'ameliabooking'), // Used in Redesign | Updated
            'enter_last_name_warning'                          => __('Please enter a last name', 'ameliabooking'), // Used in Redesign | Updated
            'first_name'                                       => __('First name', 'ameliabooking'), // Used in Redesign
            'last_name'                                        => __('Last name', 'ameliabooking'), // Used in Redesign
            'female'                                           => __('Female', 'ameliabooking'), // Used in Redesign
            'male'                                             => __('Male', 'ameliabooking'), // Used in Redesign
            'notification_language'                            => __('Notification language', 'ameliabooking'), // Used in Redesign
            'wp_user'                                          => __('WordPress user', 'ameliabooking'), // Used in Redesign
            'wp_user_customer_tooltip'                         => __('Link this customer to a WordPress user so they can log in and view their appointments in Amelia’s back end.', 'ameliabooking'), // Used in Redesign | Updated
            'wp_user_employee_tooltip'                         => __('Map a WordPress user to this employee to give them access to view their appointments in the plugin’s back-end.', 'ameliabooking'), // Used in Redesign | Updated
            'wp_customer_lang_tooltip'                         => __('Defines the language used for notifications sent to this customer for bookings created from the admin or employee panel. If a supported language was used in a previous booking, it will be automatically selected; otherwise, you can set it manually.', 'ameliabooking'), // Used in Redesign | Updated
            'edit_employee'                                    => __('Edit employee', 'ameliabooking'), // Used in Redesign
            'employee_show_on_site'                            => __('Show on website', 'ameliabooking'),
            'employee_show_on_site_tooltip'                    => __('If this option is disabled, the employee will only be available for booking through the back-end', 'ameliabooking'),
            'employee_panel_password'                          => __('Employee panel password', 'ameliabooking'), // Used in Redesign
            'special_days'                                     => __('Special days', 'ameliabooking'), // Used in Redesign
            'timezone'                                         => __('Time zone', 'ameliabooking'), // Used in Redesign | Updated
            'away'                                             => __('Away', 'ameliabooking'), // Used in Redesign
            'new_employee'                                     => __('New employee', 'ameliabooking'), // Used in Redesign
            'confirm_hide_employee'                            => __('Are you sure you want to hide this employee?', 'ameliabooking'),
            'confirm_show_employee'                            => __('Are you sure you want to show this employee?', 'ameliabooking'), // Used in Redesign
            'employee_visible'                                 => __('Employee is now visible.', 'ameliabooking'), // Used in Redesign | Updated
            'employee_hidden'                                  => __('Employee has been hidden.', 'ameliabooking'), // Used in Redesign | Updated
            'confirm_delete_employee'                          => __('Are you sure you want to delete this employee?', 'ameliabooking'), // Used in Redesign
            'confirm_delete_customer'                          => __('Are you sure you want to delete this customer?', 'ameliabooking'), // Used in Redesign
            'confirm_block_customer'                           => __('Are you sure you want to block this customer?', 'ameliabooking'), // Used in Redesign
            'confirm_unblock_customer'                         => __('Are you sure you want to unblock this customer?', 'ameliabooking'), // Used in Redesign
            'customer_deleted'                                 => __('Customer has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'customer_blocked'                                 => __('Customer has been blocked.', 'ameliabooking'), // Used in Redesign | Updated
            'customer_phone'                                   => __('Customer phone', 'ameliabooking'), // Used in Redesign
            'customer_unblocked'                               => __('Customer has been unblocked.', 'ameliabooking'), // Used in Redesign | Updated
            'customer_note'                                    => __('Note', 'ameliabooking'),
            'customers'                                        => __('Customers', 'ameliabooking'),
            'customers_search_placeholder'                     => __('Search customers', 'ameliabooking'), // Used in Redesign | Updated
            'date_of_birth'                                    => __('Date of birth', 'ameliabooking'), // Used in Redesign
            'edit_customer'                                    => __('Edit customer', 'ameliabooking'), // Used in Redesign
            'gender'                                           => __('Gender', 'ameliabooking'), // Used in Redesign
            'imported_customers'                               => __('Customers imported from file:', 'ameliabooking'), // Used in Redesign | Updated
            'last_booking'                                     => __('Last booking', 'ameliabooking'), // Used in Redesign
            'new_customer'                                     => __('New customer', 'ameliabooking'), // Used in Redesign
            'required_data'                                    => __('Required fields: <b>First Name</b> and <b>Last Name</b>.', 'ameliabooking'), // Used in Redesign | Updated
            'total_appointments'                               => __('Total appointments', 'ameliabooking'), // Used in Redesign
            'total_bookings'                                   => __('Total bookings', 'ameliabooking'), // Used in Redesign
            'total_events'                                     => __('Total events', 'ameliabooking'), // Used in Redesign
            'view_appointments'                                => __('View appointments', 'ameliabooking'), // Used in Redesign
            'view_events'                                      => __('View events', 'ameliabooking'), // Used in Redesign
            'drag_drop'                                        => __('Drop files here or click to upload', 'ameliabooking'), // Used in Redesign | Updated
            'import_rules'                                     => __('Import Rules', 'ameliabooking'), // Used in Redesign | Updated
            'import_successful'                                => __('Import successful', 'ameliabooking'), // Used in Redesign | Updated
            'map_data'                                         => __('Please map corresponding data to columns:', 'ameliabooking'), // Used in Redesign | Updated
            'wrong_format'                                     => __('Some records have an incorrect format.', 'ameliabooking'), // Used in Redesign | Updated
            'amount'                                           => __('Amount', 'ameliabooking'), // Used in Redesign
            'booking_start'                                    => __('Booking start', 'ameliabooking'), // Used in Redesign
            'customer_email'                                   => __('Customer email', 'ameliabooking'), // Used in Redesign
            'employee_email'                                   => __('Employee email', 'ameliabooking'), // Used in Redesign
            'method'                                           => __('Method', 'ameliabooking'),  // Used in Redesign
            'payment_date'                                     => __('Payment date', 'ameliabooking'), // Used in Redesign | Updated
            'payment_created'                                  => __('Payment created', 'ameliabooking'), // Used in Redesign | Updated
            'rate'                                             => __('Rate', 'ameliabooking'), // Used in Redesign
            'invoice_qty'                                      => __('Qty', 'ameliabooking'),
            'invoice_total_item_price'                         => __('Total price', 'ameliabooking'),
            'invoices'                                         => __('Invoices', 'ameliabooking'), // Used in Redesign
            'discount_amount'                                  => __('Discount', 'ameliabooking'), // Used in Redesign
            'due'                                              => __('Due', 'ameliabooking'), // Used in Redesign
            'finance'                                          => __('Finance', 'ameliabooking'), // Used in Redesign
            'payment_details'                                  => __('Payment details', 'ameliabooking'), // Used in Redesign
            'service_price'                                    => __('Service price', 'ameliabooking'), // Used in Redesign
            'subtotal'                                         => __('Subtotal', 'ameliabooking'), // Used in Redesign
            'total_price'                                      => __('Total price', 'ameliabooking'), // Used in Redesign
            'event_price'                                      => __('Event price', 'ameliabooking'), // Used in Redesign
            'appointment_deleted'                              => __('Appointment has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'appointment_rescheduled'                          => __('Appointment has been rescheduled', 'ameliabooking'),
            'appointment_status_changed'                       => __('Appointment status has been changed to ', 'ameliabooking'),
            'category'                                         => __('Category', 'ameliabooking'), // Used in Redesign
            'confirm_delete_appointment'                       => __('Are you sure? This action can\'t be undone.', 'ameliabooking'), // Used in Redesign | Updated
            'confirm_duplicate_appointment'                    => __('Are you sure you want to duplicate this appointment?', 'ameliabooking'), // Used in Redesign
            'custom_fields'                                    => __('Custom fields', 'ameliabooking'), // Used in Redesign - title case
            'edit_appointment'                                 => __('Edit appointment', 'ameliabooking'), // Used in Redesign
            'end_time'                                         => __('End time', 'ameliabooking'), // Used in Redesign
            'new_appointment'                                  => __('New appointment', 'ameliabooking'), // Used in Redesign
            'notify_attendees'                                 => __('Notify the attendees', 'ameliabooking'), // Used in Redesign | Updated
            'notify_attendees_tooltip'                         => __('Notify attendees by email when event information is updated.', 'ameliabooking'),  // Used in Redesign | Updated
            'over_booking_message'                             => __('By continuing, you will set the appointment to a time slot that already has an existing appointment!', 'ameliabooking'),
            'select_service_warning'                           => __('Please select a service.', 'ameliabooking'), // Used in Redesign | Updated
            'start_time'                                       => __('Start time', 'ameliabooking'), // Used in Redesign
            'booking_reschedule_exception'                     => __('Appointment can\'t be rescheduled', 'ameliabooking'),
            'booking_status_changed'                           => __('Booking status has been changed to ', 'ameliabooking'),
            'wc'                                               => __('WooCommerce', 'ameliabooking'),
            'select_a_customer_warning'                        => __('Please select a customer.', 'ameliabooking'), // Used in Redesign | Updated
            'select_employee_warning'                          => __('Please select an employee.', 'ameliabooking'), // Used in Redesign | Updated
            'deposit_enabled'                                  => __('Deposit payment', 'ameliabooking'), // Used in Redesign
            'custom_pricing'                                   => __('Custom pricing', 'ameliabooking'), // Used in Redesign
            'custom_duration_pricing_enabled'                  => __('Pricing by duration', 'ameliabooking'), // Used in Redesign | Updated
            'custom_person_pricing_enabled'                    => __('Pricing by number of people', 'ameliabooking'), // Used in Redesign | Updated
            'custom_period_pricing_enabled'                    => __('Pricing by date & time', 'ameliabooking'), // Used in Redesign | Updated
            'recurring_appointments'                           => __('Recurring appointments', 'ameliabooking'),
            'confirm_duplicate_event'                          => __('Are you sure you want to duplicate this event?', 'ameliabooking'),
            'confirm_cancel'                                   => __('Are you sure you want to cancel this event?', 'ameliabooking'), // Used in Redesign
            'confirm_open'                                     => __('Are you sure you want to open this event?', 'ameliabooking'), // Used in Redesign
            'event_cancel_before_delete'                       => __('Please cancel the event first before deleting it.', 'ameliabooking'),
            'customize'                                        => __('Customize', 'ameliabooking'),
            'full'                                             => __('Full', 'ameliabooking'),
            'upcoming'                                         => __('Upcoming', 'ameliabooking'),
            'edit_event'                                       => __('Edit event', 'ameliabooking'),
            'event_book_persons'                               => __('Number of people', 'ameliabooking'),
            'event_book_status'                                => __('Status', 'ameliabooking'),
            'event_book_tickets'                               => __('Number of Tickets', 'ameliabooking'), // Used in Redesign | Updated
            'event_aggregated_price'                           => __('Multiply price by number of people', 'ameliabooking'), // Used in Redesign | Updated
            'event_book_more_than_once'                        => __('Allow multiple bookings per customer', 'ameliabooking'), // Used in Redesign | Updated
            'event_bringing_anyone'                            => __('Allow additional people', 'ameliabooking'), // Used in Redesign | Updated
            'event_cancel'                                     => __('Cancel Event', 'ameliabooking'), // Used in Redesign
            'event_close_after_min'                            => __('Close event when minimum capacity is reached', 'ameliabooking'), // Used in Redesign | Updated
            'event_close_min_total'                            => __('Minimum number of attendees', 'ameliabooking'), // Used in Redesign | Updated
            'event_close_min_bookings'                         => __('Minimum number of bookings', 'ameliabooking'), // Used in Redesign | Updated
            'event_close_min_total_tt'                         => __('Each spot counts as one attendee.', 'ameliabooking'), // Used in Redesign | Updated
            'event_close_min_bookings_tt'                      => __('A single booking may include multiple attendees (spots).', 'ameliabooking'), // Used in Redesign | Updated
            'event_close_minimum'                              => __('Set minimum', 'ameliabooking'), // Used in Redesign
            'event_custom_address'                             => __('Custom address', 'ameliabooking'), // Used in Redesign
            'event_delete'                                     => __('Delete Event', 'ameliabooking'), // Used in Redesign
            'event_deleted'                                    => __('Event has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'event_booking_closes_on'                          => __('Closes on', 'ameliabooking'), // Used in Redesign | Updated
            'event_booking_opens_on'                           => __('Opens on', 'ameliabooking'), // Used in Redesign | Updated
            'event_booking_closes_after'                       => __('Booking closes when event starts', 'ameliabooking'), // Used in Redesign | Updated
            'event_booking_opens_now'                          => __('Booking opens immediately', 'ameliabooking'), // Used in Redesign | Updated
            'event_open'                                       => __('Open Event', 'ameliabooking'), // Used in Redesign
            'event_opened'                                     => __('Event has been opened.', 'ameliabooking'), // Used in Redesign | Updated
            'event_canceled'                                   => __('Event has been canceled.', 'ameliabooking'), // Used in Redesign | Updated
            'event_search_placeholder'                         => __('Search events', 'ameliabooking'), // Used in Redesign | Updated
            'event_staff'                                      => __('Staff', 'ameliabooking'), // Used in Redesign
            'event_organizer'                                  => __('Organizer', 'ameliabooking'), // Used in Redesign
            'event_organizer_tooltip'                          => __('Select the employee who will be added as the organizer of the Google/Outlook/Apple Calendar event. Employees selected under Staff will be added as guests.', 'ameliabooking'), // Used in Redesign | Updated
            'event_tags'                                       => __('Tags', 'ameliabooking'), // Used in Redesign
            'event_show_on_site'                               => __('Show on website', 'ameliabooking'),  // Used in Redesign | Updated
            'event_status_changed'                             => __('Booking status has been changed to ', 'ameliabooking'),
            'new_event'                                        => __('New event', 'ameliabooking'),
            'maximum_capacity_reached'                         => __('Maximum capacity is reached', 'ameliabooking'),
            'confirm'                                          => __('Confirm', 'ameliabooking'), // Used in Redesign
            'add_custom_field'                                 => __('Add custom field', 'ameliabooking'), // Used in Redesign
            'are_you_sure_reset_customize'                     => __('Are you sure you want to reset your form settings?', 'ameliabooking'),
            'current_changes_will_be_lost'                     => __('Your current changes will be lost.', 'ameliabooking'),
            'reset_yes'                                        => __('Yes, Reset', 'ameliabooking'),
            'reset_no'                                         => __('No, Cancel', 'ameliabooking'),
            'reset_form'                                       => __('Reset Form', 'ameliabooking'),
            'package_available'                                => __('Available in package', 'ameliabooking'),
            'bringing_anyone_with_you'                         => __('Bringing anyone with you?', 'ameliabooking'),
            'buttons'                                          => __('Buttons', 'ameliabooking'),
            'package_discount_text'                            => __('Save', 'ameliabooking'),
            'default_label'                                    => __('Default Label', 'ameliabooking'),
            'duration_colon'                                   => __('Duration', 'ameliabooking'),
            'checkbox'                                         => __('Checkbox', 'ameliabooking'), // Used in Redesign
            'click_add_custom_field'                           => __('Start by clicking the add custom field button', 'ameliabooking'),
            'text_content'                                     => __('Text content', 'ameliabooking'), // Used in Redesign
            'custom_fields_title'                              => __('Custom Fields', 'ameliabooking'), // Used in Redesign
            'font'                                             => __('Font', 'ameliabooking'),
            'no_custom_fields_yet'                             => __('You don\'t have any custom fields here yet...', 'ameliabooking'),
            'options'                                          => __('Options:', 'ameliabooking'), // Used in Redesign | Updated
            'pick_date_and_time'                               => __('Pick date & time', 'ameliabooking'),
            'please_select_service'                            => __('Please select service', 'ameliabooking'),
            'primary'                                          => __('Primary', 'ameliabooking'),
            'primary_color'                                    => __('Primary color', 'ameliabooking'),
            'success_color'                                    => __('Success', 'ameliabooking'),
            'warning_color'                                    => __('Warning', 'ameliabooking'),
            'error_color'                                      => __('Error', 'ameliabooking'),
            'radio'                                            => __('Radio button', 'ameliabooking'), // Used in Redesign | Updated
            'reset'                                            => __('Reset', 'ameliabooking'),
            'select'                                           => __('Select Box', 'ameliabooking'),
            'steps'                                            => __('Steps', 'ameliabooking'),
            'select_service'                                   => __('Select service', 'ameliabooking'),
            'text'                                             => __('Text', 'ameliabooking'), // Used in Redesign
            'text-area'                                        => __('Text area', 'ameliabooking'), // Used in Redesign
            'text_color'                                       => __('Text color', 'ameliabooking'),
            'placeholder_color'                                => __('Placeholder Color', 'ameliabooking'),
            'text_color_on_background'                         => __('Text color on background', 'ameliabooking'),
            'file'                                             => __('Attachment', 'ameliabooking'), // Used in Redesign
            'datepicker'                                       => __('Date picker', 'ameliabooking'), // Used in Redesign
            'preview'                                          => __('Preview', 'ameliabooking'),
            'bgr_color'                                        => __('Background Color', 'ameliabooking'),
            'bgr_gradient_color1'                              => __('Background Gradient Color 1', 'ameliabooking'),
            'bgr_gradient_color2'                              => __('Background Gradient Color 2', 'ameliabooking'),
            'bgr_gradient_angle'                               => __('Background Gradient Angle', 'ameliabooking'),
            'input_color'                                      => __('Input Color', 'ameliabooking'),
            'input_text_color'                                 => __('Input Text Color', 'ameliabooking'),
            'dropdown_color'                                   => __('Dropdown Color', 'ameliabooking'),
            'dropdown_text_color'                              => __('Dropdown Text Color', 'ameliabooking'),
            'image_color'                                      => __('Image Color', 'ameliabooking'),
            'recurring_active'                                 => __('Repeat this appointment', 'ameliabooking'),
            'first_name_colon'                                 => __('First name', 'ameliabooking'),
            'last_name_colon'                                  => __('Last name', 'ameliabooking'),
            'last_name_input_field'                            => __('Last name', 'ameliabooking'),
            'email_colon'                                      => __('Email', 'ameliabooking'),
            'email_input_field'                                => __('Email', 'ameliabooking'),
            'phone_colon'                                      => __('Phone', 'ameliabooking'),
            'phone_input_field'                                => __('Phone', 'ameliabooking'),
            'go_back'                                          => __('Go back', 'ameliabooking'),
            'service_name'                                     => __('Service name', 'ameliabooking'),
            'display_field'                                    => __('Display Field:', 'ameliabooking'),
            'filterable_field'                                 => __('Filterable Field:', 'ameliabooking'),
            'mandatory_field'                                  => __('Mandatory Field:', 'ameliabooking'),
            'event_type'                                       => __('Event type', 'ameliabooking'),
            'event_location'                                   => __('Event location', 'ameliabooking'),
            'event_free'                                       => __('Free', 'ameliabooking'),
            'service_badge'                                    => __('Service badge', 'ameliabooking'),
            'package_name'                                     => __('Package name', 'ameliabooking'),
            'congratulations'                                  => __('Congratulations!', 'ameliabooking'),
            'add_to_calendar'                                  => __('Add to calendar', 'ameliabooking'), // Used in Redesign
            'finish_appointment'                               => __('Finish', 'ameliabooking'),
            'form_type_step_by_step'                           => __('Step By Step Booking Form', 'ameliabooking'),
            'event_status'                                     => __('Event status', 'ameliabooking'),
            'event_filters'                                    => __('Filters', 'ameliabooking'),
            'event_book_event'                                 => __('Book event', 'ameliabooking'), // Used in Redesign | Updated
            'form_block_service'                               => __('Service', 'ameliabooking'),
            'form'                                             => __('Form', 'ameliabooking'),
            'form_flow'                                        => __('Form Flow', 'ameliabooking'),
            'use_global_colors'                                => __('Use Global Colors', 'ameliabooking'),
            'service_selection'                                => __('Service selection', 'ameliabooking'),
            'employee_selection'                               => __('Employee selection', 'ameliabooking'),
            'location_selection'                               => __('Location selection', 'ameliabooking'),
            'service_colon'                                    => __('Service', 'ameliabooking'),
            'dropdown_category_heading'                        => __('Category', 'ameliabooking'),
            'dropdown_items_heading'                           => __('Service', 'ameliabooking'),
            'dropdown_empty'                                   => __('No matching data', 'ameliabooking'),
            'bringing_anyone'                                  => __('Bringing anyone with you', 'ameliabooking'),
            'show_more'                                        => __('Show more', 'ameliabooking'),
            'show_less'                                        => __('Show less', 'ameliabooking'), // Used in Redesign | Updated
            'date_time'                                        => __('Date & time', 'ameliabooking'), // Used in Redesign
            'date_time_slots_selected'                         => __('All slots are selected', 'ameliabooking'),
            'info_step'                                        => __('Your information', 'ameliabooking'),
            'enter_first_name'                                 => __('Enter first name', 'ameliabooking'),
            'enter_last_name'                                  => __('Enter last name', 'ameliabooking'),
            'enter_email'                                      => __('Enter email', 'ameliabooking'),
            'enter_phone'                                      => __('Enter phone', 'ameliabooking'),
            'enter_phone_warning'                              => __('Please enter phone', 'ameliabooking'),
            'payment_step'                                     => __('Payment', 'ameliabooking'),
            'summary'                                          => __('Summary', 'ameliabooking'), // Used in Redesign
            'summary_services'                                 => __('Services', 'ameliabooking'),
            'summary_services_subtotal'                        => __('Service subtotal', 'ameliabooking'),
            'summary_persons'                                  => __('people', 'ameliabooking'),
            'total_amount_colon'                               => __('Total amount', 'ameliabooking'),
            'payment_onsite_sentence'                          => __('The payment will be done on-site.', 'ameliabooking'),
            'appointment_id'                                   => __('Appointment ID', 'ameliabooking'),
            'congrats_total_amount'                            => __('Total amount', 'ameliabooking'),
            'congrats_payment'                                 => __('Payment', 'ameliabooking'),
            'your_name_colon'                                  => __('Your name', 'ameliabooking'),
            'email_address_colon'                              => __('Email address', 'ameliabooking'),
            'phone_number_colon'                               => __('Phone number', 'ameliabooking'), // Used in Redesign
            'congrats_date'                                    => __('Date', 'ameliabooking'),
            'congrats_time'                                    => __('Local time', 'ameliabooking'),
            'congrats_service'                                 => __('Service', 'ameliabooking'),
            'congrats_employee'                                => __('Employee', 'ameliabooking'),
            'congrats_location'                                => __('Location', 'ameliabooking'),
            'choose_form'                                      => __('Choose a Form', 'ameliabooking'),
            'choose_form_for_customize'                        => __('Choose a form you want to customize. The Step-by-Step 2.0 form is the new and improved version which provides you with better design and user experience, as well as better speed.', 'ameliabooking'),
            'sbs_booking_form'                                 => __('Step-by-step', 'ameliabooking'), // Used in Redesign | Updated
            'sbs_booking_form_old'                             => __('Booking Forms 1.0', 'ameliabooking'),
            'redesigned_sbs_booking_form'                      => __('Provide a simplified, guided booking experience on your website. Customize the design and labels to improve usability and align with your business needs.', 'ameliabooking'), // Used in Redesign | Updated
            'old_forms_text'                                   => __('The original booking forms—Step-by-Step, Catalog, Event List, and Event Calendar—feature basic customization and label changes, serving as the foundation for our newer versions.', 'ameliabooking'),
            'primary_and_state_colors'                         => __('Primary and state colors', 'ameliabooking'),
            'sidebar'                                          => __('Sidebar area', 'ameliabooking'),
            'background_color'                                 => __('Background Color', 'ameliabooking'),
            'content'                                          => __('Content', 'ameliabooking'),
            'heading_text_color'                               => __('Heading Text Color', 'ameliabooking'),
            'content_text_color'                               => __('Content Text Color', 'ameliabooking'),
            'input_fields'                                     => __('Input fields', 'ameliabooking'),
            'border_color'                                     => __('Border color', 'ameliabooking'),
            'dropdowns'                                        => __('Dropdowns', 'ameliabooking'),
            'lower_price_background'                           => __('Lower price background', 'ameliabooking'),
            'higher_price_background'                          => __('Higher price background', 'ameliabooking'),
            'lower_price_text'                                 => __('Lower price text', 'ameliabooking'),
            'higher_price_text'                                => __('Higher price text', 'ameliabooking'),
            'waiting_list_background'                          => __('Waiting list background', 'ameliabooking'),
            'waiting_list_text'                                => __('Waiting list text', 'ameliabooking'),
            'primary_text'                                     => __('Primary text', 'ameliabooking'),
            'secondary_color'                                  => __('Secondary color', 'ameliabooking'),
            'danger_background'                                => __('Danger button background color', 'ameliabooking'),
            'danger_text'                                      => __('Danger button text color', 'ameliabooking'),
            'layout_and_inputs'                                => __('Layout & Inputs', 'ameliabooking'),
            'colors'                                           => __('Colors', 'ameliabooking'),
            'fonts'                                            => __('Fonts', 'ameliabooking'),
            'order'                                            => __('Order', 'ameliabooking'),
            'step_title'                                       => __('Title section', 'ameliabooking'),
            'footer_buttons'                                   => __('Footer buttons', 'ameliabooking'),
            'step_content'                                     => __('Step content', 'ameliabooking'),
            'finish_btn_type'                                  => __('Finish Button Type', 'ameliabooking'),
            'panel_btn_type'                                   => __('Panel Button Type', 'ameliabooking'),
            'summary_segment'                                  => __('Summary segment', 'ameliabooking'),
            'payment_segment'                                  => __('Payment segment', 'ameliabooking'),
            'heading_title'                                    => __('Heading title', 'ameliabooking'),
            'sub_steps'                                        => __('Sub Steps', 'ameliabooking'),
            'step_popups'                                      => __('Step Popups', 'ameliabooking'),
            'csb_global_settings_content'                      => __('Fonts and colors', 'ameliabooking'),
            'csb_sidebar_content'                              => __('Set up Sidebar visibility and its content', 'ameliabooking'),
            'csb_packages'                                     => __('Packages popup', 'ameliabooking'),
            'csb_services_content'                             => __('Set up Services, Locations, Employees selection options', 'ameliabooking'),
            'csb_services_only_content'                        => __('Set up Services selection options', 'ameliabooking'),
            'csb_employees_only_content'                       => __('Set up Employees selection options', 'ameliabooking'),
            'csb_locations_only_content'                       => __('Set up Locations selection options', 'ameliabooking'),
            'csb_date_time_content'                            => __('Set up Calendar layout and Recurring popup options', 'ameliabooking'),
            'csb_info_step'                                    => __('Customer information', 'ameliabooking'),
            'csb_info_step_content'                            => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_payment'                                      => __('Payment summary', 'ameliabooking'),
            'csb_payment_content'                              => __('Set up labels and buttons', 'ameliabooking'),
            'cpb_congratulations_content'                      => __('Set up button types and labels', 'ameliabooking'),
            'plus_more'                                        => __('+more', 'ameliabooking'),
            'cb_global_settings_heading'                       => __('Global Settings', 'ameliabooking'),
            'cb_sidebar'                                       => __('Sidebar area', 'ameliabooking'),
            'cb_section'                                       => __('Section', 'ameliabooking'),
            'cb_field_order_heading'                           => __('Field Order', 'ameliabooking'),
            'cb_congratulations_heading'                       => __('Congratulations', 'ameliabooking'),
            'sidebar_footer'                                   => __('Footer', 'ameliabooking'),
            'get_in_touch'                                     => __('Get in touch', 'ameliabooking'),
            'collapse_menu'                                    => __('Collapse menu', 'ameliabooking'),
            'sb_radio_filled'                                  => __('Filled', 'ameliabooking'),
            'sb_radio_plain'                                   => __('Plain', 'ameliabooking'),
            'sb_radio_text'                                    => __('Text', 'ameliabooking'),
            'continue_button_type'                             => __('\'Continue\' button style', 'ameliabooking'),
            'calendar_slot_end_time'                           => __('Slot end time', 'ameliabooking'),
            'show_busy_slots'                                  => __('Busy slots', 'ameliabooking'),
            'show_estimated_pricing'                           => __('Estimated price', 'ameliabooking'),
            'show_slot_pricing'                                => __('Time slot price', 'ameliabooking'),
            'show_indicator_pricing'                           => __('Price indicators', 'ameliabooking'),
            'show_people_waiting'                              => __('Number of people on waiting list', 'ameliabooking'),
            'calendar_time_zone'                               => __('Time zone', 'ameliabooking'),
            'finish_button_type'                               => __('\'Finish\' button style', 'ameliabooking'),
            'panel_button_type'                                => __('\'Customer panel\' button style', 'ameliabooking'),
            'sidebar_visibility'                               => __('Sidebar visibility', 'ameliabooking'),
            'publish_form'                                     => __('Publish Form', 'ameliabooking'),
            'view_all'                                         => __('View all', 'ameliabooking'),
            'csb_categories'                                   => __('Categories', 'ameliabooking'),
            'csb_categories_content'                           => __('Set up categories cards', 'ameliabooking'),
            'cards'                                            => __('Cards', 'ameliabooking'),
            'card_button_type'                                 => __('Button style', 'ameliabooking'),
            'csb_category_services'                            => __('Services overview', 'ameliabooking'),
            'csb_category_services_content'                    => __('Set up Services view', 'ameliabooking'),
            'csb_category_service'                             => __('Service details', 'ameliabooking'),
            'csb_category_service_content'                     => __('Set up Service detailed view', 'ameliabooking'),
            'booking_form'                                     => __('Booking Form', 'ameliabooking'),
            'booking_form_content'                             => __('Set options, colors and labels for booking form', 'ameliabooking'),
            'cat_booking_form'                                 => __('Catalog', 'ameliabooking'), // Used in Redesign | Updated
            'redesigned_cat_booking_form'                      => __('Showcase your services in stylish card layouts. Easily organize them by category and tailor the appearance to match your brand.', 'ameliabooking'), // Used in Redesign | Updated
            'card_services_number'                             => __('Service count', 'ameliabooking'),
            'back_btn_heading'                                 => __('Back button', 'ameliabooking'),
            'back_btn_type'                                    => __('\'Back\' button style', 'ameliabooking'),
            'back_btn'                                         => __('Go back', 'ameliabooking'),
            'booking_btn_type'                                 => __('\'Book now\' button style', 'ameliabooking'),
            'cl_btn'                                           => __('Main category button', 'ameliabooking'),
            'cl_side_color'                                    => __('Ribbon', 'ameliabooking'),
            'cl_color'                                         => __('Color', 'ameliabooking'),
            'cil_filter_menu_btn'                              => __('\'Filter\' button style', 'ameliabooking'),
            'cil_sidebar'                                      => __('Categories sidebar', 'ameliabooking'),
            'cil_filter_block'                                 => __('Filters block', 'ameliabooking'),
            'cil_side_menu_block'                              => __('Categories sidebar', 'ameliabooking'),
            'cil_main_header'                                  => __('Page header', 'ameliabooking'),
            'cil_main_content'                                 => __('Main content', 'ameliabooking'),
            'service_category'                                 => __('Service category', 'ameliabooking'),
            'service_duration'                                 => __('Service duration', 'ameliabooking'),
            'service_about'                                    => __('About service', 'ameliabooking'),
            'cil_filter_input'                                 => __('Search', 'ameliabooking'),
            'cli_item_color'                                   => __('Card color', 'ameliabooking'),
            'page_scroll_visibility'                           => __('Page scroll', 'ameliabooking'),
            'filter_input'                                     => __('Search', 'ameliabooking'),
            'available'                                        => __('Available', 'ameliabooking'), // Used in Redesign
            'heading_service'                                  => __('Service', 'ameliabooking'),
            'heading_services'                                 => __('Services', 'ameliabooking'),
            'no_search_data'                                   => __('No results', 'ameliabooking'), // Used in Redesign | Updated
            'free'                                             => __('Free', 'ameliabooking'),
            'book_now'                                         => __('Book now', 'ameliabooking'),
            'about_service'                                    => __('About service', 'ameliabooking'),
            'view_all_photos'                                  => __('View all photos', 'ameliabooking'),
            'contact_message'                                  => __('Contact message', 'ameliabooking'),
            'company_phone'                                    => __('Company Phone:', 'ameliabooking'),
            'company_email'                                    => __('Company Email:', 'ameliabooking'),
            'elf_booking_form'                                 => __('Events list', 'ameliabooking'), // Used in Redesign | Updated
            'redesigned_elf_booking_form'                      => __('Offer a clean, list-based booking experience with a design that grabs attention. Customers can easily explore and book from your full event lineup.', 'ameliabooking'), // Used in Redesign | Updated
            'csb_events_list'                                  => __('Events list', 'ameliabooking'),
            'csb_events_list_content'                          => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'ameliabooking'),
            'csb_event_info'                                   => __('Event info', 'ameliabooking'),
            'csb_event_info_content'                           => __('Set up staff, location, gallery and other event information visibility', 'ameliabooking'),
            'csb_event_customer'                               => __('Customer information', 'ameliabooking'),
            'csb_event_customer_content'                       => __('Field order, mandatory fields, labels and display options', 'ameliabooking'),
            'csb_event_payment'                                => __('Payment', 'ameliabooking'),
            'csb_event_payment_content'                        => __('Set up labels and buttons', 'ameliabooking'),
            'csb_event_congratulations'                        => __('Congratulations', 'ameliabooking'),
            'csb_event_congratulations_content'                => __('Set up button types and labels', 'ameliabooking'),
            'events_available'                                 => __('Events available', 'ameliabooking'),
            'event_available'                                  => __('Event available', 'ameliabooking'),
            'event_page'                                       => __('Page', 'ameliabooking'),
            'event_search'                                     => __('Search for events', 'ameliabooking'),
            'event_begins'                                     => __('Begins', 'ameliabooking'),
            'event_slot_left'                                  => __('slot left', 'ameliabooking'),
            'event_slots_left'                                 => __('slots left', 'ameliabooking'),
            'event_learn_more'                                 => __('Learn more', 'ameliabooking'),
            'event_read_more'                                  => __('Read more', 'ameliabooking'),
            'event_close'                                      => __('Close', 'ameliabooking'),
            'event_customer_info'                              => __('Your information', 'ameliabooking'),
            'summary_event'                                    => __('Event', 'ameliabooking'),
            'event_id'                                         => __('Event ID', 'ameliabooking'),
            'about'                                            => __('About', 'ameliabooking'),
            'event_info'                                       => __('Event info', 'ameliabooking'),
            'event_timetable'                                  => __('Timetable', 'ameliabooking'),
            'event_payment'                                    => __('Payment', 'ameliabooking'),
            'event_congrats'                                   => __('Congratulations', 'ameliabooking'),
            'event_about_list'                                 => __('About event', 'ameliabooking'),
            'event_start'                                      => __('Event starts', 'ameliabooking'),
            'event_end'                                        => __('Event ends', 'ameliabooking'),
            'event_at'                                         => __('at', 'ameliabooking'),
            'event_bringing'                                   => __('How many attendees do you want to book event for?', 'ameliabooking'),
            'step_filters'                                     => __('Filter', 'ameliabooking'),
            'event_card'                                       => __('Event card', 'ameliabooking'),
            'step_pagination'                                  => __('Step pagination', 'ameliabooking'),
            'event_slots_capacity'                             => __('Event slots capacity', 'ameliabooking'),
            'filters_button_type'                              => __('\'Filter\' button style', 'ameliabooking'),
            'read_more_button_type'                            => __('\'Read more\' button style', 'ameliabooking'),
            'learn_more_button_type'                           => __('\'Learn more\' button style', 'ameliabooking'),
            'event_tab_img'                                    => __('Image', 'ameliabooking'),
            'step_header'                                      => __('Step header', 'ameliabooking'),
            'step_info_tab'                                    => __('Step info tab', 'ameliabooking'),
            'booking_event_btn'                                => __('\'Book\' button style', 'ameliabooking'),
            'finish_event_btn'                                 => __('\'Finish\' button style', 'ameliabooking'),
            'close_event_btn'                                  => __('\'Close\' button style', 'ameliabooking'),
            'event_gallery'                                    => __('Event gallery', 'ameliabooking'),
            'event_description'                                => __('Event description', 'ameliabooking'), // Used in Redesign
            'summary_person'                                   => __('person', 'ameliabooking'),
            'event_employees'                                  => __('Event employees', 'ameliabooking'),
            'learn_more'                                       => __('Learn more', 'ameliabooking'),
            'service_information'                              => __('Service information', 'ameliabooking'),
            'learn_more_button'                                => __('\'Learn more\' button', 'ameliabooking'),
            'location_address'                                 => __('Location address', 'ameliabooking'),
            'no_results_found'                                 => __('No results found...', 'ameliabooking'),
            'card_field'                                       => __('Card field', 'ameliabooking'),
            'popup_content'                                    => __('Description', 'ameliabooking'),
            'layout'                                           => __('Layout', 'ameliabooking'),
            'search_input_field'                               => __('Search Input Field', 'ameliabooking'),
            'category_input_field'                             => __('Category Input Field', 'ameliabooking'),
            'select_service_category'                          => __('Select Service Category', 'ameliabooking'),
            'visibility'                                       => __('Visibility', 'ameliabooking'), // Used in Redesign
            'bringing_people_total'                            => __('Total people', 'ameliabooking'), // Used in Redesign | Updated
            'attendees'                                        => __('Attendees', 'ameliabooking'),
            'event_upcoming_events'                            => __('Upcoming events', 'ameliabooking'), // Used in Redesign
            'book_appointment'                                 => __('Book appointment', 'ameliabooking'), // Used in Redesign
            'custom'                                           => __('Custom', 'ameliabooking'), // Used in Redesign
            'ecf_booking_form'                                 => __('Events calendar', 'ameliabooking'), // Used in Redesign | Updated
            'redesigned_ecf_booking_form'                      => __('Display events in a calendar view, allowing customers to browse, search, and book directly. A great way to highlight upcoming events in an interactive format.', 'ameliabooking'),
            'capc_form'                                        => __('Customer panel', 'ameliabooking'), // Used in Redesign | Updated
            'redesigned_capc_form'                             => __('Enable customers to manage their appointments and events efficiently. Personalize colors and labels to create a seamless and branded experience.', 'ameliabooking'), // Used in Redesign | Updated
            'cape_form'                                        => __('Employee panel', 'ameliabooking'), // Used in Redesign | Updated
            'redesigned_cape_form'                             => __('Allow employees to manage appointments and events with ease. Customize colors to match your branding and improve usability.', 'ameliabooking'), // Used in Redesign | Updated
            'new_password_colon_retype'                        => __('Re-type new password', 'ameliabooking'),
            'catalog'                                          => __('Catalog', 'ameliabooking'),
            'choose_category'                                  => __('Choose Category', 'ameliabooking'),
            'choose_service'                                   => __('Choose Service', 'ameliabooking'),
            'choose_package'                                   => __('Choose Package', 'ameliabooking'),
            'filter'                                           => __('Preselect Booking Parameters', 'ameliabooking'), // Used in Redesign
            'skip_categories'                                  => __('Skip Categories step', 'ameliabooking'),
            'insert_amelia_shortcode'                          => __('Insert Amelia Booking Shortcode', 'ameliabooking'),
            'select_catalog_view'                              => __('Select Catalog View', 'ameliabooking'),
            'select_category'                                  => __('Select category', 'ameliabooking'),
            'select_employee'                                  => __('Select employee', 'ameliabooking'),
            'select_location'                                  => __('Select location', 'ameliabooking'),
            'select_package'                                   => __('Select Package', 'ameliabooking'),
            'select_event'                                     => __('Select Event', 'ameliabooking'),
            'select_events'                                    => __('Select Events', 'ameliabooking'),
            'select_tag'                                       => __('Select Tag', 'ameliabooking'),
            'select_tags'                                      => __('Select Tags', 'ameliabooking'),
            'select_view'                                      => __('Select View', 'ameliabooking'),
            'show'                                             => __('Show', 'ameliabooking'),
            'show_all'                                         => __('Show All', 'ameliabooking'),
            'manually_loading'                                 => __('Load booking form manually', 'ameliabooking'),
            'manually_loading_description'                     => __('Add element (button, link...) ID, that will manually load amelia shortcode content', 'ameliabooking'),
            'multiselect_note'                                 => __('For multiselect: hold CTRL / Command (⌘).', 'ameliabooking'),
            'show_all_categories'                              => __('Show all categories', 'ameliabooking'),
            'show_all_employees'                               => __('Show all employees', 'ameliabooking'),
            'show_all_locations'                               => __('Show all locations', 'ameliabooking'),
            'show_all_services'                                => __('Show all services', 'ameliabooking'), // Used in Redesign | Updated
            'show_all_events'                                  => __('Show all events', 'ameliabooking'),
            'show_all_packages'                                => __('Show all packages', 'ameliabooking'),
            'show_all_tags'                                    => __('Show all tags', 'ameliabooking'),
            'show_catalog'                                     => __('Show catalog of all categories', 'ameliabooking'),
            'show_category'                                    => __('Show specific category', 'ameliabooking'),
            'show_categories'                                  => __('Show specific categories', 'ameliabooking'),
            'show_package'                                     => __('Show specific package', 'ameliabooking'),
            'show_packages'                                    => __('Show specific packages', 'ameliabooking'),
            'show_event'                                       => __('Show event', 'ameliabooking'),
            'show_event_view_type'                             => __('Show Type', 'ameliabooking'),
            'show_event_view_list'                             => __('List (default)', 'ameliabooking'),
            'show_event_view_calendar'                         => __('Calendar', 'ameliabooking'),
            'show_tag'                                         => __('Show tag', 'ameliabooking'),
            'show_service'                                     => __('Show specific service', 'ameliabooking'),
            'show_services'                                    => __('Show specific services', 'ameliabooking'),
            'trigger_type'                                     => __('Trigger type', 'ameliabooking'),
            'trigger_type_id'                                  => __('Id', 'ameliabooking'),
            'trigger_type_class'                               => __('Class', 'ameliabooking'),
            'trigger_type_tooltip'                             => __('Trigger by attribute', 'ameliabooking'),
            'step_booking'                                     => __('Step Booking', 'ameliabooking'),
            'catalog_booking'                                  => __('Catalog Booking', 'ameliabooking'),
            'events_list_booking'                              => __('Events List Booking', 'ameliabooking'),
            'recurring_event'                                  => __('Show recurring events', 'ameliabooking'),
            'in_dialog'                                        => __('Show in Amelia Popup', 'ameliabooking'),
            'booking_divi'                                     => __('AM - Booking view', 'ameliabooking'),
            'step_booking_divi'                                => __('AM - Step Booking', 'ameliabooking'),
            'catalog_booking_divi'                             => __('AM - Catalog Booking', 'ameliabooking'),
            'catalog_divi'                                     => __('AM - Catalog view', 'ameliabooking'),
            'events_divi'                                      => __('AM - Events view', 'ameliabooking'),
            'events_list_booking_divi'                         => __('AM - Events List Booking', 'ameliabooking'),
            'events_calendar_booking_divi'                     => __('AM - Events Calendar Booking', 'ameliabooking'),
            'booking_gutenberg_block'                          => [
                'title'       => __('Amelia - Booking view', 'ameliabooking'),
                'description' => __('Step-By-Step Booking Wizard gives your customers the option to choose everything about the booking in a few steps', 'ameliabooking'),
            ],
            'step_booking_gutenberg_block'                     => [
                'title'       => __('Amelia - Step-By-Step Booking', 'ameliabooking'),
                'description' => __('Step-by-Step booking view guides the customers through several steps in order to make their bookings.', 'ameliabooking'),
            ],
            'catalog_booking_gutenberg_block'                  => [
                'title'       => __('Amelia - Catalog Booking', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a catalog', 'ameliabooking'),
            ],
            'catalog_gutenberg_block'                          => [
                'title'       => __('Amelia - Catalog view', 'ameliabooking'),
                'description' => __('Front-end Booking Catalog is shortcode when you want to show your service in a form of a cataloge', 'ameliabooking'),
            ],
            'events_gutenberg_block'                           => [
                'title'       => __('Amelia - Events', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_list_booking_gutenberg_block'              => [
                'title'       => __('Amelia - Events List', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event list view.', 'ameliabooking'),
            ],
            'events_calendar_booking_gutenberg_block'          => [
                'title'       => __('Amelia - Events Calendar', 'ameliabooking'),
                'description' => __('Event Booking is shortcode that gives your customers the option to book one of the events that you\'ve created on the back-end in a simple event calendar view.', 'ameliabooking'),
            ],
            'outdated_booking_gutenberg_block'                 => __('You are using a form that will be outdated soon!', 'ameliabooking'),
            'search'                                           => __('Search', 'ameliabooking'), // Used in Redesign
            'red_activation_settings'                          => __('Activation settings', 'ameliabooking'),
            'red_action_triggered'                             => __('Action Triggered', 'ameliabooking'),
            'red_add_custom_notification'                      => __('Add custom notification', 'ameliabooking'),
            'red_add_work_hours'                               => __('Add work hours', 'ameliabooking'),
            'red_agencies'                                     => __('Agencies', 'ameliabooking'),
            'red_api'                                          => __('API', 'ameliabooking'),
            'red_appointment_created_success'                  => __('Appointment has been created.', 'ameliabooking'),
            'red_appointment_status_updated'                   => __('Appointment status has been updated.'),
            'red_appointment_details'                          => __('Appointment details', 'ameliabooking'),
            'red_appointment_note_updated'                     => __('Appointment note has been updated.', 'ameliabooking'),
            'red_are_you_sure_delete_items'                    => __('Are you sure you want to delete these items?', 'ameliabooking'),
            'red_at_time'                                      => __('at {time}', 'ameliabooking'),
            'red_attendee_asc'                                 => __('Attendee Asc', 'ameliabooking'),
            'red_attendee_desc'                                => __('Attendee Desc', 'ameliabooking'),
            'red_beauty'                                       => __('Beauty', 'ameliabooking'),
            'red_blog'                                         => __('Blog', 'ameliabooking'),
            'red_book'                                         => __('Book', 'ameliabooking'),
            'red_booking_closes_asc'                           => __('Booking Closes Asc', 'ameliabooking'),
            'red_booking_closes_desc'                          => __('Booking Closes Desc', 'ameliabooking'),
            'red_booking_closes'                               => __('Booking closes', 'ameliabooking'),
            'red_booking_number_count'                         => __('Booking #{count}', 'ameliabooking'),
            'red_booking_opens_asc'                            => __('Booking Opens Asc', 'ameliabooking'),
            'red_booking_opens_desc'                           => __('Booking Opens Desc', 'ameliabooking'),
            'red_booking_opens'                                => __('Booking opens', 'ameliabooking'),
            'red_booking_type'                                 => __('Booking type', 'ameliabooking'),
            'red_bookings_count'                               => __('# of bookings', 'ameliabooking'),
            'red_buddyboss'                                    => __('BuddyBoss', 'ameliabooking'),
            'red_cancel_and_delete'                            => __('Cancel and Delete', 'ameliabooking'),
            'red_configure_combined_placeholder_tooltip'       => __('Click "Configure" to edit the text that will appear when this placeholder is used in notifications.', 'ameliabooking'),
            'red_content_placeholders'                         => __('Content placeholders', 'ameliabooking'),
            'red_catalog'                                      => __('Catalog', 'ameliabooking'),
            'red_clear_filters'                                => __('Clear filters', 'ameliabooking'),
            'red_clear'                                        => __('Clear', 'ameliabooking'),
            'red_click_to_upload'                              => __('Click to upload', 'ameliabooking'),
            'red_coaching'                                     => __('Coaching', 'ameliabooking'),
            'red_color'                                        => __('Color', 'ameliabooking'),
            'red_compared_stats'                               => __('Compared to previous range', 'ameliabooking'),
            'red_consulting'                                   => __('Consulting', 'ameliabooking'),
            'red_contact_support'                              => __('Contact support.', 'ameliabooking'),
            'red_count_attendees'                              => __('{count} Attendee | {count} Attendees', 'ameliabooking'),
            'red_count_days'                                   => __('{count} day | {count} days', 'ameliabooking'),
            'red_count_hours'                                  => __('{count} hour | {count} hours', 'ameliabooking'),
            'red_count_minutes'                                => __('{count} minute | {count} minutes', 'ameliabooking'),
            'red_count_months'                                 => __('{count} month | {count} months', 'ameliabooking'),
            'red_booking_updated'                              => __('Booking has been updated.', 'ameliabooking'),
            'red_count_appointments_deleted'                   => __('{count} appointment has been deleted. | {count} appointments have been deleted.', 'ameliabooking'),
            'red_count_appointments_failed_to_be_deleted'      => __('{count} appointment has not been deleted. | {count} appointments have not been deleted.', 'ameliabooking'),
            'red_count_event_bookings_deleted'                 => __('{count} event booking has been deleted. | {count} event bookings have been deleted.', 'ameliabooking'),
            'red_count_event_bookings_failed_to_be_deleted'    => __('{count} event booking has not been deleted. | {count} event bookings have not been deleted.', 'ameliabooking'),
            'red_count_events_deleted'                         => __('{count} event has been deleted. | {count} events have been deleted.', 'ameliabooking'),
            'red_count_selected'                               => __('{count} Selected', 'ameliabooking'),
            'red_count_services_deleted'                       => __('{count} service has been deleted. | {count} services have been deleted.', 'ameliabooking'),
            'red_count_services_failed_to_be_deleted'          => __('{count} service has not been deleted. | {count} services have not been deleted.', 'ameliabooking'),
            'red_count_weeks'                                  => __('{count} week | {count} weeks', 'ameliabooking'),
            'red_table_settings_updated'                       => __('Table settings have been updated.', 'ameliabooking'),
            'red_custom_notifications'                         => __('Custom notifications', 'ameliabooking'),
            'red_customer_configuration'                       => __('Customer configuration', 'ameliabooking'),
            'red_customer_asc'                                 => __('Customer Asc', 'ameliabooking'),
            'red_customer_desc'                                => __('Customer Desc', 'ameliabooking'),
            'red_customer_note'                                => __('Customer note', 'ameliabooking'),
            'red_customers_detected_in_file'                   => __('Customers detected in file:', 'ameliabooking'),
            'red_daily_occupancy'                              => __('Daily occupancy', 'ameliabooking'),
            'red_enter_phone_number_then_press_enter_to_add'   => __('Enter a phone number, then press Enter to add', 'ameliabooking'),
            'red_dark_theme'                                   => __('Dark Theme', 'ameliabooking'),
            'red_date_asc'                                     => __('Date Asc', 'ameliabooking'),
            'red_date_desc'                                    => __('Date Desc', 'ameliabooking'),
            'red_delete_appointment'                           => __('Delete appointment', 'ameliabooking'),
            'red_delete_booking'                               => __('Delete booking', 'ameliabooking'),
            'red_delete_service_effect_past'                   => __('This service has {count} appointment in the past. | This service has {count} appointments in the past.', 'ameliabooking'),
            'red_documentation'                                => __('Documentation', 'ameliabooking'),
            'red_duplicate_appointment'                        => __('Duplicate appointment', 'ameliabooking'),
            'red_duration_asc'                                 => __('Duration Asc', 'ameliabooking'),
            'red_duration_desc'                                => __('Duration Desc', 'ameliabooking'),
            'red_e_ticket_qr_code'                             => __('E-ticket QR code', 'ameliabooking'),
            'red_edit_booking'                                 => __('Edit booking', 'ameliabooking'),
            'red_edit_event'                                   => __('Edit event', 'ameliabooking'),
            'red_edit_table_subtitle'                          => __('Drag to rearrange columns and/or choose which ones to display.', 'ameliabooking'),
            'red_edit_transaction'                             => __('Edit transaction', 'ameliabooking'),
            'red_edit_table'                                   => __('Edit table', 'ameliabooking'),
            'red_enable'                                       => __('Enable', 'ameliabooking'),
            'red_end_date'                                     => __('End date', 'ameliabooking'),
            'red_event_asc'                                    => __('Event Asc', 'ameliabooking'),
            'red_event_booking_details'                        => __('Event Booking Details', 'ameliabooking'),
            'red_event_desc'                                   => __('Event Desc', 'ameliabooking'),
            'red_event_details'                                => __('Event details', 'ameliabooking'),
            'red_export_bookings'                              => __('Export bookings', 'ameliabooking'),
            'red_facebook_social_login_description'            => __('Allow customers and employees to quickly sign in using their Facebook account, making the login process faster, simpler, and more secure.', 'ameliabooking'),
            'red_facebook_social_login'                        => __('Facebook social login', 'ameliabooking'),
            'red_feature_api_description'                      => __('Connect APIs effortlessly for smooth, integrated workflows.', 'ameliabooking'),
            'red_feature_apple_calendar_description'           => __('Connect Apple Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_barion_description'                   => __('Simple, secure payments powered by Barion.', 'ameliabooking'),
            'red_feature_buddyboss_description'                => __('Display Amelia booking forms and panels on BuddyBoss member profiles.', 'ameliabooking'),
            'red_feature_cart_description'                     => __('Allow customers to book multiple services in a single transaction for a streamlined experience.', 'ameliabooking'),
            'red_feature_coupons_description'                  => __('Offer discounts or free appointments with customizable coupons.', 'ameliabooking'),
            'red_feature_custom_duration_description'          => __('Offer services with multiple duration options for customers to choose from.', 'ameliabooking'),
            'red_feature_custom_fields_description'            => __('Use custom fields as intake forms to collect customer information during booking.', 'ameliabooking'),
            'red_feature_custom_notifications_description'     => __('Send personalized email and SMS notifications tailored to your business.', 'ameliabooking'),
            'red_feature_custom_pricing_description'           => __('Set dynamic pricing for services based on various conditions.', 'ameliabooking'),
            'red_feature_deposit_payment_description'          => __('Allow clients to secure bookings with partial payments.', 'ameliabooking'),
            'red_feature_e_ticket_qr_code_description'         => __('Enable quick, contactless event check-ins with unique QR codes for each ticket.', 'ameliabooking'),
            'red_feature_employee_badge_description'           => __('Enhance bookings with customizable badges to strengthen your brand identity.', 'ameliabooking'),
            'red_feature_event_tickets_description'            => __('Set flexible ticket pricing with categories and date-based ranges to maximize accessibility and revenue.', 'ameliabooking'),
            'red_feature_extras_description'                   => __('Offer upsells or additional benefits within a service using extras.', 'ameliabooking'),
            'red_feature_facebook_pixel_description'           => __('Add Meta Pixel to track ad conversions and optimize marketing.', 'ameliabooking'),
            'red_feature_google_analytics_description'         => __('Add a Google Analytics tracking code to your booking page to gain insights into visitor behavior.', 'ameliabooking'),
            'red_feature_google_calendar_description'          => __('Connect Google Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_google_disconnect'                    => __('Disconnect account', 'ameliabooking'),
            'red_feature_google_general_description'           => __('Sync your and your employees\' personal and professional events by connecting Google calendars.', 'ameliabooking'),
            'red_feature_google_sign_in_button'                => __('Sign in with Google', 'ameliabooking'),
            'red_feature_invoices_description'                 => __('Generate invoices automatically for bookings to streamline payments and improve client experience.', 'ameliabooking'),
            'red_feature_lesson_space_description'             => __('Create online classrooms automatically for each booked appointment or event.', 'ameliabooking'),
            'red_feature_mailchimop_description'               => __('Send your customer data to Mailchimp quickly and effortlessly.', 'ameliabooking'),
            'red_feature_mollie_description'                   => __('Accept payments seamlessly through the Mollie payment gateway.', 'ameliabooking'),
            'red_feature_no_show_tag_description'              => __('Track customers who miss appointments or events without sending notifications.', 'ameliabooking'),
            'red_feature_outlook_calendar_description'         => __('Connect Outlook Calendars to sync your personal and professional events, along with your employees’.', 'ameliabooking'),
            'red_feature_packages_description'                 => __('Bundle multiple appointments or services at discounted rates to encourage customers to book more.', 'ameliabooking'),
            'red_feature_paypal_description'                   => __('Accept payments for bookings and services via PayPal.', 'ameliabooking'),
            'red_feature_razorpay_description'                 => __('Accept payments via Razorpay, ideal for Indian businesses.', 'ameliabooking'),
            'red_feature_recaptcha_description'                => __('Protect your booking system from bots by integrating reCAPTCHA keys.', 'ameliabooking'),
            'red_feature_recurring_appointments_description'   => __('Allow customers to book repeating appointments with customizable recurrence.', 'ameliabooking'),
            'red_feature_resources_description'                => __('Create resources like rooms or chairs that can be shared across services, locations, and employees.', 'ameliabooking'),
            'red_feature_square_description'                   => __('Process payments easily with Square.', 'ameliabooking'),
            'red_feature_stripe_description'                   => __('Securely process payments using Stripe.', 'ameliabooking'),
            'red_feature_tax_description'                      => __('Automatically calculate and apply taxes for hassle-free compliance and accurate billing.', 'ameliabooking'),
            'red_feature_time_zones_description'               => __('Set individual time zones for employees so availability and bookings are shown correctly for clients worldwide.', 'ameliabooking'),
            'red_feature_event_waiting_list_description'       => __('Manage event cancellations efficiently by allowing customers to join waiting lists and filling open spots manually.', 'ameliabooking'),
            'red_feature_appointment_waiting_list_description' => __('Efficiently manage appointment cancellations by allowing customers to join a waiting list and manually fill newly opened time slots.', 'ameliabooking'),
            'red_feature_webhooks_description'                 => __('Connect with web apps to automate messaging and send updates to custom URLs.', 'ameliabooking'),
            'red_feature_whatsapp_description'                 => __('Send appointment notifications directly via WhatsApp.', 'ameliabooking'),
            'red_feature_woocommerce_description'              => __('Integrate with WooCommerce to enable advanced e-commerce capabilities.', 'ameliabooking'),
            'red_feature_zoom_description'                     => __('Automatically create Zoom meetings for bookings and notify customers and employees.', 'ameliabooking'),
            'red_features_integrations'                        => __('Features & Integrations', 'ameliabooking'),
            'red_features'                                     => __('Features', 'ameliabooking'),
            'red_fri'                                          => __('Fri', 'ameliabooking'),
            'red_full_events'                                  => __('Full events', 'ameliabooking'),
            'red_go_to_custom_fields'                          => __('Go to Custom Fields', 'ameliabooking'),
            'red_google_calendar_and_google_meet'              => __('Google Calendar & Google Meet', 'ameliabooking'),
            'red_google_meet'                                  => __('Google Meet', 'ameliabooking'),
            'red_google_social_login_description'              => __('Allow customers and employees to quickly sign in using their Google account, making the login process faster, simpler, and more secure.', 'ameliabooking'),
            'red_google_social_login'                          => __('Google social login', 'ameliabooking'),
            'red_gyms'                                         => __('Gyms', 'ameliabooking'),
            'red_healthcare'                                   => __('Healthcare', 'ameliabooking'),
            'red_hidden'                                       => __('Hidden', 'ameliabooking'),
            'red_hour_short'                                   => __('h', 'ameliabooking'),
            'red_id_asc'                                       => __('ID Asc', 'ameliabooking'),
            'red_id_desc'                                      => __('ID Desc', 'ameliabooking'),
            'red_import_rules_1'                               => __('You can import the following columns: First name, Last name, Email, Phone, Gender, Birthday, Note.', 'ameliabooking'),
            'red_industries'                                   => __('Industries', 'ameliabooking'),
            'red_import_rules_2'                               => __('The first row should not contain column names.', 'ameliabooking'),
            'red_import_rules_3'                               => __('Valid first and last names are required fields.', 'ameliabooking'),
            'red_import_rules_4'                               => __('First and last names must be in two separate fields.', 'ameliabooking'),
            'red_import_rules_5'                               => __('Date of birth must be in the same format as chosen in your WP settings. If a date format with a comma is used, the dates should be in quotes.', 'ameliabooking'),
            'red_import_rules_6'                               => __('Phone number must include a country code.', 'ameliabooking'),
            'red_import_rules_7'                               => __('Gender should be specified as either \'male\' or \'female\'.', 'ameliabooking'),
            'red_import_rules_8'                               => __('If multiple customers have the same email address, only the first one will be imported.', 'ameliabooking'),
            'red_import_rules_9'                               => __('If invalid, other values will be skipped and not imported.', 'ameliabooking'),
            'red_last_booking_asc'                             => __('Last Booking Asc', 'ameliabooking'),
            'red_last_booking_desc'                            => __('Last Booking Desc', 'ameliabooking'),
            'red_less_options'                                 => __('Less options', 'ameliabooking'),
            'red_light_theme'                                  => __('Light Theme', 'ameliabooking'),
            'red_manage_bookings'                              => __('Manage bookings', 'ameliabooking'),
            'red_max_capacity_asc'                             => __('Max Capacity Asc', 'ameliabooking'),
            'red_max_capacity_desc'                            => __('Max Capacity Desc', 'ameliabooking'),
            'red_microsoft_teams'                              => __('Microsoft Teams', 'ameliabooking'),
            'red_message'                                      => __('Message', 'ameliabooking'),
            'red_message_content'                              => __('Message content', 'ameliabooking'),
            'red_message_template'                             => __('Message template', 'ameliabooking'),
            'red_minute_short'                                 => __('min', 'ameliabooking'),
            'red_mon'                                          => __('Mon', 'ameliabooking'),
            'red_more_features_zero_limits'                    => __('More Features Zero Limits', 'ameliabooking'),
            'red_more_options'                                 => __('More options', 'ameliabooking'),
            'red_need_additional_fields'                       => __('Need additional fields?', 'ameliabooking'),
            'red_new_attendee'                                 => __('New Attendee', 'ameliabooking'),
            'red_new_event_booking'                            => __('New event booking', 'ameliabooking'),
            'red_new_update'                                   => __('New Update', 'ameliabooking'),
            'red_no_appointments_subtitle_1'                   => __('Once you receive bookings, your appointments will be displayed here. You can also get started by clicking the Add button below.', 'ameliabooking'),
            'red_no_appointments_yet'                          => __('No appointments yet', 'ameliabooking'),
            'red_no_attendees_found'                           => __('No attendees found', 'ameliabooking'),
            'red_no_event_bookings_subtitle_1'                 => __('Once you receive event bookings, they will be displayed here. You can also get started by clicking the Book Event button below.', 'ameliabooking'),
            'red_no_event_bookings_yet'                        => __('No event bookings yet', 'ameliabooking'),
            'red_no_events_subtitle_1'                         => __('Once you add your first event, it will appear here. Click + Event below to get started.', 'ameliabooking'),
            'red_no_events_yet'                                => __('No events yet', 'ameliabooking'),
            'red_no_results_found_empty'                       => __('No results found', 'ameliabooking'),
            'red_no_results_found'                             => __('No results found', 'ameliabooking'),
            'red_no_results_found_for'                         => __('No results found for', 'ameliabooking'),
            'red_no_search_results_subtitle'                   => __('Try adjusting your search or filters.', 'ameliabooking'),
            'red_no_services_or_employees_available_subtitle'  => __('Please ensure that services and employees are created and that services are assigned to employees.', 'ameliabooking'),
            'red_no_services_or_employees_available'           => __('No services or employees available', 'ameliabooking'),
            'red_no_services_subtitle_1_part_1'                => __('Once you add your first service, it will appear here.', 'ameliabooking'),
            'red_no_services_subtitle_1_part_2'                => __('Click + Service below to get started.', 'ameliabooking'),
            'red_no_services_subtitle_2_part_1'                => __('Try adjusting your filters or search criteria to find the services you\'re looking for.', 'ameliabooking'),
            'red_no_services_subtitle_2_part_2'                => __('You can also clear all filters to view all services.', 'ameliabooking'),
            'red_no_services_yet'                              => __('No services yet', 'ameliabooking'),
            'red_no_show_1'                                    => __('No Show (1)', 'ameliabooking'),
            'red_no_show_2'                                    => __('No Show (2)', 'ameliabooking'),
            'red_no_show_3_plus'                               => __('No Show (3+)', 'ameliabooking'),
            'red_no_show_tag'                                  => __('No-show tag', 'ameliabooking'),
            'red_no_top_trends'                                => __('No top trends', 'ameliabooking'),
            'red_no_transactions_subtitle_1'                   => __('Once you start receiving bookings, transactions will be displayed here.', 'ameliabooking'),
            'red_no_transactions_title'                        => __('No transactions yet', 'ameliabooking'),
            'red_no_upcoming_events_subtitle'                  => __('There are no future events scheduled. Please create a new event.', 'ameliabooking'),
            'red_no_upcoming_events'                           => __('No upcoming events', 'ameliabooking'),
            'red_no_wp_users_with_amelia_customer_role'        => __('No WordPress users with the Amelia Customer role are available.', 'ameliabooking'),
            'red_notifications'                                => __('Notifications', 'ameliabooking'),
            'red_occupancy_rate_info'                          => __('This widget shows monthly data instead of using the global date range.', 'ameliabooking'),
            'red_occupancy_rate'                               => __('Occupancy rate', 'ameliabooking'),
            'red_occupied'                                     => __('Occupied', 'ameliabooking'),
            'red_on_site_payment'                              => __('On-site payment', 'ameliabooking'),
            'red_organizers'                                   => __('Organizers', 'ameliabooking'),
            'red_payment_methods'                              => __('Payment methods', 'ameliabooking'),
            'red_payment_methods_compatibility_rules'          => __('Some payment methods cannot be used together due to compatibility rules', 'ameliabooking'),
            'red_outlook_calendar_and_microsoft_teams'         => __('Outlook Calendar & Microsoft Teams', 'ameliabooking'),
            'red_paragraph'                                    => __('Paragraph', 'ameliabooking'),
            'red_placeholder_tooltip'                          => __('Select a placeholder to insert it where your cursor is placed.', 'ameliabooking'),
            'red_plans'                                        => __('Plans', 'ameliabooking'),
            'red_please_enter_content'                         => __('Please enter a content.', 'ameliabooking'),
            'red_please_enter_notification_name'               => __('Please enter a notification name.', 'ameliabooking'),
            'red_please_enter_subject'                         => __('Please enter a subject.', 'ameliabooking'),
            'red_please_enter_ticket_name'                     => __('Please enter a ticket name.', 'ameliabooking'),
            'red_recaptcha'                                    => __('reCAPTCHA', 'ameliabooking'),
            'red_recurring_alert_setup'                        => __('Before enabling the recurring option, ensure that all required fields are set, including the service, employee, date, time, and location (if applicable).', 'ameliabooking'),
            'red_reorder_on_website'                           => __('Reorder on website', 'ameliabooking'),
            'red_reorder_services_description'                 => __('Reordering services affects how they are displayed on the website.', 'ameliabooking'),
            'red_reorder_services'                             => __('Reorder Services', 'ameliabooking'),
            'red_reorder_services_failed'                      => __('Failed to reorder services.', 'ameliabooking'),
            'red_reorder_services_successfully'                => __('Services have been reordered.', 'ameliabooking'),
            'red_replace'                                      => __('Replace', 'ameliabooking'),
            'red_revenue_prev_range'                           => __('Previous range', 'ameliabooking'),
            'red_revenue_this_range'                           => __('This range', 'ameliabooking'),
            'red_roles_permissions'                            => __('Roles & permissions', 'ameliabooking'),
            'red_same_day'                                     => __('Same day', 'ameliabooking'),
            'red_sat'                                          => __('Sat', 'ameliabooking'),
            'red_scheduled'                                    => __('Scheduled', 'ameliabooking'),
            'red_scope'                                        => __('Scope', 'ameliabooking'),
            'red_scopes'                                       => __('Scopes', 'ameliabooking'),
            'red_search_bookings'                              => __('Search bookings', 'ameliabooking'),
            'red_search_features'                              => __('Search features', 'ameliabooking'),
            'red_search_integrations'                          => __('Search integrations', 'ameliabooking'),
            'red_search_invoices'                              => __('Search invoices', 'ameliabooking'),
            'red_search_notifications'                         => __('Search notifications', 'ameliabooking'),
            'red_search_packages'                              => __('Search packages', 'ameliabooking'),
            'red_search_services'                              => __('Search services', 'ameliabooking'),
            'red_select_attendee_warning'                      => __('Please select an attendee.', 'ameliabooking'),
            'red_select_booking_closes_date_warning'           => __('Please select a closing date.', 'ameliabooking'),
            'red_select_booking_closes_time_warning'           => __('Please select a closing time.', 'ameliabooking'),
            'red_select_booking_opens_date_warning'            => __('Please select an opening date.', 'ameliabooking'),
            'red_select_booking_opens_time_warning'            => __('Please select an opening time.', 'ameliabooking'),
            'red_select_box'                                   => __('Select box', 'ameliabooking'),
            'red_select_color_warning'                         => __('Please select a color.', 'ameliabooking'),
            'red_select_date_range_warning'                    => __('Please select a date range.', 'ameliabooking'),
            'red_select_end_time_warning'                      => __('Please select an end time.', 'ameliabooking'),
            'red_select_event_warning'                         => __('Please select an event.', 'ameliabooking'),
            'red_select_start_time_warning'                    => __('Please select a start time.', 'ameliabooking'),
            'red_send_test'                                    => __('Send test', 'ameliabooking'),
            'red_service_asc'                                  => __('Service Asc', 'ameliabooking'),
            'red_service_categories'                           => __('Service Categories', 'ameliabooking'),
            'red_service_desc'                                 => __('Service Desc', 'ameliabooking'),
            'red_service_event'                                => __('Service/Event', 'ameliabooking'),
            'red_service_updated_success'                      => __('Service has been updated.', 'ameliabooking'),
            'red_services_count'                               => __('{count} Service | {count} Services', 'ameliabooking'),
            'red_show_bookings'                                => __('Show bookings', 'ameliabooking'),
            'red_show_event'                                   => __('Show event', 'ameliabooking'),
            'red_show_event_subtitle'                          => __('Are you sure you want to show this event?', 'ameliabooking'),
            'red_show_in_calendar'                             => __('View in Calendar', 'ameliabooking'),
            'red_single_booking'                               => __('Single booking', 'ameliabooking'),
            'red_sms'                                          => __('SMS', 'ameliabooking'),
            'red_sms_balance'                                  => __('SMS balance', 'ameliabooking'),
            'red_sms_settings'                                 => __('SMS Settings', 'ameliabooking'),
            'red_spots'                                        => __('Spots', 'ameliabooking'),
            'red_booked'                                       => __('Booked', 'ameliabooking'),
            'red_start_date'                                   => __('Start date', 'ameliabooking'),
            'red_status_asc'                                   => __('Status Asc', 'ameliabooking'),
            'red_status_desc'                                  => __('Status Desc', 'ameliabooking'),
            'red_studios'                                      => __('Studios', 'ameliabooking'),
            'red_subject_placeholders'                         => __('Subject placeholders', 'ameliabooking'),
            'red_sun'                                          => __('Sun', 'ameliabooking'),
            'red_support'                                      => __('Support', 'ameliabooking'),
            'red_thu'                                          => __('Thu', 'ameliabooking'),
            'red_time_zones'                                   => __('Time zones', 'ameliabooking'),
            'red_tip_appointment_management_guide'             => __('Appointment management guide', 'ameliabooking'),
            'red_tip_custom_service_duration'                  => __('Custom service duration', 'ameliabooking'),
            'red_tip_event_calendar_booking_from'              => __('Event calendar booking from', 'ameliabooking'),
            'red_tip_event_list_booking_from'                  => __('Event list booking from', 'ameliabooking'),
            'red_tip_event_management_guide'                   => __('Events setup', 'ameliabooking'),
            'red_tip_event_pricing_setup'                      => __('Events custom pricing', 'ameliabooking'),
            'red_tip_event_ticketing'                          => __('Event ticketing', 'ameliabooking'),
            'red_tip_events_list_view'                         => __('Events list view', 'ameliabooking'),
            'red_tip_events_pricing'                           => __('Events pricing', 'ameliabooking'),
            'red_tip_front_end_customer_panel'                 => __('Front-end customer panel', 'ameliabooking'),
            'red_tip_importing_customers'                      => __('Importing customers', 'ameliabooking'),
            'red_tip_notification_settings'                    => __('Notification settings', 'ameliabooking'),
            'red_tip_notifications_in_amelia'                  => __('Notifications in Amelia', 'ameliabooking'),
            'red_tip_recurring_appointments_setup'             => __('Recurring appointments setup', 'ameliabooking'),
            'red_tip_recurring_events_description'             => __('Create and manage recurring events with customizable schedules for flexibility and convenience.', 'ameliabooking'),
            'red_tip_recurring_events'                         => __('Recurring events', 'ameliabooking'),
            'red_tip_services_categories_setup'                => __('Services & categories setup', 'ameliabooking'),
            'red_tip_services_setup'                           => __('Services setup', 'ameliabooking'),
            'red_tip_step_by_step_booking_form_guide'          => __('Step-by-step booking form guide', 'ameliabooking'),
            'red_tips_and_suggestions'                         => __('Tips & suggestions', 'ameliabooking'),
            'red_total_capacity'                               => __('Total capacity', 'ameliabooking'),
            'red_trainers'                                     => __('Trainers', 'ameliabooking'),
            'red_transaction'                                  => __('Transaction', 'ameliabooking'),
            'red_transaction_details'                          => __('Transaction details', 'ameliabooking'),
            'red_transaction_number_count'                     => __('Transaction #{count}', 'ameliabooking'),
            'red_transactions'                                 => __('Transactions', 'ameliabooking'),
            'red_try_adjusting_search'                         => __('Try adjusting your search to find what you are looking for.', 'ameliabooking'),
            'red_tue'                                          => __('Tue', 'ameliabooking'),
            'red_update_service_settings'                      => __('Update Service Settings', 'ameliabooking'),
            'red_updates'                                      => __('Updates', 'ameliabooking'),
            'red_upgrade'                                      => __('Upgrade', 'ameliabooking'),
            'red_upload_avatar'                                => __('Upload image', 'ameliabooking'),
            'red_upload'                                       => __('Upload', 'ameliabooking'),
            'red_videos'                                       => __('Videos', 'ameliabooking'),
            'red_view_booking'                                 => __('View booking', 'ameliabooking'),
            'red_view_invoice'                                 => __('View invoice', 'ameliabooking'),
            'red_watch_tutorials'                              => __('Video tutorials', 'ameliabooking'),
            'red_web'                                          => __('Web', 'ameliabooking'),
            'red_webhooks'                                     => __('Webhooks', 'ameliabooking'),
            'red_wed'                                          => __('Wed', 'ameliabooking'),
            'red_wellness'                                     => __('Wellness', 'ameliabooking'),
            'red_whatsapp'                                     => __('WhatsApp', 'ameliabooking'),
            'red_working_hours'                                => __('Working hours', 'ameliabooking'),
            'red_yoga'                                         => __('Yoga', 'ameliabooking'),
            'top_trends'                                       => __('Top trends', 'ameliabooking'),
            'red_no_customers_title'                           => __('No customers yet', 'ameliabooking'),
            'red_no_customers_subtitle_1'                      => __('Once you start receiving bookings, your customers will be displayed here. You can also get started by clicking the Add button below.', 'ameliabooking'),
            'red_tip_customer_setup'                           => __('Customer setup', 'ameliabooking'),
            'red_how_to'                                       => __('How to', 'ameliabooking'),
            'red_packages_locked_heading'                      => __('Boost revenue with bundled service packages', 'ameliabooking'),
            'red_packages_locked_description'                  => __('Turn your services into high-value packages that customers love. Combine multiple appointments into a single, discounted offer that drives bigger, more confident purchases.', 'ameliabooking'),
            'red_packages_feature_1'                           => __('Increase sales volume by encouraging customers to book more appointments at once', 'ameliabooking'),
            'red_packages_feature_2'                           => __('Flexible pricing lets you set a fixed package price and offer attractive discounts', 'ameliabooking'),
            'red_packages_feature_3'                           => __('Improved customer retention as clients return to use the remaining sessions in their package', 'ameliabooking'),
            'red_resources_locked_heading'                     => __('Manage shared resources with ease', 'ameliabooking'),
            'red_resources_locked_description'                 => __('Create rooms, equipment, or other resources that can be shared across employees, services, or locations, ensuring customers only see time slots when everything they need is truly available.', 'ameliabooking'),
            'red_resources_feature_1'                          => __('Avoid double-booking by automatically coordinating shared rooms, equipment, or tools', 'ameliabooking'),
            'red_resources_feature_2'                          => __('Streamline operations with one central place to manage all resources across your business', 'ameliabooking'),
            'red_resources_feature_3'                          => __('Deliver a smoother booking experience by showing customers only real, available time slots', 'ameliabooking'),
            'red_extras_locked_heading'                        => __('Boost revenue with valuable extras', 'ameliabooking'),
            'red_extras_locked_description'                    => __('Offer optional or mandatory extras during the booking process - upsell additional services, products, or experiences to enhance appointments and delight your customers.', 'ameliabooking'),
            'red_extras_feature_1'                             => __('Increase revenue by encouraging customers to purchase additional services or products', 'ameliabooking'),
            'red_extras_feature_2'                             => __('Customize offerings to match specific services and meet diverse client needs', 'ameliabooking'),
            'red_extras_feature_3'                             => __('Enhance the customer experience with tailored add-ons that add convenience and value', 'ameliabooking'),
            'red_locations_locked_heading'                     => __('Effortless management for every location', 'ameliabooking'),
            'red_locations_locked_description'                 => __('Easily organize multiple business locations in one place, ensuring smooth operations and a consistent booking experience no matter where your services are offered.', 'ameliabooking'),
            'red_locations_feature_1'                          => __('Centralize scheduling across all branches for clearer, simpler management', 'ameliabooking'),
            'red_locations_feature_2'                          => __('Improve customer experience by letting clients choose the location that suits them best', 'ameliabooking'),
            'red_locations_feature_3'                          => __('Keep operations aligned with unified settings, availability, and resource control', 'ameliabooking'),
            'red_custom_fields_locked_heading'                 => __('Collect the information your business truly needs', 'ameliabooking'),
            'red_custom_fields_locked_description'             => __('Build tailored forms across services, events, and customer profiles using custom fields. Capture exactly the details you need with checkboxes, text areas, and more, turning every booking and registration into a powerful intake process.', 'ameliabooking'),
            'red_custom_fields_feature_1'                      => __('Customize every interaction by gathering the right information for services, events, and customer records', 'ameliabooking'),
            'red_custom_fields_feature_2'                      => __('Keep your data organized and meaningful with structured fields that standardize the information you collect', 'ameliabooking'),
            'red_custom_fields_feature_3'                      => __('Enhance the customer experience with clear, intuitive forms designed around your business needs', 'ameliabooking'),
            'red_invoices_locked_heading'                      => __('Automated invoices for a smoother payment experience', 'ameliabooking'),
            'red_invoices_locked_description'                  => __('Automatically generate invoices for every booking, making payments easier, more transparent, and fully streamlined for both you and your clients.', 'ameliabooking'),
            'red_invoices_feature_1'                           => __('Save time and reduce manual work with instant, auto-generated invoices', 'ameliabooking'),
            'red_invoices_feature_2'                           => __('Improve accuracy and professionalism with consistent, clearly formatted billing', 'ameliabooking'),
            'red_invoices_feature_3'                           => __('Enhance client trust by providing transparent, documented payment details for every booking', 'ameliabooking'),
            'red_coupons_locked_heading'                       => __('Drive bookings with irresistible coupon offers', 'ameliabooking'),
            'red_coupons_locked_description'                   => __('Create unique coupon codes that customers can redeem during booking-offer discounts or even free appointments to boost engagement, satisfaction, and sales.', 'ameliabooking'),
            'red_coupons_feature_1'                            => __('Increase conversions by motivating customers with attractive, limited-time deals', 'ameliabooking'),
            'red_coupons_feature_2'                            => __('Flexible discount options let you set custom values or offer full-price waivers', 'ameliabooking'),
            'red_coupons_feature_3'                            => __('Enhance customer loyalty by rewarding clients with exclusive, personalized offers', 'ameliabooking'),
            'red_taxes_locked_heading'                         => __('Effortless tax management for every booking', 'ameliabooking'),
            'red_taxes_locked_description'                     => __('Automatically calculate and apply taxes to your services and events, ensuring accurate billing and hassle-free compliance with every transaction.', 'ameliabooking'),
            'red_taxes_feature_1'                              => __('Eliminate manual calculations with smart, automated tax application', 'ameliabooking'),
            'red_taxes_feature_2'                              => __('Ensure accurate billing by applying the correct tax rates every time', 'ameliabooking'),
            'red_taxes_feature_3'                              => __('Stay compliant with ease through consistent, reliable tax handling across your business', 'ameliabooking'),
            'red_whatsapp_locked_heading'                      => __('Stay connected with WhatsApp notifications', 'ameliabooking'),
            'red_whatsapp_locked_description'                  => __('Keep customers and employees informed by sending appointment and event notifications directly through WhatsApp - choose predefined messages or customize your own for a personal touch.', 'ameliabooking'),
            'red_whatsapp_feature_1'                           => __('Boost engagement by reaching clients instantly on a platform they use every day', 'ameliabooking'),
            'red_whatsapp_feature_2'                           => __('Reduce no-shows with timely reminders sent automatically', 'ameliabooking'),
            'red_whatsapp_feature_3'                           => __('Simplify communication with customizable messages for both customers and employees', 'ameliabooking'),
            'red_recurring_events_locked_heading'              => __('Simplify scheduling with recurring events', 'ameliabooking'),
            'red_recurring_events_locked_description'          => __('Effortlessly set up and manage events that repeat on your preferred schedule-offering flexibility, consistency, and a smooth experience for both your business and your customers.', 'ameliabooking'),
            'red_recurring_events_feature_1'                   => __('Save time by automating repeating events instead of creating them manually', 'ameliabooking'),
            'red_recurring_events_feature_2'                   => __('Maintain consistent scheduling with customizable frequencies and patterns', 'ameliabooking'),
            'red_recurring_events_feature_3'                   => __('Improve customer convenience by offering predictable, easy-to-book recurring options', 'ameliabooking'),
            'red_employee_integrations_locked_heading'         => __('Empower your team with seamless integrations', 'ameliabooking'),
            'red_employee_integrations_locked_description'     => __('Connect employee calendars, meeting tools, and other integrations to keep schedules perfectly synced and communication effortless across your entire team.', 'ameliabooking'),
            'red_employee_integrations_feature_1'              => __('Prevent scheduling conflicts with real-time calendar syncing for every employee.', 'ameliabooking'),
            'red_employee_integrations_feature_2'              => __('Streamline virtual meetings by integrating popular meeting platforms directly into bookings.', 'ameliabooking'),
            'red_employee_integrations_feature_3'              => __('Boost team productivity with automated updates and fewer manual tasks.', 'ameliabooking'),
            'red_employee_note_updated'                        => __('Employee note has been updated.', 'ameliabooking'),
            'red_customer_note_updated'                        => __('Customer note has been updated.', 'ameliabooking'),
            'red_need_to_update_company_days_off'             => __('Need to update your company\'s days off?', 'ameliabooking'),
            'red_manage_company_days_off'                     => __('Manage company days off', 'ameliabooking'),
            'red_learn_more'                                   => __('Learn more', 'ameliabooking'),
            'red_no_employees_yet'                             => __('No employees yet', 'ameliabooking'),
            'red_no_employees_subtitle_1'                      => __('Once you add your first employee, it will appear here. Click + Employee below to get started.', 'ameliabooking'),
            'red_attendees_search_placeholder'                 => __('Search attendees', 'ameliabooking'),
            'red_total_payments'                               => __('Total payments', 'ameliabooking'),
            'red_event_booking_closes_at'                      => __('Closes at', 'ameliabooking'),
            'red_booking_source'                               => __('Booking source', 'ameliabooking'),
            'red_edit_event_booking'                           => __('Edit event booking', 'ameliabooking'),
            'red_availability'                                 => __('Availability', 'ameliabooking'),
            'red_employee_details'                             => __('Employee details', 'ameliabooking'),
            'red_show_more_count'                              => __('Show more ({count})', 'ameliabooking'),
            'red_actions'                                      => __('Actions', 'ameliabooking'),
            'red_tip_employee_setup'                           => __('Employee setup', 'ameliabooking'),
            'red_tip_managing_assigned_services'               => __('Managing assigned services', 'ameliabooking'),
            'red_tip_special_days_setup'                       => __('Special days setup', 'ameliabooking'),
            'red_tip_setting_up_days_off'                      => __('Setting up days off', 'ameliabooking'),
            'red_tip_employee_badges_management'               => __('Employee badges management', 'ameliabooking'),
            'red_tip_google_meet_setup'                        => __('Google Meet setup', 'ameliabooking'),
            'red_tip_work_hours_setup'                         => __('Work hours setup', 'ameliabooking'),
            'red_all_assigned_services'                        => __('All assigned services', 'ameliabooking'),
            'red_default_location'                             => __('Default location', 'ameliabooking'),
            'red_tip_zoom_setup'                               => __('Zoom setup', 'ameliabooking'),
            'red_tip_front_end_employee_panel'                 => __('Front-end employee panel', 'ameliabooking'),
            'red_tip_roles_settings'                           => __('Roles settings', 'ameliabooking'),
            'red_hide_service'                                 => __('Hide service', 'ameliabooking'),
            'red_duplicate_service'                            => __('Duplicate service', 'ameliabooking'),
            'red_duplicate_category'                           => __('Duplicate category', 'ameliabooking'),
            'red_delete_category_effect_future'                => __('Could not delete category. This category has services with {count} future appointment. | Could not delete category. This category has services with {count} future appointments.', 'ameliabooking'),
            'red_delete_category_effect_past'                  => __('This category has services with {count} past appointment. | This category has services with {count} past appointments.', 'ameliabooking'),
            'red_delete_service_effect_future'                 => __('Could not delete service. This service has {count} appointment in the future. | Could not delete service. This service has {count} appointments in the future.', 'ameliabooking'),
            'red_hide_employee'                                => __('Hide employee', 'ameliabooking'),
            'red_show_employee'                                => __('Show employee', 'ameliabooking'),
            'red_delete_customer'                              => __('Delete customer', 'ameliabooking'),
            'red_delete_employee'                              => __('Delete employee', 'ameliabooking'),
            'red_delete_user_effect_future'                    => __('Could not delete user. This user has {count} appointment in the future. | Could not delete user. This user has {count} appointments in the future.', 'ameliabooking'),
            'red_block_customer'                               => __('Block customer', 'ameliabooking'),
            'red_unblock_customer'                             => __('Unblock customer', 'ameliabooking'),
            'red_hide_event'                                   => __('Hide event', 'ameliabooking'),
            'red_hide_event_subtitle'                          => __('Are you sure you want to hide this event?', 'ameliabooking'),
            'red_event_cancel_delete'                          => __('Are you sure you want to cancel and delete this event?', 'ameliabooking'),
            'red_confirm_delete_event_booking'                 => __('Are you sure you want to delete this event booking?', 'ameliabooking'),
            'red_notification_status_updated'                  => __('Notification status has been updated.', 'ameliabooking'),
            'red_notification_status_failed'                   => __('Notification status has not been updated.', 'ameliabooking'),
            'red_draft'                                        => __('Draft', 'ameliabooking'),
            'red_customers_deleted_success'                    => __('{count} customer deleted. | {count} customers deleted.', 'ameliabooking'),
            'red_event_hidden'                                 => __('Event has been hidden.', 'ameliabooking'),
            'red_event_visible'                                => __('Event is now visible.', 'ameliabooking'),
            'red_customer_details'                             => __('Customer details', 'ameliabooking'),
            'red_last_on'                                      => __('Last on {date}', 'ameliabooking'),
            'red_customers_deleted_error'                      => __('{count} customer could not be deleted due to future bookings. | {count} customers could not be deleted due to future bookings.', 'ameliabooking'),
            'red_customer_updated_success'                     => __('Customer has been updated.', 'ameliabooking'),
            'red_watch_on_youtube'                             => __('Watch on YouTube', 'ameliabooking'),
            'red_repeat_every_year'                            => __('Repeat every year', 'ameliabooking'),
            'red_edit_work_hours'                              => __('Edit work hours', 'ameliabooking'),
            'red_edit_day_off'                                 => __('Edit day off', 'ameliabooking'),
            'red_hide_tips_and_suggestions'                    => __('Hide tips & suggestions', 'ameliabooking'), // Used in Redesign | Update
            'red_export_appointments_locked_title'             => __('Export appointment data with ease', 'ameliabooking'),
            'red_export_appointments_locked_description'       => __('Quickly download all appointment details from the Bookings page, making reporting, analysis, and record-keeping simple and efficient.', 'ameliabooking'),
            'red_export_appointments_locked_feature_1'         => __('Save time with fast, one-click appointment exports', 'ameliabooking'),
            'red_export_appointments_locked_feature_2'         => __('Improve reporting accuracy by accessing complete appointment data instantly', 'ameliabooking'),
            'red_export_appointments_locked_feature_3'         => __('Stay organized with export files ready for analysis or external tools', 'ameliabooking'),
            'red_export_customers_locked_title'                => __('Easily export your customer data in one click', 'ameliabooking'),
            'red_export_customers_locked_description'          => __('Download your customer list instantly for reporting, marketing, or external system use, making data management faster and more convenient than ever.', 'ameliabooking'),
            'red_export_customers_locked_feature_1'            => __('Save time with quick, hassle-free customer data exports', 'ameliabooking'),
            'red_export_customers_locked_feature_2'            => __('Support deeper insights by using exported data for analysis and reporting', 'ameliabooking'),
            'red_export_customers_locked_feature_3'            => __('Enhance flexibility with customer information ready for marketing tools or external platforms', 'ameliabooking'),
            'red_custom_notifications_locked_title'            => __('Send smart, personalized notifications your way', 'ameliabooking'),
            'red_custom_notifications_locked_description'      => __('Create custom notifications that trigger based on booking status or schedule reminders, keeping customers and employees informed at exactly the right time.', 'ameliabooking'),
            'red_custom_notifications_locked_feature_1'        => __('Automate communication with notifications triggered by booking status, time, or custom rules', 'ameliabooking'),
            'red_custom_notifications_locked_feature_2'        => __('Keep everyone on track using scheduled reminders that reduce no-shows and confusion', 'ameliabooking'),
            'red_custom_notifications_locked_feature_3'        => __('Deliver personalized messages tailored to your business tone, branding, and workflow', 'ameliabooking'),
            'red_export_payments_locked_title'                 => __('Access your financial data in seconds', 'ameliabooking'),
            'red_export_payments_locked_description'           => __('Export all transaction records from the Finance page for effortless accounting, reconciliation, or sharing with your finance tools.', 'ameliabooking'),
            'red_export_payments_locked_feature_1'             => __('Simplify financial management with easy, one-click transaction exports', 'ameliabooking'),
            'red_export_payments_locked_feature_2'             => __('Ensure accurate bookkeeping with clear, organized financial data', 'ameliabooking'),
            'red_export_payments_locked_feature_3'             => __('Support external workflows by seamlessly moving financial records into other systems', 'ameliabooking'),
            'red_multiple_employees_locked_title'              => __('Grow your team with unlimited employee management', 'ameliabooking'),
            'red_multiple_employees_locked_description'        => __('Add multiple employees to your booking system, manage their schedules, and assign them to services or events, making it easy to scale your business and coordinate your team.', 'ameliabooking'),
            'red_multiple_employees_locked_feature_1'          => __('Expand your capacity by adding as many employees as your business needs', 'ameliabooking'),
            'red_multiple_employees_locked_feature_2'          => __('Simplify scheduling with individual availability, working hours, and assignments', 'ameliabooking'),
            'red_multiple_employees_locked_feature_3'          => __('Improve customer choice by letting clients book with the employee that suits them best', 'ameliabooking'),
            'red_notification'                                 => __('Notification', 'ameliabooking'),
            'red_confirm_delete_event'                         => __('Are you sure you want to delete this event?', 'ameliabooking'),
            'red_delete_category'                              => __('Delete category', 'ameliabooking'),
            'red_delete_service'                               => __('Delete service', 'ameliabooking'),
            'red_configuration'                                => __('Configuration', 'ameliabooking'),
            'red_delete_user_effect_past'                      => __('This user has {count} appointment in the past. | This user has {count} appointments in the past.', 'ameliabooking'),
            'red_delete_user_event_effect_future'              => __('This user is an attendee in future event. Are you sure you want to delete this user? | This user is an attendee in future events. Are you sure you want to delete this user?', 'ameliabooking'),
            'red_no_wp_users_with_amelia_employee_role'        => __('No WordPress users with the Amelia Employee role are available.', 'ameliabooking'),
            'red_set_up'                                       => __('Set up', 'ameliabooking'),
            'red_disable'                                      => __('Disable', 'ameliabooking'),
            'enter_email_then_press_enter_to_add'              => __('Enter email, then press Enter to add', 'ameliabooking'),
            'payment_links_warning'                            => __('This option requires adding the payment link placeholder to your message templates.', 'ameliabooking'), // Used in Redesign | Updated
            'payment_links_redirect'                           => __('Redirect URL after payment', 'ameliabooking'), // Used in Redesign | Updated
            'payment_links_redirect_tooltip'                   => __('Customers will be redirected to this URL after they complete their payment.', 'ameliabooking'), // Used in Redesign | Updated
            'basic'                                            => __('Basic', 'ameliabooking'),
            'advanced'                                         => __('Advanced', 'ameliabooking'),
            'field_options'                                    => __('Options', 'ameliabooking'), // Used in Redesign
            'field_order'                                      => __('Field order', 'ameliabooking'), // Used in Redesign
            'button'                                           => __('Button', 'ameliabooking'), // Used in Redesign
            'language'                                         => __('Language', 'ameliabooking'), // Used in Redesign
            'go_to_sbs_form'                                   => __('Go to Step-by-step form', 'ameliabooking'), // Used in Redesign
            'go_to_cat_form'                                   => __('Go to Catalog form', 'ameliabooking'), // Used in Redesign
            'redirect'                                         => __('Redirect', 'ameliabooking'), // Used in Redesign
            'save_data_on_redirect'                            => __('Your data will be saved before redirecting to another form.', 'ameliabooking'), // Used in Redesign
            'steps_order'                                      => __('Steps order', 'ameliabooking'), // Used in Redesign
            'labels'                                           => __('Labels', 'ameliabooking'), // Used in Redesign
            'forms_picker'                                     => __('Forms', 'ameliabooking'), // Used in Redesign
            'accent'                                           => __('Accent', 'ameliabooking'), // Used in Redesign
            'accent_text'                                      => __('Accent text', 'ameliabooking'), // Used in Redesign
            'secondary'                                        => __('Secondary', 'ameliabooking'), // Used in Redesign
            'secondary_text'                                   => __('Secondary text', 'ameliabooking'), // Used in Redesign
            'body_text'                                        => __('Body text', 'ameliabooking'), // Used in Redesign
            'publish'                                          => __('Publish', 'ameliabooking'),
            'red_employee_added_success'                       => __('Employee has been created.', 'ameliabooking'),
            'red_employee_updated_success'                     => __('Employee has been updated.', 'ameliabooking'),
            'employee_deleted'                                 => __('Employee has been deleted.', 'ameliabooking'), // Used in Redesign | Updated
            'red_update'                                       => __('Update', 'ameliabooking'),
            'background'                                       => __('Background', 'ameliabooking'), // Used in Redesign
            'outline'                                          => __('Outline', 'ameliabooking'), // Used in Redesign
            'placeholder_text'                                 => __('Placeholder text', 'ameliabooking'), // Used in Redesign
            'available_date_background'                        => __('Available date background', 'ameliabooking'), // Used in Redesign
            'available_date_text'                              => __('Available date text', 'ameliabooking'), // Used in Redesign
            'selected_date_background'                         => __('Selected date background', 'ameliabooking'), // Used in Redesign
            'selected_date_text'                               => __('Selected date text', 'ameliabooking'), // Used in Redesign
            'unavailable_date_background'                      => __('Unavailable date background', 'ameliabooking'), // Used in Redesign
            'unavailable_date_text'                            => __('Unavailable date text', 'ameliabooking'),
            'employee_description'                             => __('Employee description popup', 'ameliabooking'),
            'content_area'                                     => __('Content area', 'ameliabooking'), // Used in Redesign
            'filters'                                          => __('Filters', 'ameliabooking'),
            'red_categories_positions_failed'                  => __('Failed to update category positions.', 'ameliabooking'),
            'red_category_added_success'                       => __('Category has been created.', 'ameliabooking'),
            'red_category_updated_success'                     => __('Category has been updated.', 'ameliabooking'),
            'red_customer_added_success'                       => __('Customer has been created.', 'ameliabooking'),
            'red_event_booking_updated_success'                => __('Event booking has been updated.', 'ameliabooking'),
            'red_event_created_success'                        => __('Event has been created.', 'ameliabooking'),
            'red_event_updated_success'                        => __('Event has been updated.', 'ameliabooking'),
            'red_event_booking_created_success'                => __('Event booking has been created.', 'ameliabooking'),
            'red_service_added_success'                        => __('Service has been added.', 'ameliabooking'),
            'csb_events_calendar'                              => __('Events calendar', 'ameliabooking'),
            'csb_event_tickets'                                => __('Event tickets', 'ameliabooking'),
            'upcoming_events_block'                            => __('Upcoming events section', 'ameliabooking'),
            'step_search'                                      => __('Search', 'ameliabooking'),
            'customer_panel_btn'                               => __('\'Customer panel\' button style', 'ameliabooking'),
            'step_heading'                                     => __('Step heading', 'ameliabooking'),
            'event_today'                                      => __('Today', 'ameliabooking'),
            'event_no_spots'                                   => __('No spots left', 'ameliabooking'),
            'evt_empty_message'                                => __('There are no upcoming events for this period', 'ameliabooking'),
            'taxes'                                            => __('Taxes', 'ameliabooking'), // Used in Redesign
            'title_text'                                       => __('Title text', 'ameliabooking'), // Used in Redesign
            'info_text'                                        => __('Info text', 'ameliabooking'), // Used in Redesign
            'primary_button_type'                              => __('Primary button style', 'ameliabooking'),
            'secondary_button_type'                            => __('Secondary button style', 'ameliabooking'),
            'font_family'                                      => __('Font family', 'ameliabooking'),
        ];
    }
}
