<?php

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Get a complete list of all plugin options to delete
$options = array(
    // API settings
    'altomatic_api_key',

    // General settings
    'altomatic_auto_optimize',
    'altomatic_auto_generate_alt',
    'altomatic_seo_keywords',
    'altomatic_format_on_upload',
    'altomatic_format_conversion',

    // Alt text settings
    'altomatic_alt_text_max_length',

    // Image sizes
    'altomatic_image_sizes',

    // Stats
    'altomatic_total_optimized',
    'altomatic_total_bytes_saved',
    'altomatic_average_reduction'
);

// Delete all options
foreach ($options as $option) {
    delete_option($option);
    // Also delete the transient version if it exists
    delete_transient($option . '_transient');
}

// Get and delete all options with altomatic prefix
$all_options = wp_load_alloptions();
foreach ($all_options as $option => $value) {
    if (strpos($option, '_altomatic_') !== false || strpos($option, 'altomatic_') !== false) {
        delete_option($option);
    }
}

// Get all attachment IDs
$args = array(
    'post_type' => 'attachment',
    'posts_per_page' => -1,
    'fields' => 'ids'
);
$attachments = get_posts($args);

// Delete all Altomatic meta for these attachments
$meta_keys = array(
    '_altomatic_status',
    '_altomatic_original_size',
    '_altomatic_optimized_size',
    '_altomatic_date',
    '_altomatic_error',
    '_altomatic_error_time',
    '_altomatic_backup_path',
    '_altomatic_webp_attachment_id',
    '_altomatic_original_attachment_id',
    '_altomatic_size_data',
    '_altomatic_bytes_saved',
    '_altomatic_percent_saved',
    '_altomatic_api_image_id',
    '_altomatic_alt_generated'
);

foreach ($attachments as $attachment_id) {
    foreach ($meta_keys as $meta_key) {
        delete_post_meta($attachment_id, $meta_key);
    }
    // Delete any size data meta keys
    delete_post_meta_by_key('_altomatic_size_data_' . $attachment_id);
}

// Remove all scheduled events
wp_clear_scheduled_hook('altomatic_cleanup_failed');
wp_clear_scheduled_hook('altomatic_cron_optimization');
wp_clear_scheduled_hook('altomatic_process_image_size');
wp_clear_scheduled_hook('altomatic_generate_alt_text');

// Delete backup directory if it exists
$upload_dir = wp_upload_dir();
$backup_dir = $upload_dir['basedir'] . '/altomatic-backups';

// Initialize WP_Filesystem
require_once ABSPATH . 'wp-admin/includes/file.php';
WP_Filesystem();
global $wp_filesystem;

if ($wp_filesystem->is_dir($backup_dir)) {
    // Delete all files in the directory
    $wp_filesystem->delete($backup_dir, true);
}
